use reqwest::header::CONTENT_TYPE;
use serde::Deserialize;
use std::time::Duration;
use time::{Time, UtcOffset};

const QUERY: &str = r#"{
  "action": "findCards",
  "version": 6,
  "params": {"query": "prop:due=0"}
}"#;

#[derive(Deserialize, Debug)]
struct ApiResponse {
    result: Vec<u64>,
}

fn class() -> &'static str {
    let morning = Time::from_hms(0, 0, 0).unwrap();
    let night = Time::from_hms(19, 0, 0).unwrap();
    let now = time::OffsetDateTime::now_utc()
        .to_offset(UtcOffset::from_hms(9, 0, 0).unwrap())
        .time();
    if now < morning {
        "MP"
    } else if now > night {
        "HP"
    } else {
        ""
    }
}

fn main() {
    let client = reqwest::blocking::Client::new();
    loop {
        let res: Option<ApiResponse> = client
            .post("http://localhost:8765")
            .body(QUERY)
            .header(CONTENT_TYPE, "application/json")
            .send()
            .and_then(|res| res.json())
            .ok();
        let int = match res.map(|r| r.result.len()) {
            Some(0) | None => {
                println!();
                600
            }
            Some(len) => {
                println!(r#"{{"text": "{}", "class": "{}"}}"#, len, class());
                10
            }
        };
        std::thread::sleep(Duration::from_secs(int));
    }
}
