#![allow(
    non_snake_case,
    non_upper_case_globals,
    non_camel_case_types,
    deref_nullptr,
    clippy::too_many_arguments
)]
/* automatically generated by rust-bindgen 0.58.1 */
/* modified by AlexApps99 to remove useless stuff */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}

pub const RDRAM_MAX_SIZE: u32 = 8388608;
pub const PARALLEL_MAX_WORKERS: u32 = 64;
pub const M64P_MEM_INVALID: u32 = 4294967295;
pub const BREAKPOINTS_MAX_NUMBER: u32 = 128;
pub const PLUGIN_NONE: u32 = 1;
pub const PLUGIN_MEMPAK: u32 = 2;
pub const PLUGIN_RUMBLE_PAK: u32 = 3;
pub const PLUGIN_TRANSFER_PAK: u32 = 4;
pub const PLUGIN_RAW: u32 = 5;
pub const CORE_BASE_NAME: &[u8; 21usize] = b"angrylion's RDP Plus\0";
pub const CORE_NAME: &[u8; 21usize] = b"angrylion's RDP Plus\0";
pub const CORE_SIMPLE_NAME: &[u8; 15usize] = b"angrylion-plus\0";
extern "C" {
    pub fn msg_error(err: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn msg_warning(err: *const ::std::os::raw::c_char, ...);
}
extern "C" {
    pub fn msg_debug(err: *const ::std::os::raw::c_char, ...);
}
pub const dp_register_DP_START: dp_register = 0;
pub const dp_register_DP_END: dp_register = 1;
pub const dp_register_DP_CURRENT: dp_register = 2;
pub const dp_register_DP_STATUS: dp_register = 3;
pub const dp_register_DP_CLOCK: dp_register = 4;
pub const dp_register_DP_BUFBUSY: dp_register = 5;
pub const dp_register_DP_PIPEBUSY: dp_register = 6;
pub const dp_register_DP_TMEM: dp_register = 7;
pub const dp_register_DP_NUM_REG: dp_register = 8;
pub type dp_register = ::std::os::raw::c_uint;
pub const vi_register_VI_STATUS: vi_register = 0;
pub const vi_register_VI_ORIGIN: vi_register = 1;
pub const vi_register_VI_WIDTH: vi_register = 2;
pub const vi_register_VI_INTR: vi_register = 3;
pub const vi_register_VI_V_CURRENT_LINE: vi_register = 4;
pub const vi_register_VI_TIMING: vi_register = 5;
pub const vi_register_VI_V_SYNC: vi_register = 6;
pub const vi_register_VI_H_SYNC: vi_register = 7;
pub const vi_register_VI_LEAP: vi_register = 8;
pub const vi_register_VI_H_START: vi_register = 9;
pub const vi_register_VI_V_START: vi_register = 10;
pub const vi_register_VI_V_BURST: vi_register = 11;
pub const vi_register_VI_X_SCALE: vi_register = 12;
pub const vi_register_VI_Y_SCALE: vi_register = 13;
pub const vi_register_VI_NUM_REG: vi_register = 14;
pub type vi_register = ::std::os::raw::c_uint;
pub const vi_mode_VI_MODE_NORMAL: vi_mode = 0;
pub const vi_mode_VI_MODE_COLOR: vi_mode = 1;
pub const vi_mode_VI_MODE_DEPTH: vi_mode = 2;
pub const vi_mode_VI_MODE_COVERAGE: vi_mode = 3;
pub const vi_mode_VI_MODE_NUM: vi_mode = 4;
pub type vi_mode = ::std::os::raw::c_uint;
pub const vi_interp_VI_INTERP_NEAREST: vi_interp = 0;
pub const vi_interp_VI_INTERP_LINEAR: vi_interp = 1;
pub const vi_interp_VI_INTERP_HYBRID: vi_interp = 2;
pub const vi_interp_VI_INTERP_NUM: vi_interp = 3;
pub type vi_interp = ::std::os::raw::c_uint;
pub const dp_compat_profile_DP_COMPAT_LOW: dp_compat_profile = 0;
pub const dp_compat_profile_DP_COMPAT_MEDIUM: dp_compat_profile = 1;
pub const dp_compat_profile_DP_COMPAT_HIGH: dp_compat_profile = 2;
pub const dp_compat_profile_DP_COMPAT_NUM: dp_compat_profile = 3;
pub type dp_compat_profile = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct n64video_pixel {
    pub r: u8,
    pub g: u8,
    pub b: u8,
    pub a: u8,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct n64video_frame_buffer {
    pub pixels: *mut n64video_pixel,
    pub width: u32,
    pub height: u32,
    pub height_out: u32,
    pub pitch: u32,
    pub valid: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct n64video_config {
    pub gfx: n64video_config__bindgen_ty_1,
    pub vi: n64video_config__bindgen_ty_2,
    pub dp: n64video_config__bindgen_ty_3,
    pub parallel: bool,
    pub busyloop: bool,
    pub num_workers: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct n64video_config__bindgen_ty_1 {
    pub rdram: *mut u8,
    pub rdram_size: u32,
    pub dmem: *mut u8,
    pub vi_reg: *mut *mut u32,
    pub dp_reg: *mut *mut u32,
    pub mi_intr_reg: *mut u32,
    pub mi_intr_cb: ::std::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct n64video_config__bindgen_ty_2 {
    pub mode: vi_mode,
    pub interp: vi_interp,
    pub widescreen: bool,
    pub hide_overscan: bool,
    pub vsync: bool,
    pub exclusive: bool,
    pub integer_scaling: bool,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct n64video_config__bindgen_ty_3 {
    pub compat: dp_compat_profile,
}
extern "C" {
    pub fn n64video_config_init(config: *mut n64video_config);
}
extern "C" {
    pub fn n64video_init(config: *mut n64video_config);
}
extern "C" {
    pub fn n64video_update_screen(fb: *mut n64video_frame_buffer);
}
extern "C" {
    pub fn n64video_process_list();
}
extern "C" {
    pub fn n64video_close();
}
extern "C" {
    pub fn parallel_init(num: u32, busy: bool);
}
extern "C" {
    pub fn parallel_run(task: ::std::option::Option<unsafe extern "C" fn(arg1: u32)>);
}
extern "C" {
    pub fn parallel_num_workers() -> u32;
}
extern "C" {
    pub fn parallel_close();
}
extern "C" {
    pub fn IntGetProcAddress(
        name: *const ::std::os::raw::c_char,
    ) -> ::std::option::Option<unsafe extern "C" fn()>;
}
extern "C" {
    pub fn screen_init(config: *mut n64video_config);
}
extern "C" {
    pub fn screen_adjust(
        width_out: i32,
        height_out: i32,
        width: *mut i32,
        height: *mut i32,
        x: *mut i32,
        y: *mut i32,
    );
}
extern "C" {
    pub fn screen_update();
}
extern "C" {
    pub fn screen_toggle_fullscreen();
}
extern "C" {
    pub fn screen_close();
}
extern "C" {
    pub fn vdac_init(config: *mut n64video_config);
}
extern "C" {
    pub fn vdac_read(fb: *mut n64video_frame_buffer, alpha: bool);
}
extern "C" {
    pub fn vdac_write(fb: *mut n64video_frame_buffer);
}
extern "C" {
    pub fn vdac_sync(invaid: bool);
}
extern "C" {
    pub fn vdac_close();
}
pub type m64p_dynlib_handle = *mut ::std::os::raw::c_void;
pub type m64p_handle = *mut ::std::os::raw::c_void;
pub type m64p_frame_callback =
    ::std::option::Option<unsafe extern "C" fn(FrameIndex: ::std::os::raw::c_uint)>;
pub type m64p_input_callback = ::std::option::Option<unsafe extern "C" fn()>;
pub type m64p_audio_callback = ::std::option::Option<unsafe extern "C" fn()>;
pub type m64p_vi_callback = ::std::option::Option<unsafe extern "C" fn()>;
pub const m64p_type_M64TYPE_INT: m64p_type = 1;
pub const m64p_type_M64TYPE_FLOAT: m64p_type = 2;
pub const m64p_type_M64TYPE_BOOL: m64p_type = 3;
pub const m64p_type_M64TYPE_STRING: m64p_type = 4;
pub type m64p_type = ::std::os::raw::c_uint;
pub const m64p_msg_level_M64MSG_ERROR: m64p_msg_level = 1;
pub const m64p_msg_level_M64MSG_WARNING: m64p_msg_level = 2;
pub const m64p_msg_level_M64MSG_INFO: m64p_msg_level = 3;
pub const m64p_msg_level_M64MSG_STATUS: m64p_msg_level = 4;
pub const m64p_msg_level_M64MSG_VERBOSE: m64p_msg_level = 5;
pub type m64p_msg_level = ::std::os::raw::c_uint;
pub const m64p_error_M64ERR_SUCCESS: m64p_error = 0;
pub const m64p_error_M64ERR_NOT_INIT: m64p_error = 1;
pub const m64p_error_M64ERR_ALREADY_INIT: m64p_error = 2;
pub const m64p_error_M64ERR_INCOMPATIBLE: m64p_error = 3;
pub const m64p_error_M64ERR_INPUT_ASSERT: m64p_error = 4;
pub const m64p_error_M64ERR_INPUT_INVALID: m64p_error = 5;
pub const m64p_error_M64ERR_INPUT_NOT_FOUND: m64p_error = 6;
pub const m64p_error_M64ERR_NO_MEMORY: m64p_error = 7;
pub const m64p_error_M64ERR_FILES: m64p_error = 8;
pub const m64p_error_M64ERR_INTERNAL: m64p_error = 9;
pub const m64p_error_M64ERR_INVALID_STATE: m64p_error = 10;
pub const m64p_error_M64ERR_PLUGIN_FAIL: m64p_error = 11;
pub const m64p_error_M64ERR_SYSTEM_FAIL: m64p_error = 12;
pub const m64p_error_M64ERR_UNSUPPORTED: m64p_error = 13;
pub const m64p_error_M64ERR_WRONG_TYPE: m64p_error = 14;
pub type m64p_error = ::std::os::raw::c_uint;
pub const m64p_core_caps_M64CAPS_DYNAREC: m64p_core_caps = 1;
pub const m64p_core_caps_M64CAPS_DEBUGGER: m64p_core_caps = 2;
pub const m64p_core_caps_M64CAPS_CORE_COMPARE: m64p_core_caps = 4;
pub type m64p_core_caps = ::std::os::raw::c_uint;
pub const m64p_plugin_type_M64PLUGIN_NULL: m64p_plugin_type = 0;
pub const m64p_plugin_type_M64PLUGIN_RSP: m64p_plugin_type = 1;
pub const m64p_plugin_type_M64PLUGIN_GFX: m64p_plugin_type = 2;
pub const m64p_plugin_type_M64PLUGIN_AUDIO: m64p_plugin_type = 3;
pub const m64p_plugin_type_M64PLUGIN_INPUT: m64p_plugin_type = 4;
pub const m64p_plugin_type_M64PLUGIN_CORE: m64p_plugin_type = 5;
pub type m64p_plugin_type = ::std::os::raw::c_uint;
pub const m64p_emu_state_M64EMU_STOPPED: m64p_emu_state = 1;
pub const m64p_emu_state_M64EMU_RUNNING: m64p_emu_state = 2;
pub const m64p_emu_state_M64EMU_PAUSED: m64p_emu_state = 3;
pub type m64p_emu_state = ::std::os::raw::c_uint;
pub const m64p_video_mode_M64VIDEO_NONE: m64p_video_mode = 1;
pub const m64p_video_mode_M64VIDEO_WINDOWED: m64p_video_mode = 2;
pub const m64p_video_mode_M64VIDEO_FULLSCREEN: m64p_video_mode = 3;
pub type m64p_video_mode = ::std::os::raw::c_uint;
pub const m64p_video_flags_M64VIDEOFLAG_SUPPORT_RESIZING: m64p_video_flags = 1;
pub type m64p_video_flags = ::std::os::raw::c_uint;
pub const m64p_core_param_M64CORE_EMU_STATE: m64p_core_param = 1;
pub const m64p_core_param_M64CORE_VIDEO_MODE: m64p_core_param = 2;
pub const m64p_core_param_M64CORE_SAVESTATE_SLOT: m64p_core_param = 3;
pub const m64p_core_param_M64CORE_SPEED_FACTOR: m64p_core_param = 4;
pub const m64p_core_param_M64CORE_SPEED_LIMITER: m64p_core_param = 5;
pub const m64p_core_param_M64CORE_VIDEO_SIZE: m64p_core_param = 6;
pub const m64p_core_param_M64CORE_AUDIO_VOLUME: m64p_core_param = 7;
pub const m64p_core_param_M64CORE_AUDIO_MUTE: m64p_core_param = 8;
pub const m64p_core_param_M64CORE_INPUT_GAMESHARK: m64p_core_param = 9;
pub const m64p_core_param_M64CORE_STATE_LOADCOMPLETE: m64p_core_param = 10;
pub const m64p_core_param_M64CORE_STATE_SAVECOMPLETE: m64p_core_param = 11;
pub type m64p_core_param = ::std::os::raw::c_uint;
pub const m64p_command_M64CMD_NOP: m64p_command = 0;
pub const m64p_command_M64CMD_ROM_OPEN: m64p_command = 1;
pub const m64p_command_M64CMD_ROM_CLOSE: m64p_command = 2;
pub const m64p_command_M64CMD_ROM_GET_HEADER: m64p_command = 3;
pub const m64p_command_M64CMD_ROM_GET_SETTINGS: m64p_command = 4;
pub const m64p_command_M64CMD_EXECUTE: m64p_command = 5;
pub const m64p_command_M64CMD_STOP: m64p_command = 6;
pub const m64p_command_M64CMD_PAUSE: m64p_command = 7;
pub const m64p_command_M64CMD_RESUME: m64p_command = 8;
pub const m64p_command_M64CMD_CORE_STATE_QUERY: m64p_command = 9;
pub const m64p_command_M64CMD_STATE_LOAD: m64p_command = 10;
pub const m64p_command_M64CMD_STATE_SAVE: m64p_command = 11;
pub const m64p_command_M64CMD_STATE_SET_SLOT: m64p_command = 12;
pub const m64p_command_M64CMD_SEND_SDL_KEYDOWN: m64p_command = 13;
pub const m64p_command_M64CMD_SEND_SDL_KEYUP: m64p_command = 14;
pub const m64p_command_M64CMD_SET_FRAME_CALLBACK: m64p_command = 15;
pub const m64p_command_M64CMD_TAKE_NEXT_SCREENSHOT: m64p_command = 16;
pub const m64p_command_M64CMD_CORE_STATE_SET: m64p_command = 17;
pub const m64p_command_M64CMD_READ_SCREEN: m64p_command = 18;
pub const m64p_command_M64CMD_RESET: m64p_command = 19;
pub const m64p_command_M64CMD_ADVANCE_FRAME: m64p_command = 20;
pub type m64p_command = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m64p_cheat_code {
    pub address: u32,
    pub value: ::std::os::raw::c_int,
}
pub const m64p_system_type_SYSTEM_NTSC: m64p_system_type = 0;
pub const m64p_system_type_SYSTEM_PAL: m64p_system_type = 1;
pub const m64p_system_type_SYSTEM_MPAL: m64p_system_type = 2;
pub type m64p_system_type = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m64p_rom_header {
    pub init_PI_BSB_DOM1_LAT_REG: u8,
    pub init_PI_BSB_DOM1_PGS_REG: u8,
    pub init_PI_BSB_DOM1_PWD_REG: u8,
    pub init_PI_BSB_DOM1_PGS_REG2: u8,
    pub ClockRate: u32,
    pub PC: u32,
    pub Release: u32,
    pub CRC1: u32,
    pub CRC2: u32,
    pub Unknown: [u32; 2usize],
    pub Name: [u8; 20usize],
    pub unknown: u32,
    pub Manufacturer_ID: u32,
    pub Cartridge_ID: u16,
    pub Country_code: u16,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct m64p_rom_settings {
    pub goodname: [::std::os::raw::c_char; 256usize],
    pub MD5: [::std::os::raw::c_char; 33usize],
    pub savetype: ::std::os::raw::c_uchar,
    pub status: ::std::os::raw::c_uchar,
    pub players: ::std::os::raw::c_uchar,
    pub rumble: ::std::os::raw::c_uchar,
}
pub const m64p_dbg_state_M64P_DBG_RUN_STATE: m64p_dbg_state = 1;
pub const m64p_dbg_state_M64P_DBG_PREVIOUS_PC: m64p_dbg_state = 2;
pub const m64p_dbg_state_M64P_DBG_NUM_BREAKPOINTS: m64p_dbg_state = 3;
pub const m64p_dbg_state_M64P_DBG_CPU_DYNACORE: m64p_dbg_state = 4;
pub const m64p_dbg_state_M64P_DBG_CPU_NEXT_INTERRUPT: m64p_dbg_state = 5;
pub type m64p_dbg_state = ::std::os::raw::c_uint;
pub const m64p_dbg_runstate_M64P_DBG_RUNSTATE_PAUSED: m64p_dbg_runstate = 0;
pub const m64p_dbg_runstate_M64P_DBG_RUNSTATE_STEPPING: m64p_dbg_runstate = 1;
pub const m64p_dbg_runstate_M64P_DBG_RUNSTATE_RUNNING: m64p_dbg_runstate = 2;
pub type m64p_dbg_runstate = ::std::os::raw::c_uint;
pub const m64p_dbg_mem_info_M64P_DBG_MEM_TYPE: m64p_dbg_mem_info = 1;
pub const m64p_dbg_mem_info_M64P_DBG_MEM_FLAGS: m64p_dbg_mem_info = 2;
pub const m64p_dbg_mem_info_M64P_DBG_MEM_HAS_RECOMPILED: m64p_dbg_mem_info = 3;
pub const m64p_dbg_mem_info_M64P_DBG_MEM_NUM_RECOMPILED: m64p_dbg_mem_info = 4;
pub const m64p_dbg_mem_info_M64P_DBG_RECOMP_OPCODE: m64p_dbg_mem_info = 16;
pub const m64p_dbg_mem_info_M64P_DBG_RECOMP_ARGS: m64p_dbg_mem_info = 17;
pub const m64p_dbg_mem_info_M64P_DBG_RECOMP_ADDR: m64p_dbg_mem_info = 18;
pub type m64p_dbg_mem_info = ::std::os::raw::c_uint;
pub const m64p_dbg_mem_type_M64P_MEM_NOMEM: m64p_dbg_mem_type = 0;
pub const m64p_dbg_mem_type_M64P_MEM_NOTHING: m64p_dbg_mem_type = 1;
pub const m64p_dbg_mem_type_M64P_MEM_RDRAM: m64p_dbg_mem_type = 2;
pub const m64p_dbg_mem_type_M64P_MEM_RDRAMREG: m64p_dbg_mem_type = 3;
pub const m64p_dbg_mem_type_M64P_MEM_RSPMEM: m64p_dbg_mem_type = 4;
pub const m64p_dbg_mem_type_M64P_MEM_RSPREG: m64p_dbg_mem_type = 5;
pub const m64p_dbg_mem_type_M64P_MEM_RSP: m64p_dbg_mem_type = 6;
pub const m64p_dbg_mem_type_M64P_MEM_DP: m64p_dbg_mem_type = 7;
pub const m64p_dbg_mem_type_M64P_MEM_DPS: m64p_dbg_mem_type = 8;
pub const m64p_dbg_mem_type_M64P_MEM_VI: m64p_dbg_mem_type = 9;
pub const m64p_dbg_mem_type_M64P_MEM_AI: m64p_dbg_mem_type = 10;
pub const m64p_dbg_mem_type_M64P_MEM_PI: m64p_dbg_mem_type = 11;
pub const m64p_dbg_mem_type_M64P_MEM_RI: m64p_dbg_mem_type = 12;
pub const m64p_dbg_mem_type_M64P_MEM_SI: m64p_dbg_mem_type = 13;
pub const m64p_dbg_mem_type_M64P_MEM_FLASHRAMSTAT: m64p_dbg_mem_type = 14;
pub const m64p_dbg_mem_type_M64P_MEM_ROM: m64p_dbg_mem_type = 15;
pub const m64p_dbg_mem_type_M64P_MEM_PIF: m64p_dbg_mem_type = 16;
pub const m64p_dbg_mem_type_M64P_MEM_MI: m64p_dbg_mem_type = 17;
pub const m64p_dbg_mem_type_M64P_MEM_BREAKPOINT: m64p_dbg_mem_type = 18;
pub type m64p_dbg_mem_type = ::std::os::raw::c_uint;
pub const m64p_dbg_mem_flags_M64P_MEM_FLAG_READABLE: m64p_dbg_mem_flags = 1;
pub const m64p_dbg_mem_flags_M64P_MEM_FLAG_WRITABLE: m64p_dbg_mem_flags = 2;
pub const m64p_dbg_mem_flags_M64P_MEM_FLAG_READABLE_EMUONLY: m64p_dbg_mem_flags = 4;
pub const m64p_dbg_mem_flags_M64P_MEM_FLAG_WRITABLE_EMUONLY: m64p_dbg_mem_flags = 8;
pub type m64p_dbg_mem_flags = ::std::os::raw::c_uint;
pub const m64p_dbg_memptr_type_M64P_DBG_PTR_RDRAM: m64p_dbg_memptr_type = 1;
pub const m64p_dbg_memptr_type_M64P_DBG_PTR_PI_REG: m64p_dbg_memptr_type = 2;
pub const m64p_dbg_memptr_type_M64P_DBG_PTR_SI_REG: m64p_dbg_memptr_type = 3;
pub const m64p_dbg_memptr_type_M64P_DBG_PTR_VI_REG: m64p_dbg_memptr_type = 4;
pub const m64p_dbg_memptr_type_M64P_DBG_PTR_RI_REG: m64p_dbg_memptr_type = 5;
pub const m64p_dbg_memptr_type_M64P_DBG_PTR_AI_REG: m64p_dbg_memptr_type = 6;
pub type m64p_dbg_memptr_type = ::std::os::raw::c_uint;
pub const m64p_dbg_cpu_data_M64P_CPU_PC: m64p_dbg_cpu_data = 1;
pub const m64p_dbg_cpu_data_M64P_CPU_REG_REG: m64p_dbg_cpu_data = 2;
pub const m64p_dbg_cpu_data_M64P_CPU_REG_HI: m64p_dbg_cpu_data = 3;
pub const m64p_dbg_cpu_data_M64P_CPU_REG_LO: m64p_dbg_cpu_data = 4;
pub const m64p_dbg_cpu_data_M64P_CPU_REG_COP0: m64p_dbg_cpu_data = 5;
pub const m64p_dbg_cpu_data_M64P_CPU_REG_COP1_DOUBLE_PTR: m64p_dbg_cpu_data = 6;
pub const m64p_dbg_cpu_data_M64P_CPU_REG_COP1_SIMPLE_PTR: m64p_dbg_cpu_data = 7;
pub const m64p_dbg_cpu_data_M64P_CPU_REG_COP1_FGR_64: m64p_dbg_cpu_data = 8;
pub const m64p_dbg_cpu_data_M64P_CPU_TLB: m64p_dbg_cpu_data = 9;
pub type m64p_dbg_cpu_data = ::std::os::raw::c_uint;
pub const m64p_dbg_bkp_command_M64P_BKP_CMD_ADD_ADDR: m64p_dbg_bkp_command = 1;
pub const m64p_dbg_bkp_command_M64P_BKP_CMD_ADD_STRUCT: m64p_dbg_bkp_command = 2;
pub const m64p_dbg_bkp_command_M64P_BKP_CMD_REPLACE: m64p_dbg_bkp_command = 3;
pub const m64p_dbg_bkp_command_M64P_BKP_CMD_REMOVE_ADDR: m64p_dbg_bkp_command = 4;
pub const m64p_dbg_bkp_command_M64P_BKP_CMD_REMOVE_IDX: m64p_dbg_bkp_command = 5;
pub const m64p_dbg_bkp_command_M64P_BKP_CMD_ENABLE: m64p_dbg_bkp_command = 6;
pub const m64p_dbg_bkp_command_M64P_BKP_CMD_DISABLE: m64p_dbg_bkp_command = 7;
pub const m64p_dbg_bkp_command_M64P_BKP_CMD_CHECK: m64p_dbg_bkp_command = 8;
pub type m64p_dbg_bkp_command = ::std::os::raw::c_uint;
pub const m64p_dbg_bkp_flags_M64P_BKP_FLAG_ENABLED: m64p_dbg_bkp_flags = 1;
pub const m64p_dbg_bkp_flags_M64P_BKP_FLAG_READ: m64p_dbg_bkp_flags = 2;
pub const m64p_dbg_bkp_flags_M64P_BKP_FLAG_WRITE: m64p_dbg_bkp_flags = 4;
pub const m64p_dbg_bkp_flags_M64P_BKP_FLAG_EXEC: m64p_dbg_bkp_flags = 8;
pub const m64p_dbg_bkp_flags_M64P_BKP_FLAG_LOG: m64p_dbg_bkp_flags = 16;
pub type m64p_dbg_bkp_flags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m64p_breakpoint {
    pub address: u32,
    pub endaddr: u32,
    pub flags: ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m64p_2d_size {
    pub uiWidth: ::std::os::raw::c_uint,
    pub uiHeight: ::std::os::raw::c_uint,
}
pub const m64p_GLattr_M64P_GL_DOUBLEBUFFER: m64p_GLattr = 1;
pub const m64p_GLattr_M64P_GL_BUFFER_SIZE: m64p_GLattr = 2;
pub const m64p_GLattr_M64P_GL_DEPTH_SIZE: m64p_GLattr = 3;
pub const m64p_GLattr_M64P_GL_RED_SIZE: m64p_GLattr = 4;
pub const m64p_GLattr_M64P_GL_GREEN_SIZE: m64p_GLattr = 5;
pub const m64p_GLattr_M64P_GL_BLUE_SIZE: m64p_GLattr = 6;
pub const m64p_GLattr_M64P_GL_ALPHA_SIZE: m64p_GLattr = 7;
pub const m64p_GLattr_M64P_GL_SWAP_CONTROL: m64p_GLattr = 8;
pub const m64p_GLattr_M64P_GL_MULTISAMPLEBUFFERS: m64p_GLattr = 9;
pub const m64p_GLattr_M64P_GL_MULTISAMPLESAMPLES: m64p_GLattr = 10;
pub const m64p_GLattr_M64P_GL_CONTEXT_MAJOR_VERSION: m64p_GLattr = 11;
pub const m64p_GLattr_M64P_GL_CONTEXT_MINOR_VERSION: m64p_GLattr = 12;
pub const m64p_GLattr_M64P_GL_CONTEXT_PROFILE_MASK: m64p_GLattr = 13;
pub type m64p_GLattr = ::std::os::raw::c_uint;
pub const m64p_GLContextType_M64P_GL_CONTEXT_PROFILE_CORE: m64p_GLContextType = 0;
pub const m64p_GLContextType_M64P_GL_CONTEXT_PROFILE_COMPATIBILITY: m64p_GLContextType = 1;
pub const m64p_GLContextType_M64P_GL_CONTEXT_PROFILE_ES: m64p_GLContextType = 2;
pub type m64p_GLContextType = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct m64p_video_extension_functions {
    pub Functions: ::std::os::raw::c_uint,
    pub VidExtFuncInit: ::std::option::Option<unsafe extern "C" fn() -> m64p_error>,
    pub VidExtFuncQuit: ::std::option::Option<unsafe extern "C" fn() -> m64p_error>,
    pub VidExtFuncListModes: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut m64p_2d_size,
            arg2: *mut ::std::os::raw::c_int,
        ) -> m64p_error,
    >,
    pub VidExtFuncSetMode: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::os::raw::c_int,
            arg3: ::std::os::raw::c_int,
            arg4: ::std::os::raw::c_int,
            arg5: ::std::os::raw::c_int,
        ) -> m64p_error,
    >,
    pub VidExtFuncGLGetProc: ::std::option::Option<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void,
    >,
    pub VidExtFuncGLSetAttr: ::std::option::Option<
        unsafe extern "C" fn(arg1: m64p_GLattr, arg2: ::std::os::raw::c_int) -> m64p_error,
    >,
    pub VidExtFuncGLGetAttr: ::std::option::Option<
        unsafe extern "C" fn(arg1: m64p_GLattr, arg2: *mut ::std::os::raw::c_int) -> m64p_error,
    >,
    pub VidExtFuncGLSwapBuf: ::std::option::Option<unsafe extern "C" fn() -> m64p_error>,
    pub VidExtFuncSetCaption: ::std::option::Option<
        unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> m64p_error,
    >,
    pub VidExtFuncToggleFS: ::std::option::Option<unsafe extern "C" fn() -> m64p_error>,
    pub VidExtFuncResizeWindow: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: ::std::os::raw::c_int,
        ) -> m64p_error,
    >,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct RSP_INFO {
    pub RDRAM: *mut ::std::os::raw::c_uchar,
    pub DMEM: *mut ::std::os::raw::c_uchar,
    pub IMEM: *mut ::std::os::raw::c_uchar,
    pub MI_INTR_REG: *mut ::std::os::raw::c_uint,
    pub SP_MEM_ADDR_REG: *mut ::std::os::raw::c_uint,
    pub SP_DRAM_ADDR_REG: *mut ::std::os::raw::c_uint,
    pub SP_RD_LEN_REG: *mut ::std::os::raw::c_uint,
    pub SP_WR_LEN_REG: *mut ::std::os::raw::c_uint,
    pub SP_STATUS_REG: *mut ::std::os::raw::c_uint,
    pub SP_DMA_FULL_REG: *mut ::std::os::raw::c_uint,
    pub SP_DMA_BUSY_REG: *mut ::std::os::raw::c_uint,
    pub SP_PC_REG: *mut ::std::os::raw::c_uint,
    pub SP_SEMAPHORE_REG: *mut ::std::os::raw::c_uint,
    pub DPC_START_REG: *mut ::std::os::raw::c_uint,
    pub DPC_END_REG: *mut ::std::os::raw::c_uint,
    pub DPC_CURRENT_REG: *mut ::std::os::raw::c_uint,
    pub DPC_STATUS_REG: *mut ::std::os::raw::c_uint,
    pub DPC_CLOCK_REG: *mut ::std::os::raw::c_uint,
    pub DPC_BUFBUSY_REG: *mut ::std::os::raw::c_uint,
    pub DPC_PIPEBUSY_REG: *mut ::std::os::raw::c_uint,
    pub DPC_TMEM_REG: *mut ::std::os::raw::c_uint,
    pub CheckInterrupts: ::std::option::Option<unsafe extern "C" fn()>,
    pub ProcessDlistList: ::std::option::Option<unsafe extern "C" fn()>,
    pub ProcessAlistList: ::std::option::Option<unsafe extern "C" fn()>,
    pub ProcessRdpList: ::std::option::Option<unsafe extern "C" fn()>,
    pub ShowCFB: ::std::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct GFX_INFO {
    pub HEADER: *mut ::std::os::raw::c_uchar,
    pub RDRAM: *mut ::std::os::raw::c_uchar,
    pub DMEM: *mut ::std::os::raw::c_uchar,
    pub IMEM: *mut ::std::os::raw::c_uchar,
    pub MI_INTR_REG: *mut ::std::os::raw::c_uint,
    pub DPC_START_REG: *mut ::std::os::raw::c_uint,
    pub DPC_END_REG: *mut ::std::os::raw::c_uint,
    pub DPC_CURRENT_REG: *mut ::std::os::raw::c_uint,
    pub DPC_STATUS_REG: *mut ::std::os::raw::c_uint,
    pub DPC_CLOCK_REG: *mut ::std::os::raw::c_uint,
    pub DPC_BUFBUSY_REG: *mut ::std::os::raw::c_uint,
    pub DPC_PIPEBUSY_REG: *mut ::std::os::raw::c_uint,
    pub DPC_TMEM_REG: *mut ::std::os::raw::c_uint,
    pub VI_STATUS_REG: *mut ::std::os::raw::c_uint,
    pub VI_ORIGIN_REG: *mut ::std::os::raw::c_uint,
    pub VI_WIDTH_REG: *mut ::std::os::raw::c_uint,
    pub VI_INTR_REG: *mut ::std::os::raw::c_uint,
    pub VI_V_CURRENT_LINE_REG: *mut ::std::os::raw::c_uint,
    pub VI_TIMING_REG: *mut ::std::os::raw::c_uint,
    pub VI_V_SYNC_REG: *mut ::std::os::raw::c_uint,
    pub VI_H_SYNC_REG: *mut ::std::os::raw::c_uint,
    pub VI_LEAP_REG: *mut ::std::os::raw::c_uint,
    pub VI_H_START_REG: *mut ::std::os::raw::c_uint,
    pub VI_V_START_REG: *mut ::std::os::raw::c_uint,
    pub VI_V_BURST_REG: *mut ::std::os::raw::c_uint,
    pub VI_X_SCALE_REG: *mut ::std::os::raw::c_uint,
    pub VI_Y_SCALE_REG: *mut ::std::os::raw::c_uint,
    pub CheckInterrupts: ::std::option::Option<unsafe extern "C" fn()>,
    pub version: ::std::os::raw::c_uint,
    pub SP_STATUS_REG: *mut ::std::os::raw::c_uint,
    pub RDRAM_SIZE: *const ::std::os::raw::c_uint,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AUDIO_INFO {
    pub RDRAM: *mut ::std::os::raw::c_uchar,
    pub DMEM: *mut ::std::os::raw::c_uchar,
    pub IMEM: *mut ::std::os::raw::c_uchar,
    pub MI_INTR_REG: *mut ::std::os::raw::c_uint,
    pub AI_DRAM_ADDR_REG: *mut ::std::os::raw::c_uint,
    pub AI_LEN_REG: *mut ::std::os::raw::c_uint,
    pub AI_CONTROL_REG: *mut ::std::os::raw::c_uint,
    pub AI_STATUS_REG: *mut ::std::os::raw::c_uint,
    pub AI_DACRATE_REG: *mut ::std::os::raw::c_uint,
    pub AI_BITRATE_REG: *mut ::std::os::raw::c_uint,
    pub CheckInterrupts: ::std::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CONTROL {
    pub Present: ::std::os::raw::c_int,
    pub RawData: ::std::os::raw::c_int,
    pub Plugin: ::std::os::raw::c_int,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union BUTTONS {
    pub Value: ::std::os::raw::c_uint,
    pub __bindgen_anon_1: BUTTONS__bindgen_ty_1,
}
#[repr(C)]
#[repr(align(4))]
#[derive(Debug, Copy, Clone)]
pub struct BUTTONS__bindgen_ty_1 {
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
impl BUTTONS__bindgen_ty_1 {
    #[inline]
    pub fn R_DPAD(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_R_DPAD(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn L_DPAD(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_L_DPAD(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn D_DPAD(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_D_DPAD(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn U_DPAD(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_U_DPAD(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn START_BUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_START_BUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn Z_TRIG(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_Z_TRIG(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn B_BUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_B_BUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn A_BUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_A_BUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn R_CBUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_R_CBUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn L_CBUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_L_CBUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn D_CBUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_D_CBUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn U_CBUTTON(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_U_CBUTTON(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn R_TRIG(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_R_TRIG(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn L_TRIG(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_L_TRIG(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn Reserved1(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(14usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_Reserved1(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(14usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn Reserved2(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(15usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_Reserved2(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(15usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn X_AXIS(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_X_AXIS(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn Y_AXIS(&self) -> ::std::os::raw::c_int {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(24usize, 8u8) as u32) }
    }
    #[inline]
    pub fn set_Y_AXIS(&mut self, val: ::std::os::raw::c_int) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(24usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        R_DPAD: ::std::os::raw::c_uint,
        L_DPAD: ::std::os::raw::c_uint,
        D_DPAD: ::std::os::raw::c_uint,
        U_DPAD: ::std::os::raw::c_uint,
        START_BUTTON: ::std::os::raw::c_uint,
        Z_TRIG: ::std::os::raw::c_uint,
        B_BUTTON: ::std::os::raw::c_uint,
        A_BUTTON: ::std::os::raw::c_uint,
        R_CBUTTON: ::std::os::raw::c_uint,
        L_CBUTTON: ::std::os::raw::c_uint,
        D_CBUTTON: ::std::os::raw::c_uint,
        U_CBUTTON: ::std::os::raw::c_uint,
        R_TRIG: ::std::os::raw::c_uint,
        L_TRIG: ::std::os::raw::c_uint,
        Reserved1: ::std::os::raw::c_uint,
        Reserved2: ::std::os::raw::c_uint,
        X_AXIS: ::std::os::raw::c_int,
        Y_AXIS: ::std::os::raw::c_int,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let R_DPAD: u32 = unsafe { ::std::mem::transmute(R_DPAD) };
            R_DPAD as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let L_DPAD: u32 = unsafe { ::std::mem::transmute(L_DPAD) };
            L_DPAD as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let D_DPAD: u32 = unsafe { ::std::mem::transmute(D_DPAD) };
            D_DPAD as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let U_DPAD: u32 = unsafe { ::std::mem::transmute(U_DPAD) };
            U_DPAD as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let START_BUTTON: u32 = unsafe { ::std::mem::transmute(START_BUTTON) };
            START_BUTTON as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let Z_TRIG: u32 = unsafe { ::std::mem::transmute(Z_TRIG) };
            Z_TRIG as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let B_BUTTON: u32 = unsafe { ::std::mem::transmute(B_BUTTON) };
            B_BUTTON as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let A_BUTTON: u32 = unsafe { ::std::mem::transmute(A_BUTTON) };
            A_BUTTON as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let R_CBUTTON: u32 = unsafe { ::std::mem::transmute(R_CBUTTON) };
            R_CBUTTON as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let L_CBUTTON: u32 = unsafe { ::std::mem::transmute(L_CBUTTON) };
            L_CBUTTON as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let D_CBUTTON: u32 = unsafe { ::std::mem::transmute(D_CBUTTON) };
            D_CBUTTON as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let U_CBUTTON: u32 = unsafe { ::std::mem::transmute(U_CBUTTON) };
            U_CBUTTON as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let R_TRIG: u32 = unsafe { ::std::mem::transmute(R_TRIG) };
            R_TRIG as u64
        });
        __bindgen_bitfield_unit.set(13usize, 1u8, {
            let L_TRIG: u32 = unsafe { ::std::mem::transmute(L_TRIG) };
            L_TRIG as u64
        });
        __bindgen_bitfield_unit.set(14usize, 1u8, {
            let Reserved1: u32 = unsafe { ::std::mem::transmute(Reserved1) };
            Reserved1 as u64
        });
        __bindgen_bitfield_unit.set(15usize, 1u8, {
            let Reserved2: u32 = unsafe { ::std::mem::transmute(Reserved2) };
            Reserved2 as u64
        });
        __bindgen_bitfield_unit.set(16usize, 8u8, {
            let X_AXIS: u32 = unsafe { ::std::mem::transmute(X_AXIS) };
            X_AXIS as u64
        });
        __bindgen_bitfield_unit.set(24usize, 8u8, {
            let Y_AXIS: u32 = unsafe { ::std::mem::transmute(Y_AXIS) };
            Y_AXIS as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct CONTROL_INFO {
    pub Controls: *mut CONTROL,
}
pub type ptr_RomClosed = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_RomOpen = ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>;
extern "C" {
    pub fn RomOpen() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn RomClosed();
}
pub type ptr_ChangeWindow = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_InitiateGFX =
    ::std::option::Option<unsafe extern "C" fn(Gfx_Info: GFX_INFO) -> ::std::os::raw::c_int>;
pub type ptr_MoveScreen =
    ::std::option::Option<unsafe extern "C" fn(x: ::std::os::raw::c_int, y: ::std::os::raw::c_int)>;
pub type ptr_ProcessDList = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_ProcessRDPList = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_ShowCFB = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_UpdateScreen = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_ViStatusChanged = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_ViWidthChanged = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_ReadScreen2 = ::std::option::Option<
    unsafe extern "C" fn(
        dest: *mut ::std::os::raw::c_void,
        width: *mut ::std::os::raw::c_int,
        height: *mut ::std::os::raw::c_int,
        front: ::std::os::raw::c_int,
    ),
>;
pub type ptr_SetRenderingCallback = ::std::option::Option<
    unsafe extern "C" fn(
        callback: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    ),
>;
pub type ptr_ResizeVideoOutput = ::std::option::Option<
    unsafe extern "C" fn(width: ::std::os::raw::c_int, height: ::std::os::raw::c_int),
>;
extern "C" {
    pub fn ChangeWindow();
}
extern "C" {
    pub fn InitiateGFX(Gfx_Info: GFX_INFO) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn MoveScreen(x: ::std::os::raw::c_int, y: ::std::os::raw::c_int);
}
extern "C" {
    pub fn ProcessDList();
}
extern "C" {
    pub fn ProcessRDPList();
}
extern "C" {
    pub fn ShowCFB();
}
extern "C" {
    pub fn UpdateScreen();
}
extern "C" {
    pub fn ViStatusChanged();
}
extern "C" {
    pub fn ViWidthChanged();
}
extern "C" {
    pub fn ReadScreen2(
        dest: *mut ::std::os::raw::c_void,
        width: *mut ::std::os::raw::c_int,
        height: *mut ::std::os::raw::c_int,
        front: ::std::os::raw::c_int,
    );
}
extern "C" {
    pub fn SetRenderingCallback(
        callback: ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>,
    );
}
extern "C" {
    pub fn ResizeVideoOutput(width: ::std::os::raw::c_int, height: ::std::os::raw::c_int);
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct FrameBufferInfo {
    pub addr: ::std::os::raw::c_uint,
    pub size: ::std::os::raw::c_uint,
    pub width: ::std::os::raw::c_uint,
    pub height: ::std::os::raw::c_uint,
}
pub type ptr_FBRead = ::std::option::Option<unsafe extern "C" fn(addr: ::std::os::raw::c_uint)>;
pub type ptr_FBWrite = ::std::option::Option<
    unsafe extern "C" fn(addr: ::std::os::raw::c_uint, size: ::std::os::raw::c_uint),
>;
pub type ptr_FBGetFrameBufferInfo =
    ::std::option::Option<unsafe extern "C" fn(p: *mut ::std::os::raw::c_void)>;
extern "C" {
    pub fn FBRead(addr: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn FBWrite(addr: ::std::os::raw::c_uint, size: ::std::os::raw::c_uint);
}
extern "C" {
    pub fn FBGetFrameBufferInfo(p: *mut ::std::os::raw::c_void);
}
pub type ptr_AiDacrateChanged =
    ::std::option::Option<unsafe extern "C" fn(SystemType: ::std::os::raw::c_int)>;
pub type ptr_AiLenChanged = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_InitiateAudio =
    ::std::option::Option<unsafe extern "C" fn(Audio_Info: AUDIO_INFO) -> ::std::os::raw::c_int>;
pub type ptr_ProcessAList = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_SetSpeedFactor =
    ::std::option::Option<unsafe extern "C" fn(percent: ::std::os::raw::c_int)>;
pub type ptr_VolumeUp = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_VolumeDown = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_VolumeGetLevel =
    ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_int>;
pub type ptr_VolumeSetLevel =
    ::std::option::Option<unsafe extern "C" fn(level: ::std::os::raw::c_int)>;
pub type ptr_VolumeMute = ::std::option::Option<unsafe extern "C" fn()>;
pub type ptr_VolumeGetString =
    ::std::option::Option<unsafe extern "C" fn() -> *const ::std::os::raw::c_char>;
extern "C" {
    pub fn AiDacrateChanged(SystemType: ::std::os::raw::c_int);
}
extern "C" {
    pub fn AiLenChanged();
}
extern "C" {
    pub fn InitiateAudio(Audio_Info: AUDIO_INFO) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ProcessAList();
}
extern "C" {
    pub fn SetSpeedFactor(percent: ::std::os::raw::c_int);
}
extern "C" {
    pub fn VolumeUp();
}
extern "C" {
    pub fn VolumeDown();
}
extern "C" {
    pub fn VolumeGetLevel() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn VolumeSetLevel(level: ::std::os::raw::c_int);
}
extern "C" {
    pub fn VolumeMute();
}
extern "C" {
    pub fn VolumeGetString() -> *const ::std::os::raw::c_char;
}
pub type ptr_ControllerCommand = ::std::option::Option<
    unsafe extern "C" fn(Control: ::std::os::raw::c_int, Command: *mut ::std::os::raw::c_uchar),
>;
pub type ptr_GetKeys =
    ::std::option::Option<unsafe extern "C" fn(Control: ::std::os::raw::c_int, Keys: *mut BUTTONS)>;
pub type ptr_InitiateControllers =
    ::std::option::Option<unsafe extern "C" fn(ControlInfo: CONTROL_INFO)>;
pub type ptr_ReadController = ::std::option::Option<
    unsafe extern "C" fn(Control: ::std::os::raw::c_int, Command: *mut ::std::os::raw::c_uchar),
>;
pub type ptr_SDL_KeyDown = ::std::option::Option<
    unsafe extern "C" fn(keymod: ::std::os::raw::c_int, keysym: ::std::os::raw::c_int),
>;
pub type ptr_SDL_KeyUp = ::std::option::Option<
    unsafe extern "C" fn(keymod: ::std::os::raw::c_int, keysym: ::std::os::raw::c_int),
>;
pub type ptr_RenderCallback = ::std::option::Option<unsafe extern "C" fn()>;
extern "C" {
    pub fn ControllerCommand(Control: ::std::os::raw::c_int, Command: *mut ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn GetKeys(Control: ::std::os::raw::c_int, Keys: *mut BUTTONS);
}
extern "C" {
    pub fn InitiateControllers(ControlInfo: CONTROL_INFO);
}
extern "C" {
    pub fn ReadController(Control: ::std::os::raw::c_int, Command: *mut ::std::os::raw::c_uchar);
}
extern "C" {
    pub fn SDL_KeyDown(keymod: ::std::os::raw::c_int, keysym: ::std::os::raw::c_int);
}
extern "C" {
    pub fn SDL_KeyUp(keymod: ::std::os::raw::c_int, keysym: ::std::os::raw::c_int);
}
extern "C" {
    pub fn RenderCallback();
}
pub type ptr_DoRspCycles = ::std::option::Option<
    unsafe extern "C" fn(Cycles: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint,
>;
pub type ptr_InitiateRSP = ::std::option::Option<
    unsafe extern "C" fn(Rsp_Info: RSP_INFO, CycleCount: *mut ::std::os::raw::c_uint),
>;
extern "C" {
    pub fn DoRspCycles(Cycles: ::std::os::raw::c_uint) -> ::std::os::raw::c_uint;
}
extern "C" {
    pub fn InitiateRSP(Rsp_Info: RSP_INFO, CycleCount: *mut ::std::os::raw::c_uint);
}
pub type ptr_PluginGetVersion = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut m64p_plugin_type,
        arg2: *mut ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut *const ::std::os::raw::c_char,
        arg5: *mut ::std::os::raw::c_int,
    ) -> m64p_error,
>;
extern "C" {
    pub fn PluginGetVersion(
        arg1: *mut m64p_plugin_type,
        arg2: *mut ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut *const ::std::os::raw::c_char,
        arg5: *mut ::std::os::raw::c_int,
    ) -> m64p_error;
}
pub type ptr_CoreGetAPIVersions = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> m64p_error,
>;
extern "C" {
    pub fn CoreGetAPIVersions(
        arg1: *mut ::std::os::raw::c_int,
        arg2: *mut ::std::os::raw::c_int,
        arg3: *mut ::std::os::raw::c_int,
        arg4: *mut ::std::os::raw::c_int,
    ) -> m64p_error;
}
pub type ptr_CoreErrorMessage =
    ::std::option::Option<unsafe extern "C" fn(arg1: m64p_error) -> *const ::std::os::raw::c_char>;
extern "C" {
    pub fn CoreErrorMessage(arg1: m64p_error) -> *const ::std::os::raw::c_char;
}
pub type ptr_PluginStartup = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_dynlib_handle,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: ::std::os::raw::c_int,
                arg3: *const ::std::os::raw::c_char,
            ),
        >,
    ) -> m64p_error,
>;
extern "C" {
    pub fn PluginStartup(
        arg1: m64p_dynlib_handle,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: ::std::os::raw::c_int,
                arg3: *const ::std::os::raw::c_char,
            ),
        >,
    ) -> m64p_error;
}
pub type ptr_PluginShutdown = ::std::option::Option<unsafe extern "C" fn() -> m64p_error>;
extern "C" {
    pub fn PluginShutdown() -> m64p_error;
}
extern "C" {
    pub static mut gfx: GFX_INFO;
}
extern "C" {
    pub static mut CoreLibHandle: m64p_dynlib_handle;
}
extern "C" {
    pub static mut render_callback:
        ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
}
extern "C" {
    pub static mut debug_callback: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: *mut ::std::os::raw::c_void,
            arg2: ::std::os::raw::c_int,
            arg3: *const ::std::os::raw::c_char,
        ),
    >;
}
extern "C" {
    pub static mut debug_call_context: *mut ::std::os::raw::c_void;
}
pub type ptr_ConfigListSections = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
            ),
        >,
    ) -> m64p_error,
>;
extern "C" {
    pub fn ConfigListSections(
        arg1: *mut ::std::os::raw::c_void,
        arg2: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
            ),
        >,
    ) -> m64p_error;
}
pub type ptr_ConfigOpenSection = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char, arg2: *mut m64p_handle) -> m64p_error,
>;
extern "C" {
    pub fn ConfigOpenSection(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut m64p_handle,
    ) -> m64p_error;
}
pub type ptr_ConfigListParameters = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: m64p_type,
            ),
        >,
    ) -> m64p_error,
>;
extern "C" {
    pub fn ConfigListParameters(
        arg1: m64p_handle,
        arg2: *mut ::std::os::raw::c_void,
        arg3: ::std::option::Option<
            unsafe extern "C" fn(
                arg1: *mut ::std::os::raw::c_void,
                arg2: *const ::std::os::raw::c_char,
                arg3: m64p_type,
            ),
        >,
    ) -> m64p_error;
}
pub type ptr_ConfigSaveFile = ::std::option::Option<unsafe extern "C" fn() -> m64p_error>;
extern "C" {
    pub fn ConfigSaveFile() -> m64p_error;
}
pub type ptr_ConfigSaveSection =
    ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> m64p_error>;
extern "C" {
    pub fn ConfigSaveSection(arg1: *const ::std::os::raw::c_char) -> m64p_error;
}
pub type ptr_ConfigHasUnsavedChanges = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn ConfigHasUnsavedChanges(arg1: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
pub type ptr_ConfigDeleteSection = ::std::option::Option<
    unsafe extern "C" fn(SectionName: *const ::std::os::raw::c_char) -> m64p_error,
>;
extern "C" {
    pub fn ConfigDeleteSection(SectionName: *const ::std::os::raw::c_char) -> m64p_error;
}
pub type ptr_ConfigRevertChanges = ::std::option::Option<
    unsafe extern "C" fn(SectionName: *const ::std::os::raw::c_char) -> m64p_error,
>;
extern "C" {
    pub fn ConfigRevertChanges(SectionName: *const ::std::os::raw::c_char) -> m64p_error;
}
pub type ptr_ConfigSetParameter = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: m64p_type,
        arg4: *const ::std::os::raw::c_void,
    ) -> m64p_error,
>;
extern "C" {
    pub fn ConfigSetParameter(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: m64p_type,
        arg4: *const ::std::os::raw::c_void,
    ) -> m64p_error;
}
pub type ptr_ConfigSetParameterHelp = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> m64p_error,
>;
extern "C" {
    pub fn ConfigSetParameterHelp(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
    ) -> m64p_error;
}
pub type ptr_ConfigGetParameter = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: m64p_type,
        arg4: *mut ::std::os::raw::c_void,
        arg5: ::std::os::raw::c_int,
    ) -> m64p_error,
>;
extern "C" {
    pub fn ConfigGetParameter(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: m64p_type,
        arg4: *mut ::std::os::raw::c_void,
        arg5: ::std::os::raw::c_int,
    ) -> m64p_error;
}
pub type ptr_ConfigGetParameterType = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut m64p_type,
    ) -> m64p_error,
>;
extern "C" {
    pub fn ConfigGetParameterType(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: *mut m64p_type,
    ) -> m64p_error;
}
pub type ptr_ConfigGetParameterHelp = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char,
>;
extern "C" {
    pub fn ConfigGetParameterHelp(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
pub type ptr_ConfigSetDefaultInt = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    ) -> m64p_error,
>;
pub type ptr_ConfigSetDefaultFloat = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: f32,
        arg4: *const ::std::os::raw::c_char,
    ) -> m64p_error,
>;
pub type ptr_ConfigSetDefaultBool = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    ) -> m64p_error,
>;
pub type ptr_ConfigSetDefaultString = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
    ) -> m64p_error,
>;
extern "C" {
    pub fn ConfigSetDefaultInt(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    ) -> m64p_error;
}
extern "C" {
    pub fn ConfigSetDefaultFloat(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: f32,
        arg4: *const ::std::os::raw::c_char,
    ) -> m64p_error;
}
extern "C" {
    pub fn ConfigSetDefaultBool(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: ::std::os::raw::c_int,
        arg4: *const ::std::os::raw::c_char,
    ) -> m64p_error;
}
extern "C" {
    pub fn ConfigSetDefaultString(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
        arg4: *const ::std::os::raw::c_char,
    ) -> m64p_error;
}
pub type ptr_ConfigGetParamInt = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
pub type ptr_ConfigGetParamFloat = ::std::option::Option<
    unsafe extern "C" fn(arg1: m64p_handle, arg2: *const ::std::os::raw::c_char) -> f32,
>;
pub type ptr_ConfigGetParamBool = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int,
>;
pub type ptr_ConfigGetParamString = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char,
>;
extern "C" {
    pub fn ConfigGetParamInt(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ConfigGetParamFloat(arg1: m64p_handle, arg2: *const ::std::os::raw::c_char) -> f32;
}
extern "C" {
    pub fn ConfigGetParamBool(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ConfigGetParamString(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
pub type ptr_ConfigGetSharedDataFilepath = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> *const ::std::os::raw::c_char,
>;
extern "C" {
    pub fn ConfigGetSharedDataFilepath(
        arg1: *const ::std::os::raw::c_char,
    ) -> *const ::std::os::raw::c_char;
}
pub type ptr_ConfigGetUserConfigPath =
    ::std::option::Option<unsafe extern "C" fn() -> *const ::std::os::raw::c_char>;
extern "C" {
    pub fn ConfigGetUserConfigPath() -> *const ::std::os::raw::c_char;
}
pub type ptr_ConfigGetUserDataPath =
    ::std::option::Option<unsafe extern "C" fn() -> *const ::std::os::raw::c_char>;
extern "C" {
    pub fn ConfigGetUserDataPath() -> *const ::std::os::raw::c_char;
}
pub type ptr_ConfigGetUserCachePath =
    ::std::option::Option<unsafe extern "C" fn() -> *const ::std::os::raw::c_char>;
extern "C" {
    pub fn ConfigGetUserCachePath() -> *const ::std::os::raw::c_char;
}
pub type ptr_ConfigExternalOpen = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char, arg2: *mut m64p_handle) -> m64p_error,
>;
extern "C" {
    pub fn ConfigExternalOpen(
        arg1: *const ::std::os::raw::c_char,
        arg2: *mut m64p_handle,
    ) -> m64p_error;
}
pub type ptr_ConfigExternalClose =
    ::std::option::Option<unsafe extern "C" fn(arg1: m64p_handle) -> m64p_error>;
extern "C" {
    pub fn ConfigExternalClose(arg1: m64p_handle) -> m64p_error;
}
pub type ptr_ConfigExternalGetParameter = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
        arg4: *mut ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_int,
    ) -> m64p_error,
>;
extern "C" {
    pub fn ConfigExternalGetParameter(
        arg1: m64p_handle,
        arg2: *const ::std::os::raw::c_char,
        arg3: *const ::std::os::raw::c_char,
        arg4: *mut ::std::os::raw::c_char,
        arg5: ::std::os::raw::c_int,
    ) -> m64p_error;
}
pub type ptr_VidExt_Init = ::std::option::Option<unsafe extern "C" fn() -> m64p_error>;
extern "C" {
    pub fn VidExt_Init() -> m64p_error;
}
pub type ptr_VidExt_Quit = ::std::option::Option<unsafe extern "C" fn() -> m64p_error>;
extern "C" {
    pub fn VidExt_Quit() -> m64p_error;
}
pub type ptr_VidExt_ListFullscreenModes = ::std::option::Option<
    unsafe extern "C" fn(arg1: *mut m64p_2d_size, arg2: *mut ::std::os::raw::c_int) -> m64p_error,
>;
extern "C" {
    pub fn VidExt_ListFullscreenModes(
        arg1: *mut m64p_2d_size,
        arg2: *mut ::std::os::raw::c_int,
    ) -> m64p_error;
}
pub type ptr_VidExt_SetVideoMode = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: m64p_video_mode,
        arg5: m64p_video_flags,
    ) -> m64p_error,
>;
extern "C" {
    pub fn VidExt_SetVideoMode(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
        arg3: ::std::os::raw::c_int,
        arg4: m64p_video_mode,
        arg5: m64p_video_flags,
    ) -> m64p_error;
}
pub type ptr_VidExt_ResizeWindow = ::std::option::Option<
    unsafe extern "C" fn(arg1: ::std::os::raw::c_int, arg2: ::std::os::raw::c_int) -> m64p_error,
>;
extern "C" {
    pub fn VidExt_ResizeWindow(
        arg1: ::std::os::raw::c_int,
        arg2: ::std::os::raw::c_int,
    ) -> m64p_error;
}
pub type ptr_VidExt_SetCaption =
    ::std::option::Option<unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> m64p_error>;
extern "C" {
    pub fn VidExt_SetCaption(arg1: *const ::std::os::raw::c_char) -> m64p_error;
}
pub type ptr_VidExt_ToggleFullScreen = ::std::option::Option<unsafe extern "C" fn() -> m64p_error>;
extern "C" {
    pub fn VidExt_ToggleFullScreen() -> m64p_error;
}
pub type ptr_VidExt_GL_GetProcAddress = ::std::option::Option<
    unsafe extern "C" fn(arg1: *const ::std::os::raw::c_char) -> *mut ::std::os::raw::c_void,
>;
extern "C" {
    pub fn VidExt_GL_GetProcAddress(
        arg1: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_void;
}
pub type ptr_VidExt_GL_SetAttribute = ::std::option::Option<
    unsafe extern "C" fn(arg1: m64p_GLattr, arg2: ::std::os::raw::c_int) -> m64p_error,
>;
extern "C" {
    pub fn VidExt_GL_SetAttribute(arg1: m64p_GLattr, arg2: ::std::os::raw::c_int) -> m64p_error;
}
pub type ptr_VidExt_GL_GetAttribute = ::std::option::Option<
    unsafe extern "C" fn(arg1: m64p_GLattr, arg2: *mut ::std::os::raw::c_int) -> m64p_error,
>;
extern "C" {
    pub fn VidExt_GL_GetAttribute(
        arg1: m64p_GLattr,
        arg2: *mut ::std::os::raw::c_int,
    ) -> m64p_error;
}
pub type ptr_VidExt_GL_SwapBuffers = ::std::option::Option<unsafe extern "C" fn() -> m64p_error>;
extern "C" {
    pub fn VidExt_GL_SwapBuffers() -> m64p_error;
}
pub const ogl_LoadStatus_ogl_LOAD_FAILED: ogl_LoadStatus = 0;
pub const ogl_LoadStatus_ogl_LOAD_SUCCEEDED: ogl_LoadStatus = 1;
pub type ogl_LoadStatus = ::std::os::raw::c_uint;
extern "C" {
    pub fn ogl_LoadFunctions() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ogl_GetMinorVersion() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ogl_GetMajorVersion() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ogl_IsVersionGEQ(
        majorVersion: ::std::os::raw::c_int,
        minorVersion: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
