#!/usr/bin/env python3

import sys
from collections import defaultdict

lexiconfile = sys.argv[1]

def product(args):
    r = 1
    for arg in args:
        r *= arg
    return r

primes = [2,3,5,7,11,13,17,19,23,29,31,37,41,43,47,53,59,61,67,71,73,79,83,89,97,101,103,107,109,113,127,131]

alphabet = { chr(x+97): primes[x]  for x in range(0,26) }

anahash = lambda s: product(alphabet[c] for c in sorted(s.lower()) if c in alphabet)

index = defaultdict(list)
with open(lexiconfile, 'r', encoding='utf-8') as f:
    for line in f:
        line = line.strip()
        anavalue = anahash(line)
        if anavalue > 2**64:
            print("WARNING: 64-bit overflow for ", line,file=sys.stderr)

        index[anavalue].append(line)

for anavalue, variants in sorted(index.items()):
    print(str(anavalue) + "\t" + "\t".join(variants))

