use serde::{Deserialize, Serialize};
use uuid::Uuid;

type Payload = Vec<u8>;

///Command messages allowed to be sent over the wire
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct CommandMessage<C> {
    pub id: Uuid,
    pub command: C,
    pub payload: Option<Payload>,
}

///Messages that are allowed to be received over the wire
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct ResponseMessage<C> {
    pub id: Uuid,
    pub command: C,
    pub payload: Option<Payload>,
    pub success: bool,
}

///Instruction type
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct Instruction<A, C> {
    pub id: Uuid,
    pub action: A,
    pub compensate: C,
    pub response_data_key: u32,
    pub response_instert_key: u32,
}

///A vector of instructions for the saga
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct Saga<A, C> {
    pub id: Uuid,
    pub initial_payload: Option<Payload>,
    pub instructions: Vec<Instruction<A, C>>,
}
