use serde::{Deserialize, Serialize};
use uuid::Uuid;

///Command messages allowed to be sent over the wire
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct CommandMessage<C, P> {
    pub id: Uuid,
    pub command: C,
    pub payload: P,
}

///Messages that are allowed to be received over the wire
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct ResponseMessage<C, P> {
    pub id: Uuid,
    pub command: C,
    pub payload: P,
    pub success: bool,
}

///Instruction type
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct Instruction<A, C, R> {
    pub id: Uuid,
    pub action: A,
    pub compensate: C,
    pub response_data_key: Option<R>,
}

///A vector of instructions for the saga
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct Saga<A, C, R, P> {
    pub id: Uuid,
    pub initial_payload: Option<P>,
    pub instructions: Vec<Instruction<A, C, R>>,
}
