use nats::Connection;

///Simple NATS wrapper
pub struct NatsClient {
    pub client: Connection,
}

impl NatsClient {
    ///connect to a NATS server and obtain a client
    pub fn new(addr: &str) -> Self {
        if let Ok(nc) = nats::connect(addr) {
            return NatsClient { client: nc };
        } else {
            panic!("Failed to connect to NATS");
        }
    }

    ///Obtain a NATS connection from the client
    pub fn connection(&self) -> Connection {
        return self.client.clone();
    }
}
