use serde::{Deserialize, Serialize};

///Command messages allowed to be sent over the wire
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct CommandMessage<C, P> {
    pub command: C,
    pub payload: P,
}

///Messages that are allowed to be received over the wire
#[derive(Debug, Clone, Serialize, Deserialize)]
pub struct ResponseMessage<C, P> {
    pub command: C,
    pub payload: P,
    pub success: bool,
}
