#[proc_macro_attribute] pub fn
SERVER(_: TokenStream, item: TokenStream) -> TokenStream {
    const FRAME: &'static str = "async fn e() -> std::io::Result<()> {}";
    const MACRO: &'static str = "#[amper::actix_web::main]";

    let frame = FRAME.parse().unwrap();
    let frame = parse_macro_input!(frame as ItemFn);

    let mut item = parse_macro_input!(item as ItemFn);

    item.sig.asyncness = frame.sig.asyncness;
    item.sig.output = frame.sig.output;

    let item = quote! { #item };
    let item: TokenStream =
        ((MACRO.to_string()) + &(item.to_string())[..]).parse().unwrap();

    item
}
