#[proc_macro_attribute] pub fn
GET(attr: TokenStream, item: TokenStream) -> TokenStream {
    const FRAME: &'static str = "async fn ex() -> impl amper::actix_web::Responder {}";

    let frame: TokenStream = FRAME.parse().unwrap();
    let frame = parse_macro_input!(frame as ItemFn);

    let mut item = parse_macro_input!(item as ItemFn);

    item.sig.asyncness = frame.sig.asyncness;
    item.sig.output = frame.sig.output;

    let attr: TokenStream = (format!("#[amper::actix_web::get({})]", attr)).parse().unwrap();
    let item = quote! { #item };

    let item: TokenStream =
        ((attr.to_string()) + &(item.to_string())[..]).parse().unwrap();
    item
}
