use regex::Regex;

pub async fn parsing(url: &'static str, rule: &'static str) -> Result<String, reqwest::Error> {
    let html = reqwest::get(url).await?;

    let html = html.text().await?;

    let re = Regex::new(rule).unwrap();

    let mut text = "".to_string();
    for cap in re.find_iter(&html) {
        let (start, end) = (cap.start() as usize, cap.end() as usize);
        text += &html[start..end];
    }
    Ok(text)
}
