#[macro_export] macro_rules!
template {
    ($var:expr) => (
        amper::actix_web::HttpResponse::Ok()
            .content_type("text/html; charset=utf-8")
            .body($var.render().unwrap())
    );
    ($var:expr; $($arg:tt)*) => (
        amper::actix_web::HttpResponse::Ok()
            $($arg)*
            .content_type("text/html; charset=utf-8")
            .body($var.render().unwrap())
    );
}

#[macro_export] macro_rules!
load {
    ($path:expr) => (
        amper::actix_web::HttpResponse::Ok()
            .content_type("text/html; charset=utf-8")
            .body(include_str!($path))
    );
    ($path:expr; $($arg:tt)*) => (
        amper::actix_web::HttpResponse::Ok()
            $($arg)*
            .content_type("text/html; charset=utf-8")
            .body(include_str!($path))
    );
}

#[macro_export] macro_rules!
html {
    ($var:expr) => {
        amper::actix_web::HttpResponse::Ok()
            .content_type("text/html; charset=utf-8")
            .body($var)
    };
    ($var:expr; $($arg:tt)*) => {
        amper::actix_web::HttpResponse::Ok()
            $($arg)*
            .content_type("text/html; charset=utf-8")
            .body($var)
    };
}
