use regex::Regex;

pub async fn parsing(url: &'static str, rule: &'static str) -> stdm::Handle<String> {
    let html = reqwest::get(url).await;

    if let Err(_) = html {
        return stdm::ERROR::<String> ("can't get id request");
    }

    let html = html
                .unwrap()
                .text()
                .await.unwrap();

    let re = Regex::new(rule).unwrap();

    let mut text = "".to_string();
    for cap in re.find_iter(&html) {
        let (start, end) = (cap.start() as usize, cap.end() as usize);
        text += &html[start..end];
    }
    Ok(text)
}
