//use std::env;
use std::path::Path;

use linux_embedded_hal::I2cdev;

pub fn main() {
    let addr = amg88::Address::High;
    let bus_path = Path::new("/dev/i2c-1");
    let bus = I2cdev::new(bus_path).unwrap();
    let mut camera = amg88::GridEye::new(bus, addr);
    println!("Power Mode: {:?}", camera.power_mode().unwrap());
    println!("Frame Rate: {:?}", camera.frame_rate().unwrap());
    println!(
        "Interrupts enabled: {:?}",
        camera.interrupts_enabled().unwrap()
    );
    println!("Interrupt mode: {:?}", camera.interrupt_mode().unwrap());
    println!("Status Flags: {:?}", camera.flags().unwrap());
    println!(
        "Moving average: {:?}",
        camera.moving_average_enabled().unwrap()
    );
    println!(
        "Interrupt levels: {:^6.2} - {:^6.2} - {:^6.2}",
        camera.lower_interrupt_level().unwrap(),
        camera.hysteresis_interrupt_level().unwrap(),
        camera.upper_interrupt_level().unwrap(),
    );
    println!("Sensor Temperature: {:?}", camera.thermistor().unwrap());
    println!("Pixel Temperatures:");
    let image = camera.image().unwrap();
    for row in image.outer_iter().rev() {
        for pixel in row.iter() {
            print!("{:>6.2} ", pixel);
        }
        println!();
    }
}
