/*
 * Copyright (c) 2019, Ambiq Micro
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * Third party software included in this distribution is subject to the
 * additional license terms as defined in the /docs/licenses directory.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @file     apollo2.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     14. January 2020
 * @note     Generated by SVDConv V3.3.27 on Tuesday, 14.01.2020 11:56:35
 *           from File './apollo2.svd',
 *           last modified on Tuesday, 14.01.2020 17:56:34
 */



/** @addtogroup Ambiq Micro
  * @{
  */


/** @addtogroup apollo2
  * @{
  */


#ifndef APOLLO2_H
#define APOLLO2_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M4 Specific Interrupt Numbers  ======================================== */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  MemoryManagement_IRQn     = -12,              /*!< -12  Memory Management, MPU mismatch, including Access Violation
                                                     and No Match                                                              */
  BusFault_IRQn             = -11,              /*!< -11  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                     related Fault                                                             */
  UsageFault_IRQn           = -10,              /*!< -10  Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  DebugMonitor_IRQn         =  -4,              /*!< -4 Debug Monitor                                                          */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ==========================================  apollo2 Specific Interrupt Numbers  =========================================== */
  BROWNOUT_IRQn             =   0,              /*!< 0  BROWNOUT                                                               */
  WDT_IRQn                  =   1,              /*!< 1  WDT                                                                    */
  CLKGEN_RTC_IRQn           =   2,              /*!< 2  CLKGEN_RTC                                                             */
  VCOMP_IRQn                =   3,              /*!< 3  VCOMP                                                                  */
  IOSLAVE_IRQn              =   4,              /*!< 4  IOSLAVE                                                                */
  IOSLAVEACC_IRQn           =   5,              /*!< 5  IOSLAVEACC                                                             */
  IOMSTR0_IRQn              =   6,              /*!< 6  IOMSTR0                                                                */
  IOMSTR1_IRQn              =   7,              /*!< 7  IOMSTR1                                                                */
  IOMSTR2_IRQn              =   8,              /*!< 8  IOMSTR2                                                                */
  IOMSTR3_IRQn              =   9,              /*!< 9  IOMSTR3                                                                */
  IOMSTR4_IRQn              =  10,              /*!< 10 IOMSTR4                                                                */
  IOMSTR5_IRQn              =  11,              /*!< 11 IOMSTR5                                                                */
  GPIO_IRQn                 =  12,              /*!< 12 GPIO                                                                   */
  CTIMER_IRQn               =  13,              /*!< 13 CTIMER                                                                 */
  UART0_IRQn                =  14,              /*!< 14 UART0                                                                  */
  UART1_IRQn                =  15,              /*!< 15 UART1                                                                  */
  ADC_IRQn                  =  16,              /*!< 16 ADC                                                                    */
  PDM_IRQn                  =  17,              /*!< 17 PDM                                                                    */
  STIMER_IRQn               =  18,              /*!< 18 STIMER                                                                 */
  STIMER_CMPR0_IRQn         =  19,              /*!< 19 STIMER_CMPR0                                                           */
  STIMER_CMPR1_IRQn         =  20,              /*!< 20 STIMER_CMPR1                                                           */
  STIMER_CMPR2_IRQn         =  21,              /*!< 21 STIMER_CMPR2                                                           */
  STIMER_CMPR3_IRQn         =  22,              /*!< 22 STIMER_CMPR3                                                           */
  STIMER_CMPR4_IRQn         =  23,              /*!< 23 STIMER_CMPR4                                                           */
  STIMER_CMPR5_IRQn         =  24,              /*!< 24 STIMER_CMPR5                                                           */
  STIMER_CMPR6_IRQn         =  25,              /*!< 25 STIMER_CMPR6                                                           */
  STIMER_CMPR7_IRQn         =  26               /*!< 26 STIMER_CMPR7                                                           */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M4 Processor and Core Peripherals  =========================== */
#define __CM4_REV                 0x0100U       /*!< CM4 Core Revision                                                         */
#define __NVIC_PRIO_BITS               3        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __MPU_PRESENT                  1        /*!< MPU present                                                               */
#define __FPU_PRESENT                  1        /*!< FPU present                                                               */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                           /*!< ARM Cortex-M4 processor and core peripherals                              */
#include "system_apollo2.h"                     /*!< apollo2 System                                                            */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Analog Digital Converter Control (ADC)
  */

typedef struct {                                /*!< (@ 0x50010000) ADC Structure                                              */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */

    struct {
      __IOM uint32_t ADCEN      : 1;            /*!< [0..0] This bit enables the ADC module. While the ADC is enabled,
                                                     the ADCCFG and SLOT Configuration regsiter settings must
                                                     remain stable and unchanged. All configuration register
                                                     settings, slot configuration settings and window comparison
                                                     settings should be written prior to setting the ADCEN bit
                                                     to '1'.                                                                   */
      __IM  uint32_t            : 1;
      __IOM uint32_t RPTEN      : 1;            /*!< [2..2] This bit enables Repeating Scan Mode.                              */
      __IOM uint32_t LPMODE     : 1;            /*!< [3..3] Select power mode to enter between active scans.                   */
      __IOM uint32_t CKMODE     : 1;            /*!< [4..4] Clock mode register                                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t REFSEL     : 2;            /*!< [9..8] Select the ADC reference voltage.                                  */
      __IM  uint32_t            : 6;
      __IOM uint32_t TRIGSEL    : 3;            /*!< [18..16] Select the ADC trigger source.                                   */
      __IOM uint32_t TRIGPOL    : 1;            /*!< [19..19] This bit selects the ADC trigger polarity for external
                                                     off chip triggers.                                                        */
      __IM  uint32_t            : 4;
      __IOM uint32_t CLKSEL     : 2;            /*!< [25..24] Select the source and frequency for the ADC clock.
                                                     All values not enumerated below are undefined.                            */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) ADC Power Status                                           */

    struct {
      __IOM uint32_t PWDSTAT    : 1;            /*!< [0..0] Indicates the power-status of the ADC.                             */
    } STAT_b;
  } ;

  union {
    __IOM uint32_t SWT;                         /*!< (@ 0x00000008) Software trigger                                           */

    struct {
      __IOM uint32_t SWT        : 8;            /*!< [7..0] Writing 0x37 to this register generates a software trigger.        */
    } SWT_b;
  } ;

  union {
    __IOM uint32_t SL0CFG;                      /*!< (@ 0x0000000C) Slot 0 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN0      : 1;            /*!< [0..0] This bit enables slot 0 for ADC conversions.                       */
      __IOM uint32_t WCEN0      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     0.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL0     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE0    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL0     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL0CFG_b;
  } ;

  union {
    __IOM uint32_t SL1CFG;                      /*!< (@ 0x00000010) Slot 1 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN1      : 1;            /*!< [0..0] This bit enables slot 1 for ADC conversions.                       */
      __IOM uint32_t WCEN1      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     1.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL1     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE1    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL1     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL1CFG_b;
  } ;

  union {
    __IOM uint32_t SL2CFG;                      /*!< (@ 0x00000014) Slot 2 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN2      : 1;            /*!< [0..0] This bit enables slot 2 for ADC conversions.                       */
      __IOM uint32_t WCEN2      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     2.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL2     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE2    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL2     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL2CFG_b;
  } ;

  union {
    __IOM uint32_t SL3CFG;                      /*!< (@ 0x00000018) Slot 3 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN3      : 1;            /*!< [0..0] This bit enables slot 3 for ADC conversions.                       */
      __IOM uint32_t WCEN3      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     3.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL3     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE3    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL3     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL3CFG_b;
  } ;

  union {
    __IOM uint32_t SL4CFG;                      /*!< (@ 0x0000001C) Slot 4 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN4      : 1;            /*!< [0..0] This bit enables slot 4 for ADC conversions.                       */
      __IOM uint32_t WCEN4      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     4.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL4     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE4    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL4     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL4CFG_b;
  } ;

  union {
    __IOM uint32_t SL5CFG;                      /*!< (@ 0x00000020) Slot 5 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN5      : 1;            /*!< [0..0] This bit enables slot 5 for ADC conversions.                       */
      __IOM uint32_t WCEN5      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     5.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL5     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE5    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL5     : 3;            /*!< [26..24] Select number of measurements to average in the accumulate
                                                     divide module for this slot.                                              */
    } SL5CFG_b;
  } ;

  union {
    __IOM uint32_t SL6CFG;                      /*!< (@ 0x00000024) Slot 6 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN6      : 1;            /*!< [0..0] This bit enables slot 6 for ADC conversions.                       */
      __IOM uint32_t WCEN6      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     6.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL6     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE6    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL6     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL6CFG_b;
  } ;

  union {
    __IOM uint32_t SL7CFG;                      /*!< (@ 0x00000028) Slot 7 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN7      : 1;            /*!< [0..0] This bit enables slot 7 for ADC conversions.                       */
      __IOM uint32_t WCEN7      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     7.                                                                        */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL7     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
      __IM  uint32_t            : 4;
      __IOM uint32_t PRMODE7    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
      __IM  uint32_t            : 6;
      __IOM uint32_t ADSEL7     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
    } SL7CFG_b;
  } ;

  union {
    __IOM uint32_t WULIM;                       /*!< (@ 0x0000002C) Window Comparator Upper Limits Register                    */

    struct {
      __IOM uint32_t ULIM       : 20;           /*!< [19..0] Sets the upper limit for the wondow comparator.                   */
    } WULIM_b;
  } ;

  union {
    __IOM uint32_t WLLIM;                       /*!< (@ 0x00000030) Window Comparator Lower Limits Register                    */

    struct {
      __IOM uint32_t LLIM       : 20;           /*!< [19..0] Sets the lower limit for the wondow comparator.                   */
    } WLLIM_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000038) FIFO Data and Valid Count Register                         */

    struct {
      __IOM uint32_t DATA       : 20;           /*!< [19..0] Oldest data in the FIFO.                                          */
      __IOM uint32_t COUNT      : 8;            /*!< [27..20] Number of valid entries in the ADC FIFO.                         */
      __IOM uint32_t SLOTNUM    : 3;            /*!< [30..28] Slot number associated with this FIFO data.                      */
      __IOM uint32_t RSVD       : 1;            /*!< [31..31] RESERVED.                                                        */
    } FIFO_b;
  } ;
  __IM  uint32_t  RESERVED1[113];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) ADC Interrupt registers: Enable                            */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) ADC Interrupt registers: Status                            */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) ADC Interrupt registers: Clear                             */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) ADC Interrupt registers: Set                               */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
    } INTSET_b;
  } ;
} ADC_Type;                                     /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                         CACHECTRL                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief Flash Cache Controller (CACHECTRL)
  */

typedef struct {                                /*!< (@ 0x40018000) CACHECTRL Structure                                        */

  union {
    __IOM uint32_t CACHECFG;                    /*!< (@ 0x00000000) Flash Cache Control Register                               */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] Enables the main flash cache controller logic and enables
                                                     power to the cache RAMs. Instruction and Data caching need
                                                     to be enabled independently using the ICACHE_ENABLE and
                                                     DCACHE_ENABLE bits.                                                       */
      __IOM uint32_t LRU        : 1;            /*!< [1..1] Sets the cache replacement policy. 0=LRR (least recently
                                                     replaced), 1=LRU (least recently used). LRR minimizes writes
                                                     to the TAG SRAM and is recommended.                                       */
      __IOM uint32_t ENABLE_NC0 : 1;            /*!< [2..2] Enable Non-cacheable region 0. See the NCR0 registers
                                                     to set the region boundaries and size.                                    */
      __IOM uint32_t ENABLE_NC1 : 1;            /*!< [3..3] Enable Non-cacheable region 1. See the NCR1 registers
                                                     to set the region boundaries and size.                                    */
      __IOM uint32_t CONFIG     : 3;            /*!< [6..4] Sets the cache configuration. Only a single configuration
                                                     of 0x5 is valid.                                                          */
      __IOM uint32_t SERIAL     : 1;            /*!< [7..7] Bitfield should always be programmed to 0.                         */
      __IOM uint32_t ICACHE_ENABLE : 1;         /*!< [8..8] Enable Flash Instruction Caching. When set to 1, all
                                                     instruction accesses to flash will be cached.                             */
      __IOM uint32_t DCACHE_ENABLE : 1;         /*!< [9..9] Enable Flash Data Caching. When set to 1, all instruction
                                                     accesses to flash will be cached.                                         */
      __IOM uint32_t CACHE_CLKGATE : 1;         /*!< [10..10] Enable clock gating of individual cache RAMs. This
                                                     bit should be enabled for normal operation for lowest power
                                                     consumption.                                                              */
      __IOM uint32_t CACHE_LS   : 1;            /*!< [11..11] Enable LS (light sleep) of cache RAMs. This should
                                                     not be enabled for normal operation. When this bit is set,
                                                     the cache's RAMS will be put into light sleep mode while
                                                     inactive. NOTE: if the cache is actively used, this may
                                                     have an adverse affect on power since entering/exiting
                                                     LS mode may consume more power than would be saved.                       */
      __IOM uint32_t DLY        : 4;            /*!< [15..12] Unused. Should be left at default value.                         */
      __IOM uint32_t SMDLY      : 4;            /*!< [19..16] Unused. Should be left at default value.                         */
      __IOM uint32_t DATA_CLKGATE : 1;          /*!< [20..20] Enable clock gating of entire cache data array subsystem.
                                                     This should be enabled for normal operation.                              */
      __IM  uint32_t            : 3;
      __IOM uint32_t ENABLE_MONITOR : 1;        /*!< [24..24] Enable Cache Monitoring Stats. Only enable this for
                                                     debug/performance analysis since it will consume additional
                                                     power. See IMON/DMON registers for data.                                  */
    } CACHECFG_b;
  } ;

  union {
    __IOM uint32_t FLASHCFG;                    /*!< (@ 0x00000004) Flash Control Register                                     */

    struct {
      __IOM uint32_t RD_WAIT    : 3;            /*!< [2..0] Sets read waitstates for flash accesses (in clock cycles).
                                                     This should be left at the default value for normal flash
                                                     operation.                                                                */
    } FLASHCFG_b;
  } ;

  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000008) Cache Control                                              */

    struct {
      __IOM uint32_t INVALIDATE : 1;            /*!< [0..0] Writing a 1 to this bitfield invalidates the flash cache
                                                     contents.                                                                 */
      __IOM uint32_t RESET_STAT : 1;            /*!< [1..1] Writing a 1 to this bitfield will reset the cache monitor
                                                     statistics (DMON0-3, IMON0-3). Statistic gathering can
                                                     be paused/stopped by disabling the MONITOR_ENABLE bit in
                                                     CACHECFG, which will maintain the count values until the
                                                     stats are reset by writing this bitfield.                                 */
      __IOM uint32_t CACHE_READY : 1;           /*!< [2..2] Cache Ready Status. A value of 1 indicates the cache
                                                     is enabled and not processing an invalidate operation.                    */
      __IM  uint32_t            : 1;
      __IOM uint32_t FLASH0_SLM_STATUS : 1;     /*!< [4..4] Flash Sleep Mode Status. When 1, flash instance 0 is
                                                     asleep.                                                                   */
      __IOM uint32_t FLASH0_SLM_DISABLE : 1;    /*!< [5..5] Disable Flash Sleep Mode. Allows CPU to manually disable
                                                     SLM mode. Performing a flash read will also wake the array.               */
      __IOM uint32_t FLASH0_SLM_ENABLE : 1;     /*!< [6..6] Enable Flash Sleep Mode. After writing this bit, the
                                                     flash instance 0 will enter a low-power mode until the
                                                     CPU writes the SLM_DISABLE bit or a flash access occurs.
                                                     Wake from SLM requires ~5us, so this should only be set
                                                     if the flash will not be accessed for reasonably long time.               */
      __IM  uint32_t            : 1;
      __IOM uint32_t FLASH1_SLM_STATUS : 1;     /*!< [8..8] Flash Sleep Mode Status. When 1, flash instance 1 is
                                                     asleep.                                                                   */
      __IOM uint32_t FLASH1_SLM_DISABLE : 1;    /*!< [9..9] Disable Flash Sleep Mode. Allows CPU to manually disable
                                                     SLM mode. Performing a flash read will also wake the array.               */
      __IOM uint32_t FLASH1_SLM_ENABLE : 1;     /*!< [10..10] Enable Flash Sleep Mode. After writing this bit, the
                                                     flash instance 1 will enter a low-power mode until the
                                                     CPU writes the SLM_DISABLE bit or a flash access occurs.
                                                     Wake from SLM requires ~5us, so this should only be set
                                                     if the flash will not be accessed for reasonably long time.               */
    } CTRL_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t NCR0START;                   /*!< (@ 0x00000010) Flash Cache Noncachable Region 0 Start Address.            */

    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 16;           /*!< [19..4] Start address for non-cacheable region 0. The physical
                                                     address of the start of this region should be programmed
                                                     to this register and must be aligned to a 16-byte boundary
                                                     (thus the lower 4 address bits are unused).                               */
    } NCR0START_b;
  } ;

  union {
    __IOM uint32_t NCR0END;                     /*!< (@ 0x00000014) Flash Cache Noncachable Region 0 End                       */

    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 16;           /*!< [19..4] End address for non-cacheable region 0. The physical
                                                     address of the end of this region should be programmed
                                                     to this register and must be aligned to a 16-byte boundary
                                                     (thus the lower 4 address bits are unused).                               */
    } NCR0END_b;
  } ;

  union {
    __IOM uint32_t NCR1START;                   /*!< (@ 0x00000018) Flash Cache Noncachable Region 1 Start                     */

    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 16;           /*!< [19..4] Start address for non-cacheable region 1. The physical
                                                     address of the start of this region should be programmed
                                                     to this register and must be aligned to a 16-byte boundary
                                                     (thus the lower 4 address bits are unused).                               */
    } NCR1START_b;
  } ;

  union {
    __IOM uint32_t NCR1END;                     /*!< (@ 0x0000001C) Flash Cache Noncachable Region 1 End                       */

    struct {
      __IM  uint32_t            : 4;
      __IOM uint32_t ADDR       : 16;           /*!< [19..4] End address for non-cacheable region 1. The physical
                                                     address of the end of this region should be programmed
                                                     to this register and must be aligned to a 16-byte boundary
                                                     (thus the lower 4 address bits are unused).                               */
    } NCR1END_b;
  } ;
  __IM  uint32_t  RESERVED1[4];

  union {
    __IOM uint32_t CACHEMODE;                   /*!< (@ 0x00000030) Flash Cache Mode Register. Used to trim performance/power. */

    struct {
      __IOM uint32_t THROTTLE1  : 1;            /*!< [0..0] Disallow cache data RAM writes on tag RAM fill cycles.
                                                     Value should be left at zero for optimal performance.                     */
      __IOM uint32_t THROTTLE2  : 1;            /*!< [1..1] Disallow cache data RAM writes on tag RAM read cycles.
                                                     Value should be left at zero for optimal performance.                     */
      __IOM uint32_t THROTTLE3  : 1;            /*!< [2..2] Disallow cache data RAM writes on data RAM read cycles.
                                                     Value should be left at zero for optimal performance.                     */
      __IOM uint32_t THROTTLE4  : 1;            /*!< [3..3] Disallow Data RAM reads (from line hits) on tag RAM fill
                                                     cycles. Value should be left at zero for optimal performance.             */
      __IOM uint32_t THROTTLE5  : 1;            /*!< [4..4] Disallow Data RAM reads (from line hits) during lookup
                                                     read ops. Value should be left at zero for optimal performance.           */
      __IOM uint32_t THROTTLE6  : 1;            /*!< [5..5] Disallow Simultaneous Data RAM reads (from 2 line hits
                                                     on each bus). Value should be left at zero for optimal
                                                     performance.                                                              */
    } CACHEMODE_b;
  } ;
  __IM  uint32_t  RESERVED2[3];

  union {
    __IOM uint32_t DMON0;                       /*!< (@ 0x00000040) Data Cache Total Accesses                                  */

    struct {
      __IOM uint32_t DACCESS_COUNT : 32;        /*!< [31..0] Total accesses to data cache                                      */
    } DMON0_b;
  } ;

  union {
    __IOM uint32_t DMON1;                       /*!< (@ 0x00000044) Data Cache Tag Lookups                                     */

    struct {
      __IOM uint32_t DLOOKUP_COUNT : 32;        /*!< [31..0] Total tag lookups from data cache                                 */
    } DMON1_b;
  } ;

  union {
    __IOM uint32_t DMON2;                       /*!< (@ 0x00000048) Data Cache Hits                                            */

    struct {
      __IOM uint32_t DHIT_COUNT : 32;           /*!< [31..0] Cache hits from lookup operations                                 */
    } DMON2_b;
  } ;

  union {
    __IOM uint32_t DMON3;                       /*!< (@ 0x0000004C) Data Cache Line Hits                                       */

    struct {
      __IOM uint32_t DLINE_COUNT : 32;          /*!< [31..0] Cache hits from line cache                                        */
    } DMON3_b;
  } ;

  union {
    __IOM uint32_t IMON0;                       /*!< (@ 0x00000050) Instruction Cache Total Accesses                           */

    struct {
      __IOM uint32_t IACCESS_COUNT : 32;        /*!< [31..0] Total accesses to Instruction cache                               */
    } IMON0_b;
  } ;

  union {
    __IOM uint32_t IMON1;                       /*!< (@ 0x00000054) Instruction Cache Tag Lookups                              */

    struct {
      __IOM uint32_t ILOOKUP_COUNT : 32;        /*!< [31..0] Total tag lookups from Instruction cache                          */
    } IMON1_b;
  } ;

  union {
    __IOM uint32_t IMON2;                       /*!< (@ 0x00000058) Instruction Cache Hits                                     */

    struct {
      __IOM uint32_t IHIT_COUNT : 32;           /*!< [31..0] Cache hits from lookup operations                                 */
    } IMON2_b;
  } ;

  union {
    __IOM uint32_t IMON3;                       /*!< (@ 0x0000005C) Instruction Cache Line Hits                                */

    struct {
      __IOM uint32_t ILINE_COUNT : 32;          /*!< [31..0] Cache hits from line cache                                        */
    } IMON3_b;
  } ;
} CACHECTRL_Type;                               /*!< Size = 96 (0x60)                                                          */



/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Clock Generator (CLKGEN)
  */

typedef struct {                                /*!< (@ 0x40004000) CLKGEN Structure                                           */

  union {
    __IOM uint32_t CALXT;                       /*!< (@ 0x00000000) XT Oscillator Control                                      */

    struct {
      __IOM uint32_t CALXT      : 11;           /*!< [10..0] XT Oscillator calibration value                                   */
    } CALXT_b;
  } ;

  union {
    __IOM uint32_t CALRC;                       /*!< (@ 0x00000004) RC Oscillator Control                                      */

    struct {
      __IOM uint32_t CALRC      : 18;           /*!< [17..0] LFRC Oscillator calibration value                                 */
    } CALRC_b;
  } ;

  union {
    __IOM uint32_t ACALCTR;                     /*!< (@ 0x00000008) Autocalibration Counter                                    */

    struct {
      __IOM uint32_t ACALCTR    : 24;           /*!< [23..0] Autocalibration Counter result.                                   */
    } ACALCTR_b;
  } ;

  union {
    __IOM uint32_t OCTRL;                       /*!< (@ 0x0000000C) Oscillator Control                                         */

    struct {
      __IOM uint32_t STOPXT     : 1;            /*!< [0..0] Stop the XT Oscillator to the RTC                                  */
      __IOM uint32_t STOPRC     : 1;            /*!< [1..1] Stop the LFRC Oscillator to the RTC                                */
      __IM  uint32_t            : 4;
      __IOM uint32_t FOS        : 1;            /*!< [6..6] Oscillator switch on failure function                              */
      __IOM uint32_t OSEL       : 1;            /*!< [7..7] Selects the RTC oscillator (1 => LFRC, 0 => XT)                    */
      __IOM uint32_t ACAL       : 3;            /*!< [10..8] Autocalibration control                                           */
    } OCTRL_b;
  } ;

  union {
    __IOM uint32_t CLKOUT;                      /*!< (@ 0x00000010) CLKOUT Frequency Select                                    */

    struct {
      __IOM uint32_t CKSEL      : 6;            /*!< [5..0] CLKOUT signal select. Note that HIGH_DRIVE should be
                                                     selected if any high frequencies (such as from HFRC) are
                                                     selected for CLKOUT.                                                      */
      __IM  uint32_t            : 1;
      __IOM uint32_t CKEN       : 1;            /*!< [7..7] Enable the CLKOUT signal                                           */
    } CLKOUT_b;
  } ;

  union {
    __IOM uint32_t CLKKEY;                      /*!< (@ 0x00000014) Key Register for Clock Control Register                    */

    struct {
      __IOM uint32_t CLKKEY     : 32;           /*!< [31..0] Key register value.                                               */
    } CLKKEY_b;
  } ;

  union {
    __IOM uint32_t CCTRL;                       /*!< (@ 0x00000018) HFRC Clock Control                                         */

    struct {
      __IOM uint32_t CORESEL    : 1;            /*!< [0..0] Core Clock divisor                                                 */
    } CCTRL_b;
  } ;

  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x0000001C) Clock Generator Status                                     */

    struct {
      __IOM uint32_t OMODE      : 1;            /*!< [0..0] Current RTC oscillator (1 => LFRC, 0 => XT)                        */
      __IOM uint32_t OSCF       : 1;            /*!< [1..1] XT Oscillator is enabled but not oscillating                       */
    } STATUS_b;
  } ;

  union {
    __IOM uint32_t HFADJ;                       /*!< (@ 0x00000020) HFRC Adjustment                                            */

    struct {
      __IOM uint32_t HFADJEN    : 1;            /*!< [0..0] HFRC adjustment control                                            */
      __IOM uint32_t HFADJCK    : 3;            /*!< [3..1] Repeat period for HFRC adjustment                                  */
      __IM  uint32_t            : 4;
      __IOM uint32_t HFXTADJ    : 12;           /*!< [19..8] Target HFRC adjustment value.                                     */
      __IOM uint32_t HFWARMUP   : 1;            /*!< [20..20] XT warmup period for HFRC adjustment                             */
      __IOM uint32_t HFADJ_GAIN : 3;            /*!< [23..21] Gain control for HFRC adjustment                                 */
    } HFADJ_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t CLOCKEN;                     /*!< (@ 0x00000028) Clock Enable Status                                        */

    struct {
      __IOM uint32_t CLOCKEN    : 32;           /*!< [31..0] Clock enable status                                               */
    } CLOCKEN_b;
  } ;

  union {
    __IOM uint32_t CLOCKEN2;                    /*!< (@ 0x0000002C) Clock Enable Status                                        */

    struct {
      __IOM uint32_t CLOCKEN2   : 32;           /*!< [31..0] Clock enable status 2                                             */
    } CLOCKEN2_b;
  } ;

  union {
    __IOM uint32_t CLOCKEN3;                    /*!< (@ 0x00000030) Clock Enable Status                                        */

    struct {
      __IOM uint32_t CLOCKEN3   : 32;           /*!< [31..0] Clock enable status 3                                             */
    } CLOCKEN3_b;
  } ;

  union {
    __IOM uint32_t UARTEN;                      /*!< (@ 0x00000034) UART Enable                                                */

    struct {
      __IOM uint32_t UART0EN    : 2;            /*!< [1..0] UART0 system clock control                                         */
      __IM  uint32_t            : 6;
      __IOM uint32_t UART1EN    : 2;            /*!< [9..8] UART1 system clock control                                         */
    } UARTEN_b;
  } ;
  __IM  uint32_t  RESERVED1[50];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000100) CLKGEN Interrupt Register: Enable                          */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
      __IOM uint32_t ALM        : 1;            /*!< [3..3] RTC Alarm interrupt                                                */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000104) CLKGEN Interrupt Register: Status                          */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
      __IOM uint32_t ALM        : 1;            /*!< [3..3] RTC Alarm interrupt                                                */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000108) CLKGEN Interrupt Register: Clear                           */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
      __IOM uint32_t ALM        : 1;            /*!< [3..3] RTC Alarm interrupt                                                */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000010C) CLKGEN Interrupt Register: Set                             */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
      __IOM uint32_t ALM        : 1;            /*!< [3..3] RTC Alarm interrupt                                                */
    } INTSET_b;
  } ;
} CLKGEN_Type;                                  /*!< Size = 272 (0x110)                                                        */



/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Counter/Timer (CTIMER)
  */

typedef struct {                                /*!< (@ 0x40008000) CTIMER Structure                                           */

  union {
    __IOM uint32_t TMR0;                        /*!< (@ 0x00000000) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA0    : 16;           /*!< [15..0] Counter/Timer A0.                                                 */
      __IOM uint32_t CTTMRB0    : 16;           /*!< [31..16] Counter/Timer B0.                                                */
    } TMR0_b;
  } ;

  union {
    __IOM uint32_t CMPRA0;                      /*!< (@ 0x00000004) Counter/Timer A0 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A0    : 16;           /*!< [15..0] Counter/Timer A0 Compare Register 0. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR1A0    : 16;           /*!< [31..16] Counter/Timer A0 Compare Register 1. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRA0_b;
  } ;

  union {
    __IOM uint32_t CMPRB0;                      /*!< (@ 0x00000008) Counter/Timer B0 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B0    : 16;           /*!< [15..0] Counter/Timer B0 Compare Register 0. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR1B0    : 16;           /*!< [31..16] Counter/Timer B0 Compare Register 1. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRB0_b;
  } ;

  union {
    __IOM uint32_t CTRL0;                       /*!< (@ 0x0000000C) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA0EN    : 1;            /*!< [0..0] Counter/Timer A0 Enable bit.                                       */
      __IOM uint32_t TMRA0CLK   : 5;            /*!< [5..1] Counter/Timer A0 Clock Select.                                     */
      __IOM uint32_t TMRA0FN    : 3;            /*!< [8..6] Counter/Timer A0 Function Select.                                  */
      __IOM uint32_t TMRA0IE0   : 1;            /*!< [9..9] Counter/Timer A0 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA0IE1   : 1;            /*!< [10..10] Counter/Timer A0 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA0CLR   : 1;            /*!< [11..11] Counter/Timer A0 Clear bit.                                      */
      __IOM uint32_t TMRA0POL   : 1;            /*!< [12..12] Counter/Timer A0 output polarity.                                */
      __IOM uint32_t TMRA0PE    : 1;            /*!< [13..13] Counter/Timer A0 Output Enable bit.                              */
      __IM  uint32_t            : 2;
      __IOM uint32_t TMRB0EN    : 1;            /*!< [16..16] Counter/Timer B0 Enable bit.                                     */
      __IOM uint32_t TMRB0CLK   : 5;            /*!< [21..17] Counter/Timer B0 Clock Select.                                   */
      __IOM uint32_t TMRB0FN    : 3;            /*!< [24..22] Counter/Timer B0 Function Select.                                */
      __IOM uint32_t TMRB0IE0   : 1;            /*!< [25..25] Counter/Timer B0 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB0IE1   : 1;            /*!< [26..26] Counter/Timer B0 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB0CLR   : 1;            /*!< [27..27] Counter/Timer B0 Clear bit.                                      */
      __IOM uint32_t TMRB0POL   : 1;            /*!< [28..28] Counter/Timer B0 output polarity.                                */
      __IOM uint32_t TMRB0PE    : 1;            /*!< [29..29] Counter/Timer B0 Output Enable bit.                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTLINK0    : 1;            /*!< [31..31] Counter/Timer A0/B0 Link bit.                                    */
    } CTRL0_b;
  } ;

  union {
    __IOM uint32_t TMR1;                        /*!< (@ 0x00000010) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA1    : 16;           /*!< [15..0] Counter/Timer A1.                                                 */
      __IOM uint32_t CTTMRB1    : 16;           /*!< [31..16] Counter/Timer B1.                                                */
    } TMR1_b;
  } ;

  union {
    __IOM uint32_t CMPRA1;                      /*!< (@ 0x00000014) Counter/Timer A1 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A1    : 16;           /*!< [15..0] Counter/Timer A1 Compare Register 0.                              */
      __IOM uint32_t CMPR1A1    : 16;           /*!< [31..16] Counter/Timer A1 Compare Register 1.                             */
    } CMPRA1_b;
  } ;

  union {
    __IOM uint32_t CMPRB1;                      /*!< (@ 0x00000018) Counter/Timer B1 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B1    : 16;           /*!< [15..0] Counter/Timer B1 Compare Register 0.                              */
      __IOM uint32_t CMPR1B1    : 16;           /*!< [31..16] Counter/Timer B1 Compare Register 1.                             */
    } CMPRB1_b;
  } ;

  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x0000001C) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA1EN    : 1;            /*!< [0..0] Counter/Timer A1 Enable bit.                                       */
      __IOM uint32_t TMRA1CLK   : 5;            /*!< [5..1] Counter/Timer A1 Clock Select.                                     */
      __IOM uint32_t TMRA1FN    : 3;            /*!< [8..6] Counter/Timer A1 Function Select.                                  */
      __IOM uint32_t TMRA1IE0   : 1;            /*!< [9..9] Counter/Timer A1 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA1IE1   : 1;            /*!< [10..10] Counter/Timer A1 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA1CLR   : 1;            /*!< [11..11] Counter/Timer A1 Clear bit.                                      */
      __IOM uint32_t TMRA1POL   : 1;            /*!< [12..12] Counter/Timer A1 output polarity.                                */
      __IOM uint32_t TMRA1PE    : 1;            /*!< [13..13] Counter/Timer A1 Output Enable bit.                              */
      __IM  uint32_t            : 2;
      __IOM uint32_t TMRB1EN    : 1;            /*!< [16..16] Counter/Timer B1 Enable bit.                                     */
      __IOM uint32_t TMRB1CLK   : 5;            /*!< [21..17] Counter/Timer B1 Clock Select.                                   */
      __IOM uint32_t TMRB1FN    : 3;            /*!< [24..22] Counter/Timer B1 Function Select.                                */
      __IOM uint32_t TMRB1IE0   : 1;            /*!< [25..25] Counter/Timer B1 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB1IE1   : 1;            /*!< [26..26] Counter/Timer B1 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB1CLR   : 1;            /*!< [27..27] Counter/Timer B1 Clear bit.                                      */
      __IOM uint32_t TMRB1POL   : 1;            /*!< [28..28] Counter/Timer B1 output polarity.                                */
      __IOM uint32_t TMRB1PE    : 1;            /*!< [29..29] Counter/Timer B1 Output Enable bit.                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTLINK1    : 1;            /*!< [31..31] Counter/Timer A1/B1 Link bit.                                    */
    } CTRL1_b;
  } ;

  union {
    __IOM uint32_t TMR2;                        /*!< (@ 0x00000020) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA2    : 16;           /*!< [15..0] Counter/Timer A2.                                                 */
      __IOM uint32_t CTTMRB2    : 16;           /*!< [31..16] Counter/Timer B2.                                                */
    } TMR2_b;
  } ;

  union {
    __IOM uint32_t CMPRA2;                      /*!< (@ 0x00000024) Counter/Timer A2 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A2    : 16;           /*!< [15..0] Counter/Timer A2 Compare Register 0.                              */
      __IOM uint32_t CMPR1A2    : 16;           /*!< [31..16] Counter/Timer A2 Compare Register 1.                             */
    } CMPRA2_b;
  } ;

  union {
    __IOM uint32_t CMPRB2;                      /*!< (@ 0x00000028) Counter/Timer B2 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B2    : 16;           /*!< [15..0] Counter/Timer B2 Compare Register 0.                              */
      __IOM uint32_t CMPR1B2    : 16;           /*!< [31..16] Counter/Timer B2 Compare Register 1.                             */
    } CMPRB2_b;
  } ;

  union {
    __IOM uint32_t CTRL2;                       /*!< (@ 0x0000002C) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA2EN    : 1;            /*!< [0..0] Counter/Timer A2 Enable bit.                                       */
      __IOM uint32_t TMRA2CLK   : 5;            /*!< [5..1] Counter/Timer A2 Clock Select.                                     */
      __IOM uint32_t TMRA2FN    : 3;            /*!< [8..6] Counter/Timer A2 Function Select.                                  */
      __IOM uint32_t TMRA2IE0   : 1;            /*!< [9..9] Counter/Timer A2 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA2IE1   : 1;            /*!< [10..10] Counter/Timer A2 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA2CLR   : 1;            /*!< [11..11] Counter/Timer A2 Clear bit.                                      */
      __IOM uint32_t TMRA2POL   : 1;            /*!< [12..12] Counter/Timer A2 output polarity.                                */
      __IOM uint32_t TMRA2PE    : 1;            /*!< [13..13] Counter/Timer A2 Output Enable bit.                              */
      __IM  uint32_t            : 2;
      __IOM uint32_t TMRB2EN    : 1;            /*!< [16..16] Counter/Timer B2 Enable bit.                                     */
      __IOM uint32_t TMRB2CLK   : 5;            /*!< [21..17] Counter/Timer B2 Clock Select.                                   */
      __IOM uint32_t TMRB2FN    : 3;            /*!< [24..22] Counter/Timer B2 Function Select.                                */
      __IOM uint32_t TMRB2IE0   : 1;            /*!< [25..25] Counter/Timer B2 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB2IE1   : 1;            /*!< [26..26] Counter/Timer B2 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB2CLR   : 1;            /*!< [27..27] Counter/Timer B2 Clear bit.                                      */
      __IOM uint32_t TMRB2POL   : 1;            /*!< [28..28] Counter/Timer B2 output polarity.                                */
      __IOM uint32_t TMRB2PE    : 1;            /*!< [29..29] Counter/Timer B2 Output Enable bit.                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTLINK2    : 1;            /*!< [31..31] Counter/Timer A2/B2 Link bit.                                    */
    } CTRL2_b;
  } ;

  union {
    __IOM uint32_t TMR3;                        /*!< (@ 0x00000030) Counter/Timer Register                                     */

    struct {
      __IOM uint32_t CTTMRA3    : 16;           /*!< [15..0] Counter/Timer A3.                                                 */
      __IOM uint32_t CTTMRB3    : 16;           /*!< [31..16] Counter/Timer B3.                                                */
    } TMR3_b;
  } ;

  union {
    __IOM uint32_t CMPRA3;                      /*!< (@ 0x00000034) Counter/Timer A3 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0A3    : 16;           /*!< [15..0] Counter/Timer A3 Compare Register 0.                              */
      __IOM uint32_t CMPR1A3    : 16;           /*!< [31..16] Counter/Timer A3 Compare Register 1.                             */
    } CMPRA3_b;
  } ;

  union {
    __IOM uint32_t CMPRB3;                      /*!< (@ 0x00000038) Counter/Timer B3 Compare Registers                         */

    struct {
      __IOM uint32_t CMPR0B3    : 16;           /*!< [15..0] Counter/Timer B3 Compare Register 0.                              */
      __IOM uint32_t CMPR1B3    : 16;           /*!< [31..16] Counter/Timer B3 Compare Register 1.                             */
    } CMPRB3_b;
  } ;

  union {
    __IOM uint32_t CTRL3;                       /*!< (@ 0x0000003C) Counter/Timer Control                                      */

    struct {
      __IOM uint32_t TMRA3EN    : 1;            /*!< [0..0] Counter/Timer A3 Enable bit.                                       */
      __IOM uint32_t TMRA3CLK   : 5;            /*!< [5..1] Counter/Timer A3 Clock Select.                                     */
      __IOM uint32_t TMRA3FN    : 3;            /*!< [8..6] Counter/Timer A3 Function Select.                                  */
      __IOM uint32_t TMRA3IE0   : 1;            /*!< [9..9] Counter/Timer A3 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA3IE1   : 1;            /*!< [10..10] Counter/Timer A3 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA3CLR   : 1;            /*!< [11..11] Counter/Timer A3 Clear bit.                                      */
      __IOM uint32_t TMRA3POL   : 1;            /*!< [12..12] Counter/Timer A3 output polarity.                                */
      __IOM uint32_t TMRA3PE    : 1;            /*!< [13..13] Counter/Timer A3 Output Enable bit.                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t ADCEN      : 1;            /*!< [15..15] Special Timer A3 enable for ADC function.                        */
      __IOM uint32_t TMRB3EN    : 1;            /*!< [16..16] Counter/Timer B3 Enable bit.                                     */
      __IOM uint32_t TMRB3CLK   : 5;            /*!< [21..17] Counter/Timer B3 Clock Select.                                   */
      __IOM uint32_t TMRB3FN    : 3;            /*!< [24..22] Counter/Timer B3 Function Select.                                */
      __IOM uint32_t TMRB3IE0   : 1;            /*!< [25..25] Counter/Timer B3 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB3IE1   : 1;            /*!< [26..26] Counter/Timer B3 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB3CLR   : 1;            /*!< [27..27] Counter/Timer B3 Clear bit.                                      */
      __IOM uint32_t TMRB3POL   : 1;            /*!< [28..28] Counter/Timer B3 output polarity.                                */
      __IOM uint32_t TMRB3PE    : 1;            /*!< [29..29] Counter/Timer B3 Output Enable bit.                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTLINK3    : 1;            /*!< [31..31] Counter/Timer A3/B3 Link bit.                                    */
    } CTRL3_b;
  } ;
  __IM  uint32_t  RESERVED[48];

  union {
    __IOM uint32_t STCFG;                       /*!< (@ 0x00000100) Configuration Register                                     */

    struct {
      __IOM uint32_t CLKSEL     : 4;            /*!< [3..0] Selects an appropriate clock source and divider to use
                                                     for the System Timer clock.                                               */
      __IM  uint32_t            : 4;
      __IOM uint32_t COMPARE_A_EN : 1;          /*!< [8..8] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_B_EN : 1;          /*!< [9..9] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_C_EN : 1;          /*!< [10..10] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_D_EN : 1;          /*!< [11..11] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_E_EN : 1;          /*!< [12..12] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_F_EN : 1;          /*!< [13..13] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_G_EN : 1;          /*!< [14..14] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IOM uint32_t COMPARE_H_EN : 1;          /*!< [15..15] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparision is met.                                       */
      __IM  uint32_t            : 14;
      __IOM uint32_t CLEAR      : 1;            /*!< [30..30] Set this bit to one to clear the System Timer register.
                                                     If this bit is set to '1', the system timer register will
                                                     stay cleared. It needs to be set to '0' for the system
                                                     timer to start running.                                                   */
      __IOM uint32_t FREEZE     : 1;            /*!< [31..31] Set this bit to one to freeze the clock input to the
                                                     COUNTER register. Once frozen, the value can be safely
                                                     written from the MCU. Unfreeze to resume.                                 */
    } STCFG_b;
  } ;

  union {
    __IOM uint32_t STTMR;                       /*!< (@ 0x00000104) System Timer Count Register (Real Time Counter)            */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } STTMR_b;
  } ;

  union {
    __IOM uint32_t CAPTURE_CONTROL;             /*!< (@ 0x00000108) Capture Control Register                                   */

    struct {
      __IOM uint32_t CAPTURE_A  : 1;            /*!< [0..0] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
      __IOM uint32_t CAPTURE_B  : 1;            /*!< [1..1] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
      __IOM uint32_t CAPTURE_C  : 1;            /*!< [2..2] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
      __IOM uint32_t CAPTURE_D  : 1;            /*!< [3..3] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
    } CAPTURE_CONTROL_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t SCMPR0;                      /*!< (@ 0x00000110) Compare Register A                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_A_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR0_b;
  } ;

  union {
    __IOM uint32_t SCMPR1;                      /*!< (@ 0x00000114) Compare Register B                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_B_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR1_b;
  } ;

  union {
    __IOM uint32_t SCMPR2;                      /*!< (@ 0x00000118) Compare Register C                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_C_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR2_b;
  } ;

  union {
    __IOM uint32_t SCMPR3;                      /*!< (@ 0x0000011C) Compare Register D                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_D_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR3_b;
  } ;

  union {
    __IOM uint32_t SCMPR4;                      /*!< (@ 0x00000120) Compare Register E                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_E_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR4_b;
  } ;

  union {
    __IOM uint32_t SCMPR5;                      /*!< (@ 0x00000124) Compare Register F                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_F_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR5_b;
  } ;

  union {
    __IOM uint32_t SCMPR6;                      /*!< (@ 0x00000128) Compare Register G                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_G_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR6_b;
  } ;

  union {
    __IOM uint32_t SCMPR7;                      /*!< (@ 0x0000012C) Compare Register H                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_H_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR7_b;
  } ;
  __IM  uint32_t  RESERVED2[44];

  union {
    __IOM uint32_t SCAPT0;                      /*!< (@ 0x000001E0) Capture Register A                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT0_b;
  } ;

  union {
    __IOM uint32_t SCAPT1;                      /*!< (@ 0x000001E4) Capture Register B                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT1_b;
  } ;

  union {
    __IOM uint32_t SCAPT2;                      /*!< (@ 0x000001E8) Capture Register C                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT2_b;
  } ;

  union {
    __IOM uint32_t SCAPT3;                      /*!< (@ 0x000001EC) Capture Register D                                         */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT3_b;
  } ;

  union {
    __IOM uint32_t SNVR0;                       /*!< (@ 0x000001F0) System Timer NVRAM_A Register                              */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR0_b;
  } ;

  union {
    __IOM uint32_t SNVR1;                       /*!< (@ 0x000001F4) System Timer NVRAM_B Register                              */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR1_b;
  } ;

  union {
    __IOM uint32_t SNVR2;                       /*!< (@ 0x000001F8) System Timer NVRAM_C Register                              */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR2_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Counter/Timer Interrupts: Enable                           */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [8..8] Counter/Timer A0 interrupt based on COMPR1.                        */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [9..9] Counter/Timer B0 interrupt based on COMPR1.                        */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [10..10] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [11..11] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [12..12] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [13..13] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [14..14] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [15..15] Counter/Timer B3 interrupt based on COMPR1.                      */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Counter/Timer Interrupts: Status                           */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [8..8] Counter/Timer A0 interrupt based on COMPR1.                        */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [9..9] Counter/Timer B0 interrupt based on COMPR1.                        */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [10..10] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [11..11] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [12..12] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [13..13] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [14..14] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [15..15] Counter/Timer B3 interrupt based on COMPR1.                      */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Counter/Timer Interrupts: Clear                            */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [8..8] Counter/Timer A0 interrupt based on COMPR1.                        */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [9..9] Counter/Timer B0 interrupt based on COMPR1.                        */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [10..10] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [11..11] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [12..12] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [13..13] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [14..14] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [15..15] Counter/Timer B3 interrupt based on COMPR1.                      */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Counter/Timer Interrupts: Set                              */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [8..8] Counter/Timer A0 interrupt based on COMPR1.                        */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [9..9] Counter/Timer B0 interrupt based on COMPR1.                        */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [10..10] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [11..11] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [12..12] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [13..13] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [14..14] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [15..15] Counter/Timer B3 interrupt based on COMPR1.                      */
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED4[60];

  union {
    __IOM uint32_t STMINTEN;                    /*!< (@ 0x00000300) STIMER Interrupt registers: Enable                         */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
    } STMINTEN_b;
  } ;

  union {
    __IOM uint32_t STMINTSTAT;                  /*!< (@ 0x00000304) STIMER Interrupt registers: Status                         */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
    } STMINTSTAT_b;
  } ;

  union {
    __IOM uint32_t STMINTCLR;                   /*!< (@ 0x00000308) STIMER Interrupt registers: Clear                          */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
    } STMINTCLR_b;
  } ;

  union {
    __IOM uint32_t STMINTSET;                   /*!< (@ 0x0000030C) STIMER Interrupt registers: Set                            */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
    } STMINTSET_b;
  } ;
} CTIMER_Type;                                  /*!< Size = 784 (0x310)                                                        */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose IO (GPIO)
  */

typedef struct {                                /*!< (@ 0x40010000) GPIO Structure                                             */

  union {
    __IOM uint32_t PADREGA;                     /*!< (@ 0x00000000) Pad Configuration Register A                               */

    struct {
      __IOM uint32_t PAD0PULL   : 1;            /*!< [0..0] Pad 0 pullup enable                                                */
      __IOM uint32_t PAD0INPEN  : 1;            /*!< [1..1] Pad 0 input enable                                                 */
      __IOM uint32_t PAD0STRNG  : 1;            /*!< [2..2] Pad 0 drive strength                                               */
      __IOM uint32_t PAD0FNCSEL : 3;            /*!< [5..3] Pad 0 function select                                              */
      __IOM uint32_t PAD0RSEL   : 2;            /*!< [7..6] Pad 0 pullup resistor selection.                                   */
      __IOM uint32_t PAD1PULL   : 1;            /*!< [8..8] Pad 1 pullup enable                                                */
      __IOM uint32_t PAD1INPEN  : 1;            /*!< [9..9] Pad 1 input enable                                                 */
      __IOM uint32_t PAD1STRNG  : 1;            /*!< [10..10] Pad 1 drive strength                                             */
      __IOM uint32_t PAD1FNCSEL : 3;            /*!< [13..11] Pad 1 function select                                            */
      __IOM uint32_t PAD1RSEL   : 2;            /*!< [15..14] Pad 1 pullup resistor selection.                                 */
      __IOM uint32_t PAD2PULL   : 1;            /*!< [16..16] Pad 2 pullup enable                                              */
      __IOM uint32_t PAD2INPEN  : 1;            /*!< [17..17] Pad 2 input enable                                               */
      __IOM uint32_t PAD2STRNG  : 1;            /*!< [18..18] Pad 2 drive strength                                             */
      __IOM uint32_t PAD2FNCSEL : 3;            /*!< [21..19] Pad 2 function select                                            */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD3PULL   : 1;            /*!< [24..24] Pad 3 pullup enable                                              */
      __IOM uint32_t PAD3INPEN  : 1;            /*!< [25..25] Pad 3 input enable.                                              */
      __IOM uint32_t PAD3STRNG  : 1;            /*!< [26..26] Pad 3 drive strength.                                            */
      __IOM uint32_t PAD3FNCSEL : 3;            /*!< [29..27] Pad 3 function select                                            */
    } PADREGA_b;
  } ;

  union {
    __IOM uint32_t PADREGB;                     /*!< (@ 0x00000004) Pad Configuration Register B                               */

    struct {
      __IOM uint32_t PAD4PULL   : 1;            /*!< [0..0] Pad 4 pullup enable                                                */
      __IOM uint32_t PAD4INPEN  : 1;            /*!< [1..1] Pad 4 input enable                                                 */
      __IOM uint32_t PAD4STRNG  : 1;            /*!< [2..2] Pad 4 drive strength                                               */
      __IOM uint32_t PAD4FNCSEL : 3;            /*!< [5..3] Pad 4 function select                                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD4PWRDN  : 1;            /*!< [7..7] Pad 4 VSS power switch enable                                      */
      __IOM uint32_t PAD5PULL   : 1;            /*!< [8..8] Pad 5 pullup enable                                                */
      __IOM uint32_t PAD5INPEN  : 1;            /*!< [9..9] Pad 5 input enable                                                 */
      __IOM uint32_t PAD5STRNG  : 1;            /*!< [10..10] Pad 5 drive strength                                             */
      __IOM uint32_t PAD5FNCSEL : 3;            /*!< [13..11] Pad 5 function select                                            */
      __IOM uint32_t PAD5RSEL   : 2;            /*!< [15..14] Pad 5 pullup resistor selection.                                 */
      __IOM uint32_t PAD6PULL   : 1;            /*!< [16..16] Pad 6 pullup enable                                              */
      __IOM uint32_t PAD6INPEN  : 1;            /*!< [17..17] Pad 6 input enable                                               */
      __IOM uint32_t PAD6STRNG  : 1;            /*!< [18..18] Pad 6 drive strength                                             */
      __IOM uint32_t PAD6FNCSEL : 3;            /*!< [21..19] Pad 6 function select                                            */
      __IOM uint32_t PAD6RSEL   : 2;            /*!< [23..22] Pad 6 pullup resistor selection.                                 */
      __IOM uint32_t PAD7PULL   : 1;            /*!< [24..24] Pad 7 pullup enable                                              */
      __IOM uint32_t PAD7INPEN  : 1;            /*!< [25..25] Pad 7 input enable                                               */
      __IOM uint32_t PAD7STRNG  : 1;            /*!< [26..26] Pad 7 drive strength                                             */
      __IOM uint32_t PAD7FNCSEL : 3;            /*!< [29..27] Pad 7 function select                                            */
    } PADREGB_b;
  } ;

  union {
    __IOM uint32_t PADREGC;                     /*!< (@ 0x00000008) Pad Configuration Register C                               */

    struct {
      __IOM uint32_t PAD8PULL   : 1;            /*!< [0..0] Pad 8 pullup enable                                                */
      __IOM uint32_t PAD8INPEN  : 1;            /*!< [1..1] Pad 8 input enable                                                 */
      __IOM uint32_t PAD8STRNG  : 1;            /*!< [2..2] Pad 8 drive strength                                               */
      __IOM uint32_t PAD8FNCSEL : 3;            /*!< [5..3] Pad 8 function select                                              */
      __IOM uint32_t PAD8RSEL   : 2;            /*!< [7..6] Pad 8 pullup resistor selection.                                   */
      __IOM uint32_t PAD9PULL   : 1;            /*!< [8..8] Pad 9 pullup enable                                                */
      __IOM uint32_t PAD9INPEN  : 1;            /*!< [9..9] Pad 9 input enable                                                 */
      __IOM uint32_t PAD9STRNG  : 1;            /*!< [10..10] Pad 9 drive strength                                             */
      __IOM uint32_t PAD9FNCSEL : 3;            /*!< [13..11] Pad 9 function select                                            */
      __IOM uint32_t PAD9RSEL   : 2;            /*!< [15..14] Pad 9 pullup resistor selection                                  */
      __IOM uint32_t PAD10PULL  : 1;            /*!< [16..16] Pad 10 pullup enable                                             */
      __IOM uint32_t PAD10INPEN : 1;            /*!< [17..17] Pad 10 input enable                                              */
      __IOM uint32_t PAD10STRNG : 1;            /*!< [18..18] Pad 10 drive strength                                            */
      __IOM uint32_t PAD10FNCSEL : 3;           /*!< [21..19] Pad 10 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD11PULL  : 1;            /*!< [24..24] Pad 11 pullup enable                                             */
      __IOM uint32_t PAD11INPEN : 1;            /*!< [25..25] Pad 11 input enable                                              */
      __IOM uint32_t PAD11STRNG : 1;            /*!< [26..26] Pad 11 drive strength                                            */
      __IOM uint32_t PAD11FNCSEL : 3;           /*!< [29..27] Pad 11 function select                                           */
    } PADREGC_b;
  } ;

  union {
    __IOM uint32_t PADREGD;                     /*!< (@ 0x0000000C) Pad Configuration Register D                               */

    struct {
      __IOM uint32_t PAD12PULL  : 1;            /*!< [0..0] Pad 12 pullup enable                                               */
      __IOM uint32_t PAD12INPEN : 1;            /*!< [1..1] Pad 12 input enable                                                */
      __IOM uint32_t PAD12STRNG : 1;            /*!< [2..2] Pad 12 drive strength                                              */
      __IOM uint32_t PAD12FNCSEL : 3;           /*!< [5..3] Pad 12 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD13PULL  : 1;            /*!< [8..8] Pad 13 pullup enable                                               */
      __IOM uint32_t PAD13INPEN : 1;            /*!< [9..9] Pad 13 input enable                                                */
      __IOM uint32_t PAD13STRNG : 1;            /*!< [10..10] Pad 13 drive strength                                            */
      __IOM uint32_t PAD13FNCSEL : 3;           /*!< [13..11] Pad 13 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD14PULL  : 1;            /*!< [16..16] Pad 14 pullup enable                                             */
      __IOM uint32_t PAD14INPEN : 1;            /*!< [17..17] Pad 14 input enable                                              */
      __IOM uint32_t PAD14STRNG : 1;            /*!< [18..18] Pad 14 drive strength                                            */
      __IOM uint32_t PAD14FNCSEL : 3;           /*!< [21..19] Pad 14 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD15PULL  : 1;            /*!< [24..24] Pad 15 pullup enable                                             */
      __IOM uint32_t PAD15INPEN : 1;            /*!< [25..25] Pad 15 input enable                                              */
      __IOM uint32_t PAD15STRNG : 1;            /*!< [26..26] Pad 15 drive strength                                            */
      __IOM uint32_t PAD15FNCSEL : 3;           /*!< [29..27] Pad 15 function select                                           */
    } PADREGD_b;
  } ;

  union {
    __IOM uint32_t PADREGE;                     /*!< (@ 0x00000010) Pad Configuration Register E                               */

    struct {
      __IOM uint32_t PAD16PULL  : 1;            /*!< [0..0] Pad 16 pullup enable                                               */
      __IOM uint32_t PAD16INPEN : 1;            /*!< [1..1] Pad 16 input enable                                                */
      __IOM uint32_t PAD16STRNG : 1;            /*!< [2..2] Pad 16 drive strength                                              */
      __IOM uint32_t PAD16FNCSEL : 3;           /*!< [5..3] Pad 16 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD17PULL  : 1;            /*!< [8..8] Pad 17 pullup enable                                               */
      __IOM uint32_t PAD17INPEN : 1;            /*!< [9..9] Pad 17 input enable                                                */
      __IOM uint32_t PAD17STRNG : 1;            /*!< [10..10] Pad 17 drive strength                                            */
      __IOM uint32_t PAD17FNCSEL : 3;           /*!< [13..11] Pad 17 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD18PULL  : 1;            /*!< [16..16] Pad 18 pullup enable                                             */
      __IOM uint32_t PAD18INPEN : 1;            /*!< [17..17] Pad 18 input enable                                              */
      __IOM uint32_t PAD18STRNG : 1;            /*!< [18..18] Pad 18 drive strength                                            */
      __IOM uint32_t PAD18FNCSEL : 3;           /*!< [21..19] Pad 18 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD19PULL  : 1;            /*!< [24..24] Pad 19 pullup enable                                             */
      __IOM uint32_t PAD19INPEN : 1;            /*!< [25..25] Pad 19 input enable                                              */
      __IOM uint32_t PAD19STRNG : 1;            /*!< [26..26] Pad 19 drive strength                                            */
      __IOM uint32_t PAD19FNCSEL : 3;           /*!< [29..27] Pad 19 function select                                           */
    } PADREGE_b;
  } ;

  union {
    __IOM uint32_t PADREGF;                     /*!< (@ 0x00000014) Pad Configuration Register F                               */

    struct {
      __IOM uint32_t PAD20PULL  : 1;            /*!< [0..0] Pad 20 pulldown enable                                             */
      __IOM uint32_t PAD20INPEN : 1;            /*!< [1..1] Pad 20 input enable                                                */
      __IOM uint32_t PAD20STRNG : 1;            /*!< [2..2] Pad 20 drive strength                                              */
      __IOM uint32_t PAD20FNCSEL : 3;           /*!< [5..3] Pad 20 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD21PULL  : 1;            /*!< [8..8] Pad 21 pullup enable                                               */
      __IOM uint32_t PAD21INPEN : 1;            /*!< [9..9] Pad 21 input enable                                                */
      __IOM uint32_t PAD21STRNG : 1;            /*!< [10..10] Pad 21 drive strength                                            */
      __IOM uint32_t PAD21FNCSEL : 3;           /*!< [13..11] Pad 21 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD22PULL  : 1;            /*!< [16..16] Pad 22 pullup enable                                             */
      __IOM uint32_t PAD22INPEN : 1;            /*!< [17..17] Pad 22 input enable                                              */
      __IOM uint32_t PAD22STRNG : 1;            /*!< [18..18] Pad 22 drive strength                                            */
      __IOM uint32_t PAD22FNCSEL : 3;           /*!< [21..19] Pad 22 function select                                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD22PWRUP : 1;            /*!< [23..23] Pad 22 upper power switch enable                                 */
      __IOM uint32_t PAD23PULL  : 1;            /*!< [24..24] Pad 23 pullup enable                                             */
      __IOM uint32_t PAD23INPEN : 1;            /*!< [25..25] Pad 23 input enable                                              */
      __IOM uint32_t PAD23STRNG : 1;            /*!< [26..26] Pad 23 drive strength                                            */
      __IOM uint32_t PAD23FNCSEL : 3;           /*!< [29..27] Pad 23 function select                                           */
    } PADREGF_b;
  } ;

  union {
    __IOM uint32_t PADREGG;                     /*!< (@ 0x00000018) Pad Configuration Register G                               */

    struct {
      __IOM uint32_t PAD24PULL  : 1;            /*!< [0..0] Pad 24 pullup enable                                               */
      __IOM uint32_t PAD24INPEN : 1;            /*!< [1..1] Pad 24 input enable                                                */
      __IOM uint32_t PAD24STRNG : 1;            /*!< [2..2] Pad 24 drive strength                                              */
      __IOM uint32_t PAD24FNCSEL : 3;           /*!< [5..3] Pad 24 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD25PULL  : 1;            /*!< [8..8] Pad 25 pullup enable                                               */
      __IOM uint32_t PAD25INPEN : 1;            /*!< [9..9] Pad 25 input enable                                                */
      __IOM uint32_t PAD25STRNG : 1;            /*!< [10..10] Pad 25 drive strength                                            */
      __IOM uint32_t PAD25FNCSEL : 3;           /*!< [13..11] Pad 25 function select                                           */
      __IOM uint32_t PAD25RSEL  : 2;            /*!< [15..14] Pad 25 pullup resistor selection.                                */
      __IOM uint32_t PAD26PULL  : 1;            /*!< [16..16] Pad 26 pullup enable                                             */
      __IOM uint32_t PAD26INPEN : 1;            /*!< [17..17] Pad 26 input enable                                              */
      __IOM uint32_t PAD26STRNG : 1;            /*!< [18..18] Pad 26 drive strength                                            */
      __IOM uint32_t PAD26FNCSEL : 3;           /*!< [21..19] Pad 26 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD27PULL  : 1;            /*!< [24..24] Pad 27 pullup enable                                             */
      __IOM uint32_t PAD27INPEN : 1;            /*!< [25..25] Pad 27 input enable                                              */
      __IOM uint32_t PAD27STRNG : 1;            /*!< [26..26] Pad 27 drive strength                                            */
      __IOM uint32_t PAD27FNCSEL : 3;           /*!< [29..27] Pad 27 function select                                           */
      __IOM uint32_t PAD27RSEL  : 2;            /*!< [31..30] Pad 27 pullup resistor selection.                                */
    } PADREGG_b;
  } ;

  union {
    __IOM uint32_t PADREGH;                     /*!< (@ 0x0000001C) Pad Configuration Register H                               */

    struct {
      __IOM uint32_t PAD28PULL  : 1;            /*!< [0..0] Pad 28 pullup enable                                               */
      __IOM uint32_t PAD28INPEN : 1;            /*!< [1..1] Pad 28 input enable                                                */
      __IOM uint32_t PAD28STRNG : 1;            /*!< [2..2] Pad 28 drive strength                                              */
      __IOM uint32_t PAD28FNCSEL : 3;           /*!< [5..3] Pad 28 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD29PULL  : 1;            /*!< [8..8] Pad 29 pullup enable                                               */
      __IOM uint32_t PAD29INPEN : 1;            /*!< [9..9] Pad 29 input enable                                                */
      __IOM uint32_t PAD29STRNG : 1;            /*!< [10..10] Pad 29 drive strength                                            */
      __IOM uint32_t PAD29FNCSEL : 3;           /*!< [13..11] Pad 29 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD30PULL  : 1;            /*!< [16..16] Pad 30 pullup enable                                             */
      __IOM uint32_t PAD30INPEN : 1;            /*!< [17..17] Pad 30 input enable                                              */
      __IOM uint32_t PAD30STRNG : 1;            /*!< [18..18] Pad 30 drive strength                                            */
      __IOM uint32_t PAD30FNCSEL : 3;           /*!< [21..19] Pad 30 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD31PULL  : 1;            /*!< [24..24] Pad 31 pullup enable                                             */
      __IOM uint32_t PAD31INPEN : 1;            /*!< [25..25] Pad 31 input enable                                              */
      __IOM uint32_t PAD31STRNG : 1;            /*!< [26..26] Pad 31 drive strength                                            */
      __IOM uint32_t PAD31FNCSEL : 3;           /*!< [29..27] Pad 31 function select                                           */
    } PADREGH_b;
  } ;

  union {
    __IOM uint32_t PADREGI;                     /*!< (@ 0x00000020) Pad Configuration Register I                               */

    struct {
      __IOM uint32_t PAD32PULL  : 1;            /*!< [0..0] Pad 32 pullup enable                                               */
      __IOM uint32_t PAD32INPEN : 1;            /*!< [1..1] Pad 32 input enable                                                */
      __IOM uint32_t PAD32STRNG : 1;            /*!< [2..2] Pad 32 drive strength                                              */
      __IOM uint32_t PAD32FNCSEL : 3;           /*!< [5..3] Pad 32 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD33PULL  : 1;            /*!< [8..8] Pad 33 pullup enable                                               */
      __IOM uint32_t PAD33INPEN : 1;            /*!< [9..9] Pad 33 input enable                                                */
      __IOM uint32_t PAD33STRNG : 1;            /*!< [10..10] Pad 33 drive strength                                            */
      __IOM uint32_t PAD33FNCSEL : 3;           /*!< [13..11] Pad 33 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD34PULL  : 1;            /*!< [16..16] Pad 34 pullup enable                                             */
      __IOM uint32_t PAD34INPEN : 1;            /*!< [17..17] Pad 34 input enable                                              */
      __IOM uint32_t PAD34STRNG : 1;            /*!< [18..18] Pad 34 drive strength                                            */
      __IOM uint32_t PAD34FNCSEL : 3;           /*!< [21..19] Pad 34 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD35PULL  : 1;            /*!< [24..24] Pad 35 pullup enable                                             */
      __IOM uint32_t PAD35INPEN : 1;            /*!< [25..25] Pad 35 input enable                                              */
      __IOM uint32_t PAD35STRNG : 1;            /*!< [26..26] Pad 35 drive strength                                            */
      __IOM uint32_t PAD35FNCSEL : 3;           /*!< [29..27] Pad 35 function select                                           */
    } PADREGI_b;
  } ;

  union {
    __IOM uint32_t PADREGJ;                     /*!< (@ 0x00000024) Pad Configuration Register J                               */

    struct {
      __IOM uint32_t PAD36PULL  : 1;            /*!< [0..0] Pad 36 pullup enable                                               */
      __IOM uint32_t PAD36INPEN : 1;            /*!< [1..1] Pad 36 input enable                                                */
      __IOM uint32_t PAD36STRNG : 1;            /*!< [2..2] Pad 36 drive strength                                              */
      __IOM uint32_t PAD36FNCSEL : 3;           /*!< [5..3] Pad 36 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD37PULL  : 1;            /*!< [8..8] Pad 37 pullup enable                                               */
      __IOM uint32_t PAD37INPEN : 1;            /*!< [9..9] Pad 37 input enable                                                */
      __IOM uint32_t PAD37STRNG : 1;            /*!< [10..10] Pad 37 drive strength                                            */
      __IOM uint32_t PAD37FNCSEL : 3;           /*!< [13..11] Pad 37 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD38PULL  : 1;            /*!< [16..16] Pad 38 pullup enable                                             */
      __IOM uint32_t PAD38INPEN : 1;            /*!< [17..17] Pad 38 input enable                                              */
      __IOM uint32_t PAD38STRNG : 1;            /*!< [18..18] Pad 38 drive strength                                            */
      __IOM uint32_t PAD38FNCSEL : 3;           /*!< [21..19] Pad 38 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD39PULL  : 1;            /*!< [24..24] Pad 39 pullup enable                                             */
      __IOM uint32_t PAD39INPEN : 1;            /*!< [25..25] Pad 39 input enable                                              */
      __IOM uint32_t PAD39STRNG : 1;            /*!< [26..26] Pad 39 drive strength                                            */
      __IOM uint32_t PAD39FNCSEL : 3;           /*!< [29..27] Pad 39 function select                                           */
      __IOM uint32_t PAD39RSEL  : 2;            /*!< [31..30] Pad 39 pullup resistor selection.                                */
    } PADREGJ_b;
  } ;

  union {
    __IOM uint32_t PADREGK;                     /*!< (@ 0x00000028) Pad Configuration Register K                               */

    struct {
      __IOM uint32_t PAD40PULL  : 1;            /*!< [0..0] Pad 40 pullup enable                                               */
      __IOM uint32_t PAD40INPEN : 1;            /*!< [1..1] Pad 40 input enable                                                */
      __IOM uint32_t PAD40STRNG : 1;            /*!< [2..2] Pad 40 drive strength                                              */
      __IOM uint32_t PAD40FNCSEL : 3;           /*!< [5..3] Pad 40 function select                                             */
      __IOM uint32_t PAD40RSEL  : 2;            /*!< [7..6] Pad 40 pullup resistor selection.                                  */
      __IOM uint32_t PAD41PULL  : 1;            /*!< [8..8] Pad 41 pullup enable                                               */
      __IOM uint32_t PAD41INPEN : 1;            /*!< [9..9] Pad 41 input enable                                                */
      __IOM uint32_t PAD41STRNG : 1;            /*!< [10..10] Pad 41 drive strength                                            */
      __IOM uint32_t PAD41FNCSEL : 3;           /*!< [13..11] Pad 41 function select                                           */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD41PWRUP : 1;            /*!< [15..15] Pad 41 upper power switch enable                                 */
      __IOM uint32_t PAD42PULL  : 1;            /*!< [16..16] Pad 42 pullup enable                                             */
      __IOM uint32_t PAD42INPEN : 1;            /*!< [17..17] Pad 42 input enable                                              */
      __IOM uint32_t PAD42STRNG : 1;            /*!< [18..18] Pad 42 drive strength                                            */
      __IOM uint32_t PAD42FNCSEL : 3;           /*!< [21..19] Pad 42 function select                                           */
      __IOM uint32_t PAD42RSEL  : 2;            /*!< [23..22] Pad 42 pullup resistor selection.                                */
      __IOM uint32_t PAD43PULL  : 1;            /*!< [24..24] Pad 43 pullup enable                                             */
      __IOM uint32_t PAD43INPEN : 1;            /*!< [25..25] Pad 43 input enable                                              */
      __IOM uint32_t PAD43STRNG : 1;            /*!< [26..26] Pad 43 drive strength                                            */
      __IOM uint32_t PAD43FNCSEL : 3;           /*!< [29..27] Pad 43 function select                                           */
      __IOM uint32_t PAD43RSEL  : 2;            /*!< [31..30] Pad 43 pullup resistor selection.                                */
    } PADREGK_b;
  } ;

  union {
    __IOM uint32_t PADREGL;                     /*!< (@ 0x0000002C) Pad Configuration Register L                               */

    struct {
      __IOM uint32_t PAD44PULL  : 1;            /*!< [0..0] Pad 44 pullup enable                                               */
      __IOM uint32_t PAD44INPEN : 1;            /*!< [1..1] Pad 44 input enable                                                */
      __IOM uint32_t PAD44STRNG : 1;            /*!< [2..2] Pad 44 drive strength                                              */
      __IOM uint32_t PAD44FNCSEL : 3;           /*!< [5..3] Pad 44 function select                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD45PULL  : 1;            /*!< [8..8] Pad 45 pullup enable                                               */
      __IOM uint32_t PAD45INPEN : 1;            /*!< [9..9] Pad 45 input enable                                                */
      __IOM uint32_t PAD45STRNG : 1;            /*!< [10..10] Pad 45 drive strength                                            */
      __IOM uint32_t PAD45FNCSEL : 3;           /*!< [13..11] Pad 45 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD46PULL  : 1;            /*!< [16..16] Pad 46 pullup enable                                             */
      __IOM uint32_t PAD46INPEN : 1;            /*!< [17..17] Pad 46 input enable                                              */
      __IOM uint32_t PAD46STRNG : 1;            /*!< [18..18] Pad 46 drive strength                                            */
      __IOM uint32_t PAD46FNCSEL : 3;           /*!< [21..19] Pad 46 function select                                           */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD47PULL  : 1;            /*!< [24..24] Pad 47 pullup enable                                             */
      __IOM uint32_t PAD47INPEN : 1;            /*!< [25..25] Pad 47 input enable                                              */
      __IOM uint32_t PAD47STRNG : 1;            /*!< [26..26] Pad 47 drive strength                                            */
      __IOM uint32_t PAD47FNCSEL : 3;           /*!< [29..27] Pad 47 function select                                           */
    } PADREGL_b;
  } ;

  union {
    __IOM uint32_t PADREGM;                     /*!< (@ 0x00000030) Pad Configuration Register M                               */

    struct {
      __IOM uint32_t PAD48PULL  : 1;            /*!< [0..0] Pad 48 pullup enable                                               */
      __IOM uint32_t PAD48INPEN : 1;            /*!< [1..1] Pad 48 input enable                                                */
      __IOM uint32_t PAD48STRNG : 1;            /*!< [2..2] Pad 48 drive strength                                              */
      __IOM uint32_t PAD48FNCSEL : 3;           /*!< [5..3] Pad 48 function select                                             */
      __IOM uint32_t PAD48RSEL  : 2;            /*!< [7..6] Pad 48 pullup resistor selection.                                  */
      __IOM uint32_t PAD49PULL  : 1;            /*!< [8..8] Pad 49 pullup enable                                               */
      __IOM uint32_t PAD49INPEN : 1;            /*!< [9..9] Pad 49 input enable                                                */
      __IOM uint32_t PAD49STRNG : 1;            /*!< [10..10] Pad 49 drive strength                                            */
      __IOM uint32_t PAD49FNCSEL : 3;           /*!< [13..11] Pad 49 function select                                           */
      __IOM uint32_t PAD49RSEL  : 2;            /*!< [15..14] Pad 49 pullup resistor selection.                                */
    } PADREGM_b;
  } ;
  __IM  uint32_t  RESERVED[3];

  union {
    __IOM uint32_t CFGA;                        /*!< (@ 0x00000040) GPIO Configuration Register A                              */

    struct {
      __IOM uint32_t GPIO0INCFG : 1;            /*!< [0..0] GPIO0 input enable.                                                */
      __IOM uint32_t GPIO0OUTCFG : 2;           /*!< [2..1] GPIO0 output configuration.                                        */
      __IOM uint32_t GPIO0INTD  : 1;            /*!< [3..3] GPIO0 interrupt direction.                                         */
      __IOM uint32_t GPIO1INCFG : 1;            /*!< [4..4] GPIO1 input enable.                                                */
      __IOM uint32_t GPIO1OUTCFG : 2;           /*!< [6..5] GPIO1 output configuration.                                        */
      __IOM uint32_t GPIO1INTD  : 1;            /*!< [7..7] GPIO1 interrupt direction.                                         */
      __IOM uint32_t GPIO2INCFG : 1;            /*!< [8..8] GPIO2 input enable.                                                */
      __IOM uint32_t GPIO2OUTCFG : 2;           /*!< [10..9] GPIO2 output configuration.                                       */
      __IOM uint32_t GPIO2INTD  : 1;            /*!< [11..11] GPIO2 interrupt direction.                                       */
      __IOM uint32_t GPIO3INCFG : 1;            /*!< [12..12] GPIO3 input enable.                                              */
      __IOM uint32_t GPIO3OUTCFG : 2;           /*!< [14..13] GPIO3 output configuration.                                      */
      __IOM uint32_t GPIO3INTD  : 1;            /*!< [15..15] GPIO3 interrupt direction.                                       */
      __IOM uint32_t GPIO4INCFG : 1;            /*!< [16..16] GPIO4 input enable.                                              */
      __IOM uint32_t GPIO4OUTCFG : 2;           /*!< [18..17] GPIO4 output configuration.                                      */
      __IOM uint32_t GPIO4INTD  : 1;            /*!< [19..19] GPIO4 interrupt direction.                                       */
      __IOM uint32_t GPIO5INCFG : 1;            /*!< [20..20] GPIO5 input enable.                                              */
      __IOM uint32_t GPIO5OUTCFG : 2;           /*!< [22..21] GPIO5 output configuration.                                      */
      __IOM uint32_t GPIO5INTD  : 1;            /*!< [23..23] GPIO5 interrupt direction.                                       */
      __IOM uint32_t GPIO6INCFG : 1;            /*!< [24..24] GPIO6 input enable.                                              */
      __IOM uint32_t GPIO6OUTCFG : 2;           /*!< [26..25] GPIO6 output configuration.                                      */
      __IOM uint32_t GPIO6INTD  : 1;            /*!< [27..27] GPIO6 interrupt direction.                                       */
      __IOM uint32_t GPIO7INCFG : 1;            /*!< [28..28] GPIO7 input enable.                                              */
      __IOM uint32_t GPIO7OUTCFG : 2;           /*!< [30..29] GPIO7 output configuration.                                      */
      __IOM uint32_t GPIO7INTD  : 1;            /*!< [31..31] GPIO7 interrupt direction.                                       */
    } CFGA_b;
  } ;

  union {
    __IOM uint32_t CFGB;                        /*!< (@ 0x00000044) GPIO Configuration Register B                              */

    struct {
      __IOM uint32_t GPIO8INCFG : 1;            /*!< [0..0] GPIO8 input enable.                                                */
      __IOM uint32_t GPIO8OUTCFG : 2;           /*!< [2..1] GPIO8 output configuration.                                        */
      __IOM uint32_t GPIO8INTD  : 1;            /*!< [3..3] GPIO8 interrupt direction.                                         */
      __IOM uint32_t GPIO9INCFG : 1;            /*!< [4..4] GPIO9 input enable.                                                */
      __IOM uint32_t GPIO9OUTCFG : 2;           /*!< [6..5] GPIO9 output configuration.                                        */
      __IOM uint32_t GPIO9INTD  : 1;            /*!< [7..7] GPIO9 interrupt direction.                                         */
      __IOM uint32_t GPIO10INCFG : 1;           /*!< [8..8] GPIO10 input enable.                                               */
      __IOM uint32_t GPIO10OUTCFG : 2;          /*!< [10..9] GPIO10 output configuration.                                      */
      __IOM uint32_t GPIO10INTD : 1;            /*!< [11..11] GPIO10 interrupt direction.                                      */
      __IOM uint32_t GPIO11INCFG : 1;           /*!< [12..12] GPIO11 input enable.                                             */
      __IOM uint32_t GPIO11OUTCFG : 2;          /*!< [14..13] GPIO11 output configuration.                                     */
      __IOM uint32_t GPIO11INTD : 1;            /*!< [15..15] GPIO11 interrupt direction.                                      */
      __IOM uint32_t GPIO12INCFG : 1;           /*!< [16..16] GPIO12 input enable.                                             */
      __IOM uint32_t GPIO12OUTCFG : 2;          /*!< [18..17] GPIO12 output configuration.                                     */
      __IOM uint32_t GPIO12INTD : 1;            /*!< [19..19] GPIO12 interrupt direction.                                      */
      __IOM uint32_t GPIO13INCFG : 1;           /*!< [20..20] GPIO13 input enable.                                             */
      __IOM uint32_t GPIO13OUTCFG : 2;          /*!< [22..21] GPIO13 output configuration.                                     */
      __IOM uint32_t GPIO13INTD : 1;            /*!< [23..23] GPIO13 interrupt direction.                                      */
      __IOM uint32_t GPIO14INCFG : 1;           /*!< [24..24] GPIO14 input enable.                                             */
      __IOM uint32_t GPIO14OUTCFG : 2;          /*!< [26..25] GPIO14 output configuration.                                     */
      __IOM uint32_t GPIO14INTD : 1;            /*!< [27..27] GPIO14 interrupt direction.                                      */
      __IOM uint32_t GPIO15INCFG : 1;           /*!< [28..28] GPIO15 input enable.                                             */
      __IOM uint32_t GPIO15OUTCFG : 2;          /*!< [30..29] GPIO15 output configuration.                                     */
      __IOM uint32_t GPIO15INTD : 1;            /*!< [31..31] GPIO15 interrupt direction.                                      */
    } CFGB_b;
  } ;

  union {
    __IOM uint32_t CFGC;                        /*!< (@ 0x00000048) GPIO Configuration Register C                              */

    struct {
      __IOM uint32_t GPIO16INCFG : 1;           /*!< [0..0] GPIO16 input enable.                                               */
      __IOM uint32_t GPIO16OUTCFG : 2;          /*!< [2..1] GPIO16 output configuration.                                       */
      __IOM uint32_t GPIO16INTD : 1;            /*!< [3..3] GPIO16 interrupt direction.                                        */
      __IOM uint32_t GPIO17INCFG : 1;           /*!< [4..4] GPIO17 input enable.                                               */
      __IOM uint32_t GPIO17OUTCFG : 2;          /*!< [6..5] GPIO17 output configuration.                                       */
      __IOM uint32_t GPIO17INTD : 1;            /*!< [7..7] GPIO17 interrupt direction.                                        */
      __IOM uint32_t GPIO18INCFG : 1;           /*!< [8..8] GPIO18 input enable.                                               */
      __IOM uint32_t GPIO18OUTCFG : 2;          /*!< [10..9] GPIO18 output configuration.                                      */
      __IOM uint32_t GPIO18INTD : 1;            /*!< [11..11] GPIO18 interrupt direction.                                      */
      __IOM uint32_t GPIO19INCFG : 1;           /*!< [12..12] GPIO19 input enable.                                             */
      __IOM uint32_t GPIO19OUTCFG : 2;          /*!< [14..13] GPIO19 output configuration.                                     */
      __IOM uint32_t GPIO19INTD : 1;            /*!< [15..15] GPIO19 interrupt direction.                                      */
      __IOM uint32_t GPIO20INCFG : 1;           /*!< [16..16] GPIO20 input enable.                                             */
      __IOM uint32_t GPIO20OUTCFG : 2;          /*!< [18..17] GPIO20 output configuration.                                     */
      __IOM uint32_t GPIO20INTD : 1;            /*!< [19..19] GPIO20 interrupt direction.                                      */
      __IOM uint32_t GPIO21INCFG : 1;           /*!< [20..20] GPIO21 input enable.                                             */
      __IOM uint32_t GPIO21OUTCFG : 2;          /*!< [22..21] GPIO21 output configuration.                                     */
      __IOM uint32_t GPIO21INTD : 1;            /*!< [23..23] GPIO21 interrupt direction.                                      */
      __IOM uint32_t GPIO22INCFG : 1;           /*!< [24..24] GPIO22 input enable.                                             */
      __IOM uint32_t GPIO22OUTCFG : 2;          /*!< [26..25] GPIO22 output configuration.                                     */
      __IOM uint32_t GPIO22INTD : 1;            /*!< [27..27] GPIO22 interrupt direction.                                      */
      __IOM uint32_t GPIO23INCFG : 1;           /*!< [28..28] GPIO23 input enable.                                             */
      __IOM uint32_t GPIO23OUTCFG : 2;          /*!< [30..29] GPIO23 output configuration.                                     */
      __IOM uint32_t GPIO23INTD : 1;            /*!< [31..31] GPIO23 interrupt direction.                                      */
    } CFGC_b;
  } ;

  union {
    __IOM uint32_t CFGD;                        /*!< (@ 0x0000004C) GPIO Configuration Register D                              */

    struct {
      __IOM uint32_t GPIO24INCFG : 1;           /*!< [0..0] GPIO24 input enable.                                               */
      __IOM uint32_t GPIO24OUTCFG : 2;          /*!< [2..1] GPIO24 output configuration.                                       */
      __IOM uint32_t GPIO24INTD : 1;            /*!< [3..3] GPIO24 interrupt direction.                                        */
      __IOM uint32_t GPIO25INCFG : 1;           /*!< [4..4] GPIO25 input enable.                                               */
      __IOM uint32_t GPIO25OUTCFG : 2;          /*!< [6..5] GPIO25 output configuration.                                       */
      __IOM uint32_t GPIO25INTD : 1;            /*!< [7..7] GPIO25 interrupt direction.                                        */
      __IOM uint32_t GPIO26INCFG : 1;           /*!< [8..8] GPIO26 input enable.                                               */
      __IOM uint32_t GPIO26OUTCFG : 2;          /*!< [10..9] GPIO26 output configuration.                                      */
      __IOM uint32_t GPIO26INTD : 1;            /*!< [11..11] GPIO26 interrupt direction.                                      */
      __IOM uint32_t GPIO27INCFG : 1;           /*!< [12..12] GPIO27 input enable.                                             */
      __IOM uint32_t GPIO27OUTCFG : 2;          /*!< [14..13] GPIO27 output configuration.                                     */
      __IOM uint32_t GPIO27INTD : 1;            /*!< [15..15] GPIO27 interrupt direction.                                      */
      __IOM uint32_t GPIO28INCFG : 1;           /*!< [16..16] GPIO28 input enable.                                             */
      __IOM uint32_t GPIO28OUTCFG : 2;          /*!< [18..17] GPIO28 output configuration.                                     */
      __IOM uint32_t GPIO28INTD : 1;            /*!< [19..19] GPIO28 interrupt direction.                                      */
      __IOM uint32_t GPIO29INCFG : 1;           /*!< [20..20] GPIO29 input enable.                                             */
      __IOM uint32_t GPIO29OUTCFG : 2;          /*!< [22..21] GPIO29 output configuration.                                     */
      __IOM uint32_t GPIO29INTD : 1;            /*!< [23..23] GPIO29 interrupt direction.                                      */
      __IOM uint32_t GPIO30INCFG : 1;           /*!< [24..24] GPIO30 input enable.                                             */
      __IOM uint32_t GPIO30OUTCFG : 2;          /*!< [26..25] GPIO30 output configuration.                                     */
      __IOM uint32_t GPIO30INTD : 1;            /*!< [27..27] GPIO30 interrupt direction.                                      */
      __IOM uint32_t GPIO31INCFG : 1;           /*!< [28..28] GPIO31 input enable.                                             */
      __IOM uint32_t GPIO31OUTCFG : 2;          /*!< [30..29] GPIO31 output configuration.                                     */
      __IOM uint32_t GPIO31INTD : 1;            /*!< [31..31] GPIO31 interrupt direction.                                      */
    } CFGD_b;
  } ;

  union {
    __IOM uint32_t CFGE;                        /*!< (@ 0x00000050) GPIO Configuration Register E                              */

    struct {
      __IOM uint32_t GPIO32INCFG : 1;           /*!< [0..0] GPIO32 input enable.                                               */
      __IOM uint32_t GPIO32OUTCFG : 2;          /*!< [2..1] GPIO32 output configuration.                                       */
      __IOM uint32_t GPIO32INTD : 1;            /*!< [3..3] GPIO32 interrupt direction.                                        */
      __IOM uint32_t GPIO33INCFG : 1;           /*!< [4..4] GPIO33 input enable.                                               */
      __IOM uint32_t GPIO33OUTCFG : 2;          /*!< [6..5] GPIO33 output configuration.                                       */
      __IOM uint32_t GPIO33INTD : 1;            /*!< [7..7] GPIO33 interrupt direction.                                        */
      __IOM uint32_t GPIO34INCFG : 1;           /*!< [8..8] GPIO34 input enable.                                               */
      __IOM uint32_t GPIO34OUTCFG : 2;          /*!< [10..9] GPIO34 output configuration.                                      */
      __IOM uint32_t GPIO34INTD : 1;            /*!< [11..11] GPIO34 interrupt direction.                                      */
      __IOM uint32_t GPIO35INCFG : 1;           /*!< [12..12] GPIO35 input enable.                                             */
      __IOM uint32_t GPIO35OUTCFG : 2;          /*!< [14..13] GPIO35 output configuration.                                     */
      __IOM uint32_t GPIO35INTD : 1;            /*!< [15..15] GPIO35 interrupt direction.                                      */
      __IOM uint32_t GPIO36INCFG : 1;           /*!< [16..16] GPIO36 input enable.                                             */
      __IOM uint32_t GPIO36OUTCFG : 2;          /*!< [18..17] GPIO36 output configuration.                                     */
      __IOM uint32_t GPIO36INTD : 1;            /*!< [19..19] GPIO36 interrupt direction.                                      */
      __IOM uint32_t GPIO37INCFG : 1;           /*!< [20..20] GPIO37 input enable.                                             */
      __IOM uint32_t GPIO37OUTCFG : 2;          /*!< [22..21] GPIO37 output configuration.                                     */
      __IOM uint32_t GPIO37INTD : 1;            /*!< [23..23] GPIO37 interrupt direction.                                      */
      __IOM uint32_t GPIO38INCFG : 1;           /*!< [24..24] GPIO38 input enable.                                             */
      __IOM uint32_t GPIO38OUTCFG : 2;          /*!< [26..25] GPIO38 output configuration.                                     */
      __IOM uint32_t GPIO38INTD : 1;            /*!< [27..27] GPIO38 interrupt direction.                                      */
      __IOM uint32_t GPIO39INCFG : 1;           /*!< [28..28] GPIO39 input enable.                                             */
      __IOM uint32_t GPIO39OUTCFG : 2;          /*!< [30..29] GPIO39 output configuration.                                     */
      __IOM uint32_t GPIO39INTD : 1;            /*!< [31..31] GPIO39 interrupt direction.                                      */
    } CFGE_b;
  } ;

  union {
    __IOM uint32_t CFGF;                        /*!< (@ 0x00000054) GPIO Configuration Register F                              */

    struct {
      __IOM uint32_t GPIO40INCFG : 1;           /*!< [0..0] GPIO40 input enable.                                               */
      __IOM uint32_t GPIO40OUTCFG : 2;          /*!< [2..1] GPIO40 output configuration.                                       */
      __IOM uint32_t GPIO40INTD : 1;            /*!< [3..3] GPIO40 interrupt direction.                                        */
      __IOM uint32_t GPIO41INCFG : 1;           /*!< [4..4] GPIO41 input enable.                                               */
      __IOM uint32_t GPIO41OUTCFG : 2;          /*!< [6..5] GPIO41 output configuration.                                       */
      __IOM uint32_t GPIO41INTD : 1;            /*!< [7..7] GPIO41 interrupt direction.                                        */
      __IOM uint32_t GPIO42INCFG : 1;           /*!< [8..8] GPIO42 input enable.                                               */
      __IOM uint32_t GPIO42OUTCFG : 2;          /*!< [10..9] GPIO42 output configuration.                                      */
      __IOM uint32_t GPIO42INTD : 1;            /*!< [11..11] GPIO42 interrupt direction.                                      */
      __IOM uint32_t GPIO43INCFG : 1;           /*!< [12..12] GPIO43 input enable.                                             */
      __IOM uint32_t GPIO43OUTCFG : 2;          /*!< [14..13] GPIO43 output configuration.                                     */
      __IOM uint32_t GPIO43INTD : 1;            /*!< [15..15] GPIO43 interrupt direction.                                      */
      __IOM uint32_t GPIO44INCFG : 1;           /*!< [16..16] GPIO44 input enable.                                             */
      __IOM uint32_t GPIO44OUTCFG : 2;          /*!< [18..17] GPIO44 output configuration.                                     */
      __IOM uint32_t GPIO44INTD : 1;            /*!< [19..19] GPIO44 interrupt direction.                                      */
      __IOM uint32_t GPIO45INCFG : 1;           /*!< [20..20] GPIO45 input enable.                                             */
      __IOM uint32_t GPIO45OUTCFG : 2;          /*!< [22..21] GPIO45 output configuration.                                     */
      __IOM uint32_t GPIO45INTD : 1;            /*!< [23..23] GPIO45 interrupt direction.                                      */
      __IOM uint32_t GPIO46INCFG : 1;           /*!< [24..24] GPIO46 input enable.                                             */
      __IOM uint32_t GPIO46OUTCFG : 2;          /*!< [26..25] GPIO46 output configuration.                                     */
      __IOM uint32_t GPIO46INTD : 1;            /*!< [27..27] GPIO46 interrupt direction.                                      */
      __IOM uint32_t GPIO47INCFG : 1;           /*!< [28..28] GPIO47 input enable.                                             */
      __IOM uint32_t GPIO47OUTCFG : 2;          /*!< [30..29] GPIO47 output configuration.                                     */
      __IOM uint32_t GPIO47INTD : 1;            /*!< [31..31] GPIO47 interrupt direction.                                      */
    } CFGF_b;
  } ;

  union {
    __IOM uint32_t CFGG;                        /*!< (@ 0x00000058) GPIO Configuration Register G                              */

    struct {
      __IOM uint32_t GPIO48INCFG : 1;           /*!< [0..0] GPIO48 input enable.                                               */
      __IOM uint32_t GPIO48OUTCFG : 2;          /*!< [2..1] GPIO48 output configuration.                                       */
      __IOM uint32_t GPIO48INTD : 1;            /*!< [3..3] GPIO48 interrupt direction.                                        */
      __IOM uint32_t GPIO49INCFG : 1;           /*!< [4..4] GPIO49 input enable.                                               */
      __IOM uint32_t GPIO49OUTCFG : 2;          /*!< [6..5] GPIO49 output configuration.                                       */
      __IOM uint32_t GPIO49INTD : 1;            /*!< [7..7] GPIO49 interrupt direction.                                        */
    } CFGG_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t PADKEY;                      /*!< (@ 0x00000060) Key Register for all pad configuration registers           */

    struct {
      __IOM uint32_t PADKEY     : 32;           /*!< [31..0] Key register value.                                               */
    } PADKEY_b;
  } ;
  __IM  uint32_t  RESERVED2[7];

  union {
    __IOM uint32_t RDA;                         /*!< (@ 0x00000080) GPIO Input Register A                                      */

    struct {
      __IOM uint32_t RDA        : 32;           /*!< [31..0] GPIO31-0 read data.                                               */
    } RDA_b;
  } ;

  union {
    __IOM uint32_t RDB;                         /*!< (@ 0x00000084) GPIO Input Register B                                      */

    struct {
      __IOM uint32_t RDB        : 18;           /*!< [17..0] GPIO49-32 read data.                                              */
    } RDB_b;
  } ;

  union {
    __IOM uint32_t WTA;                         /*!< (@ 0x00000088) GPIO Output Register A                                     */

    struct {
      __IOM uint32_t WTA        : 32;           /*!< [31..0] GPIO31-0 write data.                                              */
    } WTA_b;
  } ;

  union {
    __IOM uint32_t WTB;                         /*!< (@ 0x0000008C) GPIO Output Register B                                     */

    struct {
      __IOM uint32_t WTB        : 18;           /*!< [17..0] GPIO49-32 write data.                                             */
    } WTB_b;
  } ;

  union {
    __IOM uint32_t WTSA;                        /*!< (@ 0x00000090) GPIO Output Register A Set                                 */

    struct {
      __IOM uint32_t WTSA       : 32;           /*!< [31..0] Set the GPIO31-0 write data.                                      */
    } WTSA_b;
  } ;

  union {
    __IOM uint32_t WTSB;                        /*!< (@ 0x00000094) GPIO Output Register B Set                                 */

    struct {
      __IOM uint32_t WTSB       : 18;           /*!< [17..0] Set the GPIO49-32 write data.                                     */
    } WTSB_b;
  } ;

  union {
    __IOM uint32_t WTCA;                        /*!< (@ 0x00000098) GPIO Output Register A Clear                               */

    struct {
      __IOM uint32_t WTCA       : 32;           /*!< [31..0] Clear the GPIO31-0 write data.                                    */
    } WTCA_b;
  } ;

  union {
    __IOM uint32_t WTCB;                        /*!< (@ 0x0000009C) GPIO Output Register B Clear                               */

    struct {
      __IOM uint32_t WTCB       : 18;           /*!< [17..0] Clear the GPIO49-32 write data.                                   */
    } WTCB_b;
  } ;

  union {
    __IOM uint32_t ENA;                         /*!< (@ 0x000000A0) GPIO Enable Register A                                     */

    struct {
      __IOM uint32_t ENA        : 32;           /*!< [31..0] GPIO31-0 output enables                                           */
    } ENA_b;
  } ;

  union {
    __IOM uint32_t ENB;                         /*!< (@ 0x000000A4) GPIO Enable Register B                                     */

    struct {
      __IOM uint32_t ENB        : 18;           /*!< [17..0] GPIO49-32 output enables                                          */
    } ENB_b;
  } ;

  union {
    __IOM uint32_t ENSA;                        /*!< (@ 0x000000A8) GPIO Enable Register A Set                                 */

    struct {
      __IOM uint32_t ENSA       : 32;           /*!< [31..0] Set the GPIO31-0 output enables                                   */
    } ENSA_b;
  } ;

  union {
    __IOM uint32_t ENSB;                        /*!< (@ 0x000000AC) GPIO Enable Register B Set                                 */

    struct {
      __IOM uint32_t ENSB       : 18;           /*!< [17..0] Set the GPIO49-32 output enables                                  */
    } ENSB_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t ENCA;                        /*!< (@ 0x000000B4) GPIO Enable Register A Clear                               */

    struct {
      __IOM uint32_t ENCA       : 32;           /*!< [31..0] Clear the GPIO31-0 output enables                                 */
    } ENCA_b;
  } ;

  union {
    __IOM uint32_t ENCB;                        /*!< (@ 0x000000B8) GPIO Enable Register B Clear                               */

    struct {
      __IOM uint32_t ENCB       : 18;           /*!< [17..0] Clear the GPIO49-32 output enables                                */
    } ENCB_b;
  } ;

  union {
    __IOM uint32_t STMRCAP;                     /*!< (@ 0x000000BC) STIMER Capture Control                                     */

    struct {
      __IOM uint32_t STSEL0     : 6;            /*!< [5..0] STIMER Capture 0 Select.                                           */
      __IOM uint32_t STPOL0     : 1;            /*!< [6..6] STIMER Capture 0 Polarity.                                         */
      __IM  uint32_t            : 1;
      __IOM uint32_t STSEL1     : 6;            /*!< [13..8] STIMER Capture 1 Select.                                          */
      __IOM uint32_t STPOL1     : 1;            /*!< [14..14] STIMER Capture 1 Polarity.                                       */
      __IM  uint32_t            : 1;
      __IOM uint32_t STSEL2     : 6;            /*!< [21..16] STIMER Capture 2 Select.                                         */
      __IOM uint32_t STPOL2     : 1;            /*!< [22..22] STIMER Capture 2 Polarity.                                       */
      __IM  uint32_t            : 1;
      __IOM uint32_t STSEL3     : 6;            /*!< [29..24] STIMER Capture 3 Select.                                         */
      __IOM uint32_t STPOL3     : 1;            /*!< [30..30] STIMER Capture 3 Polarity.                                       */
    } STMRCAP_b;
  } ;

  union {
    __IOM uint32_t IOM0IRQ;                     /*!< (@ 0x000000C0) IOM0 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM0IRQ    : 6;            /*!< [5..0] IOMSTR0 IRQ pad select.                                            */
    } IOM0IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM1IRQ;                     /*!< (@ 0x000000C4) IOM1 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM1IRQ    : 6;            /*!< [5..0] IOMSTR1 IRQ pad select.                                            */
    } IOM1IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM2IRQ;                     /*!< (@ 0x000000C8) IOM2 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM2IRQ    : 6;            /*!< [5..0] IOMSTR2 IRQ pad select.                                            */
    } IOM2IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM3IRQ;                     /*!< (@ 0x000000CC) IOM3 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM3IRQ    : 6;            /*!< [5..0] IOMSTR3 IRQ pad select.                                            */
    } IOM3IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM4IRQ;                     /*!< (@ 0x000000D0) IOM4 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM4IRQ    : 6;            /*!< [5..0] IOMSTR4 IRQ pad select.                                            */
    } IOM4IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM5IRQ;                     /*!< (@ 0x000000D4) IOM5 Flow Control IRQ Select                               */

    struct {
      __IOM uint32_t IOM5IRQ    : 6;            /*!< [5..0] IOMSTR5 IRQ pad select.                                            */
    } IOM5IRQ_b;
  } ;

  union {
    __IOM uint32_t LOOPBACK;                    /*!< (@ 0x000000D8) IOM to IOS Loopback Control                                */

    struct {
      __IOM uint32_t LOOPBACK   : 3;            /*!< [2..0] IOM to IOS loopback control.                                       */
    } LOOPBACK_b;
  } ;

  union {
    __IOM uint32_t GPIOOBS;                     /*!< (@ 0x000000DC) GPIO Observation Mode Sample register                      */

    struct {
      __IOM uint32_t OBS_DATA   : 16;           /*!< [15..0] Sample of the data output on the GPIO observation port.
                                                     May have async sampling issues, as the data is not synronized
                                                     to the read operation. Intended for debug purposes only                   */
    } GPIOOBS_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGA;                  /*!< (@ 0x000000E0) Alternate Pad Configuration reg0 (Pads 3,2,1,0)            */

    struct {
      __IOM uint32_t PAD0_DS1   : 1;            /*!< [0..0] Pad 0 high order drive strength selection. Used in conjunction
                                                     with PAD0STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD0_SR    : 1;            /*!< [4..4] Pad 0 slew rate selection.                                         */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD1_DS1   : 1;            /*!< [8..8] Pad 1 high order drive strength selection. Used in conjunction
                                                     with PAD1STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD1_SR    : 1;            /*!< [12..12] Pad 1 slew rate selection.                                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD2_DS1   : 1;            /*!< [16..16] Pad 2 high order drive strength selection. Used in
                                                     conjunction with PAD2STRNG field to set the pad drive strength.           */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD2_SR    : 1;            /*!< [20..20] Pad 2 slew rate selection.                                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD3_DS1   : 1;            /*!< [24..24] Pad 3 high order drive strength selection. Used in
                                                     conjunction with PAD3STRNG field to set the pad drive strength.           */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD3_SR    : 1;            /*!< [28..28] Pad 3 slew rate selection.                                       */
    } ALTPADCFGA_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGB;                  /*!< (@ 0x000000E4) Alternate Pad Configuration reg1 (Pads 7,6,5,4)            */

    struct {
      __IOM uint32_t PAD4_DS1   : 1;            /*!< [0..0] Pad 4 high order drive strength selection. Used in conjunction
                                                     with PAD4STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD4_SR    : 1;            /*!< [4..4] Pad 4 slew rate selection.                                         */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD5_DS1   : 1;            /*!< [8..8] Pad 5 high order drive strength selection. Used in conjunction
                                                     with PAD5STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD5_SR    : 1;            /*!< [12..12] Pad 5 slew rate selection.                                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD6_DS1   : 1;            /*!< [16..16] Pad 6 high order drive strength selection. Used in
                                                     conjunction with PAD6STRNG field to set the pad drive strength.           */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD6_SR    : 1;            /*!< [20..20] Pad 6 slew rate selection.                                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD7_DS1   : 1;            /*!< [24..24] Pad 7 high order drive strength selection. Used in
                                                     conjunction with PAD7STRNG field to set the pad drive strength.           */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD7_SR    : 1;            /*!< [28..28] Pad 7 slew rate selection.                                       */
    } ALTPADCFGB_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGC;                  /*!< (@ 0x000000E8) Alternate Pad Configuration reg2 (Pads 11,10,9,8)          */

    struct {
      __IOM uint32_t PAD8_DS1   : 1;            /*!< [0..0] Pad 8 high order drive strength selection. Used in conjunction
                                                     with PAD8STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD8_SR    : 1;            /*!< [4..4] Pad 8 slew rate selection.                                         */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD9_DS1   : 1;            /*!< [8..8] Pad 9 high order drive strength selection. Used in conjunction
                                                     with PAD9STRNG field to set the pad drive strength.                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD9_SR    : 1;            /*!< [12..12] Pad 9 slew rate selection.                                       */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD10_DS1  : 1;            /*!< [16..16] Pad 10 high order drive strength selection. Used in
                                                     conjunction with PAD10STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD10_SR   : 1;            /*!< [20..20] Pad 10 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD11_DS1  : 1;            /*!< [24..24] Pad 11 high order drive strength selection. Used in
                                                     conjunction with PAD11STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD11_SR   : 1;            /*!< [28..28] Pad 11 slew rate selection.                                      */
    } ALTPADCFGC_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGD;                  /*!< (@ 0x000000EC) Alternate Pad Configuration reg3 (Pads 15,14,13,12)        */

    struct {
      __IOM uint32_t PAD12_DS1  : 1;            /*!< [0..0] Pad 12 high order drive strength selection. Used in conjunction
                                                     with PAD12STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD12_SR   : 1;            /*!< [4..4] Pad 12 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD13_DS1  : 1;            /*!< [8..8] Pad 13 high order drive strength selection. Used in conjunction
                                                     with PAD13STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD13_SR   : 1;            /*!< [12..12] Pad 13 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD14_DS1  : 1;            /*!< [16..16] Pad 14 high order drive strength selection. Used in
                                                     conjunction with PAD14STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD14_SR   : 1;            /*!< [20..20] Pad 14 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD15_DS1  : 1;            /*!< [24..24] Pad 15 high order drive strength selection. Used in
                                                     conjunction with PAD15STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD15_SR   : 1;            /*!< [28..28] Pad 15 slew rate selection.                                      */
    } ALTPADCFGD_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGE;                  /*!< (@ 0x000000F0) Alternate Pad Configuration reg4 (Pads 19,18,17,16)        */

    struct {
      __IOM uint32_t PAD16_DS1  : 1;            /*!< [0..0] Pad 16 high order drive strength selection. Used in conjunction
                                                     with PAD16STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD16_SR   : 1;            /*!< [4..4] Pad 16 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD17_DS1  : 1;            /*!< [8..8] Pad 17 high order drive strength selection. Used in conjunction
                                                     with PAD17STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD17_SR   : 1;            /*!< [12..12] Pad 17 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD18_DS1  : 1;            /*!< [16..16] Pad 18 high order drive strength selection. Used in
                                                     conjunction with PAD18STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD18_SR   : 1;            /*!< [20..20] Pad 18 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD19_DS1  : 1;            /*!< [24..24] Pad 19 high order drive strength selection. Used in
                                                     conjunction with PAD19STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD19_SR   : 1;            /*!< [28..28] Pad 19 slew rate selection.                                      */
    } ALTPADCFGE_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGF;                  /*!< (@ 0x000000F4) Alternate Pad Configuration reg5 (Pads 23,22,21,20)        */

    struct {
      __IOM uint32_t PAD20_DS1  : 1;            /*!< [0..0] Pad 20 high order drive strength selection. Used in conjunction
                                                     with PAD20STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD20_SR   : 1;            /*!< [4..4] Pad 20 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD21_DS1  : 1;            /*!< [8..8] Pad 21 high order drive strength selection. Used in conjunction
                                                     with PAD21STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD21_SR   : 1;            /*!< [12..12] Pad 21 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD22_DS1  : 1;            /*!< [16..16] Pad 22 high order drive strength selection. Used in
                                                     conjunction with PAD22STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD22_SR   : 1;            /*!< [20..20] Pad 22 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD23_DS1  : 1;            /*!< [24..24] Pad 23 high order drive strength selection. Used in
                                                     conjunction with PAD23STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD23_SR   : 1;            /*!< [28..28] Pad 23 slew rate selection.                                      */
    } ALTPADCFGF_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGG;                  /*!< (@ 0x000000F8) Alternate Pad Configuration reg6 (Pads 27,26,25,24)        */

    struct {
      __IOM uint32_t PAD24_DS1  : 1;            /*!< [0..0] Pad 24 high order drive strength selection. Used in conjunction
                                                     with PAD24STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD24_SR   : 1;            /*!< [4..4] Pad 24 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD25_DS1  : 1;            /*!< [8..8] Pad 25 high order drive strength selection. Used in conjunction
                                                     with PAD25STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD25_SR   : 1;            /*!< [12..12] Pad 25 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD26_DS1  : 1;            /*!< [16..16] Pad 26 high order drive strength selection. Used in
                                                     conjunction with PAD26STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD26_SR   : 1;            /*!< [20..20] Pad 26 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD27_DS1  : 1;            /*!< [24..24] Pad 27 high order drive strength selection. Used in
                                                     conjunction with PAD27STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD27_SR   : 1;            /*!< [28..28] Pad 27 slew rate selection.                                      */
    } ALTPADCFGG_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGH;                  /*!< (@ 0x000000FC) Alternate Pad Configuration reg7 (Pads 31,30,29,28)        */

    struct {
      __IOM uint32_t PAD28_DS1  : 1;            /*!< [0..0] Pad 28 high order drive strength selection. Used in conjunction
                                                     with PAD28STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD28_SR   : 1;            /*!< [4..4] Pad 28 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD29_DS1  : 1;            /*!< [8..8] Pad 29 high order drive strength selection. Used in conjunction
                                                     with PAD29STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD29_SR   : 1;            /*!< [12..12] Pad 29 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD30_DS1  : 1;            /*!< [16..16] Pad 30 high order drive strength selection. Used in
                                                     conjunction with PAD30STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD30_SR   : 1;            /*!< [20..20] Pad 30 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD31_DS1  : 1;            /*!< [24..24] Pad 31 high order drive strength selection. Used in
                                                     conjunction with PAD31STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD31_SR   : 1;            /*!< [28..28] Pad 31 slew rate selection.                                      */
    } ALTPADCFGH_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGI;                  /*!< (@ 0x00000100) Alternate Pad Configuration reg8 (Pads 35,34,33,32)        */

    struct {
      __IOM uint32_t PAD32_DS1  : 1;            /*!< [0..0] Pad 32 high order drive strength selection. Used in conjunction
                                                     with PAD32STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD32_SR   : 1;            /*!< [4..4] Pad 32 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD33_DS1  : 1;            /*!< [8..8] Pad 33 high order drive strength selection. Used in conjunction
                                                     with PAD33STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD33_SR   : 1;            /*!< [12..12] Pad 33 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD34_DS1  : 1;            /*!< [16..16] Pad 34 high order drive strength selection. Used in
                                                     conjunction with PAD34STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD34_SR   : 1;            /*!< [20..20] Pad 34 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD35_DS1  : 1;            /*!< [24..24] Pad 35 high order drive strength selection. Used in
                                                     conjunction with PAD35STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD35_SR   : 1;            /*!< [28..28] Pad 35 slew rate selection.                                      */
    } ALTPADCFGI_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGJ;                  /*!< (@ 0x00000104) Alternate Pad Configuration reg9 (Pads 39,38,37,36)        */

    struct {
      __IOM uint32_t PAD36_DS1  : 1;            /*!< [0..0] Pad 36 high order drive strength selection. Used in conjunction
                                                     with PAD36STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD36_SR   : 1;            /*!< [4..4] Pad 36 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD37_DS1  : 1;            /*!< [8..8] Pad 37 high order drive strength selection. Used in conjunction
                                                     with PAD37STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD37_SR   : 1;            /*!< [12..12] Pad 37 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD38_DS1  : 1;            /*!< [16..16] Pad 38 high order drive strength selection. Used in
                                                     conjunction with PAD38STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD38_SR   : 1;            /*!< [20..20] Pad 38 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD39_DS1  : 1;            /*!< [24..24] Pad 39 high order drive strength selection. Used in
                                                     conjunction with PAD39STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD39_SR   : 1;            /*!< [28..28] Pad 39 slew rate selection.                                      */
    } ALTPADCFGJ_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGK;                  /*!< (@ 0x00000108) Alternate Pad Configuration reg10 (Pads 43,42,41,40)       */

    struct {
      __IOM uint32_t PAD40_DS1  : 1;            /*!< [0..0] Pad 40 high order drive strength selection. Used in conjunction
                                                     with PAD40STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD40_SR   : 1;            /*!< [4..4] Pad 40 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD41_DS1  : 1;            /*!< [8..8] Pad 41 high order drive strength selection. Used in conjunction
                                                     with PAD41STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD41_SR   : 1;            /*!< [12..12] Pad 41 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD42_DS1  : 1;            /*!< [16..16] Pad 42 high order drive strength selection. Used in
                                                     conjunction with PAD42STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD42_SR   : 1;            /*!< [20..20] Pad 42 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD43_DS1  : 1;            /*!< [24..24] Pad 43 high order drive strength selection. Used in
                                                     conjunction with PAD43STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD43_SR   : 1;            /*!< [28..28] Pad 43 slew rate selection.                                      */
    } ALTPADCFGK_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGL;                  /*!< (@ 0x0000010C) Alternate Pad Configuration reg11 (Pads 47,46,45,44)       */

    struct {
      __IOM uint32_t PAD44_DS1  : 1;            /*!< [0..0] Pad 44 high order drive strength selection. Used in conjunction
                                                     with PAD44STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD44_SR   : 1;            /*!< [4..4] Pad 44 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD45_DS1  : 1;            /*!< [8..8] Pad 45 high order drive strength selection. Used in conjunction
                                                     with PAD45STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD45_SR   : 1;            /*!< [12..12] Pad 45 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD46_DS1  : 1;            /*!< [16..16] Pad 46 high order drive strength selection. Used in
                                                     conjunction with PAD46STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD46_SR   : 1;            /*!< [20..20] Pad 46 slew rate selection.                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD47_DS1  : 1;            /*!< [24..24] Pad 47 high order drive strength selection. Used in
                                                     conjunction with PAD47STRNG field to set the pad drive
                                                     strength.                                                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD47_SR   : 1;            /*!< [28..28] Pad 47 slew rate selection.                                      */
    } ALTPADCFGL_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGM;                  /*!< (@ 0x00000110) Alternate Pad Configuration reg12 (Pads 49,48)             */

    struct {
      __IOM uint32_t PAD48_DS1  : 1;            /*!< [0..0] Pad 48 high order drive strength selection. Used in conjunction
                                                     with PAD48STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD48_SR   : 1;            /*!< [4..4] Pad 48 slew rate selection.                                        */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD49_DS1  : 1;            /*!< [8..8] Pad 49 high order drive strength selection. Used in conjunction
                                                     with PAD49STRNG field to set the pad drive strength.                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD49_SR   : 1;            /*!< [12..12] Pad 49 slew rate selection.                                      */
    } ALTPADCFGM_b;
  } ;
  __IM  uint32_t  RESERVED4[59];

  union {
    __IOM uint32_t INT0EN;                      /*!< (@ 0x00000200) GPIO Interrupt Registers 31-0: Enable                      */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0EN_b;
  } ;

  union {
    __IOM uint32_t INT0STAT;                    /*!< (@ 0x00000204) GPIO Interrupt Registers 31-0: Status                      */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0STAT_b;
  } ;

  union {
    __IOM uint32_t INT0CLR;                     /*!< (@ 0x00000208) GPIO Interrupt Registers 31-0: Clear                       */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0CLR_b;
  } ;

  union {
    __IOM uint32_t INT0SET;                     /*!< (@ 0x0000020C) GPIO Interrupt Registers 31-0: Set                         */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0SET_b;
  } ;

  union {
    __IOM uint32_t INT1EN;                      /*!< (@ 0x00000210) GPIO Interrupt Registers 49-32: Enable                     */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
    } INT1EN_b;
  } ;

  union {
    __IOM uint32_t INT1STAT;                    /*!< (@ 0x00000214) GPIO Interrupt Registers 49-32: Status                     */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
    } INT1STAT_b;
  } ;

  union {
    __IOM uint32_t INT1CLR;                     /*!< (@ 0x00000218) GPIO Interrupt Registers 49-32: Clear                      */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
    } INT1CLR_b;
  } ;

  union {
    __IOM uint32_t INT1SET;                     /*!< (@ 0x0000021C) GPIO Interrupt Registers 49-32: Set                        */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
    } INT1SET_b;
  } ;
} GPIO_Type;                                    /*!< Size = 544 (0x220)                                                        */



/* =========================================================================================================================== */
/* ================                                          IOMSTR0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C/SPI Master (IOMSTR0)
  */

typedef struct {                                /*!< (@ 0x50004000) IOMSTR0 Structure                                          */

  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000000) FIFO Access Port                                           */

    struct {
      __IOM uint32_t FIFO       : 32;           /*!< [31..0] FIFO access port.                                                 */
    } FIFO_b;
  } ;
  __IM  uint32_t  RESERVED[63];

  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) Current FIFO Pointers                                      */

    struct {
      __IOM uint32_t FIFOSIZ    : 8;            /*!< [7..0] The number of bytes currently in the FIFO.                         */
      __IM  uint32_t            : 8;
      __IOM uint32_t FIFOREM    : 8;            /*!< [23..16] The number of bytes remaining in the FIFO (i.e. 128-FIFOSIZ
                                                     if FULLDUP = 0 or 64-FIFOSIZ if FULLDUP = 1)).                            */
    } FIFOPTR_b;
  } ;

  union {
    __IOM uint32_t TLNGTH;                      /*!< (@ 0x00000104) Transfer Length                                            */

    struct {
      __IOM uint32_t TLNGTH     : 12;           /*!< [11..0] Remaining transfer length.                                        */
    } TLNGTH_b;
  } ;

  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000108) FIFO Threshold Configuration                               */

    struct {
      __IOM uint32_t FIFORTHR   : 7;            /*!< [6..0] FIFO read threshold.                                               */
      __IM  uint32_t            : 1;
      __IOM uint32_t FIFOWTHR   : 7;            /*!< [14..8] FIFO write threshold.                                             */
    } FIFOTHR_b;
  } ;

  union {
    __IOM uint32_t CLKCFG;                      /*!< (@ 0x0000010C) I/O Clock Configuration                                    */

    struct {
      __IM  uint32_t            : 8;
      __IOM uint32_t FSEL       : 3;            /*!< [10..8] Select the input clock frequency.                                 */
      __IOM uint32_t DIV3       : 1;            /*!< [11..11] Enable divide by 3.                                              */
      __IOM uint32_t DIVEN      : 1;            /*!< [12..12] Enable clock division by TOTPER.                                 */
      __IM  uint32_t            : 3;
      __IOM uint32_t LOWPER     : 8;            /*!< [23..16] Clock low count minus 1.                                         */
      __IOM uint32_t TOTPER     : 8;            /*!< [31..24] Clock total count minus 1.                                       */
    } CLKCFG_b;
  } ;

  union {
    __IOM uint32_t CMD;                         /*!< (@ 0x00000110) Command Register                                           */

    struct {
      __IOM uint32_t CMD        : 32;           /*!< [31..0] This register holds the I/O Command                               */
    } CMD_b;
  } ;

  union {
    __IOM uint32_t CMDRPT;                      /*!< (@ 0x00000114) Command Repeat Register                                    */

    struct {
      __IOM uint32_t CMDRPT     : 5;            /*!< [4..0] These bits hold the Command repeat count.                          */
    } CMDRPT_b;
  } ;

  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x00000118) Status Register                                            */

    struct {
      __IOM uint32_t ERR        : 1;            /*!< [0..0] This bit indicates if an error interrupt has occurred.             */
      __IOM uint32_t CMDACT     : 1;            /*!< [1..1] This bit indicates if the I/O Command is active.                   */
      __IOM uint32_t IDLEST     : 1;            /*!< [2..2] This bit indicates if the I/O state machine is IDLE.               */
    } STATUS_b;
  } ;

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x0000011C) I/O Master Configuration                                   */

    struct {
      __IOM uint32_t IFCSEL     : 1;            /*!< [0..0] This bit selects the I/O interface.                                */
      __IOM uint32_t SPOL       : 1;            /*!< [1..1] This bit selects SPI polarity.                                     */
      __IOM uint32_t SPHA       : 1;            /*!< [2..2] This bit selects SPI phase.                                        */
      __IOM uint32_t FULLDUP    : 1;            /*!< [3..3] This bit selects full duplex mode.                                 */
      __IOM uint32_t STARTRD    : 2;            /*!< [5..4] This bit selects the preread timing.                               */
      __IM  uint32_t            : 2;
      __IOM uint32_t WTFC       : 1;            /*!< [8..8] This bit enables write mode flow control.                          */
      __IOM uint32_t RDFC       : 1;            /*!< [9..9] This bit enables read mode flow control.                           */
      __IOM uint32_t MOSIINV    : 1;            /*!< [10..10] This bit invewrts MOSI when flow control is enabled.             */
      __IOM uint32_t FCDEL      : 1;            /*!< [11..11] This bit must be left at the default value of 0.                 */
      __IOM uint32_t WTFCIRQ    : 1;            /*!< [12..12] This bit selects the write mode flow control signal.             */
      __IOM uint32_t WTFCPOL    : 1;            /*!< [13..13] This bit selects the write flow control signal polarity.         */
      __IOM uint32_t RDFCPOL    : 1;            /*!< [14..14] This bit selects the read flow control signal polarity.          */
      __IM  uint32_t            : 16;
      __IOM uint32_t IFCEN      : 1;            /*!< [31..31] This bit enables the IO Master.                                  */
    } CFG_b;
  } ;
  __IM  uint32_t  RESERVED1[56];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Master Interrupts: Enable                               */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] This is the Command Complete interrupt.                            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] This is the FIFO Threshold interrupt.                              */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] This is the Read FIFO Underflow interrupt. An attempt
                                                     was made to read FIFO when empty (i.e. while FIFOSIZ less
                                                     than 4).                                                                  */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] This is the Write FIFO Overflow interrupt. An attempt
                                                     was made to write the FIFO while it was full (i.e. while
                                                     FIFOSIZ > 124).                                                           */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] This is the I2C NAK interrupt. The expected ACK from
                                                     the slave was not received by the IOM.                                    */
      __IOM uint32_t WTLEN      : 1;            /*!< [5..5] This is the WTLEN interrupt.                                       */
      __IOM uint32_t IACC       : 1;            /*!< [6..6] This is the illegal FIFO access interrupt. An attempt
                                                     was made to read the FIFO during a write CMD. Or an attempt
                                                     was made to write the FIFO on a read CMD.                                 */
      __IOM uint32_t ICMD       : 1;            /*!< [7..7] This is the illegal command interrupt. Software attempted
                                                     to issue a CMD while another CMD was already in progress.
                                                     Or an attempt was made to issue a non-zero-length write
                                                     CMD with an empty FIFO.                                                   */
      __IOM uint32_t START      : 1;            /*!< [8..8] This is the START command interrupt. A START from another
                                                     master was detected. Software must wait for a STOP before
                                                     proceeding.                                                               */
      __IOM uint32_t STOP       : 1;            /*!< [9..9] This is the STOP command interrupt. A STOP bit was detected
                                                     by the IOM.                                                               */
      __IOM uint32_t ARB        : 1;            /*!< [10..10] This is the arbitration loss interrupt. This error
                                                     occurs if another master collides with an IO Master transfer.
                                                     Generally, the IOM started an operation but found SDA already
                                                     low.                                                                      */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Master Interrupts: Status                               */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] This is the Command Complete interrupt.                            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] This is the FIFO Threshold interrupt.                              */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] This is the Read FIFO Underflow interrupt. An attempt
                                                     was made to read FIFO when empty (i.e. while FIFOSIZ less
                                                     than 4).                                                                  */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] This is the Write FIFO Overflow interrupt. An attempt
                                                     was made to write the FIFO while it was full (i.e. while
                                                     FIFOSIZ > 124).                                                           */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] This is the I2C NAK interrupt. The expected ACK from
                                                     the slave was not received by the IOM.                                    */
      __IOM uint32_t WTLEN      : 1;            /*!< [5..5] This is the WTLEN interrupt.                                       */
      __IOM uint32_t IACC       : 1;            /*!< [6..6] This is the illegal FIFO access interrupt. An attempt
                                                     was made to read the FIFO during a write CMD. Or an attempt
                                                     was made to write the FIFO on a read CMD.                                 */
      __IOM uint32_t ICMD       : 1;            /*!< [7..7] This is the illegal command interrupt. Software attempted
                                                     to issue a CMD while another CMD was already in progress.
                                                     Or an attempt was made to issue a non-zero-length write
                                                     CMD with an empty FIFO.                                                   */
      __IOM uint32_t START      : 1;            /*!< [8..8] This is the START command interrupt. A START from another
                                                     master was detected. Software must wait for a STOP before
                                                     proceeding.                                                               */
      __IOM uint32_t STOP       : 1;            /*!< [9..9] This is the STOP command interrupt. A STOP bit was detected
                                                     by the IOM.                                                               */
      __IOM uint32_t ARB        : 1;            /*!< [10..10] This is the arbitration loss interrupt. This error
                                                     occurs if another master collides with an IO Master transfer.
                                                     Generally, the IOM started an operation but found SDA already
                                                     low.                                                                      */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Master Interrupts: Clear                                */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] This is the Command Complete interrupt.                            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] This is the FIFO Threshold interrupt.                              */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] This is the Read FIFO Underflow interrupt. An attempt
                                                     was made to read FIFO when empty (i.e. while FIFOSIZ less
                                                     than 4).                                                                  */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] This is the Write FIFO Overflow interrupt. An attempt
                                                     was made to write the FIFO while it was full (i.e. while
                                                     FIFOSIZ > 124).                                                           */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] This is the I2C NAK interrupt. The expected ACK from
                                                     the slave was not received by the IOM.                                    */
      __IOM uint32_t WTLEN      : 1;            /*!< [5..5] This is the WTLEN interrupt.                                       */
      __IOM uint32_t IACC       : 1;            /*!< [6..6] This is the illegal FIFO access interrupt. An attempt
                                                     was made to read the FIFO during a write CMD. Or an attempt
                                                     was made to write the FIFO on a read CMD.                                 */
      __IOM uint32_t ICMD       : 1;            /*!< [7..7] This is the illegal command interrupt. Software attempted
                                                     to issue a CMD while another CMD was already in progress.
                                                     Or an attempt was made to issue a non-zero-length write
                                                     CMD with an empty FIFO.                                                   */
      __IOM uint32_t START      : 1;            /*!< [8..8] This is the START command interrupt. A START from another
                                                     master was detected. Software must wait for a STOP before
                                                     proceeding.                                                               */
      __IOM uint32_t STOP       : 1;            /*!< [9..9] This is the STOP command interrupt. A STOP bit was detected
                                                     by the IOM.                                                               */
      __IOM uint32_t ARB        : 1;            /*!< [10..10] This is the arbitration loss interrupt. This error
                                                     occurs if another master collides with an IO Master transfer.
                                                     Generally, the IOM started an operation but found SDA already
                                                     low.                                                                      */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Master Interrupts: Set                                  */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] This is the Command Complete interrupt.                            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] This is the FIFO Threshold interrupt.                              */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] This is the Read FIFO Underflow interrupt. An attempt
                                                     was made to read FIFO when empty (i.e. while FIFOSIZ less
                                                     than 4).                                                                  */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] This is the Write FIFO Overflow interrupt. An attempt
                                                     was made to write the FIFO while it was full (i.e. while
                                                     FIFOSIZ > 124).                                                           */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] This is the I2C NAK interrupt. The expected ACK from
                                                     the slave was not received by the IOM.                                    */
      __IOM uint32_t WTLEN      : 1;            /*!< [5..5] This is the WTLEN interrupt.                                       */
      __IOM uint32_t IACC       : 1;            /*!< [6..6] This is the illegal FIFO access interrupt. An attempt
                                                     was made to read the FIFO during a write CMD. Or an attempt
                                                     was made to write the FIFO on a read CMD.                                 */
      __IOM uint32_t ICMD       : 1;            /*!< [7..7] This is the illegal command interrupt. Software attempted
                                                     to issue a CMD while another CMD was already in progress.
                                                     Or an attempt was made to issue a non-zero-length write
                                                     CMD with an empty FIFO.                                                   */
      __IOM uint32_t START      : 1;            /*!< [8..8] This is the START command interrupt. A START from another
                                                     master was detected. Software must wait for a STOP before
                                                     proceeding.                                                               */
      __IOM uint32_t STOP       : 1;            /*!< [9..9] This is the STOP command interrupt. A STOP bit was detected
                                                     by the IOM.                                                               */
      __IOM uint32_t ARB        : 1;            /*!< [10..10] This is the arbitration loss interrupt. This error
                                                     occurs if another master collides with an IO Master transfer.
                                                     Generally, the IOM started an operation but found SDA already
                                                     low.                                                                      */
    } INTSET_b;
  } ;
} IOMSTR0_Type;                                 /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                          IOSLAVE                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C/SPI Slave (IOSLAVE)
  */

typedef struct {                                /*!< (@ 0x50000000) IOSLAVE Structure                                          */
  __IM  uint32_t  RESERVED[64];

  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) Current FIFO Pointer                                       */

    struct {
      __IOM uint32_t FIFOPTR    : 8;            /*!< [7..0] Current FIFO pointer.                                              */
      __IOM uint32_t FIFOSIZ    : 8;            /*!< [15..8] The number of bytes currently in the hardware FIFO.               */
    } FIFOPTR_b;
  } ;

  union {
    __IOM uint32_t FIFOCFG;                     /*!< (@ 0x00000104) FIFO Configuration                                         */

    struct {
      __IOM uint32_t FIFOBASE   : 5;            /*!< [4..0] These bits hold the base address of the I/O FIFO in 8
                                                     byte segments. The IO Slave FIFO is situated in LRAM at
                                                     (FIFOBASE*8) to (FIFOMAX*8-1).                                            */
      __IM  uint32_t            : 3;
      __IOM uint32_t FIFOMAX    : 6;            /*!< [13..8] These bits hold the maximum FIFO address in 8 byte segments.
                                                     It is also the beginning of the RAM area of the LRAM. Note
                                                     that no RAM area is configured if FIFOMAX is set to 0x1F.                 */
      __IM  uint32_t            : 10;
      __IOM uint32_t ROBASE     : 6;            /*!< [29..24] Defines the read-only area. The IO Slave read-only
                                                     area is situated in LRAM at (ROBASE*8) to (FIFOOBASE*8-1)                 */
    } FIFOCFG_b;
  } ;

  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000108) FIFO Threshold Configuration                               */

    struct {
      __IOM uint32_t FIFOTHR    : 8;            /*!< [7..0] FIFO size interrupt threshold.                                     */
    } FIFOTHR_b;
  } ;

  union {
    __IOM uint32_t FUPD;                        /*!< (@ 0x0000010C) FIFO Update Status                                         */

    struct {
      __IOM uint32_t FIFOUPD    : 1;            /*!< [0..0] This bit indicates that a FIFO update is underway.                 */
      __IOM uint32_t IOREAD     : 1;            /*!< [1..1] This bitfield indicates an IO read is active.                      */
    } FUPD_b;
  } ;

  union {
    __IOM uint32_t FIFOCTR;                     /*!< (@ 0x00000110) Overall FIFO Counter                                       */

    struct {
      __IOM uint32_t FIFOCTR    : 10;           /*!< [9..0] Virtual FIFO byte count                                            */
    } FIFOCTR_b;
  } ;

  union {
    __IOM uint32_t FIFOINC;                     /*!< (@ 0x00000114) Overall FIFO Counter Increment                             */

    struct {
      __IOM uint32_t FIFOINC    : 10;           /*!< [9..0] Increment the Overall FIFO Counter by this value on a
                                                     write                                                                     */
    } FIFOINC_b;
  } ;

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000118) I/O Slave Configuration                                    */

    struct {
      __IOM uint32_t IFCSEL     : 1;            /*!< [0..0] This bit selects the I/O interface.                                */
      __IOM uint32_t SPOL       : 1;            /*!< [1..1] This bit selects SPI polarity.                                     */
      __IOM uint32_t LSB        : 1;            /*!< [2..2] This bit selects the transfer bit ordering.                        */
      __IM  uint32_t            : 1;
      __IOM uint32_t STARTRD    : 1;            /*!< [4..4] This bit holds the cycle to initiate an I/O RAM read.              */
      __IM  uint32_t            : 3;
      __IOM uint32_t I2CADDR    : 12;           /*!< [19..8] 7-bit or 10-bit I2C device address.                               */
      __IM  uint32_t            : 11;
      __IOM uint32_t IFCEN      : 1;            /*!< [31..31] IOSLAVE interface enable.                                        */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t PRENC;                       /*!< (@ 0x0000011C) I/O Slave Interrupt Priority Encode                        */

    struct {
      __IOM uint32_t PRENC      : 5;            /*!< [4..0] These bits hold the priority encode of the REGACC interrupts.      */
    } PRENC_b;
  } ;

  union {
    __IOM uint32_t IOINTCTL;                    /*!< (@ 0x00000120) I/O Interrupt Control                                      */

    struct {
      __IOM uint32_t IOINTEN    : 8;            /*!< [7..0] These read-only bits indicate whether the IOINT interrupts
                                                     are enabled.                                                              */
      __IOM uint32_t IOINT      : 8;            /*!< [15..8] These bits read the IOINT interrupts.                             */
      __IOM uint32_t IOINTCLR   : 1;            /*!< [16..16] This bit clears all of the IOINT interrupts when written
                                                     with a 1.                                                                 */
      __IM  uint32_t            : 7;
      __IOM uint32_t IOINTSET   : 8;            /*!< [31..24] These bits set the IOINT interrupts when written with
                                                     a 1.                                                                      */
    } IOINTCTL_b;
  } ;

  union {
    __IOM uint32_t GENADD;                      /*!< (@ 0x00000124) General Address Data                                       */

    struct {
      __IOM uint32_t GADATA     : 8;            /*!< [7..0] The data supplied on the last General Address reference.           */
    } GENADD_b;
  } ;
  __IM  uint32_t  RESERVED1[54];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Slave Interrupts: Enable                                */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] I2C Interrupt Write interrupt.                                     */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Slave Interrupts: Status                                */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] I2C Interrupt Write interrupt.                                     */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Slave Interrupts: Clear                                 */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] I2C Interrupt Write interrupt.                                     */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Slave Interrupts: Set                                   */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] I2C Interrupt Write interrupt.                                     */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
    } INTSET_b;
  } ;

  union {
    __IOM uint32_t REGACCINTEN;                 /*!< (@ 0x00000210) Register Access Interrupts: Enable                         */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTEN_b;
  } ;

  union {
    __IOM uint32_t REGACCINTSTAT;               /*!< (@ 0x00000214) Register Access Interrupts: Status                         */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTSTAT_b;
  } ;

  union {
    __IOM uint32_t REGACCINTCLR;                /*!< (@ 0x00000218) Register Access Interrupts: Clear                          */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTCLR_b;
  } ;

  union {
    __IOM uint32_t REGACCINTSET;                /*!< (@ 0x0000021C) Register Access Interrupts: Set                            */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTSET_b;
  } ;
} IOSLAVE_Type;                                 /*!< Size = 544 (0x220)                                                        */



/* =========================================================================================================================== */
/* ================                                          MCUCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief MCU Miscellaneous Control Logic (MCUCTRL)
  */

typedef struct {                                /*!< (@ 0x40020000) MCUCTRL Structure                                          */

  union {
    __IOM uint32_t CHIP_INFO;                   /*!< (@ 0x00000000) Chip Information Register                                  */

    struct {
      __IOM uint32_t PARTNUM    : 32;           /*!< [31..0] BCD part number.                                                  */
    } CHIP_INFO_b;
  } ;

  union {
    __IOM uint32_t CHIPID0;                     /*!< (@ 0x00000004) Unique Chip ID 0                                           */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Unique chip ID 0.                                                 */
    } CHIPID0_b;
  } ;

  union {
    __IOM uint32_t CHIPID1;                     /*!< (@ 0x00000008) Unique Chip ID 1                                           */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Unique chip ID 1.                                                 */
    } CHIPID1_b;
  } ;

  union {
    __IOM uint32_t CHIPREV;                     /*!< (@ 0x0000000C) Chip Revision                                              */

    struct {
      __IOM uint32_t REVMIN     : 4;            /*!< [3..0] Minor Revision ID.                                                 */
      __IOM uint32_t REVMAJ     : 4;            /*!< [7..4] Major Revision ID.                                                 */
    } CHIPREV_b;
  } ;

  union {
    __IOM uint32_t VENDORID;                    /*!< (@ 0x00000010) Unique Vendor ID                                           */

    struct {
      __IOM uint32_t VALUE      : 32;           /*!< [31..0] Unique Vendor ID                                                  */
    } VENDORID_b;
  } ;

  union {
    __IOM uint32_t DEBUGGER;                    /*!< (@ 0x00000014) Debugger Access Control                                    */

    struct {
      __IOM uint32_t LOCKOUT    : 1;            /*!< [0..0] Lockout of debugger (SWD).                                         */
    } DEBUGGER_b;
  } ;
  __IM  uint32_t  RESERVED[18];

  union {
    __IOM uint32_t BUCK;                        /*!< (@ 0x00000060) Analog Buck Control                                        */

    struct {
      __IOM uint32_t BUCKSWE    : 1;            /*!< [0..0] Buck Register Software Override Enable. This will enable
                                                     the override values for MEMBUCKPWD, COREBUCKPWD, COREBUCKRST,
                                                     MEMBUCKRST, all to be propagated to the control logic,
                                                     instead of the normal power control module signal. Note
                                                     - Must take care to have correct value for ALL the register
                                                     bits when this SWE is enabled.                                            */
      __IOM uint32_t BYPBUCKCORE : 1;           /*!< [1..1] Not used. Additional control of buck is available in
                                                     the power control module                                                  */
      __IOM uint32_t COREBUCKPWD : 1;           /*!< [2..2] Core buck power down override. 1=Powered Down; 0=Enabled;
                                                     Value is propagated only when the BUCKSWE bit is active,
                                                     otherwise control is from the power control module.                       */
      __IOM uint32_t SLEEPBUCKANA : 1;          /*!< [3..3] HFRC clkgen bit 0 override. When set, this will override
                                                     to 0 bit 0 of the hfrc_freq_clkgen internal bus (see internal
                                                     Shelby-1473)                                                              */
      __IOM uint32_t MEMBUCKPWD : 1;            /*!< [4..4] Memory buck power down override. 1=Powered Down; 0=Enabled;
                                                     Value is propagated only when the BUCKSWE bit is active,
                                                     otherwise control is from the power control module.                       */
      __IOM uint32_t BYPBUCKMEM : 1;            /*!< [5..5] Not used. Additional control of buck is available in
                                                     the power control module                                                  */
      __IOM uint32_t COREBUCKRST : 1;           /*!< [6..6] Reset control override for Core Buck; 0=enabled, 1=reset;
                                                     Value is propagated only when the BUCKSWE bit is active,
                                                     otherwise control is from the power control module.                       */
      __IOM uint32_t MEMBUCKRST : 1;            /*!< [7..7] Reset control override for Mem Buck; 0=enabled, 1=reset;
                                                     Value is propagated only when the BUCKSWE bit is active,
                                                     otherwise contrl is from the power control module.                        */
    } BUCK_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t BUCK3;                       /*!< (@ 0x00000068) Buck control reg 3                                         */

    struct {
      __IOM uint32_t COREBUCKHYSTTRIM : 2;      /*!< [1..0] Hysterisis trim for core buck                                      */
      __IOM uint32_t COREBUCKZXTRIM : 4;        /*!< [5..2] Core buck zero crossing trim value                                 */
      __IOM uint32_t COREBUCKBURSTEN : 1;       /*!< [6..6] Core Buck burst enable. 0=disabled, 1=enabled                      */
      __IOM uint32_t COREBUCKLOTON : 4;         /*!< [10..7] Core Buck low TON trim value                                      */
      __IOM uint32_t MEMBUCKHYSTTRIM : 2;       /*!< [12..11] Hysterisis trim for mem buck                                     */
      __IOM uint32_t MEMBUCKZXTRIM : 4;         /*!< [16..13] Memory buck zero crossing trim value                             */
      __IOM uint32_t MEMBUCKBURSTEN : 1;        /*!< [17..17] MEM Buck burst enable 0=disable, 0=disabled, 1=enable.           */
      __IOM uint32_t MEMBUCKLOTON : 4;          /*!< [21..18] MEM Buck low TON trim value                                      */
    } BUCK3_b;
  } ;
  __IM  uint32_t  RESERVED2[5];

  union {
    __IOM uint32_t LDOREG1;                     /*!< (@ 0x00000080) Analog LDO Reg 1                                           */

    struct {
      __IOM uint32_t TRIMCORELDOR1 : 10;        /*!< [9..0] CORE LDO Active mode ouput trim (R1).                              */
      __IOM uint32_t TRIMCORELDOR3 : 4;         /*!< [13..10] CORE LDO tempco trim (R3).                                       */
      __IOM uint32_t CORELDOLPTRIM : 6;         /*!< [19..14] CORE LDO Low Power Trim                                          */
      __IOM uint32_t CORELDOIBSTRM : 1;         /*!< [20..20] CORE LDO IBIAS Trim                                              */
    } LDOREG1_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t LDOREG3;                     /*!< (@ 0x00000088) LDO Control Register 3                                     */

    struct {
      __IOM uint32_t MEMLDOLPTRIM : 6;          /*!< [5..0] MEM LDO TRIM for low power mode with ADC inactive                  */
      __IOM uint32_t MEMLDOLPALTTRIM : 6;       /*!< [11..6] MEM LDO TRIM for low power mode with ADC active                   */
      __IOM uint32_t TRIMMEMLDOR1 : 6;          /*!< [17..12] MEM LDO active mode trim (R1).                                   */
    } LDOREG3_b;
  } ;
  __IM  uint32_t  RESERVED4[29];

  union {
    __IOM uint32_t BODPORCTRL;                  /*!< (@ 0x00000100) BOD and PDR control Register                               */

    struct {
      __IOM uint32_t PWDPDR     : 1;            /*!< [0..0] PDR Power Down.                                                    */
      __IOM uint32_t PWDBOD     : 1;            /*!< [1..1] BOD Power Down.                                                    */
      __IOM uint32_t PDREXTREFSEL : 1;          /*!< [2..2] PDR External Reference Select.                                     */
      __IOM uint32_t BODEXTREFSEL : 1;          /*!< [3..3] BOD External Reference Select.                                     */
    } BODPORCTRL_b;
  } ;

  union {
    __IOM uint32_t ADCPWRDLY;                   /*!< (@ 0x00000104) ADC Power Up Delay Control                                 */

    struct {
      __IOM uint32_t ADCPWR0    : 8;            /*!< [7..0] ADC Reference Buffer Power Enable delay in 64 ADC CLK
                                                     increments for ADC_CLKSEL = 0x1, 32 ADC CLOCK increments
                                                     for ADC_CLKSEL = 0x2.                                                     */
      __IOM uint32_t ADCPWR1    : 8;            /*!< [15..8] ADC Reference Keeper enable delay in 16 ADC CLK increments
                                                     for ADC_CLKSEL = 0x1, 8 ADC CLOCK increments for ADC_CLKSEL
                                                     = 0x2.                                                                    */
    } ADCPWRDLY_b;
  } ;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint32_t ADCCAL;                      /*!< (@ 0x0000010C) ADC Calibration Control                                    */

    struct {
      __IOM uint32_t CALONPWRUP : 1;            /*!< [0..0] Run ADC Calibration on initial power up sequence                   */
      __IOM uint32_t ADCCALIBRATED : 1;         /*!< [1..1] Status for ADC Calibration                                         */
    } ADCCAL_b;
  } ;

  union {
    __IOM uint32_t ADCBATTLOAD;                 /*!< (@ 0x00000110) ADC Battery Load Enable                                    */

    struct {
      __IOM uint32_t BATTLOAD   : 1;            /*!< [0..0] Enable the ADC battery load resistor                               */
    } ADCBATTLOAD_b;
  } ;

  union {
    __IOM uint32_t BUCKTRIM;                    /*!< (@ 0x00000114) Trim settings for Core and Mem buck modules                */

    struct {
      __IOM uint32_t MEMBUCKR1  : 6;            /*!< [5..0] Trim values for BUCK regulator.                                    */
      __IM  uint32_t            : 2;
      __IOM uint32_t COREBUCKR1_LO : 6;         /*!< [13..8] Core Buck voltage output trim bits[5:0], Concatenate
                                                     with field COREBUCKR1_HI for the full trim value.                         */
      __IM  uint32_t            : 2;
      __IOM uint32_t COREBUCKR1_HI : 4;         /*!< [19..16] Core Buck voltage output trim bits[9:6]. Concatenate
                                                     with field COREBUCKR1_LO for the full trim value.                         */
      __IM  uint32_t            : 4;
      __IOM uint32_t RSVD2      : 6;            /*!< [29..24] RESERVED.                                                        */
    } BUCKTRIM_b;
  } ;
  __IM  uint32_t  RESERVED6[3];

  union {
    __IOM uint32_t XTALGENCTRL;                 /*!< (@ 0x00000124) XTAL Oscillator General Control                            */

    struct {
      __IOM uint32_t ACWARMUP   : 2;            /*!< [1..0] Auto-calibration delay control                                     */
      __IOM uint32_t XTALBIASTRIM : 6;          /*!< [7..2] XTAL IBIAS trim                                                    */
      __IOM uint32_t XTALKSBIASTRIM : 6;        /*!< [13..8] XTAL IBIAS Kick start trim . This trim value is used
                                                     during the startup process to enable a faster lock and
                                                     is applied when the kickstart signal is active.                           */
    } XTALGENCTRL_b;
  } ;
  __IM  uint32_t  RESERVED7[30];

  union {
    __IOM uint32_t BOOTLOADERLOW;               /*!< (@ 0x000001A0) Determines whether the bootloader code is visible
                                                                    at address 0x00000000                                      */

    struct {
      __IOM uint32_t VALUE      : 1;            /*!< [0..0] Determines whether the bootloader code is visible at
                                                     address 0x00000000 or not.                                                */
    } BOOTLOADERLOW_b;
  } ;

  union {
    __IOM uint32_t SHADOWVALID;                 /*!< (@ 0x000001A4) Register to indicate whether the shadow registers
                                                                    have been successfully loaded from the Flash
                                                                    Information Space.                                         */

    struct {
      __IOM uint32_t VALID      : 1;            /*!< [0..0] Indicates whether the shadow registers contain valid
                                                     data from the Flash Information Space.                                    */
      __IOM uint32_t BL_DSLEEP  : 1;            /*!< [1..1] Indicates whether the bootloader should sleep or deep
                                                     sleep if no image loaded.                                                 */
    } SHADOWVALID_b;
  } ;
  __IM  uint32_t  RESERVED8[6];

  union {
    __IOM uint32_t ICODEFAULTADDR;              /*!< (@ 0x000001C0) ICODE bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t ADDR       : 32;           /*!< [31..0] The ICODE bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } ICODEFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t DCODEFAULTADDR;              /*!< (@ 0x000001C4) DCODE bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t ADDR       : 32;           /*!< [31..0] The DCODE bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } DCODEFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t SYSFAULTADDR;                /*!< (@ 0x000001C8) System bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t ADDR       : 32;           /*!< [31..0] SYS bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } SYSFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t FAULTSTATUS;                 /*!< (@ 0x000001CC) Reflects the status of the bus decoders' fault
                                                                    detection. Any write to this register will
                                                                    clear all of the status bits within the
                                                                    register.                                                  */

    struct {
      __IOM uint32_t ICODE      : 1;            /*!< [0..0] The ICODE Bus Decoder Fault Detected bit. When set, a
                                                     fault has been detected, and the ICODEFAULTADDR register
                                                     will contain the bus address which generated the fault.                   */
      __IOM uint32_t DCODE      : 1;            /*!< [1..1] DCODE Bus Decoder Fault Detected bit. When set, a fault
                                                     has been detected, and the DCODEFAULTADDR register will
                                                     contain the bus address which generated the fault.                        */
      __IOM uint32_t SYS        : 1;            /*!< [2..2] SYS Bus Decoder Fault Detected bit. When set, a fault
                                                     has been detected, and the SYSFAULTADDR register will contain
                                                     the bus address which generated the fault.                                */
    } FAULTSTATUS_b;
  } ;

  union {
    __IOM uint32_t FAULTCAPTUREEN;              /*!< (@ 0x000001D0) Enable the fault capture registers                         */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] Fault Capture Enable field. When set, the Fault Capture
                                                     monitors are enabled and addresses which generate a hard
                                                     fault are captured into the FAULTADDR registers.                          */
    } FAULTCAPTUREEN_b;
  } ;
  __IM  uint32_t  RESERVED9[11];

  union {
    __IOM uint32_t DBGR1;                       /*!< (@ 0x00000200) Read-only debug register 1                                 */

    struct {
      __IOM uint32_t ONETO8     : 32;           /*!< [31..0] Read-only register for communication validation                   */
    } DBGR1_b;
  } ;

  union {
    __IOM uint32_t DBGR2;                       /*!< (@ 0x00000204) Read-only debug register 2                                 */

    struct {
      __IOM uint32_t COOLCODE   : 32;           /*!< [31..0] Read-only register for communication validation                   */
    } DBGR2_b;
  } ;
  __IM  uint32_t  RESERVED10[6];

  union {
    __IOM uint32_t PMUENABLE;                   /*!< (@ 0x00000220) Control bit to enable/disable the PMU                      */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] PMU Enable Control bit. When set, the MCU's PMU will
                                                     place the MCU into the lowest power consuming Deep Sleep
                                                     mode upon execution of a WFI instruction (dependent on
                                                     the setting of the SLEEPDEEP bit in the ARM SCR register).
                                                     When cleared, regardless of the requested sleep mode, the
                                                     PMU will not enter the lowest power Deep Sleep mode, instead
                                                     entering the Sleep mode.                                                  */
    } PMUENABLE_b;
  } ;
  __IM  uint32_t  RESERVED11[11];

  union {
    __IOM uint32_t TPIUCTRL;                    /*!< (@ 0x00000250) TPIU Control Register. Determines the clock enable
                                                                    and frequency for the M4's TPIU interface.                 */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] TPIU Enable field. When set, the ARM M4 TPIU is enabled
                                                     and data can be streamed out of the MCU's SWO port using
                                                     the ARM ITM and TPIU modules.                                             */
      __IM  uint32_t            : 7;
      __IOM uint32_t CLKSEL     : 3;            /*!< [10..8] This field selects the frequency of the ARM M4 TPIU
                                                     port.                                                                     */
    } TPIUCTRL_b;
  } ;
} MCUCTRL_Type;                                 /*!< Size = 596 (0x254)                                                        */



/* =========================================================================================================================== */
/* ================                                            PDM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief PDM Audio (PDM)
  */

typedef struct {                                /*!< (@ 0x50011000) PDM Structure                                              */

  union {
    __IOM uint32_t PCFG;                        /*!< (@ 0x00000000) PDM Configuration Register                                 */

    struct {
      __IOM uint32_t PDMCORE    : 1;            /*!< [0..0] Data Streaming Control.                                            */
      __IOM uint32_t SOFTMUTE   : 1;            /*!< [1..1] Soft mute control.                                                 */
      __IOM uint32_t CYCLES     : 3;            /*!< [4..2] Number of clocks during gain-setting changes.                      */
      __IOM uint32_t HPCUTOFF   : 4;            /*!< [8..5] High pass filter coefficients.                                     */
      __IOM uint32_t ADCHPD     : 1;            /*!< [9..9] High pass filter disable.                                          */
      __IOM uint32_t SINCRATE   : 7;            /*!< [16..10] SINC decimation rate.                                            */
      __IOM uint32_t MCLKDIV    : 2;            /*!< [18..17] PDM_CLK frequency divisor.                                       */
      __IM  uint32_t            : 4;
      __IOM uint32_t PGALEFT    : 4;            /*!< [26..23] Left channel PGA gain.                                           */
      __IOM uint32_t PGARIGHT   : 4;            /*!< [30..27] Right channel PGA gain.                                          */
      __IOM uint32_t LRSWAP     : 1;            /*!< [31..31] Left/right channel swap.                                         */
    } PCFG_b;
  } ;

  union {
    __IOM uint32_t VCFG;                        /*!< (@ 0x00000004) Voice Configuration Register                               */

    struct {
      __IM  uint32_t            : 3;
      __IOM uint32_t CHSET      : 2;            /*!< [4..3] Set PCM channels.                                                  */
      __IM  uint32_t            : 3;
      __IOM uint32_t PCMPACK    : 1;            /*!< [8..8] PCM data packing enable.                                           */
      __IM  uint32_t            : 7;
      __IOM uint32_t SELAP      : 1;            /*!< [16..16] Select PDM input clock source.                                   */
      __IOM uint32_t DMICKDEL   : 1;            /*!< [17..17] PDM clock sampling delay.                                        */
      __IM  uint32_t            : 1;
      __IOM uint32_t BCLKINV    : 1;            /*!< [19..19] I2S BCLK input inversion.                                        */
      __IOM uint32_t I2SMODE    : 1;            /*!< [20..20] I2S interface enable.                                            */
      __IM  uint32_t            : 5;
      __IOM uint32_t PDMCLK     : 1;            /*!< [26..26] Enable the serial clock.                                         */
      __IOM uint32_t PDMCLKSEL  : 3;            /*!< [29..27] Select the PDM input clock.                                      */
      __IOM uint32_t RSTB       : 1;            /*!< [30..30] Reset the IP core.                                               */
      __IOM uint32_t IOCLKEN    : 1;            /*!< [31..31] Enable the IO clock.                                             */
    } VCFG_b;
  } ;

  union {
    __IOM uint32_t FR;                          /*!< (@ 0x00000008) Voice Status Register                                      */

    struct {
      __IOM uint32_t FIFOCNT    : 9;            /*!< [8..0] Valid 32-bit entries currently in the FIFO.                        */
    } FR_b;
  } ;

  union {
    __IOM uint32_t FRD;                         /*!< (@ 0x0000000C) FIFO Read                                                  */

    struct {
      __IOM uint32_t FIFOREAD   : 32;           /*!< [31..0] FIFO read data.                                                   */
    } FRD_b;
  } ;

  union {
    __IOM uint32_t FLUSH;                       /*!< (@ 0x00000010) FIFO Flush                                                 */

    struct {
      __IOM uint32_t FIFOFLUSH  : 1;            /*!< [0..0] FIFO FLUSH.                                                        */
    } FLUSH_b;
  } ;

  union {
    __IOM uint32_t FTHR;                        /*!< (@ 0x00000014) FIFO Threshold                                             */

    struct {
      __IOM uint32_t FIFOTHR    : 8;            /*!< [7..0] FIFO interrupt threshold.                                          */
    } FTHR_b;
  } ;
  __IM  uint32_t  RESERVED[122];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Master Interrupts: Enable                               */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Master Interrupts: Status                               */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Master Interrupts: Clear                                */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Master Interrupts: Set                                  */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
    } INTSET_b;
  } ;
} PDM_Type;                                     /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                          PWRCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief PWR Controller Register Bank (PWRCTRL)
  */

typedef struct {                                /*!< (@ 0x40021000) PWRCTRL Structure                                          */

  union {
    __IOM uint32_t SUPPLYSRC;                   /*!< (@ 0x00000000) Memory and Core Voltage Supply Source Select
                                                                    Register                                                   */

    struct {
      __IOM uint32_t MEMBUCKEN  : 1;            /*!< [0..0] Enables and select the Memory Buck as the supply for
                                                     the Flash and SRAM power domain.                                          */
      __IOM uint32_t COREBUCKEN : 1;            /*!< [1..1] Enables and Selects the Core Buck as the supply for the
                                                     low-voltage power domain.                                                 */
      __IOM uint32_t SWITCH_LDO_IN_SLEEP : 1;   /*!< [2..2] Switches the CORE DOMAIN from BUCK mode (if enabled)
                                                     to LDO when CPU is in DEEP SLEEP. If all the devices are
                                                     off then this does not matter and LDO (low power mode)
                                                     is used                                                                   */
    } SUPPLYSRC_b;
  } ;

  union {
    __IOM uint32_t POWERSTATUS;                 /*!< (@ 0x00000004) Power Status Register for MCU supplies and peripherals     */

    struct {
      __IOM uint32_t MEMBUCKON  : 1;            /*!< [0..0] Indicate whether the Memory power domain is supplied
                                                     from the LDO or the Buck.                                                 */
      __IOM uint32_t COREBUCKON : 1;            /*!< [1..1] Indicates whether the Core low-voltage domain is supplied
                                                     from the LDO or the Buck.                                                 */
    } POWERSTATUS_b;
  } ;

  union {
    __IOM uint32_t DEVICEEN;                    /*!< (@ 0x00000008) DEVICE ENABLES for SHELBY                                  */

    struct {
      __IOM uint32_t IO_SLAVE   : 1;            /*!< [0..0] Enable IO SLAVE                                                    */
      __IOM uint32_t IO_MASTER0 : 1;            /*!< [1..1] Enable IO MASTER 0                                                 */
      __IOM uint32_t IO_MASTER1 : 1;            /*!< [2..2] Enable IO MASTER 1                                                 */
      __IOM uint32_t IO_MASTER2 : 1;            /*!< [3..3] Enable IO MASTER 2                                                 */
      __IOM uint32_t IO_MASTER3 : 1;            /*!< [4..4] Enable IO MASTER 3                                                 */
      __IOM uint32_t IO_MASTER4 : 1;            /*!< [5..5] Enable IO MASTER 4                                                 */
      __IOM uint32_t IO_MASTER5 : 1;            /*!< [6..6] Enable IO MASTER 5                                                 */
      __IOM uint32_t PWRUART0   : 1;            /*!< [7..7] Enable UART 0                                                      */
      __IOM uint32_t PWRUART1   : 1;            /*!< [8..8] Enable UART 1                                                      */
      __IOM uint32_t PWRADC     : 1;            /*!< [9..9] Enable ADC Digital Block                                           */
      __IOM uint32_t PWRPDM     : 1;            /*!< [10..10] Enable PDM Digital Block                                         */
    } DEVICEEN_b;
  } ;

  union {
    __IOM uint32_t SRAMPWDINSLEEP;              /*!< (@ 0x0000000C) Powerdown an SRAM Banks in Deep Sleep mode                 */

    struct {
      __IOM uint32_t SRAMSLEEPPOWERDOWN : 11;   /*!< [10..0] Selects which SRAM banks are powered down in deep sleep
                                                     mode, causing the contents of the bank to be lost.                        */
      __IM  uint32_t            : 20;
      __IOM uint32_t CACHE_PWD_SLP : 1;         /*!< [31..31] Enable CACHE BANKS to power down in deep sleep                   */
    } SRAMPWDINSLEEP_b;
  } ;

  union {
    __IOM uint32_t MEMEN;                       /*!< (@ 0x00000010) Disables individual banks of the MEMORY array              */

    struct {
      __IOM uint32_t SRAMEN     : 11;           /*!< [10..0] Enables power for selected SRAM banks (else an access
                                                     to its address space to generate a Hard Fault).                           */
      __IOM uint32_t FLASH0     : 1;            /*!< [11..11] Enable FLASH 0                                                   */
      __IOM uint32_t FLASH1     : 1;            /*!< [12..12] Enable FLASH1                                                    */
      __IM  uint32_t            : 16;
      __IOM uint32_t CACHEB0    : 1;            /*!< [29..29] Enable CACHE BANK 0                                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t CACHEB2    : 1;            /*!< [31..31] Enable CACHE BANK 2                                              */
    } MEMEN_b;
  } ;

  union {
    __IOM uint32_t PWRONSTATUS;                 /*!< (@ 0x00000014) POWER ON Status                                            */

    struct {
      __IM  uint32_t            : 1;
      __IOM uint32_t PDA        : 1;            /*!< [1..1] This bit is 1 if power is supplied to power domain A,
                                                     which supplies IOS and UART0,1.                                           */
      __IOM uint32_t PDB        : 1;            /*!< [2..2] This bit is 1 if power is supplied to power domain B,
                                                     which supplies IOM0-2.                                                    */
      __IOM uint32_t PDC        : 1;            /*!< [3..3] This bit is 1 if power is supplied to power domain C,
                                                     which supplies IOM3-5.                                                    */
      __IOM uint32_t PD_PDM     : 1;            /*!< [4..4] This bit is 1 if power is supplied to domain PD_PDM                */
      __IOM uint32_t PD_FLAM0   : 1;            /*!< [5..5] This bit is 1 if power is supplied to domain PD_FLAM0              */
      __IOM uint32_t PD_FLAM1   : 1;            /*!< [6..6] This bit is 1 if power is supplied to domain PD_FLAM1              */
      __IOM uint32_t PDADC      : 1;            /*!< [7..7] This bit is 1 if power is supplied to domain PD_ADC                */
      __IOM uint32_t PD_GRP0_SRAM0 : 1;         /*!< [8..8] This bit is 1 if power is supplied to SRAM domain SRAM0_0          */
      __IOM uint32_t PD_GRP0_SRAM1 : 1;         /*!< [9..9] This bit is 1 if power is supplied to SRAM domain SRAM0_1          */
      __IOM uint32_t PD_GRP0_SRAM2 : 1;         /*!< [10..10] This bit is 1 if power is supplied to SRAM domain PD_SRAM0_2     */
      __IOM uint32_t PD_GRP0_SRAM3 : 1;         /*!< [11..11] This bit is 1 if power is supplied to SRAM domain PD_SRAM0_3     */
      __IOM uint32_t PD_GRP1_SRAM : 1;          /*!< [12..12] This bit is 1 if power is supplied to SRAM domain PD_GRP1        */
      __IOM uint32_t PD_GRP2_SRAM : 1;          /*!< [13..13] This bit is 1 if power is supplied to SRAM domain PD_GRP2        */
      __IOM uint32_t PD_GRP3_SRAM : 1;          /*!< [14..14] This bit is 1 if power is supplied to SRAM domain PD_GRP3        */
      __IOM uint32_t PD_GRP4_SRAM : 1;          /*!< [15..15] This bit is 1 if power is supplied to SRAM domain PD_GRP4        */
      __IOM uint32_t PD_GRP5_SRAM : 1;          /*!< [16..16] This bit is 1 if power is supplied to SRAM domain PD_GRP5        */
      __IOM uint32_t PD_GRP6_SRAM : 1;          /*!< [17..17] This bit is 1 if power is supplied to SRAM domain PD_GRP6        */
      __IOM uint32_t PD_GRP7_SRAM : 1;          /*!< [18..18] This bit is 1 if power is supplied to SRAM domain PD_GRP7        */
      __IOM uint32_t PD_CACHEB0 : 1;            /*!< [19..19] This bit is 1 if power is supplied to CACHE BANK 0               */
      __IM  uint32_t            : 1;
      __IOM uint32_t PD_CACHEB2 : 1;            /*!< [21..21] This bit is 1 if power is supplied to CACHE BANK 2               */
    } PWRONSTATUS_b;
  } ;

  union {
    __IOM uint32_t SRAMCTRL;                    /*!< (@ 0x00000018) SRAM Control register                                      */

    struct {
      __IOM uint32_t SRAM_LIGHT_SLEEP : 1;      /*!< [0..0] Enable LS (light sleep) of cache RAMs. When this bit
                                                     is set, the RAMS will be put into light sleep mode while
                                                     inactive. NOTE: if the SRAM is actively used, this may
                                                     have an adverse affect on power since entering/exiting
                                                     LS mode may consume more power than would be saved.                       */
      __IOM uint32_t SRAM_CLKGATE : 1;          /*!< [1..1] Enables individual per-RAM clock gating in the SRAM block.
                                                     This bit should be enabled for lowest power operation.                    */
      __IOM uint32_t SRAM_MASTER_CLKGATE : 1;   /*!< [2..2] Enables top-level clock gating in the SRAM block. This
                                                     bit should be enabled for lowest power operation.                         */
    } SRAMCTRL_b;
  } ;

  union {
    __IOM uint32_t ADCSTATUS;                   /*!< (@ 0x0000001C) Power Status Register for ADC Block                        */

    struct {
      __IOM uint32_t ADC_PWD    : 1;            /*!< [0..0] This bit indicates that the ADC is powered down                    */
      __IOM uint32_t ADC_BGT_PWD : 1;           /*!< [1..1] This bit indicates that the ADC Band Gap is powered down           */
      __IOM uint32_t ADC_VPTAT_PWD : 1;         /*!< [2..2] This bit indicates that the ADC temperature sensor input
                                                     buffer is powered down                                                    */
      __IOM uint32_t ADC_VBAT_PWD : 1;          /*!< [3..3] This bit indicates that the ADC VBAT resistor divider
                                                     is powered down                                                           */
      __IOM uint32_t ADC_REFKEEP_PWD : 1;       /*!< [4..4] This bit indicates that the ADC REFKEEP is powered down            */
      __IOM uint32_t ADC_REFBUF_PWD : 1;        /*!< [5..5] This bit indicates that the ADC REFBUF is powered down             */
    } ADCSTATUS_b;
  } ;

  union {
    __IOM uint32_t MISCOPT;                     /*!< (@ 0x00000020) Power Optimization Control Bits                            */

    struct {
      __IM  uint32_t            : 2;
      __IOM uint32_t DIS_LDOLPMODE_TIMERS : 1;  /*!< [2..2] Setting this bit will enable the MEM LDO to be in LPMODE
                                                     during deep sleep even when the ctimers or stimers are
                                                     running                                                                   */
    } MISCOPT_b;
  } ;
} PWRCTRL_Type;                                 /*!< Size = 36 (0x24)                                                          */



/* =========================================================================================================================== */
/* ================                                          RSTGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief MCU Reset Generator (RSTGEN)
  */

typedef struct {                                /*!< (@ 0x40000000) RSTGEN Structure                                           */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */

    struct {
      __IOM uint32_t BODHREN    : 1;            /*!< [0..0] Brown out high (2.1v) reset enable.                                */
      __IOM uint32_t WDREN      : 1;            /*!< [1..1] Watchdog Timer Reset Enable. NOTE: The WDT module must
                                                     also be configured for WDT reset.                                         */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t SWPOI;                       /*!< (@ 0x00000004) Software POI Reset                                         */

    struct {
      __IOM uint32_t SWPOIKEY   : 8;            /*!< [7..0] 0x1B generates a software POI reset.                               */
    } SWPOI_b;
  } ;

  union {
    __IOM uint32_t SWPOR;                       /*!< (@ 0x00000008) Software POR Reset                                         */

    struct {
      __IOM uint32_t SWPORKEY   : 8;            /*!< [7..0] 0xD4 generates a software POR reset.                               */
    } SWPOR_b;
  } ;

  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x0000000C) Status Register                                            */

    struct {
      __IOM uint32_t EXRSTAT    : 1;            /*!< [0..0] Reset was initiated by an External Reset.                          */
      __IOM uint32_t PORSTAT    : 1;            /*!< [1..1] Reset was initiated by a Power-On Reset.                           */
      __IOM uint32_t BORSTAT    : 1;            /*!< [2..2] Reset was initiated by a Brown-Out Reset.                          */
      __IOM uint32_t SWRSTAT    : 1;            /*!< [3..3] Reset was a initiated by SW POR or AIRCR Reset.                    */
      __IOM uint32_t POIRSTAT   : 1;            /*!< [4..4] Reset was a initiated by Software POI Reset.                       */
      __IOM uint32_t DBGRSTAT   : 1;            /*!< [5..5] Reset was a initiated by Debugger Reset.                           */
      __IOM uint32_t WDRSTAT    : 1;            /*!< [6..6] Reset was initiated by a Watchdog Timer Reset.                     */
    } STAT_b;
  } ;

  union {
    __IOM uint32_t CLRSTAT;                     /*!< (@ 0x00000010) Clear the status register                                  */

    struct {
      __IOM uint32_t CLRSTAT    : 1;            /*!< [0..0] Writing a 1 to this bit clears all bits in the RST_STAT.           */
    } CLRSTAT_b;
  } ;

  union {
    __IOM uint32_t TPIU_RST;                    /*!< (@ 0x00000014) TPIU reset                                                 */

    struct {
      __IOM uint32_t TPIURST    : 1;            /*!< [0..0] Static reset for the TPIU. Write to '1' to assert reset
                                                     to TPIU. Write to '0' to clear the reset.                                 */
    } TPIU_RST_b;
  } ;
  __IM  uint32_t  RESERVED[122];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Reset Interrupt register: Enable                           */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Reset Interrupt register: Status                           */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Reset Interrupt register: Clear                            */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Reset Interrupt register: Set                              */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
    } INTSET_b;
  } ;
} RSTGEN_Type;                                  /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Real Time Clock (RTC)
  */

typedef struct {                                /*!< (@ 0x40004040) RTC Structure                                              */

  union {
    __IOM uint32_t CTRLOW;                      /*!< (@ 0x00000000) RTC Counters Lower                                         */

    struct {
      __IOM uint32_t CTR100     : 8;            /*!< [7..0] 100ths of a second Counter                                         */
      __IOM uint32_t CTRSEC     : 7;            /*!< [14..8] Seconds Counter                                                   */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTRMIN     : 7;            /*!< [22..16] Minutes Counter                                                  */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTRHR      : 6;            /*!< [29..24] Hours Counter                                                    */
    } CTRLOW_b;
  } ;

  union {
    __IOM uint32_t CTRUP;                       /*!< (@ 0x00000004) RTC Counters Upper                                         */

    struct {
      __IOM uint32_t CTRDATE    : 6;            /*!< [5..0] Date Counter                                                       */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTRMO      : 5;            /*!< [12..8] Months Counter                                                    */
      __IM  uint32_t            : 3;
      __IOM uint32_t CTRYR      : 8;            /*!< [23..16] Years Counter                                                    */
      __IOM uint32_t CTRWKDY    : 3;            /*!< [26..24] Weekdays Counter                                                 */
      __IOM uint32_t CB         : 1;            /*!< [27..27] Century                                                          */
      __IOM uint32_t CEB        : 1;            /*!< [28..28] Century enable                                                   */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTERR      : 1;            /*!< [31..31] Counter read error status                                        */
    } CTRUP_b;
  } ;

  union {
    __IOM uint32_t ALMLOW;                      /*!< (@ 0x00000008) RTC Alarms Lower                                           */

    struct {
      __IOM uint32_t ALM100     : 8;            /*!< [7..0] 100ths of a second Alarm                                           */
      __IOM uint32_t ALMSEC     : 7;            /*!< [14..8] Seconds Alarm                                                     */
      __IM  uint32_t            : 1;
      __IOM uint32_t ALMMIN     : 7;            /*!< [22..16] Minutes Alarm                                                    */
      __IM  uint32_t            : 1;
      __IOM uint32_t ALMHR      : 6;            /*!< [29..24] Hours Alarm                                                      */
    } ALMLOW_b;
  } ;

  union {
    __IOM uint32_t ALMUP;                       /*!< (@ 0x0000000C) RTC Alarms Upper                                           */

    struct {
      __IOM uint32_t ALMDATE    : 6;            /*!< [5..0] Date Alarm                                                         */
      __IM  uint32_t            : 2;
      __IOM uint32_t ALMMO      : 5;            /*!< [12..8] Months Alarm                                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t ALMWKDY    : 3;            /*!< [18..16] Weekdays Alarm                                                   */
    } ALMUP_b;
  } ;

  union {
    __IOM uint32_t RTCCTL;                      /*!< (@ 0x00000010) RTC Control Register                                       */

    struct {
      __IOM uint32_t WRTC       : 1;            /*!< [0..0] Counter write control                                              */
      __IOM uint32_t RPT        : 3;            /*!< [3..1] Alarm repeat interval                                              */
      __IOM uint32_t RSTOP      : 1;            /*!< [4..4] RTC input clock control                                            */
      __IOM uint32_t HR1224     : 1;            /*!< [5..5] Hours Counter mode                                                 */
    } RTCCTL_b;
  } ;
  __IM  uint32_t  RESERVED[43];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x000000C0) RTC Interrupt Register: Enable                             */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
      __IOM uint32_t ALM        : 1;            /*!< [3..3] RTC Alarm interrupt                                                */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x000000C4) RTC Interrupt Register: Status                             */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
      __IOM uint32_t ALM        : 1;            /*!< [3..3] RTC Alarm interrupt                                                */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x000000C8) RTC Interrupt Register: Clear                              */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
      __IOM uint32_t ALM        : 1;            /*!< [3..3] RTC Alarm interrupt                                                */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x000000CC) RTC Interrupt Register: Set                                */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
      __IOM uint32_t ALM        : 1;            /*!< [3..3] RTC Alarm interrupt                                                */
    } INTSET_b;
  } ;
} RTC_Type;                                     /*!< Size = 208 (0xd0)                                                         */



/* =========================================================================================================================== */
/* ================                                           UART0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial UART (UART0)
  */

typedef struct {                                /*!< (@ 0x4001C000) UART0 Structure                                            */

  union {
    __IOM uint32_t DR;                          /*!< (@ 0x00000000) UART Data Register                                         */

    struct {
      __IOM uint32_t DATA       : 8;            /*!< [7..0] This is the UART data port.                                        */
      __IOM uint32_t FEDATA     : 1;            /*!< [8..8] This is the framing error indicator.                               */
      __IOM uint32_t PEDATA     : 1;            /*!< [9..9] This is the parity error indicator.                                */
      __IOM uint32_t BEDATA     : 1;            /*!< [10..10] This is the break error indicator.                               */
      __IOM uint32_t OEDATA     : 1;            /*!< [11..11] This is the overrun error indicator.                             */
    } DR_b;
  } ;

  union {
    __IOM uint32_t RSR;                         /*!< (@ 0x00000004) UART Status Register                                       */

    struct {
      __IOM uint32_t FESTAT     : 1;            /*!< [0..0] This is the framing error indicator.                               */
      __IOM uint32_t PESTAT     : 1;            /*!< [1..1] This is the parity error indicator.                                */
      __IOM uint32_t BESTAT     : 1;            /*!< [2..2] This is the break error indicator.                                 */
      __IOM uint32_t OESTAT     : 1;            /*!< [3..3] This is the overrun error indicator.                               */
    } RSR_b;
  } ;
  __IM  uint32_t  RESERVED[4];

  union {
    __IOM uint32_t FR;                          /*!< (@ 0x00000018) Flag Register                                              */

    struct {
      __IOM uint32_t CTS        : 1;            /*!< [0..0] This bit holds the clear to send indicator.                        */
      __IOM uint32_t DSR        : 1;            /*!< [1..1] This bit holds the data set ready indicator.                       */
      __IOM uint32_t DCD        : 1;            /*!< [2..2] This bit holds the data carrier detect indicator.                  */
      __IOM uint32_t BUSY       : 1;            /*!< [3..3] This bit holds the busy indicator.                                 */
      __IOM uint32_t RXFE       : 1;            /*!< [4..4] This bit holds the receive FIFO empty indicator.                   */
      __IOM uint32_t TXFF       : 1;            /*!< [5..5] This bit holds the transmit FIFO full indicator.                   */
      __IOM uint32_t RXFF       : 1;            /*!< [6..6] This bit holds the receive FIFO full indicator.                    */
      __IOM uint32_t TXFE       : 1;            /*!< [7..7] This bit holds the transmit FIFO empty indicator.                  */
      __IOM uint32_t TXBUSY     : 1;            /*!< [8..8] This bit holds the transmit BUSY indicator.                        */
    } FR_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t ILPR;                        /*!< (@ 0x00000020) IrDA Counter                                               */

    struct {
      __IOM uint32_t ILPDVSR    : 8;            /*!< [7..0] These bits hold the IrDA counter divisor.                          */
    } ILPR_b;
  } ;

  union {
    __IOM uint32_t IBRD;                        /*!< (@ 0x00000024) Integer Baud Rate Divisor                                  */

    struct {
      __IOM uint32_t DIVINT     : 16;           /*!< [15..0] These bits hold the baud integer divisor.                         */
    } IBRD_b;
  } ;

  union {
    __IOM uint32_t FBRD;                        /*!< (@ 0x00000028) Fractional Baud Rate Divisor                               */

    struct {
      __IOM uint32_t DIVFRAC    : 6;            /*!< [5..0] These bits hold the baud fractional divisor.                       */
    } FBRD_b;
  } ;

  union {
    __IOM uint32_t LCRH;                        /*!< (@ 0x0000002C) Line Control High                                          */

    struct {
      __IOM uint32_t BRK        : 1;            /*!< [0..0] This bit holds the break set.                                      */
      __IOM uint32_t PEN        : 1;            /*!< [1..1] This bit holds the parity enable.                                  */
      __IOM uint32_t EPS        : 1;            /*!< [2..2] This bit holds the even parity select.                             */
      __IOM uint32_t STP2       : 1;            /*!< [3..3] This bit holds the two stop bits select.                           */
      __IOM uint32_t FEN        : 1;            /*!< [4..4] This bit holds the FIFO enable.                                    */
      __IOM uint32_t WLEN       : 2;            /*!< [6..5] These bits hold the write length.                                  */
      __IOM uint32_t SPS        : 1;            /*!< [7..7] This bit holds the stick parity select.                            */
    } LCRH_b;
  } ;

  union {
    __IOM uint32_t CR;                          /*!< (@ 0x00000030) Control Register                                           */

    struct {
      __IOM uint32_t UARTEN     : 1;            /*!< [0..0] This bit is the UART enable.                                       */
      __IOM uint32_t SIREN      : 1;            /*!< [1..1] This bit is the SIR ENDEC enable.                                  */
      __IOM uint32_t SIRLP      : 1;            /*!< [2..2] This bit is the SIR low power select.                              */
      __IOM uint32_t CLKEN      : 1;            /*!< [3..3] This bit is the UART clock enable.                                 */
      __IOM uint32_t CLKSEL     : 3;            /*!< [6..4] This bitfield is the UART clock select.                            */
      __IOM uint32_t LBE        : 1;            /*!< [7..7] This bit is the loopback enable.                                   */
      __IOM uint32_t TXE        : 1;            /*!< [8..8] This bit is the transmit enable.                                   */
      __IOM uint32_t RXE        : 1;            /*!< [9..9] This bit is the receive enable.                                    */
      __IOM uint32_t DTR        : 1;            /*!< [10..10] This bit enables data transmit ready.                            */
      __IOM uint32_t RTS        : 1;            /*!< [11..11] This bit enables request to send.                                */
      __IOM uint32_t OUT1       : 1;            /*!< [12..12] This bit holds modem Out1.                                       */
      __IOM uint32_t OUT2       : 1;            /*!< [13..13] This bit holds modem Out2.                                       */
      __IOM uint32_t RTSEN      : 1;            /*!< [14..14] This bit enables RTS hardware flow control.                      */
      __IOM uint32_t CTSEN      : 1;            /*!< [15..15] This bit enables CTS hardware flow control.                      */
    } CR_b;
  } ;

  union {
    __IOM uint32_t IFLS;                        /*!< (@ 0x00000034) FIFO Interrupt Level Select                                */

    struct {
      __IOM uint32_t TXIFLSEL   : 3;            /*!< [2..0] These bits hold the transmit FIFO interrupt level.                 */
      __IOM uint32_t RXIFLSEL   : 3;            /*!< [5..3] These bits hold the receive FIFO interrupt level.                  */
    } IFLS_b;
  } ;

  union {
    __IOM uint32_t IER;                         /*!< (@ 0x00000038) Interrupt Enable                                           */

    struct {
      __IOM uint32_t TXCMPMIM   : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt enable.                   */
      __IOM uint32_t CTSMIM     : 1;            /*!< [1..1] This bit holds the modem CTS interrupt enable.                     */
      __IOM uint32_t DCDMIM     : 1;            /*!< [2..2] This bit holds the modem DCD interrupt enable.                     */
      __IOM uint32_t DSRMIM     : 1;            /*!< [3..3] This bit holds the modem DSR interrupt enable.                     */
      __IOM uint32_t RXIM       : 1;            /*!< [4..4] This bit holds the receive interrupt enable.                       */
      __IOM uint32_t TXIM       : 1;            /*!< [5..5] This bit holds the transmit interrupt enable.                      */
      __IOM uint32_t RTIM       : 1;            /*!< [6..6] This bit holds the receive timeout interrupt enable.               */
      __IOM uint32_t FEIM       : 1;            /*!< [7..7] This bit holds the framing error interrupt enable.                 */
      __IOM uint32_t PEIM       : 1;            /*!< [8..8] This bit holds the parity error interrupt enable.                  */
      __IOM uint32_t BEIM       : 1;            /*!< [9..9] This bit holds the break error interrupt enable.                   */
      __IOM uint32_t OEIM       : 1;            /*!< [10..10] This bit holds the overflow interrupt enable.                    */
    } IER_b;
  } ;

  union {
    __IOM uint32_t IES;                         /*!< (@ 0x0000003C) Interrupt Status                                           */

    struct {
      __IOM uint32_t TXCMPMRIS  : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt status.                   */
      __IOM uint32_t CTSMRIS    : 1;            /*!< [1..1] This bit holds the modem CTS interrupt status.                     */
      __IOM uint32_t DCDMRIS    : 1;            /*!< [2..2] This bit holds the modem DCD interrupt status.                     */
      __IOM uint32_t DSRMRIS    : 1;            /*!< [3..3] This bit holds the modem DSR interrupt status.                     */
      __IOM uint32_t RXRIS      : 1;            /*!< [4..4] This bit holds the receive interrupt status.                       */
      __IOM uint32_t TXRIS      : 1;            /*!< [5..5] This bit holds the transmit interrupt status.                      */
      __IOM uint32_t RTRIS      : 1;            /*!< [6..6] This bit holds the receive timeout interrupt status.               */
      __IOM uint32_t FERIS      : 1;            /*!< [7..7] This bit holds the framing error interrupt status.                 */
      __IOM uint32_t PERIS      : 1;            /*!< [8..8] This bit holds the parity error interrupt status.                  */
      __IOM uint32_t BERIS      : 1;            /*!< [9..9] This bit holds the break error interrupt status.                   */
      __IOM uint32_t OERIS      : 1;            /*!< [10..10] This bit holds the overflow interrupt status.                    */
    } IES_b;
  } ;

  union {
    __IOM uint32_t MIS;                         /*!< (@ 0x00000040) Masked Interrupt Status                                    */

    struct {
      __IOM uint32_t TXCMPMMIS  : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt status masked.            */
      __IOM uint32_t CTSMMIS    : 1;            /*!< [1..1] This bit holds the modem CTS interrupt status masked.              */
      __IOM uint32_t DCDMMIS    : 1;            /*!< [2..2] This bit holds the modem DCD interrupt status masked.              */
      __IOM uint32_t DSRMMIS    : 1;            /*!< [3..3] This bit holds the modem DSR interrupt status masked.              */
      __IOM uint32_t RXMIS      : 1;            /*!< [4..4] This bit holds the receive interrupt status masked.                */
      __IOM uint32_t TXMIS      : 1;            /*!< [5..5] This bit holds the transmit interrupt status masked.               */
      __IOM uint32_t RTMIS      : 1;            /*!< [6..6] This bit holds the receive timeout interrupt status masked.        */
      __IOM uint32_t FEMIS      : 1;            /*!< [7..7] This bit holds the framing error interrupt status masked.          */
      __IOM uint32_t PEMIS      : 1;            /*!< [8..8] This bit holds the parity error interrupt status masked.           */
      __IOM uint32_t BEMIS      : 1;            /*!< [9..9] This bit holds the break error interrupt status masked.            */
      __IOM uint32_t OEMIS      : 1;            /*!< [10..10] This bit holds the overflow interrupt status masked.             */
    } MIS_b;
  } ;

  union {
    __IOM uint32_t IEC;                         /*!< (@ 0x00000044) Interrupt Clear                                            */

    struct {
      __IOM uint32_t TXCMPMIC   : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt clear.                    */
      __IOM uint32_t CTSMIC     : 1;            /*!< [1..1] This bit holds the modem CTS interrupt clear.                      */
      __IOM uint32_t DCDMIC     : 1;            /*!< [2..2] This bit holds the modem DCD interrupt clear.                      */
      __IOM uint32_t DSRMIC     : 1;            /*!< [3..3] This bit holds the modem DSR interrupt clear.                      */
      __IOM uint32_t RXIC       : 1;            /*!< [4..4] This bit holds the receive interrupt clear.                        */
      __IOM uint32_t TXIC       : 1;            /*!< [5..5] This bit holds the transmit interrupt clear.                       */
      __IOM uint32_t RTIC       : 1;            /*!< [6..6] This bit holds the receive timeout interrupt clear.                */
      __IOM uint32_t FEIC       : 1;            /*!< [7..7] This bit holds the framing error interrupt clear.                  */
      __IOM uint32_t PEIC       : 1;            /*!< [8..8] This bit holds the parity error interrupt clear.                   */
      __IOM uint32_t BEIC       : 1;            /*!< [9..9] This bit holds the break error interrupt clear.                    */
      __IOM uint32_t OEIC       : 1;            /*!< [10..10] This bit holds the overflow interrupt clear.                     */
    } IEC_b;
  } ;
} UART0_Type;                                   /*!< Size = 72 (0x48)                                                          */



/* =========================================================================================================================== */
/* ================                                           VCOMP                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Voltage Comparator (VCOMP)
  */

typedef struct {                                /*!< (@ 0x4000C000) VCOMP Structure                                            */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */

    struct {
      __IOM uint32_t PSEL       : 2;            /*!< [1..0] This bitfield selects the positive input to the comparator.        */
      __IM  uint32_t            : 6;
      __IOM uint32_t NSEL       : 2;            /*!< [9..8] This bitfield selects the negative input to the comparator.        */
      __IM  uint32_t            : 6;
      __IOM uint32_t LVLSEL     : 4;            /*!< [19..16] When the reference input NSEL is set to NSEL_DAC, this
                                                     bitfield selects the voltage level for the negative input
                                                     to the comparator.                                                        */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) Status Register                                            */

    struct {
      __IOM uint32_t CMPOUT     : 1;            /*!< [0..0] This bit is 1 if the positive input of the comparator
                                                     is greater than the negative input.                                       */
      __IOM uint32_t PWDSTAT    : 1;            /*!< [1..1] This bit indicates the power down state of the voltage
                                                     comparator.                                                               */
    } STAT_b;
  } ;

  union {
    __IOM uint32_t PWDKEY;                      /*!< (@ 0x00000008) Key Register for Powering Down the Voltage Comparator      */

    struct {
      __IOM uint32_t PWDKEY     : 32;           /*!< [31..0] Key register value.                                               */
    } PWDKEY_b;
  } ;
  __IM  uint32_t  RESERVED[125];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Voltage Comparator Interrupt registers: Enable             */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Voltage Comparator Interrupt registers: Status             */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Voltage Comparator Interrupt registers: Clear              */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Voltage Comparator Interrupt registers: Set                */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
    } INTSET_b;
  } ;
} VCOMP_Type;                                   /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Watchdog Timer (WDT)
  */

typedef struct {                                /*!< (@ 0x40024000) WDT Structure                                              */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */

    struct {
      __IOM uint32_t WDTEN      : 1;            /*!< [0..0] This bitfield enables the WDT.                                     */
      __IOM uint32_t INTEN      : 1;            /*!< [1..1] This bitfield enables the WDT interrupt. Note : This
                                                     bit must be set before the interrupt status bit will reflect
                                                     a watchdog timer expiration. The IER interrupt register
                                                     must also be enabled for a WDT interrupt to be sent to
                                                     the NVIC.                                                                 */
      __IOM uint32_t RESEN      : 1;            /*!< [2..2] This bitfield enables the WDT reset.                               */
      __IM  uint32_t            : 5;
      __IOM uint32_t RESVAL     : 8;            /*!< [15..8] This bitfield is the compare value for counter bits
                                                     7:0 to generate a watchdog reset.                                         */
      __IOM uint32_t INTVAL     : 8;            /*!< [23..16] This bitfield is the compare value for counter bits
                                                     7:0 to generate a watchdog interrupt.                                     */
      __IOM uint32_t CLKSEL     : 3;            /*!< [26..24] Select the frequency for the WDT. All values not enumerated
                                                     below are undefined.                                                      */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t RSTRT;                       /*!< (@ 0x00000004) Restart the watchdog timer                                 */

    struct {
      __IOM uint32_t RSTRT      : 8;            /*!< [7..0] Writing 0xB2 to WDTRSTRT restarts the watchdog timer.              */
    } RSTRT_b;
  } ;

  union {
    __IOM uint32_t LOCK;                        /*!< (@ 0x00000008) Locks the WDT                                              */

    struct {
      __IOM uint32_t LOCK       : 8;            /*!< [7..0] Writing 0x3A locks the watchdog timer. Once locked, the
                                                     WDTCFG reg cannot be written and WDTEN is set.                            */
    } LOCK_b;
  } ;

  union {
    __IOM uint32_t COUNT;                       /*!< (@ 0x0000000C) Current Counter Value for WDT                              */

    struct {
      __IOM uint32_t COUNT      : 8;            /*!< [7..0] Read-Only current value of the WDT counter                         */
    } COUNT_b;
  } ;
  __IM  uint32_t  RESERVED[124];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) WDT Interrupt register: Enable                             */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) WDT Interrupt register: Status                             */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) WDT Interrupt register: Clear                              */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) WDT Interrupt register: Set                                */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
    } INTSET_b;
  } ;
} WDT_Type;                                     /*!< Size = 528 (0x210)                                                        */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define ADC_BASE                    0x50010000UL
#define CACHECTRL_BASE              0x40018000UL
#define CLKGEN_BASE                 0x40004000UL
#define CTIMER_BASE                 0x40008000UL
#define GPIO_BASE                   0x40010000UL
#define IOMSTR0_BASE                0x50004000UL
#define IOMSTR1_BASE                0x50005000UL
#define IOMSTR2_BASE                0x50006000UL
#define IOMSTR3_BASE                0x50007000UL
#define IOMSTR4_BASE                0x50008000UL
#define IOMSTR5_BASE                0x50009000UL
#define IOSLAVE_BASE                0x50000000UL
#define MCUCTRL_BASE                0x40020000UL
#define PDM_BASE                    0x50011000UL
#define PWRCTRL_BASE                0x40021000UL
#define RSTGEN_BASE                 0x40000000UL
#define RTC_BASE                    0x40004040UL
#define UART0_BASE                  0x4001C000UL
#define UART1_BASE                  0x4001D000UL
#define VCOMP_BASE                  0x4000C000UL
#define WDT_BASE                    0x40024000UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define ADC                         ((ADC_Type*)               ADC_BASE)
#define CACHECTRL                   ((CACHECTRL_Type*)         CACHECTRL_BASE)
#define CLKGEN                      ((CLKGEN_Type*)            CLKGEN_BASE)
#define CTIMER                      ((CTIMER_Type*)            CTIMER_BASE)
#define GPIO                        ((GPIO_Type*)              GPIO_BASE)
#define IOMSTR0                     ((IOMSTR0_Type*)           IOMSTR0_BASE)
#define IOMSTR1                     ((IOMSTR0_Type*)           IOMSTR1_BASE)
#define IOMSTR2                     ((IOMSTR0_Type*)           IOMSTR2_BASE)
#define IOMSTR3                     ((IOMSTR0_Type*)           IOMSTR3_BASE)
#define IOMSTR4                     ((IOMSTR0_Type*)           IOMSTR4_BASE)
#define IOMSTR5                     ((IOMSTR0_Type*)           IOMSTR5_BASE)
#define IOSLAVE                     ((IOSLAVE_Type*)           IOSLAVE_BASE)
#define MCUCTRL                     ((MCUCTRL_Type*)           MCUCTRL_BASE)
#define PDM                         ((PDM_Type*)               PDM_BASE)
#define PWRCTRL                     ((PWRCTRL_Type*)           PWRCTRL_BASE)
#define RSTGEN                      ((RSTGEN_Type*)            RSTGEN_BASE)
#define RTC                         ((RTC_Type*)               RTC_BASE)
#define UART0                       ((UART0_Type*)             UART0_BASE)
#define UART1                       ((UART0_Type*)             UART1_BASE)
#define VCOMP                       ((VCOMP_Type*)             VCOMP_BASE)
#define WDT                         ((WDT_Type*)               WDT_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define ADC_CFG_CLKSEL_Pos                (24UL)                    /*!< CLKSEL (Bit 24)                                       */
#define ADC_CFG_CLKSEL_Msk                (0x3000000UL)             /*!< CLKSEL (Bitfield-Mask: 0x03)                          */
#define ADC_CFG_TRIGPOL_Pos               (19UL)                    /*!< TRIGPOL (Bit 19)                                      */
#define ADC_CFG_TRIGPOL_Msk               (0x80000UL)               /*!< TRIGPOL (Bitfield-Mask: 0x01)                         */
#define ADC_CFG_TRIGSEL_Pos               (16UL)                    /*!< TRIGSEL (Bit 16)                                      */
#define ADC_CFG_TRIGSEL_Msk               (0x70000UL)               /*!< TRIGSEL (Bitfield-Mask: 0x07)                         */
#define ADC_CFG_REFSEL_Pos                (8UL)                     /*!< REFSEL (Bit 8)                                        */
#define ADC_CFG_REFSEL_Msk                (0x300UL)                 /*!< REFSEL (Bitfield-Mask: 0x03)                          */
#define ADC_CFG_CKMODE_Pos                (4UL)                     /*!< CKMODE (Bit 4)                                        */
#define ADC_CFG_CKMODE_Msk                (0x10UL)                  /*!< CKMODE (Bitfield-Mask: 0x01)                          */
#define ADC_CFG_LPMODE_Pos                (3UL)                     /*!< LPMODE (Bit 3)                                        */
#define ADC_CFG_LPMODE_Msk                (0x8UL)                   /*!< LPMODE (Bitfield-Mask: 0x01)                          */
#define ADC_CFG_RPTEN_Pos                 (2UL)                     /*!< RPTEN (Bit 2)                                         */
#define ADC_CFG_RPTEN_Msk                 (0x4UL)                   /*!< RPTEN (Bitfield-Mask: 0x01)                           */
#define ADC_CFG_ADCEN_Pos                 (0UL)                     /*!< ADCEN (Bit 0)                                         */
#define ADC_CFG_ADCEN_Msk                 (0x1UL)                   /*!< ADCEN (Bitfield-Mask: 0x01)                           */
/* =========================================================  STAT  ========================================================== */
#define ADC_STAT_PWDSTAT_Pos              (0UL)                     /*!< PWDSTAT (Bit 0)                                       */
#define ADC_STAT_PWDSTAT_Msk              (0x1UL)                   /*!< PWDSTAT (Bitfield-Mask: 0x01)                         */
/* ==========================================================  SWT  ========================================================== */
#define ADC_SWT_SWT_Pos                   (0UL)                     /*!< SWT (Bit 0)                                           */
#define ADC_SWT_SWT_Msk                   (0xffUL)                  /*!< SWT (Bitfield-Mask: 0xff)                             */
/* ========================================================  SL0CFG  ========================================================= */
#define ADC_SL0CFG_ADSEL0_Pos             (24UL)                    /*!< ADSEL0 (Bit 24)                                       */
#define ADC_SL0CFG_ADSEL0_Msk             (0x7000000UL)             /*!< ADSEL0 (Bitfield-Mask: 0x07)                          */
#define ADC_SL0CFG_PRMODE0_Pos            (16UL)                    /*!< PRMODE0 (Bit 16)                                      */
#define ADC_SL0CFG_PRMODE0_Msk            (0x30000UL)               /*!< PRMODE0 (Bitfield-Mask: 0x03)                         */
#define ADC_SL0CFG_CHSEL0_Pos             (8UL)                     /*!< CHSEL0 (Bit 8)                                        */
#define ADC_SL0CFG_CHSEL0_Msk             (0xf00UL)                 /*!< CHSEL0 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL0CFG_WCEN0_Pos              (1UL)                     /*!< WCEN0 (Bit 1)                                         */
#define ADC_SL0CFG_WCEN0_Msk              (0x2UL)                   /*!< WCEN0 (Bitfield-Mask: 0x01)                           */
#define ADC_SL0CFG_SLEN0_Pos              (0UL)                     /*!< SLEN0 (Bit 0)                                         */
#define ADC_SL0CFG_SLEN0_Msk              (0x1UL)                   /*!< SLEN0 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL1CFG  ========================================================= */
#define ADC_SL1CFG_ADSEL1_Pos             (24UL)                    /*!< ADSEL1 (Bit 24)                                       */
#define ADC_SL1CFG_ADSEL1_Msk             (0x7000000UL)             /*!< ADSEL1 (Bitfield-Mask: 0x07)                          */
#define ADC_SL1CFG_PRMODE1_Pos            (16UL)                    /*!< PRMODE1 (Bit 16)                                      */
#define ADC_SL1CFG_PRMODE1_Msk            (0x30000UL)               /*!< PRMODE1 (Bitfield-Mask: 0x03)                         */
#define ADC_SL1CFG_CHSEL1_Pos             (8UL)                     /*!< CHSEL1 (Bit 8)                                        */
#define ADC_SL1CFG_CHSEL1_Msk             (0xf00UL)                 /*!< CHSEL1 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL1CFG_WCEN1_Pos              (1UL)                     /*!< WCEN1 (Bit 1)                                         */
#define ADC_SL1CFG_WCEN1_Msk              (0x2UL)                   /*!< WCEN1 (Bitfield-Mask: 0x01)                           */
#define ADC_SL1CFG_SLEN1_Pos              (0UL)                     /*!< SLEN1 (Bit 0)                                         */
#define ADC_SL1CFG_SLEN1_Msk              (0x1UL)                   /*!< SLEN1 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL2CFG  ========================================================= */
#define ADC_SL2CFG_ADSEL2_Pos             (24UL)                    /*!< ADSEL2 (Bit 24)                                       */
#define ADC_SL2CFG_ADSEL2_Msk             (0x7000000UL)             /*!< ADSEL2 (Bitfield-Mask: 0x07)                          */
#define ADC_SL2CFG_PRMODE2_Pos            (16UL)                    /*!< PRMODE2 (Bit 16)                                      */
#define ADC_SL2CFG_PRMODE2_Msk            (0x30000UL)               /*!< PRMODE2 (Bitfield-Mask: 0x03)                         */
#define ADC_SL2CFG_CHSEL2_Pos             (8UL)                     /*!< CHSEL2 (Bit 8)                                        */
#define ADC_SL2CFG_CHSEL2_Msk             (0xf00UL)                 /*!< CHSEL2 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL2CFG_WCEN2_Pos              (1UL)                     /*!< WCEN2 (Bit 1)                                         */
#define ADC_SL2CFG_WCEN2_Msk              (0x2UL)                   /*!< WCEN2 (Bitfield-Mask: 0x01)                           */
#define ADC_SL2CFG_SLEN2_Pos              (0UL)                     /*!< SLEN2 (Bit 0)                                         */
#define ADC_SL2CFG_SLEN2_Msk              (0x1UL)                   /*!< SLEN2 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL3CFG  ========================================================= */
#define ADC_SL3CFG_ADSEL3_Pos             (24UL)                    /*!< ADSEL3 (Bit 24)                                       */
#define ADC_SL3CFG_ADSEL3_Msk             (0x7000000UL)             /*!< ADSEL3 (Bitfield-Mask: 0x07)                          */
#define ADC_SL3CFG_PRMODE3_Pos            (16UL)                    /*!< PRMODE3 (Bit 16)                                      */
#define ADC_SL3CFG_PRMODE3_Msk            (0x30000UL)               /*!< PRMODE3 (Bitfield-Mask: 0x03)                         */
#define ADC_SL3CFG_CHSEL3_Pos             (8UL)                     /*!< CHSEL3 (Bit 8)                                        */
#define ADC_SL3CFG_CHSEL3_Msk             (0xf00UL)                 /*!< CHSEL3 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL3CFG_WCEN3_Pos              (1UL)                     /*!< WCEN3 (Bit 1)                                         */
#define ADC_SL3CFG_WCEN3_Msk              (0x2UL)                   /*!< WCEN3 (Bitfield-Mask: 0x01)                           */
#define ADC_SL3CFG_SLEN3_Pos              (0UL)                     /*!< SLEN3 (Bit 0)                                         */
#define ADC_SL3CFG_SLEN3_Msk              (0x1UL)                   /*!< SLEN3 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL4CFG  ========================================================= */
#define ADC_SL4CFG_ADSEL4_Pos             (24UL)                    /*!< ADSEL4 (Bit 24)                                       */
#define ADC_SL4CFG_ADSEL4_Msk             (0x7000000UL)             /*!< ADSEL4 (Bitfield-Mask: 0x07)                          */
#define ADC_SL4CFG_PRMODE4_Pos            (16UL)                    /*!< PRMODE4 (Bit 16)                                      */
#define ADC_SL4CFG_PRMODE4_Msk            (0x30000UL)               /*!< PRMODE4 (Bitfield-Mask: 0x03)                         */
#define ADC_SL4CFG_CHSEL4_Pos             (8UL)                     /*!< CHSEL4 (Bit 8)                                        */
#define ADC_SL4CFG_CHSEL4_Msk             (0xf00UL)                 /*!< CHSEL4 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL4CFG_WCEN4_Pos              (1UL)                     /*!< WCEN4 (Bit 1)                                         */
#define ADC_SL4CFG_WCEN4_Msk              (0x2UL)                   /*!< WCEN4 (Bitfield-Mask: 0x01)                           */
#define ADC_SL4CFG_SLEN4_Pos              (0UL)                     /*!< SLEN4 (Bit 0)                                         */
#define ADC_SL4CFG_SLEN4_Msk              (0x1UL)                   /*!< SLEN4 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL5CFG  ========================================================= */
#define ADC_SL5CFG_ADSEL5_Pos             (24UL)                    /*!< ADSEL5 (Bit 24)                                       */
#define ADC_SL5CFG_ADSEL5_Msk             (0x7000000UL)             /*!< ADSEL5 (Bitfield-Mask: 0x07)                          */
#define ADC_SL5CFG_PRMODE5_Pos            (16UL)                    /*!< PRMODE5 (Bit 16)                                      */
#define ADC_SL5CFG_PRMODE5_Msk            (0x30000UL)               /*!< PRMODE5 (Bitfield-Mask: 0x03)                         */
#define ADC_SL5CFG_CHSEL5_Pos             (8UL)                     /*!< CHSEL5 (Bit 8)                                        */
#define ADC_SL5CFG_CHSEL5_Msk             (0xf00UL)                 /*!< CHSEL5 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL5CFG_WCEN5_Pos              (1UL)                     /*!< WCEN5 (Bit 1)                                         */
#define ADC_SL5CFG_WCEN5_Msk              (0x2UL)                   /*!< WCEN5 (Bitfield-Mask: 0x01)                           */
#define ADC_SL5CFG_SLEN5_Pos              (0UL)                     /*!< SLEN5 (Bit 0)                                         */
#define ADC_SL5CFG_SLEN5_Msk              (0x1UL)                   /*!< SLEN5 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL6CFG  ========================================================= */
#define ADC_SL6CFG_ADSEL6_Pos             (24UL)                    /*!< ADSEL6 (Bit 24)                                       */
#define ADC_SL6CFG_ADSEL6_Msk             (0x7000000UL)             /*!< ADSEL6 (Bitfield-Mask: 0x07)                          */
#define ADC_SL6CFG_PRMODE6_Pos            (16UL)                    /*!< PRMODE6 (Bit 16)                                      */
#define ADC_SL6CFG_PRMODE6_Msk            (0x30000UL)               /*!< PRMODE6 (Bitfield-Mask: 0x03)                         */
#define ADC_SL6CFG_CHSEL6_Pos             (8UL)                     /*!< CHSEL6 (Bit 8)                                        */
#define ADC_SL6CFG_CHSEL6_Msk             (0xf00UL)                 /*!< CHSEL6 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL6CFG_WCEN6_Pos              (1UL)                     /*!< WCEN6 (Bit 1)                                         */
#define ADC_SL6CFG_WCEN6_Msk              (0x2UL)                   /*!< WCEN6 (Bitfield-Mask: 0x01)                           */
#define ADC_SL6CFG_SLEN6_Pos              (0UL)                     /*!< SLEN6 (Bit 0)                                         */
#define ADC_SL6CFG_SLEN6_Msk              (0x1UL)                   /*!< SLEN6 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL7CFG  ========================================================= */
#define ADC_SL7CFG_ADSEL7_Pos             (24UL)                    /*!< ADSEL7 (Bit 24)                                       */
#define ADC_SL7CFG_ADSEL7_Msk             (0x7000000UL)             /*!< ADSEL7 (Bitfield-Mask: 0x07)                          */
#define ADC_SL7CFG_PRMODE7_Pos            (16UL)                    /*!< PRMODE7 (Bit 16)                                      */
#define ADC_SL7CFG_PRMODE7_Msk            (0x30000UL)               /*!< PRMODE7 (Bitfield-Mask: 0x03)                         */
#define ADC_SL7CFG_CHSEL7_Pos             (8UL)                     /*!< CHSEL7 (Bit 8)                                        */
#define ADC_SL7CFG_CHSEL7_Msk             (0xf00UL)                 /*!< CHSEL7 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL7CFG_WCEN7_Pos              (1UL)                     /*!< WCEN7 (Bit 1)                                         */
#define ADC_SL7CFG_WCEN7_Msk              (0x2UL)                   /*!< WCEN7 (Bitfield-Mask: 0x01)                           */
#define ADC_SL7CFG_SLEN7_Pos              (0UL)                     /*!< SLEN7 (Bit 0)                                         */
#define ADC_SL7CFG_SLEN7_Msk              (0x1UL)                   /*!< SLEN7 (Bitfield-Mask: 0x01)                           */
/* =========================================================  WULIM  ========================================================= */
#define ADC_WULIM_ULIM_Pos                (0UL)                     /*!< ULIM (Bit 0)                                          */
#define ADC_WULIM_ULIM_Msk                (0xfffffUL)               /*!< ULIM (Bitfield-Mask: 0xfffff)                         */
/* =========================================================  WLLIM  ========================================================= */
#define ADC_WLLIM_LLIM_Pos                (0UL)                     /*!< LLIM (Bit 0)                                          */
#define ADC_WLLIM_LLIM_Msk                (0xfffffUL)               /*!< LLIM (Bitfield-Mask: 0xfffff)                         */
/* =========================================================  FIFO  ========================================================== */
#define ADC_FIFO_RSVD_Pos                 (31UL)                    /*!< RSVD (Bit 31)                                         */
#define ADC_FIFO_RSVD_Msk                 (0x80000000UL)            /*!< RSVD (Bitfield-Mask: 0x01)                            */
#define ADC_FIFO_SLOTNUM_Pos              (28UL)                    /*!< SLOTNUM (Bit 28)                                      */
#define ADC_FIFO_SLOTNUM_Msk              (0x70000000UL)            /*!< SLOTNUM (Bitfield-Mask: 0x07)                         */
#define ADC_FIFO_COUNT_Pos                (20UL)                    /*!< COUNT (Bit 20)                                        */
#define ADC_FIFO_COUNT_Msk                (0xff00000UL)             /*!< COUNT (Bitfield-Mask: 0xff)                           */
#define ADC_FIFO_DATA_Pos                 (0UL)                     /*!< DATA (Bit 0)                                          */
#define ADC_FIFO_DATA_Msk                 (0xfffffUL)               /*!< DATA (Bitfield-Mask: 0xfffff)                         */
/* =========================================================  INTEN  ========================================================= */
#define ADC_INTEN_WCINC_Pos               (5UL)                     /*!< WCINC (Bit 5)                                         */
#define ADC_INTEN_WCINC_Msk               (0x20UL)                  /*!< WCINC (Bitfield-Mask: 0x01)                           */
#define ADC_INTEN_WCEXC_Pos               (4UL)                     /*!< WCEXC (Bit 4)                                         */
#define ADC_INTEN_WCEXC_Msk               (0x10UL)                  /*!< WCEXC (Bitfield-Mask: 0x01)                           */
#define ADC_INTEN_FIFOOVR2_Pos            (3UL)                     /*!< FIFOOVR2 (Bit 3)                                      */
#define ADC_INTEN_FIFOOVR2_Msk            (0x8UL)                   /*!< FIFOOVR2 (Bitfield-Mask: 0x01)                        */
#define ADC_INTEN_FIFOOVR1_Pos            (2UL)                     /*!< FIFOOVR1 (Bit 2)                                      */
#define ADC_INTEN_FIFOOVR1_Msk            (0x4UL)                   /*!< FIFOOVR1 (Bitfield-Mask: 0x01)                        */
#define ADC_INTEN_SCNCMP_Pos              (1UL)                     /*!< SCNCMP (Bit 1)                                        */
#define ADC_INTEN_SCNCMP_Msk              (0x2UL)                   /*!< SCNCMP (Bitfield-Mask: 0x01)                          */
#define ADC_INTEN_CNVCMP_Pos              (0UL)                     /*!< CNVCMP (Bit 0)                                        */
#define ADC_INTEN_CNVCMP_Msk              (0x1UL)                   /*!< CNVCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSTAT  ======================================================== */
#define ADC_INTSTAT_WCINC_Pos             (5UL)                     /*!< WCINC (Bit 5)                                         */
#define ADC_INTSTAT_WCINC_Msk             (0x20UL)                  /*!< WCINC (Bitfield-Mask: 0x01)                           */
#define ADC_INTSTAT_WCEXC_Pos             (4UL)                     /*!< WCEXC (Bit 4)                                         */
#define ADC_INTSTAT_WCEXC_Msk             (0x10UL)                  /*!< WCEXC (Bitfield-Mask: 0x01)                           */
#define ADC_INTSTAT_FIFOOVR2_Pos          (3UL)                     /*!< FIFOOVR2 (Bit 3)                                      */
#define ADC_INTSTAT_FIFOOVR2_Msk          (0x8UL)                   /*!< FIFOOVR2 (Bitfield-Mask: 0x01)                        */
#define ADC_INTSTAT_FIFOOVR1_Pos          (2UL)                     /*!< FIFOOVR1 (Bit 2)                                      */
#define ADC_INTSTAT_FIFOOVR1_Msk          (0x4UL)                   /*!< FIFOOVR1 (Bitfield-Mask: 0x01)                        */
#define ADC_INTSTAT_SCNCMP_Pos            (1UL)                     /*!< SCNCMP (Bit 1)                                        */
#define ADC_INTSTAT_SCNCMP_Msk            (0x2UL)                   /*!< SCNCMP (Bitfield-Mask: 0x01)                          */
#define ADC_INTSTAT_CNVCMP_Pos            (0UL)                     /*!< CNVCMP (Bit 0)                                        */
#define ADC_INTSTAT_CNVCMP_Msk            (0x1UL)                   /*!< CNVCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTCLR  ========================================================= */
#define ADC_INTCLR_WCINC_Pos              (5UL)                     /*!< WCINC (Bit 5)                                         */
#define ADC_INTCLR_WCINC_Msk              (0x20UL)                  /*!< WCINC (Bitfield-Mask: 0x01)                           */
#define ADC_INTCLR_WCEXC_Pos              (4UL)                     /*!< WCEXC (Bit 4)                                         */
#define ADC_INTCLR_WCEXC_Msk              (0x10UL)                  /*!< WCEXC (Bitfield-Mask: 0x01)                           */
#define ADC_INTCLR_FIFOOVR2_Pos           (3UL)                     /*!< FIFOOVR2 (Bit 3)                                      */
#define ADC_INTCLR_FIFOOVR2_Msk           (0x8UL)                   /*!< FIFOOVR2 (Bitfield-Mask: 0x01)                        */
#define ADC_INTCLR_FIFOOVR1_Pos           (2UL)                     /*!< FIFOOVR1 (Bit 2)                                      */
#define ADC_INTCLR_FIFOOVR1_Msk           (0x4UL)                   /*!< FIFOOVR1 (Bitfield-Mask: 0x01)                        */
#define ADC_INTCLR_SCNCMP_Pos             (1UL)                     /*!< SCNCMP (Bit 1)                                        */
#define ADC_INTCLR_SCNCMP_Msk             (0x2UL)                   /*!< SCNCMP (Bitfield-Mask: 0x01)                          */
#define ADC_INTCLR_CNVCMP_Pos             (0UL)                     /*!< CNVCMP (Bit 0)                                        */
#define ADC_INTCLR_CNVCMP_Msk             (0x1UL)                   /*!< CNVCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSET  ========================================================= */
#define ADC_INTSET_WCINC_Pos              (5UL)                     /*!< WCINC (Bit 5)                                         */
#define ADC_INTSET_WCINC_Msk              (0x20UL)                  /*!< WCINC (Bitfield-Mask: 0x01)                           */
#define ADC_INTSET_WCEXC_Pos              (4UL)                     /*!< WCEXC (Bit 4)                                         */
#define ADC_INTSET_WCEXC_Msk              (0x10UL)                  /*!< WCEXC (Bitfield-Mask: 0x01)                           */
#define ADC_INTSET_FIFOOVR2_Pos           (3UL)                     /*!< FIFOOVR2 (Bit 3)                                      */
#define ADC_INTSET_FIFOOVR2_Msk           (0x8UL)                   /*!< FIFOOVR2 (Bitfield-Mask: 0x01)                        */
#define ADC_INTSET_FIFOOVR1_Pos           (2UL)                     /*!< FIFOOVR1 (Bit 2)                                      */
#define ADC_INTSET_FIFOOVR1_Msk           (0x4UL)                   /*!< FIFOOVR1 (Bitfield-Mask: 0x01)                        */
#define ADC_INTSET_SCNCMP_Pos             (1UL)                     /*!< SCNCMP (Bit 1)                                        */
#define ADC_INTSET_SCNCMP_Msk             (0x2UL)                   /*!< SCNCMP (Bitfield-Mask: 0x01)                          */
#define ADC_INTSET_CNVCMP_Pos             (0UL)                     /*!< CNVCMP (Bit 0)                                        */
#define ADC_INTSET_CNVCMP_Msk             (0x1UL)                   /*!< CNVCMP (Bitfield-Mask: 0x01)                          */


/* =========================================================================================================================== */
/* ================                                         CACHECTRL                                         ================ */
/* =========================================================================================================================== */

/* =======================================================  CACHECFG  ======================================================== */
#define CACHECTRL_CACHECFG_ENABLE_MONITOR_Pos (24UL)                /*!< ENABLE_MONITOR (Bit 24)                               */
#define CACHECTRL_CACHECFG_ENABLE_MONITOR_Msk (0x1000000UL)         /*!< ENABLE_MONITOR (Bitfield-Mask: 0x01)                  */
#define CACHECTRL_CACHECFG_DATA_CLKGATE_Pos (20UL)                  /*!< DATA_CLKGATE (Bit 20)                                 */
#define CACHECTRL_CACHECFG_DATA_CLKGATE_Msk (0x100000UL)            /*!< DATA_CLKGATE (Bitfield-Mask: 0x01)                    */
#define CACHECTRL_CACHECFG_SMDLY_Pos      (16UL)                    /*!< SMDLY (Bit 16)                                        */
#define CACHECTRL_CACHECFG_SMDLY_Msk      (0xf0000UL)               /*!< SMDLY (Bitfield-Mask: 0x0f)                           */
#define CACHECTRL_CACHECFG_DLY_Pos        (12UL)                    /*!< DLY (Bit 12)                                          */
#define CACHECTRL_CACHECFG_DLY_Msk        (0xf000UL)                /*!< DLY (Bitfield-Mask: 0x0f)                             */
#define CACHECTRL_CACHECFG_CACHE_LS_Pos   (11UL)                    /*!< CACHE_LS (Bit 11)                                     */
#define CACHECTRL_CACHECFG_CACHE_LS_Msk   (0x800UL)                 /*!< CACHE_LS (Bitfield-Mask: 0x01)                        */
#define CACHECTRL_CACHECFG_CACHE_CLKGATE_Pos (10UL)                 /*!< CACHE_CLKGATE (Bit 10)                                */
#define CACHECTRL_CACHECFG_CACHE_CLKGATE_Msk (0x400UL)              /*!< CACHE_CLKGATE (Bitfield-Mask: 0x01)                   */
#define CACHECTRL_CACHECFG_DCACHE_ENABLE_Pos (9UL)                  /*!< DCACHE_ENABLE (Bit 9)                                 */
#define CACHECTRL_CACHECFG_DCACHE_ENABLE_Msk (0x200UL)              /*!< DCACHE_ENABLE (Bitfield-Mask: 0x01)                   */
#define CACHECTRL_CACHECFG_ICACHE_ENABLE_Pos (8UL)                  /*!< ICACHE_ENABLE (Bit 8)                                 */
#define CACHECTRL_CACHECFG_ICACHE_ENABLE_Msk (0x100UL)              /*!< ICACHE_ENABLE (Bitfield-Mask: 0x01)                   */
#define CACHECTRL_CACHECFG_SERIAL_Pos     (7UL)                     /*!< SERIAL (Bit 7)                                        */
#define CACHECTRL_CACHECFG_SERIAL_Msk     (0x80UL)                  /*!< SERIAL (Bitfield-Mask: 0x01)                          */
#define CACHECTRL_CACHECFG_CONFIG_Pos     (4UL)                     /*!< CONFIG (Bit 4)                                        */
#define CACHECTRL_CACHECFG_CONFIG_Msk     (0x70UL)                  /*!< CONFIG (Bitfield-Mask: 0x07)                          */
#define CACHECTRL_CACHECFG_ENABLE_NC1_Pos (3UL)                     /*!< ENABLE_NC1 (Bit 3)                                    */
#define CACHECTRL_CACHECFG_ENABLE_NC1_Msk (0x8UL)                   /*!< ENABLE_NC1 (Bitfield-Mask: 0x01)                      */
#define CACHECTRL_CACHECFG_ENABLE_NC0_Pos (2UL)                     /*!< ENABLE_NC0 (Bit 2)                                    */
#define CACHECTRL_CACHECFG_ENABLE_NC0_Msk (0x4UL)                   /*!< ENABLE_NC0 (Bitfield-Mask: 0x01)                      */
#define CACHECTRL_CACHECFG_LRU_Pos        (1UL)                     /*!< LRU (Bit 1)                                           */
#define CACHECTRL_CACHECFG_LRU_Msk        (0x2UL)                   /*!< LRU (Bitfield-Mask: 0x01)                             */
#define CACHECTRL_CACHECFG_ENABLE_Pos     (0UL)                     /*!< ENABLE (Bit 0)                                        */
#define CACHECTRL_CACHECFG_ENABLE_Msk     (0x1UL)                   /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* =======================================================  FLASHCFG  ======================================================== */
#define CACHECTRL_FLASHCFG_RD_WAIT_Pos    (0UL)                     /*!< RD_WAIT (Bit 0)                                       */
#define CACHECTRL_FLASHCFG_RD_WAIT_Msk    (0x7UL)                   /*!< RD_WAIT (Bitfield-Mask: 0x07)                         */
/* =========================================================  CTRL  ========================================================== */
#define CACHECTRL_CTRL_FLASH1_SLM_ENABLE_Pos (10UL)                 /*!< FLASH1_SLM_ENABLE (Bit 10)                            */
#define CACHECTRL_CTRL_FLASH1_SLM_ENABLE_Msk (0x400UL)              /*!< FLASH1_SLM_ENABLE (Bitfield-Mask: 0x01)               */
#define CACHECTRL_CTRL_FLASH1_SLM_DISABLE_Pos (9UL)                 /*!< FLASH1_SLM_DISABLE (Bit 9)                            */
#define CACHECTRL_CTRL_FLASH1_SLM_DISABLE_Msk (0x200UL)             /*!< FLASH1_SLM_DISABLE (Bitfield-Mask: 0x01)              */
#define CACHECTRL_CTRL_FLASH1_SLM_STATUS_Pos (8UL)                  /*!< FLASH1_SLM_STATUS (Bit 8)                             */
#define CACHECTRL_CTRL_FLASH1_SLM_STATUS_Msk (0x100UL)              /*!< FLASH1_SLM_STATUS (Bitfield-Mask: 0x01)               */
#define CACHECTRL_CTRL_FLASH0_SLM_ENABLE_Pos (6UL)                  /*!< FLASH0_SLM_ENABLE (Bit 6)                             */
#define CACHECTRL_CTRL_FLASH0_SLM_ENABLE_Msk (0x40UL)               /*!< FLASH0_SLM_ENABLE (Bitfield-Mask: 0x01)               */
#define CACHECTRL_CTRL_FLASH0_SLM_DISABLE_Pos (5UL)                 /*!< FLASH0_SLM_DISABLE (Bit 5)                            */
#define CACHECTRL_CTRL_FLASH0_SLM_DISABLE_Msk (0x20UL)              /*!< FLASH0_SLM_DISABLE (Bitfield-Mask: 0x01)              */
#define CACHECTRL_CTRL_FLASH0_SLM_STATUS_Pos (4UL)                  /*!< FLASH0_SLM_STATUS (Bit 4)                             */
#define CACHECTRL_CTRL_FLASH0_SLM_STATUS_Msk (0x10UL)               /*!< FLASH0_SLM_STATUS (Bitfield-Mask: 0x01)               */
#define CACHECTRL_CTRL_CACHE_READY_Pos    (2UL)                     /*!< CACHE_READY (Bit 2)                                   */
#define CACHECTRL_CTRL_CACHE_READY_Msk    (0x4UL)                   /*!< CACHE_READY (Bitfield-Mask: 0x01)                     */
#define CACHECTRL_CTRL_RESET_STAT_Pos     (1UL)                     /*!< RESET_STAT (Bit 1)                                    */
#define CACHECTRL_CTRL_RESET_STAT_Msk     (0x2UL)                   /*!< RESET_STAT (Bitfield-Mask: 0x01)                      */
#define CACHECTRL_CTRL_INVALIDATE_Pos     (0UL)                     /*!< INVALIDATE (Bit 0)                                    */
#define CACHECTRL_CTRL_INVALIDATE_Msk     (0x1UL)                   /*!< INVALIDATE (Bitfield-Mask: 0x01)                      */
/* =======================================================  NCR0START  ======================================================= */
#define CACHECTRL_NCR0START_ADDR_Pos      (4UL)                     /*!< ADDR (Bit 4)                                          */
#define CACHECTRL_NCR0START_ADDR_Msk      (0xffff0UL)               /*!< ADDR (Bitfield-Mask: 0xffff)                          */
/* ========================================================  NCR0END  ======================================================== */
#define CACHECTRL_NCR0END_ADDR_Pos        (4UL)                     /*!< ADDR (Bit 4)                                          */
#define CACHECTRL_NCR0END_ADDR_Msk        (0xffff0UL)               /*!< ADDR (Bitfield-Mask: 0xffff)                          */
/* =======================================================  NCR1START  ======================================================= */
#define CACHECTRL_NCR1START_ADDR_Pos      (4UL)                     /*!< ADDR (Bit 4)                                          */
#define CACHECTRL_NCR1START_ADDR_Msk      (0xffff0UL)               /*!< ADDR (Bitfield-Mask: 0xffff)                          */
/* ========================================================  NCR1END  ======================================================== */
#define CACHECTRL_NCR1END_ADDR_Pos        (4UL)                     /*!< ADDR (Bit 4)                                          */
#define CACHECTRL_NCR1END_ADDR_Msk        (0xffff0UL)               /*!< ADDR (Bitfield-Mask: 0xffff)                          */
/* =======================================================  CACHEMODE  ======================================================= */
#define CACHECTRL_CACHEMODE_THROTTLE6_Pos (5UL)                     /*!< THROTTLE6 (Bit 5)                                     */
#define CACHECTRL_CACHEMODE_THROTTLE6_Msk (0x20UL)                  /*!< THROTTLE6 (Bitfield-Mask: 0x01)                       */
#define CACHECTRL_CACHEMODE_THROTTLE5_Pos (4UL)                     /*!< THROTTLE5 (Bit 4)                                     */
#define CACHECTRL_CACHEMODE_THROTTLE5_Msk (0x10UL)                  /*!< THROTTLE5 (Bitfield-Mask: 0x01)                       */
#define CACHECTRL_CACHEMODE_THROTTLE4_Pos (3UL)                     /*!< THROTTLE4 (Bit 3)                                     */
#define CACHECTRL_CACHEMODE_THROTTLE4_Msk (0x8UL)                   /*!< THROTTLE4 (Bitfield-Mask: 0x01)                       */
#define CACHECTRL_CACHEMODE_THROTTLE3_Pos (2UL)                     /*!< THROTTLE3 (Bit 2)                                     */
#define CACHECTRL_CACHEMODE_THROTTLE3_Msk (0x4UL)                   /*!< THROTTLE3 (Bitfield-Mask: 0x01)                       */
#define CACHECTRL_CACHEMODE_THROTTLE2_Pos (1UL)                     /*!< THROTTLE2 (Bit 1)                                     */
#define CACHECTRL_CACHEMODE_THROTTLE2_Msk (0x2UL)                   /*!< THROTTLE2 (Bitfield-Mask: 0x01)                       */
#define CACHECTRL_CACHEMODE_THROTTLE1_Pos (0UL)                     /*!< THROTTLE1 (Bit 0)                                     */
#define CACHECTRL_CACHEMODE_THROTTLE1_Msk (0x1UL)                   /*!< THROTTLE1 (Bitfield-Mask: 0x01)                       */
/* =========================================================  DMON0  ========================================================= */
#define CACHECTRL_DMON0_DACCESS_COUNT_Pos (0UL)                     /*!< DACCESS_COUNT (Bit 0)                                 */
#define CACHECTRL_DMON0_DACCESS_COUNT_Msk (0xffffffffUL)            /*!< DACCESS_COUNT (Bitfield-Mask: 0xffffffff)             */
/* =========================================================  DMON1  ========================================================= */
#define CACHECTRL_DMON1_DLOOKUP_COUNT_Pos (0UL)                     /*!< DLOOKUP_COUNT (Bit 0)                                 */
#define CACHECTRL_DMON1_DLOOKUP_COUNT_Msk (0xffffffffUL)            /*!< DLOOKUP_COUNT (Bitfield-Mask: 0xffffffff)             */
/* =========================================================  DMON2  ========================================================= */
#define CACHECTRL_DMON2_DHIT_COUNT_Pos    (0UL)                     /*!< DHIT_COUNT (Bit 0)                                    */
#define CACHECTRL_DMON2_DHIT_COUNT_Msk    (0xffffffffUL)            /*!< DHIT_COUNT (Bitfield-Mask: 0xffffffff)                */
/* =========================================================  DMON3  ========================================================= */
#define CACHECTRL_DMON3_DLINE_COUNT_Pos   (0UL)                     /*!< DLINE_COUNT (Bit 0)                                   */
#define CACHECTRL_DMON3_DLINE_COUNT_Msk   (0xffffffffUL)            /*!< DLINE_COUNT (Bitfield-Mask: 0xffffffff)               */
/* =========================================================  IMON0  ========================================================= */
#define CACHECTRL_IMON0_IACCESS_COUNT_Pos (0UL)                     /*!< IACCESS_COUNT (Bit 0)                                 */
#define CACHECTRL_IMON0_IACCESS_COUNT_Msk (0xffffffffUL)            /*!< IACCESS_COUNT (Bitfield-Mask: 0xffffffff)             */
/* =========================================================  IMON1  ========================================================= */
#define CACHECTRL_IMON1_ILOOKUP_COUNT_Pos (0UL)                     /*!< ILOOKUP_COUNT (Bit 0)                                 */
#define CACHECTRL_IMON1_ILOOKUP_COUNT_Msk (0xffffffffUL)            /*!< ILOOKUP_COUNT (Bitfield-Mask: 0xffffffff)             */
/* =========================================================  IMON2  ========================================================= */
#define CACHECTRL_IMON2_IHIT_COUNT_Pos    (0UL)                     /*!< IHIT_COUNT (Bit 0)                                    */
#define CACHECTRL_IMON2_IHIT_COUNT_Msk    (0xffffffffUL)            /*!< IHIT_COUNT (Bitfield-Mask: 0xffffffff)                */
/* =========================================================  IMON3  ========================================================= */
#define CACHECTRL_IMON3_ILINE_COUNT_Pos   (0UL)                     /*!< ILINE_COUNT (Bit 0)                                   */
#define CACHECTRL_IMON3_ILINE_COUNT_Msk   (0xffffffffUL)            /*!< ILINE_COUNT (Bitfield-Mask: 0xffffffff)               */


/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  CALXT  ========================================================= */
#define CLKGEN_CALXT_CALXT_Pos            (0UL)                     /*!< CALXT (Bit 0)                                         */
#define CLKGEN_CALXT_CALXT_Msk            (0x7ffUL)                 /*!< CALXT (Bitfield-Mask: 0x7ff)                          */
/* =========================================================  CALRC  ========================================================= */
#define CLKGEN_CALRC_CALRC_Pos            (0UL)                     /*!< CALRC (Bit 0)                                         */
#define CLKGEN_CALRC_CALRC_Msk            (0x3ffffUL)               /*!< CALRC (Bitfield-Mask: 0x3ffff)                        */
/* ========================================================  ACALCTR  ======================================================== */
#define CLKGEN_ACALCTR_ACALCTR_Pos        (0UL)                     /*!< ACALCTR (Bit 0)                                       */
#define CLKGEN_ACALCTR_ACALCTR_Msk        (0xffffffUL)              /*!< ACALCTR (Bitfield-Mask: 0xffffff)                     */
/* =========================================================  OCTRL  ========================================================= */
#define CLKGEN_OCTRL_ACAL_Pos             (8UL)                     /*!< ACAL (Bit 8)                                          */
#define CLKGEN_OCTRL_ACAL_Msk             (0x700UL)                 /*!< ACAL (Bitfield-Mask: 0x07)                            */
#define CLKGEN_OCTRL_OSEL_Pos             (7UL)                     /*!< OSEL (Bit 7)                                          */
#define CLKGEN_OCTRL_OSEL_Msk             (0x80UL)                  /*!< OSEL (Bitfield-Mask: 0x01)                            */
#define CLKGEN_OCTRL_FOS_Pos              (6UL)                     /*!< FOS (Bit 6)                                           */
#define CLKGEN_OCTRL_FOS_Msk              (0x40UL)                  /*!< FOS (Bitfield-Mask: 0x01)                             */
#define CLKGEN_OCTRL_STOPRC_Pos           (1UL)                     /*!< STOPRC (Bit 1)                                        */
#define CLKGEN_OCTRL_STOPRC_Msk           (0x2UL)                   /*!< STOPRC (Bitfield-Mask: 0x01)                          */
#define CLKGEN_OCTRL_STOPXT_Pos           (0UL)                     /*!< STOPXT (Bit 0)                                        */
#define CLKGEN_OCTRL_STOPXT_Msk           (0x1UL)                   /*!< STOPXT (Bitfield-Mask: 0x01)                          */
/* ========================================================  CLKOUT  ========================================================= */
#define CLKGEN_CLKOUT_CKEN_Pos            (7UL)                     /*!< CKEN (Bit 7)                                          */
#define CLKGEN_CLKOUT_CKEN_Msk            (0x80UL)                  /*!< CKEN (Bitfield-Mask: 0x01)                            */
#define CLKGEN_CLKOUT_CKSEL_Pos           (0UL)                     /*!< CKSEL (Bit 0)                                         */
#define CLKGEN_CLKOUT_CKSEL_Msk           (0x3fUL)                  /*!< CKSEL (Bitfield-Mask: 0x3f)                           */
/* ========================================================  CLKKEY  ========================================================= */
#define CLKGEN_CLKKEY_CLKKEY_Pos          (0UL)                     /*!< CLKKEY (Bit 0)                                        */
#define CLKGEN_CLKKEY_CLKKEY_Msk          (0xffffffffUL)            /*!< CLKKEY (Bitfield-Mask: 0xffffffff)                    */
/* =========================================================  CCTRL  ========================================================= */
#define CLKGEN_CCTRL_CORESEL_Pos          (0UL)                     /*!< CORESEL (Bit 0)                                       */
#define CLKGEN_CCTRL_CORESEL_Msk          (0x1UL)                   /*!< CORESEL (Bitfield-Mask: 0x01)                         */
/* ========================================================  STATUS  ========================================================= */
#define CLKGEN_STATUS_OSCF_Pos            (1UL)                     /*!< OSCF (Bit 1)                                          */
#define CLKGEN_STATUS_OSCF_Msk            (0x2UL)                   /*!< OSCF (Bitfield-Mask: 0x01)                            */
#define CLKGEN_STATUS_OMODE_Pos           (0UL)                     /*!< OMODE (Bit 0)                                         */
#define CLKGEN_STATUS_OMODE_Msk           (0x1UL)                   /*!< OMODE (Bitfield-Mask: 0x01)                           */
/* =========================================================  HFADJ  ========================================================= */
#define CLKGEN_HFADJ_HFADJ_GAIN_Pos       (21UL)                    /*!< HFADJ_GAIN (Bit 21)                                   */
#define CLKGEN_HFADJ_HFADJ_GAIN_Msk       (0xe00000UL)              /*!< HFADJ_GAIN (Bitfield-Mask: 0x07)                      */
#define CLKGEN_HFADJ_HFWARMUP_Pos         (20UL)                    /*!< HFWARMUP (Bit 20)                                     */
#define CLKGEN_HFADJ_HFWARMUP_Msk         (0x100000UL)              /*!< HFWARMUP (Bitfield-Mask: 0x01)                        */
#define CLKGEN_HFADJ_HFXTADJ_Pos          (8UL)                     /*!< HFXTADJ (Bit 8)                                       */
#define CLKGEN_HFADJ_HFXTADJ_Msk          (0xfff00UL)               /*!< HFXTADJ (Bitfield-Mask: 0xfff)                        */
#define CLKGEN_HFADJ_HFADJCK_Pos          (1UL)                     /*!< HFADJCK (Bit 1)                                       */
#define CLKGEN_HFADJ_HFADJCK_Msk          (0xeUL)                   /*!< HFADJCK (Bitfield-Mask: 0x07)                         */
#define CLKGEN_HFADJ_HFADJEN_Pos          (0UL)                     /*!< HFADJEN (Bit 0)                                       */
#define CLKGEN_HFADJ_HFADJEN_Msk          (0x1UL)                   /*!< HFADJEN (Bitfield-Mask: 0x01)                         */
/* ========================================================  CLOCKEN  ======================================================== */
#define CLKGEN_CLOCKEN_CLOCKEN_Pos        (0UL)                     /*!< CLOCKEN (Bit 0)                                       */
#define CLKGEN_CLOCKEN_CLOCKEN_Msk        (0xffffffffUL)            /*!< CLOCKEN (Bitfield-Mask: 0xffffffff)                   */
/* =======================================================  CLOCKEN2  ======================================================== */
#define CLKGEN_CLOCKEN2_CLOCKEN2_Pos      (0UL)                     /*!< CLOCKEN2 (Bit 0)                                      */
#define CLKGEN_CLOCKEN2_CLOCKEN2_Msk      (0xffffffffUL)            /*!< CLOCKEN2 (Bitfield-Mask: 0xffffffff)                  */
/* =======================================================  CLOCKEN3  ======================================================== */
#define CLKGEN_CLOCKEN3_CLOCKEN3_Pos      (0UL)                     /*!< CLOCKEN3 (Bit 0)                                      */
#define CLKGEN_CLOCKEN3_CLOCKEN3_Msk      (0xffffffffUL)            /*!< CLOCKEN3 (Bitfield-Mask: 0xffffffff)                  */
/* ========================================================  UARTEN  ========================================================= */
#define CLKGEN_UARTEN_UART1EN_Pos         (8UL)                     /*!< UART1EN (Bit 8)                                       */
#define CLKGEN_UARTEN_UART1EN_Msk         (0x300UL)                 /*!< UART1EN (Bitfield-Mask: 0x03)                         */
#define CLKGEN_UARTEN_UART0EN_Pos         (0UL)                     /*!< UART0EN (Bit 0)                                       */
#define CLKGEN_UARTEN_UART0EN_Msk         (0x3UL)                   /*!< UART0EN (Bitfield-Mask: 0x03)                         */
/* =========================================================  INTEN  ========================================================= */
#define CLKGEN_INTEN_ALM_Pos              (3UL)                     /*!< ALM (Bit 3)                                           */
#define CLKGEN_INTEN_ALM_Msk              (0x8UL)                   /*!< ALM (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTEN_OF_Pos               (2UL)                     /*!< OF (Bit 2)                                            */
#define CLKGEN_INTEN_OF_Msk               (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define CLKGEN_INTEN_ACC_Pos              (1UL)                     /*!< ACC (Bit 1)                                           */
#define CLKGEN_INTEN_ACC_Msk              (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTEN_ACF_Pos              (0UL)                     /*!< ACF (Bit 0)                                           */
#define CLKGEN_INTEN_ACF_Msk              (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */
/* ========================================================  INTSTAT  ======================================================== */
#define CLKGEN_INTSTAT_ALM_Pos            (3UL)                     /*!< ALM (Bit 3)                                           */
#define CLKGEN_INTSTAT_ALM_Msk            (0x8UL)                   /*!< ALM (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTSTAT_OF_Pos             (2UL)                     /*!< OF (Bit 2)                                            */
#define CLKGEN_INTSTAT_OF_Msk             (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define CLKGEN_INTSTAT_ACC_Pos            (1UL)                     /*!< ACC (Bit 1)                                           */
#define CLKGEN_INTSTAT_ACC_Msk            (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTSTAT_ACF_Pos            (0UL)                     /*!< ACF (Bit 0)                                           */
#define CLKGEN_INTSTAT_ACF_Msk            (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */
/* ========================================================  INTCLR  ========================================================= */
#define CLKGEN_INTCLR_ALM_Pos             (3UL)                     /*!< ALM (Bit 3)                                           */
#define CLKGEN_INTCLR_ALM_Msk             (0x8UL)                   /*!< ALM (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTCLR_OF_Pos              (2UL)                     /*!< OF (Bit 2)                                            */
#define CLKGEN_INTCLR_OF_Msk              (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define CLKGEN_INTCLR_ACC_Pos             (1UL)                     /*!< ACC (Bit 1)                                           */
#define CLKGEN_INTCLR_ACC_Msk             (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTCLR_ACF_Pos             (0UL)                     /*!< ACF (Bit 0)                                           */
#define CLKGEN_INTCLR_ACF_Msk             (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */
/* ========================================================  INTSET  ========================================================= */
#define CLKGEN_INTSET_ALM_Pos             (3UL)                     /*!< ALM (Bit 3)                                           */
#define CLKGEN_INTSET_ALM_Msk             (0x8UL)                   /*!< ALM (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTSET_OF_Pos              (2UL)                     /*!< OF (Bit 2)                                            */
#define CLKGEN_INTSET_OF_Msk              (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define CLKGEN_INTSET_ACC_Pos             (1UL)                     /*!< ACC (Bit 1)                                           */
#define CLKGEN_INTSET_ACC_Msk             (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTSET_ACF_Pos             (0UL)                     /*!< ACF (Bit 0)                                           */
#define CLKGEN_INTSET_ACF_Msk             (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */


/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  TMR0  ========================================================== */
#define CTIMER_TMR0_CTTMRB0_Pos           (16UL)                    /*!< CTTMRB0 (Bit 16)                                      */
#define CTIMER_TMR0_CTTMRB0_Msk           (0xffff0000UL)            /*!< CTTMRB0 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR0_CTTMRA0_Pos           (0UL)                     /*!< CTTMRA0 (Bit 0)                                       */
#define CTIMER_TMR0_CTTMRA0_Msk           (0xffffUL)                /*!< CTTMRA0 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA0  ========================================================= */
#define CTIMER_CMPRA0_CMPR1A0_Pos         (16UL)                    /*!< CMPR1A0 (Bit 16)                                      */
#define CTIMER_CMPRA0_CMPR1A0_Msk         (0xffff0000UL)            /*!< CMPR1A0 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA0_CMPR0A0_Pos         (0UL)                     /*!< CMPR0A0 (Bit 0)                                       */
#define CTIMER_CMPRA0_CMPR0A0_Msk         (0xffffUL)                /*!< CMPR0A0 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB0  ========================================================= */
#define CTIMER_CMPRB0_CMPR1B0_Pos         (16UL)                    /*!< CMPR1B0 (Bit 16)                                      */
#define CTIMER_CMPRB0_CMPR1B0_Msk         (0xffff0000UL)            /*!< CMPR1B0 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB0_CMPR0B0_Pos         (0UL)                     /*!< CMPR0B0 (Bit 0)                                       */
#define CTIMER_CMPRB0_CMPR0B0_Msk         (0xffffUL)                /*!< CMPR0B0 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL0  ========================================================= */
#define CTIMER_CTRL0_CTLINK0_Pos          (31UL)                    /*!< CTLINK0 (Bit 31)                                      */
#define CTIMER_CTRL0_CTLINK0_Msk          (0x80000000UL)            /*!< CTLINK0 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL0_TMRB0PE_Pos          (29UL)                    /*!< TMRB0PE (Bit 29)                                      */
#define CTIMER_CTRL0_TMRB0PE_Msk          (0x20000000UL)            /*!< TMRB0PE (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL0_TMRB0POL_Pos         (28UL)                    /*!< TMRB0POL (Bit 28)                                     */
#define CTIMER_CTRL0_TMRB0POL_Msk         (0x10000000UL)            /*!< TMRB0POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRB0CLR_Pos         (27UL)                    /*!< TMRB0CLR (Bit 27)                                     */
#define CTIMER_CTRL0_TMRB0CLR_Msk         (0x8000000UL)             /*!< TMRB0CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRB0IE1_Pos         (26UL)                    /*!< TMRB0IE1 (Bit 26)                                     */
#define CTIMER_CTRL0_TMRB0IE1_Msk         (0x4000000UL)             /*!< TMRB0IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRB0IE0_Pos         (25UL)                    /*!< TMRB0IE0 (Bit 25)                                     */
#define CTIMER_CTRL0_TMRB0IE0_Msk         (0x2000000UL)             /*!< TMRB0IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRB0FN_Pos          (22UL)                    /*!< TMRB0FN (Bit 22)                                      */
#define CTIMER_CTRL0_TMRB0FN_Msk          (0x1c00000UL)             /*!< TMRB0FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL0_TMRB0CLK_Pos         (17UL)                    /*!< TMRB0CLK (Bit 17)                                     */
#define CTIMER_CTRL0_TMRB0CLK_Msk         (0x3e0000UL)              /*!< TMRB0CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL0_TMRB0EN_Pos          (16UL)                    /*!< TMRB0EN (Bit 16)                                      */
#define CTIMER_CTRL0_TMRB0EN_Msk          (0x10000UL)               /*!< TMRB0EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL0_TMRA0PE_Pos          (13UL)                    /*!< TMRA0PE (Bit 13)                                      */
#define CTIMER_CTRL0_TMRA0PE_Msk          (0x2000UL)                /*!< TMRA0PE (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL0_TMRA0POL_Pos         (12UL)                    /*!< TMRA0POL (Bit 12)                                     */
#define CTIMER_CTRL0_TMRA0POL_Msk         (0x1000UL)                /*!< TMRA0POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRA0CLR_Pos         (11UL)                    /*!< TMRA0CLR (Bit 11)                                     */
#define CTIMER_CTRL0_TMRA0CLR_Msk         (0x800UL)                 /*!< TMRA0CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRA0IE1_Pos         (10UL)                    /*!< TMRA0IE1 (Bit 10)                                     */
#define CTIMER_CTRL0_TMRA0IE1_Msk         (0x400UL)                 /*!< TMRA0IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRA0IE0_Pos         (9UL)                     /*!< TMRA0IE0 (Bit 9)                                      */
#define CTIMER_CTRL0_TMRA0IE0_Msk         (0x200UL)                 /*!< TMRA0IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRA0FN_Pos          (6UL)                     /*!< TMRA0FN (Bit 6)                                       */
#define CTIMER_CTRL0_TMRA0FN_Msk          (0x1c0UL)                 /*!< TMRA0FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL0_TMRA0CLK_Pos         (1UL)                     /*!< TMRA0CLK (Bit 1)                                      */
#define CTIMER_CTRL0_TMRA0CLK_Msk         (0x3eUL)                  /*!< TMRA0CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL0_TMRA0EN_Pos          (0UL)                     /*!< TMRA0EN (Bit 0)                                       */
#define CTIMER_CTRL0_TMRA0EN_Msk          (0x1UL)                   /*!< TMRA0EN (Bitfield-Mask: 0x01)                         */
/* =========================================================  TMR1  ========================================================== */
#define CTIMER_TMR1_CTTMRB1_Pos           (16UL)                    /*!< CTTMRB1 (Bit 16)                                      */
#define CTIMER_TMR1_CTTMRB1_Msk           (0xffff0000UL)            /*!< CTTMRB1 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR1_CTTMRA1_Pos           (0UL)                     /*!< CTTMRA1 (Bit 0)                                       */
#define CTIMER_TMR1_CTTMRA1_Msk           (0xffffUL)                /*!< CTTMRA1 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA1  ========================================================= */
#define CTIMER_CMPRA1_CMPR1A1_Pos         (16UL)                    /*!< CMPR1A1 (Bit 16)                                      */
#define CTIMER_CMPRA1_CMPR1A1_Msk         (0xffff0000UL)            /*!< CMPR1A1 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA1_CMPR0A1_Pos         (0UL)                     /*!< CMPR0A1 (Bit 0)                                       */
#define CTIMER_CMPRA1_CMPR0A1_Msk         (0xffffUL)                /*!< CMPR0A1 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB1  ========================================================= */
#define CTIMER_CMPRB1_CMPR1B1_Pos         (16UL)                    /*!< CMPR1B1 (Bit 16)                                      */
#define CTIMER_CMPRB1_CMPR1B1_Msk         (0xffff0000UL)            /*!< CMPR1B1 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB1_CMPR0B1_Pos         (0UL)                     /*!< CMPR0B1 (Bit 0)                                       */
#define CTIMER_CMPRB1_CMPR0B1_Msk         (0xffffUL)                /*!< CMPR0B1 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL1  ========================================================= */
#define CTIMER_CTRL1_CTLINK1_Pos          (31UL)                    /*!< CTLINK1 (Bit 31)                                      */
#define CTIMER_CTRL1_CTLINK1_Msk          (0x80000000UL)            /*!< CTLINK1 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL1_TMRB1PE_Pos          (29UL)                    /*!< TMRB1PE (Bit 29)                                      */
#define CTIMER_CTRL1_TMRB1PE_Msk          (0x20000000UL)            /*!< TMRB1PE (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL1_TMRB1POL_Pos         (28UL)                    /*!< TMRB1POL (Bit 28)                                     */
#define CTIMER_CTRL1_TMRB1POL_Msk         (0x10000000UL)            /*!< TMRB1POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRB1CLR_Pos         (27UL)                    /*!< TMRB1CLR (Bit 27)                                     */
#define CTIMER_CTRL1_TMRB1CLR_Msk         (0x8000000UL)             /*!< TMRB1CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRB1IE1_Pos         (26UL)                    /*!< TMRB1IE1 (Bit 26)                                     */
#define CTIMER_CTRL1_TMRB1IE1_Msk         (0x4000000UL)             /*!< TMRB1IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRB1IE0_Pos         (25UL)                    /*!< TMRB1IE0 (Bit 25)                                     */
#define CTIMER_CTRL1_TMRB1IE0_Msk         (0x2000000UL)             /*!< TMRB1IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRB1FN_Pos          (22UL)                    /*!< TMRB1FN (Bit 22)                                      */
#define CTIMER_CTRL1_TMRB1FN_Msk          (0x1c00000UL)             /*!< TMRB1FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL1_TMRB1CLK_Pos         (17UL)                    /*!< TMRB1CLK (Bit 17)                                     */
#define CTIMER_CTRL1_TMRB1CLK_Msk         (0x3e0000UL)              /*!< TMRB1CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL1_TMRB1EN_Pos          (16UL)                    /*!< TMRB1EN (Bit 16)                                      */
#define CTIMER_CTRL1_TMRB1EN_Msk          (0x10000UL)               /*!< TMRB1EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL1_TMRA1PE_Pos          (13UL)                    /*!< TMRA1PE (Bit 13)                                      */
#define CTIMER_CTRL1_TMRA1PE_Msk          (0x2000UL)                /*!< TMRA1PE (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL1_TMRA1POL_Pos         (12UL)                    /*!< TMRA1POL (Bit 12)                                     */
#define CTIMER_CTRL1_TMRA1POL_Msk         (0x1000UL)                /*!< TMRA1POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRA1CLR_Pos         (11UL)                    /*!< TMRA1CLR (Bit 11)                                     */
#define CTIMER_CTRL1_TMRA1CLR_Msk         (0x800UL)                 /*!< TMRA1CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRA1IE1_Pos         (10UL)                    /*!< TMRA1IE1 (Bit 10)                                     */
#define CTIMER_CTRL1_TMRA1IE1_Msk         (0x400UL)                 /*!< TMRA1IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRA1IE0_Pos         (9UL)                     /*!< TMRA1IE0 (Bit 9)                                      */
#define CTIMER_CTRL1_TMRA1IE0_Msk         (0x200UL)                 /*!< TMRA1IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRA1FN_Pos          (6UL)                     /*!< TMRA1FN (Bit 6)                                       */
#define CTIMER_CTRL1_TMRA1FN_Msk          (0x1c0UL)                 /*!< TMRA1FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL1_TMRA1CLK_Pos         (1UL)                     /*!< TMRA1CLK (Bit 1)                                      */
#define CTIMER_CTRL1_TMRA1CLK_Msk         (0x3eUL)                  /*!< TMRA1CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL1_TMRA1EN_Pos          (0UL)                     /*!< TMRA1EN (Bit 0)                                       */
#define CTIMER_CTRL1_TMRA1EN_Msk          (0x1UL)                   /*!< TMRA1EN (Bitfield-Mask: 0x01)                         */
/* =========================================================  TMR2  ========================================================== */
#define CTIMER_TMR2_CTTMRB2_Pos           (16UL)                    /*!< CTTMRB2 (Bit 16)                                      */
#define CTIMER_TMR2_CTTMRB2_Msk           (0xffff0000UL)            /*!< CTTMRB2 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR2_CTTMRA2_Pos           (0UL)                     /*!< CTTMRA2 (Bit 0)                                       */
#define CTIMER_TMR2_CTTMRA2_Msk           (0xffffUL)                /*!< CTTMRA2 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA2  ========================================================= */
#define CTIMER_CMPRA2_CMPR1A2_Pos         (16UL)                    /*!< CMPR1A2 (Bit 16)                                      */
#define CTIMER_CMPRA2_CMPR1A2_Msk         (0xffff0000UL)            /*!< CMPR1A2 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA2_CMPR0A2_Pos         (0UL)                     /*!< CMPR0A2 (Bit 0)                                       */
#define CTIMER_CMPRA2_CMPR0A2_Msk         (0xffffUL)                /*!< CMPR0A2 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB2  ========================================================= */
#define CTIMER_CMPRB2_CMPR1B2_Pos         (16UL)                    /*!< CMPR1B2 (Bit 16)                                      */
#define CTIMER_CMPRB2_CMPR1B2_Msk         (0xffff0000UL)            /*!< CMPR1B2 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB2_CMPR0B2_Pos         (0UL)                     /*!< CMPR0B2 (Bit 0)                                       */
#define CTIMER_CMPRB2_CMPR0B2_Msk         (0xffffUL)                /*!< CMPR0B2 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL2  ========================================================= */
#define CTIMER_CTRL2_CTLINK2_Pos          (31UL)                    /*!< CTLINK2 (Bit 31)                                      */
#define CTIMER_CTRL2_CTLINK2_Msk          (0x80000000UL)            /*!< CTLINK2 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL2_TMRB2PE_Pos          (29UL)                    /*!< TMRB2PE (Bit 29)                                      */
#define CTIMER_CTRL2_TMRB2PE_Msk          (0x20000000UL)            /*!< TMRB2PE (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL2_TMRB2POL_Pos         (28UL)                    /*!< TMRB2POL (Bit 28)                                     */
#define CTIMER_CTRL2_TMRB2POL_Msk         (0x10000000UL)            /*!< TMRB2POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRB2CLR_Pos         (27UL)                    /*!< TMRB2CLR (Bit 27)                                     */
#define CTIMER_CTRL2_TMRB2CLR_Msk         (0x8000000UL)             /*!< TMRB2CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRB2IE1_Pos         (26UL)                    /*!< TMRB2IE1 (Bit 26)                                     */
#define CTIMER_CTRL2_TMRB2IE1_Msk         (0x4000000UL)             /*!< TMRB2IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRB2IE0_Pos         (25UL)                    /*!< TMRB2IE0 (Bit 25)                                     */
#define CTIMER_CTRL2_TMRB2IE0_Msk         (0x2000000UL)             /*!< TMRB2IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRB2FN_Pos          (22UL)                    /*!< TMRB2FN (Bit 22)                                      */
#define CTIMER_CTRL2_TMRB2FN_Msk          (0x1c00000UL)             /*!< TMRB2FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL2_TMRB2CLK_Pos         (17UL)                    /*!< TMRB2CLK (Bit 17)                                     */
#define CTIMER_CTRL2_TMRB2CLK_Msk         (0x3e0000UL)              /*!< TMRB2CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL2_TMRB2EN_Pos          (16UL)                    /*!< TMRB2EN (Bit 16)                                      */
#define CTIMER_CTRL2_TMRB2EN_Msk          (0x10000UL)               /*!< TMRB2EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL2_TMRA2PE_Pos          (13UL)                    /*!< TMRA2PE (Bit 13)                                      */
#define CTIMER_CTRL2_TMRA2PE_Msk          (0x2000UL)                /*!< TMRA2PE (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL2_TMRA2POL_Pos         (12UL)                    /*!< TMRA2POL (Bit 12)                                     */
#define CTIMER_CTRL2_TMRA2POL_Msk         (0x1000UL)                /*!< TMRA2POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRA2CLR_Pos         (11UL)                    /*!< TMRA2CLR (Bit 11)                                     */
#define CTIMER_CTRL2_TMRA2CLR_Msk         (0x800UL)                 /*!< TMRA2CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRA2IE1_Pos         (10UL)                    /*!< TMRA2IE1 (Bit 10)                                     */
#define CTIMER_CTRL2_TMRA2IE1_Msk         (0x400UL)                 /*!< TMRA2IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRA2IE0_Pos         (9UL)                     /*!< TMRA2IE0 (Bit 9)                                      */
#define CTIMER_CTRL2_TMRA2IE0_Msk         (0x200UL)                 /*!< TMRA2IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRA2FN_Pos          (6UL)                     /*!< TMRA2FN (Bit 6)                                       */
#define CTIMER_CTRL2_TMRA2FN_Msk          (0x1c0UL)                 /*!< TMRA2FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL2_TMRA2CLK_Pos         (1UL)                     /*!< TMRA2CLK (Bit 1)                                      */
#define CTIMER_CTRL2_TMRA2CLK_Msk         (0x3eUL)                  /*!< TMRA2CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL2_TMRA2EN_Pos          (0UL)                     /*!< TMRA2EN (Bit 0)                                       */
#define CTIMER_CTRL2_TMRA2EN_Msk          (0x1UL)                   /*!< TMRA2EN (Bitfield-Mask: 0x01)                         */
/* =========================================================  TMR3  ========================================================== */
#define CTIMER_TMR3_CTTMRB3_Pos           (16UL)                    /*!< CTTMRB3 (Bit 16)                                      */
#define CTIMER_TMR3_CTTMRB3_Msk           (0xffff0000UL)            /*!< CTTMRB3 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR3_CTTMRA3_Pos           (0UL)                     /*!< CTTMRA3 (Bit 0)                                       */
#define CTIMER_TMR3_CTTMRA3_Msk           (0xffffUL)                /*!< CTTMRA3 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA3  ========================================================= */
#define CTIMER_CMPRA3_CMPR1A3_Pos         (16UL)                    /*!< CMPR1A3 (Bit 16)                                      */
#define CTIMER_CMPRA3_CMPR1A3_Msk         (0xffff0000UL)            /*!< CMPR1A3 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA3_CMPR0A3_Pos         (0UL)                     /*!< CMPR0A3 (Bit 0)                                       */
#define CTIMER_CMPRA3_CMPR0A3_Msk         (0xffffUL)                /*!< CMPR0A3 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB3  ========================================================= */
#define CTIMER_CMPRB3_CMPR1B3_Pos         (16UL)                    /*!< CMPR1B3 (Bit 16)                                      */
#define CTIMER_CMPRB3_CMPR1B3_Msk         (0xffff0000UL)            /*!< CMPR1B3 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB3_CMPR0B3_Pos         (0UL)                     /*!< CMPR0B3 (Bit 0)                                       */
#define CTIMER_CMPRB3_CMPR0B3_Msk         (0xffffUL)                /*!< CMPR0B3 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL3  ========================================================= */
#define CTIMER_CTRL3_CTLINK3_Pos          (31UL)                    /*!< CTLINK3 (Bit 31)                                      */
#define CTIMER_CTRL3_CTLINK3_Msk          (0x80000000UL)            /*!< CTLINK3 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL3_TMRB3PE_Pos          (29UL)                    /*!< TMRB3PE (Bit 29)                                      */
#define CTIMER_CTRL3_TMRB3PE_Msk          (0x20000000UL)            /*!< TMRB3PE (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL3_TMRB3POL_Pos         (28UL)                    /*!< TMRB3POL (Bit 28)                                     */
#define CTIMER_CTRL3_TMRB3POL_Msk         (0x10000000UL)            /*!< TMRB3POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRB3CLR_Pos         (27UL)                    /*!< TMRB3CLR (Bit 27)                                     */
#define CTIMER_CTRL3_TMRB3CLR_Msk         (0x8000000UL)             /*!< TMRB3CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRB3IE1_Pos         (26UL)                    /*!< TMRB3IE1 (Bit 26)                                     */
#define CTIMER_CTRL3_TMRB3IE1_Msk         (0x4000000UL)             /*!< TMRB3IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRB3IE0_Pos         (25UL)                    /*!< TMRB3IE0 (Bit 25)                                     */
#define CTIMER_CTRL3_TMRB3IE0_Msk         (0x2000000UL)             /*!< TMRB3IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRB3FN_Pos          (22UL)                    /*!< TMRB3FN (Bit 22)                                      */
#define CTIMER_CTRL3_TMRB3FN_Msk          (0x1c00000UL)             /*!< TMRB3FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL3_TMRB3CLK_Pos         (17UL)                    /*!< TMRB3CLK (Bit 17)                                     */
#define CTIMER_CTRL3_TMRB3CLK_Msk         (0x3e0000UL)              /*!< TMRB3CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL3_TMRB3EN_Pos          (16UL)                    /*!< TMRB3EN (Bit 16)                                      */
#define CTIMER_CTRL3_TMRB3EN_Msk          (0x10000UL)               /*!< TMRB3EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL3_ADCEN_Pos            (15UL)                    /*!< ADCEN (Bit 15)                                        */
#define CTIMER_CTRL3_ADCEN_Msk            (0x8000UL)                /*!< ADCEN (Bitfield-Mask: 0x01)                           */
#define CTIMER_CTRL3_TMRA3PE_Pos          (13UL)                    /*!< TMRA3PE (Bit 13)                                      */
#define CTIMER_CTRL3_TMRA3PE_Msk          (0x2000UL)                /*!< TMRA3PE (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL3_TMRA3POL_Pos         (12UL)                    /*!< TMRA3POL (Bit 12)                                     */
#define CTIMER_CTRL3_TMRA3POL_Msk         (0x1000UL)                /*!< TMRA3POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRA3CLR_Pos         (11UL)                    /*!< TMRA3CLR (Bit 11)                                     */
#define CTIMER_CTRL3_TMRA3CLR_Msk         (0x800UL)                 /*!< TMRA3CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRA3IE1_Pos         (10UL)                    /*!< TMRA3IE1 (Bit 10)                                     */
#define CTIMER_CTRL3_TMRA3IE1_Msk         (0x400UL)                 /*!< TMRA3IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRA3IE0_Pos         (9UL)                     /*!< TMRA3IE0 (Bit 9)                                      */
#define CTIMER_CTRL3_TMRA3IE0_Msk         (0x200UL)                 /*!< TMRA3IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRA3FN_Pos          (6UL)                     /*!< TMRA3FN (Bit 6)                                       */
#define CTIMER_CTRL3_TMRA3FN_Msk          (0x1c0UL)                 /*!< TMRA3FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL3_TMRA3CLK_Pos         (1UL)                     /*!< TMRA3CLK (Bit 1)                                      */
#define CTIMER_CTRL3_TMRA3CLK_Msk         (0x3eUL)                  /*!< TMRA3CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL3_TMRA3EN_Pos          (0UL)                     /*!< TMRA3EN (Bit 0)                                       */
#define CTIMER_CTRL3_TMRA3EN_Msk          (0x1UL)                   /*!< TMRA3EN (Bitfield-Mask: 0x01)                         */
/* =========================================================  STCFG  ========================================================= */
#define CTIMER_STCFG_FREEZE_Pos           (31UL)                    /*!< FREEZE (Bit 31)                                       */
#define CTIMER_STCFG_FREEZE_Msk           (0x80000000UL)            /*!< FREEZE (Bitfield-Mask: 0x01)                          */
#define CTIMER_STCFG_CLEAR_Pos            (30UL)                    /*!< CLEAR (Bit 30)                                        */
#define CTIMER_STCFG_CLEAR_Msk            (0x40000000UL)            /*!< CLEAR (Bitfield-Mask: 0x01)                           */
#define CTIMER_STCFG_COMPARE_H_EN_Pos     (15UL)                    /*!< COMPARE_H_EN (Bit 15)                                 */
#define CTIMER_STCFG_COMPARE_H_EN_Msk     (0x8000UL)                /*!< COMPARE_H_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_G_EN_Pos     (14UL)                    /*!< COMPARE_G_EN (Bit 14)                                 */
#define CTIMER_STCFG_COMPARE_G_EN_Msk     (0x4000UL)                /*!< COMPARE_G_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_F_EN_Pos     (13UL)                    /*!< COMPARE_F_EN (Bit 13)                                 */
#define CTIMER_STCFG_COMPARE_F_EN_Msk     (0x2000UL)                /*!< COMPARE_F_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_E_EN_Pos     (12UL)                    /*!< COMPARE_E_EN (Bit 12)                                 */
#define CTIMER_STCFG_COMPARE_E_EN_Msk     (0x1000UL)                /*!< COMPARE_E_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_D_EN_Pos     (11UL)                    /*!< COMPARE_D_EN (Bit 11)                                 */
#define CTIMER_STCFG_COMPARE_D_EN_Msk     (0x800UL)                 /*!< COMPARE_D_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_C_EN_Pos     (10UL)                    /*!< COMPARE_C_EN (Bit 10)                                 */
#define CTIMER_STCFG_COMPARE_C_EN_Msk     (0x400UL)                 /*!< COMPARE_C_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_B_EN_Pos     (9UL)                     /*!< COMPARE_B_EN (Bit 9)                                  */
#define CTIMER_STCFG_COMPARE_B_EN_Msk     (0x200UL)                 /*!< COMPARE_B_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_A_EN_Pos     (8UL)                     /*!< COMPARE_A_EN (Bit 8)                                  */
#define CTIMER_STCFG_COMPARE_A_EN_Msk     (0x100UL)                 /*!< COMPARE_A_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_CLKSEL_Pos           (0UL)                     /*!< CLKSEL (Bit 0)                                        */
#define CTIMER_STCFG_CLKSEL_Msk           (0xfUL)                   /*!< CLKSEL (Bitfield-Mask: 0x0f)                          */
/* =========================================================  STTMR  ========================================================= */
#define CTIMER_STTMR_VALUE_Pos            (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_STTMR_VALUE_Msk            (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ====================================================  CAPTURE_CONTROL  ==================================================== */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_D_Pos (3UL)                  /*!< CAPTURE_D (Bit 3)                                     */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_D_Msk (0x8UL)                /*!< CAPTURE_D (Bitfield-Mask: 0x01)                       */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_C_Pos (2UL)                  /*!< CAPTURE_C (Bit 2)                                     */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_C_Msk (0x4UL)                /*!< CAPTURE_C (Bitfield-Mask: 0x01)                       */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_B_Pos (1UL)                  /*!< CAPTURE_B (Bit 1)                                     */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_B_Msk (0x2UL)                /*!< CAPTURE_B (Bitfield-Mask: 0x01)                       */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_A_Pos (0UL)                  /*!< CAPTURE_A (Bit 0)                                     */
#define CTIMER_CAPTURE_CONTROL_CAPTURE_A_Msk (0x1UL)                /*!< CAPTURE_A (Bitfield-Mask: 0x01)                       */
/* ========================================================  SCMPR0  ========================================================= */
#define CTIMER_SCMPR0_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCMPR0_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCMPR1  ========================================================= */
#define CTIMER_SCMPR1_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCMPR1_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCMPR2  ========================================================= */
#define CTIMER_SCMPR2_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCMPR2_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCMPR3  ========================================================= */
#define CTIMER_SCMPR3_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCMPR3_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCMPR4  ========================================================= */
#define CTIMER_SCMPR4_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCMPR4_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCMPR5  ========================================================= */
#define CTIMER_SCMPR5_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCMPR5_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCMPR6  ========================================================= */
#define CTIMER_SCMPR6_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCMPR6_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCMPR7  ========================================================= */
#define CTIMER_SCMPR7_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCMPR7_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCAPT0  ========================================================= */
#define CTIMER_SCAPT0_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCAPT0_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCAPT1  ========================================================= */
#define CTIMER_SCAPT1_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCAPT1_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCAPT2  ========================================================= */
#define CTIMER_SCAPT2_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCAPT2_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  SCAPT3  ========================================================= */
#define CTIMER_SCAPT3_VALUE_Pos           (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SCAPT3_VALUE_Msk           (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  SNVR0  ========================================================= */
#define CTIMER_SNVR0_VALUE_Pos            (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SNVR0_VALUE_Msk            (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  SNVR1  ========================================================= */
#define CTIMER_SNVR1_VALUE_Pos            (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SNVR1_VALUE_Msk            (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  SNVR2  ========================================================= */
#define CTIMER_SNVR2_VALUE_Pos            (0UL)                     /*!< VALUE (Bit 0)                                         */
#define CTIMER_SNVR2_VALUE_Msk            (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  INTEN  ========================================================= */
#define CTIMER_INTEN_CTMRB3C1INT_Pos      (15UL)                    /*!< CTMRB3C1INT (Bit 15)                                  */
#define CTIMER_INTEN_CTMRB3C1INT_Msk      (0x8000UL)                /*!< CTMRB3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA3C1INT_Pos      (14UL)                    /*!< CTMRA3C1INT (Bit 14)                                  */
#define CTIMER_INTEN_CTMRA3C1INT_Msk      (0x4000UL)                /*!< CTMRA3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB2C1INT_Pos      (13UL)                    /*!< CTMRB2C1INT (Bit 13)                                  */
#define CTIMER_INTEN_CTMRB2C1INT_Msk      (0x2000UL)                /*!< CTMRB2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA2C1INT_Pos      (12UL)                    /*!< CTMRA2C1INT (Bit 12)                                  */
#define CTIMER_INTEN_CTMRA2C1INT_Msk      (0x1000UL)                /*!< CTMRA2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB1C1INT_Pos      (11UL)                    /*!< CTMRB1C1INT (Bit 11)                                  */
#define CTIMER_INTEN_CTMRB1C1INT_Msk      (0x800UL)                 /*!< CTMRB1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA1C1INT_Pos      (10UL)                    /*!< CTMRA1C1INT (Bit 10)                                  */
#define CTIMER_INTEN_CTMRA1C1INT_Msk      (0x400UL)                 /*!< CTMRA1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB0C1INT_Pos      (9UL)                     /*!< CTMRB0C1INT (Bit 9)                                   */
#define CTIMER_INTEN_CTMRB0C1INT_Msk      (0x200UL)                 /*!< CTMRB0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA0C1INT_Pos      (8UL)                     /*!< CTMRA0C1INT (Bit 8)                                   */
#define CTIMER_INTEN_CTMRA0C1INT_Msk      (0x100UL)                 /*!< CTMRA0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB3C0INT_Pos      (7UL)                     /*!< CTMRB3C0INT (Bit 7)                                   */
#define CTIMER_INTEN_CTMRB3C0INT_Msk      (0x80UL)                  /*!< CTMRB3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA3C0INT_Pos      (6UL)                     /*!< CTMRA3C0INT (Bit 6)                                   */
#define CTIMER_INTEN_CTMRA3C0INT_Msk      (0x40UL)                  /*!< CTMRA3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB2C0INT_Pos      (5UL)                     /*!< CTMRB2C0INT (Bit 5)                                   */
#define CTIMER_INTEN_CTMRB2C0INT_Msk      (0x20UL)                  /*!< CTMRB2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA2C0INT_Pos      (4UL)                     /*!< CTMRA2C0INT (Bit 4)                                   */
#define CTIMER_INTEN_CTMRA2C0INT_Msk      (0x10UL)                  /*!< CTMRA2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB1C0INT_Pos      (3UL)                     /*!< CTMRB1C0INT (Bit 3)                                   */
#define CTIMER_INTEN_CTMRB1C0INT_Msk      (0x8UL)                   /*!< CTMRB1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA1C0INT_Pos      (2UL)                     /*!< CTMRA1C0INT (Bit 2)                                   */
#define CTIMER_INTEN_CTMRA1C0INT_Msk      (0x4UL)                   /*!< CTMRA1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB0C0INT_Pos      (1UL)                     /*!< CTMRB0C0INT (Bit 1)                                   */
#define CTIMER_INTEN_CTMRB0C0INT_Msk      (0x2UL)                   /*!< CTMRB0C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA0C0INT_Pos      (0UL)                     /*!< CTMRA0C0INT (Bit 0)                                   */
#define CTIMER_INTEN_CTMRA0C0INT_Msk      (0x1UL)                   /*!< CTMRA0C0INT (Bitfield-Mask: 0x01)                     */
/* ========================================================  INTSTAT  ======================================================== */
#define CTIMER_INTSTAT_CTMRB3C1INT_Pos    (15UL)                    /*!< CTMRB3C1INT (Bit 15)                                  */
#define CTIMER_INTSTAT_CTMRB3C1INT_Msk    (0x8000UL)                /*!< CTMRB3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA3C1INT_Pos    (14UL)                    /*!< CTMRA3C1INT (Bit 14)                                  */
#define CTIMER_INTSTAT_CTMRA3C1INT_Msk    (0x4000UL)                /*!< CTMRA3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB2C1INT_Pos    (13UL)                    /*!< CTMRB2C1INT (Bit 13)                                  */
#define CTIMER_INTSTAT_CTMRB2C1INT_Msk    (0x2000UL)                /*!< CTMRB2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA2C1INT_Pos    (12UL)                    /*!< CTMRA2C1INT (Bit 12)                                  */
#define CTIMER_INTSTAT_CTMRA2C1INT_Msk    (0x1000UL)                /*!< CTMRA2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB1C1INT_Pos    (11UL)                    /*!< CTMRB1C1INT (Bit 11)                                  */
#define CTIMER_INTSTAT_CTMRB1C1INT_Msk    (0x800UL)                 /*!< CTMRB1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA1C1INT_Pos    (10UL)                    /*!< CTMRA1C1INT (Bit 10)                                  */
#define CTIMER_INTSTAT_CTMRA1C1INT_Msk    (0x400UL)                 /*!< CTMRA1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB0C1INT_Pos    (9UL)                     /*!< CTMRB0C1INT (Bit 9)                                   */
#define CTIMER_INTSTAT_CTMRB0C1INT_Msk    (0x200UL)                 /*!< CTMRB0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA0C1INT_Pos    (8UL)                     /*!< CTMRA0C1INT (Bit 8)                                   */
#define CTIMER_INTSTAT_CTMRA0C1INT_Msk    (0x100UL)                 /*!< CTMRA0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB3C0INT_Pos    (7UL)                     /*!< CTMRB3C0INT (Bit 7)                                   */
#define CTIMER_INTSTAT_CTMRB3C0INT_Msk    (0x80UL)                  /*!< CTMRB3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA3C0INT_Pos    (6UL)                     /*!< CTMRA3C0INT (Bit 6)                                   */
#define CTIMER_INTSTAT_CTMRA3C0INT_Msk    (0x40UL)                  /*!< CTMRA3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB2C0INT_Pos    (5UL)                     /*!< CTMRB2C0INT (Bit 5)                                   */
#define CTIMER_INTSTAT_CTMRB2C0INT_Msk    (0x20UL)                  /*!< CTMRB2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA2C0INT_Pos    (4UL)                     /*!< CTMRA2C0INT (Bit 4)                                   */
#define CTIMER_INTSTAT_CTMRA2C0INT_Msk    (0x10UL)                  /*!< CTMRA2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB1C0INT_Pos    (3UL)                     /*!< CTMRB1C0INT (Bit 3)                                   */
#define CTIMER_INTSTAT_CTMRB1C0INT_Msk    (0x8UL)                   /*!< CTMRB1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA1C0INT_Pos    (2UL)                     /*!< CTMRA1C0INT (Bit 2)                                   */
#define CTIMER_INTSTAT_CTMRA1C0INT_Msk    (0x4UL)                   /*!< CTMRA1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB0C0INT_Pos    (1UL)                     /*!< CTMRB0C0INT (Bit 1)                                   */
#define CTIMER_INTSTAT_CTMRB0C0INT_Msk    (0x2UL)                   /*!< CTMRB0C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA0C0INT_Pos    (0UL)                     /*!< CTMRA0C0INT (Bit 0)                                   */
#define CTIMER_INTSTAT_CTMRA0C0INT_Msk    (0x1UL)                   /*!< CTMRA0C0INT (Bitfield-Mask: 0x01)                     */
/* ========================================================  INTCLR  ========================================================= */
#define CTIMER_INTCLR_CTMRB3C1INT_Pos     (15UL)                    /*!< CTMRB3C1INT (Bit 15)                                  */
#define CTIMER_INTCLR_CTMRB3C1INT_Msk     (0x8000UL)                /*!< CTMRB3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA3C1INT_Pos     (14UL)                    /*!< CTMRA3C1INT (Bit 14)                                  */
#define CTIMER_INTCLR_CTMRA3C1INT_Msk     (0x4000UL)                /*!< CTMRA3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB2C1INT_Pos     (13UL)                    /*!< CTMRB2C1INT (Bit 13)                                  */
#define CTIMER_INTCLR_CTMRB2C1INT_Msk     (0x2000UL)                /*!< CTMRB2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA2C1INT_Pos     (12UL)                    /*!< CTMRA2C1INT (Bit 12)                                  */
#define CTIMER_INTCLR_CTMRA2C1INT_Msk     (0x1000UL)                /*!< CTMRA2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB1C1INT_Pos     (11UL)                    /*!< CTMRB1C1INT (Bit 11)                                  */
#define CTIMER_INTCLR_CTMRB1C1INT_Msk     (0x800UL)                 /*!< CTMRB1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA1C1INT_Pos     (10UL)                    /*!< CTMRA1C1INT (Bit 10)                                  */
#define CTIMER_INTCLR_CTMRA1C1INT_Msk     (0x400UL)                 /*!< CTMRA1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB0C1INT_Pos     (9UL)                     /*!< CTMRB0C1INT (Bit 9)                                   */
#define CTIMER_INTCLR_CTMRB0C1INT_Msk     (0x200UL)                 /*!< CTMRB0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA0C1INT_Pos     (8UL)                     /*!< CTMRA0C1INT (Bit 8)                                   */
#define CTIMER_INTCLR_CTMRA0C1INT_Msk     (0x100UL)                 /*!< CTMRA0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB3C0INT_Pos     (7UL)                     /*!< CTMRB3C0INT (Bit 7)                                   */
#define CTIMER_INTCLR_CTMRB3C0INT_Msk     (0x80UL)                  /*!< CTMRB3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA3C0INT_Pos     (6UL)                     /*!< CTMRA3C0INT (Bit 6)                                   */
#define CTIMER_INTCLR_CTMRA3C0INT_Msk     (0x40UL)                  /*!< CTMRA3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB2C0INT_Pos     (5UL)                     /*!< CTMRB2C0INT (Bit 5)                                   */
#define CTIMER_INTCLR_CTMRB2C0INT_Msk     (0x20UL)                  /*!< CTMRB2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA2C0INT_Pos     (4UL)                     /*!< CTMRA2C0INT (Bit 4)                                   */
#define CTIMER_INTCLR_CTMRA2C0INT_Msk     (0x10UL)                  /*!< CTMRA2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB1C0INT_Pos     (3UL)                     /*!< CTMRB1C0INT (Bit 3)                                   */
#define CTIMER_INTCLR_CTMRB1C0INT_Msk     (0x8UL)                   /*!< CTMRB1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA1C0INT_Pos     (2UL)                     /*!< CTMRA1C0INT (Bit 2)                                   */
#define CTIMER_INTCLR_CTMRA1C0INT_Msk     (0x4UL)                   /*!< CTMRA1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB0C0INT_Pos     (1UL)                     /*!< CTMRB0C0INT (Bit 1)                                   */
#define CTIMER_INTCLR_CTMRB0C0INT_Msk     (0x2UL)                   /*!< CTMRB0C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA0C0INT_Pos     (0UL)                     /*!< CTMRA0C0INT (Bit 0)                                   */
#define CTIMER_INTCLR_CTMRA0C0INT_Msk     (0x1UL)                   /*!< CTMRA0C0INT (Bitfield-Mask: 0x01)                     */
/* ========================================================  INTSET  ========================================================= */
#define CTIMER_INTSET_CTMRB3C1INT_Pos     (15UL)                    /*!< CTMRB3C1INT (Bit 15)                                  */
#define CTIMER_INTSET_CTMRB3C1INT_Msk     (0x8000UL)                /*!< CTMRB3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA3C1INT_Pos     (14UL)                    /*!< CTMRA3C1INT (Bit 14)                                  */
#define CTIMER_INTSET_CTMRA3C1INT_Msk     (0x4000UL)                /*!< CTMRA3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB2C1INT_Pos     (13UL)                    /*!< CTMRB2C1INT (Bit 13)                                  */
#define CTIMER_INTSET_CTMRB2C1INT_Msk     (0x2000UL)                /*!< CTMRB2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA2C1INT_Pos     (12UL)                    /*!< CTMRA2C1INT (Bit 12)                                  */
#define CTIMER_INTSET_CTMRA2C1INT_Msk     (0x1000UL)                /*!< CTMRA2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB1C1INT_Pos     (11UL)                    /*!< CTMRB1C1INT (Bit 11)                                  */
#define CTIMER_INTSET_CTMRB1C1INT_Msk     (0x800UL)                 /*!< CTMRB1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA1C1INT_Pos     (10UL)                    /*!< CTMRA1C1INT (Bit 10)                                  */
#define CTIMER_INTSET_CTMRA1C1INT_Msk     (0x400UL)                 /*!< CTMRA1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB0C1INT_Pos     (9UL)                     /*!< CTMRB0C1INT (Bit 9)                                   */
#define CTIMER_INTSET_CTMRB0C1INT_Msk     (0x200UL)                 /*!< CTMRB0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA0C1INT_Pos     (8UL)                     /*!< CTMRA0C1INT (Bit 8)                                   */
#define CTIMER_INTSET_CTMRA0C1INT_Msk     (0x100UL)                 /*!< CTMRA0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB3C0INT_Pos     (7UL)                     /*!< CTMRB3C0INT (Bit 7)                                   */
#define CTIMER_INTSET_CTMRB3C0INT_Msk     (0x80UL)                  /*!< CTMRB3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA3C0INT_Pos     (6UL)                     /*!< CTMRA3C0INT (Bit 6)                                   */
#define CTIMER_INTSET_CTMRA3C0INT_Msk     (0x40UL)                  /*!< CTMRA3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB2C0INT_Pos     (5UL)                     /*!< CTMRB2C0INT (Bit 5)                                   */
#define CTIMER_INTSET_CTMRB2C0INT_Msk     (0x20UL)                  /*!< CTMRB2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA2C0INT_Pos     (4UL)                     /*!< CTMRA2C0INT (Bit 4)                                   */
#define CTIMER_INTSET_CTMRA2C0INT_Msk     (0x10UL)                  /*!< CTMRA2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB1C0INT_Pos     (3UL)                     /*!< CTMRB1C0INT (Bit 3)                                   */
#define CTIMER_INTSET_CTMRB1C0INT_Msk     (0x8UL)                   /*!< CTMRB1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA1C0INT_Pos     (2UL)                     /*!< CTMRA1C0INT (Bit 2)                                   */
#define CTIMER_INTSET_CTMRA1C0INT_Msk     (0x4UL)                   /*!< CTMRA1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB0C0INT_Pos     (1UL)                     /*!< CTMRB0C0INT (Bit 1)                                   */
#define CTIMER_INTSET_CTMRB0C0INT_Msk     (0x2UL)                   /*!< CTMRB0C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA0C0INT_Pos     (0UL)                     /*!< CTMRA0C0INT (Bit 0)                                   */
#define CTIMER_INTSET_CTMRA0C0INT_Msk     (0x1UL)                   /*!< CTMRA0C0INT (Bitfield-Mask: 0x01)                     */
/* =======================================================  STMINTEN  ======================================================== */
#define CTIMER_STMINTEN_CAPTURED_Pos      (12UL)                    /*!< CAPTURED (Bit 12)                                     */
#define CTIMER_STMINTEN_CAPTURED_Msk      (0x1000UL)                /*!< CAPTURED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_CAPTUREC_Pos      (11UL)                    /*!< CAPTUREC (Bit 11)                                     */
#define CTIMER_STMINTEN_CAPTUREC_Msk      (0x800UL)                 /*!< CAPTUREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_CAPTUREB_Pos      (10UL)                    /*!< CAPTUREB (Bit 10)                                     */
#define CTIMER_STMINTEN_CAPTUREB_Msk      (0x400UL)                 /*!< CAPTUREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_CAPTUREA_Pos      (9UL)                     /*!< CAPTUREA (Bit 9)                                      */
#define CTIMER_STMINTEN_CAPTUREA_Msk      (0x200UL)                 /*!< CAPTUREA (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_OVERFLOW_Pos      (8UL)                     /*!< OVERFLOW (Bit 8)                                      */
#define CTIMER_STMINTEN_OVERFLOW_Msk      (0x100UL)                 /*!< OVERFLOW (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREH_Pos      (7UL)                     /*!< COMPAREH (Bit 7)                                      */
#define CTIMER_STMINTEN_COMPAREH_Msk      (0x80UL)                  /*!< COMPAREH (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREG_Pos      (6UL)                     /*!< COMPAREG (Bit 6)                                      */
#define CTIMER_STMINTEN_COMPAREG_Msk      (0x40UL)                  /*!< COMPAREG (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREF_Pos      (5UL)                     /*!< COMPAREF (Bit 5)                                      */
#define CTIMER_STMINTEN_COMPAREF_Msk      (0x20UL)                  /*!< COMPAREF (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREE_Pos      (4UL)                     /*!< COMPAREE (Bit 4)                                      */
#define CTIMER_STMINTEN_COMPAREE_Msk      (0x10UL)                  /*!< COMPAREE (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPARED_Pos      (3UL)                     /*!< COMPARED (Bit 3)                                      */
#define CTIMER_STMINTEN_COMPARED_Msk      (0x8UL)                   /*!< COMPARED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREC_Pos      (2UL)                     /*!< COMPAREC (Bit 2)                                      */
#define CTIMER_STMINTEN_COMPAREC_Msk      (0x4UL)                   /*!< COMPAREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREB_Pos      (1UL)                     /*!< COMPAREB (Bit 1)                                      */
#define CTIMER_STMINTEN_COMPAREB_Msk      (0x2UL)                   /*!< COMPAREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREA_Pos      (0UL)                     /*!< COMPAREA (Bit 0)                                      */
#define CTIMER_STMINTEN_COMPAREA_Msk      (0x1UL)                   /*!< COMPAREA (Bitfield-Mask: 0x01)                        */
/* ======================================================  STMINTSTAT  ======================================================= */
#define CTIMER_STMINTSTAT_CAPTURED_Pos    (12UL)                    /*!< CAPTURED (Bit 12)                                     */
#define CTIMER_STMINTSTAT_CAPTURED_Msk    (0x1000UL)                /*!< CAPTURED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_CAPTUREC_Pos    (11UL)                    /*!< CAPTUREC (Bit 11)                                     */
#define CTIMER_STMINTSTAT_CAPTUREC_Msk    (0x800UL)                 /*!< CAPTUREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_CAPTUREB_Pos    (10UL)                    /*!< CAPTUREB (Bit 10)                                     */
#define CTIMER_STMINTSTAT_CAPTUREB_Msk    (0x400UL)                 /*!< CAPTUREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_CAPTUREA_Pos    (9UL)                     /*!< CAPTUREA (Bit 9)                                      */
#define CTIMER_STMINTSTAT_CAPTUREA_Msk    (0x200UL)                 /*!< CAPTUREA (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_OVERFLOW_Pos    (8UL)                     /*!< OVERFLOW (Bit 8)                                      */
#define CTIMER_STMINTSTAT_OVERFLOW_Msk    (0x100UL)                 /*!< OVERFLOW (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREH_Pos    (7UL)                     /*!< COMPAREH (Bit 7)                                      */
#define CTIMER_STMINTSTAT_COMPAREH_Msk    (0x80UL)                  /*!< COMPAREH (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREG_Pos    (6UL)                     /*!< COMPAREG (Bit 6)                                      */
#define CTIMER_STMINTSTAT_COMPAREG_Msk    (0x40UL)                  /*!< COMPAREG (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREF_Pos    (5UL)                     /*!< COMPAREF (Bit 5)                                      */
#define CTIMER_STMINTSTAT_COMPAREF_Msk    (0x20UL)                  /*!< COMPAREF (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREE_Pos    (4UL)                     /*!< COMPAREE (Bit 4)                                      */
#define CTIMER_STMINTSTAT_COMPAREE_Msk    (0x10UL)                  /*!< COMPAREE (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPARED_Pos    (3UL)                     /*!< COMPARED (Bit 3)                                      */
#define CTIMER_STMINTSTAT_COMPARED_Msk    (0x8UL)                   /*!< COMPARED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREC_Pos    (2UL)                     /*!< COMPAREC (Bit 2)                                      */
#define CTIMER_STMINTSTAT_COMPAREC_Msk    (0x4UL)                   /*!< COMPAREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREB_Pos    (1UL)                     /*!< COMPAREB (Bit 1)                                      */
#define CTIMER_STMINTSTAT_COMPAREB_Msk    (0x2UL)                   /*!< COMPAREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREA_Pos    (0UL)                     /*!< COMPAREA (Bit 0)                                      */
#define CTIMER_STMINTSTAT_COMPAREA_Msk    (0x1UL)                   /*!< COMPAREA (Bitfield-Mask: 0x01)                        */
/* =======================================================  STMINTCLR  ======================================================= */
#define CTIMER_STMINTCLR_CAPTURED_Pos     (12UL)                    /*!< CAPTURED (Bit 12)                                     */
#define CTIMER_STMINTCLR_CAPTURED_Msk     (0x1000UL)                /*!< CAPTURED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_CAPTUREC_Pos     (11UL)                    /*!< CAPTUREC (Bit 11)                                     */
#define CTIMER_STMINTCLR_CAPTUREC_Msk     (0x800UL)                 /*!< CAPTUREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_CAPTUREB_Pos     (10UL)                    /*!< CAPTUREB (Bit 10)                                     */
#define CTIMER_STMINTCLR_CAPTUREB_Msk     (0x400UL)                 /*!< CAPTUREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_CAPTUREA_Pos     (9UL)                     /*!< CAPTUREA (Bit 9)                                      */
#define CTIMER_STMINTCLR_CAPTUREA_Msk     (0x200UL)                 /*!< CAPTUREA (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_OVERFLOW_Pos     (8UL)                     /*!< OVERFLOW (Bit 8)                                      */
#define CTIMER_STMINTCLR_OVERFLOW_Msk     (0x100UL)                 /*!< OVERFLOW (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREH_Pos     (7UL)                     /*!< COMPAREH (Bit 7)                                      */
#define CTIMER_STMINTCLR_COMPAREH_Msk     (0x80UL)                  /*!< COMPAREH (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREG_Pos     (6UL)                     /*!< COMPAREG (Bit 6)                                      */
#define CTIMER_STMINTCLR_COMPAREG_Msk     (0x40UL)                  /*!< COMPAREG (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREF_Pos     (5UL)                     /*!< COMPAREF (Bit 5)                                      */
#define CTIMER_STMINTCLR_COMPAREF_Msk     (0x20UL)                  /*!< COMPAREF (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREE_Pos     (4UL)                     /*!< COMPAREE (Bit 4)                                      */
#define CTIMER_STMINTCLR_COMPAREE_Msk     (0x10UL)                  /*!< COMPAREE (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPARED_Pos     (3UL)                     /*!< COMPARED (Bit 3)                                      */
#define CTIMER_STMINTCLR_COMPARED_Msk     (0x8UL)                   /*!< COMPARED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREC_Pos     (2UL)                     /*!< COMPAREC (Bit 2)                                      */
#define CTIMER_STMINTCLR_COMPAREC_Msk     (0x4UL)                   /*!< COMPAREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREB_Pos     (1UL)                     /*!< COMPAREB (Bit 1)                                      */
#define CTIMER_STMINTCLR_COMPAREB_Msk     (0x2UL)                   /*!< COMPAREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREA_Pos     (0UL)                     /*!< COMPAREA (Bit 0)                                      */
#define CTIMER_STMINTCLR_COMPAREA_Msk     (0x1UL)                   /*!< COMPAREA (Bitfield-Mask: 0x01)                        */
/* =======================================================  STMINTSET  ======================================================= */
#define CTIMER_STMINTSET_CAPTURED_Pos     (12UL)                    /*!< CAPTURED (Bit 12)                                     */
#define CTIMER_STMINTSET_CAPTURED_Msk     (0x1000UL)                /*!< CAPTURED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_CAPTUREC_Pos     (11UL)                    /*!< CAPTUREC (Bit 11)                                     */
#define CTIMER_STMINTSET_CAPTUREC_Msk     (0x800UL)                 /*!< CAPTUREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_CAPTUREB_Pos     (10UL)                    /*!< CAPTUREB (Bit 10)                                     */
#define CTIMER_STMINTSET_CAPTUREB_Msk     (0x400UL)                 /*!< CAPTUREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_CAPTUREA_Pos     (9UL)                     /*!< CAPTUREA (Bit 9)                                      */
#define CTIMER_STMINTSET_CAPTUREA_Msk     (0x200UL)                 /*!< CAPTUREA (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_OVERFLOW_Pos     (8UL)                     /*!< OVERFLOW (Bit 8)                                      */
#define CTIMER_STMINTSET_OVERFLOW_Msk     (0x100UL)                 /*!< OVERFLOW (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREH_Pos     (7UL)                     /*!< COMPAREH (Bit 7)                                      */
#define CTIMER_STMINTSET_COMPAREH_Msk     (0x80UL)                  /*!< COMPAREH (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREG_Pos     (6UL)                     /*!< COMPAREG (Bit 6)                                      */
#define CTIMER_STMINTSET_COMPAREG_Msk     (0x40UL)                  /*!< COMPAREG (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREF_Pos     (5UL)                     /*!< COMPAREF (Bit 5)                                      */
#define CTIMER_STMINTSET_COMPAREF_Msk     (0x20UL)                  /*!< COMPAREF (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREE_Pos     (4UL)                     /*!< COMPAREE (Bit 4)                                      */
#define CTIMER_STMINTSET_COMPAREE_Msk     (0x10UL)                  /*!< COMPAREE (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPARED_Pos     (3UL)                     /*!< COMPARED (Bit 3)                                      */
#define CTIMER_STMINTSET_COMPARED_Msk     (0x8UL)                   /*!< COMPARED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREC_Pos     (2UL)                     /*!< COMPAREC (Bit 2)                                      */
#define CTIMER_STMINTSET_COMPAREC_Msk     (0x4UL)                   /*!< COMPAREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREB_Pos     (1UL)                     /*!< COMPAREB (Bit 1)                                      */
#define CTIMER_STMINTSET_COMPAREB_Msk     (0x2UL)                   /*!< COMPAREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREA_Pos     (0UL)                     /*!< COMPAREA (Bit 0)                                      */
#define CTIMER_STMINTSET_COMPAREA_Msk     (0x1UL)                   /*!< COMPAREA (Bitfield-Mask: 0x01)                        */


/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  PADREGA  ======================================================== */
#define GPIO_PADREGA_PAD3FNCSEL_Pos       (27UL)                    /*!< PAD3FNCSEL (Bit 27)                                   */
#define GPIO_PADREGA_PAD3FNCSEL_Msk       (0x38000000UL)            /*!< PAD3FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGA_PAD3STRNG_Pos        (26UL)                    /*!< PAD3STRNG (Bit 26)                                    */
#define GPIO_PADREGA_PAD3STRNG_Msk        (0x4000000UL)             /*!< PAD3STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD3INPEN_Pos        (25UL)                    /*!< PAD3INPEN (Bit 25)                                    */
#define GPIO_PADREGA_PAD3INPEN_Msk        (0x2000000UL)             /*!< PAD3INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD3PULL_Pos         (24UL)                    /*!< PAD3PULL (Bit 24)                                     */
#define GPIO_PADREGA_PAD3PULL_Msk         (0x1000000UL)             /*!< PAD3PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGA_PAD2FNCSEL_Pos       (19UL)                    /*!< PAD2FNCSEL (Bit 19)                                   */
#define GPIO_PADREGA_PAD2FNCSEL_Msk       (0x380000UL)              /*!< PAD2FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGA_PAD2STRNG_Pos        (18UL)                    /*!< PAD2STRNG (Bit 18)                                    */
#define GPIO_PADREGA_PAD2STRNG_Msk        (0x40000UL)               /*!< PAD2STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD2INPEN_Pos        (17UL)                    /*!< PAD2INPEN (Bit 17)                                    */
#define GPIO_PADREGA_PAD2INPEN_Msk        (0x20000UL)               /*!< PAD2INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD2PULL_Pos         (16UL)                    /*!< PAD2PULL (Bit 16)                                     */
#define GPIO_PADREGA_PAD2PULL_Msk         (0x10000UL)               /*!< PAD2PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGA_PAD1RSEL_Pos         (14UL)                    /*!< PAD1RSEL (Bit 14)                                     */
#define GPIO_PADREGA_PAD1RSEL_Msk         (0xc000UL)                /*!< PAD1RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGA_PAD1FNCSEL_Pos       (11UL)                    /*!< PAD1FNCSEL (Bit 11)                                   */
#define GPIO_PADREGA_PAD1FNCSEL_Msk       (0x3800UL)                /*!< PAD1FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGA_PAD1STRNG_Pos        (10UL)                    /*!< PAD1STRNG (Bit 10)                                    */
#define GPIO_PADREGA_PAD1STRNG_Msk        (0x400UL)                 /*!< PAD1STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD1INPEN_Pos        (9UL)                     /*!< PAD1INPEN (Bit 9)                                     */
#define GPIO_PADREGA_PAD1INPEN_Msk        (0x200UL)                 /*!< PAD1INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD1PULL_Pos         (8UL)                     /*!< PAD1PULL (Bit 8)                                      */
#define GPIO_PADREGA_PAD1PULL_Msk         (0x100UL)                 /*!< PAD1PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGA_PAD0RSEL_Pos         (6UL)                     /*!< PAD0RSEL (Bit 6)                                      */
#define GPIO_PADREGA_PAD0RSEL_Msk         (0xc0UL)                  /*!< PAD0RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGA_PAD0FNCSEL_Pos       (3UL)                     /*!< PAD0FNCSEL (Bit 3)                                    */
#define GPIO_PADREGA_PAD0FNCSEL_Msk       (0x38UL)                  /*!< PAD0FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGA_PAD0STRNG_Pos        (2UL)                     /*!< PAD0STRNG (Bit 2)                                     */
#define GPIO_PADREGA_PAD0STRNG_Msk        (0x4UL)                   /*!< PAD0STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD0INPEN_Pos        (1UL)                     /*!< PAD0INPEN (Bit 1)                                     */
#define GPIO_PADREGA_PAD0INPEN_Msk        (0x2UL)                   /*!< PAD0INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD0PULL_Pos         (0UL)                     /*!< PAD0PULL (Bit 0)                                      */
#define GPIO_PADREGA_PAD0PULL_Msk         (0x1UL)                   /*!< PAD0PULL (Bitfield-Mask: 0x01)                        */
/* ========================================================  PADREGB  ======================================================== */
#define GPIO_PADREGB_PAD7FNCSEL_Pos       (27UL)                    /*!< PAD7FNCSEL (Bit 27)                                   */
#define GPIO_PADREGB_PAD7FNCSEL_Msk       (0x38000000UL)            /*!< PAD7FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGB_PAD7STRNG_Pos        (26UL)                    /*!< PAD7STRNG (Bit 26)                                    */
#define GPIO_PADREGB_PAD7STRNG_Msk        (0x4000000UL)             /*!< PAD7STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD7INPEN_Pos        (25UL)                    /*!< PAD7INPEN (Bit 25)                                    */
#define GPIO_PADREGB_PAD7INPEN_Msk        (0x2000000UL)             /*!< PAD7INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD7PULL_Pos         (24UL)                    /*!< PAD7PULL (Bit 24)                                     */
#define GPIO_PADREGB_PAD7PULL_Msk         (0x1000000UL)             /*!< PAD7PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGB_PAD6RSEL_Pos         (22UL)                    /*!< PAD6RSEL (Bit 22)                                     */
#define GPIO_PADREGB_PAD6RSEL_Msk         (0xc00000UL)              /*!< PAD6RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGB_PAD6FNCSEL_Pos       (19UL)                    /*!< PAD6FNCSEL (Bit 19)                                   */
#define GPIO_PADREGB_PAD6FNCSEL_Msk       (0x380000UL)              /*!< PAD6FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGB_PAD6STRNG_Pos        (18UL)                    /*!< PAD6STRNG (Bit 18)                                    */
#define GPIO_PADREGB_PAD6STRNG_Msk        (0x40000UL)               /*!< PAD6STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD6INPEN_Pos        (17UL)                    /*!< PAD6INPEN (Bit 17)                                    */
#define GPIO_PADREGB_PAD6INPEN_Msk        (0x20000UL)               /*!< PAD6INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD6PULL_Pos         (16UL)                    /*!< PAD6PULL (Bit 16)                                     */
#define GPIO_PADREGB_PAD6PULL_Msk         (0x10000UL)               /*!< PAD6PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGB_PAD5RSEL_Pos         (14UL)                    /*!< PAD5RSEL (Bit 14)                                     */
#define GPIO_PADREGB_PAD5RSEL_Msk         (0xc000UL)                /*!< PAD5RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGB_PAD5FNCSEL_Pos       (11UL)                    /*!< PAD5FNCSEL (Bit 11)                                   */
#define GPIO_PADREGB_PAD5FNCSEL_Msk       (0x3800UL)                /*!< PAD5FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGB_PAD5STRNG_Pos        (10UL)                    /*!< PAD5STRNG (Bit 10)                                    */
#define GPIO_PADREGB_PAD5STRNG_Msk        (0x400UL)                 /*!< PAD5STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD5INPEN_Pos        (9UL)                     /*!< PAD5INPEN (Bit 9)                                     */
#define GPIO_PADREGB_PAD5INPEN_Msk        (0x200UL)                 /*!< PAD5INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD5PULL_Pos         (8UL)                     /*!< PAD5PULL (Bit 8)                                      */
#define GPIO_PADREGB_PAD5PULL_Msk         (0x100UL)                 /*!< PAD5PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGB_PAD4PWRDN_Pos        (7UL)                     /*!< PAD4PWRDN (Bit 7)                                     */
#define GPIO_PADREGB_PAD4PWRDN_Msk        (0x80UL)                  /*!< PAD4PWRDN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD4FNCSEL_Pos       (3UL)                     /*!< PAD4FNCSEL (Bit 3)                                    */
#define GPIO_PADREGB_PAD4FNCSEL_Msk       (0x38UL)                  /*!< PAD4FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGB_PAD4STRNG_Pos        (2UL)                     /*!< PAD4STRNG (Bit 2)                                     */
#define GPIO_PADREGB_PAD4STRNG_Msk        (0x4UL)                   /*!< PAD4STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD4INPEN_Pos        (1UL)                     /*!< PAD4INPEN (Bit 1)                                     */
#define GPIO_PADREGB_PAD4INPEN_Msk        (0x2UL)                   /*!< PAD4INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD4PULL_Pos         (0UL)                     /*!< PAD4PULL (Bit 0)                                      */
#define GPIO_PADREGB_PAD4PULL_Msk         (0x1UL)                   /*!< PAD4PULL (Bitfield-Mask: 0x01)                        */
/* ========================================================  PADREGC  ======================================================== */
#define GPIO_PADREGC_PAD11FNCSEL_Pos      (27UL)                    /*!< PAD11FNCSEL (Bit 27)                                  */
#define GPIO_PADREGC_PAD11FNCSEL_Msk      (0x38000000UL)            /*!< PAD11FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGC_PAD11STRNG_Pos       (26UL)                    /*!< PAD11STRNG (Bit 26)                                   */
#define GPIO_PADREGC_PAD11STRNG_Msk       (0x4000000UL)             /*!< PAD11STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGC_PAD11INPEN_Pos       (25UL)                    /*!< PAD11INPEN (Bit 25)                                   */
#define GPIO_PADREGC_PAD11INPEN_Msk       (0x2000000UL)             /*!< PAD11INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGC_PAD11PULL_Pos        (24UL)                    /*!< PAD11PULL (Bit 24)                                    */
#define GPIO_PADREGC_PAD11PULL_Msk        (0x1000000UL)             /*!< PAD11PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGC_PAD10FNCSEL_Pos      (19UL)                    /*!< PAD10FNCSEL (Bit 19)                                  */
#define GPIO_PADREGC_PAD10FNCSEL_Msk      (0x380000UL)              /*!< PAD10FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGC_PAD10STRNG_Pos       (18UL)                    /*!< PAD10STRNG (Bit 18)                                   */
#define GPIO_PADREGC_PAD10STRNG_Msk       (0x40000UL)               /*!< PAD10STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGC_PAD10INPEN_Pos       (17UL)                    /*!< PAD10INPEN (Bit 17)                                   */
#define GPIO_PADREGC_PAD10INPEN_Msk       (0x20000UL)               /*!< PAD10INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGC_PAD10PULL_Pos        (16UL)                    /*!< PAD10PULL (Bit 16)                                    */
#define GPIO_PADREGC_PAD10PULL_Msk        (0x10000UL)               /*!< PAD10PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGC_PAD9RSEL_Pos         (14UL)                    /*!< PAD9RSEL (Bit 14)                                     */
#define GPIO_PADREGC_PAD9RSEL_Msk         (0xc000UL)                /*!< PAD9RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGC_PAD9FNCSEL_Pos       (11UL)                    /*!< PAD9FNCSEL (Bit 11)                                   */
#define GPIO_PADREGC_PAD9FNCSEL_Msk       (0x3800UL)                /*!< PAD9FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGC_PAD9STRNG_Pos        (10UL)                    /*!< PAD9STRNG (Bit 10)                                    */
#define GPIO_PADREGC_PAD9STRNG_Msk        (0x400UL)                 /*!< PAD9STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGC_PAD9INPEN_Pos        (9UL)                     /*!< PAD9INPEN (Bit 9)                                     */
#define GPIO_PADREGC_PAD9INPEN_Msk        (0x200UL)                 /*!< PAD9INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGC_PAD9PULL_Pos         (8UL)                     /*!< PAD9PULL (Bit 8)                                      */
#define GPIO_PADREGC_PAD9PULL_Msk         (0x100UL)                 /*!< PAD9PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGC_PAD8RSEL_Pos         (6UL)                     /*!< PAD8RSEL (Bit 6)                                      */
#define GPIO_PADREGC_PAD8RSEL_Msk         (0xc0UL)                  /*!< PAD8RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGC_PAD8FNCSEL_Pos       (3UL)                     /*!< PAD8FNCSEL (Bit 3)                                    */
#define GPIO_PADREGC_PAD8FNCSEL_Msk       (0x38UL)                  /*!< PAD8FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGC_PAD8STRNG_Pos        (2UL)                     /*!< PAD8STRNG (Bit 2)                                     */
#define GPIO_PADREGC_PAD8STRNG_Msk        (0x4UL)                   /*!< PAD8STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGC_PAD8INPEN_Pos        (1UL)                     /*!< PAD8INPEN (Bit 1)                                     */
#define GPIO_PADREGC_PAD8INPEN_Msk        (0x2UL)                   /*!< PAD8INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGC_PAD8PULL_Pos         (0UL)                     /*!< PAD8PULL (Bit 0)                                      */
#define GPIO_PADREGC_PAD8PULL_Msk         (0x1UL)                   /*!< PAD8PULL (Bitfield-Mask: 0x01)                        */
/* ========================================================  PADREGD  ======================================================== */
#define GPIO_PADREGD_PAD15FNCSEL_Pos      (27UL)                    /*!< PAD15FNCSEL (Bit 27)                                  */
#define GPIO_PADREGD_PAD15FNCSEL_Msk      (0x38000000UL)            /*!< PAD15FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGD_PAD15STRNG_Pos       (26UL)                    /*!< PAD15STRNG (Bit 26)                                   */
#define GPIO_PADREGD_PAD15STRNG_Msk       (0x4000000UL)             /*!< PAD15STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGD_PAD15INPEN_Pos       (25UL)                    /*!< PAD15INPEN (Bit 25)                                   */
#define GPIO_PADREGD_PAD15INPEN_Msk       (0x2000000UL)             /*!< PAD15INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGD_PAD15PULL_Pos        (24UL)                    /*!< PAD15PULL (Bit 24)                                    */
#define GPIO_PADREGD_PAD15PULL_Msk        (0x1000000UL)             /*!< PAD15PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGD_PAD14FNCSEL_Pos      (19UL)                    /*!< PAD14FNCSEL (Bit 19)                                  */
#define GPIO_PADREGD_PAD14FNCSEL_Msk      (0x380000UL)              /*!< PAD14FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGD_PAD14STRNG_Pos       (18UL)                    /*!< PAD14STRNG (Bit 18)                                   */
#define GPIO_PADREGD_PAD14STRNG_Msk       (0x40000UL)               /*!< PAD14STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGD_PAD14INPEN_Pos       (17UL)                    /*!< PAD14INPEN (Bit 17)                                   */
#define GPIO_PADREGD_PAD14INPEN_Msk       (0x20000UL)               /*!< PAD14INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGD_PAD14PULL_Pos        (16UL)                    /*!< PAD14PULL (Bit 16)                                    */
#define GPIO_PADREGD_PAD14PULL_Msk        (0x10000UL)               /*!< PAD14PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGD_PAD13FNCSEL_Pos      (11UL)                    /*!< PAD13FNCSEL (Bit 11)                                  */
#define GPIO_PADREGD_PAD13FNCSEL_Msk      (0x3800UL)                /*!< PAD13FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGD_PAD13STRNG_Pos       (10UL)                    /*!< PAD13STRNG (Bit 10)                                   */
#define GPIO_PADREGD_PAD13STRNG_Msk       (0x400UL)                 /*!< PAD13STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGD_PAD13INPEN_Pos       (9UL)                     /*!< PAD13INPEN (Bit 9)                                    */
#define GPIO_PADREGD_PAD13INPEN_Msk       (0x200UL)                 /*!< PAD13INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGD_PAD13PULL_Pos        (8UL)                     /*!< PAD13PULL (Bit 8)                                     */
#define GPIO_PADREGD_PAD13PULL_Msk        (0x100UL)                 /*!< PAD13PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGD_PAD12FNCSEL_Pos      (3UL)                     /*!< PAD12FNCSEL (Bit 3)                                   */
#define GPIO_PADREGD_PAD12FNCSEL_Msk      (0x38UL)                  /*!< PAD12FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGD_PAD12STRNG_Pos       (2UL)                     /*!< PAD12STRNG (Bit 2)                                    */
#define GPIO_PADREGD_PAD12STRNG_Msk       (0x4UL)                   /*!< PAD12STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGD_PAD12INPEN_Pos       (1UL)                     /*!< PAD12INPEN (Bit 1)                                    */
#define GPIO_PADREGD_PAD12INPEN_Msk       (0x2UL)                   /*!< PAD12INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGD_PAD12PULL_Pos        (0UL)                     /*!< PAD12PULL (Bit 0)                                     */
#define GPIO_PADREGD_PAD12PULL_Msk        (0x1UL)                   /*!< PAD12PULL (Bitfield-Mask: 0x01)                       */
/* ========================================================  PADREGE  ======================================================== */
#define GPIO_PADREGE_PAD19FNCSEL_Pos      (27UL)                    /*!< PAD19FNCSEL (Bit 27)                                  */
#define GPIO_PADREGE_PAD19FNCSEL_Msk      (0x38000000UL)            /*!< PAD19FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGE_PAD19STRNG_Pos       (26UL)                    /*!< PAD19STRNG (Bit 26)                                   */
#define GPIO_PADREGE_PAD19STRNG_Msk       (0x4000000UL)             /*!< PAD19STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGE_PAD19INPEN_Pos       (25UL)                    /*!< PAD19INPEN (Bit 25)                                   */
#define GPIO_PADREGE_PAD19INPEN_Msk       (0x2000000UL)             /*!< PAD19INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGE_PAD19PULL_Pos        (24UL)                    /*!< PAD19PULL (Bit 24)                                    */
#define GPIO_PADREGE_PAD19PULL_Msk        (0x1000000UL)             /*!< PAD19PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGE_PAD18FNCSEL_Pos      (19UL)                    /*!< PAD18FNCSEL (Bit 19)                                  */
#define GPIO_PADREGE_PAD18FNCSEL_Msk      (0x380000UL)              /*!< PAD18FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGE_PAD18STRNG_Pos       (18UL)                    /*!< PAD18STRNG (Bit 18)                                   */
#define GPIO_PADREGE_PAD18STRNG_Msk       (0x40000UL)               /*!< PAD18STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGE_PAD18INPEN_Pos       (17UL)                    /*!< PAD18INPEN (Bit 17)                                   */
#define GPIO_PADREGE_PAD18INPEN_Msk       (0x20000UL)               /*!< PAD18INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGE_PAD18PULL_Pos        (16UL)                    /*!< PAD18PULL (Bit 16)                                    */
#define GPIO_PADREGE_PAD18PULL_Msk        (0x10000UL)               /*!< PAD18PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGE_PAD17FNCSEL_Pos      (11UL)                    /*!< PAD17FNCSEL (Bit 11)                                  */
#define GPIO_PADREGE_PAD17FNCSEL_Msk      (0x3800UL)                /*!< PAD17FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGE_PAD17STRNG_Pos       (10UL)                    /*!< PAD17STRNG (Bit 10)                                   */
#define GPIO_PADREGE_PAD17STRNG_Msk       (0x400UL)                 /*!< PAD17STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGE_PAD17INPEN_Pos       (9UL)                     /*!< PAD17INPEN (Bit 9)                                    */
#define GPIO_PADREGE_PAD17INPEN_Msk       (0x200UL)                 /*!< PAD17INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGE_PAD17PULL_Pos        (8UL)                     /*!< PAD17PULL (Bit 8)                                     */
#define GPIO_PADREGE_PAD17PULL_Msk        (0x100UL)                 /*!< PAD17PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGE_PAD16FNCSEL_Pos      (3UL)                     /*!< PAD16FNCSEL (Bit 3)                                   */
#define GPIO_PADREGE_PAD16FNCSEL_Msk      (0x38UL)                  /*!< PAD16FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGE_PAD16STRNG_Pos       (2UL)                     /*!< PAD16STRNG (Bit 2)                                    */
#define GPIO_PADREGE_PAD16STRNG_Msk       (0x4UL)                   /*!< PAD16STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGE_PAD16INPEN_Pos       (1UL)                     /*!< PAD16INPEN (Bit 1)                                    */
#define GPIO_PADREGE_PAD16INPEN_Msk       (0x2UL)                   /*!< PAD16INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGE_PAD16PULL_Pos        (0UL)                     /*!< PAD16PULL (Bit 0)                                     */
#define GPIO_PADREGE_PAD16PULL_Msk        (0x1UL)                   /*!< PAD16PULL (Bitfield-Mask: 0x01)                       */
/* ========================================================  PADREGF  ======================================================== */
#define GPIO_PADREGF_PAD23FNCSEL_Pos      (27UL)                    /*!< PAD23FNCSEL (Bit 27)                                  */
#define GPIO_PADREGF_PAD23FNCSEL_Msk      (0x38000000UL)            /*!< PAD23FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGF_PAD23STRNG_Pos       (26UL)                    /*!< PAD23STRNG (Bit 26)                                   */
#define GPIO_PADREGF_PAD23STRNG_Msk       (0x4000000UL)             /*!< PAD23STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGF_PAD23INPEN_Pos       (25UL)                    /*!< PAD23INPEN (Bit 25)                                   */
#define GPIO_PADREGF_PAD23INPEN_Msk       (0x2000000UL)             /*!< PAD23INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGF_PAD23PULL_Pos        (24UL)                    /*!< PAD23PULL (Bit 24)                                    */
#define GPIO_PADREGF_PAD23PULL_Msk        (0x1000000UL)             /*!< PAD23PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGF_PAD22PWRUP_Pos       (23UL)                    /*!< PAD22PWRUP (Bit 23)                                   */
#define GPIO_PADREGF_PAD22PWRUP_Msk       (0x800000UL)              /*!< PAD22PWRUP (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGF_PAD22FNCSEL_Pos      (19UL)                    /*!< PAD22FNCSEL (Bit 19)                                  */
#define GPIO_PADREGF_PAD22FNCSEL_Msk      (0x380000UL)              /*!< PAD22FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGF_PAD22STRNG_Pos       (18UL)                    /*!< PAD22STRNG (Bit 18)                                   */
#define GPIO_PADREGF_PAD22STRNG_Msk       (0x40000UL)               /*!< PAD22STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGF_PAD22INPEN_Pos       (17UL)                    /*!< PAD22INPEN (Bit 17)                                   */
#define GPIO_PADREGF_PAD22INPEN_Msk       (0x20000UL)               /*!< PAD22INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGF_PAD22PULL_Pos        (16UL)                    /*!< PAD22PULL (Bit 16)                                    */
#define GPIO_PADREGF_PAD22PULL_Msk        (0x10000UL)               /*!< PAD22PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGF_PAD21FNCSEL_Pos      (11UL)                    /*!< PAD21FNCSEL (Bit 11)                                  */
#define GPIO_PADREGF_PAD21FNCSEL_Msk      (0x3800UL)                /*!< PAD21FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGF_PAD21STRNG_Pos       (10UL)                    /*!< PAD21STRNG (Bit 10)                                   */
#define GPIO_PADREGF_PAD21STRNG_Msk       (0x400UL)                 /*!< PAD21STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGF_PAD21INPEN_Pos       (9UL)                     /*!< PAD21INPEN (Bit 9)                                    */
#define GPIO_PADREGF_PAD21INPEN_Msk       (0x200UL)                 /*!< PAD21INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGF_PAD21PULL_Pos        (8UL)                     /*!< PAD21PULL (Bit 8)                                     */
#define GPIO_PADREGF_PAD21PULL_Msk        (0x100UL)                 /*!< PAD21PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGF_PAD20FNCSEL_Pos      (3UL)                     /*!< PAD20FNCSEL (Bit 3)                                   */
#define GPIO_PADREGF_PAD20FNCSEL_Msk      (0x38UL)                  /*!< PAD20FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGF_PAD20STRNG_Pos       (2UL)                     /*!< PAD20STRNG (Bit 2)                                    */
#define GPIO_PADREGF_PAD20STRNG_Msk       (0x4UL)                   /*!< PAD20STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGF_PAD20INPEN_Pos       (1UL)                     /*!< PAD20INPEN (Bit 1)                                    */
#define GPIO_PADREGF_PAD20INPEN_Msk       (0x2UL)                   /*!< PAD20INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGF_PAD20PULL_Pos        (0UL)                     /*!< PAD20PULL (Bit 0)                                     */
#define GPIO_PADREGF_PAD20PULL_Msk        (0x1UL)                   /*!< PAD20PULL (Bitfield-Mask: 0x01)                       */
/* ========================================================  PADREGG  ======================================================== */
#define GPIO_PADREGG_PAD27RSEL_Pos        (30UL)                    /*!< PAD27RSEL (Bit 30)                                    */
#define GPIO_PADREGG_PAD27RSEL_Msk        (0xc0000000UL)            /*!< PAD27RSEL (Bitfield-Mask: 0x03)                       */
#define GPIO_PADREGG_PAD27FNCSEL_Pos      (27UL)                    /*!< PAD27FNCSEL (Bit 27)                                  */
#define GPIO_PADREGG_PAD27FNCSEL_Msk      (0x38000000UL)            /*!< PAD27FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGG_PAD27STRNG_Pos       (26UL)                    /*!< PAD27STRNG (Bit 26)                                   */
#define GPIO_PADREGG_PAD27STRNG_Msk       (0x4000000UL)             /*!< PAD27STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGG_PAD27INPEN_Pos       (25UL)                    /*!< PAD27INPEN (Bit 25)                                   */
#define GPIO_PADREGG_PAD27INPEN_Msk       (0x2000000UL)             /*!< PAD27INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGG_PAD27PULL_Pos        (24UL)                    /*!< PAD27PULL (Bit 24)                                    */
#define GPIO_PADREGG_PAD27PULL_Msk        (0x1000000UL)             /*!< PAD27PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGG_PAD26FNCSEL_Pos      (19UL)                    /*!< PAD26FNCSEL (Bit 19)                                  */
#define GPIO_PADREGG_PAD26FNCSEL_Msk      (0x380000UL)              /*!< PAD26FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGG_PAD26STRNG_Pos       (18UL)                    /*!< PAD26STRNG (Bit 18)                                   */
#define GPIO_PADREGG_PAD26STRNG_Msk       (0x40000UL)               /*!< PAD26STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGG_PAD26INPEN_Pos       (17UL)                    /*!< PAD26INPEN (Bit 17)                                   */
#define GPIO_PADREGG_PAD26INPEN_Msk       (0x20000UL)               /*!< PAD26INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGG_PAD26PULL_Pos        (16UL)                    /*!< PAD26PULL (Bit 16)                                    */
#define GPIO_PADREGG_PAD26PULL_Msk        (0x10000UL)               /*!< PAD26PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGG_PAD25RSEL_Pos        (14UL)                    /*!< PAD25RSEL (Bit 14)                                    */
#define GPIO_PADREGG_PAD25RSEL_Msk        (0xc000UL)                /*!< PAD25RSEL (Bitfield-Mask: 0x03)                       */
#define GPIO_PADREGG_PAD25FNCSEL_Pos      (11UL)                    /*!< PAD25FNCSEL (Bit 11)                                  */
#define GPIO_PADREGG_PAD25FNCSEL_Msk      (0x3800UL)                /*!< PAD25FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGG_PAD25STRNG_Pos       (10UL)                    /*!< PAD25STRNG (Bit 10)                                   */
#define GPIO_PADREGG_PAD25STRNG_Msk       (0x400UL)                 /*!< PAD25STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGG_PAD25INPEN_Pos       (9UL)                     /*!< PAD25INPEN (Bit 9)                                    */
#define GPIO_PADREGG_PAD25INPEN_Msk       (0x200UL)                 /*!< PAD25INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGG_PAD25PULL_Pos        (8UL)                     /*!< PAD25PULL (Bit 8)                                     */
#define GPIO_PADREGG_PAD25PULL_Msk        (0x100UL)                 /*!< PAD25PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGG_PAD24FNCSEL_Pos      (3UL)                     /*!< PAD24FNCSEL (Bit 3)                                   */
#define GPIO_PADREGG_PAD24FNCSEL_Msk      (0x38UL)                  /*!< PAD24FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGG_PAD24STRNG_Pos       (2UL)                     /*!< PAD24STRNG (Bit 2)                                    */
#define GPIO_PADREGG_PAD24STRNG_Msk       (0x4UL)                   /*!< PAD24STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGG_PAD24INPEN_Pos       (1UL)                     /*!< PAD24INPEN (Bit 1)                                    */
#define GPIO_PADREGG_PAD24INPEN_Msk       (0x2UL)                   /*!< PAD24INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGG_PAD24PULL_Pos        (0UL)                     /*!< PAD24PULL (Bit 0)                                     */
#define GPIO_PADREGG_PAD24PULL_Msk        (0x1UL)                   /*!< PAD24PULL (Bitfield-Mask: 0x01)                       */
/* ========================================================  PADREGH  ======================================================== */
#define GPIO_PADREGH_PAD31FNCSEL_Pos      (27UL)                    /*!< PAD31FNCSEL (Bit 27)                                  */
#define GPIO_PADREGH_PAD31FNCSEL_Msk      (0x38000000UL)            /*!< PAD31FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGH_PAD31STRNG_Pos       (26UL)                    /*!< PAD31STRNG (Bit 26)                                   */
#define GPIO_PADREGH_PAD31STRNG_Msk       (0x4000000UL)             /*!< PAD31STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGH_PAD31INPEN_Pos       (25UL)                    /*!< PAD31INPEN (Bit 25)                                   */
#define GPIO_PADREGH_PAD31INPEN_Msk       (0x2000000UL)             /*!< PAD31INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGH_PAD31PULL_Pos        (24UL)                    /*!< PAD31PULL (Bit 24)                                    */
#define GPIO_PADREGH_PAD31PULL_Msk        (0x1000000UL)             /*!< PAD31PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGH_PAD30FNCSEL_Pos      (19UL)                    /*!< PAD30FNCSEL (Bit 19)                                  */
#define GPIO_PADREGH_PAD30FNCSEL_Msk      (0x380000UL)              /*!< PAD30FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGH_PAD30STRNG_Pos       (18UL)                    /*!< PAD30STRNG (Bit 18)                                   */
#define GPIO_PADREGH_PAD30STRNG_Msk       (0x40000UL)               /*!< PAD30STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGH_PAD30INPEN_Pos       (17UL)                    /*!< PAD30INPEN (Bit 17)                                   */
#define GPIO_PADREGH_PAD30INPEN_Msk       (0x20000UL)               /*!< PAD30INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGH_PAD30PULL_Pos        (16UL)                    /*!< PAD30PULL (Bit 16)                                    */
#define GPIO_PADREGH_PAD30PULL_Msk        (0x10000UL)               /*!< PAD30PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGH_PAD29FNCSEL_Pos      (11UL)                    /*!< PAD29FNCSEL (Bit 11)                                  */
#define GPIO_PADREGH_PAD29FNCSEL_Msk      (0x3800UL)                /*!< PAD29FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGH_PAD29STRNG_Pos       (10UL)                    /*!< PAD29STRNG (Bit 10)                                   */
#define GPIO_PADREGH_PAD29STRNG_Msk       (0x400UL)                 /*!< PAD29STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGH_PAD29INPEN_Pos       (9UL)                     /*!< PAD29INPEN (Bit 9)                                    */
#define GPIO_PADREGH_PAD29INPEN_Msk       (0x200UL)                 /*!< PAD29INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGH_PAD29PULL_Pos        (8UL)                     /*!< PAD29PULL (Bit 8)                                     */
#define GPIO_PADREGH_PAD29PULL_Msk        (0x100UL)                 /*!< PAD29PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGH_PAD28FNCSEL_Pos      (3UL)                     /*!< PAD28FNCSEL (Bit 3)                                   */
#define GPIO_PADREGH_PAD28FNCSEL_Msk      (0x38UL)                  /*!< PAD28FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGH_PAD28STRNG_Pos       (2UL)                     /*!< PAD28STRNG (Bit 2)                                    */
#define GPIO_PADREGH_PAD28STRNG_Msk       (0x4UL)                   /*!< PAD28STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGH_PAD28INPEN_Pos       (1UL)                     /*!< PAD28INPEN (Bit 1)                                    */
#define GPIO_PADREGH_PAD28INPEN_Msk       (0x2UL)                   /*!< PAD28INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGH_PAD28PULL_Pos        (0UL)                     /*!< PAD28PULL (Bit 0)                                     */
#define GPIO_PADREGH_PAD28PULL_Msk        (0x1UL)                   /*!< PAD28PULL (Bitfield-Mask: 0x01)                       */
/* ========================================================  PADREGI  ======================================================== */
#define GPIO_PADREGI_PAD35FNCSEL_Pos      (27UL)                    /*!< PAD35FNCSEL (Bit 27)                                  */
#define GPIO_PADREGI_PAD35FNCSEL_Msk      (0x38000000UL)            /*!< PAD35FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGI_PAD35STRNG_Pos       (26UL)                    /*!< PAD35STRNG (Bit 26)                                   */
#define GPIO_PADREGI_PAD35STRNG_Msk       (0x4000000UL)             /*!< PAD35STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGI_PAD35INPEN_Pos       (25UL)                    /*!< PAD35INPEN (Bit 25)                                   */
#define GPIO_PADREGI_PAD35INPEN_Msk       (0x2000000UL)             /*!< PAD35INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGI_PAD35PULL_Pos        (24UL)                    /*!< PAD35PULL (Bit 24)                                    */
#define GPIO_PADREGI_PAD35PULL_Msk        (0x1000000UL)             /*!< PAD35PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGI_PAD34FNCSEL_Pos      (19UL)                    /*!< PAD34FNCSEL (Bit 19)                                  */
#define GPIO_PADREGI_PAD34FNCSEL_Msk      (0x380000UL)              /*!< PAD34FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGI_PAD34STRNG_Pos       (18UL)                    /*!< PAD34STRNG (Bit 18)                                   */
#define GPIO_PADREGI_PAD34STRNG_Msk       (0x40000UL)               /*!< PAD34STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGI_PAD34INPEN_Pos       (17UL)                    /*!< PAD34INPEN (Bit 17)                                   */
#define GPIO_PADREGI_PAD34INPEN_Msk       (0x20000UL)               /*!< PAD34INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGI_PAD34PULL_Pos        (16UL)                    /*!< PAD34PULL (Bit 16)                                    */
#define GPIO_PADREGI_PAD34PULL_Msk        (0x10000UL)               /*!< PAD34PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGI_PAD33FNCSEL_Pos      (11UL)                    /*!< PAD33FNCSEL (Bit 11)                                  */
#define GPIO_PADREGI_PAD33FNCSEL_Msk      (0x3800UL)                /*!< PAD33FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGI_PAD33STRNG_Pos       (10UL)                    /*!< PAD33STRNG (Bit 10)                                   */
#define GPIO_PADREGI_PAD33STRNG_Msk       (0x400UL)                 /*!< PAD33STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGI_PAD33INPEN_Pos       (9UL)                     /*!< PAD33INPEN (Bit 9)                                    */
#define GPIO_PADREGI_PAD33INPEN_Msk       (0x200UL)                 /*!< PAD33INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGI_PAD33PULL_Pos        (8UL)                     /*!< PAD33PULL (Bit 8)                                     */
#define GPIO_PADREGI_PAD33PULL_Msk        (0x100UL)                 /*!< PAD33PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGI_PAD32FNCSEL_Pos      (3UL)                     /*!< PAD32FNCSEL (Bit 3)                                   */
#define GPIO_PADREGI_PAD32FNCSEL_Msk      (0x38UL)                  /*!< PAD32FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGI_PAD32STRNG_Pos       (2UL)                     /*!< PAD32STRNG (Bit 2)                                    */
#define GPIO_PADREGI_PAD32STRNG_Msk       (0x4UL)                   /*!< PAD32STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGI_PAD32INPEN_Pos       (1UL)                     /*!< PAD32INPEN (Bit 1)                                    */
#define GPIO_PADREGI_PAD32INPEN_Msk       (0x2UL)                   /*!< PAD32INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGI_PAD32PULL_Pos        (0UL)                     /*!< PAD32PULL (Bit 0)                                     */
#define GPIO_PADREGI_PAD32PULL_Msk        (0x1UL)                   /*!< PAD32PULL (Bitfield-Mask: 0x01)                       */
/* ========================================================  PADREGJ  ======================================================== */
#define GPIO_PADREGJ_PAD39RSEL_Pos        (30UL)                    /*!< PAD39RSEL (Bit 30)                                    */
#define GPIO_PADREGJ_PAD39RSEL_Msk        (0xc0000000UL)            /*!< PAD39RSEL (Bitfield-Mask: 0x03)                       */
#define GPIO_PADREGJ_PAD39FNCSEL_Pos      (27UL)                    /*!< PAD39FNCSEL (Bit 27)                                  */
#define GPIO_PADREGJ_PAD39FNCSEL_Msk      (0x38000000UL)            /*!< PAD39FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGJ_PAD39STRNG_Pos       (26UL)                    /*!< PAD39STRNG (Bit 26)                                   */
#define GPIO_PADREGJ_PAD39STRNG_Msk       (0x4000000UL)             /*!< PAD39STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGJ_PAD39INPEN_Pos       (25UL)                    /*!< PAD39INPEN (Bit 25)                                   */
#define GPIO_PADREGJ_PAD39INPEN_Msk       (0x2000000UL)             /*!< PAD39INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGJ_PAD39PULL_Pos        (24UL)                    /*!< PAD39PULL (Bit 24)                                    */
#define GPIO_PADREGJ_PAD39PULL_Msk        (0x1000000UL)             /*!< PAD39PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGJ_PAD38FNCSEL_Pos      (19UL)                    /*!< PAD38FNCSEL (Bit 19)                                  */
#define GPIO_PADREGJ_PAD38FNCSEL_Msk      (0x380000UL)              /*!< PAD38FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGJ_PAD38STRNG_Pos       (18UL)                    /*!< PAD38STRNG (Bit 18)                                   */
#define GPIO_PADREGJ_PAD38STRNG_Msk       (0x40000UL)               /*!< PAD38STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGJ_PAD38INPEN_Pos       (17UL)                    /*!< PAD38INPEN (Bit 17)                                   */
#define GPIO_PADREGJ_PAD38INPEN_Msk       (0x20000UL)               /*!< PAD38INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGJ_PAD38PULL_Pos        (16UL)                    /*!< PAD38PULL (Bit 16)                                    */
#define GPIO_PADREGJ_PAD38PULL_Msk        (0x10000UL)               /*!< PAD38PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGJ_PAD37FNCSEL_Pos      (11UL)                    /*!< PAD37FNCSEL (Bit 11)                                  */
#define GPIO_PADREGJ_PAD37FNCSEL_Msk      (0x3800UL)                /*!< PAD37FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGJ_PAD37STRNG_Pos       (10UL)                    /*!< PAD37STRNG (Bit 10)                                   */
#define GPIO_PADREGJ_PAD37STRNG_Msk       (0x400UL)                 /*!< PAD37STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGJ_PAD37INPEN_Pos       (9UL)                     /*!< PAD37INPEN (Bit 9)                                    */
#define GPIO_PADREGJ_PAD37INPEN_Msk       (0x200UL)                 /*!< PAD37INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGJ_PAD37PULL_Pos        (8UL)                     /*!< PAD37PULL (Bit 8)                                     */
#define GPIO_PADREGJ_PAD37PULL_Msk        (0x100UL)                 /*!< PAD37PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGJ_PAD36FNCSEL_Pos      (3UL)                     /*!< PAD36FNCSEL (Bit 3)                                   */
#define GPIO_PADREGJ_PAD36FNCSEL_Msk      (0x38UL)                  /*!< PAD36FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGJ_PAD36STRNG_Pos       (2UL)                     /*!< PAD36STRNG (Bit 2)                                    */
#define GPIO_PADREGJ_PAD36STRNG_Msk       (0x4UL)                   /*!< PAD36STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGJ_PAD36INPEN_Pos       (1UL)                     /*!< PAD36INPEN (Bit 1)                                    */
#define GPIO_PADREGJ_PAD36INPEN_Msk       (0x2UL)                   /*!< PAD36INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGJ_PAD36PULL_Pos        (0UL)                     /*!< PAD36PULL (Bit 0)                                     */
#define GPIO_PADREGJ_PAD36PULL_Msk        (0x1UL)                   /*!< PAD36PULL (Bitfield-Mask: 0x01)                       */
/* ========================================================  PADREGK  ======================================================== */
#define GPIO_PADREGK_PAD43RSEL_Pos        (30UL)                    /*!< PAD43RSEL (Bit 30)                                    */
#define GPIO_PADREGK_PAD43RSEL_Msk        (0xc0000000UL)            /*!< PAD43RSEL (Bitfield-Mask: 0x03)                       */
#define GPIO_PADREGK_PAD43FNCSEL_Pos      (27UL)                    /*!< PAD43FNCSEL (Bit 27)                                  */
#define GPIO_PADREGK_PAD43FNCSEL_Msk      (0x38000000UL)            /*!< PAD43FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGK_PAD43STRNG_Pos       (26UL)                    /*!< PAD43STRNG (Bit 26)                                   */
#define GPIO_PADREGK_PAD43STRNG_Msk       (0x4000000UL)             /*!< PAD43STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGK_PAD43INPEN_Pos       (25UL)                    /*!< PAD43INPEN (Bit 25)                                   */
#define GPIO_PADREGK_PAD43INPEN_Msk       (0x2000000UL)             /*!< PAD43INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGK_PAD43PULL_Pos        (24UL)                    /*!< PAD43PULL (Bit 24)                                    */
#define GPIO_PADREGK_PAD43PULL_Msk        (0x1000000UL)             /*!< PAD43PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGK_PAD42RSEL_Pos        (22UL)                    /*!< PAD42RSEL (Bit 22)                                    */
#define GPIO_PADREGK_PAD42RSEL_Msk        (0xc00000UL)              /*!< PAD42RSEL (Bitfield-Mask: 0x03)                       */
#define GPIO_PADREGK_PAD42FNCSEL_Pos      (19UL)                    /*!< PAD42FNCSEL (Bit 19)                                  */
#define GPIO_PADREGK_PAD42FNCSEL_Msk      (0x380000UL)              /*!< PAD42FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGK_PAD42STRNG_Pos       (18UL)                    /*!< PAD42STRNG (Bit 18)                                   */
#define GPIO_PADREGK_PAD42STRNG_Msk       (0x40000UL)               /*!< PAD42STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGK_PAD42INPEN_Pos       (17UL)                    /*!< PAD42INPEN (Bit 17)                                   */
#define GPIO_PADREGK_PAD42INPEN_Msk       (0x20000UL)               /*!< PAD42INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGK_PAD42PULL_Pos        (16UL)                    /*!< PAD42PULL (Bit 16)                                    */
#define GPIO_PADREGK_PAD42PULL_Msk        (0x10000UL)               /*!< PAD42PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGK_PAD41PWRUP_Pos       (15UL)                    /*!< PAD41PWRUP (Bit 15)                                   */
#define GPIO_PADREGK_PAD41PWRUP_Msk       (0x8000UL)                /*!< PAD41PWRUP (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGK_PAD41FNCSEL_Pos      (11UL)                    /*!< PAD41FNCSEL (Bit 11)                                  */
#define GPIO_PADREGK_PAD41FNCSEL_Msk      (0x3800UL)                /*!< PAD41FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGK_PAD41STRNG_Pos       (10UL)                    /*!< PAD41STRNG (Bit 10)                                   */
#define GPIO_PADREGK_PAD41STRNG_Msk       (0x400UL)                 /*!< PAD41STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGK_PAD41INPEN_Pos       (9UL)                     /*!< PAD41INPEN (Bit 9)                                    */
#define GPIO_PADREGK_PAD41INPEN_Msk       (0x200UL)                 /*!< PAD41INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGK_PAD41PULL_Pos        (8UL)                     /*!< PAD41PULL (Bit 8)                                     */
#define GPIO_PADREGK_PAD41PULL_Msk        (0x100UL)                 /*!< PAD41PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGK_PAD40RSEL_Pos        (6UL)                     /*!< PAD40RSEL (Bit 6)                                     */
#define GPIO_PADREGK_PAD40RSEL_Msk        (0xc0UL)                  /*!< PAD40RSEL (Bitfield-Mask: 0x03)                       */
#define GPIO_PADREGK_PAD40FNCSEL_Pos      (3UL)                     /*!< PAD40FNCSEL (Bit 3)                                   */
#define GPIO_PADREGK_PAD40FNCSEL_Msk      (0x38UL)                  /*!< PAD40FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGK_PAD40STRNG_Pos       (2UL)                     /*!< PAD40STRNG (Bit 2)                                    */
#define GPIO_PADREGK_PAD40STRNG_Msk       (0x4UL)                   /*!< PAD40STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGK_PAD40INPEN_Pos       (1UL)                     /*!< PAD40INPEN (Bit 1)                                    */
#define GPIO_PADREGK_PAD40INPEN_Msk       (0x2UL)                   /*!< PAD40INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGK_PAD40PULL_Pos        (0UL)                     /*!< PAD40PULL (Bit 0)                                     */
#define GPIO_PADREGK_PAD40PULL_Msk        (0x1UL)                   /*!< PAD40PULL (Bitfield-Mask: 0x01)                       */
/* ========================================================  PADREGL  ======================================================== */
#define GPIO_PADREGL_PAD47FNCSEL_Pos      (27UL)                    /*!< PAD47FNCSEL (Bit 27)                                  */
#define GPIO_PADREGL_PAD47FNCSEL_Msk      (0x38000000UL)            /*!< PAD47FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGL_PAD47STRNG_Pos       (26UL)                    /*!< PAD47STRNG (Bit 26)                                   */
#define GPIO_PADREGL_PAD47STRNG_Msk       (0x4000000UL)             /*!< PAD47STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGL_PAD47INPEN_Pos       (25UL)                    /*!< PAD47INPEN (Bit 25)                                   */
#define GPIO_PADREGL_PAD47INPEN_Msk       (0x2000000UL)             /*!< PAD47INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGL_PAD47PULL_Pos        (24UL)                    /*!< PAD47PULL (Bit 24)                                    */
#define GPIO_PADREGL_PAD47PULL_Msk        (0x1000000UL)             /*!< PAD47PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGL_PAD46FNCSEL_Pos      (19UL)                    /*!< PAD46FNCSEL (Bit 19)                                  */
#define GPIO_PADREGL_PAD46FNCSEL_Msk      (0x380000UL)              /*!< PAD46FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGL_PAD46STRNG_Pos       (18UL)                    /*!< PAD46STRNG (Bit 18)                                   */
#define GPIO_PADREGL_PAD46STRNG_Msk       (0x40000UL)               /*!< PAD46STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGL_PAD46INPEN_Pos       (17UL)                    /*!< PAD46INPEN (Bit 17)                                   */
#define GPIO_PADREGL_PAD46INPEN_Msk       (0x20000UL)               /*!< PAD46INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGL_PAD46PULL_Pos        (16UL)                    /*!< PAD46PULL (Bit 16)                                    */
#define GPIO_PADREGL_PAD46PULL_Msk        (0x10000UL)               /*!< PAD46PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGL_PAD45FNCSEL_Pos      (11UL)                    /*!< PAD45FNCSEL (Bit 11)                                  */
#define GPIO_PADREGL_PAD45FNCSEL_Msk      (0x3800UL)                /*!< PAD45FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGL_PAD45STRNG_Pos       (10UL)                    /*!< PAD45STRNG (Bit 10)                                   */
#define GPIO_PADREGL_PAD45STRNG_Msk       (0x400UL)                 /*!< PAD45STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGL_PAD45INPEN_Pos       (9UL)                     /*!< PAD45INPEN (Bit 9)                                    */
#define GPIO_PADREGL_PAD45INPEN_Msk       (0x200UL)                 /*!< PAD45INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGL_PAD45PULL_Pos        (8UL)                     /*!< PAD45PULL (Bit 8)                                     */
#define GPIO_PADREGL_PAD45PULL_Msk        (0x100UL)                 /*!< PAD45PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGL_PAD44FNCSEL_Pos      (3UL)                     /*!< PAD44FNCSEL (Bit 3)                                   */
#define GPIO_PADREGL_PAD44FNCSEL_Msk      (0x38UL)                  /*!< PAD44FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGL_PAD44STRNG_Pos       (2UL)                     /*!< PAD44STRNG (Bit 2)                                    */
#define GPIO_PADREGL_PAD44STRNG_Msk       (0x4UL)                   /*!< PAD44STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGL_PAD44INPEN_Pos       (1UL)                     /*!< PAD44INPEN (Bit 1)                                    */
#define GPIO_PADREGL_PAD44INPEN_Msk       (0x2UL)                   /*!< PAD44INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGL_PAD44PULL_Pos        (0UL)                     /*!< PAD44PULL (Bit 0)                                     */
#define GPIO_PADREGL_PAD44PULL_Msk        (0x1UL)                   /*!< PAD44PULL (Bitfield-Mask: 0x01)                       */
/* ========================================================  PADREGM  ======================================================== */
#define GPIO_PADREGM_PAD49RSEL_Pos        (14UL)                    /*!< PAD49RSEL (Bit 14)                                    */
#define GPIO_PADREGM_PAD49RSEL_Msk        (0xc000UL)                /*!< PAD49RSEL (Bitfield-Mask: 0x03)                       */
#define GPIO_PADREGM_PAD49FNCSEL_Pos      (11UL)                    /*!< PAD49FNCSEL (Bit 11)                                  */
#define GPIO_PADREGM_PAD49FNCSEL_Msk      (0x3800UL)                /*!< PAD49FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGM_PAD49STRNG_Pos       (10UL)                    /*!< PAD49STRNG (Bit 10)                                   */
#define GPIO_PADREGM_PAD49STRNG_Msk       (0x400UL)                 /*!< PAD49STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGM_PAD49INPEN_Pos       (9UL)                     /*!< PAD49INPEN (Bit 9)                                    */
#define GPIO_PADREGM_PAD49INPEN_Msk       (0x200UL)                 /*!< PAD49INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGM_PAD49PULL_Pos        (8UL)                     /*!< PAD49PULL (Bit 8)                                     */
#define GPIO_PADREGM_PAD49PULL_Msk        (0x100UL)                 /*!< PAD49PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGM_PAD48RSEL_Pos        (6UL)                     /*!< PAD48RSEL (Bit 6)                                     */
#define GPIO_PADREGM_PAD48RSEL_Msk        (0xc0UL)                  /*!< PAD48RSEL (Bitfield-Mask: 0x03)                       */
#define GPIO_PADREGM_PAD48FNCSEL_Pos      (3UL)                     /*!< PAD48FNCSEL (Bit 3)                                   */
#define GPIO_PADREGM_PAD48FNCSEL_Msk      (0x38UL)                  /*!< PAD48FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGM_PAD48STRNG_Pos       (2UL)                     /*!< PAD48STRNG (Bit 2)                                    */
#define GPIO_PADREGM_PAD48STRNG_Msk       (0x4UL)                   /*!< PAD48STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGM_PAD48INPEN_Pos       (1UL)                     /*!< PAD48INPEN (Bit 1)                                    */
#define GPIO_PADREGM_PAD48INPEN_Msk       (0x2UL)                   /*!< PAD48INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGM_PAD48PULL_Pos        (0UL)                     /*!< PAD48PULL (Bit 0)                                     */
#define GPIO_PADREGM_PAD48PULL_Msk        (0x1UL)                   /*!< PAD48PULL (Bitfield-Mask: 0x01)                       */
/* =========================================================  CFGA  ========================================================== */
#define GPIO_CFGA_GPIO7INTD_Pos           (31UL)                    /*!< GPIO7INTD (Bit 31)                                    */
#define GPIO_CFGA_GPIO7INTD_Msk           (0x80000000UL)            /*!< GPIO7INTD (Bitfield-Mask: 0x01)                       */
#define GPIO_CFGA_GPIO7OUTCFG_Pos         (29UL)                    /*!< GPIO7OUTCFG (Bit 29)                                  */
#define GPIO_CFGA_GPIO7OUTCFG_Msk         (0x60000000UL)            /*!< GPIO7OUTCFG (Bitfield-Mask: 0x03)                     */
#define GPIO_CFGA_GPIO7INCFG_Pos          (28UL)                    /*!< GPIO7INCFG (Bit 28)                                   */
#define GPIO_CFGA_GPIO7INCFG_Msk          (0x10000000UL)            /*!< GPIO7INCFG (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGA_GPIO6INTD_Pos           (27UL)                    /*!< GPIO6INTD (Bit 27)                                    */
#define GPIO_CFGA_GPIO6INTD_Msk           (0x8000000UL)             /*!< GPIO6INTD (Bitfield-Mask: 0x01)                       */
#define GPIO_CFGA_GPIO6OUTCFG_Pos         (25UL)                    /*!< GPIO6OUTCFG (Bit 25)                                  */
#define GPIO_CFGA_GPIO6OUTCFG_Msk         (0x6000000UL)             /*!< GPIO6OUTCFG (Bitfield-Mask: 0x03)                     */
#define GPIO_CFGA_GPIO6INCFG_Pos          (24UL)                    /*!< GPIO6INCFG (Bit 24)                                   */
#define GPIO_CFGA_GPIO6INCFG_Msk          (0x1000000UL)             /*!< GPIO6INCFG (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGA_GPIO5INTD_Pos           (23UL)                    /*!< GPIO5INTD (Bit 23)                                    */
#define GPIO_CFGA_GPIO5INTD_Msk           (0x800000UL)              /*!< GPIO5INTD (Bitfield-Mask: 0x01)                       */
#define GPIO_CFGA_GPIO5OUTCFG_Pos         (21UL)                    /*!< GPIO5OUTCFG (Bit 21)                                  */
#define GPIO_CFGA_GPIO5OUTCFG_Msk         (0x600000UL)              /*!< GPIO5OUTCFG (Bitfield-Mask: 0x03)                     */
#define GPIO_CFGA_GPIO5INCFG_Pos          (20UL)                    /*!< GPIO5INCFG (Bit 20)                                   */
#define GPIO_CFGA_GPIO5INCFG_Msk          (0x100000UL)              /*!< GPIO5INCFG (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGA_GPIO4INTD_Pos           (19UL)                    /*!< GPIO4INTD (Bit 19)                                    */
#define GPIO_CFGA_GPIO4INTD_Msk           (0x80000UL)               /*!< GPIO4INTD (Bitfield-Mask: 0x01)                       */
#define GPIO_CFGA_GPIO4OUTCFG_Pos         (17UL)                    /*!< GPIO4OUTCFG (Bit 17)                                  */
#define GPIO_CFGA_GPIO4OUTCFG_Msk         (0x60000UL)               /*!< GPIO4OUTCFG (Bitfield-Mask: 0x03)                     */
#define GPIO_CFGA_GPIO4INCFG_Pos          (16UL)                    /*!< GPIO4INCFG (Bit 16)                                   */
#define GPIO_CFGA_GPIO4INCFG_Msk          (0x10000UL)               /*!< GPIO4INCFG (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGA_GPIO3INTD_Pos           (15UL)                    /*!< GPIO3INTD (Bit 15)                                    */
#define GPIO_CFGA_GPIO3INTD_Msk           (0x8000UL)                /*!< GPIO3INTD (Bitfield-Mask: 0x01)                       */
#define GPIO_CFGA_GPIO3OUTCFG_Pos         (13UL)                    /*!< GPIO3OUTCFG (Bit 13)                                  */
#define GPIO_CFGA_GPIO3OUTCFG_Msk         (0x6000UL)                /*!< GPIO3OUTCFG (Bitfield-Mask: 0x03)                     */
#define GPIO_CFGA_GPIO3INCFG_Pos          (12UL)                    /*!< GPIO3INCFG (Bit 12)                                   */
#define GPIO_CFGA_GPIO3INCFG_Msk          (0x1000UL)                /*!< GPIO3INCFG (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGA_GPIO2INTD_Pos           (11UL)                    /*!< GPIO2INTD (Bit 11)                                    */
#define GPIO_CFGA_GPIO2INTD_Msk           (0x800UL)                 /*!< GPIO2INTD (Bitfield-Mask: 0x01)                       */
#define GPIO_CFGA_GPIO2OUTCFG_Pos         (9UL)                     /*!< GPIO2OUTCFG (Bit 9)                                   */
#define GPIO_CFGA_GPIO2OUTCFG_Msk         (0x600UL)                 /*!< GPIO2OUTCFG (Bitfield-Mask: 0x03)                     */
#define GPIO_CFGA_GPIO2INCFG_Pos          (8UL)                     /*!< GPIO2INCFG (Bit 8)                                    */
#define GPIO_CFGA_GPIO2INCFG_Msk          (0x100UL)                 /*!< GPIO2INCFG (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGA_GPIO1INTD_Pos           (7UL)                     /*!< GPIO1INTD (Bit 7)                                     */
#define GPIO_CFGA_GPIO1INTD_Msk           (0x80UL)                  /*!< GPIO1INTD (Bitfield-Mask: 0x01)                       */
#define GPIO_CFGA_GPIO1OUTCFG_Pos         (5UL)                     /*!< GPIO1OUTCFG (Bit 5)                                   */
#define GPIO_CFGA_GPIO1OUTCFG_Msk         (0x60UL)                  /*!< GPIO1OUTCFG (Bitfield-Mask: 0x03)                     */
#define GPIO_CFGA_GPIO1INCFG_Pos          (4UL)                     /*!< GPIO1INCFG (Bit 4)                                    */
#define GPIO_CFGA_GPIO1INCFG_Msk          (0x10UL)                  /*!< GPIO1INCFG (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGA_GPIO0INTD_Pos           (3UL)                     /*!< GPIO0INTD (Bit 3)                                     */
#define GPIO_CFGA_GPIO0INTD_Msk           (0x8UL)                   /*!< GPIO0INTD (Bitfield-Mask: 0x01)                       */
#define GPIO_CFGA_GPIO0OUTCFG_Pos         (1UL)                     /*!< GPIO0OUTCFG (Bit 1)                                   */
#define GPIO_CFGA_GPIO0OUTCFG_Msk         (0x6UL)                   /*!< GPIO0OUTCFG (Bitfield-Mask: 0x03)                     */
#define GPIO_CFGA_GPIO0INCFG_Pos          (0UL)                     /*!< GPIO0INCFG (Bit 0)                                    */
#define GPIO_CFGA_GPIO0INCFG_Msk          (0x1UL)                   /*!< GPIO0INCFG (Bitfield-Mask: 0x01)                      */
/* =========================================================  CFGB  ========================================================== */
#define GPIO_CFGB_GPIO15INTD_Pos          (31UL)                    /*!< GPIO15INTD (Bit 31)                                   */
#define GPIO_CFGB_GPIO15INTD_Msk          (0x80000000UL)            /*!< GPIO15INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGB_GPIO15OUTCFG_Pos        (29UL)                    /*!< GPIO15OUTCFG (Bit 29)                                 */
#define GPIO_CFGB_GPIO15OUTCFG_Msk        (0x60000000UL)            /*!< GPIO15OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGB_GPIO15INCFG_Pos         (28UL)                    /*!< GPIO15INCFG (Bit 28)                                  */
#define GPIO_CFGB_GPIO15INCFG_Msk         (0x10000000UL)            /*!< GPIO15INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGB_GPIO14INTD_Pos          (27UL)                    /*!< GPIO14INTD (Bit 27)                                   */
#define GPIO_CFGB_GPIO14INTD_Msk          (0x8000000UL)             /*!< GPIO14INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGB_GPIO14OUTCFG_Pos        (25UL)                    /*!< GPIO14OUTCFG (Bit 25)                                 */
#define GPIO_CFGB_GPIO14OUTCFG_Msk        (0x6000000UL)             /*!< GPIO14OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGB_GPIO14INCFG_Pos         (24UL)                    /*!< GPIO14INCFG (Bit 24)                                  */
#define GPIO_CFGB_GPIO14INCFG_Msk         (0x1000000UL)             /*!< GPIO14INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGB_GPIO13INTD_Pos          (23UL)                    /*!< GPIO13INTD (Bit 23)                                   */
#define GPIO_CFGB_GPIO13INTD_Msk          (0x800000UL)              /*!< GPIO13INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGB_GPIO13OUTCFG_Pos        (21UL)                    /*!< GPIO13OUTCFG (Bit 21)                                 */
#define GPIO_CFGB_GPIO13OUTCFG_Msk        (0x600000UL)              /*!< GPIO13OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGB_GPIO13INCFG_Pos         (20UL)                    /*!< GPIO13INCFG (Bit 20)                                  */
#define GPIO_CFGB_GPIO13INCFG_Msk         (0x100000UL)              /*!< GPIO13INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGB_GPIO12INTD_Pos          (19UL)                    /*!< GPIO12INTD (Bit 19)                                   */
#define GPIO_CFGB_GPIO12INTD_Msk          (0x80000UL)               /*!< GPIO12INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGB_GPIO12OUTCFG_Pos        (17UL)                    /*!< GPIO12OUTCFG (Bit 17)                                 */
#define GPIO_CFGB_GPIO12OUTCFG_Msk        (0x60000UL)               /*!< GPIO12OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGB_GPIO12INCFG_Pos         (16UL)                    /*!< GPIO12INCFG (Bit 16)                                  */
#define GPIO_CFGB_GPIO12INCFG_Msk         (0x10000UL)               /*!< GPIO12INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGB_GPIO11INTD_Pos          (15UL)                    /*!< GPIO11INTD (Bit 15)                                   */
#define GPIO_CFGB_GPIO11INTD_Msk          (0x8000UL)                /*!< GPIO11INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGB_GPIO11OUTCFG_Pos        (13UL)                    /*!< GPIO11OUTCFG (Bit 13)                                 */
#define GPIO_CFGB_GPIO11OUTCFG_Msk        (0x6000UL)                /*!< GPIO11OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGB_GPIO11INCFG_Pos         (12UL)                    /*!< GPIO11INCFG (Bit 12)                                  */
#define GPIO_CFGB_GPIO11INCFG_Msk         (0x1000UL)                /*!< GPIO11INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGB_GPIO10INTD_Pos          (11UL)                    /*!< GPIO10INTD (Bit 11)                                   */
#define GPIO_CFGB_GPIO10INTD_Msk          (0x800UL)                 /*!< GPIO10INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGB_GPIO10OUTCFG_Pos        (9UL)                     /*!< GPIO10OUTCFG (Bit 9)                                  */
#define GPIO_CFGB_GPIO10OUTCFG_Msk        (0x600UL)                 /*!< GPIO10OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGB_GPIO10INCFG_Pos         (8UL)                     /*!< GPIO10INCFG (Bit 8)                                   */
#define GPIO_CFGB_GPIO10INCFG_Msk         (0x100UL)                 /*!< GPIO10INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGB_GPIO9INTD_Pos           (7UL)                     /*!< GPIO9INTD (Bit 7)                                     */
#define GPIO_CFGB_GPIO9INTD_Msk           (0x80UL)                  /*!< GPIO9INTD (Bitfield-Mask: 0x01)                       */
#define GPIO_CFGB_GPIO9OUTCFG_Pos         (5UL)                     /*!< GPIO9OUTCFG (Bit 5)                                   */
#define GPIO_CFGB_GPIO9OUTCFG_Msk         (0x60UL)                  /*!< GPIO9OUTCFG (Bitfield-Mask: 0x03)                     */
#define GPIO_CFGB_GPIO9INCFG_Pos          (4UL)                     /*!< GPIO9INCFG (Bit 4)                                    */
#define GPIO_CFGB_GPIO9INCFG_Msk          (0x10UL)                  /*!< GPIO9INCFG (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGB_GPIO8INTD_Pos           (3UL)                     /*!< GPIO8INTD (Bit 3)                                     */
#define GPIO_CFGB_GPIO8INTD_Msk           (0x8UL)                   /*!< GPIO8INTD (Bitfield-Mask: 0x01)                       */
#define GPIO_CFGB_GPIO8OUTCFG_Pos         (1UL)                     /*!< GPIO8OUTCFG (Bit 1)                                   */
#define GPIO_CFGB_GPIO8OUTCFG_Msk         (0x6UL)                   /*!< GPIO8OUTCFG (Bitfield-Mask: 0x03)                     */
#define GPIO_CFGB_GPIO8INCFG_Pos          (0UL)                     /*!< GPIO8INCFG (Bit 0)                                    */
#define GPIO_CFGB_GPIO8INCFG_Msk          (0x1UL)                   /*!< GPIO8INCFG (Bitfield-Mask: 0x01)                      */
/* =========================================================  CFGC  ========================================================== */
#define GPIO_CFGC_GPIO23INTD_Pos          (31UL)                    /*!< GPIO23INTD (Bit 31)                                   */
#define GPIO_CFGC_GPIO23INTD_Msk          (0x80000000UL)            /*!< GPIO23INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGC_GPIO23OUTCFG_Pos        (29UL)                    /*!< GPIO23OUTCFG (Bit 29)                                 */
#define GPIO_CFGC_GPIO23OUTCFG_Msk        (0x60000000UL)            /*!< GPIO23OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGC_GPIO23INCFG_Pos         (28UL)                    /*!< GPIO23INCFG (Bit 28)                                  */
#define GPIO_CFGC_GPIO23INCFG_Msk         (0x10000000UL)            /*!< GPIO23INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGC_GPIO22INTD_Pos          (27UL)                    /*!< GPIO22INTD (Bit 27)                                   */
#define GPIO_CFGC_GPIO22INTD_Msk          (0x8000000UL)             /*!< GPIO22INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGC_GPIO22OUTCFG_Pos        (25UL)                    /*!< GPIO22OUTCFG (Bit 25)                                 */
#define GPIO_CFGC_GPIO22OUTCFG_Msk        (0x6000000UL)             /*!< GPIO22OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGC_GPIO22INCFG_Pos         (24UL)                    /*!< GPIO22INCFG (Bit 24)                                  */
#define GPIO_CFGC_GPIO22INCFG_Msk         (0x1000000UL)             /*!< GPIO22INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGC_GPIO21INTD_Pos          (23UL)                    /*!< GPIO21INTD (Bit 23)                                   */
#define GPIO_CFGC_GPIO21INTD_Msk          (0x800000UL)              /*!< GPIO21INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGC_GPIO21OUTCFG_Pos        (21UL)                    /*!< GPIO21OUTCFG (Bit 21)                                 */
#define GPIO_CFGC_GPIO21OUTCFG_Msk        (0x600000UL)              /*!< GPIO21OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGC_GPIO21INCFG_Pos         (20UL)                    /*!< GPIO21INCFG (Bit 20)                                  */
#define GPIO_CFGC_GPIO21INCFG_Msk         (0x100000UL)              /*!< GPIO21INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGC_GPIO20INTD_Pos          (19UL)                    /*!< GPIO20INTD (Bit 19)                                   */
#define GPIO_CFGC_GPIO20INTD_Msk          (0x80000UL)               /*!< GPIO20INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGC_GPIO20OUTCFG_Pos        (17UL)                    /*!< GPIO20OUTCFG (Bit 17)                                 */
#define GPIO_CFGC_GPIO20OUTCFG_Msk        (0x60000UL)               /*!< GPIO20OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGC_GPIO20INCFG_Pos         (16UL)                    /*!< GPIO20INCFG (Bit 16)                                  */
#define GPIO_CFGC_GPIO20INCFG_Msk         (0x10000UL)               /*!< GPIO20INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGC_GPIO19INTD_Pos          (15UL)                    /*!< GPIO19INTD (Bit 15)                                   */
#define GPIO_CFGC_GPIO19INTD_Msk          (0x8000UL)                /*!< GPIO19INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGC_GPIO19OUTCFG_Pos        (13UL)                    /*!< GPIO19OUTCFG (Bit 13)                                 */
#define GPIO_CFGC_GPIO19OUTCFG_Msk        (0x6000UL)                /*!< GPIO19OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGC_GPIO19INCFG_Pos         (12UL)                    /*!< GPIO19INCFG (Bit 12)                                  */
#define GPIO_CFGC_GPIO19INCFG_Msk         (0x1000UL)                /*!< GPIO19INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGC_GPIO18INTD_Pos          (11UL)                    /*!< GPIO18INTD (Bit 11)                                   */
#define GPIO_CFGC_GPIO18INTD_Msk          (0x800UL)                 /*!< GPIO18INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGC_GPIO18OUTCFG_Pos        (9UL)                     /*!< GPIO18OUTCFG (Bit 9)                                  */
#define GPIO_CFGC_GPIO18OUTCFG_Msk        (0x600UL)                 /*!< GPIO18OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGC_GPIO18INCFG_Pos         (8UL)                     /*!< GPIO18INCFG (Bit 8)                                   */
#define GPIO_CFGC_GPIO18INCFG_Msk         (0x100UL)                 /*!< GPIO18INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGC_GPIO17INTD_Pos          (7UL)                     /*!< GPIO17INTD (Bit 7)                                    */
#define GPIO_CFGC_GPIO17INTD_Msk          (0x80UL)                  /*!< GPIO17INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGC_GPIO17OUTCFG_Pos        (5UL)                     /*!< GPIO17OUTCFG (Bit 5)                                  */
#define GPIO_CFGC_GPIO17OUTCFG_Msk        (0x60UL)                  /*!< GPIO17OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGC_GPIO17INCFG_Pos         (4UL)                     /*!< GPIO17INCFG (Bit 4)                                   */
#define GPIO_CFGC_GPIO17INCFG_Msk         (0x10UL)                  /*!< GPIO17INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGC_GPIO16INTD_Pos          (3UL)                     /*!< GPIO16INTD (Bit 3)                                    */
#define GPIO_CFGC_GPIO16INTD_Msk          (0x8UL)                   /*!< GPIO16INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGC_GPIO16OUTCFG_Pos        (1UL)                     /*!< GPIO16OUTCFG (Bit 1)                                  */
#define GPIO_CFGC_GPIO16OUTCFG_Msk        (0x6UL)                   /*!< GPIO16OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGC_GPIO16INCFG_Pos         (0UL)                     /*!< GPIO16INCFG (Bit 0)                                   */
#define GPIO_CFGC_GPIO16INCFG_Msk         (0x1UL)                   /*!< GPIO16INCFG (Bitfield-Mask: 0x01)                     */
/* =========================================================  CFGD  ========================================================== */
#define GPIO_CFGD_GPIO31INTD_Pos          (31UL)                    /*!< GPIO31INTD (Bit 31)                                   */
#define GPIO_CFGD_GPIO31INTD_Msk          (0x80000000UL)            /*!< GPIO31INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGD_GPIO31OUTCFG_Pos        (29UL)                    /*!< GPIO31OUTCFG (Bit 29)                                 */
#define GPIO_CFGD_GPIO31OUTCFG_Msk        (0x60000000UL)            /*!< GPIO31OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGD_GPIO31INCFG_Pos         (28UL)                    /*!< GPIO31INCFG (Bit 28)                                  */
#define GPIO_CFGD_GPIO31INCFG_Msk         (0x10000000UL)            /*!< GPIO31INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGD_GPIO30INTD_Pos          (27UL)                    /*!< GPIO30INTD (Bit 27)                                   */
#define GPIO_CFGD_GPIO30INTD_Msk          (0x8000000UL)             /*!< GPIO30INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGD_GPIO30OUTCFG_Pos        (25UL)                    /*!< GPIO30OUTCFG (Bit 25)                                 */
#define GPIO_CFGD_GPIO30OUTCFG_Msk        (0x6000000UL)             /*!< GPIO30OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGD_GPIO30INCFG_Pos         (24UL)                    /*!< GPIO30INCFG (Bit 24)                                  */
#define GPIO_CFGD_GPIO30INCFG_Msk         (0x1000000UL)             /*!< GPIO30INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGD_GPIO29INTD_Pos          (23UL)                    /*!< GPIO29INTD (Bit 23)                                   */
#define GPIO_CFGD_GPIO29INTD_Msk          (0x800000UL)              /*!< GPIO29INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGD_GPIO29OUTCFG_Pos        (21UL)                    /*!< GPIO29OUTCFG (Bit 21)                                 */
#define GPIO_CFGD_GPIO29OUTCFG_Msk        (0x600000UL)              /*!< GPIO29OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGD_GPIO29INCFG_Pos         (20UL)                    /*!< GPIO29INCFG (Bit 20)                                  */
#define GPIO_CFGD_GPIO29INCFG_Msk         (0x100000UL)              /*!< GPIO29INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGD_GPIO28INTD_Pos          (19UL)                    /*!< GPIO28INTD (Bit 19)                                   */
#define GPIO_CFGD_GPIO28INTD_Msk          (0x80000UL)               /*!< GPIO28INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGD_GPIO28OUTCFG_Pos        (17UL)                    /*!< GPIO28OUTCFG (Bit 17)                                 */
#define GPIO_CFGD_GPIO28OUTCFG_Msk        (0x60000UL)               /*!< GPIO28OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGD_GPIO28INCFG_Pos         (16UL)                    /*!< GPIO28INCFG (Bit 16)                                  */
#define GPIO_CFGD_GPIO28INCFG_Msk         (0x10000UL)               /*!< GPIO28INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGD_GPIO27INTD_Pos          (15UL)                    /*!< GPIO27INTD (Bit 15)                                   */
#define GPIO_CFGD_GPIO27INTD_Msk          (0x8000UL)                /*!< GPIO27INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGD_GPIO27OUTCFG_Pos        (13UL)                    /*!< GPIO27OUTCFG (Bit 13)                                 */
#define GPIO_CFGD_GPIO27OUTCFG_Msk        (0x6000UL)                /*!< GPIO27OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGD_GPIO27INCFG_Pos         (12UL)                    /*!< GPIO27INCFG (Bit 12)                                  */
#define GPIO_CFGD_GPIO27INCFG_Msk         (0x1000UL)                /*!< GPIO27INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGD_GPIO26INTD_Pos          (11UL)                    /*!< GPIO26INTD (Bit 11)                                   */
#define GPIO_CFGD_GPIO26INTD_Msk          (0x800UL)                 /*!< GPIO26INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGD_GPIO26OUTCFG_Pos        (9UL)                     /*!< GPIO26OUTCFG (Bit 9)                                  */
#define GPIO_CFGD_GPIO26OUTCFG_Msk        (0x600UL)                 /*!< GPIO26OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGD_GPIO26INCFG_Pos         (8UL)                     /*!< GPIO26INCFG (Bit 8)                                   */
#define GPIO_CFGD_GPIO26INCFG_Msk         (0x100UL)                 /*!< GPIO26INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGD_GPIO25INTD_Pos          (7UL)                     /*!< GPIO25INTD (Bit 7)                                    */
#define GPIO_CFGD_GPIO25INTD_Msk          (0x80UL)                  /*!< GPIO25INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGD_GPIO25OUTCFG_Pos        (5UL)                     /*!< GPIO25OUTCFG (Bit 5)                                  */
#define GPIO_CFGD_GPIO25OUTCFG_Msk        (0x60UL)                  /*!< GPIO25OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGD_GPIO25INCFG_Pos         (4UL)                     /*!< GPIO25INCFG (Bit 4)                                   */
#define GPIO_CFGD_GPIO25INCFG_Msk         (0x10UL)                  /*!< GPIO25INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGD_GPIO24INTD_Pos          (3UL)                     /*!< GPIO24INTD (Bit 3)                                    */
#define GPIO_CFGD_GPIO24INTD_Msk          (0x8UL)                   /*!< GPIO24INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGD_GPIO24OUTCFG_Pos        (1UL)                     /*!< GPIO24OUTCFG (Bit 1)                                  */
#define GPIO_CFGD_GPIO24OUTCFG_Msk        (0x6UL)                   /*!< GPIO24OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGD_GPIO24INCFG_Pos         (0UL)                     /*!< GPIO24INCFG (Bit 0)                                   */
#define GPIO_CFGD_GPIO24INCFG_Msk         (0x1UL)                   /*!< GPIO24INCFG (Bitfield-Mask: 0x01)                     */
/* =========================================================  CFGE  ========================================================== */
#define GPIO_CFGE_GPIO39INTD_Pos          (31UL)                    /*!< GPIO39INTD (Bit 31)                                   */
#define GPIO_CFGE_GPIO39INTD_Msk          (0x80000000UL)            /*!< GPIO39INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGE_GPIO39OUTCFG_Pos        (29UL)                    /*!< GPIO39OUTCFG (Bit 29)                                 */
#define GPIO_CFGE_GPIO39OUTCFG_Msk        (0x60000000UL)            /*!< GPIO39OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGE_GPIO39INCFG_Pos         (28UL)                    /*!< GPIO39INCFG (Bit 28)                                  */
#define GPIO_CFGE_GPIO39INCFG_Msk         (0x10000000UL)            /*!< GPIO39INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGE_GPIO38INTD_Pos          (27UL)                    /*!< GPIO38INTD (Bit 27)                                   */
#define GPIO_CFGE_GPIO38INTD_Msk          (0x8000000UL)             /*!< GPIO38INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGE_GPIO38OUTCFG_Pos        (25UL)                    /*!< GPIO38OUTCFG (Bit 25)                                 */
#define GPIO_CFGE_GPIO38OUTCFG_Msk        (0x6000000UL)             /*!< GPIO38OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGE_GPIO38INCFG_Pos         (24UL)                    /*!< GPIO38INCFG (Bit 24)                                  */
#define GPIO_CFGE_GPIO38INCFG_Msk         (0x1000000UL)             /*!< GPIO38INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGE_GPIO37INTD_Pos          (23UL)                    /*!< GPIO37INTD (Bit 23)                                   */
#define GPIO_CFGE_GPIO37INTD_Msk          (0x800000UL)              /*!< GPIO37INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGE_GPIO37OUTCFG_Pos        (21UL)                    /*!< GPIO37OUTCFG (Bit 21)                                 */
#define GPIO_CFGE_GPIO37OUTCFG_Msk        (0x600000UL)              /*!< GPIO37OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGE_GPIO37INCFG_Pos         (20UL)                    /*!< GPIO37INCFG (Bit 20)                                  */
#define GPIO_CFGE_GPIO37INCFG_Msk         (0x100000UL)              /*!< GPIO37INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGE_GPIO36INTD_Pos          (19UL)                    /*!< GPIO36INTD (Bit 19)                                   */
#define GPIO_CFGE_GPIO36INTD_Msk          (0x80000UL)               /*!< GPIO36INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGE_GPIO36OUTCFG_Pos        (17UL)                    /*!< GPIO36OUTCFG (Bit 17)                                 */
#define GPIO_CFGE_GPIO36OUTCFG_Msk        (0x60000UL)               /*!< GPIO36OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGE_GPIO36INCFG_Pos         (16UL)                    /*!< GPIO36INCFG (Bit 16)                                  */
#define GPIO_CFGE_GPIO36INCFG_Msk         (0x10000UL)               /*!< GPIO36INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGE_GPIO35INTD_Pos          (15UL)                    /*!< GPIO35INTD (Bit 15)                                   */
#define GPIO_CFGE_GPIO35INTD_Msk          (0x8000UL)                /*!< GPIO35INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGE_GPIO35OUTCFG_Pos        (13UL)                    /*!< GPIO35OUTCFG (Bit 13)                                 */
#define GPIO_CFGE_GPIO35OUTCFG_Msk        (0x6000UL)                /*!< GPIO35OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGE_GPIO35INCFG_Pos         (12UL)                    /*!< GPIO35INCFG (Bit 12)                                  */
#define GPIO_CFGE_GPIO35INCFG_Msk         (0x1000UL)                /*!< GPIO35INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGE_GPIO34INTD_Pos          (11UL)                    /*!< GPIO34INTD (Bit 11)                                   */
#define GPIO_CFGE_GPIO34INTD_Msk          (0x800UL)                 /*!< GPIO34INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGE_GPIO34OUTCFG_Pos        (9UL)                     /*!< GPIO34OUTCFG (Bit 9)                                  */
#define GPIO_CFGE_GPIO34OUTCFG_Msk        (0x600UL)                 /*!< GPIO34OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGE_GPIO34INCFG_Pos         (8UL)                     /*!< GPIO34INCFG (Bit 8)                                   */
#define GPIO_CFGE_GPIO34INCFG_Msk         (0x100UL)                 /*!< GPIO34INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGE_GPIO33INTD_Pos          (7UL)                     /*!< GPIO33INTD (Bit 7)                                    */
#define GPIO_CFGE_GPIO33INTD_Msk          (0x80UL)                  /*!< GPIO33INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGE_GPIO33OUTCFG_Pos        (5UL)                     /*!< GPIO33OUTCFG (Bit 5)                                  */
#define GPIO_CFGE_GPIO33OUTCFG_Msk        (0x60UL)                  /*!< GPIO33OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGE_GPIO33INCFG_Pos         (4UL)                     /*!< GPIO33INCFG (Bit 4)                                   */
#define GPIO_CFGE_GPIO33INCFG_Msk         (0x10UL)                  /*!< GPIO33INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGE_GPIO32INTD_Pos          (3UL)                     /*!< GPIO32INTD (Bit 3)                                    */
#define GPIO_CFGE_GPIO32INTD_Msk          (0x8UL)                   /*!< GPIO32INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGE_GPIO32OUTCFG_Pos        (1UL)                     /*!< GPIO32OUTCFG (Bit 1)                                  */
#define GPIO_CFGE_GPIO32OUTCFG_Msk        (0x6UL)                   /*!< GPIO32OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGE_GPIO32INCFG_Pos         (0UL)                     /*!< GPIO32INCFG (Bit 0)                                   */
#define GPIO_CFGE_GPIO32INCFG_Msk         (0x1UL)                   /*!< GPIO32INCFG (Bitfield-Mask: 0x01)                     */
/* =========================================================  CFGF  ========================================================== */
#define GPIO_CFGF_GPIO47INTD_Pos          (31UL)                    /*!< GPIO47INTD (Bit 31)                                   */
#define GPIO_CFGF_GPIO47INTD_Msk          (0x80000000UL)            /*!< GPIO47INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGF_GPIO47OUTCFG_Pos        (29UL)                    /*!< GPIO47OUTCFG (Bit 29)                                 */
#define GPIO_CFGF_GPIO47OUTCFG_Msk        (0x60000000UL)            /*!< GPIO47OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGF_GPIO47INCFG_Pos         (28UL)                    /*!< GPIO47INCFG (Bit 28)                                  */
#define GPIO_CFGF_GPIO47INCFG_Msk         (0x10000000UL)            /*!< GPIO47INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGF_GPIO46INTD_Pos          (27UL)                    /*!< GPIO46INTD (Bit 27)                                   */
#define GPIO_CFGF_GPIO46INTD_Msk          (0x8000000UL)             /*!< GPIO46INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGF_GPIO46OUTCFG_Pos        (25UL)                    /*!< GPIO46OUTCFG (Bit 25)                                 */
#define GPIO_CFGF_GPIO46OUTCFG_Msk        (0x6000000UL)             /*!< GPIO46OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGF_GPIO46INCFG_Pos         (24UL)                    /*!< GPIO46INCFG (Bit 24)                                  */
#define GPIO_CFGF_GPIO46INCFG_Msk         (0x1000000UL)             /*!< GPIO46INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGF_GPIO45INTD_Pos          (23UL)                    /*!< GPIO45INTD (Bit 23)                                   */
#define GPIO_CFGF_GPIO45INTD_Msk          (0x800000UL)              /*!< GPIO45INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGF_GPIO45OUTCFG_Pos        (21UL)                    /*!< GPIO45OUTCFG (Bit 21)                                 */
#define GPIO_CFGF_GPIO45OUTCFG_Msk        (0x600000UL)              /*!< GPIO45OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGF_GPIO45INCFG_Pos         (20UL)                    /*!< GPIO45INCFG (Bit 20)                                  */
#define GPIO_CFGF_GPIO45INCFG_Msk         (0x100000UL)              /*!< GPIO45INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGF_GPIO44INTD_Pos          (19UL)                    /*!< GPIO44INTD (Bit 19)                                   */
#define GPIO_CFGF_GPIO44INTD_Msk          (0x80000UL)               /*!< GPIO44INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGF_GPIO44OUTCFG_Pos        (17UL)                    /*!< GPIO44OUTCFG (Bit 17)                                 */
#define GPIO_CFGF_GPIO44OUTCFG_Msk        (0x60000UL)               /*!< GPIO44OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGF_GPIO44INCFG_Pos         (16UL)                    /*!< GPIO44INCFG (Bit 16)                                  */
#define GPIO_CFGF_GPIO44INCFG_Msk         (0x10000UL)               /*!< GPIO44INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGF_GPIO43INTD_Pos          (15UL)                    /*!< GPIO43INTD (Bit 15)                                   */
#define GPIO_CFGF_GPIO43INTD_Msk          (0x8000UL)                /*!< GPIO43INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGF_GPIO43OUTCFG_Pos        (13UL)                    /*!< GPIO43OUTCFG (Bit 13)                                 */
#define GPIO_CFGF_GPIO43OUTCFG_Msk        (0x6000UL)                /*!< GPIO43OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGF_GPIO43INCFG_Pos         (12UL)                    /*!< GPIO43INCFG (Bit 12)                                  */
#define GPIO_CFGF_GPIO43INCFG_Msk         (0x1000UL)                /*!< GPIO43INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGF_GPIO42INTD_Pos          (11UL)                    /*!< GPIO42INTD (Bit 11)                                   */
#define GPIO_CFGF_GPIO42INTD_Msk          (0x800UL)                 /*!< GPIO42INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGF_GPIO42OUTCFG_Pos        (9UL)                     /*!< GPIO42OUTCFG (Bit 9)                                  */
#define GPIO_CFGF_GPIO42OUTCFG_Msk        (0x600UL)                 /*!< GPIO42OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGF_GPIO42INCFG_Pos         (8UL)                     /*!< GPIO42INCFG (Bit 8)                                   */
#define GPIO_CFGF_GPIO42INCFG_Msk         (0x100UL)                 /*!< GPIO42INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGF_GPIO41INTD_Pos          (7UL)                     /*!< GPIO41INTD (Bit 7)                                    */
#define GPIO_CFGF_GPIO41INTD_Msk          (0x80UL)                  /*!< GPIO41INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGF_GPIO41OUTCFG_Pos        (5UL)                     /*!< GPIO41OUTCFG (Bit 5)                                  */
#define GPIO_CFGF_GPIO41OUTCFG_Msk        (0x60UL)                  /*!< GPIO41OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGF_GPIO41INCFG_Pos         (4UL)                     /*!< GPIO41INCFG (Bit 4)                                   */
#define GPIO_CFGF_GPIO41INCFG_Msk         (0x10UL)                  /*!< GPIO41INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGF_GPIO40INTD_Pos          (3UL)                     /*!< GPIO40INTD (Bit 3)                                    */
#define GPIO_CFGF_GPIO40INTD_Msk          (0x8UL)                   /*!< GPIO40INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGF_GPIO40OUTCFG_Pos        (1UL)                     /*!< GPIO40OUTCFG (Bit 1)                                  */
#define GPIO_CFGF_GPIO40OUTCFG_Msk        (0x6UL)                   /*!< GPIO40OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGF_GPIO40INCFG_Pos         (0UL)                     /*!< GPIO40INCFG (Bit 0)                                   */
#define GPIO_CFGF_GPIO40INCFG_Msk         (0x1UL)                   /*!< GPIO40INCFG (Bitfield-Mask: 0x01)                     */
/* =========================================================  CFGG  ========================================================== */
#define GPIO_CFGG_GPIO49INTD_Pos          (7UL)                     /*!< GPIO49INTD (Bit 7)                                    */
#define GPIO_CFGG_GPIO49INTD_Msk          (0x80UL)                  /*!< GPIO49INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGG_GPIO49OUTCFG_Pos        (5UL)                     /*!< GPIO49OUTCFG (Bit 5)                                  */
#define GPIO_CFGG_GPIO49OUTCFG_Msk        (0x60UL)                  /*!< GPIO49OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGG_GPIO49INCFG_Pos         (4UL)                     /*!< GPIO49INCFG (Bit 4)                                   */
#define GPIO_CFGG_GPIO49INCFG_Msk         (0x10UL)                  /*!< GPIO49INCFG (Bitfield-Mask: 0x01)                     */
#define GPIO_CFGG_GPIO48INTD_Pos          (3UL)                     /*!< GPIO48INTD (Bit 3)                                    */
#define GPIO_CFGG_GPIO48INTD_Msk          (0x8UL)                   /*!< GPIO48INTD (Bitfield-Mask: 0x01)                      */
#define GPIO_CFGG_GPIO48OUTCFG_Pos        (1UL)                     /*!< GPIO48OUTCFG (Bit 1)                                  */
#define GPIO_CFGG_GPIO48OUTCFG_Msk        (0x6UL)                   /*!< GPIO48OUTCFG (Bitfield-Mask: 0x03)                    */
#define GPIO_CFGG_GPIO48INCFG_Pos         (0UL)                     /*!< GPIO48INCFG (Bit 0)                                   */
#define GPIO_CFGG_GPIO48INCFG_Msk         (0x1UL)                   /*!< GPIO48INCFG (Bitfield-Mask: 0x01)                     */
/* ========================================================  PADKEY  ========================================================= */
#define GPIO_PADKEY_PADKEY_Pos            (0UL)                     /*!< PADKEY (Bit 0)                                        */
#define GPIO_PADKEY_PADKEY_Msk            (0xffffffffUL)            /*!< PADKEY (Bitfield-Mask: 0xffffffff)                    */
/* ==========================================================  RDA  ========================================================== */
#define GPIO_RDA_RDA_Pos                  (0UL)                     /*!< RDA (Bit 0)                                           */
#define GPIO_RDA_RDA_Msk                  (0xffffffffUL)            /*!< RDA (Bitfield-Mask: 0xffffffff)                       */
/* ==========================================================  RDB  ========================================================== */
#define GPIO_RDB_RDB_Pos                  (0UL)                     /*!< RDB (Bit 0)                                           */
#define GPIO_RDB_RDB_Msk                  (0x3ffffUL)               /*!< RDB (Bitfield-Mask: 0x3ffff)                          */
/* ==========================================================  WTA  ========================================================== */
#define GPIO_WTA_WTA_Pos                  (0UL)                     /*!< WTA (Bit 0)                                           */
#define GPIO_WTA_WTA_Msk                  (0xffffffffUL)            /*!< WTA (Bitfield-Mask: 0xffffffff)                       */
/* ==========================================================  WTB  ========================================================== */
#define GPIO_WTB_WTB_Pos                  (0UL)                     /*!< WTB (Bit 0)                                           */
#define GPIO_WTB_WTB_Msk                  (0x3ffffUL)               /*!< WTB (Bitfield-Mask: 0x3ffff)                          */
/* =========================================================  WTSA  ========================================================== */
#define GPIO_WTSA_WTSA_Pos                (0UL)                     /*!< WTSA (Bit 0)                                          */
#define GPIO_WTSA_WTSA_Msk                (0xffffffffUL)            /*!< WTSA (Bitfield-Mask: 0xffffffff)                      */
/* =========================================================  WTSB  ========================================================== */
#define GPIO_WTSB_WTSB_Pos                (0UL)                     /*!< WTSB (Bit 0)                                          */
#define GPIO_WTSB_WTSB_Msk                (0x3ffffUL)               /*!< WTSB (Bitfield-Mask: 0x3ffff)                         */
/* =========================================================  WTCA  ========================================================== */
#define GPIO_WTCA_WTCA_Pos                (0UL)                     /*!< WTCA (Bit 0)                                          */
#define GPIO_WTCA_WTCA_Msk                (0xffffffffUL)            /*!< WTCA (Bitfield-Mask: 0xffffffff)                      */
/* =========================================================  WTCB  ========================================================== */
#define GPIO_WTCB_WTCB_Pos                (0UL)                     /*!< WTCB (Bit 0)                                          */
#define GPIO_WTCB_WTCB_Msk                (0x3ffffUL)               /*!< WTCB (Bitfield-Mask: 0x3ffff)                         */
/* ==========================================================  ENA  ========================================================== */
#define GPIO_ENA_ENA_Pos                  (0UL)                     /*!< ENA (Bit 0)                                           */
#define GPIO_ENA_ENA_Msk                  (0xffffffffUL)            /*!< ENA (Bitfield-Mask: 0xffffffff)                       */
/* ==========================================================  ENB  ========================================================== */
#define GPIO_ENB_ENB_Pos                  (0UL)                     /*!< ENB (Bit 0)                                           */
#define GPIO_ENB_ENB_Msk                  (0x3ffffUL)               /*!< ENB (Bitfield-Mask: 0x3ffff)                          */
/* =========================================================  ENSA  ========================================================== */
#define GPIO_ENSA_ENSA_Pos                (0UL)                     /*!< ENSA (Bit 0)                                          */
#define GPIO_ENSA_ENSA_Msk                (0xffffffffUL)            /*!< ENSA (Bitfield-Mask: 0xffffffff)                      */
/* =========================================================  ENSB  ========================================================== */
#define GPIO_ENSB_ENSB_Pos                (0UL)                     /*!< ENSB (Bit 0)                                          */
#define GPIO_ENSB_ENSB_Msk                (0x3ffffUL)               /*!< ENSB (Bitfield-Mask: 0x3ffff)                         */
/* =========================================================  ENCA  ========================================================== */
#define GPIO_ENCA_ENCA_Pos                (0UL)                     /*!< ENCA (Bit 0)                                          */
#define GPIO_ENCA_ENCA_Msk                (0xffffffffUL)            /*!< ENCA (Bitfield-Mask: 0xffffffff)                      */
/* =========================================================  ENCB  ========================================================== */
#define GPIO_ENCB_ENCB_Pos                (0UL)                     /*!< ENCB (Bit 0)                                          */
#define GPIO_ENCB_ENCB_Msk                (0x3ffffUL)               /*!< ENCB (Bitfield-Mask: 0x3ffff)                         */
/* ========================================================  STMRCAP  ======================================================== */
#define GPIO_STMRCAP_STPOL3_Pos           (30UL)                    /*!< STPOL3 (Bit 30)                                       */
#define GPIO_STMRCAP_STPOL3_Msk           (0x40000000UL)            /*!< STPOL3 (Bitfield-Mask: 0x01)                          */
#define GPIO_STMRCAP_STSEL3_Pos           (24UL)                    /*!< STSEL3 (Bit 24)                                       */
#define GPIO_STMRCAP_STSEL3_Msk           (0x3f000000UL)            /*!< STSEL3 (Bitfield-Mask: 0x3f)                          */
#define GPIO_STMRCAP_STPOL2_Pos           (22UL)                    /*!< STPOL2 (Bit 22)                                       */
#define GPIO_STMRCAP_STPOL2_Msk           (0x400000UL)              /*!< STPOL2 (Bitfield-Mask: 0x01)                          */
#define GPIO_STMRCAP_STSEL2_Pos           (16UL)                    /*!< STSEL2 (Bit 16)                                       */
#define GPIO_STMRCAP_STSEL2_Msk           (0x3f0000UL)              /*!< STSEL2 (Bitfield-Mask: 0x3f)                          */
#define GPIO_STMRCAP_STPOL1_Pos           (14UL)                    /*!< STPOL1 (Bit 14)                                       */
#define GPIO_STMRCAP_STPOL1_Msk           (0x4000UL)                /*!< STPOL1 (Bitfield-Mask: 0x01)                          */
#define GPIO_STMRCAP_STSEL1_Pos           (8UL)                     /*!< STSEL1 (Bit 8)                                        */
#define GPIO_STMRCAP_STSEL1_Msk           (0x3f00UL)                /*!< STSEL1 (Bitfield-Mask: 0x3f)                          */
#define GPIO_STMRCAP_STPOL0_Pos           (6UL)                     /*!< STPOL0 (Bit 6)                                        */
#define GPIO_STMRCAP_STPOL0_Msk           (0x40UL)                  /*!< STPOL0 (Bitfield-Mask: 0x01)                          */
#define GPIO_STMRCAP_STSEL0_Pos           (0UL)                     /*!< STSEL0 (Bit 0)                                        */
#define GPIO_STMRCAP_STSEL0_Msk           (0x3fUL)                  /*!< STSEL0 (Bitfield-Mask: 0x3f)                          */
/* ========================================================  IOM0IRQ  ======================================================== */
#define GPIO_IOM0IRQ_IOM0IRQ_Pos          (0UL)                     /*!< IOM0IRQ (Bit 0)                                       */
#define GPIO_IOM0IRQ_IOM0IRQ_Msk          (0x3fUL)                  /*!< IOM0IRQ (Bitfield-Mask: 0x3f)                         */
/* ========================================================  IOM1IRQ  ======================================================== */
#define GPIO_IOM1IRQ_IOM1IRQ_Pos          (0UL)                     /*!< IOM1IRQ (Bit 0)                                       */
#define GPIO_IOM1IRQ_IOM1IRQ_Msk          (0x3fUL)                  /*!< IOM1IRQ (Bitfield-Mask: 0x3f)                         */
/* ========================================================  IOM2IRQ  ======================================================== */
#define GPIO_IOM2IRQ_IOM2IRQ_Pos          (0UL)                     /*!< IOM2IRQ (Bit 0)                                       */
#define GPIO_IOM2IRQ_IOM2IRQ_Msk          (0x3fUL)                  /*!< IOM2IRQ (Bitfield-Mask: 0x3f)                         */
/* ========================================================  IOM3IRQ  ======================================================== */
#define GPIO_IOM3IRQ_IOM3IRQ_Pos          (0UL)                     /*!< IOM3IRQ (Bit 0)                                       */
#define GPIO_IOM3IRQ_IOM3IRQ_Msk          (0x3fUL)                  /*!< IOM3IRQ (Bitfield-Mask: 0x3f)                         */
/* ========================================================  IOM4IRQ  ======================================================== */
#define GPIO_IOM4IRQ_IOM4IRQ_Pos          (0UL)                     /*!< IOM4IRQ (Bit 0)                                       */
#define GPIO_IOM4IRQ_IOM4IRQ_Msk          (0x3fUL)                  /*!< IOM4IRQ (Bitfield-Mask: 0x3f)                         */
/* ========================================================  IOM5IRQ  ======================================================== */
#define GPIO_IOM5IRQ_IOM5IRQ_Pos          (0UL)                     /*!< IOM5IRQ (Bit 0)                                       */
#define GPIO_IOM5IRQ_IOM5IRQ_Msk          (0x3fUL)                  /*!< IOM5IRQ (Bitfield-Mask: 0x3f)                         */
/* =======================================================  LOOPBACK  ======================================================== */
#define GPIO_LOOPBACK_LOOPBACK_Pos        (0UL)                     /*!< LOOPBACK (Bit 0)                                      */
#define GPIO_LOOPBACK_LOOPBACK_Msk        (0x7UL)                   /*!< LOOPBACK (Bitfield-Mask: 0x07)                        */
/* ========================================================  GPIOOBS  ======================================================== */
#define GPIO_GPIOOBS_OBS_DATA_Pos         (0UL)                     /*!< OBS_DATA (Bit 0)                                      */
#define GPIO_GPIOOBS_OBS_DATA_Msk         (0xffffUL)                /*!< OBS_DATA (Bitfield-Mask: 0xffff)                      */
/* ======================================================  ALTPADCFGA  ======================================================= */
#define GPIO_ALTPADCFGA_PAD3_SR_Pos       (28UL)                    /*!< PAD3_SR (Bit 28)                                      */
#define GPIO_ALTPADCFGA_PAD3_SR_Msk       (0x10000000UL)            /*!< PAD3_SR (Bitfield-Mask: 0x01)                         */
#define GPIO_ALTPADCFGA_PAD3_DS1_Pos      (24UL)                    /*!< PAD3_DS1 (Bit 24)                                     */
#define GPIO_ALTPADCFGA_PAD3_DS1_Msk      (0x1000000UL)             /*!< PAD3_DS1 (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGA_PAD2_SR_Pos       (20UL)                    /*!< PAD2_SR (Bit 20)                                      */
#define GPIO_ALTPADCFGA_PAD2_SR_Msk       (0x100000UL)              /*!< PAD2_SR (Bitfield-Mask: 0x01)                         */
#define GPIO_ALTPADCFGA_PAD2_DS1_Pos      (16UL)                    /*!< PAD2_DS1 (Bit 16)                                     */
#define GPIO_ALTPADCFGA_PAD2_DS1_Msk      (0x10000UL)               /*!< PAD2_DS1 (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGA_PAD1_SR_Pos       (12UL)                    /*!< PAD1_SR (Bit 12)                                      */
#define GPIO_ALTPADCFGA_PAD1_SR_Msk       (0x1000UL)                /*!< PAD1_SR (Bitfield-Mask: 0x01)                         */
#define GPIO_ALTPADCFGA_PAD1_DS1_Pos      (8UL)                     /*!< PAD1_DS1 (Bit 8)                                      */
#define GPIO_ALTPADCFGA_PAD1_DS1_Msk      (0x100UL)                 /*!< PAD1_DS1 (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGA_PAD0_SR_Pos       (4UL)                     /*!< PAD0_SR (Bit 4)                                       */
#define GPIO_ALTPADCFGA_PAD0_SR_Msk       (0x10UL)                  /*!< PAD0_SR (Bitfield-Mask: 0x01)                         */
#define GPIO_ALTPADCFGA_PAD0_DS1_Pos      (0UL)                     /*!< PAD0_DS1 (Bit 0)                                      */
#define GPIO_ALTPADCFGA_PAD0_DS1_Msk      (0x1UL)                   /*!< PAD0_DS1 (Bitfield-Mask: 0x01)                        */
/* ======================================================  ALTPADCFGB  ======================================================= */
#define GPIO_ALTPADCFGB_PAD7_SR_Pos       (28UL)                    /*!< PAD7_SR (Bit 28)                                      */
#define GPIO_ALTPADCFGB_PAD7_SR_Msk       (0x10000000UL)            /*!< PAD7_SR (Bitfield-Mask: 0x01)                         */
#define GPIO_ALTPADCFGB_PAD7_DS1_Pos      (24UL)                    /*!< PAD7_DS1 (Bit 24)                                     */
#define GPIO_ALTPADCFGB_PAD7_DS1_Msk      (0x1000000UL)             /*!< PAD7_DS1 (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGB_PAD6_SR_Pos       (20UL)                    /*!< PAD6_SR (Bit 20)                                      */
#define GPIO_ALTPADCFGB_PAD6_SR_Msk       (0x100000UL)              /*!< PAD6_SR (Bitfield-Mask: 0x01)                         */
#define GPIO_ALTPADCFGB_PAD6_DS1_Pos      (16UL)                    /*!< PAD6_DS1 (Bit 16)                                     */
#define GPIO_ALTPADCFGB_PAD6_DS1_Msk      (0x10000UL)               /*!< PAD6_DS1 (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGB_PAD5_SR_Pos       (12UL)                    /*!< PAD5_SR (Bit 12)                                      */
#define GPIO_ALTPADCFGB_PAD5_SR_Msk       (0x1000UL)                /*!< PAD5_SR (Bitfield-Mask: 0x01)                         */
#define GPIO_ALTPADCFGB_PAD5_DS1_Pos      (8UL)                     /*!< PAD5_DS1 (Bit 8)                                      */
#define GPIO_ALTPADCFGB_PAD5_DS1_Msk      (0x100UL)                 /*!< PAD5_DS1 (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGB_PAD4_SR_Pos       (4UL)                     /*!< PAD4_SR (Bit 4)                                       */
#define GPIO_ALTPADCFGB_PAD4_SR_Msk       (0x10UL)                  /*!< PAD4_SR (Bitfield-Mask: 0x01)                         */
#define GPIO_ALTPADCFGB_PAD4_DS1_Pos      (0UL)                     /*!< PAD4_DS1 (Bit 0)                                      */
#define GPIO_ALTPADCFGB_PAD4_DS1_Msk      (0x1UL)                   /*!< PAD4_DS1 (Bitfield-Mask: 0x01)                        */
/* ======================================================  ALTPADCFGC  ======================================================= */
#define GPIO_ALTPADCFGC_PAD11_SR_Pos      (28UL)                    /*!< PAD11_SR (Bit 28)                                     */
#define GPIO_ALTPADCFGC_PAD11_SR_Msk      (0x10000000UL)            /*!< PAD11_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGC_PAD11_DS1_Pos     (24UL)                    /*!< PAD11_DS1 (Bit 24)                                    */
#define GPIO_ALTPADCFGC_PAD11_DS1_Msk     (0x1000000UL)             /*!< PAD11_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGC_PAD10_SR_Pos      (20UL)                    /*!< PAD10_SR (Bit 20)                                     */
#define GPIO_ALTPADCFGC_PAD10_SR_Msk      (0x100000UL)              /*!< PAD10_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGC_PAD10_DS1_Pos     (16UL)                    /*!< PAD10_DS1 (Bit 16)                                    */
#define GPIO_ALTPADCFGC_PAD10_DS1_Msk     (0x10000UL)               /*!< PAD10_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGC_PAD9_SR_Pos       (12UL)                    /*!< PAD9_SR (Bit 12)                                      */
#define GPIO_ALTPADCFGC_PAD9_SR_Msk       (0x1000UL)                /*!< PAD9_SR (Bitfield-Mask: 0x01)                         */
#define GPIO_ALTPADCFGC_PAD9_DS1_Pos      (8UL)                     /*!< PAD9_DS1 (Bit 8)                                      */
#define GPIO_ALTPADCFGC_PAD9_DS1_Msk      (0x100UL)                 /*!< PAD9_DS1 (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGC_PAD8_SR_Pos       (4UL)                     /*!< PAD8_SR (Bit 4)                                       */
#define GPIO_ALTPADCFGC_PAD8_SR_Msk       (0x10UL)                  /*!< PAD8_SR (Bitfield-Mask: 0x01)                         */
#define GPIO_ALTPADCFGC_PAD8_DS1_Pos      (0UL)                     /*!< PAD8_DS1 (Bit 0)                                      */
#define GPIO_ALTPADCFGC_PAD8_DS1_Msk      (0x1UL)                   /*!< PAD8_DS1 (Bitfield-Mask: 0x01)                        */
/* ======================================================  ALTPADCFGD  ======================================================= */
#define GPIO_ALTPADCFGD_PAD15_SR_Pos      (28UL)                    /*!< PAD15_SR (Bit 28)                                     */
#define GPIO_ALTPADCFGD_PAD15_SR_Msk      (0x10000000UL)            /*!< PAD15_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGD_PAD15_DS1_Pos     (24UL)                    /*!< PAD15_DS1 (Bit 24)                                    */
#define GPIO_ALTPADCFGD_PAD15_DS1_Msk     (0x1000000UL)             /*!< PAD15_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGD_PAD14_SR_Pos      (20UL)                    /*!< PAD14_SR (Bit 20)                                     */
#define GPIO_ALTPADCFGD_PAD14_SR_Msk      (0x100000UL)              /*!< PAD14_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGD_PAD14_DS1_Pos     (16UL)                    /*!< PAD14_DS1 (Bit 16)                                    */
#define GPIO_ALTPADCFGD_PAD14_DS1_Msk     (0x10000UL)               /*!< PAD14_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGD_PAD13_SR_Pos      (12UL)                    /*!< PAD13_SR (Bit 12)                                     */
#define GPIO_ALTPADCFGD_PAD13_SR_Msk      (0x1000UL)                /*!< PAD13_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGD_PAD13_DS1_Pos     (8UL)                     /*!< PAD13_DS1 (Bit 8)                                     */
#define GPIO_ALTPADCFGD_PAD13_DS1_Msk     (0x100UL)                 /*!< PAD13_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGD_PAD12_SR_Pos      (4UL)                     /*!< PAD12_SR (Bit 4)                                      */
#define GPIO_ALTPADCFGD_PAD12_SR_Msk      (0x10UL)                  /*!< PAD12_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGD_PAD12_DS1_Pos     (0UL)                     /*!< PAD12_DS1 (Bit 0)                                     */
#define GPIO_ALTPADCFGD_PAD12_DS1_Msk     (0x1UL)                   /*!< PAD12_DS1 (Bitfield-Mask: 0x01)                       */
/* ======================================================  ALTPADCFGE  ======================================================= */
#define GPIO_ALTPADCFGE_PAD19_SR_Pos      (28UL)                    /*!< PAD19_SR (Bit 28)                                     */
#define GPIO_ALTPADCFGE_PAD19_SR_Msk      (0x10000000UL)            /*!< PAD19_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGE_PAD19_DS1_Pos     (24UL)                    /*!< PAD19_DS1 (Bit 24)                                    */
#define GPIO_ALTPADCFGE_PAD19_DS1_Msk     (0x1000000UL)             /*!< PAD19_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGE_PAD18_SR_Pos      (20UL)                    /*!< PAD18_SR (Bit 20)                                     */
#define GPIO_ALTPADCFGE_PAD18_SR_Msk      (0x100000UL)              /*!< PAD18_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGE_PAD18_DS1_Pos     (16UL)                    /*!< PAD18_DS1 (Bit 16)                                    */
#define GPIO_ALTPADCFGE_PAD18_DS1_Msk     (0x10000UL)               /*!< PAD18_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGE_PAD17_SR_Pos      (12UL)                    /*!< PAD17_SR (Bit 12)                                     */
#define GPIO_ALTPADCFGE_PAD17_SR_Msk      (0x1000UL)                /*!< PAD17_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGE_PAD17_DS1_Pos     (8UL)                     /*!< PAD17_DS1 (Bit 8)                                     */
#define GPIO_ALTPADCFGE_PAD17_DS1_Msk     (0x100UL)                 /*!< PAD17_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGE_PAD16_SR_Pos      (4UL)                     /*!< PAD16_SR (Bit 4)                                      */
#define GPIO_ALTPADCFGE_PAD16_SR_Msk      (0x10UL)                  /*!< PAD16_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGE_PAD16_DS1_Pos     (0UL)                     /*!< PAD16_DS1 (Bit 0)                                     */
#define GPIO_ALTPADCFGE_PAD16_DS1_Msk     (0x1UL)                   /*!< PAD16_DS1 (Bitfield-Mask: 0x01)                       */
/* ======================================================  ALTPADCFGF  ======================================================= */
#define GPIO_ALTPADCFGF_PAD23_SR_Pos      (28UL)                    /*!< PAD23_SR (Bit 28)                                     */
#define GPIO_ALTPADCFGF_PAD23_SR_Msk      (0x10000000UL)            /*!< PAD23_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGF_PAD23_DS1_Pos     (24UL)                    /*!< PAD23_DS1 (Bit 24)                                    */
#define GPIO_ALTPADCFGF_PAD23_DS1_Msk     (0x1000000UL)             /*!< PAD23_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGF_PAD22_SR_Pos      (20UL)                    /*!< PAD22_SR (Bit 20)                                     */
#define GPIO_ALTPADCFGF_PAD22_SR_Msk      (0x100000UL)              /*!< PAD22_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGF_PAD22_DS1_Pos     (16UL)                    /*!< PAD22_DS1 (Bit 16)                                    */
#define GPIO_ALTPADCFGF_PAD22_DS1_Msk     (0x10000UL)               /*!< PAD22_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGF_PAD21_SR_Pos      (12UL)                    /*!< PAD21_SR (Bit 12)                                     */
#define GPIO_ALTPADCFGF_PAD21_SR_Msk      (0x1000UL)                /*!< PAD21_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGF_PAD21_DS1_Pos     (8UL)                     /*!< PAD21_DS1 (Bit 8)                                     */
#define GPIO_ALTPADCFGF_PAD21_DS1_Msk     (0x100UL)                 /*!< PAD21_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGF_PAD20_SR_Pos      (4UL)                     /*!< PAD20_SR (Bit 4)                                      */
#define GPIO_ALTPADCFGF_PAD20_SR_Msk      (0x10UL)                  /*!< PAD20_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGF_PAD20_DS1_Pos     (0UL)                     /*!< PAD20_DS1 (Bit 0)                                     */
#define GPIO_ALTPADCFGF_PAD20_DS1_Msk     (0x1UL)                   /*!< PAD20_DS1 (Bitfield-Mask: 0x01)                       */
/* ======================================================  ALTPADCFGG  ======================================================= */
#define GPIO_ALTPADCFGG_PAD27_SR_Pos      (28UL)                    /*!< PAD27_SR (Bit 28)                                     */
#define GPIO_ALTPADCFGG_PAD27_SR_Msk      (0x10000000UL)            /*!< PAD27_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGG_PAD27_DS1_Pos     (24UL)                    /*!< PAD27_DS1 (Bit 24)                                    */
#define GPIO_ALTPADCFGG_PAD27_DS1_Msk     (0x1000000UL)             /*!< PAD27_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGG_PAD26_SR_Pos      (20UL)                    /*!< PAD26_SR (Bit 20)                                     */
#define GPIO_ALTPADCFGG_PAD26_SR_Msk      (0x100000UL)              /*!< PAD26_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGG_PAD26_DS1_Pos     (16UL)                    /*!< PAD26_DS1 (Bit 16)                                    */
#define GPIO_ALTPADCFGG_PAD26_DS1_Msk     (0x10000UL)               /*!< PAD26_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGG_PAD25_SR_Pos      (12UL)                    /*!< PAD25_SR (Bit 12)                                     */
#define GPIO_ALTPADCFGG_PAD25_SR_Msk      (0x1000UL)                /*!< PAD25_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGG_PAD25_DS1_Pos     (8UL)                     /*!< PAD25_DS1 (Bit 8)                                     */
#define GPIO_ALTPADCFGG_PAD25_DS1_Msk     (0x100UL)                 /*!< PAD25_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGG_PAD24_SR_Pos      (4UL)                     /*!< PAD24_SR (Bit 4)                                      */
#define GPIO_ALTPADCFGG_PAD24_SR_Msk      (0x10UL)                  /*!< PAD24_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGG_PAD24_DS1_Pos     (0UL)                     /*!< PAD24_DS1 (Bit 0)                                     */
#define GPIO_ALTPADCFGG_PAD24_DS1_Msk     (0x1UL)                   /*!< PAD24_DS1 (Bitfield-Mask: 0x01)                       */
/* ======================================================  ALTPADCFGH  ======================================================= */
#define GPIO_ALTPADCFGH_PAD31_SR_Pos      (28UL)                    /*!< PAD31_SR (Bit 28)                                     */
#define GPIO_ALTPADCFGH_PAD31_SR_Msk      (0x10000000UL)            /*!< PAD31_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGH_PAD31_DS1_Pos     (24UL)                    /*!< PAD31_DS1 (Bit 24)                                    */
#define GPIO_ALTPADCFGH_PAD31_DS1_Msk     (0x1000000UL)             /*!< PAD31_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGH_PAD30_SR_Pos      (20UL)                    /*!< PAD30_SR (Bit 20)                                     */
#define GPIO_ALTPADCFGH_PAD30_SR_Msk      (0x100000UL)              /*!< PAD30_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGH_PAD30_DS1_Pos     (16UL)                    /*!< PAD30_DS1 (Bit 16)                                    */
#define GPIO_ALTPADCFGH_PAD30_DS1_Msk     (0x10000UL)               /*!< PAD30_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGH_PAD29_SR_Pos      (12UL)                    /*!< PAD29_SR (Bit 12)                                     */
#define GPIO_ALTPADCFGH_PAD29_SR_Msk      (0x1000UL)                /*!< PAD29_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGH_PAD29_DS1_Pos     (8UL)                     /*!< PAD29_DS1 (Bit 8)                                     */
#define GPIO_ALTPADCFGH_PAD29_DS1_Msk     (0x100UL)                 /*!< PAD29_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGH_PAD28_SR_Pos      (4UL)                     /*!< PAD28_SR (Bit 4)                                      */
#define GPIO_ALTPADCFGH_PAD28_SR_Msk      (0x10UL)                  /*!< PAD28_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGH_PAD28_DS1_Pos     (0UL)                     /*!< PAD28_DS1 (Bit 0)                                     */
#define GPIO_ALTPADCFGH_PAD28_DS1_Msk     (0x1UL)                   /*!< PAD28_DS1 (Bitfield-Mask: 0x01)                       */
/* ======================================================  ALTPADCFGI  ======================================================= */
#define GPIO_ALTPADCFGI_PAD35_SR_Pos      (28UL)                    /*!< PAD35_SR (Bit 28)                                     */
#define GPIO_ALTPADCFGI_PAD35_SR_Msk      (0x10000000UL)            /*!< PAD35_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGI_PAD35_DS1_Pos     (24UL)                    /*!< PAD35_DS1 (Bit 24)                                    */
#define GPIO_ALTPADCFGI_PAD35_DS1_Msk     (0x1000000UL)             /*!< PAD35_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGI_PAD34_SR_Pos      (20UL)                    /*!< PAD34_SR (Bit 20)                                     */
#define GPIO_ALTPADCFGI_PAD34_SR_Msk      (0x100000UL)              /*!< PAD34_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGI_PAD34_DS1_Pos     (16UL)                    /*!< PAD34_DS1 (Bit 16)                                    */
#define GPIO_ALTPADCFGI_PAD34_DS1_Msk     (0x10000UL)               /*!< PAD34_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGI_PAD33_SR_Pos      (12UL)                    /*!< PAD33_SR (Bit 12)                                     */
#define GPIO_ALTPADCFGI_PAD33_SR_Msk      (0x1000UL)                /*!< PAD33_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGI_PAD33_DS1_Pos     (8UL)                     /*!< PAD33_DS1 (Bit 8)                                     */
#define GPIO_ALTPADCFGI_PAD33_DS1_Msk     (0x100UL)                 /*!< PAD33_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGI_PAD32_SR_Pos      (4UL)                     /*!< PAD32_SR (Bit 4)                                      */
#define GPIO_ALTPADCFGI_PAD32_SR_Msk      (0x10UL)                  /*!< PAD32_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGI_PAD32_DS1_Pos     (0UL)                     /*!< PAD32_DS1 (Bit 0)                                     */
#define GPIO_ALTPADCFGI_PAD32_DS1_Msk     (0x1UL)                   /*!< PAD32_DS1 (Bitfield-Mask: 0x01)                       */
/* ======================================================  ALTPADCFGJ  ======================================================= */
#define GPIO_ALTPADCFGJ_PAD39_SR_Pos      (28UL)                    /*!< PAD39_SR (Bit 28)                                     */
#define GPIO_ALTPADCFGJ_PAD39_SR_Msk      (0x10000000UL)            /*!< PAD39_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGJ_PAD39_DS1_Pos     (24UL)                    /*!< PAD39_DS1 (Bit 24)                                    */
#define GPIO_ALTPADCFGJ_PAD39_DS1_Msk     (0x1000000UL)             /*!< PAD39_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGJ_PAD38_SR_Pos      (20UL)                    /*!< PAD38_SR (Bit 20)                                     */
#define GPIO_ALTPADCFGJ_PAD38_SR_Msk      (0x100000UL)              /*!< PAD38_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGJ_PAD38_DS1_Pos     (16UL)                    /*!< PAD38_DS1 (Bit 16)                                    */
#define GPIO_ALTPADCFGJ_PAD38_DS1_Msk     (0x10000UL)               /*!< PAD38_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGJ_PAD37_SR_Pos      (12UL)                    /*!< PAD37_SR (Bit 12)                                     */
#define GPIO_ALTPADCFGJ_PAD37_SR_Msk      (0x1000UL)                /*!< PAD37_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGJ_PAD37_DS1_Pos     (8UL)                     /*!< PAD37_DS1 (Bit 8)                                     */
#define GPIO_ALTPADCFGJ_PAD37_DS1_Msk     (0x100UL)                 /*!< PAD37_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGJ_PAD36_SR_Pos      (4UL)                     /*!< PAD36_SR (Bit 4)                                      */
#define GPIO_ALTPADCFGJ_PAD36_SR_Msk      (0x10UL)                  /*!< PAD36_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGJ_PAD36_DS1_Pos     (0UL)                     /*!< PAD36_DS1 (Bit 0)                                     */
#define GPIO_ALTPADCFGJ_PAD36_DS1_Msk     (0x1UL)                   /*!< PAD36_DS1 (Bitfield-Mask: 0x01)                       */
/* ======================================================  ALTPADCFGK  ======================================================= */
#define GPIO_ALTPADCFGK_PAD43_SR_Pos      (28UL)                    /*!< PAD43_SR (Bit 28)                                     */
#define GPIO_ALTPADCFGK_PAD43_SR_Msk      (0x10000000UL)            /*!< PAD43_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGK_PAD43_DS1_Pos     (24UL)                    /*!< PAD43_DS1 (Bit 24)                                    */
#define GPIO_ALTPADCFGK_PAD43_DS1_Msk     (0x1000000UL)             /*!< PAD43_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGK_PAD42_SR_Pos      (20UL)                    /*!< PAD42_SR (Bit 20)                                     */
#define GPIO_ALTPADCFGK_PAD42_SR_Msk      (0x100000UL)              /*!< PAD42_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGK_PAD42_DS1_Pos     (16UL)                    /*!< PAD42_DS1 (Bit 16)                                    */
#define GPIO_ALTPADCFGK_PAD42_DS1_Msk     (0x10000UL)               /*!< PAD42_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGK_PAD41_SR_Pos      (12UL)                    /*!< PAD41_SR (Bit 12)                                     */
#define GPIO_ALTPADCFGK_PAD41_SR_Msk      (0x1000UL)                /*!< PAD41_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGK_PAD41_DS1_Pos     (8UL)                     /*!< PAD41_DS1 (Bit 8)                                     */
#define GPIO_ALTPADCFGK_PAD41_DS1_Msk     (0x100UL)                 /*!< PAD41_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGK_PAD40_SR_Pos      (4UL)                     /*!< PAD40_SR (Bit 4)                                      */
#define GPIO_ALTPADCFGK_PAD40_SR_Msk      (0x10UL)                  /*!< PAD40_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGK_PAD40_DS1_Pos     (0UL)                     /*!< PAD40_DS1 (Bit 0)                                     */
#define GPIO_ALTPADCFGK_PAD40_DS1_Msk     (0x1UL)                   /*!< PAD40_DS1 (Bitfield-Mask: 0x01)                       */
/* ======================================================  ALTPADCFGL  ======================================================= */
#define GPIO_ALTPADCFGL_PAD47_SR_Pos      (28UL)                    /*!< PAD47_SR (Bit 28)                                     */
#define GPIO_ALTPADCFGL_PAD47_SR_Msk      (0x10000000UL)            /*!< PAD47_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGL_PAD47_DS1_Pos     (24UL)                    /*!< PAD47_DS1 (Bit 24)                                    */
#define GPIO_ALTPADCFGL_PAD47_DS1_Msk     (0x1000000UL)             /*!< PAD47_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGL_PAD46_SR_Pos      (20UL)                    /*!< PAD46_SR (Bit 20)                                     */
#define GPIO_ALTPADCFGL_PAD46_SR_Msk      (0x100000UL)              /*!< PAD46_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGL_PAD46_DS1_Pos     (16UL)                    /*!< PAD46_DS1 (Bit 16)                                    */
#define GPIO_ALTPADCFGL_PAD46_DS1_Msk     (0x10000UL)               /*!< PAD46_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGL_PAD45_SR_Pos      (12UL)                    /*!< PAD45_SR (Bit 12)                                     */
#define GPIO_ALTPADCFGL_PAD45_SR_Msk      (0x1000UL)                /*!< PAD45_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGL_PAD45_DS1_Pos     (8UL)                     /*!< PAD45_DS1 (Bit 8)                                     */
#define GPIO_ALTPADCFGL_PAD45_DS1_Msk     (0x100UL)                 /*!< PAD45_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGL_PAD44_SR_Pos      (4UL)                     /*!< PAD44_SR (Bit 4)                                      */
#define GPIO_ALTPADCFGL_PAD44_SR_Msk      (0x10UL)                  /*!< PAD44_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGL_PAD44_DS1_Pos     (0UL)                     /*!< PAD44_DS1 (Bit 0)                                     */
#define GPIO_ALTPADCFGL_PAD44_DS1_Msk     (0x1UL)                   /*!< PAD44_DS1 (Bitfield-Mask: 0x01)                       */
/* ======================================================  ALTPADCFGM  ======================================================= */
#define GPIO_ALTPADCFGM_PAD49_SR_Pos      (12UL)                    /*!< PAD49_SR (Bit 12)                                     */
#define GPIO_ALTPADCFGM_PAD49_SR_Msk      (0x1000UL)                /*!< PAD49_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGM_PAD49_DS1_Pos     (8UL)                     /*!< PAD49_DS1 (Bit 8)                                     */
#define GPIO_ALTPADCFGM_PAD49_DS1_Msk     (0x100UL)                 /*!< PAD49_DS1 (Bitfield-Mask: 0x01)                       */
#define GPIO_ALTPADCFGM_PAD48_SR_Pos      (4UL)                     /*!< PAD48_SR (Bit 4)                                      */
#define GPIO_ALTPADCFGM_PAD48_SR_Msk      (0x10UL)                  /*!< PAD48_SR (Bitfield-Mask: 0x01)                        */
#define GPIO_ALTPADCFGM_PAD48_DS1_Pos     (0UL)                     /*!< PAD48_DS1 (Bit 0)                                     */
#define GPIO_ALTPADCFGM_PAD48_DS1_Msk     (0x1UL)                   /*!< PAD48_DS1 (Bitfield-Mask: 0x01)                       */
/* ========================================================  INT0EN  ========================================================= */
#define GPIO_INT0EN_GPIO31_Pos            (31UL)                    /*!< GPIO31 (Bit 31)                                       */
#define GPIO_INT0EN_GPIO31_Msk            (0x80000000UL)            /*!< GPIO31 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO30_Pos            (30UL)                    /*!< GPIO30 (Bit 30)                                       */
#define GPIO_INT0EN_GPIO30_Msk            (0x40000000UL)            /*!< GPIO30 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO29_Pos            (29UL)                    /*!< GPIO29 (Bit 29)                                       */
#define GPIO_INT0EN_GPIO29_Msk            (0x20000000UL)            /*!< GPIO29 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO28_Pos            (28UL)                    /*!< GPIO28 (Bit 28)                                       */
#define GPIO_INT0EN_GPIO28_Msk            (0x10000000UL)            /*!< GPIO28 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO27_Pos            (27UL)                    /*!< GPIO27 (Bit 27)                                       */
#define GPIO_INT0EN_GPIO27_Msk            (0x8000000UL)             /*!< GPIO27 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO26_Pos            (26UL)                    /*!< GPIO26 (Bit 26)                                       */
#define GPIO_INT0EN_GPIO26_Msk            (0x4000000UL)             /*!< GPIO26 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO25_Pos            (25UL)                    /*!< GPIO25 (Bit 25)                                       */
#define GPIO_INT0EN_GPIO25_Msk            (0x2000000UL)             /*!< GPIO25 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO24_Pos            (24UL)                    /*!< GPIO24 (Bit 24)                                       */
#define GPIO_INT0EN_GPIO24_Msk            (0x1000000UL)             /*!< GPIO24 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO23_Pos            (23UL)                    /*!< GPIO23 (Bit 23)                                       */
#define GPIO_INT0EN_GPIO23_Msk            (0x800000UL)              /*!< GPIO23 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO22_Pos            (22UL)                    /*!< GPIO22 (Bit 22)                                       */
#define GPIO_INT0EN_GPIO22_Msk            (0x400000UL)              /*!< GPIO22 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO21_Pos            (21UL)                    /*!< GPIO21 (Bit 21)                                       */
#define GPIO_INT0EN_GPIO21_Msk            (0x200000UL)              /*!< GPIO21 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO20_Pos            (20UL)                    /*!< GPIO20 (Bit 20)                                       */
#define GPIO_INT0EN_GPIO20_Msk            (0x100000UL)              /*!< GPIO20 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO19_Pos            (19UL)                    /*!< GPIO19 (Bit 19)                                       */
#define GPIO_INT0EN_GPIO19_Msk            (0x80000UL)               /*!< GPIO19 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO18_Pos            (18UL)                    /*!< GPIO18 (Bit 18)                                       */
#define GPIO_INT0EN_GPIO18_Msk            (0x40000UL)               /*!< GPIO18 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO17_Pos            (17UL)                    /*!< GPIO17 (Bit 17)                                       */
#define GPIO_INT0EN_GPIO17_Msk            (0x20000UL)               /*!< GPIO17 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO16_Pos            (16UL)                    /*!< GPIO16 (Bit 16)                                       */
#define GPIO_INT0EN_GPIO16_Msk            (0x10000UL)               /*!< GPIO16 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO15_Pos            (15UL)                    /*!< GPIO15 (Bit 15)                                       */
#define GPIO_INT0EN_GPIO15_Msk            (0x8000UL)                /*!< GPIO15 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO14_Pos            (14UL)                    /*!< GPIO14 (Bit 14)                                       */
#define GPIO_INT0EN_GPIO14_Msk            (0x4000UL)                /*!< GPIO14 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO13_Pos            (13UL)                    /*!< GPIO13 (Bit 13)                                       */
#define GPIO_INT0EN_GPIO13_Msk            (0x2000UL)                /*!< GPIO13 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO12_Pos            (12UL)                    /*!< GPIO12 (Bit 12)                                       */
#define GPIO_INT0EN_GPIO12_Msk            (0x1000UL)                /*!< GPIO12 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO11_Pos            (11UL)                    /*!< GPIO11 (Bit 11)                                       */
#define GPIO_INT0EN_GPIO11_Msk            (0x800UL)                 /*!< GPIO11 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO10_Pos            (10UL)                    /*!< GPIO10 (Bit 10)                                       */
#define GPIO_INT0EN_GPIO10_Msk            (0x400UL)                 /*!< GPIO10 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0EN_GPIO9_Pos             (9UL)                     /*!< GPIO9 (Bit 9)                                         */
#define GPIO_INT0EN_GPIO9_Msk             (0x200UL)                 /*!< GPIO9 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0EN_GPIO8_Pos             (8UL)                     /*!< GPIO8 (Bit 8)                                         */
#define GPIO_INT0EN_GPIO8_Msk             (0x100UL)                 /*!< GPIO8 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0EN_GPIO7_Pos             (7UL)                     /*!< GPIO7 (Bit 7)                                         */
#define GPIO_INT0EN_GPIO7_Msk             (0x80UL)                  /*!< GPIO7 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0EN_GPIO6_Pos             (6UL)                     /*!< GPIO6 (Bit 6)                                         */
#define GPIO_INT0EN_GPIO6_Msk             (0x40UL)                  /*!< GPIO6 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0EN_GPIO5_Pos             (5UL)                     /*!< GPIO5 (Bit 5)                                         */
#define GPIO_INT0EN_GPIO5_Msk             (0x20UL)                  /*!< GPIO5 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0EN_GPIO4_Pos             (4UL)                     /*!< GPIO4 (Bit 4)                                         */
#define GPIO_INT0EN_GPIO4_Msk             (0x10UL)                  /*!< GPIO4 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0EN_GPIO3_Pos             (3UL)                     /*!< GPIO3 (Bit 3)                                         */
#define GPIO_INT0EN_GPIO3_Msk             (0x8UL)                   /*!< GPIO3 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0EN_GPIO2_Pos             (2UL)                     /*!< GPIO2 (Bit 2)                                         */
#define GPIO_INT0EN_GPIO2_Msk             (0x4UL)                   /*!< GPIO2 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0EN_GPIO1_Pos             (1UL)                     /*!< GPIO1 (Bit 1)                                         */
#define GPIO_INT0EN_GPIO1_Msk             (0x2UL)                   /*!< GPIO1 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0EN_GPIO0_Pos             (0UL)                     /*!< GPIO0 (Bit 0)                                         */
#define GPIO_INT0EN_GPIO0_Msk             (0x1UL)                   /*!< GPIO0 (Bitfield-Mask: 0x01)                           */
/* =======================================================  INT0STAT  ======================================================== */
#define GPIO_INT0STAT_GPIO31_Pos          (31UL)                    /*!< GPIO31 (Bit 31)                                       */
#define GPIO_INT0STAT_GPIO31_Msk          (0x80000000UL)            /*!< GPIO31 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO30_Pos          (30UL)                    /*!< GPIO30 (Bit 30)                                       */
#define GPIO_INT0STAT_GPIO30_Msk          (0x40000000UL)            /*!< GPIO30 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO29_Pos          (29UL)                    /*!< GPIO29 (Bit 29)                                       */
#define GPIO_INT0STAT_GPIO29_Msk          (0x20000000UL)            /*!< GPIO29 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO28_Pos          (28UL)                    /*!< GPIO28 (Bit 28)                                       */
#define GPIO_INT0STAT_GPIO28_Msk          (0x10000000UL)            /*!< GPIO28 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO27_Pos          (27UL)                    /*!< GPIO27 (Bit 27)                                       */
#define GPIO_INT0STAT_GPIO27_Msk          (0x8000000UL)             /*!< GPIO27 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO26_Pos          (26UL)                    /*!< GPIO26 (Bit 26)                                       */
#define GPIO_INT0STAT_GPIO26_Msk          (0x4000000UL)             /*!< GPIO26 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO25_Pos          (25UL)                    /*!< GPIO25 (Bit 25)                                       */
#define GPIO_INT0STAT_GPIO25_Msk          (0x2000000UL)             /*!< GPIO25 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO24_Pos          (24UL)                    /*!< GPIO24 (Bit 24)                                       */
#define GPIO_INT0STAT_GPIO24_Msk          (0x1000000UL)             /*!< GPIO24 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO23_Pos          (23UL)                    /*!< GPIO23 (Bit 23)                                       */
#define GPIO_INT0STAT_GPIO23_Msk          (0x800000UL)              /*!< GPIO23 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO22_Pos          (22UL)                    /*!< GPIO22 (Bit 22)                                       */
#define GPIO_INT0STAT_GPIO22_Msk          (0x400000UL)              /*!< GPIO22 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO21_Pos          (21UL)                    /*!< GPIO21 (Bit 21)                                       */
#define GPIO_INT0STAT_GPIO21_Msk          (0x200000UL)              /*!< GPIO21 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO20_Pos          (20UL)                    /*!< GPIO20 (Bit 20)                                       */
#define GPIO_INT0STAT_GPIO20_Msk          (0x100000UL)              /*!< GPIO20 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO19_Pos          (19UL)                    /*!< GPIO19 (Bit 19)                                       */
#define GPIO_INT0STAT_GPIO19_Msk          (0x80000UL)               /*!< GPIO19 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO18_Pos          (18UL)                    /*!< GPIO18 (Bit 18)                                       */
#define GPIO_INT0STAT_GPIO18_Msk          (0x40000UL)               /*!< GPIO18 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO17_Pos          (17UL)                    /*!< GPIO17 (Bit 17)                                       */
#define GPIO_INT0STAT_GPIO17_Msk          (0x20000UL)               /*!< GPIO17 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO16_Pos          (16UL)                    /*!< GPIO16 (Bit 16)                                       */
#define GPIO_INT0STAT_GPIO16_Msk          (0x10000UL)               /*!< GPIO16 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO15_Pos          (15UL)                    /*!< GPIO15 (Bit 15)                                       */
#define GPIO_INT0STAT_GPIO15_Msk          (0x8000UL)                /*!< GPIO15 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO14_Pos          (14UL)                    /*!< GPIO14 (Bit 14)                                       */
#define GPIO_INT0STAT_GPIO14_Msk          (0x4000UL)                /*!< GPIO14 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO13_Pos          (13UL)                    /*!< GPIO13 (Bit 13)                                       */
#define GPIO_INT0STAT_GPIO13_Msk          (0x2000UL)                /*!< GPIO13 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO12_Pos          (12UL)                    /*!< GPIO12 (Bit 12)                                       */
#define GPIO_INT0STAT_GPIO12_Msk          (0x1000UL)                /*!< GPIO12 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO11_Pos          (11UL)                    /*!< GPIO11 (Bit 11)                                       */
#define GPIO_INT0STAT_GPIO11_Msk          (0x800UL)                 /*!< GPIO11 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO10_Pos          (10UL)                    /*!< GPIO10 (Bit 10)                                       */
#define GPIO_INT0STAT_GPIO10_Msk          (0x400UL)                 /*!< GPIO10 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0STAT_GPIO9_Pos           (9UL)                     /*!< GPIO9 (Bit 9)                                         */
#define GPIO_INT0STAT_GPIO9_Msk           (0x200UL)                 /*!< GPIO9 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0STAT_GPIO8_Pos           (8UL)                     /*!< GPIO8 (Bit 8)                                         */
#define GPIO_INT0STAT_GPIO8_Msk           (0x100UL)                 /*!< GPIO8 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0STAT_GPIO7_Pos           (7UL)                     /*!< GPIO7 (Bit 7)                                         */
#define GPIO_INT0STAT_GPIO7_Msk           (0x80UL)                  /*!< GPIO7 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0STAT_GPIO6_Pos           (6UL)                     /*!< GPIO6 (Bit 6)                                         */
#define GPIO_INT0STAT_GPIO6_Msk           (0x40UL)                  /*!< GPIO6 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0STAT_GPIO5_Pos           (5UL)                     /*!< GPIO5 (Bit 5)                                         */
#define GPIO_INT0STAT_GPIO5_Msk           (0x20UL)                  /*!< GPIO5 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0STAT_GPIO4_Pos           (4UL)                     /*!< GPIO4 (Bit 4)                                         */
#define GPIO_INT0STAT_GPIO4_Msk           (0x10UL)                  /*!< GPIO4 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0STAT_GPIO3_Pos           (3UL)                     /*!< GPIO3 (Bit 3)                                         */
#define GPIO_INT0STAT_GPIO3_Msk           (0x8UL)                   /*!< GPIO3 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0STAT_GPIO2_Pos           (2UL)                     /*!< GPIO2 (Bit 2)                                         */
#define GPIO_INT0STAT_GPIO2_Msk           (0x4UL)                   /*!< GPIO2 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0STAT_GPIO1_Pos           (1UL)                     /*!< GPIO1 (Bit 1)                                         */
#define GPIO_INT0STAT_GPIO1_Msk           (0x2UL)                   /*!< GPIO1 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0STAT_GPIO0_Pos           (0UL)                     /*!< GPIO0 (Bit 0)                                         */
#define GPIO_INT0STAT_GPIO0_Msk           (0x1UL)                   /*!< GPIO0 (Bitfield-Mask: 0x01)                           */
/* ========================================================  INT0CLR  ======================================================== */
#define GPIO_INT0CLR_GPIO31_Pos           (31UL)                    /*!< GPIO31 (Bit 31)                                       */
#define GPIO_INT0CLR_GPIO31_Msk           (0x80000000UL)            /*!< GPIO31 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO30_Pos           (30UL)                    /*!< GPIO30 (Bit 30)                                       */
#define GPIO_INT0CLR_GPIO30_Msk           (0x40000000UL)            /*!< GPIO30 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO29_Pos           (29UL)                    /*!< GPIO29 (Bit 29)                                       */
#define GPIO_INT0CLR_GPIO29_Msk           (0x20000000UL)            /*!< GPIO29 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO28_Pos           (28UL)                    /*!< GPIO28 (Bit 28)                                       */
#define GPIO_INT0CLR_GPIO28_Msk           (0x10000000UL)            /*!< GPIO28 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO27_Pos           (27UL)                    /*!< GPIO27 (Bit 27)                                       */
#define GPIO_INT0CLR_GPIO27_Msk           (0x8000000UL)             /*!< GPIO27 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO26_Pos           (26UL)                    /*!< GPIO26 (Bit 26)                                       */
#define GPIO_INT0CLR_GPIO26_Msk           (0x4000000UL)             /*!< GPIO26 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO25_Pos           (25UL)                    /*!< GPIO25 (Bit 25)                                       */
#define GPIO_INT0CLR_GPIO25_Msk           (0x2000000UL)             /*!< GPIO25 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO24_Pos           (24UL)                    /*!< GPIO24 (Bit 24)                                       */
#define GPIO_INT0CLR_GPIO24_Msk           (0x1000000UL)             /*!< GPIO24 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO23_Pos           (23UL)                    /*!< GPIO23 (Bit 23)                                       */
#define GPIO_INT0CLR_GPIO23_Msk           (0x800000UL)              /*!< GPIO23 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO22_Pos           (22UL)                    /*!< GPIO22 (Bit 22)                                       */
#define GPIO_INT0CLR_GPIO22_Msk           (0x400000UL)              /*!< GPIO22 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO21_Pos           (21UL)                    /*!< GPIO21 (Bit 21)                                       */
#define GPIO_INT0CLR_GPIO21_Msk           (0x200000UL)              /*!< GPIO21 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO20_Pos           (20UL)                    /*!< GPIO20 (Bit 20)                                       */
#define GPIO_INT0CLR_GPIO20_Msk           (0x100000UL)              /*!< GPIO20 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO19_Pos           (19UL)                    /*!< GPIO19 (Bit 19)                                       */
#define GPIO_INT0CLR_GPIO19_Msk           (0x80000UL)               /*!< GPIO19 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO18_Pos           (18UL)                    /*!< GPIO18 (Bit 18)                                       */
#define GPIO_INT0CLR_GPIO18_Msk           (0x40000UL)               /*!< GPIO18 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO17_Pos           (17UL)                    /*!< GPIO17 (Bit 17)                                       */
#define GPIO_INT0CLR_GPIO17_Msk           (0x20000UL)               /*!< GPIO17 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO16_Pos           (16UL)                    /*!< GPIO16 (Bit 16)                                       */
#define GPIO_INT0CLR_GPIO16_Msk           (0x10000UL)               /*!< GPIO16 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO15_Pos           (15UL)                    /*!< GPIO15 (Bit 15)                                       */
#define GPIO_INT0CLR_GPIO15_Msk           (0x8000UL)                /*!< GPIO15 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO14_Pos           (14UL)                    /*!< GPIO14 (Bit 14)                                       */
#define GPIO_INT0CLR_GPIO14_Msk           (0x4000UL)                /*!< GPIO14 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO13_Pos           (13UL)                    /*!< GPIO13 (Bit 13)                                       */
#define GPIO_INT0CLR_GPIO13_Msk           (0x2000UL)                /*!< GPIO13 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO12_Pos           (12UL)                    /*!< GPIO12 (Bit 12)                                       */
#define GPIO_INT0CLR_GPIO12_Msk           (0x1000UL)                /*!< GPIO12 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO11_Pos           (11UL)                    /*!< GPIO11 (Bit 11)                                       */
#define GPIO_INT0CLR_GPIO11_Msk           (0x800UL)                 /*!< GPIO11 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO10_Pos           (10UL)                    /*!< GPIO10 (Bit 10)                                       */
#define GPIO_INT0CLR_GPIO10_Msk           (0x400UL)                 /*!< GPIO10 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0CLR_GPIO9_Pos            (9UL)                     /*!< GPIO9 (Bit 9)                                         */
#define GPIO_INT0CLR_GPIO9_Msk            (0x200UL)                 /*!< GPIO9 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0CLR_GPIO8_Pos            (8UL)                     /*!< GPIO8 (Bit 8)                                         */
#define GPIO_INT0CLR_GPIO8_Msk            (0x100UL)                 /*!< GPIO8 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0CLR_GPIO7_Pos            (7UL)                     /*!< GPIO7 (Bit 7)                                         */
#define GPIO_INT0CLR_GPIO7_Msk            (0x80UL)                  /*!< GPIO7 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0CLR_GPIO6_Pos            (6UL)                     /*!< GPIO6 (Bit 6)                                         */
#define GPIO_INT0CLR_GPIO6_Msk            (0x40UL)                  /*!< GPIO6 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0CLR_GPIO5_Pos            (5UL)                     /*!< GPIO5 (Bit 5)                                         */
#define GPIO_INT0CLR_GPIO5_Msk            (0x20UL)                  /*!< GPIO5 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0CLR_GPIO4_Pos            (4UL)                     /*!< GPIO4 (Bit 4)                                         */
#define GPIO_INT0CLR_GPIO4_Msk            (0x10UL)                  /*!< GPIO4 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0CLR_GPIO3_Pos            (3UL)                     /*!< GPIO3 (Bit 3)                                         */
#define GPIO_INT0CLR_GPIO3_Msk            (0x8UL)                   /*!< GPIO3 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0CLR_GPIO2_Pos            (2UL)                     /*!< GPIO2 (Bit 2)                                         */
#define GPIO_INT0CLR_GPIO2_Msk            (0x4UL)                   /*!< GPIO2 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0CLR_GPIO1_Pos            (1UL)                     /*!< GPIO1 (Bit 1)                                         */
#define GPIO_INT0CLR_GPIO1_Msk            (0x2UL)                   /*!< GPIO1 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0CLR_GPIO0_Pos            (0UL)                     /*!< GPIO0 (Bit 0)                                         */
#define GPIO_INT0CLR_GPIO0_Msk            (0x1UL)                   /*!< GPIO0 (Bitfield-Mask: 0x01)                           */
/* ========================================================  INT0SET  ======================================================== */
#define GPIO_INT0SET_GPIO31_Pos           (31UL)                    /*!< GPIO31 (Bit 31)                                       */
#define GPIO_INT0SET_GPIO31_Msk           (0x80000000UL)            /*!< GPIO31 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO30_Pos           (30UL)                    /*!< GPIO30 (Bit 30)                                       */
#define GPIO_INT0SET_GPIO30_Msk           (0x40000000UL)            /*!< GPIO30 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO29_Pos           (29UL)                    /*!< GPIO29 (Bit 29)                                       */
#define GPIO_INT0SET_GPIO29_Msk           (0x20000000UL)            /*!< GPIO29 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO28_Pos           (28UL)                    /*!< GPIO28 (Bit 28)                                       */
#define GPIO_INT0SET_GPIO28_Msk           (0x10000000UL)            /*!< GPIO28 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO27_Pos           (27UL)                    /*!< GPIO27 (Bit 27)                                       */
#define GPIO_INT0SET_GPIO27_Msk           (0x8000000UL)             /*!< GPIO27 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO26_Pos           (26UL)                    /*!< GPIO26 (Bit 26)                                       */
#define GPIO_INT0SET_GPIO26_Msk           (0x4000000UL)             /*!< GPIO26 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO25_Pos           (25UL)                    /*!< GPIO25 (Bit 25)                                       */
#define GPIO_INT0SET_GPIO25_Msk           (0x2000000UL)             /*!< GPIO25 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO24_Pos           (24UL)                    /*!< GPIO24 (Bit 24)                                       */
#define GPIO_INT0SET_GPIO24_Msk           (0x1000000UL)             /*!< GPIO24 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO23_Pos           (23UL)                    /*!< GPIO23 (Bit 23)                                       */
#define GPIO_INT0SET_GPIO23_Msk           (0x800000UL)              /*!< GPIO23 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO22_Pos           (22UL)                    /*!< GPIO22 (Bit 22)                                       */
#define GPIO_INT0SET_GPIO22_Msk           (0x400000UL)              /*!< GPIO22 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO21_Pos           (21UL)                    /*!< GPIO21 (Bit 21)                                       */
#define GPIO_INT0SET_GPIO21_Msk           (0x200000UL)              /*!< GPIO21 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO20_Pos           (20UL)                    /*!< GPIO20 (Bit 20)                                       */
#define GPIO_INT0SET_GPIO20_Msk           (0x100000UL)              /*!< GPIO20 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO19_Pos           (19UL)                    /*!< GPIO19 (Bit 19)                                       */
#define GPIO_INT0SET_GPIO19_Msk           (0x80000UL)               /*!< GPIO19 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO18_Pos           (18UL)                    /*!< GPIO18 (Bit 18)                                       */
#define GPIO_INT0SET_GPIO18_Msk           (0x40000UL)               /*!< GPIO18 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO17_Pos           (17UL)                    /*!< GPIO17 (Bit 17)                                       */
#define GPIO_INT0SET_GPIO17_Msk           (0x20000UL)               /*!< GPIO17 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO16_Pos           (16UL)                    /*!< GPIO16 (Bit 16)                                       */
#define GPIO_INT0SET_GPIO16_Msk           (0x10000UL)               /*!< GPIO16 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO15_Pos           (15UL)                    /*!< GPIO15 (Bit 15)                                       */
#define GPIO_INT0SET_GPIO15_Msk           (0x8000UL)                /*!< GPIO15 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO14_Pos           (14UL)                    /*!< GPIO14 (Bit 14)                                       */
#define GPIO_INT0SET_GPIO14_Msk           (0x4000UL)                /*!< GPIO14 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO13_Pos           (13UL)                    /*!< GPIO13 (Bit 13)                                       */
#define GPIO_INT0SET_GPIO13_Msk           (0x2000UL)                /*!< GPIO13 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO12_Pos           (12UL)                    /*!< GPIO12 (Bit 12)                                       */
#define GPIO_INT0SET_GPIO12_Msk           (0x1000UL)                /*!< GPIO12 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO11_Pos           (11UL)                    /*!< GPIO11 (Bit 11)                                       */
#define GPIO_INT0SET_GPIO11_Msk           (0x800UL)                 /*!< GPIO11 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO10_Pos           (10UL)                    /*!< GPIO10 (Bit 10)                                       */
#define GPIO_INT0SET_GPIO10_Msk           (0x400UL)                 /*!< GPIO10 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT0SET_GPIO9_Pos            (9UL)                     /*!< GPIO9 (Bit 9)                                         */
#define GPIO_INT0SET_GPIO9_Msk            (0x200UL)                 /*!< GPIO9 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0SET_GPIO8_Pos            (8UL)                     /*!< GPIO8 (Bit 8)                                         */
#define GPIO_INT0SET_GPIO8_Msk            (0x100UL)                 /*!< GPIO8 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0SET_GPIO7_Pos            (7UL)                     /*!< GPIO7 (Bit 7)                                         */
#define GPIO_INT0SET_GPIO7_Msk            (0x80UL)                  /*!< GPIO7 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0SET_GPIO6_Pos            (6UL)                     /*!< GPIO6 (Bit 6)                                         */
#define GPIO_INT0SET_GPIO6_Msk            (0x40UL)                  /*!< GPIO6 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0SET_GPIO5_Pos            (5UL)                     /*!< GPIO5 (Bit 5)                                         */
#define GPIO_INT0SET_GPIO5_Msk            (0x20UL)                  /*!< GPIO5 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0SET_GPIO4_Pos            (4UL)                     /*!< GPIO4 (Bit 4)                                         */
#define GPIO_INT0SET_GPIO4_Msk            (0x10UL)                  /*!< GPIO4 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0SET_GPIO3_Pos            (3UL)                     /*!< GPIO3 (Bit 3)                                         */
#define GPIO_INT0SET_GPIO3_Msk            (0x8UL)                   /*!< GPIO3 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0SET_GPIO2_Pos            (2UL)                     /*!< GPIO2 (Bit 2)                                         */
#define GPIO_INT0SET_GPIO2_Msk            (0x4UL)                   /*!< GPIO2 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0SET_GPIO1_Pos            (1UL)                     /*!< GPIO1 (Bit 1)                                         */
#define GPIO_INT0SET_GPIO1_Msk            (0x2UL)                   /*!< GPIO1 (Bitfield-Mask: 0x01)                           */
#define GPIO_INT0SET_GPIO0_Pos            (0UL)                     /*!< GPIO0 (Bit 0)                                         */
#define GPIO_INT0SET_GPIO0_Msk            (0x1UL)                   /*!< GPIO0 (Bitfield-Mask: 0x01)                           */
/* ========================================================  INT1EN  ========================================================= */
#define GPIO_INT1EN_GPIO49_Pos            (17UL)                    /*!< GPIO49 (Bit 17)                                       */
#define GPIO_INT1EN_GPIO49_Msk            (0x20000UL)               /*!< GPIO49 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO48_Pos            (16UL)                    /*!< GPIO48 (Bit 16)                                       */
#define GPIO_INT1EN_GPIO48_Msk            (0x10000UL)               /*!< GPIO48 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO47_Pos            (15UL)                    /*!< GPIO47 (Bit 15)                                       */
#define GPIO_INT1EN_GPIO47_Msk            (0x8000UL)                /*!< GPIO47 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO46_Pos            (14UL)                    /*!< GPIO46 (Bit 14)                                       */
#define GPIO_INT1EN_GPIO46_Msk            (0x4000UL)                /*!< GPIO46 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO45_Pos            (13UL)                    /*!< GPIO45 (Bit 13)                                       */
#define GPIO_INT1EN_GPIO45_Msk            (0x2000UL)                /*!< GPIO45 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO44_Pos            (12UL)                    /*!< GPIO44 (Bit 12)                                       */
#define GPIO_INT1EN_GPIO44_Msk            (0x1000UL)                /*!< GPIO44 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO43_Pos            (11UL)                    /*!< GPIO43 (Bit 11)                                       */
#define GPIO_INT1EN_GPIO43_Msk            (0x800UL)                 /*!< GPIO43 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO42_Pos            (10UL)                    /*!< GPIO42 (Bit 10)                                       */
#define GPIO_INT1EN_GPIO42_Msk            (0x400UL)                 /*!< GPIO42 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO41_Pos            (9UL)                     /*!< GPIO41 (Bit 9)                                        */
#define GPIO_INT1EN_GPIO41_Msk            (0x200UL)                 /*!< GPIO41 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO40_Pos            (8UL)                     /*!< GPIO40 (Bit 8)                                        */
#define GPIO_INT1EN_GPIO40_Msk            (0x100UL)                 /*!< GPIO40 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO39_Pos            (7UL)                     /*!< GPIO39 (Bit 7)                                        */
#define GPIO_INT1EN_GPIO39_Msk            (0x80UL)                  /*!< GPIO39 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO38_Pos            (6UL)                     /*!< GPIO38 (Bit 6)                                        */
#define GPIO_INT1EN_GPIO38_Msk            (0x40UL)                  /*!< GPIO38 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO37_Pos            (5UL)                     /*!< GPIO37 (Bit 5)                                        */
#define GPIO_INT1EN_GPIO37_Msk            (0x20UL)                  /*!< GPIO37 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO36_Pos            (4UL)                     /*!< GPIO36 (Bit 4)                                        */
#define GPIO_INT1EN_GPIO36_Msk            (0x10UL)                  /*!< GPIO36 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO35_Pos            (3UL)                     /*!< GPIO35 (Bit 3)                                        */
#define GPIO_INT1EN_GPIO35_Msk            (0x8UL)                   /*!< GPIO35 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO34_Pos            (2UL)                     /*!< GPIO34 (Bit 2)                                        */
#define GPIO_INT1EN_GPIO34_Msk            (0x4UL)                   /*!< GPIO34 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO33_Pos            (1UL)                     /*!< GPIO33 (Bit 1)                                        */
#define GPIO_INT1EN_GPIO33_Msk            (0x2UL)                   /*!< GPIO33 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1EN_GPIO32_Pos            (0UL)                     /*!< GPIO32 (Bit 0)                                        */
#define GPIO_INT1EN_GPIO32_Msk            (0x1UL)                   /*!< GPIO32 (Bitfield-Mask: 0x01)                          */
/* =======================================================  INT1STAT  ======================================================== */
#define GPIO_INT1STAT_GPIO49_Pos          (17UL)                    /*!< GPIO49 (Bit 17)                                       */
#define GPIO_INT1STAT_GPIO49_Msk          (0x20000UL)               /*!< GPIO49 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO48_Pos          (16UL)                    /*!< GPIO48 (Bit 16)                                       */
#define GPIO_INT1STAT_GPIO48_Msk          (0x10000UL)               /*!< GPIO48 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO47_Pos          (15UL)                    /*!< GPIO47 (Bit 15)                                       */
#define GPIO_INT1STAT_GPIO47_Msk          (0x8000UL)                /*!< GPIO47 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO46_Pos          (14UL)                    /*!< GPIO46 (Bit 14)                                       */
#define GPIO_INT1STAT_GPIO46_Msk          (0x4000UL)                /*!< GPIO46 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO45_Pos          (13UL)                    /*!< GPIO45 (Bit 13)                                       */
#define GPIO_INT1STAT_GPIO45_Msk          (0x2000UL)                /*!< GPIO45 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO44_Pos          (12UL)                    /*!< GPIO44 (Bit 12)                                       */
#define GPIO_INT1STAT_GPIO44_Msk          (0x1000UL)                /*!< GPIO44 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO43_Pos          (11UL)                    /*!< GPIO43 (Bit 11)                                       */
#define GPIO_INT1STAT_GPIO43_Msk          (0x800UL)                 /*!< GPIO43 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO42_Pos          (10UL)                    /*!< GPIO42 (Bit 10)                                       */
#define GPIO_INT1STAT_GPIO42_Msk          (0x400UL)                 /*!< GPIO42 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO41_Pos          (9UL)                     /*!< GPIO41 (Bit 9)                                        */
#define GPIO_INT1STAT_GPIO41_Msk          (0x200UL)                 /*!< GPIO41 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO40_Pos          (8UL)                     /*!< GPIO40 (Bit 8)                                        */
#define GPIO_INT1STAT_GPIO40_Msk          (0x100UL)                 /*!< GPIO40 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO39_Pos          (7UL)                     /*!< GPIO39 (Bit 7)                                        */
#define GPIO_INT1STAT_GPIO39_Msk          (0x80UL)                  /*!< GPIO39 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO38_Pos          (6UL)                     /*!< GPIO38 (Bit 6)                                        */
#define GPIO_INT1STAT_GPIO38_Msk          (0x40UL)                  /*!< GPIO38 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO37_Pos          (5UL)                     /*!< GPIO37 (Bit 5)                                        */
#define GPIO_INT1STAT_GPIO37_Msk          (0x20UL)                  /*!< GPIO37 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO36_Pos          (4UL)                     /*!< GPIO36 (Bit 4)                                        */
#define GPIO_INT1STAT_GPIO36_Msk          (0x10UL)                  /*!< GPIO36 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO35_Pos          (3UL)                     /*!< GPIO35 (Bit 3)                                        */
#define GPIO_INT1STAT_GPIO35_Msk          (0x8UL)                   /*!< GPIO35 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO34_Pos          (2UL)                     /*!< GPIO34 (Bit 2)                                        */
#define GPIO_INT1STAT_GPIO34_Msk          (0x4UL)                   /*!< GPIO34 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO33_Pos          (1UL)                     /*!< GPIO33 (Bit 1)                                        */
#define GPIO_INT1STAT_GPIO33_Msk          (0x2UL)                   /*!< GPIO33 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1STAT_GPIO32_Pos          (0UL)                     /*!< GPIO32 (Bit 0)                                        */
#define GPIO_INT1STAT_GPIO32_Msk          (0x1UL)                   /*!< GPIO32 (Bitfield-Mask: 0x01)                          */
/* ========================================================  INT1CLR  ======================================================== */
#define GPIO_INT1CLR_GPIO49_Pos           (17UL)                    /*!< GPIO49 (Bit 17)                                       */
#define GPIO_INT1CLR_GPIO49_Msk           (0x20000UL)               /*!< GPIO49 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO48_Pos           (16UL)                    /*!< GPIO48 (Bit 16)                                       */
#define GPIO_INT1CLR_GPIO48_Msk           (0x10000UL)               /*!< GPIO48 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO47_Pos           (15UL)                    /*!< GPIO47 (Bit 15)                                       */
#define GPIO_INT1CLR_GPIO47_Msk           (0x8000UL)                /*!< GPIO47 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO46_Pos           (14UL)                    /*!< GPIO46 (Bit 14)                                       */
#define GPIO_INT1CLR_GPIO46_Msk           (0x4000UL)                /*!< GPIO46 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO45_Pos           (13UL)                    /*!< GPIO45 (Bit 13)                                       */
#define GPIO_INT1CLR_GPIO45_Msk           (0x2000UL)                /*!< GPIO45 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO44_Pos           (12UL)                    /*!< GPIO44 (Bit 12)                                       */
#define GPIO_INT1CLR_GPIO44_Msk           (0x1000UL)                /*!< GPIO44 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO43_Pos           (11UL)                    /*!< GPIO43 (Bit 11)                                       */
#define GPIO_INT1CLR_GPIO43_Msk           (0x800UL)                 /*!< GPIO43 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO42_Pos           (10UL)                    /*!< GPIO42 (Bit 10)                                       */
#define GPIO_INT1CLR_GPIO42_Msk           (0x400UL)                 /*!< GPIO42 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO41_Pos           (9UL)                     /*!< GPIO41 (Bit 9)                                        */
#define GPIO_INT1CLR_GPIO41_Msk           (0x200UL)                 /*!< GPIO41 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO40_Pos           (8UL)                     /*!< GPIO40 (Bit 8)                                        */
#define GPIO_INT1CLR_GPIO40_Msk           (0x100UL)                 /*!< GPIO40 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO39_Pos           (7UL)                     /*!< GPIO39 (Bit 7)                                        */
#define GPIO_INT1CLR_GPIO39_Msk           (0x80UL)                  /*!< GPIO39 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO38_Pos           (6UL)                     /*!< GPIO38 (Bit 6)                                        */
#define GPIO_INT1CLR_GPIO38_Msk           (0x40UL)                  /*!< GPIO38 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO37_Pos           (5UL)                     /*!< GPIO37 (Bit 5)                                        */
#define GPIO_INT1CLR_GPIO37_Msk           (0x20UL)                  /*!< GPIO37 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO36_Pos           (4UL)                     /*!< GPIO36 (Bit 4)                                        */
#define GPIO_INT1CLR_GPIO36_Msk           (0x10UL)                  /*!< GPIO36 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO35_Pos           (3UL)                     /*!< GPIO35 (Bit 3)                                        */
#define GPIO_INT1CLR_GPIO35_Msk           (0x8UL)                   /*!< GPIO35 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO34_Pos           (2UL)                     /*!< GPIO34 (Bit 2)                                        */
#define GPIO_INT1CLR_GPIO34_Msk           (0x4UL)                   /*!< GPIO34 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO33_Pos           (1UL)                     /*!< GPIO33 (Bit 1)                                        */
#define GPIO_INT1CLR_GPIO33_Msk           (0x2UL)                   /*!< GPIO33 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1CLR_GPIO32_Pos           (0UL)                     /*!< GPIO32 (Bit 0)                                        */
#define GPIO_INT1CLR_GPIO32_Msk           (0x1UL)                   /*!< GPIO32 (Bitfield-Mask: 0x01)                          */
/* ========================================================  INT1SET  ======================================================== */
#define GPIO_INT1SET_GPIO49_Pos           (17UL)                    /*!< GPIO49 (Bit 17)                                       */
#define GPIO_INT1SET_GPIO49_Msk           (0x20000UL)               /*!< GPIO49 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO48_Pos           (16UL)                    /*!< GPIO48 (Bit 16)                                       */
#define GPIO_INT1SET_GPIO48_Msk           (0x10000UL)               /*!< GPIO48 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO47_Pos           (15UL)                    /*!< GPIO47 (Bit 15)                                       */
#define GPIO_INT1SET_GPIO47_Msk           (0x8000UL)                /*!< GPIO47 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO46_Pos           (14UL)                    /*!< GPIO46 (Bit 14)                                       */
#define GPIO_INT1SET_GPIO46_Msk           (0x4000UL)                /*!< GPIO46 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO45_Pos           (13UL)                    /*!< GPIO45 (Bit 13)                                       */
#define GPIO_INT1SET_GPIO45_Msk           (0x2000UL)                /*!< GPIO45 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO44_Pos           (12UL)                    /*!< GPIO44 (Bit 12)                                       */
#define GPIO_INT1SET_GPIO44_Msk           (0x1000UL)                /*!< GPIO44 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO43_Pos           (11UL)                    /*!< GPIO43 (Bit 11)                                       */
#define GPIO_INT1SET_GPIO43_Msk           (0x800UL)                 /*!< GPIO43 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO42_Pos           (10UL)                    /*!< GPIO42 (Bit 10)                                       */
#define GPIO_INT1SET_GPIO42_Msk           (0x400UL)                 /*!< GPIO42 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO41_Pos           (9UL)                     /*!< GPIO41 (Bit 9)                                        */
#define GPIO_INT1SET_GPIO41_Msk           (0x200UL)                 /*!< GPIO41 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO40_Pos           (8UL)                     /*!< GPIO40 (Bit 8)                                        */
#define GPIO_INT1SET_GPIO40_Msk           (0x100UL)                 /*!< GPIO40 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO39_Pos           (7UL)                     /*!< GPIO39 (Bit 7)                                        */
#define GPIO_INT1SET_GPIO39_Msk           (0x80UL)                  /*!< GPIO39 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO38_Pos           (6UL)                     /*!< GPIO38 (Bit 6)                                        */
#define GPIO_INT1SET_GPIO38_Msk           (0x40UL)                  /*!< GPIO38 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO37_Pos           (5UL)                     /*!< GPIO37 (Bit 5)                                        */
#define GPIO_INT1SET_GPIO37_Msk           (0x20UL)                  /*!< GPIO37 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO36_Pos           (4UL)                     /*!< GPIO36 (Bit 4)                                        */
#define GPIO_INT1SET_GPIO36_Msk           (0x10UL)                  /*!< GPIO36 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO35_Pos           (3UL)                     /*!< GPIO35 (Bit 3)                                        */
#define GPIO_INT1SET_GPIO35_Msk           (0x8UL)                   /*!< GPIO35 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO34_Pos           (2UL)                     /*!< GPIO34 (Bit 2)                                        */
#define GPIO_INT1SET_GPIO34_Msk           (0x4UL)                   /*!< GPIO34 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO33_Pos           (1UL)                     /*!< GPIO33 (Bit 1)                                        */
#define GPIO_INT1SET_GPIO33_Msk           (0x2UL)                   /*!< GPIO33 (Bitfield-Mask: 0x01)                          */
#define GPIO_INT1SET_GPIO32_Pos           (0UL)                     /*!< GPIO32 (Bit 0)                                        */
#define GPIO_INT1SET_GPIO32_Msk           (0x1UL)                   /*!< GPIO32 (Bitfield-Mask: 0x01)                          */


/* =========================================================================================================================== */
/* ================                                          IOMSTR0                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  FIFO  ========================================================== */
#define IOMSTR0_FIFO_FIFO_Pos             (0UL)                     /*!< FIFO (Bit 0)                                          */
#define IOMSTR0_FIFO_FIFO_Msk             (0xffffffffUL)            /*!< FIFO (Bitfield-Mask: 0xffffffff)                      */
/* ========================================================  FIFOPTR  ======================================================== */
#define IOMSTR0_FIFOPTR_FIFOREM_Pos       (16UL)                    /*!< FIFOREM (Bit 16)                                      */
#define IOMSTR0_FIFOPTR_FIFOREM_Msk       (0xff0000UL)              /*!< FIFOREM (Bitfield-Mask: 0xff)                         */
#define IOMSTR0_FIFOPTR_FIFOSIZ_Pos       (0UL)                     /*!< FIFOSIZ (Bit 0)                                       */
#define IOMSTR0_FIFOPTR_FIFOSIZ_Msk       (0xffUL)                  /*!< FIFOSIZ (Bitfield-Mask: 0xff)                         */
/* ========================================================  TLNGTH  ========================================================= */
#define IOMSTR0_TLNGTH_TLNGTH_Pos         (0UL)                     /*!< TLNGTH (Bit 0)                                        */
#define IOMSTR0_TLNGTH_TLNGTH_Msk         (0xfffUL)                 /*!< TLNGTH (Bitfield-Mask: 0xfff)                         */
/* ========================================================  FIFOTHR  ======================================================== */
#define IOMSTR0_FIFOTHR_FIFOWTHR_Pos      (8UL)                     /*!< FIFOWTHR (Bit 8)                                      */
#define IOMSTR0_FIFOTHR_FIFOWTHR_Msk      (0x7f00UL)                /*!< FIFOWTHR (Bitfield-Mask: 0x7f)                        */
#define IOMSTR0_FIFOTHR_FIFORTHR_Pos      (0UL)                     /*!< FIFORTHR (Bit 0)                                      */
#define IOMSTR0_FIFOTHR_FIFORTHR_Msk      (0x7fUL)                  /*!< FIFORTHR (Bitfield-Mask: 0x7f)                        */
/* ========================================================  CLKCFG  ========================================================= */
#define IOMSTR0_CLKCFG_TOTPER_Pos         (24UL)                    /*!< TOTPER (Bit 24)                                       */
#define IOMSTR0_CLKCFG_TOTPER_Msk         (0xff000000UL)            /*!< TOTPER (Bitfield-Mask: 0xff)                          */
#define IOMSTR0_CLKCFG_LOWPER_Pos         (16UL)                    /*!< LOWPER (Bit 16)                                       */
#define IOMSTR0_CLKCFG_LOWPER_Msk         (0xff0000UL)              /*!< LOWPER (Bitfield-Mask: 0xff)                          */
#define IOMSTR0_CLKCFG_DIVEN_Pos          (12UL)                    /*!< DIVEN (Bit 12)                                        */
#define IOMSTR0_CLKCFG_DIVEN_Msk          (0x1000UL)                /*!< DIVEN (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_CLKCFG_DIV3_Pos           (11UL)                    /*!< DIV3 (Bit 11)                                         */
#define IOMSTR0_CLKCFG_DIV3_Msk           (0x800UL)                 /*!< DIV3 (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_CLKCFG_FSEL_Pos           (8UL)                     /*!< FSEL (Bit 8)                                          */
#define IOMSTR0_CLKCFG_FSEL_Msk           (0x700UL)                 /*!< FSEL (Bitfield-Mask: 0x07)                            */
/* ==========================================================  CMD  ========================================================== */
#define IOMSTR0_CMD_CMD_Pos               (0UL)                     /*!< CMD (Bit 0)                                           */
#define IOMSTR0_CMD_CMD_Msk               (0xffffffffUL)            /*!< CMD (Bitfield-Mask: 0xffffffff)                       */
/* ========================================================  CMDRPT  ========================================================= */
#define IOMSTR0_CMDRPT_CMDRPT_Pos         (0UL)                     /*!< CMDRPT (Bit 0)                                        */
#define IOMSTR0_CMDRPT_CMDRPT_Msk         (0x1fUL)                  /*!< CMDRPT (Bitfield-Mask: 0x1f)                          */
/* ========================================================  STATUS  ========================================================= */
#define IOMSTR0_STATUS_IDLEST_Pos         (2UL)                     /*!< IDLEST (Bit 2)                                        */
#define IOMSTR0_STATUS_IDLEST_Msk         (0x4UL)                   /*!< IDLEST (Bitfield-Mask: 0x01)                          */
#define IOMSTR0_STATUS_CMDACT_Pos         (1UL)                     /*!< CMDACT (Bit 1)                                        */
#define IOMSTR0_STATUS_CMDACT_Msk         (0x2UL)                   /*!< CMDACT (Bitfield-Mask: 0x01)                          */
#define IOMSTR0_STATUS_ERR_Pos            (0UL)                     /*!< ERR (Bit 0)                                           */
#define IOMSTR0_STATUS_ERR_Msk            (0x1UL)                   /*!< ERR (Bitfield-Mask: 0x01)                             */
/* ==========================================================  CFG  ========================================================== */
#define IOMSTR0_CFG_IFCEN_Pos             (31UL)                    /*!< IFCEN (Bit 31)                                        */
#define IOMSTR0_CFG_IFCEN_Msk             (0x80000000UL)            /*!< IFCEN (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_CFG_RDFCPOL_Pos           (14UL)                    /*!< RDFCPOL (Bit 14)                                      */
#define IOMSTR0_CFG_RDFCPOL_Msk           (0x4000UL)                /*!< RDFCPOL (Bitfield-Mask: 0x01)                         */
#define IOMSTR0_CFG_WTFCPOL_Pos           (13UL)                    /*!< WTFCPOL (Bit 13)                                      */
#define IOMSTR0_CFG_WTFCPOL_Msk           (0x2000UL)                /*!< WTFCPOL (Bitfield-Mask: 0x01)                         */
#define IOMSTR0_CFG_WTFCIRQ_Pos           (12UL)                    /*!< WTFCIRQ (Bit 12)                                      */
#define IOMSTR0_CFG_WTFCIRQ_Msk           (0x1000UL)                /*!< WTFCIRQ (Bitfield-Mask: 0x01)                         */
#define IOMSTR0_CFG_FCDEL_Pos             (11UL)                    /*!< FCDEL (Bit 11)                                        */
#define IOMSTR0_CFG_FCDEL_Msk             (0x800UL)                 /*!< FCDEL (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_CFG_MOSIINV_Pos           (10UL)                    /*!< MOSIINV (Bit 10)                                      */
#define IOMSTR0_CFG_MOSIINV_Msk           (0x400UL)                 /*!< MOSIINV (Bitfield-Mask: 0x01)                         */
#define IOMSTR0_CFG_RDFC_Pos              (9UL)                     /*!< RDFC (Bit 9)                                          */
#define IOMSTR0_CFG_RDFC_Msk              (0x200UL)                 /*!< RDFC (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_CFG_WTFC_Pos              (8UL)                     /*!< WTFC (Bit 8)                                          */
#define IOMSTR0_CFG_WTFC_Msk              (0x100UL)                 /*!< WTFC (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_CFG_STARTRD_Pos           (4UL)                     /*!< STARTRD (Bit 4)                                       */
#define IOMSTR0_CFG_STARTRD_Msk           (0x30UL)                  /*!< STARTRD (Bitfield-Mask: 0x03)                         */
#define IOMSTR0_CFG_FULLDUP_Pos           (3UL)                     /*!< FULLDUP (Bit 3)                                       */
#define IOMSTR0_CFG_FULLDUP_Msk           (0x8UL)                   /*!< FULLDUP (Bitfield-Mask: 0x01)                         */
#define IOMSTR0_CFG_SPHA_Pos              (2UL)                     /*!< SPHA (Bit 2)                                          */
#define IOMSTR0_CFG_SPHA_Msk              (0x4UL)                   /*!< SPHA (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_CFG_SPOL_Pos              (1UL)                     /*!< SPOL (Bit 1)                                          */
#define IOMSTR0_CFG_SPOL_Msk              (0x2UL)                   /*!< SPOL (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_CFG_IFCSEL_Pos            (0UL)                     /*!< IFCSEL (Bit 0)                                        */
#define IOMSTR0_CFG_IFCSEL_Msk            (0x1UL)                   /*!< IFCSEL (Bitfield-Mask: 0x01)                          */
/* =========================================================  INTEN  ========================================================= */
#define IOMSTR0_INTEN_ARB_Pos             (10UL)                    /*!< ARB (Bit 10)                                          */
#define IOMSTR0_INTEN_ARB_Msk             (0x400UL)                 /*!< ARB (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTEN_STOP_Pos            (9UL)                     /*!< STOP (Bit 9)                                          */
#define IOMSTR0_INTEN_STOP_Msk            (0x200UL)                 /*!< STOP (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTEN_START_Pos           (8UL)                     /*!< START (Bit 8)                                         */
#define IOMSTR0_INTEN_START_Msk           (0x100UL)                 /*!< START (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTEN_ICMD_Pos            (7UL)                     /*!< ICMD (Bit 7)                                          */
#define IOMSTR0_INTEN_ICMD_Msk            (0x80UL)                  /*!< ICMD (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTEN_IACC_Pos            (6UL)                     /*!< IACC (Bit 6)                                          */
#define IOMSTR0_INTEN_IACC_Msk            (0x40UL)                  /*!< IACC (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTEN_WTLEN_Pos           (5UL)                     /*!< WTLEN (Bit 5)                                         */
#define IOMSTR0_INTEN_WTLEN_Msk           (0x20UL)                  /*!< WTLEN (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTEN_NAK_Pos             (4UL)                     /*!< NAK (Bit 4)                                           */
#define IOMSTR0_INTEN_NAK_Msk             (0x10UL)                  /*!< NAK (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTEN_FOVFL_Pos           (3UL)                     /*!< FOVFL (Bit 3)                                         */
#define IOMSTR0_INTEN_FOVFL_Msk           (0x8UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTEN_FUNDFL_Pos          (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define IOMSTR0_INTEN_FUNDFL_Msk          (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define IOMSTR0_INTEN_THR_Pos             (1UL)                     /*!< THR (Bit 1)                                           */
#define IOMSTR0_INTEN_THR_Msk             (0x2UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTEN_CMDCMP_Pos          (0UL)                     /*!< CMDCMP (Bit 0)                                        */
#define IOMSTR0_INTEN_CMDCMP_Msk          (0x1UL)                   /*!< CMDCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSTAT  ======================================================== */
#define IOMSTR0_INTSTAT_ARB_Pos           (10UL)                    /*!< ARB (Bit 10)                                          */
#define IOMSTR0_INTSTAT_ARB_Msk           (0x400UL)                 /*!< ARB (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTSTAT_STOP_Pos          (9UL)                     /*!< STOP (Bit 9)                                          */
#define IOMSTR0_INTSTAT_STOP_Msk          (0x200UL)                 /*!< STOP (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTSTAT_START_Pos         (8UL)                     /*!< START (Bit 8)                                         */
#define IOMSTR0_INTSTAT_START_Msk         (0x100UL)                 /*!< START (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTSTAT_ICMD_Pos          (7UL)                     /*!< ICMD (Bit 7)                                          */
#define IOMSTR0_INTSTAT_ICMD_Msk          (0x80UL)                  /*!< ICMD (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTSTAT_IACC_Pos          (6UL)                     /*!< IACC (Bit 6)                                          */
#define IOMSTR0_INTSTAT_IACC_Msk          (0x40UL)                  /*!< IACC (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTSTAT_WTLEN_Pos         (5UL)                     /*!< WTLEN (Bit 5)                                         */
#define IOMSTR0_INTSTAT_WTLEN_Msk         (0x20UL)                  /*!< WTLEN (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTSTAT_NAK_Pos           (4UL)                     /*!< NAK (Bit 4)                                           */
#define IOMSTR0_INTSTAT_NAK_Msk           (0x10UL)                  /*!< NAK (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTSTAT_FOVFL_Pos         (3UL)                     /*!< FOVFL (Bit 3)                                         */
#define IOMSTR0_INTSTAT_FOVFL_Msk         (0x8UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTSTAT_FUNDFL_Pos        (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define IOMSTR0_INTSTAT_FUNDFL_Msk        (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define IOMSTR0_INTSTAT_THR_Pos           (1UL)                     /*!< THR (Bit 1)                                           */
#define IOMSTR0_INTSTAT_THR_Msk           (0x2UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTSTAT_CMDCMP_Pos        (0UL)                     /*!< CMDCMP (Bit 0)                                        */
#define IOMSTR0_INTSTAT_CMDCMP_Msk        (0x1UL)                   /*!< CMDCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTCLR  ========================================================= */
#define IOMSTR0_INTCLR_ARB_Pos            (10UL)                    /*!< ARB (Bit 10)                                          */
#define IOMSTR0_INTCLR_ARB_Msk            (0x400UL)                 /*!< ARB (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTCLR_STOP_Pos           (9UL)                     /*!< STOP (Bit 9)                                          */
#define IOMSTR0_INTCLR_STOP_Msk           (0x200UL)                 /*!< STOP (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTCLR_START_Pos          (8UL)                     /*!< START (Bit 8)                                         */
#define IOMSTR0_INTCLR_START_Msk          (0x100UL)                 /*!< START (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTCLR_ICMD_Pos           (7UL)                     /*!< ICMD (Bit 7)                                          */
#define IOMSTR0_INTCLR_ICMD_Msk           (0x80UL)                  /*!< ICMD (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTCLR_IACC_Pos           (6UL)                     /*!< IACC (Bit 6)                                          */
#define IOMSTR0_INTCLR_IACC_Msk           (0x40UL)                  /*!< IACC (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTCLR_WTLEN_Pos          (5UL)                     /*!< WTLEN (Bit 5)                                         */
#define IOMSTR0_INTCLR_WTLEN_Msk          (0x20UL)                  /*!< WTLEN (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTCLR_NAK_Pos            (4UL)                     /*!< NAK (Bit 4)                                           */
#define IOMSTR0_INTCLR_NAK_Msk            (0x10UL)                  /*!< NAK (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTCLR_FOVFL_Pos          (3UL)                     /*!< FOVFL (Bit 3)                                         */
#define IOMSTR0_INTCLR_FOVFL_Msk          (0x8UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTCLR_FUNDFL_Pos         (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define IOMSTR0_INTCLR_FUNDFL_Msk         (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define IOMSTR0_INTCLR_THR_Pos            (1UL)                     /*!< THR (Bit 1)                                           */
#define IOMSTR0_INTCLR_THR_Msk            (0x2UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTCLR_CMDCMP_Pos         (0UL)                     /*!< CMDCMP (Bit 0)                                        */
#define IOMSTR0_INTCLR_CMDCMP_Msk         (0x1UL)                   /*!< CMDCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSET  ========================================================= */
#define IOMSTR0_INTSET_ARB_Pos            (10UL)                    /*!< ARB (Bit 10)                                          */
#define IOMSTR0_INTSET_ARB_Msk            (0x400UL)                 /*!< ARB (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTSET_STOP_Pos           (9UL)                     /*!< STOP (Bit 9)                                          */
#define IOMSTR0_INTSET_STOP_Msk           (0x200UL)                 /*!< STOP (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTSET_START_Pos          (8UL)                     /*!< START (Bit 8)                                         */
#define IOMSTR0_INTSET_START_Msk          (0x100UL)                 /*!< START (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTSET_ICMD_Pos           (7UL)                     /*!< ICMD (Bit 7)                                          */
#define IOMSTR0_INTSET_ICMD_Msk           (0x80UL)                  /*!< ICMD (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTSET_IACC_Pos           (6UL)                     /*!< IACC (Bit 6)                                          */
#define IOMSTR0_INTSET_IACC_Msk           (0x40UL)                  /*!< IACC (Bitfield-Mask: 0x01)                            */
#define IOMSTR0_INTSET_WTLEN_Pos          (5UL)                     /*!< WTLEN (Bit 5)                                         */
#define IOMSTR0_INTSET_WTLEN_Msk          (0x20UL)                  /*!< WTLEN (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTSET_NAK_Pos            (4UL)                     /*!< NAK (Bit 4)                                           */
#define IOMSTR0_INTSET_NAK_Msk            (0x10UL)                  /*!< NAK (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTSET_FOVFL_Pos          (3UL)                     /*!< FOVFL (Bit 3)                                         */
#define IOMSTR0_INTSET_FOVFL_Msk          (0x8UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define IOMSTR0_INTSET_FUNDFL_Pos         (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define IOMSTR0_INTSET_FUNDFL_Msk         (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define IOMSTR0_INTSET_THR_Pos            (1UL)                     /*!< THR (Bit 1)                                           */
#define IOMSTR0_INTSET_THR_Msk            (0x2UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
#define IOMSTR0_INTSET_CMDCMP_Pos         (0UL)                     /*!< CMDCMP (Bit 0)                                        */
#define IOMSTR0_INTSET_CMDCMP_Msk         (0x1UL)                   /*!< CMDCMP (Bitfield-Mask: 0x01)                          */


/* =========================================================================================================================== */
/* ================                                          IOSLAVE                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  FIFOPTR  ======================================================== */
#define IOSLAVE_FIFOPTR_FIFOSIZ_Pos       (8UL)                     /*!< FIFOSIZ (Bit 8)                                       */
#define IOSLAVE_FIFOPTR_FIFOSIZ_Msk       (0xff00UL)                /*!< FIFOSIZ (Bitfield-Mask: 0xff)                         */
#define IOSLAVE_FIFOPTR_FIFOPTR_Pos       (0UL)                     /*!< FIFOPTR (Bit 0)                                       */
#define IOSLAVE_FIFOPTR_FIFOPTR_Msk       (0xffUL)                  /*!< FIFOPTR (Bitfield-Mask: 0xff)                         */
/* ========================================================  FIFOCFG  ======================================================== */
#define IOSLAVE_FIFOCFG_ROBASE_Pos        (24UL)                    /*!< ROBASE (Bit 24)                                       */
#define IOSLAVE_FIFOCFG_ROBASE_Msk        (0x3f000000UL)            /*!< ROBASE (Bitfield-Mask: 0x3f)                          */
#define IOSLAVE_FIFOCFG_FIFOMAX_Pos       (8UL)                     /*!< FIFOMAX (Bit 8)                                       */
#define IOSLAVE_FIFOCFG_FIFOMAX_Msk       (0x3f00UL)                /*!< FIFOMAX (Bitfield-Mask: 0x3f)                         */
#define IOSLAVE_FIFOCFG_FIFOBASE_Pos      (0UL)                     /*!< FIFOBASE (Bit 0)                                      */
#define IOSLAVE_FIFOCFG_FIFOBASE_Msk      (0x1fUL)                  /*!< FIFOBASE (Bitfield-Mask: 0x1f)                        */
/* ========================================================  FIFOTHR  ======================================================== */
#define IOSLAVE_FIFOTHR_FIFOTHR_Pos       (0UL)                     /*!< FIFOTHR (Bit 0)                                       */
#define IOSLAVE_FIFOTHR_FIFOTHR_Msk       (0xffUL)                  /*!< FIFOTHR (Bitfield-Mask: 0xff)                         */
/* =========================================================  FUPD  ========================================================== */
#define IOSLAVE_FUPD_IOREAD_Pos           (1UL)                     /*!< IOREAD (Bit 1)                                        */
#define IOSLAVE_FUPD_IOREAD_Msk           (0x2UL)                   /*!< IOREAD (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_FUPD_FIFOUPD_Pos          (0UL)                     /*!< FIFOUPD (Bit 0)                                       */
#define IOSLAVE_FUPD_FIFOUPD_Msk          (0x1UL)                   /*!< FIFOUPD (Bitfield-Mask: 0x01)                         */
/* ========================================================  FIFOCTR  ======================================================== */
#define IOSLAVE_FIFOCTR_FIFOCTR_Pos       (0UL)                     /*!< FIFOCTR (Bit 0)                                       */
#define IOSLAVE_FIFOCTR_FIFOCTR_Msk       (0x3ffUL)                 /*!< FIFOCTR (Bitfield-Mask: 0x3ff)                        */
/* ========================================================  FIFOINC  ======================================================== */
#define IOSLAVE_FIFOINC_FIFOINC_Pos       (0UL)                     /*!< FIFOINC (Bit 0)                                       */
#define IOSLAVE_FIFOINC_FIFOINC_Msk       (0x3ffUL)                 /*!< FIFOINC (Bitfield-Mask: 0x3ff)                        */
/* ==========================================================  CFG  ========================================================== */
#define IOSLAVE_CFG_IFCEN_Pos             (31UL)                    /*!< IFCEN (Bit 31)                                        */
#define IOSLAVE_CFG_IFCEN_Msk             (0x80000000UL)            /*!< IFCEN (Bitfield-Mask: 0x01)                           */
#define IOSLAVE_CFG_I2CADDR_Pos           (8UL)                     /*!< I2CADDR (Bit 8)                                       */
#define IOSLAVE_CFG_I2CADDR_Msk           (0xfff00UL)               /*!< I2CADDR (Bitfield-Mask: 0xfff)                        */
#define IOSLAVE_CFG_STARTRD_Pos           (4UL)                     /*!< STARTRD (Bit 4)                                       */
#define IOSLAVE_CFG_STARTRD_Msk           (0x10UL)                  /*!< STARTRD (Bitfield-Mask: 0x01)                         */
#define IOSLAVE_CFG_LSB_Pos               (2UL)                     /*!< LSB (Bit 2)                                           */
#define IOSLAVE_CFG_LSB_Msk               (0x4UL)                   /*!< LSB (Bitfield-Mask: 0x01)                             */
#define IOSLAVE_CFG_SPOL_Pos              (1UL)                     /*!< SPOL (Bit 1)                                          */
#define IOSLAVE_CFG_SPOL_Msk              (0x2UL)                   /*!< SPOL (Bitfield-Mask: 0x01)                            */
#define IOSLAVE_CFG_IFCSEL_Pos            (0UL)                     /*!< IFCSEL (Bit 0)                                        */
#define IOSLAVE_CFG_IFCSEL_Msk            (0x1UL)                   /*!< IFCSEL (Bitfield-Mask: 0x01)                          */
/* =========================================================  PRENC  ========================================================= */
#define IOSLAVE_PRENC_PRENC_Pos           (0UL)                     /*!< PRENC (Bit 0)                                         */
#define IOSLAVE_PRENC_PRENC_Msk           (0x1fUL)                  /*!< PRENC (Bitfield-Mask: 0x1f)                           */
/* =======================================================  IOINTCTL  ======================================================== */
#define IOSLAVE_IOINTCTL_IOINTSET_Pos     (24UL)                    /*!< IOINTSET (Bit 24)                                     */
#define IOSLAVE_IOINTCTL_IOINTSET_Msk     (0xff000000UL)            /*!< IOINTSET (Bitfield-Mask: 0xff)                        */
#define IOSLAVE_IOINTCTL_IOINTCLR_Pos     (16UL)                    /*!< IOINTCLR (Bit 16)                                     */
#define IOSLAVE_IOINTCTL_IOINTCLR_Msk     (0x10000UL)               /*!< IOINTCLR (Bitfield-Mask: 0x01)                        */
#define IOSLAVE_IOINTCTL_IOINT_Pos        (8UL)                     /*!< IOINT (Bit 8)                                         */
#define IOSLAVE_IOINTCTL_IOINT_Msk        (0xff00UL)                /*!< IOINT (Bitfield-Mask: 0xff)                           */
#define IOSLAVE_IOINTCTL_IOINTEN_Pos      (0UL)                     /*!< IOINTEN (Bit 0)                                       */
#define IOSLAVE_IOINTCTL_IOINTEN_Msk      (0xffUL)                  /*!< IOINTEN (Bitfield-Mask: 0xff)                         */
/* ========================================================  GENADD  ========================================================= */
#define IOSLAVE_GENADD_GADATA_Pos         (0UL)                     /*!< GADATA (Bit 0)                                        */
#define IOSLAVE_GENADD_GADATA_Msk         (0xffUL)                  /*!< GADATA (Bitfield-Mask: 0xff)                          */
/* =========================================================  INTEN  ========================================================= */
#define IOSLAVE_INTEN_XCMPWR_Pos          (9UL)                     /*!< XCMPWR (Bit 9)                                        */
#define IOSLAVE_INTEN_XCMPWR_Msk          (0x200UL)                 /*!< XCMPWR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTEN_XCMPWF_Pos          (8UL)                     /*!< XCMPWF (Bit 8)                                        */
#define IOSLAVE_INTEN_XCMPWF_Msk          (0x100UL)                 /*!< XCMPWF (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTEN_XCMPRR_Pos          (7UL)                     /*!< XCMPRR (Bit 7)                                        */
#define IOSLAVE_INTEN_XCMPRR_Msk          (0x80UL)                  /*!< XCMPRR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTEN_XCMPRF_Pos          (6UL)                     /*!< XCMPRF (Bit 6)                                        */
#define IOSLAVE_INTEN_XCMPRF_Msk          (0x40UL)                  /*!< XCMPRF (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTEN_IOINTW_Pos          (5UL)                     /*!< IOINTW (Bit 5)                                        */
#define IOSLAVE_INTEN_IOINTW_Msk          (0x20UL)                  /*!< IOINTW (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTEN_GENAD_Pos           (4UL)                     /*!< GENAD (Bit 4)                                         */
#define IOSLAVE_INTEN_GENAD_Msk           (0x10UL)                  /*!< GENAD (Bitfield-Mask: 0x01)                           */
#define IOSLAVE_INTEN_FRDERR_Pos          (3UL)                     /*!< FRDERR (Bit 3)                                        */
#define IOSLAVE_INTEN_FRDERR_Msk          (0x8UL)                   /*!< FRDERR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTEN_FUNDFL_Pos          (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define IOSLAVE_INTEN_FUNDFL_Msk          (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTEN_FOVFL_Pos           (1UL)                     /*!< FOVFL (Bit 1)                                         */
#define IOSLAVE_INTEN_FOVFL_Msk           (0x2UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define IOSLAVE_INTEN_FSIZE_Pos           (0UL)                     /*!< FSIZE (Bit 0)                                         */
#define IOSLAVE_INTEN_FSIZE_Msk           (0x1UL)                   /*!< FSIZE (Bitfield-Mask: 0x01)                           */
/* ========================================================  INTSTAT  ======================================================== */
#define IOSLAVE_INTSTAT_XCMPWR_Pos        (9UL)                     /*!< XCMPWR (Bit 9)                                        */
#define IOSLAVE_INTSTAT_XCMPWR_Msk        (0x200UL)                 /*!< XCMPWR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSTAT_XCMPWF_Pos        (8UL)                     /*!< XCMPWF (Bit 8)                                        */
#define IOSLAVE_INTSTAT_XCMPWF_Msk        (0x100UL)                 /*!< XCMPWF (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSTAT_XCMPRR_Pos        (7UL)                     /*!< XCMPRR (Bit 7)                                        */
#define IOSLAVE_INTSTAT_XCMPRR_Msk        (0x80UL)                  /*!< XCMPRR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSTAT_XCMPRF_Pos        (6UL)                     /*!< XCMPRF (Bit 6)                                        */
#define IOSLAVE_INTSTAT_XCMPRF_Msk        (0x40UL)                  /*!< XCMPRF (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSTAT_IOINTW_Pos        (5UL)                     /*!< IOINTW (Bit 5)                                        */
#define IOSLAVE_INTSTAT_IOINTW_Msk        (0x20UL)                  /*!< IOINTW (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSTAT_GENAD_Pos         (4UL)                     /*!< GENAD (Bit 4)                                         */
#define IOSLAVE_INTSTAT_GENAD_Msk         (0x10UL)                  /*!< GENAD (Bitfield-Mask: 0x01)                           */
#define IOSLAVE_INTSTAT_FRDERR_Pos        (3UL)                     /*!< FRDERR (Bit 3)                                        */
#define IOSLAVE_INTSTAT_FRDERR_Msk        (0x8UL)                   /*!< FRDERR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSTAT_FUNDFL_Pos        (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define IOSLAVE_INTSTAT_FUNDFL_Msk        (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSTAT_FOVFL_Pos         (1UL)                     /*!< FOVFL (Bit 1)                                         */
#define IOSLAVE_INTSTAT_FOVFL_Msk         (0x2UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define IOSLAVE_INTSTAT_FSIZE_Pos         (0UL)                     /*!< FSIZE (Bit 0)                                         */
#define IOSLAVE_INTSTAT_FSIZE_Msk         (0x1UL)                   /*!< FSIZE (Bitfield-Mask: 0x01)                           */
/* ========================================================  INTCLR  ========================================================= */
#define IOSLAVE_INTCLR_XCMPWR_Pos         (9UL)                     /*!< XCMPWR (Bit 9)                                        */
#define IOSLAVE_INTCLR_XCMPWR_Msk         (0x200UL)                 /*!< XCMPWR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTCLR_XCMPWF_Pos         (8UL)                     /*!< XCMPWF (Bit 8)                                        */
#define IOSLAVE_INTCLR_XCMPWF_Msk         (0x100UL)                 /*!< XCMPWF (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTCLR_XCMPRR_Pos         (7UL)                     /*!< XCMPRR (Bit 7)                                        */
#define IOSLAVE_INTCLR_XCMPRR_Msk         (0x80UL)                  /*!< XCMPRR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTCLR_XCMPRF_Pos         (6UL)                     /*!< XCMPRF (Bit 6)                                        */
#define IOSLAVE_INTCLR_XCMPRF_Msk         (0x40UL)                  /*!< XCMPRF (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTCLR_IOINTW_Pos         (5UL)                     /*!< IOINTW (Bit 5)                                        */
#define IOSLAVE_INTCLR_IOINTW_Msk         (0x20UL)                  /*!< IOINTW (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTCLR_GENAD_Pos          (4UL)                     /*!< GENAD (Bit 4)                                         */
#define IOSLAVE_INTCLR_GENAD_Msk          (0x10UL)                  /*!< GENAD (Bitfield-Mask: 0x01)                           */
#define IOSLAVE_INTCLR_FRDERR_Pos         (3UL)                     /*!< FRDERR (Bit 3)                                        */
#define IOSLAVE_INTCLR_FRDERR_Msk         (0x8UL)                   /*!< FRDERR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTCLR_FUNDFL_Pos         (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define IOSLAVE_INTCLR_FUNDFL_Msk         (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTCLR_FOVFL_Pos          (1UL)                     /*!< FOVFL (Bit 1)                                         */
#define IOSLAVE_INTCLR_FOVFL_Msk          (0x2UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define IOSLAVE_INTCLR_FSIZE_Pos          (0UL)                     /*!< FSIZE (Bit 0)                                         */
#define IOSLAVE_INTCLR_FSIZE_Msk          (0x1UL)                   /*!< FSIZE (Bitfield-Mask: 0x01)                           */
/* ========================================================  INTSET  ========================================================= */
#define IOSLAVE_INTSET_XCMPWR_Pos         (9UL)                     /*!< XCMPWR (Bit 9)                                        */
#define IOSLAVE_INTSET_XCMPWR_Msk         (0x200UL)                 /*!< XCMPWR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSET_XCMPWF_Pos         (8UL)                     /*!< XCMPWF (Bit 8)                                        */
#define IOSLAVE_INTSET_XCMPWF_Msk         (0x100UL)                 /*!< XCMPWF (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSET_XCMPRR_Pos         (7UL)                     /*!< XCMPRR (Bit 7)                                        */
#define IOSLAVE_INTSET_XCMPRR_Msk         (0x80UL)                  /*!< XCMPRR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSET_XCMPRF_Pos         (6UL)                     /*!< XCMPRF (Bit 6)                                        */
#define IOSLAVE_INTSET_XCMPRF_Msk         (0x40UL)                  /*!< XCMPRF (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSET_IOINTW_Pos         (5UL)                     /*!< IOINTW (Bit 5)                                        */
#define IOSLAVE_INTSET_IOINTW_Msk         (0x20UL)                  /*!< IOINTW (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSET_GENAD_Pos          (4UL)                     /*!< GENAD (Bit 4)                                         */
#define IOSLAVE_INTSET_GENAD_Msk          (0x10UL)                  /*!< GENAD (Bitfield-Mask: 0x01)                           */
#define IOSLAVE_INTSET_FRDERR_Pos         (3UL)                     /*!< FRDERR (Bit 3)                                        */
#define IOSLAVE_INTSET_FRDERR_Msk         (0x8UL)                   /*!< FRDERR (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSET_FUNDFL_Pos         (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define IOSLAVE_INTSET_FUNDFL_Msk         (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define IOSLAVE_INTSET_FOVFL_Pos          (1UL)                     /*!< FOVFL (Bit 1)                                         */
#define IOSLAVE_INTSET_FOVFL_Msk          (0x2UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define IOSLAVE_INTSET_FSIZE_Pos          (0UL)                     /*!< FSIZE (Bit 0)                                         */
#define IOSLAVE_INTSET_FSIZE_Msk          (0x1UL)                   /*!< FSIZE (Bitfield-Mask: 0x01)                           */
/* ======================================================  REGACCINTEN  ====================================================== */
#define IOSLAVE_REGACCINTEN_REGACC_Pos    (0UL)                     /*!< REGACC (Bit 0)                                        */
#define IOSLAVE_REGACCINTEN_REGACC_Msk    (0xffffffffUL)            /*!< REGACC (Bitfield-Mask: 0xffffffff)                    */
/* =====================================================  REGACCINTSTAT  ===================================================== */
#define IOSLAVE_REGACCINTSTAT_REGACC_Pos  (0UL)                     /*!< REGACC (Bit 0)                                        */
#define IOSLAVE_REGACCINTSTAT_REGACC_Msk  (0xffffffffUL)            /*!< REGACC (Bitfield-Mask: 0xffffffff)                    */
/* =====================================================  REGACCINTCLR  ====================================================== */
#define IOSLAVE_REGACCINTCLR_REGACC_Pos   (0UL)                     /*!< REGACC (Bit 0)                                        */
#define IOSLAVE_REGACCINTCLR_REGACC_Msk   (0xffffffffUL)            /*!< REGACC (Bitfield-Mask: 0xffffffff)                    */
/* =====================================================  REGACCINTSET  ====================================================== */
#define IOSLAVE_REGACCINTSET_REGACC_Pos   (0UL)                     /*!< REGACC (Bit 0)                                        */
#define IOSLAVE_REGACCINTSET_REGACC_Msk   (0xffffffffUL)            /*!< REGACC (Bitfield-Mask: 0xffffffff)                    */


/* =========================================================================================================================== */
/* ================                                          MCUCTRL                                          ================ */
/* =========================================================================================================================== */

/* =======================================================  CHIP_INFO  ======================================================= */
#define MCUCTRL_CHIP_INFO_PARTNUM_Pos     (0UL)                     /*!< PARTNUM (Bit 0)                                       */
#define MCUCTRL_CHIP_INFO_PARTNUM_Msk     (0xffffffffUL)            /*!< PARTNUM (Bitfield-Mask: 0xffffffff)                   */
/* ========================================================  CHIPID0  ======================================================== */
#define MCUCTRL_CHIPID0_VALUE_Pos         (0UL)                     /*!< VALUE (Bit 0)                                         */
#define MCUCTRL_CHIPID0_VALUE_Msk         (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  CHIPID1  ======================================================== */
#define MCUCTRL_CHIPID1_VALUE_Pos         (0UL)                     /*!< VALUE (Bit 0)                                         */
#define MCUCTRL_CHIPID1_VALUE_Msk         (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* ========================================================  CHIPREV  ======================================================== */
#define MCUCTRL_CHIPREV_REVMAJ_Pos        (4UL)                     /*!< REVMAJ (Bit 4)                                        */
#define MCUCTRL_CHIPREV_REVMAJ_Msk        (0xf0UL)                  /*!< REVMAJ (Bitfield-Mask: 0x0f)                          */
#define MCUCTRL_CHIPREV_REVMIN_Pos        (0UL)                     /*!< REVMIN (Bit 0)                                        */
#define MCUCTRL_CHIPREV_REVMIN_Msk        (0xfUL)                   /*!< REVMIN (Bitfield-Mask: 0x0f)                          */
/* =======================================================  VENDORID  ======================================================== */
#define MCUCTRL_VENDORID_VALUE_Pos        (0UL)                     /*!< VALUE (Bit 0)                                         */
#define MCUCTRL_VENDORID_VALUE_Msk        (0xffffffffUL)            /*!< VALUE (Bitfield-Mask: 0xffffffff)                     */
/* =======================================================  DEBUGGER  ======================================================== */
#define MCUCTRL_DEBUGGER_LOCKOUT_Pos      (0UL)                     /*!< LOCKOUT (Bit 0)                                       */
#define MCUCTRL_DEBUGGER_LOCKOUT_Msk      (0x1UL)                   /*!< LOCKOUT (Bitfield-Mask: 0x01)                         */
/* =========================================================  BUCK  ========================================================== */
#define MCUCTRL_BUCK_MEMBUCKRST_Pos       (7UL)                     /*!< MEMBUCKRST (Bit 7)                                    */
#define MCUCTRL_BUCK_MEMBUCKRST_Msk       (0x80UL)                  /*!< MEMBUCKRST (Bitfield-Mask: 0x01)                      */
#define MCUCTRL_BUCK_COREBUCKRST_Pos      (6UL)                     /*!< COREBUCKRST (Bit 6)                                   */
#define MCUCTRL_BUCK_COREBUCKRST_Msk      (0x40UL)                  /*!< COREBUCKRST (Bitfield-Mask: 0x01)                     */
#define MCUCTRL_BUCK_BYPBUCKMEM_Pos       (5UL)                     /*!< BYPBUCKMEM (Bit 5)                                    */
#define MCUCTRL_BUCK_BYPBUCKMEM_Msk       (0x20UL)                  /*!< BYPBUCKMEM (Bitfield-Mask: 0x01)                      */
#define MCUCTRL_BUCK_MEMBUCKPWD_Pos       (4UL)                     /*!< MEMBUCKPWD (Bit 4)                                    */
#define MCUCTRL_BUCK_MEMBUCKPWD_Msk       (0x10UL)                  /*!< MEMBUCKPWD (Bitfield-Mask: 0x01)                      */
#define MCUCTRL_BUCK_SLEEPBUCKANA_Pos     (3UL)                     /*!< SLEEPBUCKANA (Bit 3)                                  */
#define MCUCTRL_BUCK_SLEEPBUCKANA_Msk     (0x8UL)                   /*!< SLEEPBUCKANA (Bitfield-Mask: 0x01)                    */
#define MCUCTRL_BUCK_COREBUCKPWD_Pos      (2UL)                     /*!< COREBUCKPWD (Bit 2)                                   */
#define MCUCTRL_BUCK_COREBUCKPWD_Msk      (0x4UL)                   /*!< COREBUCKPWD (Bitfield-Mask: 0x01)                     */
#define MCUCTRL_BUCK_BYPBUCKCORE_Pos      (1UL)                     /*!< BYPBUCKCORE (Bit 1)                                   */
#define MCUCTRL_BUCK_BYPBUCKCORE_Msk      (0x2UL)                   /*!< BYPBUCKCORE (Bitfield-Mask: 0x01)                     */
#define MCUCTRL_BUCK_BUCKSWE_Pos          (0UL)                     /*!< BUCKSWE (Bit 0)                                       */
#define MCUCTRL_BUCK_BUCKSWE_Msk          (0x1UL)                   /*!< BUCKSWE (Bitfield-Mask: 0x01)                         */
/* =========================================================  BUCK3  ========================================================= */
#define MCUCTRL_BUCK3_MEMBUCKLOTON_Pos    (18UL)                    /*!< MEMBUCKLOTON (Bit 18)                                 */
#define MCUCTRL_BUCK3_MEMBUCKLOTON_Msk    (0x3c0000UL)              /*!< MEMBUCKLOTON (Bitfield-Mask: 0x0f)                    */
#define MCUCTRL_BUCK3_MEMBUCKBURSTEN_Pos  (17UL)                    /*!< MEMBUCKBURSTEN (Bit 17)                               */
#define MCUCTRL_BUCK3_MEMBUCKBURSTEN_Msk  (0x20000UL)               /*!< MEMBUCKBURSTEN (Bitfield-Mask: 0x01)                  */
#define MCUCTRL_BUCK3_MEMBUCKZXTRIM_Pos   (13UL)                    /*!< MEMBUCKZXTRIM (Bit 13)                                */
#define MCUCTRL_BUCK3_MEMBUCKZXTRIM_Msk   (0x1e000UL)               /*!< MEMBUCKZXTRIM (Bitfield-Mask: 0x0f)                   */
#define MCUCTRL_BUCK3_MEMBUCKHYSTTRIM_Pos (11UL)                    /*!< MEMBUCKHYSTTRIM (Bit 11)                              */
#define MCUCTRL_BUCK3_MEMBUCKHYSTTRIM_Msk (0x1800UL)                /*!< MEMBUCKHYSTTRIM (Bitfield-Mask: 0x03)                 */
#define MCUCTRL_BUCK3_COREBUCKLOTON_Pos   (7UL)                     /*!< COREBUCKLOTON (Bit 7)                                 */
#define MCUCTRL_BUCK3_COREBUCKLOTON_Msk   (0x780UL)                 /*!< COREBUCKLOTON (Bitfield-Mask: 0x0f)                   */
#define MCUCTRL_BUCK3_COREBUCKBURSTEN_Pos (6UL)                     /*!< COREBUCKBURSTEN (Bit 6)                               */
#define MCUCTRL_BUCK3_COREBUCKBURSTEN_Msk (0x40UL)                  /*!< COREBUCKBURSTEN (Bitfield-Mask: 0x01)                 */
#define MCUCTRL_BUCK3_COREBUCKZXTRIM_Pos  (2UL)                     /*!< COREBUCKZXTRIM (Bit 2)                                */
#define MCUCTRL_BUCK3_COREBUCKZXTRIM_Msk  (0x3cUL)                  /*!< COREBUCKZXTRIM (Bitfield-Mask: 0x0f)                  */
#define MCUCTRL_BUCK3_COREBUCKHYSTTRIM_Pos (0UL)                    /*!< COREBUCKHYSTTRIM (Bit 0)                              */
#define MCUCTRL_BUCK3_COREBUCKHYSTTRIM_Msk (0x3UL)                  /*!< COREBUCKHYSTTRIM (Bitfield-Mask: 0x03)                */
/* ========================================================  LDOREG1  ======================================================== */
#define MCUCTRL_LDOREG1_CORELDOIBSTRM_Pos (20UL)                    /*!< CORELDOIBSTRM (Bit 20)                                */
#define MCUCTRL_LDOREG1_CORELDOIBSTRM_Msk (0x100000UL)              /*!< CORELDOIBSTRM (Bitfield-Mask: 0x01)                   */
#define MCUCTRL_LDOREG1_CORELDOLPTRIM_Pos (14UL)                    /*!< CORELDOLPTRIM (Bit 14)                                */
#define MCUCTRL_LDOREG1_CORELDOLPTRIM_Msk (0xfc000UL)               /*!< CORELDOLPTRIM (Bitfield-Mask: 0x3f)                   */
#define MCUCTRL_LDOREG1_TRIMCORELDOR3_Pos (10UL)                    /*!< TRIMCORELDOR3 (Bit 10)                                */
#define MCUCTRL_LDOREG1_TRIMCORELDOR3_Msk (0x3c00UL)                /*!< TRIMCORELDOR3 (Bitfield-Mask: 0x0f)                   */
#define MCUCTRL_LDOREG1_TRIMCORELDOR1_Pos (0UL)                     /*!< TRIMCORELDOR1 (Bit 0)                                 */
#define MCUCTRL_LDOREG1_TRIMCORELDOR1_Msk (0x3ffUL)                 /*!< TRIMCORELDOR1 (Bitfield-Mask: 0x3ff)                  */
/* ========================================================  LDOREG3  ======================================================== */
#define MCUCTRL_LDOREG3_TRIMMEMLDOR1_Pos  (12UL)                    /*!< TRIMMEMLDOR1 (Bit 12)                                 */
#define MCUCTRL_LDOREG3_TRIMMEMLDOR1_Msk  (0x3f000UL)               /*!< TRIMMEMLDOR1 (Bitfield-Mask: 0x3f)                    */
#define MCUCTRL_LDOREG3_MEMLDOLPALTTRIM_Pos (6UL)                   /*!< MEMLDOLPALTTRIM (Bit 6)                               */
#define MCUCTRL_LDOREG3_MEMLDOLPALTTRIM_Msk (0xfc0UL)               /*!< MEMLDOLPALTTRIM (Bitfield-Mask: 0x3f)                 */
#define MCUCTRL_LDOREG3_MEMLDOLPTRIM_Pos  (0UL)                     /*!< MEMLDOLPTRIM (Bit 0)                                  */
#define MCUCTRL_LDOREG3_MEMLDOLPTRIM_Msk  (0x3fUL)                  /*!< MEMLDOLPTRIM (Bitfield-Mask: 0x3f)                    */
/* ======================================================  BODPORCTRL  ======================================================= */
#define MCUCTRL_BODPORCTRL_BODEXTREFSEL_Pos (3UL)                   /*!< BODEXTREFSEL (Bit 3)                                  */
#define MCUCTRL_BODPORCTRL_BODEXTREFSEL_Msk (0x8UL)                 /*!< BODEXTREFSEL (Bitfield-Mask: 0x01)                    */
#define MCUCTRL_BODPORCTRL_PDREXTREFSEL_Pos (2UL)                   /*!< PDREXTREFSEL (Bit 2)                                  */
#define MCUCTRL_BODPORCTRL_PDREXTREFSEL_Msk (0x4UL)                 /*!< PDREXTREFSEL (Bitfield-Mask: 0x01)                    */
#define MCUCTRL_BODPORCTRL_PWDBOD_Pos     (1UL)                     /*!< PWDBOD (Bit 1)                                        */
#define MCUCTRL_BODPORCTRL_PWDBOD_Msk     (0x2UL)                   /*!< PWDBOD (Bitfield-Mask: 0x01)                          */
#define MCUCTRL_BODPORCTRL_PWDPDR_Pos     (0UL)                     /*!< PWDPDR (Bit 0)                                        */
#define MCUCTRL_BODPORCTRL_PWDPDR_Msk     (0x1UL)                   /*!< PWDPDR (Bitfield-Mask: 0x01)                          */
/* =======================================================  ADCPWRDLY  ======================================================= */
#define MCUCTRL_ADCPWRDLY_ADCPWR1_Pos     (8UL)                     /*!< ADCPWR1 (Bit 8)                                       */
#define MCUCTRL_ADCPWRDLY_ADCPWR1_Msk     (0xff00UL)                /*!< ADCPWR1 (Bitfield-Mask: 0xff)                         */
#define MCUCTRL_ADCPWRDLY_ADCPWR0_Pos     (0UL)                     /*!< ADCPWR0 (Bit 0)                                       */
#define MCUCTRL_ADCPWRDLY_ADCPWR0_Msk     (0xffUL)                  /*!< ADCPWR0 (Bitfield-Mask: 0xff)                         */
/* ========================================================  ADCCAL  ========================================================= */
#define MCUCTRL_ADCCAL_ADCCALIBRATED_Pos  (1UL)                     /*!< ADCCALIBRATED (Bit 1)                                 */
#define MCUCTRL_ADCCAL_ADCCALIBRATED_Msk  (0x2UL)                   /*!< ADCCALIBRATED (Bitfield-Mask: 0x01)                   */
#define MCUCTRL_ADCCAL_CALONPWRUP_Pos     (0UL)                     /*!< CALONPWRUP (Bit 0)                                    */
#define MCUCTRL_ADCCAL_CALONPWRUP_Msk     (0x1UL)                   /*!< CALONPWRUP (Bitfield-Mask: 0x01)                      */
/* ======================================================  ADCBATTLOAD  ====================================================== */
#define MCUCTRL_ADCBATTLOAD_BATTLOAD_Pos  (0UL)                     /*!< BATTLOAD (Bit 0)                                      */
#define MCUCTRL_ADCBATTLOAD_BATTLOAD_Msk  (0x1UL)                   /*!< BATTLOAD (Bitfield-Mask: 0x01)                        */
/* =======================================================  BUCKTRIM  ======================================================== */
#define MCUCTRL_BUCKTRIM_RSVD2_Pos        (24UL)                    /*!< RSVD2 (Bit 24)                                        */
#define MCUCTRL_BUCKTRIM_RSVD2_Msk        (0x3f000000UL)            /*!< RSVD2 (Bitfield-Mask: 0x3f)                           */
#define MCUCTRL_BUCKTRIM_COREBUCKR1_HI_Pos (16UL)                   /*!< COREBUCKR1_HI (Bit 16)                                */
#define MCUCTRL_BUCKTRIM_COREBUCKR1_HI_Msk (0xf0000UL)              /*!< COREBUCKR1_HI (Bitfield-Mask: 0x0f)                   */
#define MCUCTRL_BUCKTRIM_COREBUCKR1_LO_Pos (8UL)                    /*!< COREBUCKR1_LO (Bit 8)                                 */
#define MCUCTRL_BUCKTRIM_COREBUCKR1_LO_Msk (0x3f00UL)               /*!< COREBUCKR1_LO (Bitfield-Mask: 0x3f)                   */
#define MCUCTRL_BUCKTRIM_MEMBUCKR1_Pos    (0UL)                     /*!< MEMBUCKR1 (Bit 0)                                     */
#define MCUCTRL_BUCKTRIM_MEMBUCKR1_Msk    (0x3fUL)                  /*!< MEMBUCKR1 (Bitfield-Mask: 0x3f)                       */
/* ======================================================  XTALGENCTRL  ====================================================== */
#define MCUCTRL_XTALGENCTRL_XTALKSBIASTRIM_Pos (8UL)                /*!< XTALKSBIASTRIM (Bit 8)                                */
#define MCUCTRL_XTALGENCTRL_XTALKSBIASTRIM_Msk (0x3f00UL)           /*!< XTALKSBIASTRIM (Bitfield-Mask: 0x3f)                  */
#define MCUCTRL_XTALGENCTRL_XTALBIASTRIM_Pos (2UL)                  /*!< XTALBIASTRIM (Bit 2)                                  */
#define MCUCTRL_XTALGENCTRL_XTALBIASTRIM_Msk (0xfcUL)               /*!< XTALBIASTRIM (Bitfield-Mask: 0x3f)                    */
#define MCUCTRL_XTALGENCTRL_ACWARMUP_Pos  (0UL)                     /*!< ACWARMUP (Bit 0)                                      */
#define MCUCTRL_XTALGENCTRL_ACWARMUP_Msk  (0x3UL)                   /*!< ACWARMUP (Bitfield-Mask: 0x03)                        */
/* =====================================================  BOOTLOADERLOW  ===================================================== */
#define MCUCTRL_BOOTLOADERLOW_VALUE_Pos   (0UL)                     /*!< VALUE (Bit 0)                                         */
#define MCUCTRL_BOOTLOADERLOW_VALUE_Msk   (0x1UL)                   /*!< VALUE (Bitfield-Mask: 0x01)                           */
/* ======================================================  SHADOWVALID  ====================================================== */
#define MCUCTRL_SHADOWVALID_BL_DSLEEP_Pos (1UL)                     /*!< BL_DSLEEP (Bit 1)                                     */
#define MCUCTRL_SHADOWVALID_BL_DSLEEP_Msk (0x2UL)                   /*!< BL_DSLEEP (Bitfield-Mask: 0x01)                       */
#define MCUCTRL_SHADOWVALID_VALID_Pos     (0UL)                     /*!< VALID (Bit 0)                                         */
#define MCUCTRL_SHADOWVALID_VALID_Msk     (0x1UL)                   /*!< VALID (Bitfield-Mask: 0x01)                           */
/* ====================================================  ICODEFAULTADDR  ===================================================== */
#define MCUCTRL_ICODEFAULTADDR_ADDR_Pos   (0UL)                     /*!< ADDR (Bit 0)                                          */
#define MCUCTRL_ICODEFAULTADDR_ADDR_Msk   (0xffffffffUL)            /*!< ADDR (Bitfield-Mask: 0xffffffff)                      */
/* ====================================================  DCODEFAULTADDR  ===================================================== */
#define MCUCTRL_DCODEFAULTADDR_ADDR_Pos   (0UL)                     /*!< ADDR (Bit 0)                                          */
#define MCUCTRL_DCODEFAULTADDR_ADDR_Msk   (0xffffffffUL)            /*!< ADDR (Bitfield-Mask: 0xffffffff)                      */
/* =====================================================  SYSFAULTADDR  ====================================================== */
#define MCUCTRL_SYSFAULTADDR_ADDR_Pos     (0UL)                     /*!< ADDR (Bit 0)                                          */
#define MCUCTRL_SYSFAULTADDR_ADDR_Msk     (0xffffffffUL)            /*!< ADDR (Bitfield-Mask: 0xffffffff)                      */
/* ======================================================  FAULTSTATUS  ====================================================== */
#define MCUCTRL_FAULTSTATUS_SYS_Pos       (2UL)                     /*!< SYS (Bit 2)                                           */
#define MCUCTRL_FAULTSTATUS_SYS_Msk       (0x4UL)                   /*!< SYS (Bitfield-Mask: 0x01)                             */
#define MCUCTRL_FAULTSTATUS_DCODE_Pos     (1UL)                     /*!< DCODE (Bit 1)                                         */
#define MCUCTRL_FAULTSTATUS_DCODE_Msk     (0x2UL)                   /*!< DCODE (Bitfield-Mask: 0x01)                           */
#define MCUCTRL_FAULTSTATUS_ICODE_Pos     (0UL)                     /*!< ICODE (Bit 0)                                         */
#define MCUCTRL_FAULTSTATUS_ICODE_Msk     (0x1UL)                   /*!< ICODE (Bitfield-Mask: 0x01)                           */
/* ====================================================  FAULTCAPTUREEN  ===================================================== */
#define MCUCTRL_FAULTCAPTUREEN_ENABLE_Pos (0UL)                     /*!< ENABLE (Bit 0)                                        */
#define MCUCTRL_FAULTCAPTUREEN_ENABLE_Msk (0x1UL)                   /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* =========================================================  DBGR1  ========================================================= */
#define MCUCTRL_DBGR1_ONETO8_Pos          (0UL)                     /*!< ONETO8 (Bit 0)                                        */
#define MCUCTRL_DBGR1_ONETO8_Msk          (0xffffffffUL)            /*!< ONETO8 (Bitfield-Mask: 0xffffffff)                    */
/* =========================================================  DBGR2  ========================================================= */
#define MCUCTRL_DBGR2_COOLCODE_Pos        (0UL)                     /*!< COOLCODE (Bit 0)                                      */
#define MCUCTRL_DBGR2_COOLCODE_Msk        (0xffffffffUL)            /*!< COOLCODE (Bitfield-Mask: 0xffffffff)                  */
/* =======================================================  PMUENABLE  ======================================================= */
#define MCUCTRL_PMUENABLE_ENABLE_Pos      (0UL)                     /*!< ENABLE (Bit 0)                                        */
#define MCUCTRL_PMUENABLE_ENABLE_Msk      (0x1UL)                   /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* =======================================================  TPIUCTRL  ======================================================== */
#define MCUCTRL_TPIUCTRL_CLKSEL_Pos       (8UL)                     /*!< CLKSEL (Bit 8)                                        */
#define MCUCTRL_TPIUCTRL_CLKSEL_Msk       (0x700UL)                 /*!< CLKSEL (Bitfield-Mask: 0x07)                          */
#define MCUCTRL_TPIUCTRL_ENABLE_Pos       (0UL)                     /*!< ENABLE (Bit 0)                                        */
#define MCUCTRL_TPIUCTRL_ENABLE_Msk       (0x1UL)                   /*!< ENABLE (Bitfield-Mask: 0x01)                          */


/* =========================================================================================================================== */
/* ================                                            PDM                                            ================ */
/* =========================================================================================================================== */

/* =========================================================  PCFG  ========================================================== */
#define PDM_PCFG_LRSWAP_Pos               (31UL)                    /*!< LRSWAP (Bit 31)                                       */
#define PDM_PCFG_LRSWAP_Msk               (0x80000000UL)            /*!< LRSWAP (Bitfield-Mask: 0x01)                          */
#define PDM_PCFG_PGARIGHT_Pos             (27UL)                    /*!< PGARIGHT (Bit 27)                                     */
#define PDM_PCFG_PGARIGHT_Msk             (0x78000000UL)            /*!< PGARIGHT (Bitfield-Mask: 0x0f)                        */
#define PDM_PCFG_PGALEFT_Pos              (23UL)                    /*!< PGALEFT (Bit 23)                                      */
#define PDM_PCFG_PGALEFT_Msk              (0x7800000UL)             /*!< PGALEFT (Bitfield-Mask: 0x0f)                         */
#define PDM_PCFG_MCLKDIV_Pos              (17UL)                    /*!< MCLKDIV (Bit 17)                                      */
#define PDM_PCFG_MCLKDIV_Msk              (0x60000UL)               /*!< MCLKDIV (Bitfield-Mask: 0x03)                         */
#define PDM_PCFG_SINCRATE_Pos             (10UL)                    /*!< SINCRATE (Bit 10)                                     */
#define PDM_PCFG_SINCRATE_Msk             (0x1fc00UL)               /*!< SINCRATE (Bitfield-Mask: 0x7f)                        */
#define PDM_PCFG_ADCHPD_Pos               (9UL)                     /*!< ADCHPD (Bit 9)                                        */
#define PDM_PCFG_ADCHPD_Msk               (0x200UL)                 /*!< ADCHPD (Bitfield-Mask: 0x01)                          */
#define PDM_PCFG_HPCUTOFF_Pos             (5UL)                     /*!< HPCUTOFF (Bit 5)                                      */
#define PDM_PCFG_HPCUTOFF_Msk             (0x1e0UL)                 /*!< HPCUTOFF (Bitfield-Mask: 0x0f)                        */
#define PDM_PCFG_CYCLES_Pos               (2UL)                     /*!< CYCLES (Bit 2)                                        */
#define PDM_PCFG_CYCLES_Msk               (0x1cUL)                  /*!< CYCLES (Bitfield-Mask: 0x07)                          */
#define PDM_PCFG_SOFTMUTE_Pos             (1UL)                     /*!< SOFTMUTE (Bit 1)                                      */
#define PDM_PCFG_SOFTMUTE_Msk             (0x2UL)                   /*!< SOFTMUTE (Bitfield-Mask: 0x01)                        */
#define PDM_PCFG_PDMCORE_Pos              (0UL)                     /*!< PDMCORE (Bit 0)                                       */
#define PDM_PCFG_PDMCORE_Msk              (0x1UL)                   /*!< PDMCORE (Bitfield-Mask: 0x01)                         */
/* =========================================================  VCFG  ========================================================== */
#define PDM_VCFG_IOCLKEN_Pos              (31UL)                    /*!< IOCLKEN (Bit 31)                                      */
#define PDM_VCFG_IOCLKEN_Msk              (0x80000000UL)            /*!< IOCLKEN (Bitfield-Mask: 0x01)                         */
#define PDM_VCFG_RSTB_Pos                 (30UL)                    /*!< RSTB (Bit 30)                                         */
#define PDM_VCFG_RSTB_Msk                 (0x40000000UL)            /*!< RSTB (Bitfield-Mask: 0x01)                            */
#define PDM_VCFG_PDMCLKSEL_Pos            (27UL)                    /*!< PDMCLKSEL (Bit 27)                                    */
#define PDM_VCFG_PDMCLKSEL_Msk            (0x38000000UL)            /*!< PDMCLKSEL (Bitfield-Mask: 0x07)                       */
#define PDM_VCFG_PDMCLK_Pos               (26UL)                    /*!< PDMCLK (Bit 26)                                       */
#define PDM_VCFG_PDMCLK_Msk               (0x4000000UL)             /*!< PDMCLK (Bitfield-Mask: 0x01)                          */
#define PDM_VCFG_I2SMODE_Pos              (20UL)                    /*!< I2SMODE (Bit 20)                                      */
#define PDM_VCFG_I2SMODE_Msk              (0x100000UL)              /*!< I2SMODE (Bitfield-Mask: 0x01)                         */
#define PDM_VCFG_BCLKINV_Pos              (19UL)                    /*!< BCLKINV (Bit 19)                                      */
#define PDM_VCFG_BCLKINV_Msk              (0x80000UL)               /*!< BCLKINV (Bitfield-Mask: 0x01)                         */
#define PDM_VCFG_DMICKDEL_Pos             (17UL)                    /*!< DMICKDEL (Bit 17)                                     */
#define PDM_VCFG_DMICKDEL_Msk             (0x20000UL)               /*!< DMICKDEL (Bitfield-Mask: 0x01)                        */
#define PDM_VCFG_SELAP_Pos                (16UL)                    /*!< SELAP (Bit 16)                                        */
#define PDM_VCFG_SELAP_Msk                (0x10000UL)               /*!< SELAP (Bitfield-Mask: 0x01)                           */
#define PDM_VCFG_PCMPACK_Pos              (8UL)                     /*!< PCMPACK (Bit 8)                                       */
#define PDM_VCFG_PCMPACK_Msk              (0x100UL)                 /*!< PCMPACK (Bitfield-Mask: 0x01)                         */
#define PDM_VCFG_CHSET_Pos                (3UL)                     /*!< CHSET (Bit 3)                                         */
#define PDM_VCFG_CHSET_Msk                (0x18UL)                  /*!< CHSET (Bitfield-Mask: 0x03)                           */
/* ==========================================================  FR  =========================================================== */
#define PDM_FR_FIFOCNT_Pos                (0UL)                     /*!< FIFOCNT (Bit 0)                                       */
#define PDM_FR_FIFOCNT_Msk                (0x1ffUL)                 /*!< FIFOCNT (Bitfield-Mask: 0x1ff)                        */
/* ==========================================================  FRD  ========================================================== */
#define PDM_FRD_FIFOREAD_Pos              (0UL)                     /*!< FIFOREAD (Bit 0)                                      */
#define PDM_FRD_FIFOREAD_Msk              (0xffffffffUL)            /*!< FIFOREAD (Bitfield-Mask: 0xffffffff)                  */
/* =========================================================  FLUSH  ========================================================= */
#define PDM_FLUSH_FIFOFLUSH_Pos           (0UL)                     /*!< FIFOFLUSH (Bit 0)                                     */
#define PDM_FLUSH_FIFOFLUSH_Msk           (0x1UL)                   /*!< FIFOFLUSH (Bitfield-Mask: 0x01)                       */
/* =========================================================  FTHR  ========================================================== */
#define PDM_FTHR_FIFOTHR_Pos              (0UL)                     /*!< FIFOTHR (Bit 0)                                       */
#define PDM_FTHR_FIFOTHR_Msk              (0xffUL)                  /*!< FIFOTHR (Bitfield-Mask: 0xff)                         */
/* =========================================================  INTEN  ========================================================= */
#define PDM_INTEN_UNDFL_Pos               (2UL)                     /*!< UNDFL (Bit 2)                                         */
#define PDM_INTEN_UNDFL_Msk               (0x4UL)                   /*!< UNDFL (Bitfield-Mask: 0x01)                           */
#define PDM_INTEN_OVF_Pos                 (1UL)                     /*!< OVF (Bit 1)                                           */
#define PDM_INTEN_OVF_Msk                 (0x2UL)                   /*!< OVF (Bitfield-Mask: 0x01)                             */
#define PDM_INTEN_THR_Pos                 (0UL)                     /*!< THR (Bit 0)                                           */
#define PDM_INTEN_THR_Msk                 (0x1UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
/* ========================================================  INTSTAT  ======================================================== */
#define PDM_INTSTAT_UNDFL_Pos             (2UL)                     /*!< UNDFL (Bit 2)                                         */
#define PDM_INTSTAT_UNDFL_Msk             (0x4UL)                   /*!< UNDFL (Bitfield-Mask: 0x01)                           */
#define PDM_INTSTAT_OVF_Pos               (1UL)                     /*!< OVF (Bit 1)                                           */
#define PDM_INTSTAT_OVF_Msk               (0x2UL)                   /*!< OVF (Bitfield-Mask: 0x01)                             */
#define PDM_INTSTAT_THR_Pos               (0UL)                     /*!< THR (Bit 0)                                           */
#define PDM_INTSTAT_THR_Msk               (0x1UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
/* ========================================================  INTCLR  ========================================================= */
#define PDM_INTCLR_UNDFL_Pos              (2UL)                     /*!< UNDFL (Bit 2)                                         */
#define PDM_INTCLR_UNDFL_Msk              (0x4UL)                   /*!< UNDFL (Bitfield-Mask: 0x01)                           */
#define PDM_INTCLR_OVF_Pos                (1UL)                     /*!< OVF (Bit 1)                                           */
#define PDM_INTCLR_OVF_Msk                (0x2UL)                   /*!< OVF (Bitfield-Mask: 0x01)                             */
#define PDM_INTCLR_THR_Pos                (0UL)                     /*!< THR (Bit 0)                                           */
#define PDM_INTCLR_THR_Msk                (0x1UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
/* ========================================================  INTSET  ========================================================= */
#define PDM_INTSET_UNDFL_Pos              (2UL)                     /*!< UNDFL (Bit 2)                                         */
#define PDM_INTSET_UNDFL_Msk              (0x4UL)                   /*!< UNDFL (Bitfield-Mask: 0x01)                           */
#define PDM_INTSET_OVF_Pos                (1UL)                     /*!< OVF (Bit 1)                                           */
#define PDM_INTSET_OVF_Msk                (0x2UL)                   /*!< OVF (Bitfield-Mask: 0x01)                             */
#define PDM_INTSET_THR_Pos                (0UL)                     /*!< THR (Bit 0)                                           */
#define PDM_INTSET_THR_Msk                (0x1UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */


/* =========================================================================================================================== */
/* ================                                          PWRCTRL                                          ================ */
/* =========================================================================================================================== */

/* =======================================================  SUPPLYSRC  ======================================================= */
#define PWRCTRL_SUPPLYSRC_SWITCH_LDO_IN_SLEEP_Pos (2UL)             /*!< SWITCH_LDO_IN_SLEEP (Bit 2)                           */
#define PWRCTRL_SUPPLYSRC_SWITCH_LDO_IN_SLEEP_Msk (0x4UL)           /*!< SWITCH_LDO_IN_SLEEP (Bitfield-Mask: 0x01)             */
#define PWRCTRL_SUPPLYSRC_COREBUCKEN_Pos  (1UL)                     /*!< COREBUCKEN (Bit 1)                                    */
#define PWRCTRL_SUPPLYSRC_COREBUCKEN_Msk  (0x2UL)                   /*!< COREBUCKEN (Bitfield-Mask: 0x01)                      */
#define PWRCTRL_SUPPLYSRC_MEMBUCKEN_Pos   (0UL)                     /*!< MEMBUCKEN (Bit 0)                                     */
#define PWRCTRL_SUPPLYSRC_MEMBUCKEN_Msk   (0x1UL)                   /*!< MEMBUCKEN (Bitfield-Mask: 0x01)                       */
/* ======================================================  POWERSTATUS  ====================================================== */
#define PWRCTRL_POWERSTATUS_COREBUCKON_Pos (1UL)                    /*!< COREBUCKON (Bit 1)                                    */
#define PWRCTRL_POWERSTATUS_COREBUCKON_Msk (0x2UL)                  /*!< COREBUCKON (Bitfield-Mask: 0x01)                      */
#define PWRCTRL_POWERSTATUS_MEMBUCKON_Pos (0UL)                     /*!< MEMBUCKON (Bit 0)                                     */
#define PWRCTRL_POWERSTATUS_MEMBUCKON_Msk (0x1UL)                   /*!< MEMBUCKON (Bitfield-Mask: 0x01)                       */
/* =======================================================  DEVICEEN  ======================================================== */
#define PWRCTRL_DEVICEEN_PWRPDM_Pos       (10UL)                    /*!< PWRPDM (Bit 10)                                       */
#define PWRCTRL_DEVICEEN_PWRPDM_Msk       (0x400UL)                 /*!< PWRPDM (Bitfield-Mask: 0x01)                          */
#define PWRCTRL_DEVICEEN_PWRADC_Pos       (9UL)                     /*!< PWRADC (Bit 9)                                        */
#define PWRCTRL_DEVICEEN_PWRADC_Msk       (0x200UL)                 /*!< PWRADC (Bitfield-Mask: 0x01)                          */
#define PWRCTRL_DEVICEEN_PWRUART1_Pos     (8UL)                     /*!< PWRUART1 (Bit 8)                                      */
#define PWRCTRL_DEVICEEN_PWRUART1_Msk     (0x100UL)                 /*!< PWRUART1 (Bitfield-Mask: 0x01)                        */
#define PWRCTRL_DEVICEEN_PWRUART0_Pos     (7UL)                     /*!< PWRUART0 (Bit 7)                                      */
#define PWRCTRL_DEVICEEN_PWRUART0_Msk     (0x80UL)                  /*!< PWRUART0 (Bitfield-Mask: 0x01)                        */
#define PWRCTRL_DEVICEEN_IO_MASTER5_Pos   (6UL)                     /*!< IO_MASTER5 (Bit 6)                                    */
#define PWRCTRL_DEVICEEN_IO_MASTER5_Msk   (0x40UL)                  /*!< IO_MASTER5 (Bitfield-Mask: 0x01)                      */
#define PWRCTRL_DEVICEEN_IO_MASTER4_Pos   (5UL)                     /*!< IO_MASTER4 (Bit 5)                                    */
#define PWRCTRL_DEVICEEN_IO_MASTER4_Msk   (0x20UL)                  /*!< IO_MASTER4 (Bitfield-Mask: 0x01)                      */
#define PWRCTRL_DEVICEEN_IO_MASTER3_Pos   (4UL)                     /*!< IO_MASTER3 (Bit 4)                                    */
#define PWRCTRL_DEVICEEN_IO_MASTER3_Msk   (0x10UL)                  /*!< IO_MASTER3 (Bitfield-Mask: 0x01)                      */
#define PWRCTRL_DEVICEEN_IO_MASTER2_Pos   (3UL)                     /*!< IO_MASTER2 (Bit 3)                                    */
#define PWRCTRL_DEVICEEN_IO_MASTER2_Msk   (0x8UL)                   /*!< IO_MASTER2 (Bitfield-Mask: 0x01)                      */
#define PWRCTRL_DEVICEEN_IO_MASTER1_Pos   (2UL)                     /*!< IO_MASTER1 (Bit 2)                                    */
#define PWRCTRL_DEVICEEN_IO_MASTER1_Msk   (0x4UL)                   /*!< IO_MASTER1 (Bitfield-Mask: 0x01)                      */
#define PWRCTRL_DEVICEEN_IO_MASTER0_Pos   (1UL)                     /*!< IO_MASTER0 (Bit 1)                                    */
#define PWRCTRL_DEVICEEN_IO_MASTER0_Msk   (0x2UL)                   /*!< IO_MASTER0 (Bitfield-Mask: 0x01)                      */
#define PWRCTRL_DEVICEEN_IO_SLAVE_Pos     (0UL)                     /*!< IO_SLAVE (Bit 0)                                      */
#define PWRCTRL_DEVICEEN_IO_SLAVE_Msk     (0x1UL)                   /*!< IO_SLAVE (Bitfield-Mask: 0x01)                        */
/* ====================================================  SRAMPWDINSLEEP  ===================================================== */
#define PWRCTRL_SRAMPWDINSLEEP_CACHE_PWD_SLP_Pos (31UL)             /*!< CACHE_PWD_SLP (Bit 31)                                */
#define PWRCTRL_SRAMPWDINSLEEP_CACHE_PWD_SLP_Msk (0x80000000UL)     /*!< CACHE_PWD_SLP (Bitfield-Mask: 0x01)                   */
#define PWRCTRL_SRAMPWDINSLEEP_SRAMSLEEPPOWERDOWN_Pos (0UL)         /*!< SRAMSLEEPPOWERDOWN (Bit 0)                            */
#define PWRCTRL_SRAMPWDINSLEEP_SRAMSLEEPPOWERDOWN_Msk (0x7ffUL)     /*!< SRAMSLEEPPOWERDOWN (Bitfield-Mask: 0x7ff)             */
/* =========================================================  MEMEN  ========================================================= */
#define PWRCTRL_MEMEN_CACHEB2_Pos         (31UL)                    /*!< CACHEB2 (Bit 31)                                      */
#define PWRCTRL_MEMEN_CACHEB2_Msk         (0x80000000UL)            /*!< CACHEB2 (Bitfield-Mask: 0x01)                         */
#define PWRCTRL_MEMEN_CACHEB0_Pos         (29UL)                    /*!< CACHEB0 (Bit 29)                                      */
#define PWRCTRL_MEMEN_CACHEB0_Msk         (0x20000000UL)            /*!< CACHEB0 (Bitfield-Mask: 0x01)                         */
#define PWRCTRL_MEMEN_FLASH1_Pos          (12UL)                    /*!< FLASH1 (Bit 12)                                       */
#define PWRCTRL_MEMEN_FLASH1_Msk          (0x1000UL)                /*!< FLASH1 (Bitfield-Mask: 0x01)                          */
#define PWRCTRL_MEMEN_FLASH0_Pos          (11UL)                    /*!< FLASH0 (Bit 11)                                       */
#define PWRCTRL_MEMEN_FLASH0_Msk          (0x800UL)                 /*!< FLASH0 (Bitfield-Mask: 0x01)                          */
#define PWRCTRL_MEMEN_SRAMEN_Pos          (0UL)                     /*!< SRAMEN (Bit 0)                                        */
#define PWRCTRL_MEMEN_SRAMEN_Msk          (0x7ffUL)                 /*!< SRAMEN (Bitfield-Mask: 0x7ff)                         */
/* ======================================================  PWRONSTATUS  ====================================================== */
#define PWRCTRL_PWRONSTATUS_PD_CACHEB2_Pos (21UL)                   /*!< PD_CACHEB2 (Bit 21)                                   */
#define PWRCTRL_PWRONSTATUS_PD_CACHEB2_Msk (0x200000UL)             /*!< PD_CACHEB2 (Bitfield-Mask: 0x01)                      */
#define PWRCTRL_PWRONSTATUS_PD_CACHEB0_Pos (19UL)                   /*!< PD_CACHEB0 (Bit 19)                                   */
#define PWRCTRL_PWRONSTATUS_PD_CACHEB0_Msk (0x80000UL)              /*!< PD_CACHEB0 (Bitfield-Mask: 0x01)                      */
#define PWRCTRL_PWRONSTATUS_PD_GRP7_SRAM_Pos (18UL)                 /*!< PD_GRP7_SRAM (Bit 18)                                 */
#define PWRCTRL_PWRONSTATUS_PD_GRP7_SRAM_Msk (0x40000UL)            /*!< PD_GRP7_SRAM (Bitfield-Mask: 0x01)                    */
#define PWRCTRL_PWRONSTATUS_PD_GRP6_SRAM_Pos (17UL)                 /*!< PD_GRP6_SRAM (Bit 17)                                 */
#define PWRCTRL_PWRONSTATUS_PD_GRP6_SRAM_Msk (0x20000UL)            /*!< PD_GRP6_SRAM (Bitfield-Mask: 0x01)                    */
#define PWRCTRL_PWRONSTATUS_PD_GRP5_SRAM_Pos (16UL)                 /*!< PD_GRP5_SRAM (Bit 16)                                 */
#define PWRCTRL_PWRONSTATUS_PD_GRP5_SRAM_Msk (0x10000UL)            /*!< PD_GRP5_SRAM (Bitfield-Mask: 0x01)                    */
#define PWRCTRL_PWRONSTATUS_PD_GRP4_SRAM_Pos (15UL)                 /*!< PD_GRP4_SRAM (Bit 15)                                 */
#define PWRCTRL_PWRONSTATUS_PD_GRP4_SRAM_Msk (0x8000UL)             /*!< PD_GRP4_SRAM (Bitfield-Mask: 0x01)                    */
#define PWRCTRL_PWRONSTATUS_PD_GRP3_SRAM_Pos (14UL)                 /*!< PD_GRP3_SRAM (Bit 14)                                 */
#define PWRCTRL_PWRONSTATUS_PD_GRP3_SRAM_Msk (0x4000UL)             /*!< PD_GRP3_SRAM (Bitfield-Mask: 0x01)                    */
#define PWRCTRL_PWRONSTATUS_PD_GRP2_SRAM_Pos (13UL)                 /*!< PD_GRP2_SRAM (Bit 13)                                 */
#define PWRCTRL_PWRONSTATUS_PD_GRP2_SRAM_Msk (0x2000UL)             /*!< PD_GRP2_SRAM (Bitfield-Mask: 0x01)                    */
#define PWRCTRL_PWRONSTATUS_PD_GRP1_SRAM_Pos (12UL)                 /*!< PD_GRP1_SRAM (Bit 12)                                 */
#define PWRCTRL_PWRONSTATUS_PD_GRP1_SRAM_Msk (0x1000UL)             /*!< PD_GRP1_SRAM (Bitfield-Mask: 0x01)                    */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM3_Pos (11UL)                /*!< PD_GRP0_SRAM3 (Bit 11)                                */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM3_Msk (0x800UL)             /*!< PD_GRP0_SRAM3 (Bitfield-Mask: 0x01)                   */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM2_Pos (10UL)                /*!< PD_GRP0_SRAM2 (Bit 10)                                */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM2_Msk (0x400UL)             /*!< PD_GRP0_SRAM2 (Bitfield-Mask: 0x01)                   */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM1_Pos (9UL)                 /*!< PD_GRP0_SRAM1 (Bit 9)                                 */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM1_Msk (0x200UL)             /*!< PD_GRP0_SRAM1 (Bitfield-Mask: 0x01)                   */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM0_Pos (8UL)                 /*!< PD_GRP0_SRAM0 (Bit 8)                                 */
#define PWRCTRL_PWRONSTATUS_PD_GRP0_SRAM0_Msk (0x100UL)             /*!< PD_GRP0_SRAM0 (Bitfield-Mask: 0x01)                   */
#define PWRCTRL_PWRONSTATUS_PDADC_Pos     (7UL)                     /*!< PDADC (Bit 7)                                         */
#define PWRCTRL_PWRONSTATUS_PDADC_Msk     (0x80UL)                  /*!< PDADC (Bitfield-Mask: 0x01)                           */
#define PWRCTRL_PWRONSTATUS_PD_FLAM1_Pos  (6UL)                     /*!< PD_FLAM1 (Bit 6)                                      */
#define PWRCTRL_PWRONSTATUS_PD_FLAM1_Msk  (0x40UL)                  /*!< PD_FLAM1 (Bitfield-Mask: 0x01)                        */
#define PWRCTRL_PWRONSTATUS_PD_FLAM0_Pos  (5UL)                     /*!< PD_FLAM0 (Bit 5)                                      */
#define PWRCTRL_PWRONSTATUS_PD_FLAM0_Msk  (0x20UL)                  /*!< PD_FLAM0 (Bitfield-Mask: 0x01)                        */
#define PWRCTRL_PWRONSTATUS_PD_PDM_Pos    (4UL)                     /*!< PD_PDM (Bit 4)                                        */
#define PWRCTRL_PWRONSTATUS_PD_PDM_Msk    (0x10UL)                  /*!< PD_PDM (Bitfield-Mask: 0x01)                          */
#define PWRCTRL_PWRONSTATUS_PDC_Pos       (3UL)                     /*!< PDC (Bit 3)                                           */
#define PWRCTRL_PWRONSTATUS_PDC_Msk       (0x8UL)                   /*!< PDC (Bitfield-Mask: 0x01)                             */
#define PWRCTRL_PWRONSTATUS_PDB_Pos       (2UL)                     /*!< PDB (Bit 2)                                           */
#define PWRCTRL_PWRONSTATUS_PDB_Msk       (0x4UL)                   /*!< PDB (Bitfield-Mask: 0x01)                             */
#define PWRCTRL_PWRONSTATUS_PDA_Pos       (1UL)                     /*!< PDA (Bit 1)                                           */
#define PWRCTRL_PWRONSTATUS_PDA_Msk       (0x2UL)                   /*!< PDA (Bitfield-Mask: 0x01)                             */
/* =======================================================  SRAMCTRL  ======================================================== */
#define PWRCTRL_SRAMCTRL_SRAM_MASTER_CLKGATE_Pos (2UL)              /*!< SRAM_MASTER_CLKGATE (Bit 2)                           */
#define PWRCTRL_SRAMCTRL_SRAM_MASTER_CLKGATE_Msk (0x4UL)            /*!< SRAM_MASTER_CLKGATE (Bitfield-Mask: 0x01)             */
#define PWRCTRL_SRAMCTRL_SRAM_CLKGATE_Pos (1UL)                     /*!< SRAM_CLKGATE (Bit 1)                                  */
#define PWRCTRL_SRAMCTRL_SRAM_CLKGATE_Msk (0x2UL)                   /*!< SRAM_CLKGATE (Bitfield-Mask: 0x01)                    */
#define PWRCTRL_SRAMCTRL_SRAM_LIGHT_SLEEP_Pos (0UL)                 /*!< SRAM_LIGHT_SLEEP (Bit 0)                              */
#define PWRCTRL_SRAMCTRL_SRAM_LIGHT_SLEEP_Msk (0x1UL)               /*!< SRAM_LIGHT_SLEEP (Bitfield-Mask: 0x01)                */
/* =======================================================  ADCSTATUS  ======================================================= */
#define PWRCTRL_ADCSTATUS_ADC_REFBUF_PWD_Pos (5UL)                  /*!< ADC_REFBUF_PWD (Bit 5)                                */
#define PWRCTRL_ADCSTATUS_ADC_REFBUF_PWD_Msk (0x20UL)               /*!< ADC_REFBUF_PWD (Bitfield-Mask: 0x01)                  */
#define PWRCTRL_ADCSTATUS_ADC_REFKEEP_PWD_Pos (4UL)                 /*!< ADC_REFKEEP_PWD (Bit 4)                               */
#define PWRCTRL_ADCSTATUS_ADC_REFKEEP_PWD_Msk (0x10UL)              /*!< ADC_REFKEEP_PWD (Bitfield-Mask: 0x01)                 */
#define PWRCTRL_ADCSTATUS_ADC_VBAT_PWD_Pos (3UL)                    /*!< ADC_VBAT_PWD (Bit 3)                                  */
#define PWRCTRL_ADCSTATUS_ADC_VBAT_PWD_Msk (0x8UL)                  /*!< ADC_VBAT_PWD (Bitfield-Mask: 0x01)                    */
#define PWRCTRL_ADCSTATUS_ADC_VPTAT_PWD_Pos (2UL)                   /*!< ADC_VPTAT_PWD (Bit 2)                                 */
#define PWRCTRL_ADCSTATUS_ADC_VPTAT_PWD_Msk (0x4UL)                 /*!< ADC_VPTAT_PWD (Bitfield-Mask: 0x01)                   */
#define PWRCTRL_ADCSTATUS_ADC_BGT_PWD_Pos (1UL)                     /*!< ADC_BGT_PWD (Bit 1)                                   */
#define PWRCTRL_ADCSTATUS_ADC_BGT_PWD_Msk (0x2UL)                   /*!< ADC_BGT_PWD (Bitfield-Mask: 0x01)                     */
#define PWRCTRL_ADCSTATUS_ADC_PWD_Pos     (0UL)                     /*!< ADC_PWD (Bit 0)                                       */
#define PWRCTRL_ADCSTATUS_ADC_PWD_Msk     (0x1UL)                   /*!< ADC_PWD (Bitfield-Mask: 0x01)                         */
/* ========================================================  MISCOPT  ======================================================== */
#define PWRCTRL_MISCOPT_DIS_LDOLPMODE_TIMERS_Pos (2UL)              /*!< DIS_LDOLPMODE_TIMERS (Bit 2)                          */
#define PWRCTRL_MISCOPT_DIS_LDOLPMODE_TIMERS_Msk (0x4UL)            /*!< DIS_LDOLPMODE_TIMERS (Bitfield-Mask: 0x01)            */


/* =========================================================================================================================== */
/* ================                                          RSTGEN                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define RSTGEN_CFG_WDREN_Pos              (1UL)                     /*!< WDREN (Bit 1)                                         */
#define RSTGEN_CFG_WDREN_Msk              (0x2UL)                   /*!< WDREN (Bitfield-Mask: 0x01)                           */
#define RSTGEN_CFG_BODHREN_Pos            (0UL)                     /*!< BODHREN (Bit 0)                                       */
#define RSTGEN_CFG_BODHREN_Msk            (0x1UL)                   /*!< BODHREN (Bitfield-Mask: 0x01)                         */
/* =========================================================  SWPOI  ========================================================= */
#define RSTGEN_SWPOI_SWPOIKEY_Pos         (0UL)                     /*!< SWPOIKEY (Bit 0)                                      */
#define RSTGEN_SWPOI_SWPOIKEY_Msk         (0xffUL)                  /*!< SWPOIKEY (Bitfield-Mask: 0xff)                        */
/* =========================================================  SWPOR  ========================================================= */
#define RSTGEN_SWPOR_SWPORKEY_Pos         (0UL)                     /*!< SWPORKEY (Bit 0)                                      */
#define RSTGEN_SWPOR_SWPORKEY_Msk         (0xffUL)                  /*!< SWPORKEY (Bitfield-Mask: 0xff)                        */
/* =========================================================  STAT  ========================================================== */
#define RSTGEN_STAT_WDRSTAT_Pos           (6UL)                     /*!< WDRSTAT (Bit 6)                                       */
#define RSTGEN_STAT_WDRSTAT_Msk           (0x40UL)                  /*!< WDRSTAT (Bitfield-Mask: 0x01)                         */
#define RSTGEN_STAT_DBGRSTAT_Pos          (5UL)                     /*!< DBGRSTAT (Bit 5)                                      */
#define RSTGEN_STAT_DBGRSTAT_Msk          (0x20UL)                  /*!< DBGRSTAT (Bitfield-Mask: 0x01)                        */
#define RSTGEN_STAT_POIRSTAT_Pos          (4UL)                     /*!< POIRSTAT (Bit 4)                                      */
#define RSTGEN_STAT_POIRSTAT_Msk          (0x10UL)                  /*!< POIRSTAT (Bitfield-Mask: 0x01)                        */
#define RSTGEN_STAT_SWRSTAT_Pos           (3UL)                     /*!< SWRSTAT (Bit 3)                                       */
#define RSTGEN_STAT_SWRSTAT_Msk           (0x8UL)                   /*!< SWRSTAT (Bitfield-Mask: 0x01)                         */
#define RSTGEN_STAT_BORSTAT_Pos           (2UL)                     /*!< BORSTAT (Bit 2)                                       */
#define RSTGEN_STAT_BORSTAT_Msk           (0x4UL)                   /*!< BORSTAT (Bitfield-Mask: 0x01)                         */
#define RSTGEN_STAT_PORSTAT_Pos           (1UL)                     /*!< PORSTAT (Bit 1)                                       */
#define RSTGEN_STAT_PORSTAT_Msk           (0x2UL)                   /*!< PORSTAT (Bitfield-Mask: 0x01)                         */
#define RSTGEN_STAT_EXRSTAT_Pos           (0UL)                     /*!< EXRSTAT (Bit 0)                                       */
#define RSTGEN_STAT_EXRSTAT_Msk           (0x1UL)                   /*!< EXRSTAT (Bitfield-Mask: 0x01)                         */
/* ========================================================  CLRSTAT  ======================================================== */
#define RSTGEN_CLRSTAT_CLRSTAT_Pos        (0UL)                     /*!< CLRSTAT (Bit 0)                                       */
#define RSTGEN_CLRSTAT_CLRSTAT_Msk        (0x1UL)                   /*!< CLRSTAT (Bitfield-Mask: 0x01)                         */
/* =======================================================  TPIU_RST  ======================================================== */
#define RSTGEN_TPIU_RST_TPIURST_Pos       (0UL)                     /*!< TPIURST (Bit 0)                                       */
#define RSTGEN_TPIU_RST_TPIURST_Msk       (0x1UL)                   /*!< TPIURST (Bitfield-Mask: 0x01)                         */
/* =========================================================  INTEN  ========================================================= */
#define RSTGEN_INTEN_BODH_Pos             (0UL)                     /*!< BODH (Bit 0)                                          */
#define RSTGEN_INTEN_BODH_Msk             (0x1UL)                   /*!< BODH (Bitfield-Mask: 0x01)                            */
/* ========================================================  INTSTAT  ======================================================== */
#define RSTGEN_INTSTAT_BODH_Pos           (0UL)                     /*!< BODH (Bit 0)                                          */
#define RSTGEN_INTSTAT_BODH_Msk           (0x1UL)                   /*!< BODH (Bitfield-Mask: 0x01)                            */
/* ========================================================  INTCLR  ========================================================= */
#define RSTGEN_INTCLR_BODH_Pos            (0UL)                     /*!< BODH (Bit 0)                                          */
#define RSTGEN_INTCLR_BODH_Msk            (0x1UL)                   /*!< BODH (Bitfield-Mask: 0x01)                            */
/* ========================================================  INTSET  ========================================================= */
#define RSTGEN_INTSET_BODH_Pos            (0UL)                     /*!< BODH (Bit 0)                                          */
#define RSTGEN_INTSET_BODH_Msk            (0x1UL)                   /*!< BODH (Bitfield-Mask: 0x01)                            */


/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  CTRLOW  ========================================================= */
#define RTC_CTRLOW_CTRHR_Pos              (24UL)                    /*!< CTRHR (Bit 24)                                        */
#define RTC_CTRLOW_CTRHR_Msk              (0x3f000000UL)            /*!< CTRHR (Bitfield-Mask: 0x3f)                           */
#define RTC_CTRLOW_CTRMIN_Pos             (16UL)                    /*!< CTRMIN (Bit 16)                                       */
#define RTC_CTRLOW_CTRMIN_Msk             (0x7f0000UL)              /*!< CTRMIN (Bitfield-Mask: 0x7f)                          */
#define RTC_CTRLOW_CTRSEC_Pos             (8UL)                     /*!< CTRSEC (Bit 8)                                        */
#define RTC_CTRLOW_CTRSEC_Msk             (0x7f00UL)                /*!< CTRSEC (Bitfield-Mask: 0x7f)                          */
#define RTC_CTRLOW_CTR100_Pos             (0UL)                     /*!< CTR100 (Bit 0)                                        */
#define RTC_CTRLOW_CTR100_Msk             (0xffUL)                  /*!< CTR100 (Bitfield-Mask: 0xff)                          */
/* =========================================================  CTRUP  ========================================================= */
#define RTC_CTRUP_CTERR_Pos               (31UL)                    /*!< CTERR (Bit 31)                                        */
#define RTC_CTRUP_CTERR_Msk               (0x80000000UL)            /*!< CTERR (Bitfield-Mask: 0x01)                           */
#define RTC_CTRUP_CEB_Pos                 (28UL)                    /*!< CEB (Bit 28)                                          */
#define RTC_CTRUP_CEB_Msk                 (0x10000000UL)            /*!< CEB (Bitfield-Mask: 0x01)                             */
#define RTC_CTRUP_CB_Pos                  (27UL)                    /*!< CB (Bit 27)                                           */
#define RTC_CTRUP_CB_Msk                  (0x8000000UL)             /*!< CB (Bitfield-Mask: 0x01)                              */
#define RTC_CTRUP_CTRWKDY_Pos             (24UL)                    /*!< CTRWKDY (Bit 24)                                      */
#define RTC_CTRUP_CTRWKDY_Msk             (0x7000000UL)             /*!< CTRWKDY (Bitfield-Mask: 0x07)                         */
#define RTC_CTRUP_CTRYR_Pos               (16UL)                    /*!< CTRYR (Bit 16)                                        */
#define RTC_CTRUP_CTRYR_Msk               (0xff0000UL)              /*!< CTRYR (Bitfield-Mask: 0xff)                           */
#define RTC_CTRUP_CTRMO_Pos               (8UL)                     /*!< CTRMO (Bit 8)                                         */
#define RTC_CTRUP_CTRMO_Msk               (0x1f00UL)                /*!< CTRMO (Bitfield-Mask: 0x1f)                           */
#define RTC_CTRUP_CTRDATE_Pos             (0UL)                     /*!< CTRDATE (Bit 0)                                       */
#define RTC_CTRUP_CTRDATE_Msk             (0x3fUL)                  /*!< CTRDATE (Bitfield-Mask: 0x3f)                         */
/* ========================================================  ALMLOW  ========================================================= */
#define RTC_ALMLOW_ALMHR_Pos              (24UL)                    /*!< ALMHR (Bit 24)                                        */
#define RTC_ALMLOW_ALMHR_Msk              (0x3f000000UL)            /*!< ALMHR (Bitfield-Mask: 0x3f)                           */
#define RTC_ALMLOW_ALMMIN_Pos             (16UL)                    /*!< ALMMIN (Bit 16)                                       */
#define RTC_ALMLOW_ALMMIN_Msk             (0x7f0000UL)              /*!< ALMMIN (Bitfield-Mask: 0x7f)                          */
#define RTC_ALMLOW_ALMSEC_Pos             (8UL)                     /*!< ALMSEC (Bit 8)                                        */
#define RTC_ALMLOW_ALMSEC_Msk             (0x7f00UL)                /*!< ALMSEC (Bitfield-Mask: 0x7f)                          */
#define RTC_ALMLOW_ALM100_Pos             (0UL)                     /*!< ALM100 (Bit 0)                                        */
#define RTC_ALMLOW_ALM100_Msk             (0xffUL)                  /*!< ALM100 (Bitfield-Mask: 0xff)                          */
/* =========================================================  ALMUP  ========================================================= */
#define RTC_ALMUP_ALMWKDY_Pos             (16UL)                    /*!< ALMWKDY (Bit 16)                                      */
#define RTC_ALMUP_ALMWKDY_Msk             (0x70000UL)               /*!< ALMWKDY (Bitfield-Mask: 0x07)                         */
#define RTC_ALMUP_ALMMO_Pos               (8UL)                     /*!< ALMMO (Bit 8)                                         */
#define RTC_ALMUP_ALMMO_Msk               (0x1f00UL)                /*!< ALMMO (Bitfield-Mask: 0x1f)                           */
#define RTC_ALMUP_ALMDATE_Pos             (0UL)                     /*!< ALMDATE (Bit 0)                                       */
#define RTC_ALMUP_ALMDATE_Msk             (0x3fUL)                  /*!< ALMDATE (Bitfield-Mask: 0x3f)                         */
/* ========================================================  RTCCTL  ========================================================= */
#define RTC_RTCCTL_HR1224_Pos             (5UL)                     /*!< HR1224 (Bit 5)                                        */
#define RTC_RTCCTL_HR1224_Msk             (0x20UL)                  /*!< HR1224 (Bitfield-Mask: 0x01)                          */
#define RTC_RTCCTL_RSTOP_Pos              (4UL)                     /*!< RSTOP (Bit 4)                                         */
#define RTC_RTCCTL_RSTOP_Msk              (0x10UL)                  /*!< RSTOP (Bitfield-Mask: 0x01)                           */
#define RTC_RTCCTL_RPT_Pos                (1UL)                     /*!< RPT (Bit 1)                                           */
#define RTC_RTCCTL_RPT_Msk                (0xeUL)                   /*!< RPT (Bitfield-Mask: 0x07)                             */
#define RTC_RTCCTL_WRTC_Pos               (0UL)                     /*!< WRTC (Bit 0)                                          */
#define RTC_RTCCTL_WRTC_Msk               (0x1UL)                   /*!< WRTC (Bitfield-Mask: 0x01)                            */
/* =========================================================  INTEN  ========================================================= */
#define RTC_INTEN_ALM_Pos                 (3UL)                     /*!< ALM (Bit 3)                                           */
#define RTC_INTEN_ALM_Msk                 (0x8UL)                   /*!< ALM (Bitfield-Mask: 0x01)                             */
#define RTC_INTEN_OF_Pos                  (2UL)                     /*!< OF (Bit 2)                                            */
#define RTC_INTEN_OF_Msk                  (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define RTC_INTEN_ACC_Pos                 (1UL)                     /*!< ACC (Bit 1)                                           */
#define RTC_INTEN_ACC_Msk                 (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define RTC_INTEN_ACF_Pos                 (0UL)                     /*!< ACF (Bit 0)                                           */
#define RTC_INTEN_ACF_Msk                 (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */
/* ========================================================  INTSTAT  ======================================================== */
#define RTC_INTSTAT_ALM_Pos               (3UL)                     /*!< ALM (Bit 3)                                           */
#define RTC_INTSTAT_ALM_Msk               (0x8UL)                   /*!< ALM (Bitfield-Mask: 0x01)                             */
#define RTC_INTSTAT_OF_Pos                (2UL)                     /*!< OF (Bit 2)                                            */
#define RTC_INTSTAT_OF_Msk                (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define RTC_INTSTAT_ACC_Pos               (1UL)                     /*!< ACC (Bit 1)                                           */
#define RTC_INTSTAT_ACC_Msk               (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define RTC_INTSTAT_ACF_Pos               (0UL)                     /*!< ACF (Bit 0)                                           */
#define RTC_INTSTAT_ACF_Msk               (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */
/* ========================================================  INTCLR  ========================================================= */
#define RTC_INTCLR_ALM_Pos                (3UL)                     /*!< ALM (Bit 3)                                           */
#define RTC_INTCLR_ALM_Msk                (0x8UL)                   /*!< ALM (Bitfield-Mask: 0x01)                             */
#define RTC_INTCLR_OF_Pos                 (2UL)                     /*!< OF (Bit 2)                                            */
#define RTC_INTCLR_OF_Msk                 (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define RTC_INTCLR_ACC_Pos                (1UL)                     /*!< ACC (Bit 1)                                           */
#define RTC_INTCLR_ACC_Msk                (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define RTC_INTCLR_ACF_Pos                (0UL)                     /*!< ACF (Bit 0)                                           */
#define RTC_INTCLR_ACF_Msk                (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */
/* ========================================================  INTSET  ========================================================= */
#define RTC_INTSET_ALM_Pos                (3UL)                     /*!< ALM (Bit 3)                                           */
#define RTC_INTSET_ALM_Msk                (0x8UL)                   /*!< ALM (Bitfield-Mask: 0x01)                             */
#define RTC_INTSET_OF_Pos                 (2UL)                     /*!< OF (Bit 2)                                            */
#define RTC_INTSET_OF_Msk                 (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define RTC_INTSET_ACC_Pos                (1UL)                     /*!< ACC (Bit 1)                                           */
#define RTC_INTSET_ACC_Msk                (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define RTC_INTSET_ACF_Pos                (0UL)                     /*!< ACF (Bit 0)                                           */
#define RTC_INTSET_ACF_Msk                (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */


/* =========================================================================================================================== */
/* ================                                           UART0                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  DR  =========================================================== */
#define UART0_DR_OEDATA_Pos               (11UL)                    /*!< OEDATA (Bit 11)                                       */
#define UART0_DR_OEDATA_Msk               (0x800UL)                 /*!< OEDATA (Bitfield-Mask: 0x01)                          */
#define UART0_DR_BEDATA_Pos               (10UL)                    /*!< BEDATA (Bit 10)                                       */
#define UART0_DR_BEDATA_Msk               (0x400UL)                 /*!< BEDATA (Bitfield-Mask: 0x01)                          */
#define UART0_DR_PEDATA_Pos               (9UL)                     /*!< PEDATA (Bit 9)                                        */
#define UART0_DR_PEDATA_Msk               (0x200UL)                 /*!< PEDATA (Bitfield-Mask: 0x01)                          */
#define UART0_DR_FEDATA_Pos               (8UL)                     /*!< FEDATA (Bit 8)                                        */
#define UART0_DR_FEDATA_Msk               (0x100UL)                 /*!< FEDATA (Bitfield-Mask: 0x01)                          */
#define UART0_DR_DATA_Pos                 (0UL)                     /*!< DATA (Bit 0)                                          */
#define UART0_DR_DATA_Msk                 (0xffUL)                  /*!< DATA (Bitfield-Mask: 0xff)                            */
/* ==========================================================  RSR  ========================================================== */
#define UART0_RSR_OESTAT_Pos              (3UL)                     /*!< OESTAT (Bit 3)                                        */
#define UART0_RSR_OESTAT_Msk              (0x8UL)                   /*!< OESTAT (Bitfield-Mask: 0x01)                          */
#define UART0_RSR_BESTAT_Pos              (2UL)                     /*!< BESTAT (Bit 2)                                        */
#define UART0_RSR_BESTAT_Msk              (0x4UL)                   /*!< BESTAT (Bitfield-Mask: 0x01)                          */
#define UART0_RSR_PESTAT_Pos              (1UL)                     /*!< PESTAT (Bit 1)                                        */
#define UART0_RSR_PESTAT_Msk              (0x2UL)                   /*!< PESTAT (Bitfield-Mask: 0x01)                          */
#define UART0_RSR_FESTAT_Pos              (0UL)                     /*!< FESTAT (Bit 0)                                        */
#define UART0_RSR_FESTAT_Msk              (0x1UL)                   /*!< FESTAT (Bitfield-Mask: 0x01)                          */
/* ==========================================================  FR  =========================================================== */
#define UART0_FR_TXBUSY_Pos               (8UL)                     /*!< TXBUSY (Bit 8)                                        */
#define UART0_FR_TXBUSY_Msk               (0x100UL)                 /*!< TXBUSY (Bitfield-Mask: 0x01)                          */
#define UART0_FR_TXFE_Pos                 (7UL)                     /*!< TXFE (Bit 7)                                          */
#define UART0_FR_TXFE_Msk                 (0x80UL)                  /*!< TXFE (Bitfield-Mask: 0x01)                            */
#define UART0_FR_RXFF_Pos                 (6UL)                     /*!< RXFF (Bit 6)                                          */
#define UART0_FR_RXFF_Msk                 (0x40UL)                  /*!< RXFF (Bitfield-Mask: 0x01)                            */
#define UART0_FR_TXFF_Pos                 (5UL)                     /*!< TXFF (Bit 5)                                          */
#define UART0_FR_TXFF_Msk                 (0x20UL)                  /*!< TXFF (Bitfield-Mask: 0x01)                            */
#define UART0_FR_RXFE_Pos                 (4UL)                     /*!< RXFE (Bit 4)                                          */
#define UART0_FR_RXFE_Msk                 (0x10UL)                  /*!< RXFE (Bitfield-Mask: 0x01)                            */
#define UART0_FR_BUSY_Pos                 (3UL)                     /*!< BUSY (Bit 3)                                          */
#define UART0_FR_BUSY_Msk                 (0x8UL)                   /*!< BUSY (Bitfield-Mask: 0x01)                            */
#define UART0_FR_DCD_Pos                  (2UL)                     /*!< DCD (Bit 2)                                           */
#define UART0_FR_DCD_Msk                  (0x4UL)                   /*!< DCD (Bitfield-Mask: 0x01)                             */
#define UART0_FR_DSR_Pos                  (1UL)                     /*!< DSR (Bit 1)                                           */
#define UART0_FR_DSR_Msk                  (0x2UL)                   /*!< DSR (Bitfield-Mask: 0x01)                             */
#define UART0_FR_CTS_Pos                  (0UL)                     /*!< CTS (Bit 0)                                           */
#define UART0_FR_CTS_Msk                  (0x1UL)                   /*!< CTS (Bitfield-Mask: 0x01)                             */
/* =========================================================  ILPR  ========================================================== */
#define UART0_ILPR_ILPDVSR_Pos            (0UL)                     /*!< ILPDVSR (Bit 0)                                       */
#define UART0_ILPR_ILPDVSR_Msk            (0xffUL)                  /*!< ILPDVSR (Bitfield-Mask: 0xff)                         */
/* =========================================================  IBRD  ========================================================== */
#define UART0_IBRD_DIVINT_Pos             (0UL)                     /*!< DIVINT (Bit 0)                                        */
#define UART0_IBRD_DIVINT_Msk             (0xffffUL)                /*!< DIVINT (Bitfield-Mask: 0xffff)                        */
/* =========================================================  FBRD  ========================================================== */
#define UART0_FBRD_DIVFRAC_Pos            (0UL)                     /*!< DIVFRAC (Bit 0)                                       */
#define UART0_FBRD_DIVFRAC_Msk            (0x3fUL)                  /*!< DIVFRAC (Bitfield-Mask: 0x3f)                         */
/* =========================================================  LCRH  ========================================================== */
#define UART0_LCRH_SPS_Pos                (7UL)                     /*!< SPS (Bit 7)                                           */
#define UART0_LCRH_SPS_Msk                (0x80UL)                  /*!< SPS (Bitfield-Mask: 0x01)                             */
#define UART0_LCRH_WLEN_Pos               (5UL)                     /*!< WLEN (Bit 5)                                          */
#define UART0_LCRH_WLEN_Msk               (0x60UL)                  /*!< WLEN (Bitfield-Mask: 0x03)                            */
#define UART0_LCRH_FEN_Pos                (4UL)                     /*!< FEN (Bit 4)                                           */
#define UART0_LCRH_FEN_Msk                (0x10UL)                  /*!< FEN (Bitfield-Mask: 0x01)                             */
#define UART0_LCRH_STP2_Pos               (3UL)                     /*!< STP2 (Bit 3)                                          */
#define UART0_LCRH_STP2_Msk               (0x8UL)                   /*!< STP2 (Bitfield-Mask: 0x01)                            */
#define UART0_LCRH_EPS_Pos                (2UL)                     /*!< EPS (Bit 2)                                           */
#define UART0_LCRH_EPS_Msk                (0x4UL)                   /*!< EPS (Bitfield-Mask: 0x01)                             */
#define UART0_LCRH_PEN_Pos                (1UL)                     /*!< PEN (Bit 1)                                           */
#define UART0_LCRH_PEN_Msk                (0x2UL)                   /*!< PEN (Bitfield-Mask: 0x01)                             */
#define UART0_LCRH_BRK_Pos                (0UL)                     /*!< BRK (Bit 0)                                           */
#define UART0_LCRH_BRK_Msk                (0x1UL)                   /*!< BRK (Bitfield-Mask: 0x01)                             */
/* ==========================================================  CR  =========================================================== */
#define UART0_CR_CTSEN_Pos                (15UL)                    /*!< CTSEN (Bit 15)                                        */
#define UART0_CR_CTSEN_Msk                (0x8000UL)                /*!< CTSEN (Bitfield-Mask: 0x01)                           */
#define UART0_CR_RTSEN_Pos                (14UL)                    /*!< RTSEN (Bit 14)                                        */
#define UART0_CR_RTSEN_Msk                (0x4000UL)                /*!< RTSEN (Bitfield-Mask: 0x01)                           */
#define UART0_CR_OUT2_Pos                 (13UL)                    /*!< OUT2 (Bit 13)                                         */
#define UART0_CR_OUT2_Msk                 (0x2000UL)                /*!< OUT2 (Bitfield-Mask: 0x01)                            */
#define UART0_CR_OUT1_Pos                 (12UL)                    /*!< OUT1 (Bit 12)                                         */
#define UART0_CR_OUT1_Msk                 (0x1000UL)                /*!< OUT1 (Bitfield-Mask: 0x01)                            */
#define UART0_CR_RTS_Pos                  (11UL)                    /*!< RTS (Bit 11)                                          */
#define UART0_CR_RTS_Msk                  (0x800UL)                 /*!< RTS (Bitfield-Mask: 0x01)                             */
#define UART0_CR_DTR_Pos                  (10UL)                    /*!< DTR (Bit 10)                                          */
#define UART0_CR_DTR_Msk                  (0x400UL)                 /*!< DTR (Bitfield-Mask: 0x01)                             */
#define UART0_CR_RXE_Pos                  (9UL)                     /*!< RXE (Bit 9)                                           */
#define UART0_CR_RXE_Msk                  (0x200UL)                 /*!< RXE (Bitfield-Mask: 0x01)                             */
#define UART0_CR_TXE_Pos                  (8UL)                     /*!< TXE (Bit 8)                                           */
#define UART0_CR_TXE_Msk                  (0x100UL)                 /*!< TXE (Bitfield-Mask: 0x01)                             */
#define UART0_CR_LBE_Pos                  (7UL)                     /*!< LBE (Bit 7)                                           */
#define UART0_CR_LBE_Msk                  (0x80UL)                  /*!< LBE (Bitfield-Mask: 0x01)                             */
#define UART0_CR_CLKSEL_Pos               (4UL)                     /*!< CLKSEL (Bit 4)                                        */
#define UART0_CR_CLKSEL_Msk               (0x70UL)                  /*!< CLKSEL (Bitfield-Mask: 0x07)                          */
#define UART0_CR_CLKEN_Pos                (3UL)                     /*!< CLKEN (Bit 3)                                         */
#define UART0_CR_CLKEN_Msk                (0x8UL)                   /*!< CLKEN (Bitfield-Mask: 0x01)                           */
#define UART0_CR_SIRLP_Pos                (2UL)                     /*!< SIRLP (Bit 2)                                         */
#define UART0_CR_SIRLP_Msk                (0x4UL)                   /*!< SIRLP (Bitfield-Mask: 0x01)                           */
#define UART0_CR_SIREN_Pos                (1UL)                     /*!< SIREN (Bit 1)                                         */
#define UART0_CR_SIREN_Msk                (0x2UL)                   /*!< SIREN (Bitfield-Mask: 0x01)                           */
#define UART0_CR_UARTEN_Pos               (0UL)                     /*!< UARTEN (Bit 0)                                        */
#define UART0_CR_UARTEN_Msk               (0x1UL)                   /*!< UARTEN (Bitfield-Mask: 0x01)                          */
/* =========================================================  IFLS  ========================================================== */
#define UART0_IFLS_RXIFLSEL_Pos           (3UL)                     /*!< RXIFLSEL (Bit 3)                                      */
#define UART0_IFLS_RXIFLSEL_Msk           (0x38UL)                  /*!< RXIFLSEL (Bitfield-Mask: 0x07)                        */
#define UART0_IFLS_TXIFLSEL_Pos           (0UL)                     /*!< TXIFLSEL (Bit 0)                                      */
#define UART0_IFLS_TXIFLSEL_Msk           (0x7UL)                   /*!< TXIFLSEL (Bitfield-Mask: 0x07)                        */
/* ==========================================================  IER  ========================================================== */
#define UART0_IER_OEIM_Pos                (10UL)                    /*!< OEIM (Bit 10)                                         */
#define UART0_IER_OEIM_Msk                (0x400UL)                 /*!< OEIM (Bitfield-Mask: 0x01)                            */
#define UART0_IER_BEIM_Pos                (9UL)                     /*!< BEIM (Bit 9)                                          */
#define UART0_IER_BEIM_Msk                (0x200UL)                 /*!< BEIM (Bitfield-Mask: 0x01)                            */
#define UART0_IER_PEIM_Pos                (8UL)                     /*!< PEIM (Bit 8)                                          */
#define UART0_IER_PEIM_Msk                (0x100UL)                 /*!< PEIM (Bitfield-Mask: 0x01)                            */
#define UART0_IER_FEIM_Pos                (7UL)                     /*!< FEIM (Bit 7)                                          */
#define UART0_IER_FEIM_Msk                (0x80UL)                  /*!< FEIM (Bitfield-Mask: 0x01)                            */
#define UART0_IER_RTIM_Pos                (6UL)                     /*!< RTIM (Bit 6)                                          */
#define UART0_IER_RTIM_Msk                (0x40UL)                  /*!< RTIM (Bitfield-Mask: 0x01)                            */
#define UART0_IER_TXIM_Pos                (5UL)                     /*!< TXIM (Bit 5)                                          */
#define UART0_IER_TXIM_Msk                (0x20UL)                  /*!< TXIM (Bitfield-Mask: 0x01)                            */
#define UART0_IER_RXIM_Pos                (4UL)                     /*!< RXIM (Bit 4)                                          */
#define UART0_IER_RXIM_Msk                (0x10UL)                  /*!< RXIM (Bitfield-Mask: 0x01)                            */
#define UART0_IER_DSRMIM_Pos              (3UL)                     /*!< DSRMIM (Bit 3)                                        */
#define UART0_IER_DSRMIM_Msk              (0x8UL)                   /*!< DSRMIM (Bitfield-Mask: 0x01)                          */
#define UART0_IER_DCDMIM_Pos              (2UL)                     /*!< DCDMIM (Bit 2)                                        */
#define UART0_IER_DCDMIM_Msk              (0x4UL)                   /*!< DCDMIM (Bitfield-Mask: 0x01)                          */
#define UART0_IER_CTSMIM_Pos              (1UL)                     /*!< CTSMIM (Bit 1)                                        */
#define UART0_IER_CTSMIM_Msk              (0x2UL)                   /*!< CTSMIM (Bitfield-Mask: 0x01)                          */
#define UART0_IER_TXCMPMIM_Pos            (0UL)                     /*!< TXCMPMIM (Bit 0)                                      */
#define UART0_IER_TXCMPMIM_Msk            (0x1UL)                   /*!< TXCMPMIM (Bitfield-Mask: 0x01)                        */
/* ==========================================================  IES  ========================================================== */
#define UART0_IES_OERIS_Pos               (10UL)                    /*!< OERIS (Bit 10)                                        */
#define UART0_IES_OERIS_Msk               (0x400UL)                 /*!< OERIS (Bitfield-Mask: 0x01)                           */
#define UART0_IES_BERIS_Pos               (9UL)                     /*!< BERIS (Bit 9)                                         */
#define UART0_IES_BERIS_Msk               (0x200UL)                 /*!< BERIS (Bitfield-Mask: 0x01)                           */
#define UART0_IES_PERIS_Pos               (8UL)                     /*!< PERIS (Bit 8)                                         */
#define UART0_IES_PERIS_Msk               (0x100UL)                 /*!< PERIS (Bitfield-Mask: 0x01)                           */
#define UART0_IES_FERIS_Pos               (7UL)                     /*!< FERIS (Bit 7)                                         */
#define UART0_IES_FERIS_Msk               (0x80UL)                  /*!< FERIS (Bitfield-Mask: 0x01)                           */
#define UART0_IES_RTRIS_Pos               (6UL)                     /*!< RTRIS (Bit 6)                                         */
#define UART0_IES_RTRIS_Msk               (0x40UL)                  /*!< RTRIS (Bitfield-Mask: 0x01)                           */
#define UART0_IES_TXRIS_Pos               (5UL)                     /*!< TXRIS (Bit 5)                                         */
#define UART0_IES_TXRIS_Msk               (0x20UL)                  /*!< TXRIS (Bitfield-Mask: 0x01)                           */
#define UART0_IES_RXRIS_Pos               (4UL)                     /*!< RXRIS (Bit 4)                                         */
#define UART0_IES_RXRIS_Msk               (0x10UL)                  /*!< RXRIS (Bitfield-Mask: 0x01)                           */
#define UART0_IES_DSRMRIS_Pos             (3UL)                     /*!< DSRMRIS (Bit 3)                                       */
#define UART0_IES_DSRMRIS_Msk             (0x8UL)                   /*!< DSRMRIS (Bitfield-Mask: 0x01)                         */
#define UART0_IES_DCDMRIS_Pos             (2UL)                     /*!< DCDMRIS (Bit 2)                                       */
#define UART0_IES_DCDMRIS_Msk             (0x4UL)                   /*!< DCDMRIS (Bitfield-Mask: 0x01)                         */
#define UART0_IES_CTSMRIS_Pos             (1UL)                     /*!< CTSMRIS (Bit 1)                                       */
#define UART0_IES_CTSMRIS_Msk             (0x2UL)                   /*!< CTSMRIS (Bitfield-Mask: 0x01)                         */
#define UART0_IES_TXCMPMRIS_Pos           (0UL)                     /*!< TXCMPMRIS (Bit 0)                                     */
#define UART0_IES_TXCMPMRIS_Msk           (0x1UL)                   /*!< TXCMPMRIS (Bitfield-Mask: 0x01)                       */
/* ==========================================================  MIS  ========================================================== */
#define UART0_MIS_OEMIS_Pos               (10UL)                    /*!< OEMIS (Bit 10)                                        */
#define UART0_MIS_OEMIS_Msk               (0x400UL)                 /*!< OEMIS (Bitfield-Mask: 0x01)                           */
#define UART0_MIS_BEMIS_Pos               (9UL)                     /*!< BEMIS (Bit 9)                                         */
#define UART0_MIS_BEMIS_Msk               (0x200UL)                 /*!< BEMIS (Bitfield-Mask: 0x01)                           */
#define UART0_MIS_PEMIS_Pos               (8UL)                     /*!< PEMIS (Bit 8)                                         */
#define UART0_MIS_PEMIS_Msk               (0x100UL)                 /*!< PEMIS (Bitfield-Mask: 0x01)                           */
#define UART0_MIS_FEMIS_Pos               (7UL)                     /*!< FEMIS (Bit 7)                                         */
#define UART0_MIS_FEMIS_Msk               (0x80UL)                  /*!< FEMIS (Bitfield-Mask: 0x01)                           */
#define UART0_MIS_RTMIS_Pos               (6UL)                     /*!< RTMIS (Bit 6)                                         */
#define UART0_MIS_RTMIS_Msk               (0x40UL)                  /*!< RTMIS (Bitfield-Mask: 0x01)                           */
#define UART0_MIS_TXMIS_Pos               (5UL)                     /*!< TXMIS (Bit 5)                                         */
#define UART0_MIS_TXMIS_Msk               (0x20UL)                  /*!< TXMIS (Bitfield-Mask: 0x01)                           */
#define UART0_MIS_RXMIS_Pos               (4UL)                     /*!< RXMIS (Bit 4)                                         */
#define UART0_MIS_RXMIS_Msk               (0x10UL)                  /*!< RXMIS (Bitfield-Mask: 0x01)                           */
#define UART0_MIS_DSRMMIS_Pos             (3UL)                     /*!< DSRMMIS (Bit 3)                                       */
#define UART0_MIS_DSRMMIS_Msk             (0x8UL)                   /*!< DSRMMIS (Bitfield-Mask: 0x01)                         */
#define UART0_MIS_DCDMMIS_Pos             (2UL)                     /*!< DCDMMIS (Bit 2)                                       */
#define UART0_MIS_DCDMMIS_Msk             (0x4UL)                   /*!< DCDMMIS (Bitfield-Mask: 0x01)                         */
#define UART0_MIS_CTSMMIS_Pos             (1UL)                     /*!< CTSMMIS (Bit 1)                                       */
#define UART0_MIS_CTSMMIS_Msk             (0x2UL)                   /*!< CTSMMIS (Bitfield-Mask: 0x01)                         */
#define UART0_MIS_TXCMPMMIS_Pos           (0UL)                     /*!< TXCMPMMIS (Bit 0)                                     */
#define UART0_MIS_TXCMPMMIS_Msk           (0x1UL)                   /*!< TXCMPMMIS (Bitfield-Mask: 0x01)                       */
/* ==========================================================  IEC  ========================================================== */
#define UART0_IEC_OEIC_Pos                (10UL)                    /*!< OEIC (Bit 10)                                         */
#define UART0_IEC_OEIC_Msk                (0x400UL)                 /*!< OEIC (Bitfield-Mask: 0x01)                            */
#define UART0_IEC_BEIC_Pos                (9UL)                     /*!< BEIC (Bit 9)                                          */
#define UART0_IEC_BEIC_Msk                (0x200UL)                 /*!< BEIC (Bitfield-Mask: 0x01)                            */
#define UART0_IEC_PEIC_Pos                (8UL)                     /*!< PEIC (Bit 8)                                          */
#define UART0_IEC_PEIC_Msk                (0x100UL)                 /*!< PEIC (Bitfield-Mask: 0x01)                            */
#define UART0_IEC_FEIC_Pos                (7UL)                     /*!< FEIC (Bit 7)                                          */
#define UART0_IEC_FEIC_Msk                (0x80UL)                  /*!< FEIC (Bitfield-Mask: 0x01)                            */
#define UART0_IEC_RTIC_Pos                (6UL)                     /*!< RTIC (Bit 6)                                          */
#define UART0_IEC_RTIC_Msk                (0x40UL)                  /*!< RTIC (Bitfield-Mask: 0x01)                            */
#define UART0_IEC_TXIC_Pos                (5UL)                     /*!< TXIC (Bit 5)                                          */
#define UART0_IEC_TXIC_Msk                (0x20UL)                  /*!< TXIC (Bitfield-Mask: 0x01)                            */
#define UART0_IEC_RXIC_Pos                (4UL)                     /*!< RXIC (Bit 4)                                          */
#define UART0_IEC_RXIC_Msk                (0x10UL)                  /*!< RXIC (Bitfield-Mask: 0x01)                            */
#define UART0_IEC_DSRMIC_Pos              (3UL)                     /*!< DSRMIC (Bit 3)                                        */
#define UART0_IEC_DSRMIC_Msk              (0x8UL)                   /*!< DSRMIC (Bitfield-Mask: 0x01)                          */
#define UART0_IEC_DCDMIC_Pos              (2UL)                     /*!< DCDMIC (Bit 2)                                        */
#define UART0_IEC_DCDMIC_Msk              (0x4UL)                   /*!< DCDMIC (Bitfield-Mask: 0x01)                          */
#define UART0_IEC_CTSMIC_Pos              (1UL)                     /*!< CTSMIC (Bit 1)                                        */
#define UART0_IEC_CTSMIC_Msk              (0x2UL)                   /*!< CTSMIC (Bitfield-Mask: 0x01)                          */
#define UART0_IEC_TXCMPMIC_Pos            (0UL)                     /*!< TXCMPMIC (Bit 0)                                      */
#define UART0_IEC_TXCMPMIC_Msk            (0x1UL)                   /*!< TXCMPMIC (Bitfield-Mask: 0x01)                        */


/* =========================================================================================================================== */
/* ================                                           VCOMP                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define VCOMP_CFG_LVLSEL_Pos              (16UL)                    /*!< LVLSEL (Bit 16)                                       */
#define VCOMP_CFG_LVLSEL_Msk              (0xf0000UL)               /*!< LVLSEL (Bitfield-Mask: 0x0f)                          */
#define VCOMP_CFG_NSEL_Pos                (8UL)                     /*!< NSEL (Bit 8)                                          */
#define VCOMP_CFG_NSEL_Msk                (0x300UL)                 /*!< NSEL (Bitfield-Mask: 0x03)                            */
#define VCOMP_CFG_PSEL_Pos                (0UL)                     /*!< PSEL (Bit 0)                                          */
#define VCOMP_CFG_PSEL_Msk                (0x3UL)                   /*!< PSEL (Bitfield-Mask: 0x03)                            */
/* =========================================================  STAT  ========================================================== */
#define VCOMP_STAT_PWDSTAT_Pos            (1UL)                     /*!< PWDSTAT (Bit 1)                                       */
#define VCOMP_STAT_PWDSTAT_Msk            (0x2UL)                   /*!< PWDSTAT (Bitfield-Mask: 0x01)                         */
#define VCOMP_STAT_CMPOUT_Pos             (0UL)                     /*!< CMPOUT (Bit 0)                                        */
#define VCOMP_STAT_CMPOUT_Msk             (0x1UL)                   /*!< CMPOUT (Bitfield-Mask: 0x01)                          */
/* ========================================================  PWDKEY  ========================================================= */
#define VCOMP_PWDKEY_PWDKEY_Pos           (0UL)                     /*!< PWDKEY (Bit 0)                                        */
#define VCOMP_PWDKEY_PWDKEY_Msk           (0xffffffffUL)            /*!< PWDKEY (Bitfield-Mask: 0xffffffff)                    */
/* =========================================================  INTEN  ========================================================= */
#define VCOMP_INTEN_OUTHI_Pos             (1UL)                     /*!< OUTHI (Bit 1)                                         */
#define VCOMP_INTEN_OUTHI_Msk             (0x2UL)                   /*!< OUTHI (Bitfield-Mask: 0x01)                           */
#define VCOMP_INTEN_OUTLOW_Pos            (0UL)                     /*!< OUTLOW (Bit 0)                                        */
#define VCOMP_INTEN_OUTLOW_Msk            (0x1UL)                   /*!< OUTLOW (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSTAT  ======================================================== */
#define VCOMP_INTSTAT_OUTHI_Pos           (1UL)                     /*!< OUTHI (Bit 1)                                         */
#define VCOMP_INTSTAT_OUTHI_Msk           (0x2UL)                   /*!< OUTHI (Bitfield-Mask: 0x01)                           */
#define VCOMP_INTSTAT_OUTLOW_Pos          (0UL)                     /*!< OUTLOW (Bit 0)                                        */
#define VCOMP_INTSTAT_OUTLOW_Msk          (0x1UL)                   /*!< OUTLOW (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTCLR  ========================================================= */
#define VCOMP_INTCLR_OUTHI_Pos            (1UL)                     /*!< OUTHI (Bit 1)                                         */
#define VCOMP_INTCLR_OUTHI_Msk            (0x2UL)                   /*!< OUTHI (Bitfield-Mask: 0x01)                           */
#define VCOMP_INTCLR_OUTLOW_Pos           (0UL)                     /*!< OUTLOW (Bit 0)                                        */
#define VCOMP_INTCLR_OUTLOW_Msk           (0x1UL)                   /*!< OUTLOW (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSET  ========================================================= */
#define VCOMP_INTSET_OUTHI_Pos            (1UL)                     /*!< OUTHI (Bit 1)                                         */
#define VCOMP_INTSET_OUTHI_Msk            (0x2UL)                   /*!< OUTHI (Bitfield-Mask: 0x01)                           */
#define VCOMP_INTSET_OUTLOW_Pos           (0UL)                     /*!< OUTLOW (Bit 0)                                        */
#define VCOMP_INTSET_OUTLOW_Msk           (0x1UL)                   /*!< OUTLOW (Bitfield-Mask: 0x01)                          */


/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define WDT_CFG_CLKSEL_Pos                (24UL)                    /*!< CLKSEL (Bit 24)                                       */
#define WDT_CFG_CLKSEL_Msk                (0x7000000UL)             /*!< CLKSEL (Bitfield-Mask: 0x07)                          */
#define WDT_CFG_INTVAL_Pos                (16UL)                    /*!< INTVAL (Bit 16)                                       */
#define WDT_CFG_INTVAL_Msk                (0xff0000UL)              /*!< INTVAL (Bitfield-Mask: 0xff)                          */
#define WDT_CFG_RESVAL_Pos                (8UL)                     /*!< RESVAL (Bit 8)                                        */
#define WDT_CFG_RESVAL_Msk                (0xff00UL)                /*!< RESVAL (Bitfield-Mask: 0xff)                          */
#define WDT_CFG_RESEN_Pos                 (2UL)                     /*!< RESEN (Bit 2)                                         */
#define WDT_CFG_RESEN_Msk                 (0x4UL)                   /*!< RESEN (Bitfield-Mask: 0x01)                           */
#define WDT_CFG_INTEN_Pos                 (1UL)                     /*!< INTEN (Bit 1)                                         */
#define WDT_CFG_INTEN_Msk                 (0x2UL)                   /*!< INTEN (Bitfield-Mask: 0x01)                           */
#define WDT_CFG_WDTEN_Pos                 (0UL)                     /*!< WDTEN (Bit 0)                                         */
#define WDT_CFG_WDTEN_Msk                 (0x1UL)                   /*!< WDTEN (Bitfield-Mask: 0x01)                           */
/* =========================================================  RSTRT  ========================================================= */
#define WDT_RSTRT_RSTRT_Pos               (0UL)                     /*!< RSTRT (Bit 0)                                         */
#define WDT_RSTRT_RSTRT_Msk               (0xffUL)                  /*!< RSTRT (Bitfield-Mask: 0xff)                           */
/* =========================================================  LOCK  ========================================================== */
#define WDT_LOCK_LOCK_Pos                 (0UL)                     /*!< LOCK (Bit 0)                                          */
#define WDT_LOCK_LOCK_Msk                 (0xffUL)                  /*!< LOCK (Bitfield-Mask: 0xff)                            */
/* =========================================================  COUNT  ========================================================= */
#define WDT_COUNT_COUNT_Pos               (0UL)                     /*!< COUNT (Bit 0)                                         */
#define WDT_COUNT_COUNT_Msk               (0xffUL)                  /*!< COUNT (Bitfield-Mask: 0xff)                           */
/* =========================================================  INTEN  ========================================================= */
#define WDT_INTEN_WDTINT_Pos              (0UL)                     /*!< WDTINT (Bit 0)                                        */
#define WDT_INTEN_WDTINT_Msk              (0x1UL)                   /*!< WDTINT (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSTAT  ======================================================== */
#define WDT_INTSTAT_WDTINT_Pos            (0UL)                     /*!< WDTINT (Bit 0)                                        */
#define WDT_INTSTAT_WDTINT_Msk            (0x1UL)                   /*!< WDTINT (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTCLR  ========================================================= */
#define WDT_INTCLR_WDTINT_Pos             (0UL)                     /*!< WDTINT (Bit 0)                                        */
#define WDT_INTCLR_WDTINT_Msk             (0x1UL)                   /*!< WDTINT (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSET  ========================================================= */
#define WDT_INTSET_WDTINT_Pos             (0UL)                     /*!< WDTINT (Bit 0)                                        */
#define WDT_INTSET_WDTINT_Msk             (0x1UL)                   /*!< WDTINT (Bitfield-Mask: 0x01)                          */

/** @} */ /* End of group PosMask_peripherals */


/* =========================================================================================================================== */
/* ================                           Enumerated Values Peripheral Section                            ================ */
/* =========================================================================================================================== */


/** @addtogroup EnumValue_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
/* ================================================  ADC CFG CLKSEL [24..25]  ================================================ */
typedef enum {                                  /*!< ADC_CFG_CLKSEL                                                            */
  ADC_CFG_CLKSEL_OFF                   = 0,     /*!< OFF : Off mode. The HFRC or HFRC_DIV2 clock must be selected
                                                                    for the ADC to function. The ADC controller
                                                                    automatically shuts off the clock in it's
                                                                    low power modes. When setting ADCEN to '0',
                                                                    the CLKSEL should remain set to one of the
                                                                    two clock selects for proper power down
                                                                    sequencing.                                                */
  ADC_CFG_CLKSEL_HFRC                  = 1,     /*!< HFRC : HFRC Core Clock Frequency                                          */
  ADC_CFG_CLKSEL_HFRC_DIV2             = 2,     /*!< HFRC_DIV2 : HFRC Core Clock / 2                                           */
} ADC_CFG_CLKSEL_Enum;

/* ===============================================  ADC CFG TRIGPOL [19..19]  ================================================ */
typedef enum {                                  /*!< ADC_CFG_TRIGPOL                                                           */
  ADC_CFG_TRIGPOL_RISING_EDGE          = 0,     /*!< RISING_EDGE : Trigger on rising edge.                                     */
  ADC_CFG_TRIGPOL_FALLING_EDGE         = 1,     /*!< FALLING_EDGE : Trigger on falling edge.                                   */
} ADC_CFG_TRIGPOL_Enum;

/* ===============================================  ADC CFG TRIGSEL [16..18]  ================================================ */
typedef enum {                                  /*!< ADC_CFG_TRIGSEL                                                           */
  ADC_CFG_TRIGSEL_EXT0                 = 0,     /*!< EXT0 : Off chip External Trigger0 (ADC_ET0)                               */
  ADC_CFG_TRIGSEL_EXT1                 = 1,     /*!< EXT1 : Off chip External Trigger1 (ADC_ET1)                               */
  ADC_CFG_TRIGSEL_EXT2                 = 2,     /*!< EXT2 : Off chip External Trigger2 (ADC_ET2)                               */
  ADC_CFG_TRIGSEL_EXT3                 = 3,     /*!< EXT3 : Off chip External Trigger3 (ADC_ET3)                               */
  ADC_CFG_TRIGSEL_VCOMP                = 4,     /*!< VCOMP : Voltage Comparator Output                                         */
  ADC_CFG_TRIGSEL_SWT                  = 7,     /*!< SWT : Software Trigger                                                    */
} ADC_CFG_TRIGSEL_Enum;

/* =================================================  ADC CFG REFSEL [8..9]  ================================================= */
typedef enum {                                  /*!< ADC_CFG_REFSEL                                                            */
  ADC_CFG_REFSEL_INT2P0                = 0,     /*!< INT2P0 : Internal 2.0V Bandgap Reference Voltage                          */
  ADC_CFG_REFSEL_INT1P5                = 1,     /*!< INT1P5 : Internal 1.5V Bandgap Reference Voltage                          */
  ADC_CFG_REFSEL_EXT2P0                = 2,     /*!< EXT2P0 : Off Chip 2.0V Reference                                          */
  ADC_CFG_REFSEL_EXT1P5                = 3,     /*!< EXT1P5 : Off Chip 1.5V Reference                                          */
} ADC_CFG_REFSEL_Enum;

/* =================================================  ADC CFG CKMODE [4..4]  ================================================= */
typedef enum {                                  /*!< ADC_CFG_CKMODE                                                            */
  ADC_CFG_CKMODE_LPCKMODE              = 0,     /*!< LPCKMODE : Disable the clock between scans for LPMODE0. Set
                                                     LPCKMODE to 0x1 while configuring the ADC.                                */
  ADC_CFG_CKMODE_LLCKMODE              = 1,     /*!< LLCKMODE : Low Latency Clock Mode. When set, HFRC and the adc_clk
                                                     will remain on while in functioning in LPMODE0.                           */
} ADC_CFG_CKMODE_Enum;

/* =================================================  ADC CFG LPMODE [3..3]  ================================================= */
typedef enum {                                  /*!< ADC_CFG_LPMODE                                                            */
  ADC_CFG_LPMODE_MODE0                 = 0,     /*!< MODE0 : Low Power Mode 0. Leaves the ADC fully powered between
                                                     scans with minimum latency between a trigger event and
                                                     sample data collection.                                                   */
  ADC_CFG_LPMODE_MODE1                 = 1,     /*!< MODE1 : Low Power Mode 1. Powers down all circuity and clocks
                                                     associated with the ADC until the next trigger event. Between
                                                     scans, the reference buffer requires up to 50us of delay
                                                     from a scan trigger event before the conversion will commence
                                                     while operating in this mode.                                             */
} ADC_CFG_LPMODE_Enum;

/* =================================================  ADC CFG RPTEN [2..2]  ================================================== */
typedef enum {                                  /*!< ADC_CFG_RPTEN                                                             */
  ADC_CFG_RPTEN_SINGLE_SCAN            = 0,     /*!< SINGLE_SCAN : In Single Scan Mode, the ADC will complete a single
                                                     scan upon each trigger event.                                             */
  ADC_CFG_RPTEN_REPEATING_SCAN         = 1,     /*!< REPEATING_SCAN : In Repeating Scan Mode, the ADC will complete
                                                     it's first scan upon the initial trigger event and all
                                                     subsequent scans will occur at regular intervals defined
                                                     by the configuration programmed for the CTTMRA3 internal
                                                     timer until the timer is disabled or the ADC is disabled.
                                                     When disabling the ADC (setting ADCEN to '0'), the RPTEN
                                                     bit should be cleared.                                                    */
} ADC_CFG_RPTEN_Enum;

/* =================================================  ADC CFG ADCEN [0..0]  ================================================== */
typedef enum {                                  /*!< ADC_CFG_ADCEN                                                             */
  ADC_CFG_ADCEN_DIS                    = 0,     /*!< DIS : Disable the ADC module.                                             */
  ADC_CFG_ADCEN_EN                     = 1,     /*!< EN : Enable the ADC module.                                               */
} ADC_CFG_ADCEN_Enum;

/* =========================================================  STAT  ========================================================== */
/* ================================================  ADC STAT PWDSTAT [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_STAT_PWDSTAT                                                          */
  ADC_STAT_PWDSTAT_ON                  = 0,     /*!< ON : Powered on.                                                          */
  ADC_STAT_PWDSTAT_POWERED_DOWN        = 1,     /*!< POWERED_DOWN : ADC Low Power Mode 1.                                      */
} ADC_STAT_PWDSTAT_Enum;

/* ==========================================================  SWT  ========================================================== */
/* ==================================================  ADC SWT SWT [0..7]  =================================================== */
typedef enum {                                  /*!< ADC_SWT_SWT                                                               */
  ADC_SWT_SWT_GEN_SW_TRIGGER           = 55,    /*!< GEN_SW_TRIGGER : Writing this value generates a software trigger.         */
} ADC_SWT_SWT_Enum;

/* ========================================================  SL0CFG  ========================================================= */
/* ==============================================  ADC SL0CFG ADSEL0 [24..26]  =============================================== */
typedef enum {                                  /*!< ADC_SL0CFG_ADSEL0                                                         */
  ADC_SL0CFG_ADSEL0_AVG_1_MSRMT        = 0,     /*!< AVG_1_MSRMT : Average in 1 measurement in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL0CFG_ADSEL0_AVG_2_MSRMTS       = 1,     /*!< AVG_2_MSRMTS : Average in 2 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL0CFG_ADSEL0_AVG_4_MSRMTS       = 2,     /*!< AVG_4_MSRMTS : Average in 4 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL0CFG_ADSEL0_AVG_8_MSRMT        = 3,     /*!< AVG_8_MSRMT : Average in 8 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL0CFG_ADSEL0_AVG_16_MSRMTS      = 4,     /*!< AVG_16_MSRMTS : Average in 16 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL0CFG_ADSEL0_AVG_32_MSRMTS      = 5,     /*!< AVG_32_MSRMTS : Average in 32 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL0CFG_ADSEL0_AVG_64_MSRMTS      = 6,     /*!< AVG_64_MSRMTS : Average in 64 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL0CFG_ADSEL0_AVG_128_MSRMTS     = 7,     /*!< AVG_128_MSRMTS : Average in 128 measurements in the accumulate
                                                     divide module for this slot.                                              */
} ADC_SL0CFG_ADSEL0_Enum;

/* ==============================================  ADC SL0CFG PRMODE0 [16..17]  ============================================== */
typedef enum {                                  /*!< ADC_SL0CFG_PRMODE0                                                        */
  ADC_SL0CFG_PRMODE0_P14B              = 0,     /*!< P14B : 14-bit precision mode                                              */
  ADC_SL0CFG_PRMODE0_P12B              = 1,     /*!< P12B : 12-bit precision mode                                              */
  ADC_SL0CFG_PRMODE0_P10B              = 2,     /*!< P10B : 10-bit precision mode                                              */
  ADC_SL0CFG_PRMODE0_P8B               = 3,     /*!< P8B : 8-bit precision mode                                                */
} ADC_SL0CFG_PRMODE0_Enum;

/* ===============================================  ADC SL0CFG CHSEL0 [8..11]  =============================================== */
typedef enum {                                  /*!< ADC_SL0CFG_CHSEL0                                                         */
  ADC_SL0CFG_CHSEL0_SE0                = 0,     /*!< SE0 : single ended external GPIO connection to pad16.                     */
  ADC_SL0CFG_CHSEL0_SE1                = 1,     /*!< SE1 : single ended external GPIO connection to pad29.                     */
  ADC_SL0CFG_CHSEL0_SE2                = 2,     /*!< SE2 : single ended external GPIO connection to pad11.                     */
  ADC_SL0CFG_CHSEL0_SE3                = 3,     /*!< SE3 : single ended external GPIO connection to pad31.                     */
  ADC_SL0CFG_CHSEL0_SE4                = 4,     /*!< SE4 : single ended external GPIO connection to pad32.                     */
  ADC_SL0CFG_CHSEL0_SE5                = 5,     /*!< SE5 : single ended external GPIO connection to pad33.                     */
  ADC_SL0CFG_CHSEL0_SE6                = 6,     /*!< SE6 : single ended external GPIO connection to pad34.                     */
  ADC_SL0CFG_CHSEL0_SE7                = 7,     /*!< SE7 : single ended external GPIO connection to pad35.                     */
  ADC_SL0CFG_CHSEL0_SE8                = 8,     /*!< SE8 : single ended external GPIO connection to pad13.                     */
  ADC_SL0CFG_CHSEL0_SE9                = 9,     /*!< SE9 : single ended external GPIO connection to pad12.                     */
  ADC_SL0CFG_CHSEL0_DF0                = 10,    /*!< DF0 : differential external GPIO connections to pad12(N) and
                                                     pad13(P).                                                                 */
  ADC_SL0CFG_CHSEL0_DF1                = 11,    /*!< DF1 : differential external GPIO connections to pad15(N) and
                                                     pad14(P).                                                                 */
  ADC_SL0CFG_CHSEL0_TEMP               = 12,    /*!< TEMP : internal temperature sensor.                                       */
  ADC_SL0CFG_CHSEL0_BATT               = 13,    /*!< BATT : internal voltage divide-by-3 connection.                           */
  ADC_SL0CFG_CHSEL0_VSS                = 14,    /*!< VSS : Input VSS                                                           */
} ADC_SL0CFG_CHSEL0_Enum;

/* ================================================  ADC SL0CFG WCEN0 [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_SL0CFG_WCEN0                                                          */
  ADC_SL0CFG_WCEN0_WCEN                = 1,     /*!< WCEN : Enable the window compare for slot 0.                              */
} ADC_SL0CFG_WCEN0_Enum;

/* ================================================  ADC SL0CFG SLEN0 [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_SL0CFG_SLEN0                                                          */
  ADC_SL0CFG_SLEN0_SLEN                = 1,     /*!< SLEN : Enable slot 0 for ADC conversions.                                 */
} ADC_SL0CFG_SLEN0_Enum;

/* ========================================================  SL1CFG  ========================================================= */
/* ==============================================  ADC SL1CFG ADSEL1 [24..26]  =============================================== */
typedef enum {                                  /*!< ADC_SL1CFG_ADSEL1                                                         */
  ADC_SL1CFG_ADSEL1_AVG_1_MSRMT        = 0,     /*!< AVG_1_MSRMT : Average in 1 measurement in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL1CFG_ADSEL1_AVG_2_MSRMTS       = 1,     /*!< AVG_2_MSRMTS : Average in 2 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL1CFG_ADSEL1_AVG_4_MSRMTS       = 2,     /*!< AVG_4_MSRMTS : Average in 4 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL1CFG_ADSEL1_AVG_8_MSRMT        = 3,     /*!< AVG_8_MSRMT : Average in 8 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL1CFG_ADSEL1_AVG_16_MSRMTS      = 4,     /*!< AVG_16_MSRMTS : Average in 16 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL1CFG_ADSEL1_AVG_32_MSRMTS      = 5,     /*!< AVG_32_MSRMTS : Average in 32 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL1CFG_ADSEL1_AVG_64_MSRMTS      = 6,     /*!< AVG_64_MSRMTS : Average in 64 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL1CFG_ADSEL1_AVG_128_MSRMTS     = 7,     /*!< AVG_128_MSRMTS : Average in 128 measurements in the accumulate
                                                     divide module for this slot.                                              */
} ADC_SL1CFG_ADSEL1_Enum;

/* ==============================================  ADC SL1CFG PRMODE1 [16..17]  ============================================== */
typedef enum {                                  /*!< ADC_SL1CFG_PRMODE1                                                        */
  ADC_SL1CFG_PRMODE1_P14B              = 0,     /*!< P14B : 14-bit precision mode                                              */
  ADC_SL1CFG_PRMODE1_P12B              = 1,     /*!< P12B : 12-bit precision mode                                              */
  ADC_SL1CFG_PRMODE1_P10B              = 2,     /*!< P10B : 10-bit precision mode                                              */
  ADC_SL1CFG_PRMODE1_P8B               = 3,     /*!< P8B : 8-bit precision mode                                                */
} ADC_SL1CFG_PRMODE1_Enum;

/* ===============================================  ADC SL1CFG CHSEL1 [8..11]  =============================================== */
typedef enum {                                  /*!< ADC_SL1CFG_CHSEL1                                                         */
  ADC_SL1CFG_CHSEL1_SE0                = 0,     /*!< SE0 : single ended external GPIO connection to pad16.                     */
  ADC_SL1CFG_CHSEL1_SE1                = 1,     /*!< SE1 : single ended external GPIO connection to pad29.                     */
  ADC_SL1CFG_CHSEL1_SE2                = 2,     /*!< SE2 : single ended external GPIO connection to pad11.                     */
  ADC_SL1CFG_CHSEL1_SE3                = 3,     /*!< SE3 : single ended external GPIO connection to pad31.                     */
  ADC_SL1CFG_CHSEL1_SE4                = 4,     /*!< SE4 : single ended external GPIO connection to pad32.                     */
  ADC_SL1CFG_CHSEL1_SE5                = 5,     /*!< SE5 : single ended external GPIO connection to pad33.                     */
  ADC_SL1CFG_CHSEL1_SE6                = 6,     /*!< SE6 : single ended external GPIO connection to pad34.                     */
  ADC_SL1CFG_CHSEL1_SE7                = 7,     /*!< SE7 : single ended external GPIO connection to pad35.                     */
  ADC_SL1CFG_CHSEL1_SE8                = 8,     /*!< SE8 : single ended external GPIO connection to pad13.                     */
  ADC_SL1CFG_CHSEL1_SE9                = 9,     /*!< SE9 : single ended external GPIO connection to pad12.                     */
  ADC_SL1CFG_CHSEL1_DF0                = 10,    /*!< DF0 : differential external GPIO connections to pad12(N) and
                                                     pad13(P).                                                                 */
  ADC_SL1CFG_CHSEL1_DF1                = 11,    /*!< DF1 : differential external GPIO connections to pad15(N) and
                                                     pad14(P).                                                                 */
  ADC_SL1CFG_CHSEL1_TEMP               = 12,    /*!< TEMP : internal temperature sensor.                                       */
  ADC_SL1CFG_CHSEL1_BATT               = 13,    /*!< BATT : internal voltage divide-by-3 connection.                           */
  ADC_SL1CFG_CHSEL1_VSS                = 14,    /*!< VSS : Input VSS                                                           */
} ADC_SL1CFG_CHSEL1_Enum;

/* ================================================  ADC SL1CFG WCEN1 [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_SL1CFG_WCEN1                                                          */
  ADC_SL1CFG_WCEN1_WCEN                = 1,     /*!< WCEN : Enable the window compare for slot 1.                              */
} ADC_SL1CFG_WCEN1_Enum;

/* ================================================  ADC SL1CFG SLEN1 [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_SL1CFG_SLEN1                                                          */
  ADC_SL1CFG_SLEN1_SLEN                = 1,     /*!< SLEN : Enable slot 1 for ADC conversions.                                 */
} ADC_SL1CFG_SLEN1_Enum;

/* ========================================================  SL2CFG  ========================================================= */
/* ==============================================  ADC SL2CFG ADSEL2 [24..26]  =============================================== */
typedef enum {                                  /*!< ADC_SL2CFG_ADSEL2                                                         */
  ADC_SL2CFG_ADSEL2_AVG_1_MSRMT        = 0,     /*!< AVG_1_MSRMT : Average in 1 measurement in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL2CFG_ADSEL2_AVG_2_MSRMTS       = 1,     /*!< AVG_2_MSRMTS : Average in 2 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL2CFG_ADSEL2_AVG_4_MSRMTS       = 2,     /*!< AVG_4_MSRMTS : Average in 4 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL2CFG_ADSEL2_AVG_8_MSRMT        = 3,     /*!< AVG_8_MSRMT : Average in 8 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL2CFG_ADSEL2_AVG_16_MSRMTS      = 4,     /*!< AVG_16_MSRMTS : Average in 16 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL2CFG_ADSEL2_AVG_32_MSRMTS      = 5,     /*!< AVG_32_MSRMTS : Average in 32 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL2CFG_ADSEL2_AVG_64_MSRMTS      = 6,     /*!< AVG_64_MSRMTS : Average in 64 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL2CFG_ADSEL2_AVG_128_MSRMTS     = 7,     /*!< AVG_128_MSRMTS : Average in 128 measurements in the accumulate
                                                     divide module for this slot.                                              */
} ADC_SL2CFG_ADSEL2_Enum;

/* ==============================================  ADC SL2CFG PRMODE2 [16..17]  ============================================== */
typedef enum {                                  /*!< ADC_SL2CFG_PRMODE2                                                        */
  ADC_SL2CFG_PRMODE2_P14B              = 0,     /*!< P14B : 14-bit precision mode                                              */
  ADC_SL2CFG_PRMODE2_P12B              = 1,     /*!< P12B : 12-bit precision mode                                              */
  ADC_SL2CFG_PRMODE2_P10B              = 2,     /*!< P10B : 10-bit precision mode                                              */
  ADC_SL2CFG_PRMODE2_P8B               = 3,     /*!< P8B : 8-bit precision mode                                                */
} ADC_SL2CFG_PRMODE2_Enum;

/* ===============================================  ADC SL2CFG CHSEL2 [8..11]  =============================================== */
typedef enum {                                  /*!< ADC_SL2CFG_CHSEL2                                                         */
  ADC_SL2CFG_CHSEL2_SE0                = 0,     /*!< SE0 : single ended external GPIO connection to pad16.                     */
  ADC_SL2CFG_CHSEL2_SE1                = 1,     /*!< SE1 : single ended external GPIO connection to pad29.                     */
  ADC_SL2CFG_CHSEL2_SE2                = 2,     /*!< SE2 : single ended external GPIO connection to pad11.                     */
  ADC_SL2CFG_CHSEL2_SE3                = 3,     /*!< SE3 : single ended external GPIO connection to pad31.                     */
  ADC_SL2CFG_CHSEL2_SE4                = 4,     /*!< SE4 : single ended external GPIO connection to pad32.                     */
  ADC_SL2CFG_CHSEL2_SE5                = 5,     /*!< SE5 : single ended external GPIO connection to pad33.                     */
  ADC_SL2CFG_CHSEL2_SE6                = 6,     /*!< SE6 : single ended external GPIO connection to pad34.                     */
  ADC_SL2CFG_CHSEL2_SE7                = 7,     /*!< SE7 : single ended external GPIO connection to pad35.                     */
  ADC_SL2CFG_CHSEL2_SE8                = 8,     /*!< SE8 : single ended external GPIO connection to pad13.                     */
  ADC_SL2CFG_CHSEL2_SE9                = 9,     /*!< SE9 : single ended external GPIO connection to pad12.                     */
  ADC_SL2CFG_CHSEL2_DF0                = 10,    /*!< DF0 : differential external GPIO connections to pad12(N) and
                                                     pad13(P).                                                                 */
  ADC_SL2CFG_CHSEL2_DF1                = 11,    /*!< DF1 : differential external GPIO connections to pad15(N) and
                                                     pad14(P).                                                                 */
  ADC_SL2CFG_CHSEL2_TEMP               = 12,    /*!< TEMP : internal temperature sensor.                                       */
  ADC_SL2CFG_CHSEL2_BATT               = 13,    /*!< BATT : internal voltage divide-by-3 connection.                           */
  ADC_SL2CFG_CHSEL2_VSS                = 14,    /*!< VSS : Input VSS                                                           */
} ADC_SL2CFG_CHSEL2_Enum;

/* ================================================  ADC SL2CFG WCEN2 [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_SL2CFG_WCEN2                                                          */
  ADC_SL2CFG_WCEN2_WCEN                = 1,     /*!< WCEN : Enable the window compare for slot 2.                              */
} ADC_SL2CFG_WCEN2_Enum;

/* ================================================  ADC SL2CFG SLEN2 [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_SL2CFG_SLEN2                                                          */
  ADC_SL2CFG_SLEN2_SLEN                = 1,     /*!< SLEN : Enable slot 2 for ADC conversions.                                 */
} ADC_SL2CFG_SLEN2_Enum;

/* ========================================================  SL3CFG  ========================================================= */
/* ==============================================  ADC SL3CFG ADSEL3 [24..26]  =============================================== */
typedef enum {                                  /*!< ADC_SL3CFG_ADSEL3                                                         */
  ADC_SL3CFG_ADSEL3_AVG_1_MSRMT        = 0,     /*!< AVG_1_MSRMT : Average in 1 measurement in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL3CFG_ADSEL3_AVG_2_MSRMTS       = 1,     /*!< AVG_2_MSRMTS : Average in 2 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL3CFG_ADSEL3_AVG_4_MSRMTS       = 2,     /*!< AVG_4_MSRMTS : Average in 4 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL3CFG_ADSEL3_AVG_8_MSRMT        = 3,     /*!< AVG_8_MSRMT : Average in 8 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL3CFG_ADSEL3_AVG_16_MSRMTS      = 4,     /*!< AVG_16_MSRMTS : Average in 16 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL3CFG_ADSEL3_AVG_32_MSRMTS      = 5,     /*!< AVG_32_MSRMTS : Average in 32 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL3CFG_ADSEL3_AVG_64_MSRMTS      = 6,     /*!< AVG_64_MSRMTS : Average in 64 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL3CFG_ADSEL3_AVG_128_MSRMTS     = 7,     /*!< AVG_128_MSRMTS : Average in 128 measurements in the accumulate
                                                     divide module for this slot.                                              */
} ADC_SL3CFG_ADSEL3_Enum;

/* ==============================================  ADC SL3CFG PRMODE3 [16..17]  ============================================== */
typedef enum {                                  /*!< ADC_SL3CFG_PRMODE3                                                        */
  ADC_SL3CFG_PRMODE3_P14B              = 0,     /*!< P14B : 14-bit precision mode                                              */
  ADC_SL3CFG_PRMODE3_P12B              = 1,     /*!< P12B : 12-bit precision mode                                              */
  ADC_SL3CFG_PRMODE3_P10B              = 2,     /*!< P10B : 10-bit precision mode                                              */
  ADC_SL3CFG_PRMODE3_P8B               = 3,     /*!< P8B : 8-bit precision mode                                                */
} ADC_SL3CFG_PRMODE3_Enum;

/* ===============================================  ADC SL3CFG CHSEL3 [8..11]  =============================================== */
typedef enum {                                  /*!< ADC_SL3CFG_CHSEL3                                                         */
  ADC_SL3CFG_CHSEL3_SE0                = 0,     /*!< SE0 : single ended external GPIO connection to pad16.                     */
  ADC_SL3CFG_CHSEL3_SE1                = 1,     /*!< SE1 : single ended external GPIO connection to pad29.                     */
  ADC_SL3CFG_CHSEL3_SE2                = 2,     /*!< SE2 : single ended external GPIO connection to pad11.                     */
  ADC_SL3CFG_CHSEL3_SE3                = 3,     /*!< SE3 : single ended external GPIO connection to pad31.                     */
  ADC_SL3CFG_CHSEL3_SE4                = 4,     /*!< SE4 : single ended external GPIO connection to pad32.                     */
  ADC_SL3CFG_CHSEL3_SE5                = 5,     /*!< SE5 : single ended external GPIO connection to pad33.                     */
  ADC_SL3CFG_CHSEL3_SE6                = 6,     /*!< SE6 : single ended external GPIO connection to pad34.                     */
  ADC_SL3CFG_CHSEL3_SE7                = 7,     /*!< SE7 : single ended external GPIO connection to pad35.                     */
  ADC_SL3CFG_CHSEL3_SE8                = 8,     /*!< SE8 : single ended external GPIO connection to pad13.                     */
  ADC_SL3CFG_CHSEL3_SE9                = 9,     /*!< SE9 : single ended external GPIO connection to pad12.                     */
  ADC_SL3CFG_CHSEL3_DF0                = 10,    /*!< DF0 : differential external GPIO connections to pad12(N) and
                                                     pad13(P).                                                                 */
  ADC_SL3CFG_CHSEL3_DF1                = 11,    /*!< DF1 : differential external GPIO connections to pad15(N) and
                                                     pad14(P).                                                                 */
  ADC_SL3CFG_CHSEL3_TEMP               = 12,    /*!< TEMP : internal temperature sensor.                                       */
  ADC_SL3CFG_CHSEL3_BATT               = 13,    /*!< BATT : internal voltage divide-by-3 connection.                           */
  ADC_SL3CFG_CHSEL3_VSS                = 14,    /*!< VSS : Input VSS                                                           */
} ADC_SL3CFG_CHSEL3_Enum;

/* ================================================  ADC SL3CFG WCEN3 [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_SL3CFG_WCEN3                                                          */
  ADC_SL3CFG_WCEN3_WCEN                = 1,     /*!< WCEN : Enable the window compare for slot 3.                              */
} ADC_SL3CFG_WCEN3_Enum;

/* ================================================  ADC SL3CFG SLEN3 [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_SL3CFG_SLEN3                                                          */
  ADC_SL3CFG_SLEN3_SLEN                = 1,     /*!< SLEN : Enable slot 3 for ADC conversions.                                 */
} ADC_SL3CFG_SLEN3_Enum;

/* ========================================================  SL4CFG  ========================================================= */
/* ==============================================  ADC SL4CFG ADSEL4 [24..26]  =============================================== */
typedef enum {                                  /*!< ADC_SL4CFG_ADSEL4                                                         */
  ADC_SL4CFG_ADSEL4_AVG_1_MSRMT        = 0,     /*!< AVG_1_MSRMT : Average in 1 measurement in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL4CFG_ADSEL4_AVG_2_MSRMTS       = 1,     /*!< AVG_2_MSRMTS : Average in 2 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL4CFG_ADSEL4_AVG_4_MSRMTS       = 2,     /*!< AVG_4_MSRMTS : Average in 4 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL4CFG_ADSEL4_AVG_8_MSRMT        = 3,     /*!< AVG_8_MSRMT : Average in 8 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL4CFG_ADSEL4_AVG_16_MSRMTS      = 4,     /*!< AVG_16_MSRMTS : Average in 16 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL4CFG_ADSEL4_AVG_32_MSRMTS      = 5,     /*!< AVG_32_MSRMTS : Average in 32 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL4CFG_ADSEL4_AVG_64_MSRMTS      = 6,     /*!< AVG_64_MSRMTS : Average in 64 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL4CFG_ADSEL4_AVG_128_MSRMTS     = 7,     /*!< AVG_128_MSRMTS : Average in 128 measurements in the accumulate
                                                     divide module for this slot.                                              */
} ADC_SL4CFG_ADSEL4_Enum;

/* ==============================================  ADC SL4CFG PRMODE4 [16..17]  ============================================== */
typedef enum {                                  /*!< ADC_SL4CFG_PRMODE4                                                        */
  ADC_SL4CFG_PRMODE4_P14B              = 0,     /*!< P14B : 14-bit precision mode                                              */
  ADC_SL4CFG_PRMODE4_P12B              = 1,     /*!< P12B : 12-bit precision mode                                              */
  ADC_SL4CFG_PRMODE4_P10B              = 2,     /*!< P10B : 10-bit precision mode                                              */
  ADC_SL4CFG_PRMODE4_P8B               = 3,     /*!< P8B : 8-bit precision mode                                                */
} ADC_SL4CFG_PRMODE4_Enum;

/* ===============================================  ADC SL4CFG CHSEL4 [8..11]  =============================================== */
typedef enum {                                  /*!< ADC_SL4CFG_CHSEL4                                                         */
  ADC_SL4CFG_CHSEL4_SE0                = 0,     /*!< SE0 : single ended external GPIO connection to pad16.                     */
  ADC_SL4CFG_CHSEL4_SE1                = 1,     /*!< SE1 : single ended external GPIO connection to pad29.                     */
  ADC_SL4CFG_CHSEL4_SE2                = 2,     /*!< SE2 : single ended external GPIO connection to pad11.                     */
  ADC_SL4CFG_CHSEL4_SE3                = 3,     /*!< SE3 : single ended external GPIO connection to pad31.                     */
  ADC_SL4CFG_CHSEL4_SE4                = 4,     /*!< SE4 : single ended external GPIO connection to pad32.                     */
  ADC_SL4CFG_CHSEL4_SE5                = 5,     /*!< SE5 : single ended external GPIO connection to pad33.                     */
  ADC_SL4CFG_CHSEL4_SE6                = 6,     /*!< SE6 : single ended external GPIO connection to pad34.                     */
  ADC_SL4CFG_CHSEL4_SE7                = 7,     /*!< SE7 : single ended external GPIO connection to pad35.                     */
  ADC_SL4CFG_CHSEL4_SE8                = 8,     /*!< SE8 : single ended external GPIO connection to pad13.                     */
  ADC_SL4CFG_CHSEL4_SE9                = 9,     /*!< SE9 : single ended external GPIO connection to pad12.                     */
  ADC_SL4CFG_CHSEL4_DF0                = 10,    /*!< DF0 : differential external GPIO connections to pad12(N) and
                                                     pad13(P).                                                                 */
  ADC_SL4CFG_CHSEL4_DF1                = 11,    /*!< DF1 : differential external GPIO connections to pad15(N) and
                                                     pad14(P).                                                                 */
  ADC_SL4CFG_CHSEL4_TEMP               = 12,    /*!< TEMP : internal temperature sensor.                                       */
  ADC_SL4CFG_CHSEL4_BATT               = 13,    /*!< BATT : internal voltage divide-by-3 connection.                           */
  ADC_SL4CFG_CHSEL4_VSS                = 14,    /*!< VSS : Input VSS                                                           */
} ADC_SL4CFG_CHSEL4_Enum;

/* ================================================  ADC SL4CFG WCEN4 [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_SL4CFG_WCEN4                                                          */
  ADC_SL4CFG_WCEN4_WCEN                = 1,     /*!< WCEN : Enable the window compare for slot 4.                              */
} ADC_SL4CFG_WCEN4_Enum;

/* ================================================  ADC SL4CFG SLEN4 [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_SL4CFG_SLEN4                                                          */
  ADC_SL4CFG_SLEN4_SLEN                = 1,     /*!< SLEN : Enable slot 4 for ADC conversions.                                 */
} ADC_SL4CFG_SLEN4_Enum;

/* ========================================================  SL5CFG  ========================================================= */
/* ==============================================  ADC SL5CFG ADSEL5 [24..26]  =============================================== */
typedef enum {                                  /*!< ADC_SL5CFG_ADSEL5                                                         */
  ADC_SL5CFG_ADSEL5_AVG_1_MSRMT        = 0,     /*!< AVG_1_MSRMT : Average in 1 measurement in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL5CFG_ADSEL5_AVG_2_MSRMTS       = 1,     /*!< AVG_2_MSRMTS : Average in 2 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL5CFG_ADSEL5_AVG_4_MSRMTS       = 2,     /*!< AVG_4_MSRMTS : Average in 4 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL5CFG_ADSEL5_AVG_8_MSRMT        = 3,     /*!< AVG_8_MSRMT : Average in 8 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL5CFG_ADSEL5_AVG_16_MSRMTS      = 4,     /*!< AVG_16_MSRMTS : Average in 16 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL5CFG_ADSEL5_AVG_32_MSRMTS      = 5,     /*!< AVG_32_MSRMTS : Average in 32 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL5CFG_ADSEL5_AVG_64_MSRMTS      = 6,     /*!< AVG_64_MSRMTS : Average in 64 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL5CFG_ADSEL5_AVG_128_MSRMTS     = 7,     /*!< AVG_128_MSRMTS : Average in 128 measurements in the accumulate
                                                     divide module for this slot.                                              */
} ADC_SL5CFG_ADSEL5_Enum;

/* ==============================================  ADC SL5CFG PRMODE5 [16..17]  ============================================== */
typedef enum {                                  /*!< ADC_SL5CFG_PRMODE5                                                        */
  ADC_SL5CFG_PRMODE5_P14B              = 0,     /*!< P14B : 14-bit precision mode                                              */
  ADC_SL5CFG_PRMODE5_P12B              = 1,     /*!< P12B : 12-bit precision mode                                              */
  ADC_SL5CFG_PRMODE5_P10B              = 2,     /*!< P10B : 10-bit precision mode                                              */
  ADC_SL5CFG_PRMODE5_P8B               = 3,     /*!< P8B : 8-bit precision mode                                                */
} ADC_SL5CFG_PRMODE5_Enum;

/* ===============================================  ADC SL5CFG CHSEL5 [8..11]  =============================================== */
typedef enum {                                  /*!< ADC_SL5CFG_CHSEL5                                                         */
  ADC_SL5CFG_CHSEL5_SE0                = 0,     /*!< SE0 : single ended external GPIO connection to pad16.                     */
  ADC_SL5CFG_CHSEL5_SE1                = 1,     /*!< SE1 : single ended external GPIO connection to pad29.                     */
  ADC_SL5CFG_CHSEL5_SE2                = 2,     /*!< SE2 : single ended external GPIO connection to pad11.                     */
  ADC_SL5CFG_CHSEL5_SE3                = 3,     /*!< SE3 : single ended external GPIO connection to pad31.                     */
  ADC_SL5CFG_CHSEL5_SE4                = 4,     /*!< SE4 : single ended external GPIO connection to pad32.                     */
  ADC_SL5CFG_CHSEL5_SE5                = 5,     /*!< SE5 : single ended external GPIO connection to pad33.                     */
  ADC_SL5CFG_CHSEL5_SE6                = 6,     /*!< SE6 : single ended external GPIO connection to pad34.                     */
  ADC_SL5CFG_CHSEL5_SE7                = 7,     /*!< SE7 : single ended external GPIO connection to pad35.                     */
  ADC_SL5CFG_CHSEL5_SE8                = 8,     /*!< SE8 : single ended external GPIO connection to pad13.                     */
  ADC_SL5CFG_CHSEL5_SE9                = 9,     /*!< SE9 : single ended external GPIO connection to pad12.                     */
  ADC_SL5CFG_CHSEL5_DF0                = 10,    /*!< DF0 : differential external GPIO connections to pad12(N) and
                                                     pad13(P).                                                                 */
  ADC_SL5CFG_CHSEL5_DF1                = 11,    /*!< DF1 : differential external GPIO connections to pad15(N) and
                                                     pad14(P).                                                                 */
  ADC_SL5CFG_CHSEL5_TEMP               = 12,    /*!< TEMP : internal temperature sensor.                                       */
  ADC_SL5CFG_CHSEL5_BATT               = 13,    /*!< BATT : internal voltage divide-by-3 connection.                           */
  ADC_SL5CFG_CHSEL5_VSS                = 14,    /*!< VSS : Input VSS                                                           */
} ADC_SL5CFG_CHSEL5_Enum;

/* ================================================  ADC SL5CFG WCEN5 [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_SL5CFG_WCEN5                                                          */
  ADC_SL5CFG_WCEN5_WCEN                = 1,     /*!< WCEN : Enable the window compare for slot 5.                              */
} ADC_SL5CFG_WCEN5_Enum;

/* ================================================  ADC SL5CFG SLEN5 [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_SL5CFG_SLEN5                                                          */
  ADC_SL5CFG_SLEN5_SLEN                = 1,     /*!< SLEN : Enable slot 5 for ADC conversions.                                 */
} ADC_SL5CFG_SLEN5_Enum;

/* ========================================================  SL6CFG  ========================================================= */
/* ==============================================  ADC SL6CFG ADSEL6 [24..26]  =============================================== */
typedef enum {                                  /*!< ADC_SL6CFG_ADSEL6                                                         */
  ADC_SL6CFG_ADSEL6_AVG_1_MSRMT        = 0,     /*!< AVG_1_MSRMT : Average in 1 measurement in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL6CFG_ADSEL6_AVG_2_MSRMTS       = 1,     /*!< AVG_2_MSRMTS : Average in 2 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL6CFG_ADSEL6_AVG_4_MSRMTS       = 2,     /*!< AVG_4_MSRMTS : Average in 4 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL6CFG_ADSEL6_AVG_8_MSRMT        = 3,     /*!< AVG_8_MSRMT : Average in 8 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL6CFG_ADSEL6_AVG_16_MSRMTS      = 4,     /*!< AVG_16_MSRMTS : Average in 16 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL6CFG_ADSEL6_AVG_32_MSRMTS      = 5,     /*!< AVG_32_MSRMTS : Average in 32 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL6CFG_ADSEL6_AVG_64_MSRMTS      = 6,     /*!< AVG_64_MSRMTS : Average in 64 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL6CFG_ADSEL6_AVG_128_MSRMTS     = 7,     /*!< AVG_128_MSRMTS : Average in 128 measurements in the accumulate
                                                     divide module for this slot.                                              */
} ADC_SL6CFG_ADSEL6_Enum;

/* ==============================================  ADC SL6CFG PRMODE6 [16..17]  ============================================== */
typedef enum {                                  /*!< ADC_SL6CFG_PRMODE6                                                        */
  ADC_SL6CFG_PRMODE6_P14B              = 0,     /*!< P14B : 14-bit precision mode                                              */
  ADC_SL6CFG_PRMODE6_P12B              = 1,     /*!< P12B : 12-bit precision mode                                              */
  ADC_SL6CFG_PRMODE6_P10B              = 2,     /*!< P10B : 10-bit precision mode                                              */
  ADC_SL6CFG_PRMODE6_P8B               = 3,     /*!< P8B : 8-bit precision mode                                                */
} ADC_SL6CFG_PRMODE6_Enum;

/* ===============================================  ADC SL6CFG CHSEL6 [8..11]  =============================================== */
typedef enum {                                  /*!< ADC_SL6CFG_CHSEL6                                                         */
  ADC_SL6CFG_CHSEL6_SE0                = 0,     /*!< SE0 : single ended external GPIO connection to pad16.                     */
  ADC_SL6CFG_CHSEL6_SE1                = 1,     /*!< SE1 : single ended external GPIO connection to pad29.                     */
  ADC_SL6CFG_CHSEL6_SE2                = 2,     /*!< SE2 : single ended external GPIO connection to pad11.                     */
  ADC_SL6CFG_CHSEL6_SE3                = 3,     /*!< SE3 : single ended external GPIO connection to pad31.                     */
  ADC_SL6CFG_CHSEL6_SE4                = 4,     /*!< SE4 : single ended external GPIO connection to pad32.                     */
  ADC_SL6CFG_CHSEL6_SE5                = 5,     /*!< SE5 : single ended external GPIO connection to pad33.                     */
  ADC_SL6CFG_CHSEL6_SE6                = 6,     /*!< SE6 : single ended external GPIO connection to pad34.                     */
  ADC_SL6CFG_CHSEL6_SE7                = 7,     /*!< SE7 : single ended external GPIO connection to pad35.                     */
  ADC_SL6CFG_CHSEL6_SE8                = 8,     /*!< SE8 : single ended external GPIO connection to pad13.                     */
  ADC_SL6CFG_CHSEL6_SE9                = 9,     /*!< SE9 : single ended external GPIO connection to pad12.                     */
  ADC_SL6CFG_CHSEL6_DF0                = 10,    /*!< DF0 : differential external GPIO connections to pad12(N) and
                                                     pad13(P).                                                                 */
  ADC_SL6CFG_CHSEL6_DF1                = 11,    /*!< DF1 : differential external GPIO connections to pad15(N) and
                                                     pad14(P).                                                                 */
  ADC_SL6CFG_CHSEL6_TEMP               = 12,    /*!< TEMP : internal temperature sensor.                                       */
  ADC_SL6CFG_CHSEL6_BATT               = 13,    /*!< BATT : internal voltage divide-by-3 connection.                           */
  ADC_SL6CFG_CHSEL6_VSS                = 14,    /*!< VSS : Input VSS                                                           */
} ADC_SL6CFG_CHSEL6_Enum;

/* ================================================  ADC SL6CFG WCEN6 [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_SL6CFG_WCEN6                                                          */
  ADC_SL6CFG_WCEN6_WCEN                = 1,     /*!< WCEN : Enable the window compare for slot 6.                              */
} ADC_SL6CFG_WCEN6_Enum;

/* ================================================  ADC SL6CFG SLEN6 [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_SL6CFG_SLEN6                                                          */
  ADC_SL6CFG_SLEN6_SLEN                = 1,     /*!< SLEN : Enable slot 6 for ADC conversions.                                 */
} ADC_SL6CFG_SLEN6_Enum;

/* ========================================================  SL7CFG  ========================================================= */
/* ==============================================  ADC SL7CFG ADSEL7 [24..26]  =============================================== */
typedef enum {                                  /*!< ADC_SL7CFG_ADSEL7                                                         */
  ADC_SL7CFG_ADSEL7_AVG_1_MSRMT        = 0,     /*!< AVG_1_MSRMT : Average in 1 measurement in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL7CFG_ADSEL7_AVG_2_MSRMTS       = 1,     /*!< AVG_2_MSRMTS : Average in 2 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL7CFG_ADSEL7_AVG_4_MSRMTS       = 2,     /*!< AVG_4_MSRMTS : Average in 4 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL7CFG_ADSEL7_AVG_8_MSRMT        = 3,     /*!< AVG_8_MSRMT : Average in 8 measurements in the accumulate divide
                                                     module for this slot.                                                     */
  ADC_SL7CFG_ADSEL7_AVG_16_MSRMTS      = 4,     /*!< AVG_16_MSRMTS : Average in 16 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL7CFG_ADSEL7_AVG_32_MSRMTS      = 5,     /*!< AVG_32_MSRMTS : Average in 32 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL7CFG_ADSEL7_AVG_64_MSRMTS      = 6,     /*!< AVG_64_MSRMTS : Average in 64 measurements in the accumulate
                                                     divide module for this slot.                                              */
  ADC_SL7CFG_ADSEL7_AVG_128_MSRMTS     = 7,     /*!< AVG_128_MSRMTS : Average in 128 measurements in the accumulate
                                                     divide module for this slot.                                              */
} ADC_SL7CFG_ADSEL7_Enum;

/* ==============================================  ADC SL7CFG PRMODE7 [16..17]  ============================================== */
typedef enum {                                  /*!< ADC_SL7CFG_PRMODE7                                                        */
  ADC_SL7CFG_PRMODE7_P14B              = 0,     /*!< P14B : 14-bit precision mode                                              */
  ADC_SL7CFG_PRMODE7_P12B              = 1,     /*!< P12B : 12-bit precision mode                                              */
  ADC_SL7CFG_PRMODE7_P10B              = 2,     /*!< P10B : 10-bit precision mode                                              */
  ADC_SL7CFG_PRMODE7_P8B               = 3,     /*!< P8B : 8-bit precision mode                                                */
} ADC_SL7CFG_PRMODE7_Enum;

/* ===============================================  ADC SL7CFG CHSEL7 [8..11]  =============================================== */
typedef enum {                                  /*!< ADC_SL7CFG_CHSEL7                                                         */
  ADC_SL7CFG_CHSEL7_SE0                = 0,     /*!< SE0 : single ended external GPIO connection to pad16.                     */
  ADC_SL7CFG_CHSEL7_SE1                = 1,     /*!< SE1 : single ended external GPIO connection to pad29.                     */
  ADC_SL7CFG_CHSEL7_SE2                = 2,     /*!< SE2 : single ended external GPIO connection to pad11.                     */
  ADC_SL7CFG_CHSEL7_SE3                = 3,     /*!< SE3 : single ended external GPIO connection to pad31.                     */
  ADC_SL7CFG_CHSEL7_SE4                = 4,     /*!< SE4 : single ended external GPIO connection to pad32.                     */
  ADC_SL7CFG_CHSEL7_SE5                = 5,     /*!< SE5 : single ended external GPIO connection to pad33.                     */
  ADC_SL7CFG_CHSEL7_SE6                = 6,     /*!< SE6 : single ended external GPIO connection to pad34.                     */
  ADC_SL7CFG_CHSEL7_SE7                = 7,     /*!< SE7 : single ended external GPIO connection to pad35.                     */
  ADC_SL7CFG_CHSEL7_SE8                = 8,     /*!< SE8 : single ended external GPIO connection to pad13.                     */
  ADC_SL7CFG_CHSEL7_SE9                = 9,     /*!< SE9 : single ended external GPIO connection to pad12.                     */
  ADC_SL7CFG_CHSEL7_DF0                = 10,    /*!< DF0 : differential external GPIO connections to pad12(N) and
                                                     pad13(P).                                                                 */
  ADC_SL7CFG_CHSEL7_DF1                = 11,    /*!< DF1 : differential external GPIO connections to pad15(N) and
                                                     pad14(P).                                                                 */
  ADC_SL7CFG_CHSEL7_TEMP               = 12,    /*!< TEMP : internal temperature sensor.                                       */
  ADC_SL7CFG_CHSEL7_BATT               = 13,    /*!< BATT : internal voltage divide-by-3 connection.                           */
  ADC_SL7CFG_CHSEL7_VSS                = 14,    /*!< VSS : Input VSS                                                           */
} ADC_SL7CFG_CHSEL7_Enum;

/* ================================================  ADC SL7CFG WCEN7 [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_SL7CFG_WCEN7                                                          */
  ADC_SL7CFG_WCEN7_WCEN                = 1,     /*!< WCEN : Enable the window compare for slot 7.                              */
} ADC_SL7CFG_WCEN7_Enum;

/* ================================================  ADC SL7CFG SLEN7 [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_SL7CFG_SLEN7                                                          */
  ADC_SL7CFG_SLEN7_SLEN                = 1,     /*!< SLEN : Enable slot 7 for ADC conversions.                                 */
} ADC_SL7CFG_SLEN7_Enum;

/* =========================================================  WULIM  ========================================================= */
/* =========================================================  WLLIM  ========================================================= */
/* =========================================================  FIFO  ========================================================== */
/* =========================================================  INTEN  ========================================================= */
/* ================================================  ADC INTEN WCINC [5..5]  ================================================= */
typedef enum {                                  /*!< ADC_INTEN_WCINC                                                           */
  ADC_INTEN_WCINC_WCINCINT             = 1,     /*!< WCINCINT : Window comparitor voltage incursion interrupt.                 */
} ADC_INTEN_WCINC_Enum;

/* ================================================  ADC INTEN WCEXC [4..4]  ================================================= */
typedef enum {                                  /*!< ADC_INTEN_WCEXC                                                           */
  ADC_INTEN_WCEXC_WCEXCINT             = 1,     /*!< WCEXCINT : Window comparitor voltage excursion interrupt.                 */
} ADC_INTEN_WCEXC_Enum;

/* ===============================================  ADC INTEN FIFOOVR2 [3..3]  =============================================== */
typedef enum {                                  /*!< ADC_INTEN_FIFOOVR2                                                        */
  ADC_INTEN_FIFOOVR2_FIFOFULLINT       = 1,     /*!< FIFOFULLINT : FIFO 100 percent full interrupt.                            */
} ADC_INTEN_FIFOOVR2_Enum;

/* ===============================================  ADC INTEN FIFOOVR1 [2..2]  =============================================== */
typedef enum {                                  /*!< ADC_INTEN_FIFOOVR1                                                        */
  ADC_INTEN_FIFOOVR1_FIFO75INT         = 1,     /*!< FIFO75INT : FIFO 75 percent full interrupt.                               */
} ADC_INTEN_FIFOOVR1_Enum;

/* ================================================  ADC INTEN SCNCMP [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_INTEN_SCNCMP                                                          */
  ADC_INTEN_SCNCMP_SCNCMPINT           = 1,     /*!< SCNCMPINT : ADC scan complete interrupt.                                  */
} ADC_INTEN_SCNCMP_Enum;

/* ================================================  ADC INTEN CNVCMP [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_INTEN_CNVCMP                                                          */
  ADC_INTEN_CNVCMP_CNVCMPINT           = 1,     /*!< CNVCMPINT : ADC conversion complete interrupt.                            */
} ADC_INTEN_CNVCMP_Enum;

/* ========================================================  INTSTAT  ======================================================== */
/* ===============================================  ADC INTSTAT WCINC [5..5]  ================================================ */
typedef enum {                                  /*!< ADC_INTSTAT_WCINC                                                         */
  ADC_INTSTAT_WCINC_WCINCINT           = 1,     /*!< WCINCINT : Window comparitor voltage incursion interrupt.                 */
} ADC_INTSTAT_WCINC_Enum;

/* ===============================================  ADC INTSTAT WCEXC [4..4]  ================================================ */
typedef enum {                                  /*!< ADC_INTSTAT_WCEXC                                                         */
  ADC_INTSTAT_WCEXC_WCEXCINT           = 1,     /*!< WCEXCINT : Window comparitor voltage excursion interrupt.                 */
} ADC_INTSTAT_WCEXC_Enum;

/* ==============================================  ADC INTSTAT FIFOOVR2 [3..3]  ============================================== */
typedef enum {                                  /*!< ADC_INTSTAT_FIFOOVR2                                                      */
  ADC_INTSTAT_FIFOOVR2_FIFOFULLINT     = 1,     /*!< FIFOFULLINT : FIFO 100 percent full interrupt.                            */
} ADC_INTSTAT_FIFOOVR2_Enum;

/* ==============================================  ADC INTSTAT FIFOOVR1 [2..2]  ============================================== */
typedef enum {                                  /*!< ADC_INTSTAT_FIFOOVR1                                                      */
  ADC_INTSTAT_FIFOOVR1_FIFO75INT       = 1,     /*!< FIFO75INT : FIFO 75 percent full interrupt.                               */
} ADC_INTSTAT_FIFOOVR1_Enum;

/* ===============================================  ADC INTSTAT SCNCMP [1..1]  =============================================== */
typedef enum {                                  /*!< ADC_INTSTAT_SCNCMP                                                        */
  ADC_INTSTAT_SCNCMP_SCNCMPINT         = 1,     /*!< SCNCMPINT : ADC scan complete interrupt.                                  */
} ADC_INTSTAT_SCNCMP_Enum;

/* ===============================================  ADC INTSTAT CNVCMP [0..0]  =============================================== */
typedef enum {                                  /*!< ADC_INTSTAT_CNVCMP                                                        */
  ADC_INTSTAT_CNVCMP_CNVCMPINT         = 1,     /*!< CNVCMPINT : ADC conversion complete interrupt.                            */
} ADC_INTSTAT_CNVCMP_Enum;

/* ========================================================  INTCLR  ========================================================= */
/* ================================================  ADC INTCLR WCINC [5..5]  ================================================ */
typedef enum {                                  /*!< ADC_INTCLR_WCINC                                                          */
  ADC_INTCLR_WCINC_WCINCINT            = 1,     /*!< WCINCINT : Window comparitor voltage incursion interrupt.                 */
} ADC_INTCLR_WCINC_Enum;

/* ================================================  ADC INTCLR WCEXC [4..4]  ================================================ */
typedef enum {                                  /*!< ADC_INTCLR_WCEXC                                                          */
  ADC_INTCLR_WCEXC_WCEXCINT            = 1,     /*!< WCEXCINT : Window comparitor voltage excursion interrupt.                 */
} ADC_INTCLR_WCEXC_Enum;

/* ==============================================  ADC INTCLR FIFOOVR2 [3..3]  =============================================== */
typedef enum {                                  /*!< ADC_INTCLR_FIFOOVR2                                                       */
  ADC_INTCLR_FIFOOVR2_FIFOFULLINT      = 1,     /*!< FIFOFULLINT : FIFO 100 percent full interrupt.                            */
} ADC_INTCLR_FIFOOVR2_Enum;

/* ==============================================  ADC INTCLR FIFOOVR1 [2..2]  =============================================== */
typedef enum {                                  /*!< ADC_INTCLR_FIFOOVR1                                                       */
  ADC_INTCLR_FIFOOVR1_FIFO75INT        = 1,     /*!< FIFO75INT : FIFO 75 percent full interrupt.                               */
} ADC_INTCLR_FIFOOVR1_Enum;

/* ===============================================  ADC INTCLR SCNCMP [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_INTCLR_SCNCMP                                                         */
  ADC_INTCLR_SCNCMP_SCNCMPINT          = 1,     /*!< SCNCMPINT : ADC scan complete interrupt.                                  */
} ADC_INTCLR_SCNCMP_Enum;

/* ===============================================  ADC INTCLR CNVCMP [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_INTCLR_CNVCMP                                                         */
  ADC_INTCLR_CNVCMP_CNVCMPINT          = 1,     /*!< CNVCMPINT : ADC conversion complete interrupt.                            */
} ADC_INTCLR_CNVCMP_Enum;

/* ========================================================  INTSET  ========================================================= */
/* ================================================  ADC INTSET WCINC [5..5]  ================================================ */
typedef enum {                                  /*!< ADC_INTSET_WCINC                                                          */
  ADC_INTSET_WCINC_WCINCINT            = 1,     /*!< WCINCINT : Window comparitor voltage incursion interrupt.                 */
} ADC_INTSET_WCINC_Enum;

/* ================================================  ADC INTSET WCEXC [4..4]  ================================================ */
typedef enum {                                  /*!< ADC_INTSET_WCEXC                                                          */
  ADC_INTSET_WCEXC_WCEXCINT            = 1,     /*!< WCEXCINT : Window comparitor voltage excursion interrupt.                 */
} ADC_INTSET_WCEXC_Enum;

/* ==============================================  ADC INTSET FIFOOVR2 [3..3]  =============================================== */
typedef enum {                                  /*!< ADC_INTSET_FIFOOVR2                                                       */
  ADC_INTSET_FIFOOVR2_FIFOFULLINT      = 1,     /*!< FIFOFULLINT : FIFO 100 percent full interrupt.                            */
} ADC_INTSET_FIFOOVR2_Enum;

/* ==============================================  ADC INTSET FIFOOVR1 [2..2]  =============================================== */
typedef enum {                                  /*!< ADC_INTSET_FIFOOVR1                                                       */
  ADC_INTSET_FIFOOVR1_FIFO75INT        = 1,     /*!< FIFO75INT : FIFO 75 percent full interrupt.                               */
} ADC_INTSET_FIFOOVR1_Enum;

/* ===============================================  ADC INTSET SCNCMP [1..1]  ================================================ */
typedef enum {                                  /*!< ADC_INTSET_SCNCMP                                                         */
  ADC_INTSET_SCNCMP_SCNCMPINT          = 1,     /*!< SCNCMPINT : ADC scan complete interrupt.                                  */
} ADC_INTSET_SCNCMP_Enum;

/* ===============================================  ADC INTSET CNVCMP [0..0]  ================================================ */
typedef enum {                                  /*!< ADC_INTSET_CNVCMP                                                         */
  ADC_INTSET_CNVCMP_CNVCMPINT          = 1,     /*!< CNVCMPINT : ADC conversion complete interrupt.                            */
} ADC_INTSET_CNVCMP_Enum;



/* =========================================================================================================================== */
/* ================                                         CACHECTRL                                         ================ */
/* =========================================================================================================================== */

/* =======================================================  CACHECFG  ======================================================== */
/* ===========================================  CACHECTRL CACHECFG CONFIG [4..6]  ============================================ */
typedef enum {                                  /*!< CACHECTRL_CACHECFG_CONFIG                                                 */
  CACHECTRL_CACHECFG_CONFIG_W2_128B_512E = 5,   /*!< W2_128B_512E : Two-way set associative, 128-bit linesize, 512
                                                     entries (8 SRAMs active)                                                  */
} CACHECTRL_CACHECFG_CONFIG_Enum;

/* =======================================================  FLASHCFG  ======================================================== */
/* =========================================================  CTRL  ========================================================== */
/* ===========================================  CACHECTRL CTRL RESET_STAT [1..1]  ============================================ */
typedef enum {                                  /*!< CACHECTRL_CTRL_RESET_STAT                                                 */
  CACHECTRL_CTRL_RESET_STAT_CLEAR      = 1,     /*!< CLEAR : Clear Cache Stats                                                 */
} CACHECTRL_CTRL_RESET_STAT_Enum;

/* ===========================================  CACHECTRL CTRL INVALIDATE [0..0]  ============================================ */
typedef enum {                                  /*!< CACHECTRL_CTRL_INVALIDATE                                                 */
  CACHECTRL_CTRL_INVALIDATE_GO         = 1,     /*!< GO : Initiate a programming operation to flash info.                      */
} CACHECTRL_CTRL_INVALIDATE_Enum;

/* =======================================================  NCR0START  ======================================================= */
/* ========================================================  NCR0END  ======================================================== */
/* =======================================================  NCR1START  ======================================================= */
/* ========================================================  NCR1END  ======================================================== */
/* =======================================================  CACHEMODE  ======================================================= */
/* =========================================================  DMON0  ========================================================= */
/* =========================================================  DMON1  ========================================================= */
/* =========================================================  DMON2  ========================================================= */
/* =========================================================  DMON3  ========================================================= */
/* =========================================================  IMON0  ========================================================= */
/* =========================================================  IMON1  ========================================================= */
/* =========================================================  IMON2  ========================================================= */
/* =========================================================  IMON3  ========================================================= */


/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  CALXT  ========================================================= */
/* =========================================================  CALRC  ========================================================= */
/* ========================================================  ACALCTR  ======================================================== */
/* =========================================================  OCTRL  ========================================================= */
/* ===============================================  CLKGEN OCTRL ACAL [8..10]  =============================================== */
typedef enum {                                  /*!< CLKGEN_OCTRL_ACAL                                                         */
  CLKGEN_OCTRL_ACAL_DIS                = 0,     /*!< DIS : Disable Autocalibration                                             */
  CLKGEN_OCTRL_ACAL_1024SEC            = 2,     /*!< 1024SEC : Autocalibrate every 1024 seconds                                */
  CLKGEN_OCTRL_ACAL_512SEC             = 3,     /*!< 512SEC : Autocalibrate every 512 seconds                                  */
  CLKGEN_OCTRL_ACAL_XTFREQ             = 6,     /*!< XTFREQ : Frequency measurement using XT                                   */
  CLKGEN_OCTRL_ACAL_EXTFREQ            = 7,     /*!< EXTFREQ : Frequency measurement using external clock                      */
} CLKGEN_OCTRL_ACAL_Enum;

/* ===============================================  CLKGEN OCTRL OSEL [7..7]  ================================================ */
typedef enum {                                  /*!< CLKGEN_OCTRL_OSEL                                                         */
  CLKGEN_OCTRL_OSEL_RTC_XT             = 0,     /*!< RTC_XT : RTC uses the XT                                                  */
  CLKGEN_OCTRL_OSEL_RTC_LFRC           = 1,     /*!< RTC_LFRC : RTC uses the LFRC                                              */
} CLKGEN_OCTRL_OSEL_Enum;

/* ================================================  CLKGEN OCTRL FOS [6..6]  ================================================ */
typedef enum {                                  /*!< CLKGEN_OCTRL_FOS                                                          */
  CLKGEN_OCTRL_FOS_DIS                 = 0,     /*!< DIS : Disable the oscillator switch on failure function                   */
  CLKGEN_OCTRL_FOS_EN                  = 1,     /*!< EN : Enable the oscillator switch on failure function                     */
} CLKGEN_OCTRL_FOS_Enum;

/* ==============================================  CLKGEN OCTRL STOPRC [1..1]  =============================================== */
typedef enum {                                  /*!< CLKGEN_OCTRL_STOPRC                                                       */
  CLKGEN_OCTRL_STOPRC_EN               = 0,     /*!< EN : Enable the LFRC Oscillator to drive the RTC                          */
  CLKGEN_OCTRL_STOPRC_STOP             = 1,     /*!< STOP : Stop the LFRC Oscillator when driving the RTC                      */
} CLKGEN_OCTRL_STOPRC_Enum;

/* ==============================================  CLKGEN OCTRL STOPXT [0..0]  =============================================== */
typedef enum {                                  /*!< CLKGEN_OCTRL_STOPXT                                                       */
  CLKGEN_OCTRL_STOPXT_EN               = 0,     /*!< EN : Enable the XT Oscillator to drive the RTC                            */
  CLKGEN_OCTRL_STOPXT_STOP             = 1,     /*!< STOP : Stop the XT Oscillator when driving the RTC                        */
} CLKGEN_OCTRL_STOPXT_Enum;

/* ========================================================  CLKOUT  ========================================================= */
/* ===============================================  CLKGEN CLKOUT CKEN [7..7]  =============================================== */
typedef enum {                                  /*!< CLKGEN_CLKOUT_CKEN                                                        */
  CLKGEN_CLKOUT_CKEN_DIS               = 0,     /*!< DIS : Disable CLKOUT                                                      */
  CLKGEN_CLKOUT_CKEN_EN                = 1,     /*!< EN : Enable CLKOUT                                                        */
} CLKGEN_CLKOUT_CKEN_Enum;

/* ==============================================  CLKGEN CLKOUT CKSEL [0..5]  =============================================== */
typedef enum {                                  /*!< CLKGEN_CLKOUT_CKSEL                                                       */
  CLKGEN_CLKOUT_CKSEL_LFRC             = 0,     /*!< LFRC : LFRC                                                               */
  CLKGEN_CLKOUT_CKSEL_XT_DIV2          = 1,     /*!< XT_DIV2 : XT / 2                                                          */
  CLKGEN_CLKOUT_CKSEL_XT_DIV4          = 2,     /*!< XT_DIV4 : XT / 4                                                          */
  CLKGEN_CLKOUT_CKSEL_XT_DIV8          = 3,     /*!< XT_DIV8 : XT / 8                                                          */
  CLKGEN_CLKOUT_CKSEL_XT_DIV16         = 4,     /*!< XT_DIV16 : XT / 16                                                        */
  CLKGEN_CLKOUT_CKSEL_XT_DIV32         = 5,     /*!< XT_DIV32 : XT / 32                                                        */
  CLKGEN_CLKOUT_CKSEL_RTC_1Hz          = 16,    /*!< RTC_1Hz : 1 Hz as selected in RTC                                         */
  CLKGEN_CLKOUT_CKSEL_XT_DIV2M         = 22,    /*!< XT_DIV2M : XT / 2^21                                                      */
  CLKGEN_CLKOUT_CKSEL_XT               = 23,    /*!< XT : XT                                                                   */
  CLKGEN_CLKOUT_CKSEL_CG_100Hz         = 24,    /*!< CG_100Hz : 100 Hz as selected in CLKGEN                                   */
  CLKGEN_CLKOUT_CKSEL_HFRC             = 25,    /*!< HFRC : HFRC                                                               */
  CLKGEN_CLKOUT_CKSEL_HFRC_DIV4        = 26,    /*!< HFRC_DIV4 : HFRC / 4                                                      */
  CLKGEN_CLKOUT_CKSEL_HFRC_DIV8        = 27,    /*!< HFRC_DIV8 : HFRC / 8                                                      */
  CLKGEN_CLKOUT_CKSEL_HFRC_DIV16       = 28,    /*!< HFRC_DIV16 : HFRC / 16                                                    */
  CLKGEN_CLKOUT_CKSEL_HFRC_DIV64       = 29,    /*!< HFRC_DIV64 : HFRC / 64                                                    */
  CLKGEN_CLKOUT_CKSEL_HFRC_DIV128      = 30,    /*!< HFRC_DIV128 : HFRC / 128                                                  */
  CLKGEN_CLKOUT_CKSEL_HFRC_DIV256      = 31,    /*!< HFRC_DIV256 : HFRC / 256                                                  */
  CLKGEN_CLKOUT_CKSEL_HFRC_DIV512      = 32,    /*!< HFRC_DIV512 : HFRC / 512                                                  */
  CLKGEN_CLKOUT_CKSEL_FLASH_CLK        = 34,    /*!< FLASH_CLK : Flash Clock                                                   */
  CLKGEN_CLKOUT_CKSEL_LFRC_DIV2        = 35,    /*!< LFRC_DIV2 : LFRC / 2                                                      */
  CLKGEN_CLKOUT_CKSEL_LFRC_DIV32       = 36,    /*!< LFRC_DIV32 : LFRC / 32                                                    */
  CLKGEN_CLKOUT_CKSEL_LFRC_DIV512      = 37,    /*!< LFRC_DIV512 : LFRC / 512                                                  */
  CLKGEN_CLKOUT_CKSEL_LFRC_DIV32K      = 38,    /*!< LFRC_DIV32K : LFRC / 32768                                                */
  CLKGEN_CLKOUT_CKSEL_XT_DIV256        = 39,    /*!< XT_DIV256 : XT / 256                                                      */
  CLKGEN_CLKOUT_CKSEL_XT_DIV8K         = 40,    /*!< XT_DIV8K : XT / 8192                                                      */
  CLKGEN_CLKOUT_CKSEL_XT_DIV64K        = 41,    /*!< XT_DIV64K : XT / 2^16                                                     */
  CLKGEN_CLKOUT_CKSEL_ULFRC_DIV16      = 42,    /*!< ULFRC_DIV16 : Uncal LFRC / 16                                             */
  CLKGEN_CLKOUT_CKSEL_ULFRC_DIV128     = 43,    /*!< ULFRC_DIV128 : Uncal LFRC / 128                                           */
  CLKGEN_CLKOUT_CKSEL_ULFRC_1Hz        = 44,    /*!< ULFRC_1Hz : Uncal LFRC / 1024                                             */
  CLKGEN_CLKOUT_CKSEL_ULFRC_DIV4K      = 45,    /*!< ULFRC_DIV4K : Uncal LFRC / 4096                                           */
  CLKGEN_CLKOUT_CKSEL_ULFRC_DIV1M      = 46,    /*!< ULFRC_DIV1M : Uncal LFRC / 2^20                                           */
  CLKGEN_CLKOUT_CKSEL_HFRC_DIV64K      = 47,    /*!< HFRC_DIV64K : HFRC / 2^16                                                 */
  CLKGEN_CLKOUT_CKSEL_HFRC_DIV16M      = 48,    /*!< HFRC_DIV16M : HFRC / 2^24                                                 */
  CLKGEN_CLKOUT_CKSEL_LFRC_DIV2M       = 49,    /*!< LFRC_DIV2M : LFRC / 2^20                                                  */
  CLKGEN_CLKOUT_CKSEL_HFRCNE           = 50,    /*!< HFRCNE : HFRC (not autoenabled)                                           */
  CLKGEN_CLKOUT_CKSEL_HFRCNE_DIV8      = 51,    /*!< HFRCNE_DIV8 : HFRC / 8 (not autoenabled)                                  */
  CLKGEN_CLKOUT_CKSEL_XTNE             = 53,    /*!< XTNE : XT (not autoenabled)                                               */
  CLKGEN_CLKOUT_CKSEL_XTNE_DIV16       = 54,    /*!< XTNE_DIV16 : XT / 16 (not autoenabled)                                    */
  CLKGEN_CLKOUT_CKSEL_LFRCNE_DIV32     = 55,    /*!< LFRCNE_DIV32 : LFRC / 32 (not autoenabled)                                */
  CLKGEN_CLKOUT_CKSEL_LFRCNE           = 57,    /*!< LFRCNE : LFRC (not autoenabled) - Default for undefined values            */
} CLKGEN_CLKOUT_CKSEL_Enum;

/* ========================================================  CLKKEY  ========================================================= */
/* =============================================  CLKGEN CLKKEY CLKKEY [0..31]  ============================================== */
typedef enum {                                  /*!< CLKGEN_CLKKEY_CLKKEY                                                      */
  CLKGEN_CLKKEY_CLKKEY_Key             = 71,    /*!< Key : Key                                                                 */
} CLKGEN_CLKKEY_CLKKEY_Enum;

/* =========================================================  CCTRL  ========================================================= */
/* ==============================================  CLKGEN CCTRL CORESEL [0..0]  ============================================== */
typedef enum {                                  /*!< CLKGEN_CCTRL_CORESEL                                                      */
  CLKGEN_CCTRL_CORESEL_HFRC            = 0,     /*!< HFRC : Core Clock is HFRC                                                 */
  CLKGEN_CCTRL_CORESEL_HFRC_DIV2       = 1,     /*!< HFRC_DIV2 : Core Clock is HFRC / 2                                        */
} CLKGEN_CCTRL_CORESEL_Enum;

/* ========================================================  STATUS  ========================================================= */
/* =========================================================  HFADJ  ========================================================= */
/* ===========================================  CLKGEN HFADJ HFADJ_GAIN [21..23]  ============================================ */
typedef enum {                                  /*!< CLKGEN_HFADJ_HFADJ_GAIN                                                   */
  CLKGEN_HFADJ_HFADJ_GAIN_Gain_of_1    = 0,     /*!< Gain_of_1 : HF Adjust with Gain of 1                                      */
  CLKGEN_HFADJ_HFADJ_GAIN_Gain_of_1_in_2 = 1,   /*!< Gain_of_1_in_2 : HF Adjust with Gain of 0.5                               */
  CLKGEN_HFADJ_HFADJ_GAIN_Gain_of_1_in_4 = 2,   /*!< Gain_of_1_in_4 : HF Adjust with Gain of 0.25                              */
  CLKGEN_HFADJ_HFADJ_GAIN_Gain_of_1_in_8 = 3,   /*!< Gain_of_1_in_8 : HF Adjust with Gain of 0.125                             */
  CLKGEN_HFADJ_HFADJ_GAIN_Gain_of_1_in_16 = 4,  /*!< Gain_of_1_in_16 : HF Adjust with Gain of 0.0625                           */
  CLKGEN_HFADJ_HFADJ_GAIN_Gain_of_1_in_32 = 5,  /*!< Gain_of_1_in_32 : HF Adjust with Gain of 0.03125                          */
} CLKGEN_HFADJ_HFADJ_GAIN_Enum;

/* ============================================  CLKGEN HFADJ HFWARMUP [20..20]  ============================================= */
typedef enum {                                  /*!< CLKGEN_HFADJ_HFWARMUP                                                     */
  CLKGEN_HFADJ_HFWARMUP_1SEC           = 0,     /*!< 1SEC : Autoadjust XT warmup period = 1-2 seconds                          */
  CLKGEN_HFADJ_HFWARMUP_2SEC           = 1,     /*!< 2SEC : Autoadjust XT warmup period = 2-4 seconds                          */
} CLKGEN_HFADJ_HFWARMUP_Enum;

/* ==============================================  CLKGEN HFADJ HFADJCK [1..3]  ============================================== */
typedef enum {                                  /*!< CLKGEN_HFADJ_HFADJCK                                                      */
  CLKGEN_HFADJ_HFADJCK_4SEC            = 0,     /*!< 4SEC : Autoadjust repeat period = 4 seconds                               */
  CLKGEN_HFADJ_HFADJCK_16SEC           = 1,     /*!< 16SEC : Autoadjust repeat period = 16 seconds                             */
  CLKGEN_HFADJ_HFADJCK_32SEC           = 2,     /*!< 32SEC : Autoadjust repeat period = 32 seconds                             */
  CLKGEN_HFADJ_HFADJCK_64SEC           = 3,     /*!< 64SEC : Autoadjust repeat period = 64 seconds                             */
  CLKGEN_HFADJ_HFADJCK_128SEC          = 4,     /*!< 128SEC : Autoadjust repeat period = 128 seconds                           */
  CLKGEN_HFADJ_HFADJCK_256SEC          = 5,     /*!< 256SEC : Autoadjust repeat period = 256 seconds                           */
  CLKGEN_HFADJ_HFADJCK_512SEC          = 6,     /*!< 512SEC : Autoadjust repeat period = 512 seconds                           */
  CLKGEN_HFADJ_HFADJCK_1024SEC         = 7,     /*!< 1024SEC : Autoadjust repeat period = 1024 seconds                         */
} CLKGEN_HFADJ_HFADJCK_Enum;

/* ==============================================  CLKGEN HFADJ HFADJEN [0..0]  ============================================== */
typedef enum {                                  /*!< CLKGEN_HFADJ_HFADJEN                                                      */
  CLKGEN_HFADJ_HFADJEN_DIS             = 0,     /*!< DIS : Disable the HFRC adjustment                                         */
  CLKGEN_HFADJ_HFADJEN_EN              = 1,     /*!< EN : Enable the HFRC adjustment                                           */
} CLKGEN_HFADJ_HFADJEN_Enum;

/* ========================================================  CLOCKEN  ======================================================== */
/* ============================================  CLKGEN CLOCKEN CLOCKEN [0..31]  ============================================= */
typedef enum {                                  /*!< CLKGEN_CLOCKEN_CLOCKEN                                                    */
  CLKGEN_CLOCKEN_CLOCKEN_ADC_CLKEN     = 1,     /*!< ADC_CLKEN : Clock enable for the ADC.                                     */
  CLKGEN_CLOCKEN_CLOCKEN_CTIMER_CLKEN  = 2,     /*!< CTIMER_CLKEN : Clock enable for the CTIMER.                               */
  CLKGEN_CLOCKEN_CLOCKEN_CTIMER0A_CLKEN = 4,    /*!< CTIMER0A_CLKEN : Clock enable for the CTIMER0A.                           */
  CLKGEN_CLOCKEN_CLOCKEN_CTIMER0B_CLKEN = 8,    /*!< CTIMER0B_CLKEN : Clock enable for the CTIMER0B.                           */
  CLKGEN_CLOCKEN_CLOCKEN_CTIMER1A_CLKEN = 16,   /*!< CTIMER1A_CLKEN : Clock enable for the CTIMER1A.                           */
  CLKGEN_CLOCKEN_CLOCKEN_CTIMER1B_CLKEN = 32,   /*!< CTIMER1B_CLKEN : Clock enable for the CTIMER1B.                           */
  CLKGEN_CLOCKEN_CLOCKEN_CTIMER2A_CLKEN = 64,   /*!< CTIMER2A_CLKEN : Clock enable for the CTIMER2A.                           */
  CLKGEN_CLOCKEN_CLOCKEN_CTIMER2B_CLKEN = 128,  /*!< CTIMER2B_CLKEN : Clock enable for the CTIMER2B.                           */
  CLKGEN_CLOCKEN_CLOCKEN_CTIMER3A_CLKEN = 256,  /*!< CTIMER3A_CLKEN : Clock enable for the CTIMER3A.                           */
  CLKGEN_CLOCKEN_CLOCKEN_CTIMER3B_CLKEN = 512,  /*!< CTIMER3B_CLKEN : Clock enable for the CTIMER3B.                           */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTR0_CLKEN = 1024,  /*!< IOMSTR0_CLKEN : Clock enable for the IO Master 0.                         */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTR1_CLKEN = 2048,  /*!< IOMSTR1_CLKEN : Clock enable for the IO Master 1.                         */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTR2_CLKEN = 4096,  /*!< IOMSTR2_CLKEN : Clock enable for the IO Master 2.                         */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTR3_CLKEN = 8192,  /*!< IOMSTR3_CLKEN : Clock enable for the IO Master 3.                         */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTR4_CLKEN = 16384, /*!< IOMSTR4_CLKEN : Clock enable for the IO Master 4.                         */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTR5_CLKEN = 32768, /*!< IOMSTR5_CLKEN : Clock enable for the IO Master 5.                         */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTRIFC0_CLKEN = 65536,/*!< IOMSTRIFC0_CLKEN : Clock enable for the IO Master IFC0.                 */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTRIFC1_CLKEN = 131072,/*!< IOMSTRIFC1_CLKEN : Clock enable for the IO Master IFC1.                */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTRIFC2_CLKEN = 262144,/*!< IOMSTRIFC2_CLKEN : Clock enable for the IO Master IFC2.                */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTRIFC3_CLKEN = 524288,/*!< IOMSTRIFC3_CLKEN : Clock enable for the IO Master IFC3.                */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTRIFC4_CLKEN = 1048576,/*!< IOMSTRIFC4_CLKEN : Clock enable for the IO Master IFC4.               */
  CLKGEN_CLOCKEN_CLOCKEN_IOMSTRIFC5_CLKEN = 2097152,/*!< IOMSTRIFC5_CLKEN : Clock enable for the IO Master IFC5.               */
  CLKGEN_CLOCKEN_CLOCKEN_IOSLAVE_CLKEN = 4194304,/*!< IOSLAVE_CLKEN : Clock enable for the IO Slave.                           */
  CLKGEN_CLOCKEN_CLOCKEN_PDM_CLKEN     = 8388608,/*!< PDM_CLKEN : Clock enable for the PDM.                                    */
  CLKGEN_CLOCKEN_CLOCKEN_PDMIFC_CLKEN  = 16777216,/*!< PDMIFC_CLKEN : Clock enable for the PDM IFC.                            */
  CLKGEN_CLOCKEN_CLOCKEN_RSTGEN_CLKEN  = 33554432,/*!< RSTGEN_CLKEN : Clock enable for the RSTGEN.                             */
  CLKGEN_CLOCKEN_CLOCKEN_SRAM_WIPE_CLKEN = 67108864,/*!< SRAM_WIPE_CLKEN : Clock enable for the SRAM_WIPE.                     */
  CLKGEN_CLOCKEN_CLOCKEN_STIMER_CLKEN  = 134217728,/*!< STIMER_CLKEN : Clock enable for the STIMER.                            */
  CLKGEN_CLOCKEN_CLOCKEN_STIMER_CNT_CLKEN = 268435456,/*!< STIMER_CNT_CLKEN : Clock enable for the STIMER_CNT.                 */
  CLKGEN_CLOCKEN_CLOCKEN_TPIU_CLKEN    = 536870912,/*!< TPIU_CLKEN : Clock enable for the TPIU.                                */
  CLKGEN_CLOCKEN_CLOCKEN_UART0_HCLK_CLKEN = 1073741824,/*!< UART0_HCLK_CLKEN : Clock enable for the UART0_HCLK.                */
  CLKGEN_CLOCKEN_CLOCKEN_UART0HF_CLKEN = -2147483648,/*!< UART0HF_CLKEN : Clock enable for the UART0HF.                        */
} CLKGEN_CLOCKEN_CLOCKEN_Enum;

/* =======================================================  CLOCKEN2  ======================================================== */
/* ===========================================  CLKGEN CLOCKEN2 CLOCKEN2 [0..31]  ============================================ */
typedef enum {                                  /*!< CLKGEN_CLOCKEN2_CLOCKEN2                                                  */
  CLKGEN_CLOCKEN2_CLOCKEN2_UART1_HCLK_CLKEN = 1,/*!< UART1_HCLK_CLKEN : Clock enable for the UART1_HCLK.                       */
  CLKGEN_CLOCKEN2_CLOCKEN2_UART1HF_CLKEN = 2,   /*!< UART1HF_CLKEN : Clock enable for the UART1HF.                             */
  CLKGEN_CLOCKEN2_CLOCKEN2_WDT_CLKEN   = 4,     /*!< WDT_CLKEN : Clock enable for the WDT.                                     */
  CLKGEN_CLOCKEN2_CLOCKEN2_XT_32KHz_EN = 1073741824,/*!< XT_32KHz_EN : Clock enable for the XT_32KHz.                          */
  CLKGEN_CLOCKEN2_CLOCKEN2_FRCHFRC     = -2147483648,/*!< FRCHFRC : Force HFRC On Status.                                      */
} CLKGEN_CLOCKEN2_CLOCKEN2_Enum;

/* =======================================================  CLOCKEN3  ======================================================== */
/* ===========================================  CLKGEN CLOCKEN3 CLOCKEN3 [0..31]  ============================================ */
typedef enum {                                  /*!< CLKGEN_CLOCKEN3_CLOCKEN3                                                  */
  CLKGEN_CLOCKEN3_CLOCKEN3_periph_all_xtal_en = 16777216,/*!< periph_all_xtal_en : At least 1 peripherial is requesting for
                                                     XTAL Clock                                                                */
  CLKGEN_CLOCKEN3_CLOCKEN3_periph_all_hfrc_en = 33554432,/*!< periph_all_hfrc_en : At least 1 peripherial is requesting for
                                                     HFRC Clock                                                                */
  CLKGEN_CLOCKEN3_CLOCKEN3_HFADJEN     = 67108864,/*!< HFADJEN : HFRC Adjust Enable Status                                     */
  CLKGEN_CLOCKEN3_CLOCKEN3_HFRC_en_out = 134217728,/*!< HFRC_en_out : HFRC is enabled during adjustment status                 */
  CLKGEN_CLOCKEN3_CLOCKEN3_RTC_SOURCE  = 268435456,/*!< RTC_SOURCE : Selects the RTC oscillator (0 => LFRC, 1 => XT)           */
  CLKGEN_CLOCKEN3_CLOCKEN3_XTAL_EN     = 536870912,/*!< XTAL_EN : XT is enabled Status                                         */
  CLKGEN_CLOCKEN3_CLOCKEN3_HFRC_EN     = 1073741824,/*!< HFRC_EN : HFRC is enabled Status                                      */
  CLKGEN_CLOCKEN3_CLOCKEN3_FLASHCLK_EN = -2147483648,/*!< FLASHCLK_EN : Flash Clock is enabled Status                          */
} CLKGEN_CLOCKEN3_CLOCKEN3_Enum;

/* ========================================================  UARTEN  ========================================================= */
/* =============================================  CLKGEN UARTEN UART1EN [8..9]  ============================================== */
typedef enum {                                  /*!< CLKGEN_UARTEN_UART1EN                                                     */
  CLKGEN_UARTEN_UART1EN_DIS            = 0,     /*!< DIS : Disable the UART1 system clock                                      */
  CLKGEN_UARTEN_UART1EN_EN             = 1,     /*!< EN : Enable the UART1 system clock                                        */
  CLKGEN_UARTEN_UART1EN_REDUCE_FREQ    = 2,     /*!< REDUCE_FREQ : Run UART_Hclk at the same frequency as UART_hfclk           */
  CLKGEN_UARTEN_UART1EN_EN_POWER_SAV   = 3,     /*!< EN_POWER_SAV : Enable UART_hclk to reduce to UART_hfclk at low
                                                     power mode                                                                */
} CLKGEN_UARTEN_UART1EN_Enum;

/* =============================================  CLKGEN UARTEN UART0EN [0..1]  ============================================== */
typedef enum {                                  /*!< CLKGEN_UARTEN_UART0EN                                                     */
  CLKGEN_UARTEN_UART0EN_DIS            = 0,     /*!< DIS : Disable the UART0 system clock                                      */
  CLKGEN_UARTEN_UART0EN_EN             = 1,     /*!< EN : Enable the UART0 system clock                                        */
  CLKGEN_UARTEN_UART0EN_REDUCE_FREQ    = 2,     /*!< REDUCE_FREQ : Run UART_Hclk at the same frequency as UART_hfclk           */
  CLKGEN_UARTEN_UART0EN_EN_POWER_SAV   = 3,     /*!< EN_POWER_SAV : Enable UART_hclk to reduce to UART_hfclk at low
                                                     power mode                                                                */
} CLKGEN_UARTEN_UART0EN_Enum;

/* =========================================================  INTEN  ========================================================= */
/* ========================================================  INTSTAT  ======================================================== */
/* ========================================================  INTCLR  ========================================================= */
/* ========================================================  INTSET  ========================================================= */


/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  TMR0  ========================================================== */
/* ========================================================  CMPRA0  ========================================================= */
/* ========================================================  CMPRB0  ========================================================= */
/* =========================================================  CTRL0  ========================================================= */
/* =============================================  CTIMER CTRL0 CTLINK0 [31..31]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_CTLINK0                                                      */
  CTIMER_CTRL0_CTLINK0_TWO_16BIT_TIMERS = 0,    /*!< TWO_16BIT_TIMERS : Use A0/B0 timers as two independent 16-bit
                                                     timers (default).                                                         */
  CTIMER_CTRL0_CTLINK0_32BIT_TIMER     = 1,     /*!< 32BIT_TIMER : Link A0/B0 timers into a single 32-bit timer.               */
} CTIMER_CTRL0_CTLINK0_Enum;

/* =============================================  CTIMER CTRL0 TMRB0PE [29..29]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRB0PE                                                      */
  CTIMER_CTRL0_TMRB0PE_DIS             = 0,     /*!< DIS : Counter/Timer B holds the TMRPINB signal at the value
                                                     TMRB0POL.                                                                 */
  CTIMER_CTRL0_TMRB0PE_EN              = 1,     /*!< EN : Enable counter/timer B0 to generate a signal on TMRPINB.             */
} CTIMER_CTRL0_TMRB0PE_Enum;

/* ============================================  CTIMER CTRL0 TMRB0POL [28..28]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRB0POL                                                     */
  CTIMER_CTRL0_TMRB0POL_NORMAL         = 0,     /*!< NORMAL : The polarity of the TMRPINB0 pin is the same as the
                                                     timer output.                                                             */
  CTIMER_CTRL0_TMRB0POL_INVERTED       = 1,     /*!< INVERTED : The polarity of the TMRPINB0 pin is the inverse of
                                                     the timer output.                                                         */
} CTIMER_CTRL0_TMRB0POL_Enum;

/* ============================================  CTIMER CTRL0 TMRB0CLR [27..27]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRB0CLR                                                     */
  CTIMER_CTRL0_TMRB0CLR_RUN            = 0,     /*!< RUN : Allow counter/timer B0 to run                                       */
  CTIMER_CTRL0_TMRB0CLR_CLEAR          = 1,     /*!< CLEAR : Holds counter/timer B0 at 0x0000.                                 */
} CTIMER_CTRL0_TMRB0CLR_Enum;

/* ============================================  CTIMER CTRL0 TMRB0IE1 [26..26]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRB0IE1                                                     */
  CTIMER_CTRL0_TMRB0IE1_DIS            = 0,     /*!< DIS : Disable counter/timer B0 from generating an interrupt
                                                     based on COMPR1.                                                          */
  CTIMER_CTRL0_TMRB0IE1_EN             = 1,     /*!< EN : Enable counter/timer B0 to generate an interrupt based
                                                     on COMPR1.                                                                */
} CTIMER_CTRL0_TMRB0IE1_Enum;

/* ============================================  CTIMER CTRL0 TMRB0IE0 [25..25]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRB0IE0                                                     */
  CTIMER_CTRL0_TMRB0IE0_DIS            = 0,     /*!< DIS : Disable counter/timer B0 from generating an interrupt
                                                     based on COMPR0.                                                          */
  CTIMER_CTRL0_TMRB0IE0_EN             = 1,     /*!< EN : Enable counter/timer B0 to generate an interrupt based
                                                     on COMPR0                                                                 */
} CTIMER_CTRL0_TMRB0IE0_Enum;

/* =============================================  CTIMER CTRL0 TMRB0FN [22..24]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRB0FN                                                      */
  CTIMER_CTRL0_TMRB0FN_SINGLECOUNT     = 0,     /*!< SINGLECOUNT : Single count (output toggles and sticks). Count
                                                     to CMPR0B0, stop.                                                         */
  CTIMER_CTRL0_TMRB0FN_REPEATEDCOUNT   = 1,     /*!< REPEATEDCOUNT : Repeated count (periodic 1-clock-cycle-wide
                                                     pulses). Count to CMPR0B0, restart.                                       */
  CTIMER_CTRL0_TMRB0FN_PULSE_ONCE      = 2,     /*!< PULSE_ONCE : Pulse once (aka one-shot). Count to CMPR0B0, assert,
                                                     count to CMPR1B0, deassert, stop.                                         */
  CTIMER_CTRL0_TMRB0FN_PULSE_CONT      = 3,     /*!< PULSE_CONT : Pulse continously. Count to CMPR0B0, assert, count
                                                     to CMPR1B0, deassert, restart.                                            */
  CTIMER_CTRL0_TMRB0FN_CONTINUOUS      = 4,     /*!< CONTINUOUS : Continuous run (aka Free Run). Count continuously.           */
} CTIMER_CTRL0_TMRB0FN_Enum;

/* ============================================  CTIMER CTRL0 TMRB0CLK [17..21]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRB0CLK                                                     */
  CTIMER_CTRL0_TMRB0CLK_TMRPIN         = 0,     /*!< TMRPIN : Clock source is TMRPINB.                                         */
  CTIMER_CTRL0_TMRB0CLK_HFRC_DIV4      = 1,     /*!< HFRC_DIV4 : Clock source is HFRC / 4                                      */
  CTIMER_CTRL0_TMRB0CLK_HFRC_DIV16     = 2,     /*!< HFRC_DIV16 : Clock source is HFRC / 16                                    */
  CTIMER_CTRL0_TMRB0CLK_HFRC_DIV256    = 3,     /*!< HFRC_DIV256 : Clock source is HFRC / 256                                  */
  CTIMER_CTRL0_TMRB0CLK_HFRC_DIV1024   = 4,     /*!< HFRC_DIV1024 : Clock source is HFRC / 1024                                */
  CTIMER_CTRL0_TMRB0CLK_HFRC_DIV4K     = 5,     /*!< HFRC_DIV4K : Clock source is HFRC / 4096                                  */
  CTIMER_CTRL0_TMRB0CLK_XT             = 6,     /*!< XT : Clock source is the XT (uncalibrated).                               */
  CTIMER_CTRL0_TMRB0CLK_XT_DIV2        = 7,     /*!< XT_DIV2 : Clock source is XT / 2                                          */
  CTIMER_CTRL0_TMRB0CLK_XT_DIV16       = 8,     /*!< XT_DIV16 : Clock source is XT / 16                                        */
  CTIMER_CTRL0_TMRB0CLK_XT_DIV256      = 9,     /*!< XT_DIV256 : Clock source is XT / 256                                      */
  CTIMER_CTRL0_TMRB0CLK_LFRC_DIV2      = 10,    /*!< LFRC_DIV2 : Clock source is LFRC / 2                                      */
  CTIMER_CTRL0_TMRB0CLK_LFRC_DIV32     = 11,    /*!< LFRC_DIV32 : Clock source is LFRC / 32                                    */
  CTIMER_CTRL0_TMRB0CLK_LFRC_DIV1K     = 12,    /*!< LFRC_DIV1K : Clock source is LFRC / 1024                                  */
  CTIMER_CTRL0_TMRB0CLK_LFRC           = 13,    /*!< LFRC : Clock source is LFRC                                               */
  CTIMER_CTRL0_TMRB0CLK_RTC_100HZ      = 14,    /*!< RTC_100HZ : Clock source is 100 Hz from the current RTC oscillator.       */
  CTIMER_CTRL0_TMRB0CLK_HCLK           = 15,    /*!< HCLK : Clock source is HCLK.                                              */
  CTIMER_CTRL0_TMRB0CLK_BUCKB          = 16,    /*!< BUCKB : Clock source is buck converter stream from CORE Buck.             */
} CTIMER_CTRL0_TMRB0CLK_Enum;

/* =============================================  CTIMER CTRL0 TMRB0EN [16..16]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRB0EN                                                      */
  CTIMER_CTRL0_TMRB0EN_DIS             = 0,     /*!< DIS : Counter/Timer B0 Disable.                                           */
  CTIMER_CTRL0_TMRB0EN_EN              = 1,     /*!< EN : Counter/Timer B0 Enable.                                             */
} CTIMER_CTRL0_TMRB0EN_Enum;

/* =============================================  CTIMER CTRL0 TMRA0PE [13..13]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRA0PE                                                      */
  CTIMER_CTRL0_TMRA0PE_DIS             = 0,     /*!< DIS : Counter/Timer A holds the TMRPINA signal at the value
                                                     TMRA0POL.                                                                 */
  CTIMER_CTRL0_TMRA0PE_EN              = 1,     /*!< EN : Enable counter/timer A0 to generate a signal on TMRPINA.             */
} CTIMER_CTRL0_TMRA0PE_Enum;

/* ============================================  CTIMER CTRL0 TMRA0POL [12..12]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRA0POL                                                     */
  CTIMER_CTRL0_TMRA0POL_NORMAL         = 0,     /*!< NORMAL : The polarity of the TMRPINA0 pin is the same as the
                                                     timer output.                                                             */
  CTIMER_CTRL0_TMRA0POL_INVERTED       = 1,     /*!< INVERTED : The polarity of the TMRPINA0 pin is the inverse of
                                                     the timer output.                                                         */
} CTIMER_CTRL0_TMRA0POL_Enum;

/* ============================================  CTIMER CTRL0 TMRA0CLR [11..11]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRA0CLR                                                     */
  CTIMER_CTRL0_TMRA0CLR_RUN            = 0,     /*!< RUN : Allow counter/timer A0 to run                                       */
  CTIMER_CTRL0_TMRA0CLR_CLEAR          = 1,     /*!< CLEAR : Holds counter/timer A0 at 0x0000.                                 */
} CTIMER_CTRL0_TMRA0CLR_Enum;

/* ============================================  CTIMER CTRL0 TMRA0IE1 [10..10]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRA0IE1                                                     */
  CTIMER_CTRL0_TMRA0IE1_DIS            = 0,     /*!< DIS : Disable counter/timer A0 from generating an interrupt
                                                     based on COMPR1.                                                          */
  CTIMER_CTRL0_TMRA0IE1_EN             = 1,     /*!< EN : Enable counter/timer A0 to generate an interrupt based
                                                     on COMPR1.                                                                */
} CTIMER_CTRL0_TMRA0IE1_Enum;

/* =============================================  CTIMER CTRL0 TMRA0IE0 [9..9]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRA0IE0                                                     */
  CTIMER_CTRL0_TMRA0IE0_DIS            = 0,     /*!< DIS : Disable counter/timer A0 from generating an interrupt
                                                     based on COMPR0.                                                          */
  CTIMER_CTRL0_TMRA0IE0_EN             = 1,     /*!< EN : Enable counter/timer A0 to generate an interrupt based
                                                     on COMPR0.                                                                */
} CTIMER_CTRL0_TMRA0IE0_Enum;

/* ==============================================  CTIMER CTRL0 TMRA0FN [6..8]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRA0FN                                                      */
  CTIMER_CTRL0_TMRA0FN_SINGLECOUNT     = 0,     /*!< SINGLECOUNT : Single count (output toggles and sticks). Count
                                                     to CMPR0A0, stop.                                                         */
  CTIMER_CTRL0_TMRA0FN_REPEATEDCOUNT   = 1,     /*!< REPEATEDCOUNT : Repeated count (periodic 1-clock-cycle-wide
                                                     pulses). Count to CMPR0A0, restart.                                       */
  CTIMER_CTRL0_TMRA0FN_PULSE_ONCE      = 2,     /*!< PULSE_ONCE : Pulse once (aka one-shot). Count to CMPR0A0, assert,
                                                     count to CMPR1A0, deassert, stop.                                         */
  CTIMER_CTRL0_TMRA0FN_PULSE_CONT      = 3,     /*!< PULSE_CONT : Pulse continously. Count to CMPR0A0, assert, count
                                                     to CMPR1A0, deassert, restart.                                            */
  CTIMER_CTRL0_TMRA0FN_CONTINUOUS      = 4,     /*!< CONTINUOUS : Continuous run (aka Free Run). Count continuously.           */
} CTIMER_CTRL0_TMRA0FN_Enum;

/* =============================================  CTIMER CTRL0 TMRA0CLK [1..5]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRA0CLK                                                     */
  CTIMER_CTRL0_TMRA0CLK_TMRPIN         = 0,     /*!< TMRPIN : Clock source is TMRPINA.                                         */
  CTIMER_CTRL0_TMRA0CLK_HFRC_DIV4      = 1,     /*!< HFRC_DIV4 : Clock source is HFRC / 4                                      */
  CTIMER_CTRL0_TMRA0CLK_HFRC_DIV16     = 2,     /*!< HFRC_DIV16 : Clock source is HFRC / 16                                    */
  CTIMER_CTRL0_TMRA0CLK_HFRC_DIV256    = 3,     /*!< HFRC_DIV256 : Clock source is HFRC / 256                                  */
  CTIMER_CTRL0_TMRA0CLK_HFRC_DIV1024   = 4,     /*!< HFRC_DIV1024 : Clock source is HFRC / 1024                                */
  CTIMER_CTRL0_TMRA0CLK_HFRC_DIV4K     = 5,     /*!< HFRC_DIV4K : Clock source is HFRC / 4096                                  */
  CTIMER_CTRL0_TMRA0CLK_XT             = 6,     /*!< XT : Clock source is the XT (uncalibrated).                               */
  CTIMER_CTRL0_TMRA0CLK_XT_DIV2        = 7,     /*!< XT_DIV2 : Clock source is XT / 2                                          */
  CTIMER_CTRL0_TMRA0CLK_XT_DIV16       = 8,     /*!< XT_DIV16 : Clock source is XT / 16                                        */
  CTIMER_CTRL0_TMRA0CLK_XT_DIV256      = 9,     /*!< XT_DIV256 : Clock source is XT / 256                                      */
  CTIMER_CTRL0_TMRA0CLK_LFRC_DIV2      = 10,    /*!< LFRC_DIV2 : Clock source is LFRC / 2                                      */
  CTIMER_CTRL0_TMRA0CLK_LFRC_DIV32     = 11,    /*!< LFRC_DIV32 : Clock source is LFRC / 32                                    */
  CTIMER_CTRL0_TMRA0CLK_LFRC_DIV1K     = 12,    /*!< LFRC_DIV1K : Clock source is LFRC / 1024                                  */
  CTIMER_CTRL0_TMRA0CLK_LFRC           = 13,    /*!< LFRC : Clock source is LFRC                                               */
  CTIMER_CTRL0_TMRA0CLK_RTC_100HZ      = 14,    /*!< RTC_100HZ : Clock source is 100 Hz from the current RTC oscillator.       */
  CTIMER_CTRL0_TMRA0CLK_HCLK_DIV4      = 15,    /*!< HCLK_DIV4 : Clock source is HCLK / 4.                                     */
  CTIMER_CTRL0_TMRA0CLK_BUCKA          = 16,    /*!< BUCKA : Clock source is buck converter stream from MEM Buck.              */
} CTIMER_CTRL0_TMRA0CLK_Enum;

/* ==============================================  CTIMER CTRL0 TMRA0EN [0..0]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL0_TMRA0EN                                                      */
  CTIMER_CTRL0_TMRA0EN_DIS             = 0,     /*!< DIS : Counter/Timer A0 Disable.                                           */
  CTIMER_CTRL0_TMRA0EN_EN              = 1,     /*!< EN : Counter/Timer A0 Enable.                                             */
} CTIMER_CTRL0_TMRA0EN_Enum;

/* =========================================================  TMR1  ========================================================== */
/* ========================================================  CMPRA1  ========================================================= */
/* ========================================================  CMPRB1  ========================================================= */
/* =========================================================  CTRL1  ========================================================= */
/* =============================================  CTIMER CTRL1 CTLINK1 [31..31]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_CTLINK1                                                      */
  CTIMER_CTRL1_CTLINK1_TWO_16BIT_TIMERS = 0,    /*!< TWO_16BIT_TIMERS : Use A1/B1 timers as two independent 16-bit
                                                     timers (default).                                                         */
  CTIMER_CTRL1_CTLINK1_32BIT_TIMER     = 1,     /*!< 32BIT_TIMER : Link A1/B1 timers into a single 32-bit timer.               */
} CTIMER_CTRL1_CTLINK1_Enum;

/* =============================================  CTIMER CTRL1 TMRB1PE [29..29]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRB1PE                                                      */
  CTIMER_CTRL1_TMRB1PE_DIS             = 0,     /*!< DIS : Counter/Timer B holds the TMRPINB signal at the value
                                                     TMRB1POL.                                                                 */
  CTIMER_CTRL1_TMRB1PE_EN              = 1,     /*!< EN : Enable counter/timer B1 to generate a signal on TMRPINB.             */
} CTIMER_CTRL1_TMRB1PE_Enum;

/* ============================================  CTIMER CTRL1 TMRB1POL [28..28]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRB1POL                                                     */
  CTIMER_CTRL1_TMRB1POL_NORMAL         = 0,     /*!< NORMAL : The polarity of the TMRPINB1 pin is the same as the
                                                     timer output.                                                             */
  CTIMER_CTRL1_TMRB1POL_INVERTED       = 1,     /*!< INVERTED : The polarity of the TMRPINB1 pin is the inverse of
                                                     the timer output.                                                         */
} CTIMER_CTRL1_TMRB1POL_Enum;

/* ============================================  CTIMER CTRL1 TMRB1CLR [27..27]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRB1CLR                                                     */
  CTIMER_CTRL1_TMRB1CLR_RUN            = 0,     /*!< RUN : Allow counter/timer B1 to run                                       */
  CTIMER_CTRL1_TMRB1CLR_CLEAR          = 1,     /*!< CLEAR : Holds counter/timer B1 at 0x0000.                                 */
} CTIMER_CTRL1_TMRB1CLR_Enum;

/* ============================================  CTIMER CTRL1 TMRB1IE1 [26..26]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRB1IE1                                                     */
  CTIMER_CTRL1_TMRB1IE1_DIS            = 0,     /*!< DIS : Disable counter/timer B1 from generating an interrupt
                                                     based on COMPR1.                                                          */
  CTIMER_CTRL1_TMRB1IE1_EN             = 1,     /*!< EN : Enable counter/timer B1 to generate an interrupt based
                                                     on COMPR1.                                                                */
} CTIMER_CTRL1_TMRB1IE1_Enum;

/* ============================================  CTIMER CTRL1 TMRB1IE0 [25..25]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRB1IE0                                                     */
  CTIMER_CTRL1_TMRB1IE0_DIS            = 0,     /*!< DIS : Disable counter/timer B1 from generating an interrupt
                                                     based on COMPR0.                                                          */
  CTIMER_CTRL1_TMRB1IE0_EN             = 1,     /*!< EN : Enable counter/timer B1 to generate an interrupt based
                                                     on COMPR0                                                                 */
} CTIMER_CTRL1_TMRB1IE0_Enum;

/* =============================================  CTIMER CTRL1 TMRB1FN [22..24]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRB1FN                                                      */
  CTIMER_CTRL1_TMRB1FN_SINGLECOUNT     = 0,     /*!< SINGLECOUNT : Single count (output toggles and sticks). Count
                                                     to CMPR0B1, stop.                                                         */
  CTIMER_CTRL1_TMRB1FN_REPEATEDCOUNT   = 1,     /*!< REPEATEDCOUNT : Repeated count (periodic 1-clock-cycle-wide
                                                     pulses). Count to CMPR0B1, restart.                                       */
  CTIMER_CTRL1_TMRB1FN_PULSE_ONCE      = 2,     /*!< PULSE_ONCE : Pulse once (aka one-shot). Count to CMPR0B1, assert,
                                                     count to CMPR1B1, deassert, stop.                                         */
  CTIMER_CTRL1_TMRB1FN_PULSE_CONT      = 3,     /*!< PULSE_CONT : Pulse continously. Count to CMPR0B1, assert, count
                                                     to CMPR1B1, deassert, restart.                                            */
  CTIMER_CTRL1_TMRB1FN_CONTINUOUS      = 4,     /*!< CONTINUOUS : Continuous run (aka Free Run). Count continuously.           */
} CTIMER_CTRL1_TMRB1FN_Enum;

/* ============================================  CTIMER CTRL1 TMRB1CLK [17..21]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRB1CLK                                                     */
  CTIMER_CTRL1_TMRB1CLK_TMRPIN         = 0,     /*!< TMRPIN : Clock source is TMRPINB.                                         */
  CTIMER_CTRL1_TMRB1CLK_HFRC_DIV4      = 1,     /*!< HFRC_DIV4 : Clock source is HFRC / 4                                      */
  CTIMER_CTRL1_TMRB1CLK_HFRC_DIV16     = 2,     /*!< HFRC_DIV16 : Clock source is HFRC / 16                                    */
  CTIMER_CTRL1_TMRB1CLK_HFRC_DIV256    = 3,     /*!< HFRC_DIV256 : Clock source is HFRC / 256                                  */
  CTIMER_CTRL1_TMRB1CLK_HFRC_DIV1024   = 4,     /*!< HFRC_DIV1024 : Clock source is HFRC / 1024                                */
  CTIMER_CTRL1_TMRB1CLK_HFRC_DIV4K     = 5,     /*!< HFRC_DIV4K : Clock source is HFRC / 4096                                  */
  CTIMER_CTRL1_TMRB1CLK_XT             = 6,     /*!< XT : Clock source is the XT (uncalibrated).                               */
  CTIMER_CTRL1_TMRB1CLK_XT_DIV2        = 7,     /*!< XT_DIV2 : Clock source is XT / 2                                          */
  CTIMER_CTRL1_TMRB1CLK_XT_DIV16       = 8,     /*!< XT_DIV16 : Clock source is XT / 16                                        */
  CTIMER_CTRL1_TMRB1CLK_XT_DIV256      = 9,     /*!< XT_DIV256 : Clock source is XT / 256                                      */
  CTIMER_CTRL1_TMRB1CLK_LFRC_DIV2      = 10,    /*!< LFRC_DIV2 : Clock source is LFRC / 2                                      */
  CTIMER_CTRL1_TMRB1CLK_LFRC_DIV32     = 11,    /*!< LFRC_DIV32 : Clock source is LFRC / 32                                    */
  CTIMER_CTRL1_TMRB1CLK_LFRC_DIV1K     = 12,    /*!< LFRC_DIV1K : Clock source is LFRC / 1024                                  */
  CTIMER_CTRL1_TMRB1CLK_LFRC           = 13,    /*!< LFRC : Clock source is LFRC                                               */
  CTIMER_CTRL1_TMRB1CLK_RTC_100HZ      = 14,    /*!< RTC_100HZ : Clock source is 100 Hz from the current RTC oscillator.       */
  CTIMER_CTRL1_TMRB1CLK_HCLK           = 15,    /*!< HCLK : Clock source is HCLK.                                              */
  CTIMER_CTRL1_TMRB1CLK_BUCKB          = 16,    /*!< BUCKB : Clock source is buck converter stream from CORE Buck.             */
} CTIMER_CTRL1_TMRB1CLK_Enum;

/* =============================================  CTIMER CTRL1 TMRB1EN [16..16]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRB1EN                                                      */
  CTIMER_CTRL1_TMRB1EN_DIS             = 0,     /*!< DIS : Counter/Timer B1 Disable.                                           */
  CTIMER_CTRL1_TMRB1EN_EN              = 1,     /*!< EN : Counter/Timer B1 Enable.                                             */
} CTIMER_CTRL1_TMRB1EN_Enum;

/* =============================================  CTIMER CTRL1 TMRA1PE [13..13]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRA1PE                                                      */
  CTIMER_CTRL1_TMRA1PE_DIS             = 0,     /*!< DIS : Counter/Timer A holds the TMRPINA signal at the value
                                                     TMRA1POL.                                                                 */
  CTIMER_CTRL1_TMRA1PE_EN              = 1,     /*!< EN : Enable counter/timer A1 to generate a signal on TMRPINA.             */
} CTIMER_CTRL1_TMRA1PE_Enum;

/* ============================================  CTIMER CTRL1 TMRA1POL [12..12]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRA1POL                                                     */
  CTIMER_CTRL1_TMRA1POL_NORMAL         = 0,     /*!< NORMAL : The polarity of the TMRPINA1 pin is the same as the
                                                     timer output.                                                             */
  CTIMER_CTRL1_TMRA1POL_INVERTED       = 1,     /*!< INVERTED : The polarity of the TMRPINA1 pin is the inverse of
                                                     the timer output.                                                         */
} CTIMER_CTRL1_TMRA1POL_Enum;

/* ============================================  CTIMER CTRL1 TMRA1CLR [11..11]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRA1CLR                                                     */
  CTIMER_CTRL1_TMRA1CLR_RUN            = 0,     /*!< RUN : Allow counter/timer A1 to run                                       */
  CTIMER_CTRL1_TMRA1CLR_CLEAR          = 1,     /*!< CLEAR : Holds counter/timer A1 at 0x0000.                                 */
} CTIMER_CTRL1_TMRA1CLR_Enum;

/* ============================================  CTIMER CTRL1 TMRA1IE1 [10..10]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRA1IE1                                                     */
  CTIMER_CTRL1_TMRA1IE1_DIS            = 0,     /*!< DIS : Disable counter/timer A1 from generating an interrupt
                                                     based on COMPR1.                                                          */
  CTIMER_CTRL1_TMRA1IE1_EN             = 1,     /*!< EN : Enable counter/timer A1 to generate an interrupt based
                                                     on COMPR1.                                                                */
} CTIMER_CTRL1_TMRA1IE1_Enum;

/* =============================================  CTIMER CTRL1 TMRA1IE0 [9..9]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRA1IE0                                                     */
  CTIMER_CTRL1_TMRA1IE0_DIS            = 0,     /*!< DIS : Disable counter/timer A1 from generating an interrupt
                                                     based on COMPR0.                                                          */
  CTIMER_CTRL1_TMRA1IE0_EN             = 1,     /*!< EN : Enable counter/timer A1 to generate an interrupt based
                                                     on COMPR0.                                                                */
} CTIMER_CTRL1_TMRA1IE0_Enum;

/* ==============================================  CTIMER CTRL1 TMRA1FN [6..8]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRA1FN                                                      */
  CTIMER_CTRL1_TMRA1FN_SINGLECOUNT     = 0,     /*!< SINGLECOUNT : Single count (output toggles and sticks). Count
                                                     to CMPR0A1, stop.                                                         */
  CTIMER_CTRL1_TMRA1FN_REPEATEDCOUNT   = 1,     /*!< REPEATEDCOUNT : Repeated count (periodic 1-clock-cycle-wide
                                                     pulses). Count to CMPR0A1, restart.                                       */
  CTIMER_CTRL1_TMRA1FN_PULSE_ONCE      = 2,     /*!< PULSE_ONCE : Pulse once (aka one-shot). Count to CMPR0A1, assert,
                                                     count to CMPR1A1, deassert, stop.                                         */
  CTIMER_CTRL1_TMRA1FN_PULSE_CONT      = 3,     /*!< PULSE_CONT : Pulse continously. Count to CMPR0A1, assert, count
                                                     to CMPR1A1, deassert, restart.                                            */
  CTIMER_CTRL1_TMRA1FN_CONTINUOUS      = 4,     /*!< CONTINUOUS : Continuous run (aka Free Run). Count continuously.           */
} CTIMER_CTRL1_TMRA1FN_Enum;

/* =============================================  CTIMER CTRL1 TMRA1CLK [1..5]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRA1CLK                                                     */
  CTIMER_CTRL1_TMRA1CLK_TMRPIN         = 0,     /*!< TMRPIN : Clock source is TMRPINA.                                         */
  CTIMER_CTRL1_TMRA1CLK_HFRC_DIV4      = 1,     /*!< HFRC_DIV4 : Clock source is HFRC / 4                                      */
  CTIMER_CTRL1_TMRA1CLK_HFRC_DIV16     = 2,     /*!< HFRC_DIV16 : Clock source is HFRC / 16                                    */
  CTIMER_CTRL1_TMRA1CLK_HFRC_DIV256    = 3,     /*!< HFRC_DIV256 : Clock source is HFRC / 256                                  */
  CTIMER_CTRL1_TMRA1CLK_HFRC_DIV1024   = 4,     /*!< HFRC_DIV1024 : Clock source is HFRC / 1024                                */
  CTIMER_CTRL1_TMRA1CLK_HFRC_DIV4K     = 5,     /*!< HFRC_DIV4K : Clock source is HFRC / 4096                                  */
  CTIMER_CTRL1_TMRA1CLK_XT             = 6,     /*!< XT : Clock source is the XT (uncalibrated).                               */
  CTIMER_CTRL1_TMRA1CLK_XT_DIV2        = 7,     /*!< XT_DIV2 : Clock source is XT / 2                                          */
  CTIMER_CTRL1_TMRA1CLK_XT_DIV16       = 8,     /*!< XT_DIV16 : Clock source is XT / 16                                        */
  CTIMER_CTRL1_TMRA1CLK_XT_DIV256      = 9,     /*!< XT_DIV256 : Clock source is XT / 256                                      */
  CTIMER_CTRL1_TMRA1CLK_LFRC_DIV2      = 10,    /*!< LFRC_DIV2 : Clock source is LFRC / 2                                      */
  CTIMER_CTRL1_TMRA1CLK_LFRC_DIV32     = 11,    /*!< LFRC_DIV32 : Clock source is LFRC / 32                                    */
  CTIMER_CTRL1_TMRA1CLK_LFRC_DIV1K     = 12,    /*!< LFRC_DIV1K : Clock source is LFRC / 1024                                  */
  CTIMER_CTRL1_TMRA1CLK_LFRC           = 13,    /*!< LFRC : Clock source is LFRC                                               */
  CTIMER_CTRL1_TMRA1CLK_RTC_100HZ      = 14,    /*!< RTC_100HZ : Clock source is 100 Hz from the current RTC oscillator.       */
  CTIMER_CTRL1_TMRA1CLK_HCLK           = 15,    /*!< HCLK : Clock source is HCLK.                                              */
  CTIMER_CTRL1_TMRA1CLK_BUCKA          = 16,    /*!< BUCKA : Clock source is buck converter stream from MEM Buck.              */
} CTIMER_CTRL1_TMRA1CLK_Enum;

/* ==============================================  CTIMER CTRL1 TMRA1EN [0..0]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL1_TMRA1EN                                                      */
  CTIMER_CTRL1_TMRA1EN_DIS             = 0,     /*!< DIS : Counter/Timer A1 Disable.                                           */
  CTIMER_CTRL1_TMRA1EN_EN              = 1,     /*!< EN : Counter/Timer A1 Enable.                                             */
} CTIMER_CTRL1_TMRA1EN_Enum;

/* =========================================================  TMR2  ========================================================== */
/* ========================================================  CMPRA2  ========================================================= */
/* ========================================================  CMPRB2  ========================================================= */
/* =========================================================  CTRL2  ========================================================= */
/* =============================================  CTIMER CTRL2 CTLINK2 [31..31]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_CTLINK2                                                      */
  CTIMER_CTRL2_CTLINK2_TWO_16BIT_TIMERS = 0,    /*!< TWO_16BIT_TIMERS : Use A2/B2 timers as two independent 16-bit
                                                     timers (default).                                                         */
  CTIMER_CTRL2_CTLINK2_32BIT_TIMER     = 1,     /*!< 32BIT_TIMER : Link A2/B2 timers into a single 32-bit timer.               */
} CTIMER_CTRL2_CTLINK2_Enum;

/* =============================================  CTIMER CTRL2 TMRB2PE [29..29]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRB2PE                                                      */
  CTIMER_CTRL2_TMRB2PE_DIS             = 0,     /*!< DIS : Counter/Timer B holds the TMRPINB signal at the value
                                                     TMRB2POL.                                                                 */
  CTIMER_CTRL2_TMRB2PE_EN              = 1,     /*!< EN : Enable counter/timer B2 to generate a signal on TMRPINB.             */
} CTIMER_CTRL2_TMRB2PE_Enum;

/* ============================================  CTIMER CTRL2 TMRB2POL [28..28]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRB2POL                                                     */
  CTIMER_CTRL2_TMRB2POL_NORMAL         = 0,     /*!< NORMAL : The polarity of the TMRPINB2 pin is the same as the
                                                     timer output.                                                             */
  CTIMER_CTRL2_TMRB2POL_INVERTED       = 1,     /*!< INVERTED : The polarity of the TMRPINB2 pin is the inverse of
                                                     the timer output.                                                         */
} CTIMER_CTRL2_TMRB2POL_Enum;

/* ============================================  CTIMER CTRL2 TMRB2CLR [27..27]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRB2CLR                                                     */
  CTIMER_CTRL2_TMRB2CLR_RUN            = 0,     /*!< RUN : Allow counter/timer B2 to run                                       */
  CTIMER_CTRL2_TMRB2CLR_CLEAR          = 1,     /*!< CLEAR : Holds counter/timer B2 at 0x0000.                                 */
} CTIMER_CTRL2_TMRB2CLR_Enum;

/* ============================================  CTIMER CTRL2 TMRB2IE1 [26..26]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRB2IE1                                                     */
  CTIMER_CTRL2_TMRB2IE1_DIS            = 0,     /*!< DIS : Disable counter/timer B2 from generating an interrupt
                                                     based on COMPR1.                                                          */
  CTIMER_CTRL2_TMRB2IE1_EN             = 1,     /*!< EN : Enable counter/timer B2 to generate an interrupt based
                                                     on COMPR1.                                                                */
} CTIMER_CTRL2_TMRB2IE1_Enum;

/* ============================================  CTIMER CTRL2 TMRB2IE0 [25..25]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRB2IE0                                                     */
  CTIMER_CTRL2_TMRB2IE0_DIS            = 0,     /*!< DIS : Disable counter/timer B2 from generating an interrupt
                                                     based on COMPR0.                                                          */
  CTIMER_CTRL2_TMRB2IE0_EN             = 1,     /*!< EN : Enable counter/timer B2 to generate an interrupt based
                                                     on COMPR0                                                                 */
} CTIMER_CTRL2_TMRB2IE0_Enum;

/* =============================================  CTIMER CTRL2 TMRB2FN [22..24]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRB2FN                                                      */
  CTIMER_CTRL2_TMRB2FN_SINGLECOUNT     = 0,     /*!< SINGLECOUNT : Single count (output toggles and sticks). Count
                                                     to CMPR0B2, stop.                                                         */
  CTIMER_CTRL2_TMRB2FN_REPEATEDCOUNT   = 1,     /*!< REPEATEDCOUNT : Repeated count (periodic 1-clock-cycle-wide
                                                     pulses). Count to CMPR0B2, restart.                                       */
  CTIMER_CTRL2_TMRB2FN_PULSE_ONCE      = 2,     /*!< PULSE_ONCE : Pulse once (aka one-shot). Count to CMPR0B2, assert,
                                                     count to CMPR1B2, deassert, stop.                                         */
  CTIMER_CTRL2_TMRB2FN_PULSE_CONT      = 3,     /*!< PULSE_CONT : Pulse continously. Count to CMPR0B2, assert, count
                                                     to CMPR1B2, deassert, restart.                                            */
  CTIMER_CTRL2_TMRB2FN_CONTINUOUS      = 4,     /*!< CONTINUOUS : Continuous run (aka Free Run). Count continuously.           */
} CTIMER_CTRL2_TMRB2FN_Enum;

/* ============================================  CTIMER CTRL2 TMRB2CLK [17..21]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRB2CLK                                                     */
  CTIMER_CTRL2_TMRB2CLK_TMRPIN         = 0,     /*!< TMRPIN : Clock source is TMRPINB.                                         */
  CTIMER_CTRL2_TMRB2CLK_HFRC_DIV4      = 1,     /*!< HFRC_DIV4 : Clock source is HFRC / 4                                      */
  CTIMER_CTRL2_TMRB2CLK_HFRC_DIV16     = 2,     /*!< HFRC_DIV16 : Clock source is HFRC / 16                                    */
  CTIMER_CTRL2_TMRB2CLK_HFRC_DIV256    = 3,     /*!< HFRC_DIV256 : Clock source is HFRC / 256                                  */
  CTIMER_CTRL2_TMRB2CLK_HFRC_DIV1024   = 4,     /*!< HFRC_DIV1024 : Clock source is HFRC / 1024                                */
  CTIMER_CTRL2_TMRB2CLK_HFRC_DIV4K     = 5,     /*!< HFRC_DIV4K : Clock source is HFRC / 4096                                  */
  CTIMER_CTRL2_TMRB2CLK_XT             = 6,     /*!< XT : Clock source is the XT (uncalibrated).                               */
  CTIMER_CTRL2_TMRB2CLK_XT_DIV2        = 7,     /*!< XT_DIV2 : Clock source is XT / 2                                          */
  CTIMER_CTRL2_TMRB2CLK_XT_DIV16       = 8,     /*!< XT_DIV16 : Clock source is XT / 16                                        */
  CTIMER_CTRL2_TMRB2CLK_XT_DIV256      = 9,     /*!< XT_DIV256 : Clock source is XT / 256                                      */
  CTIMER_CTRL2_TMRB2CLK_LFRC_DIV2      = 10,    /*!< LFRC_DIV2 : Clock source is LFRC / 2                                      */
  CTIMER_CTRL2_TMRB2CLK_LFRC_DIV32     = 11,    /*!< LFRC_DIV32 : Clock source is LFRC / 32                                    */
  CTIMER_CTRL2_TMRB2CLK_LFRC_DIV1K     = 12,    /*!< LFRC_DIV1K : Clock source is LFRC / 1024                                  */
  CTIMER_CTRL2_TMRB2CLK_LFRC           = 13,    /*!< LFRC : Clock source is LFRC                                               */
  CTIMER_CTRL2_TMRB2CLK_RTC_100HZ      = 14,    /*!< RTC_100HZ : Clock source is 100 Hz from the current RTC oscillator.       */
  CTIMER_CTRL2_TMRB2CLK_HCLK           = 15,    /*!< HCLK : Clock source is HCLK.                                              */
  CTIMER_CTRL2_TMRB2CLK_BUCKA          = 16,    /*!< BUCKA : Clock source is buck converter stream from MEM Buck.              */
} CTIMER_CTRL2_TMRB2CLK_Enum;

/* =============================================  CTIMER CTRL2 TMRB2EN [16..16]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRB2EN                                                      */
  CTIMER_CTRL2_TMRB2EN_DIS             = 0,     /*!< DIS : Counter/Timer B2 Disable.                                           */
  CTIMER_CTRL2_TMRB2EN_EN              = 1,     /*!< EN : Counter/Timer B2 Enable.                                             */
} CTIMER_CTRL2_TMRB2EN_Enum;

/* =============================================  CTIMER CTRL2 TMRA2PE [13..13]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRA2PE                                                      */
  CTIMER_CTRL2_TMRA2PE_DIS             = 0,     /*!< DIS : Counter/Timer A holds the TMRPINA signal at the value
                                                     TMRA2POL.                                                                 */
  CTIMER_CTRL2_TMRA2PE_EN              = 1,     /*!< EN : Enable counter/timer A2 to generate a signal on TMRPINA.             */
} CTIMER_CTRL2_TMRA2PE_Enum;

/* ============================================  CTIMER CTRL2 TMRA2POL [12..12]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRA2POL                                                     */
  CTIMER_CTRL2_TMRA2POL_NORMAL         = 0,     /*!< NORMAL : The polarity of the TMRPINA2 pin is the same as the
                                                     timer output.                                                             */
  CTIMER_CTRL2_TMRA2POL_INVERTED       = 1,     /*!< INVERTED : The polarity of the TMRPINA2 pin is the inverse of
                                                     the timer output.                                                         */
} CTIMER_CTRL2_TMRA2POL_Enum;

/* ============================================  CTIMER CTRL2 TMRA2CLR [11..11]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRA2CLR                                                     */
  CTIMER_CTRL2_TMRA2CLR_RUN            = 0,     /*!< RUN : Allow counter/timer A2 to run                                       */
  CTIMER_CTRL2_TMRA2CLR_CLEAR          = 1,     /*!< CLEAR : Holds counter/timer A2 at 0x0000.                                 */
} CTIMER_CTRL2_TMRA2CLR_Enum;

/* ============================================  CTIMER CTRL2 TMRA2IE1 [10..10]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRA2IE1                                                     */
  CTIMER_CTRL2_TMRA2IE1_DIS            = 0,     /*!< DIS : Disable counter/timer A2 from generating an interrupt
                                                     based on COMPR1.                                                          */
  CTIMER_CTRL2_TMRA2IE1_EN             = 1,     /*!< EN : Enable counter/timer A2 to generate an interrupt based
                                                     on COMPR1.                                                                */
} CTIMER_CTRL2_TMRA2IE1_Enum;

/* =============================================  CTIMER CTRL2 TMRA2IE0 [9..9]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRA2IE0                                                     */
  CTIMER_CTRL2_TMRA2IE0_DIS            = 0,     /*!< DIS : Disable counter/timer A2 from generating an interrupt
                                                     based on COMPR0.                                                          */
  CTIMER_CTRL2_TMRA2IE0_EN             = 1,     /*!< EN : Enable counter/timer A2 to generate an interrupt based
                                                     on COMPR0.                                                                */
} CTIMER_CTRL2_TMRA2IE0_Enum;

/* ==============================================  CTIMER CTRL2 TMRA2FN [6..8]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRA2FN                                                      */
  CTIMER_CTRL2_TMRA2FN_SINGLECOUNT     = 0,     /*!< SINGLECOUNT : Single count (output toggles and sticks). Count
                                                     to CMPR0A2, stop.                                                         */
  CTIMER_CTRL2_TMRA2FN_REPEATEDCOUNT   = 1,     /*!< REPEATEDCOUNT : Repeated count (periodic 1-clock-cycle-wide
                                                     pulses). Count to CMPR0A2, restart.                                       */
  CTIMER_CTRL2_TMRA2FN_PULSE_ONCE      = 2,     /*!< PULSE_ONCE : Pulse once (aka one-shot). Count to CMPR0A2, assert,
                                                     count to CMPR1A2, deassert, stop.                                         */
  CTIMER_CTRL2_TMRA2FN_PULSE_CONT      = 3,     /*!< PULSE_CONT : Pulse continously. Count to CMPR0A2, assert, count
                                                     to CMPR1A2, deassert, restart.                                            */
  CTIMER_CTRL2_TMRA2FN_CONTINUOUS      = 4,     /*!< CONTINUOUS : Continuous run (aka Free Run). Count continuously.           */
} CTIMER_CTRL2_TMRA2FN_Enum;

/* =============================================  CTIMER CTRL2 TMRA2CLK [1..5]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRA2CLK                                                     */
  CTIMER_CTRL2_TMRA2CLK_TMRPIN         = 0,     /*!< TMRPIN : Clock source is TMRPINA.                                         */
  CTIMER_CTRL2_TMRA2CLK_HFRC_DIV4      = 1,     /*!< HFRC_DIV4 : Clock source is HFRC / 4                                      */
  CTIMER_CTRL2_TMRA2CLK_HFRC_DIV16     = 2,     /*!< HFRC_DIV16 : Clock source is HFRC / 16                                    */
  CTIMER_CTRL2_TMRA2CLK_HFRC_DIV256    = 3,     /*!< HFRC_DIV256 : Clock source is HFRC / 256                                  */
  CTIMER_CTRL2_TMRA2CLK_HFRC_DIV1024   = 4,     /*!< HFRC_DIV1024 : Clock source is HFRC / 1024                                */
  CTIMER_CTRL2_TMRA2CLK_HFRC_DIV4K     = 5,     /*!< HFRC_DIV4K : Clock source is HFRC / 4096                                  */
  CTIMER_CTRL2_TMRA2CLK_XT             = 6,     /*!< XT : Clock source is the XT (uncalibrated).                               */
  CTIMER_CTRL2_TMRA2CLK_XT_DIV2        = 7,     /*!< XT_DIV2 : Clock source is XT / 2                                          */
  CTIMER_CTRL2_TMRA2CLK_XT_DIV16       = 8,     /*!< XT_DIV16 : Clock source is XT / 16                                        */
  CTIMER_CTRL2_TMRA2CLK_XT_DIV256      = 9,     /*!< XT_DIV256 : Clock source is XT / 256                                      */
  CTIMER_CTRL2_TMRA2CLK_LFRC_DIV2      = 10,    /*!< LFRC_DIV2 : Clock source is LFRC / 2                                      */
  CTIMER_CTRL2_TMRA2CLK_LFRC_DIV32     = 11,    /*!< LFRC_DIV32 : Clock source is LFRC / 32                                    */
  CTIMER_CTRL2_TMRA2CLK_LFRC_DIV1K     = 12,    /*!< LFRC_DIV1K : Clock source is LFRC / 1024                                  */
  CTIMER_CTRL2_TMRA2CLK_LFRC           = 13,    /*!< LFRC : Clock source is LFRC                                               */
  CTIMER_CTRL2_TMRA2CLK_RTC_100HZ      = 14,    /*!< RTC_100HZ : Clock source is 100 Hz from the current RTC oscillator.       */
  CTIMER_CTRL2_TMRA2CLK_HCLK           = 15,    /*!< HCLK : Clock source is HCLK.                                              */
  CTIMER_CTRL2_TMRA2CLK_BUCKB          = 16,    /*!< BUCKB : Clock source is buck converter stream from CORE Buck.             */
} CTIMER_CTRL2_TMRA2CLK_Enum;

/* ==============================================  CTIMER CTRL2 TMRA2EN [0..0]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL2_TMRA2EN                                                      */
  CTIMER_CTRL2_TMRA2EN_DIS             = 0,     /*!< DIS : Counter/Timer A2 Disable.                                           */
  CTIMER_CTRL2_TMRA2EN_EN              = 1,     /*!< EN : Counter/Timer A2 Enable.                                             */
} CTIMER_CTRL2_TMRA2EN_Enum;

/* =========================================================  TMR3  ========================================================== */
/* ========================================================  CMPRA3  ========================================================= */
/* ========================================================  CMPRB3  ========================================================= */
/* =========================================================  CTRL3  ========================================================= */
/* =============================================  CTIMER CTRL3 CTLINK3 [31..31]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_CTLINK3                                                      */
  CTIMER_CTRL3_CTLINK3_TWO_16BIT_TIMERS = 0,    /*!< TWO_16BIT_TIMERS : Use A3/B3 timers as two independent 16-bit
                                                     timers (default).                                                         */
  CTIMER_CTRL3_CTLINK3_32BIT_TIMER     = 1,     /*!< 32BIT_TIMER : Link A3/B3 timers into a single 32-bit timer.               */
} CTIMER_CTRL3_CTLINK3_Enum;

/* =============================================  CTIMER CTRL3 TMRB3PE [29..29]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRB3PE                                                      */
  CTIMER_CTRL3_TMRB3PE_DIS             = 0,     /*!< DIS : Counter/Timer B holds the TMRPINB signal at the value
                                                     TMRB3POL.                                                                 */
  CTIMER_CTRL3_TMRB3PE_EN              = 1,     /*!< EN : Enable counter/timer B3 to generate a signal on TMRPINB.             */
} CTIMER_CTRL3_TMRB3PE_Enum;

/* ============================================  CTIMER CTRL3 TMRB3POL [28..28]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRB3POL                                                     */
  CTIMER_CTRL3_TMRB3POL_NORMAL         = 0,     /*!< NORMAL : The polarity of the TMRPINB3 pin is the same as the
                                                     timer output.                                                             */
  CTIMER_CTRL3_TMRB3POL_INVERTED       = 1,     /*!< INVERTED : The polarity of the TMRPINB3 pin is the inverse of
                                                     the timer output.                                                         */
} CTIMER_CTRL3_TMRB3POL_Enum;

/* ============================================  CTIMER CTRL3 TMRB3CLR [27..27]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRB3CLR                                                     */
  CTIMER_CTRL3_TMRB3CLR_RUN            = 0,     /*!< RUN : Allow counter/timer B3 to run                                       */
  CTIMER_CTRL3_TMRB3CLR_CLEAR          = 1,     /*!< CLEAR : Holds counter/timer B3 at 0x0000.                                 */
} CTIMER_CTRL3_TMRB3CLR_Enum;

/* ============================================  CTIMER CTRL3 TMRB3IE1 [26..26]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRB3IE1                                                     */
  CTIMER_CTRL3_TMRB3IE1_DIS            = 0,     /*!< DIS : Disable counter/timer B3 from generating an interrupt
                                                     based on COMPR1.                                                          */
  CTIMER_CTRL3_TMRB3IE1_EN             = 1,     /*!< EN : Enable counter/timer B3 to generate an interrupt based
                                                     on COMPR1.                                                                */
} CTIMER_CTRL3_TMRB3IE1_Enum;

/* ============================================  CTIMER CTRL3 TMRB3IE0 [25..25]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRB3IE0                                                     */
  CTIMER_CTRL3_TMRB3IE0_DIS            = 0,     /*!< DIS : Disable counter/timer B3 from generating an interrupt
                                                     based on COMPR0.                                                          */
  CTIMER_CTRL3_TMRB3IE0_EN             = 1,     /*!< EN : Enable counter/timer B3 to generate an interrupt based
                                                     on COMPR0                                                                 */
} CTIMER_CTRL3_TMRB3IE0_Enum;

/* =============================================  CTIMER CTRL3 TMRB3FN [22..24]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRB3FN                                                      */
  CTIMER_CTRL3_TMRB3FN_SINGLECOUNT     = 0,     /*!< SINGLECOUNT : Single count (output toggles and sticks). Count
                                                     to CMPR0B3, stop.                                                         */
  CTIMER_CTRL3_TMRB3FN_REPEATEDCOUNT   = 1,     /*!< REPEATEDCOUNT : Repeated count (periodic 1-clock-cycle-wide
                                                     pulses). Count to CMPR0B3, restart.                                       */
  CTIMER_CTRL3_TMRB3FN_PULSE_ONCE      = 2,     /*!< PULSE_ONCE : Pulse once (aka one-shot). Count to CMPR0B3, assert,
                                                     count to CMPR1B3, deassert, stop.                                         */
  CTIMER_CTRL3_TMRB3FN_PULSE_CONT      = 3,     /*!< PULSE_CONT : Pulse continously. Count to CMPR0B3, assert, count
                                                     to CMPR1B3, deassert, restart.                                            */
  CTIMER_CTRL3_TMRB3FN_CONTINUOUS      = 4,     /*!< CONTINUOUS : Continuous run (aka Free Run). Count continuously.           */
} CTIMER_CTRL3_TMRB3FN_Enum;

/* ============================================  CTIMER CTRL3 TMRB3CLK [17..21]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRB3CLK                                                     */
  CTIMER_CTRL3_TMRB3CLK_TMRPIN         = 0,     /*!< TMRPIN : Clock source is TMRPINB.                                         */
  CTIMER_CTRL3_TMRB3CLK_HFRC_DIV4      = 1,     /*!< HFRC_DIV4 : Clock source is HFRC / 4                                      */
  CTIMER_CTRL3_TMRB3CLK_HFRC_DIV16     = 2,     /*!< HFRC_DIV16 : Clock source is HFRC / 16                                    */
  CTIMER_CTRL3_TMRB3CLK_HFRC_DIV256    = 3,     /*!< HFRC_DIV256 : Clock source is HFRC / 256                                  */
  CTIMER_CTRL3_TMRB3CLK_HFRC_DIV1024   = 4,     /*!< HFRC_DIV1024 : Clock source is HFRC / 1024                                */
  CTIMER_CTRL3_TMRB3CLK_HFRC_DIV4K     = 5,     /*!< HFRC_DIV4K : Clock source is HFRC / 4096                                  */
  CTIMER_CTRL3_TMRB3CLK_XT             = 6,     /*!< XT : Clock source is the XT (uncalibrated).                               */
  CTIMER_CTRL3_TMRB3CLK_XT_DIV2        = 7,     /*!< XT_DIV2 : Clock source is XT / 2                                          */
  CTIMER_CTRL3_TMRB3CLK_XT_DIV16       = 8,     /*!< XT_DIV16 : Clock source is XT / 16                                        */
  CTIMER_CTRL3_TMRB3CLK_XT_DIV256      = 9,     /*!< XT_DIV256 : Clock source is XT / 256                                      */
  CTIMER_CTRL3_TMRB3CLK_LFRC_DIV2      = 10,    /*!< LFRC_DIV2 : Clock source is LFRC / 2                                      */
  CTIMER_CTRL3_TMRB3CLK_LFRC_DIV32     = 11,    /*!< LFRC_DIV32 : Clock source is LFRC / 32                                    */
  CTIMER_CTRL3_TMRB3CLK_LFRC_DIV1K     = 12,    /*!< LFRC_DIV1K : Clock source is LFRC / 1024                                  */
  CTIMER_CTRL3_TMRB3CLK_LFRC           = 13,    /*!< LFRC : Clock source is LFRC                                               */
  CTIMER_CTRL3_TMRB3CLK_RTC_100HZ      = 14,    /*!< RTC_100HZ : Clock source is 100 Hz from the current RTC oscillator.       */
  CTIMER_CTRL3_TMRB3CLK_HCLK           = 15,    /*!< HCLK : Clock source is HCLK.                                              */
  CTIMER_CTRL3_TMRB3CLK_BUCKA          = 16,    /*!< BUCKA : Clock source is buck converter stream from MEM Buck.              */
} CTIMER_CTRL3_TMRB3CLK_Enum;

/* =============================================  CTIMER CTRL3 TMRB3EN [16..16]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRB3EN                                                      */
  CTIMER_CTRL3_TMRB3EN_DIS             = 0,     /*!< DIS : Counter/Timer B3 Disable.                                           */
  CTIMER_CTRL3_TMRB3EN_EN              = 1,     /*!< EN : Counter/Timer B3 Enable.                                             */
} CTIMER_CTRL3_TMRB3EN_Enum;

/* =============================================  CTIMER CTRL3 TMRA3PE [13..13]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRA3PE                                                      */
  CTIMER_CTRL3_TMRA3PE_DIS             = 0,     /*!< DIS : Counter/Timer A holds the TMRPINA signal at the value
                                                     TMRA3POL.                                                                 */
  CTIMER_CTRL3_TMRA3PE_EN              = 1,     /*!< EN : Enable counter/timer A3 to generate a signal on TMRPINA.             */
} CTIMER_CTRL3_TMRA3PE_Enum;

/* ============================================  CTIMER CTRL3 TMRA3POL [12..12]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRA3POL                                                     */
  CTIMER_CTRL3_TMRA3POL_NORMAL         = 0,     /*!< NORMAL : The polarity of the TMRPINA3 pin is the same as the
                                                     timer output.                                                             */
  CTIMER_CTRL3_TMRA3POL_INVERTED       = 1,     /*!< INVERTED : The polarity of the TMRPINA3 pin is the inverse of
                                                     the timer output.                                                         */
} CTIMER_CTRL3_TMRA3POL_Enum;

/* ============================================  CTIMER CTRL3 TMRA3CLR [11..11]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRA3CLR                                                     */
  CTIMER_CTRL3_TMRA3CLR_RUN            = 0,     /*!< RUN : Allow counter/timer A3 to run                                       */
  CTIMER_CTRL3_TMRA3CLR_CLEAR          = 1,     /*!< CLEAR : Holds counter/timer A3 at 0x0000.                                 */
} CTIMER_CTRL3_TMRA3CLR_Enum;

/* ============================================  CTIMER CTRL3 TMRA3IE1 [10..10]  ============================================= */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRA3IE1                                                     */
  CTIMER_CTRL3_TMRA3IE1_DIS            = 0,     /*!< DIS : Disable counter/timer A3 from generating an interrupt
                                                     based on COMPR1.                                                          */
  CTIMER_CTRL3_TMRA3IE1_EN             = 1,     /*!< EN : Enable counter/timer A3 to generate an interrupt based
                                                     on COMPR1.                                                                */
} CTIMER_CTRL3_TMRA3IE1_Enum;

/* =============================================  CTIMER CTRL3 TMRA3IE0 [9..9]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRA3IE0                                                     */
  CTIMER_CTRL3_TMRA3IE0_DIS            = 0,     /*!< DIS : Disable counter/timer A3 from generating an interrupt
                                                     based on COMPR0.                                                          */
  CTIMER_CTRL3_TMRA3IE0_EN             = 1,     /*!< EN : Enable counter/timer A3 to generate an interrupt based
                                                     on COMPR0.                                                                */
} CTIMER_CTRL3_TMRA3IE0_Enum;

/* ==============================================  CTIMER CTRL3 TMRA3FN [6..8]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRA3FN                                                      */
  CTIMER_CTRL3_TMRA3FN_SINGLECOUNT     = 0,     /*!< SINGLECOUNT : Single count (output toggles and sticks). Count
                                                     to CMPR0A3, stop.                                                         */
  CTIMER_CTRL3_TMRA3FN_REPEATEDCOUNT   = 1,     /*!< REPEATEDCOUNT : Repeated count (periodic 1-clock-cycle-wide
                                                     pulses). Count to CMPR0A3, restart.                                       */
  CTIMER_CTRL3_TMRA3FN_PULSE_ONCE      = 2,     /*!< PULSE_ONCE : Pulse once (aka one-shot). Count to CMPR0A3, assert,
                                                     count to CMPR1A3, deassert, stop.                                         */
  CTIMER_CTRL3_TMRA3FN_PULSE_CONT      = 3,     /*!< PULSE_CONT : Pulse continously. Count to CMPR0A3, assert, count
                                                     to CMPR1A3, deassert, restart.                                            */
  CTIMER_CTRL3_TMRA3FN_CONTINUOUS      = 4,     /*!< CONTINUOUS : Continuous run (aka Free Run). Count continuously.           */
} CTIMER_CTRL3_TMRA3FN_Enum;

/* =============================================  CTIMER CTRL3 TMRA3CLK [1..5]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRA3CLK                                                     */
  CTIMER_CTRL3_TMRA3CLK_TMRPIN         = 0,     /*!< TMRPIN : Clock source is TMRPINA.                                         */
  CTIMER_CTRL3_TMRA3CLK_HFRC_DIV4      = 1,     /*!< HFRC_DIV4 : Clock source is HFRC / 4                                      */
  CTIMER_CTRL3_TMRA3CLK_HFRC_DIV16     = 2,     /*!< HFRC_DIV16 : Clock source is HFRC / 16                                    */
  CTIMER_CTRL3_TMRA3CLK_HFRC_DIV256    = 3,     /*!< HFRC_DIV256 : Clock source is HFRC / 256                                  */
  CTIMER_CTRL3_TMRA3CLK_HFRC_DIV1024   = 4,     /*!< HFRC_DIV1024 : Clock source is HFRC / 1024                                */
  CTIMER_CTRL3_TMRA3CLK_HFRC_DIV4K     = 5,     /*!< HFRC_DIV4K : Clock source is HFRC / 4096                                  */
  CTIMER_CTRL3_TMRA3CLK_XT             = 6,     /*!< XT : Clock source is the XT (uncalibrated).                               */
  CTIMER_CTRL3_TMRA3CLK_XT_DIV2        = 7,     /*!< XT_DIV2 : Clock source is XT / 2                                          */
  CTIMER_CTRL3_TMRA3CLK_XT_DIV16       = 8,     /*!< XT_DIV16 : Clock source is XT / 16                                        */
  CTIMER_CTRL3_TMRA3CLK_XT_DIV256      = 9,     /*!< XT_DIV256 : Clock source is XT / 256                                      */
  CTIMER_CTRL3_TMRA3CLK_LFRC_DIV2      = 10,    /*!< LFRC_DIV2 : Clock source is LFRC / 2                                      */
  CTIMER_CTRL3_TMRA3CLK_LFRC_DIV32     = 11,    /*!< LFRC_DIV32 : Clock source is LFRC / 32                                    */
  CTIMER_CTRL3_TMRA3CLK_LFRC_DIV1K     = 12,    /*!< LFRC_DIV1K : Clock source is LFRC / 1024                                  */
  CTIMER_CTRL3_TMRA3CLK_LFRC           = 13,    /*!< LFRC : Clock source is LFRC                                               */
  CTIMER_CTRL3_TMRA3CLK_RTC_100HZ      = 14,    /*!< RTC_100HZ : Clock source is 100 Hz from the current RTC oscillator.       */
  CTIMER_CTRL3_TMRA3CLK_HCLK           = 15,    /*!< HCLK : Clock source is HCLK.                                              */
  CTIMER_CTRL3_TMRA3CLK_BUCKB          = 16,    /*!< BUCKB : Clock source is buck converter stream from CORE Buck.             */
} CTIMER_CTRL3_TMRA3CLK_Enum;

/* ==============================================  CTIMER CTRL3 TMRA3EN [0..0]  ============================================== */
typedef enum {                                  /*!< CTIMER_CTRL3_TMRA3EN                                                      */
  CTIMER_CTRL3_TMRA3EN_DIS             = 0,     /*!< DIS : Counter/Timer A3 Disable.                                           */
  CTIMER_CTRL3_TMRA3EN_EN              = 1,     /*!< EN : Counter/Timer A3 Enable.                                             */
} CTIMER_CTRL3_TMRA3EN_Enum;

/* =========================================================  STCFG  ========================================================= */
/* =============================================  CTIMER STCFG FREEZE [31..31]  ============================================== */
typedef enum {                                  /*!< CTIMER_STCFG_FREEZE                                                       */
  CTIMER_STCFG_FREEZE_THAW             = 0,     /*!< THAW : Let the COUNTER register run on its input clock.                   */
  CTIMER_STCFG_FREEZE_FREEZE           = 1,     /*!< FREEZE : Stop the COUNTER register for loading.                           */
} CTIMER_STCFG_FREEZE_Enum;

/* ==============================================  CTIMER STCFG CLEAR [30..30]  ============================================== */
typedef enum {                                  /*!< CTIMER_STCFG_CLEAR                                                        */
  CTIMER_STCFG_CLEAR_RUN               = 0,     /*!< RUN : Let the COUNTER register run on its input clock.                    */
  CTIMER_STCFG_CLEAR_CLEAR             = 1,     /*!< CLEAR : Stop the COUNTER register for loading.                            */
} CTIMER_STCFG_CLEAR_Enum;

/* ==========================================  CTIMER STCFG COMPARE_H_EN [15..15]  =========================================== */
typedef enum {                                  /*!< CTIMER_STCFG_COMPARE_H_EN                                                 */
  CTIMER_STCFG_COMPARE_H_EN_DISABLE    = 0,     /*!< DISABLE : Compare H disabled.                                             */
  CTIMER_STCFG_COMPARE_H_EN_ENABLE     = 1,     /*!< ENABLE : Compare H enabled.                                               */
} CTIMER_STCFG_COMPARE_H_EN_Enum;

/* ==========================================  CTIMER STCFG COMPARE_G_EN [14..14]  =========================================== */
typedef enum {                                  /*!< CTIMER_STCFG_COMPARE_G_EN                                                 */
  CTIMER_STCFG_COMPARE_G_EN_DISABLE    = 0,     /*!< DISABLE : Compare G disabled.                                             */
  CTIMER_STCFG_COMPARE_G_EN_ENABLE     = 1,     /*!< ENABLE : Compare G enabled.                                               */
} CTIMER_STCFG_COMPARE_G_EN_Enum;

/* ==========================================  CTIMER STCFG COMPARE_F_EN [13..13]  =========================================== */
typedef enum {                                  /*!< CTIMER_STCFG_COMPARE_F_EN                                                 */
  CTIMER_STCFG_COMPARE_F_EN_DISABLE    = 0,     /*!< DISABLE : Compare F disabled.                                             */
  CTIMER_STCFG_COMPARE_F_EN_ENABLE     = 1,     /*!< ENABLE : Compare F enabled.                                               */
} CTIMER_STCFG_COMPARE_F_EN_Enum;

/* ==========================================  CTIMER STCFG COMPARE_E_EN [12..12]  =========================================== */
typedef enum {                                  /*!< CTIMER_STCFG_COMPARE_E_EN                                                 */
  CTIMER_STCFG_COMPARE_E_EN_DISABLE    = 0,     /*!< DISABLE : Compare E disabled.                                             */
  CTIMER_STCFG_COMPARE_E_EN_ENABLE     = 1,     /*!< ENABLE : Compare E enabled.                                               */
} CTIMER_STCFG_COMPARE_E_EN_Enum;

/* ==========================================  CTIMER STCFG COMPARE_D_EN [11..11]  =========================================== */
typedef enum {                                  /*!< CTIMER_STCFG_COMPARE_D_EN                                                 */
  CTIMER_STCFG_COMPARE_D_EN_DISABLE    = 0,     /*!< DISABLE : Compare D disabled.                                             */
  CTIMER_STCFG_COMPARE_D_EN_ENABLE     = 1,     /*!< ENABLE : Compare D enabled.                                               */
} CTIMER_STCFG_COMPARE_D_EN_Enum;

/* ==========================================  CTIMER STCFG COMPARE_C_EN [10..10]  =========================================== */
typedef enum {                                  /*!< CTIMER_STCFG_COMPARE_C_EN                                                 */
  CTIMER_STCFG_COMPARE_C_EN_DISABLE    = 0,     /*!< DISABLE : Compare C disabled.                                             */
  CTIMER_STCFG_COMPARE_C_EN_ENABLE     = 1,     /*!< ENABLE : Compare C enabled.                                               */
} CTIMER_STCFG_COMPARE_C_EN_Enum;

/* ===========================================  CTIMER STCFG COMPARE_B_EN [9..9]  ============================================ */
typedef enum {                                  /*!< CTIMER_STCFG_COMPARE_B_EN                                                 */
  CTIMER_STCFG_COMPARE_B_EN_DISABLE    = 0,     /*!< DISABLE : Compare B disabled.                                             */
  CTIMER_STCFG_COMPARE_B_EN_ENABLE     = 1,     /*!< ENABLE : Compare B enabled.                                               */
} CTIMER_STCFG_COMPARE_B_EN_Enum;

/* ===========================================  CTIMER STCFG COMPARE_A_EN [8..8]  ============================================ */
typedef enum {                                  /*!< CTIMER_STCFG_COMPARE_A_EN                                                 */
  CTIMER_STCFG_COMPARE_A_EN_DISABLE    = 0,     /*!< DISABLE : Compare A disabled.                                             */
  CTIMER_STCFG_COMPARE_A_EN_ENABLE     = 1,     /*!< ENABLE : Compare A enabled.                                               */
} CTIMER_STCFG_COMPARE_A_EN_Enum;

/* ==============================================  CTIMER STCFG CLKSEL [0..3]  =============================================== */
typedef enum {                                  /*!< CTIMER_STCFG_CLKSEL                                                       */
  CTIMER_STCFG_CLKSEL_NOCLK            = 0,     /*!< NOCLK : No clock enabled.                                                 */
  CTIMER_STCFG_CLKSEL_HFRC_DIV16       = 1,     /*!< HFRC_DIV16 : 3MHz from the HFRC clock divider.                            */
  CTIMER_STCFG_CLKSEL_HFRC_DIV256      = 2,     /*!< HFRC_DIV256 : 187.5KHz from the HFRC clock divider.                       */
  CTIMER_STCFG_CLKSEL_XTAL_DIV1        = 3,     /*!< XTAL_DIV1 : 32768Hz from the crystal oscillator.                          */
  CTIMER_STCFG_CLKSEL_XTAL_DIV2        = 4,     /*!< XTAL_DIV2 : 16384Hz from the crystal oscillator.                          */
  CTIMER_STCFG_CLKSEL_XTAL_DIV32       = 5,     /*!< XTAL_DIV32 : 1024Hz from the crystal oscillator.                          */
  CTIMER_STCFG_CLKSEL_LFRC_DIV1        = 6,     /*!< LFRC_DIV1 : Approximately 1KHz from the LFRC oscillator (uncalibrated).   */
  CTIMER_STCFG_CLKSEL_CTIMER0A         = 7,     /*!< CTIMER0A : Use CTIMER 0 section A as a prescaler for the clock
                                                     source.                                                                   */
  CTIMER_STCFG_CLKSEL_CTIMER0B         = 8,     /*!< CTIMER0B : Use CTIMER 0 section B (or A and B linked together)
                                                     as a prescaler for the clock source.                                      */
} CTIMER_STCFG_CLKSEL_Enum;

/* =========================================================  STTMR  ========================================================= */
/* ====================================================  CAPTURE_CONTROL  ==================================================== */
/* ========================================  CTIMER CAPTURE_CONTROL CAPTURE_D [3..3]  ======================================== */
typedef enum {                                  /*!< CTIMER_CAPTURE_CONTROL_CAPTURE_D                                          */
  CTIMER_CAPTURE_CONTROL_CAPTURE_D_DISABLE = 0, /*!< DISABLE : Capture function disabled.                                      */
  CTIMER_CAPTURE_CONTROL_CAPTURE_D_ENABLE = 1,  /*!< ENABLE : Capture function enabled.                                        */
} CTIMER_CAPTURE_CONTROL_CAPTURE_D_Enum;

/* ========================================  CTIMER CAPTURE_CONTROL CAPTURE_C [2..2]  ======================================== */
typedef enum {                                  /*!< CTIMER_CAPTURE_CONTROL_CAPTURE_C                                          */
  CTIMER_CAPTURE_CONTROL_CAPTURE_C_DISABLE = 0, /*!< DISABLE : Capture function disabled.                                      */
  CTIMER_CAPTURE_CONTROL_CAPTURE_C_ENABLE = 1,  /*!< ENABLE : Capture function enabled.                                        */
} CTIMER_CAPTURE_CONTROL_CAPTURE_C_Enum;

/* ========================================  CTIMER CAPTURE_CONTROL CAPTURE_B [1..1]  ======================================== */
typedef enum {                                  /*!< CTIMER_CAPTURE_CONTROL_CAPTURE_B                                          */
  CTIMER_CAPTURE_CONTROL_CAPTURE_B_DISABLE = 0, /*!< DISABLE : Capture function disabled.                                      */
  CTIMER_CAPTURE_CONTROL_CAPTURE_B_ENABLE = 1,  /*!< ENABLE : Capture function enabled.                                        */
} CTIMER_CAPTURE_CONTROL_CAPTURE_B_Enum;

/* ========================================  CTIMER CAPTURE_CONTROL CAPTURE_A [0..0]  ======================================== */
typedef enum {                                  /*!< CTIMER_CAPTURE_CONTROL_CAPTURE_A                                          */
  CTIMER_CAPTURE_CONTROL_CAPTURE_A_DISABLE = 0, /*!< DISABLE : Capture function disabled.                                      */
  CTIMER_CAPTURE_CONTROL_CAPTURE_A_ENABLE = 1,  /*!< ENABLE : Capture function enabled.                                        */
} CTIMER_CAPTURE_CONTROL_CAPTURE_A_Enum;

/* ========================================================  SCMPR0  ========================================================= */
/* ========================================================  SCMPR1  ========================================================= */
/* ========================================================  SCMPR2  ========================================================= */
/* ========================================================  SCMPR3  ========================================================= */
/* ========================================================  SCMPR4  ========================================================= */
/* ========================================================  SCMPR5  ========================================================= */
/* ========================================================  SCMPR6  ========================================================= */
/* ========================================================  SCMPR7  ========================================================= */
/* ========================================================  SCAPT0  ========================================================= */
/* ========================================================  SCAPT1  ========================================================= */
/* ========================================================  SCAPT2  ========================================================= */
/* ========================================================  SCAPT3  ========================================================= */
/* =========================================================  SNVR0  ========================================================= */
/* =========================================================  SNVR1  ========================================================= */
/* =========================================================  SNVR2  ========================================================= */
/* =========================================================  INTEN  ========================================================= */
/* ========================================================  INTSTAT  ======================================================== */
/* ========================================================  INTCLR  ========================================================= */
/* ========================================================  INTSET  ========================================================= */
/* =======================================================  STMINTEN  ======================================================== */
/* ===========================================  CTIMER STMINTEN CAPTURED [12..12]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTEN_CAPTURED                                                  */
  CTIMER_STMINTEN_CAPTURED_CAPD_INT    = 1,     /*!< CAPD_INT : Capture D interrupt status bit was set.                        */
} CTIMER_STMINTEN_CAPTURED_Enum;

/* ===========================================  CTIMER STMINTEN CAPTUREC [11..11]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTEN_CAPTUREC                                                  */
  CTIMER_STMINTEN_CAPTUREC_CAPC_INT    = 1,     /*!< CAPC_INT : CAPTURE C interrupt status bit was set.                        */
} CTIMER_STMINTEN_CAPTUREC_Enum;

/* ===========================================  CTIMER STMINTEN CAPTUREB [10..10]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTEN_CAPTUREB                                                  */
  CTIMER_STMINTEN_CAPTUREB_CAPB_INT    = 1,     /*!< CAPB_INT : CAPTURE B interrupt status bit was set.                        */
} CTIMER_STMINTEN_CAPTUREB_Enum;

/* ============================================  CTIMER STMINTEN CAPTUREA [9..9]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTEN_CAPTUREA                                                  */
  CTIMER_STMINTEN_CAPTUREA_CAPA_INT    = 1,     /*!< CAPA_INT : CAPTURE A interrupt status bit was set.                        */
} CTIMER_STMINTEN_CAPTUREA_Enum;

/* ============================================  CTIMER STMINTEN OVERFLOW [8..8]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTEN_OVERFLOW                                                  */
  CTIMER_STMINTEN_OVERFLOW_OFLOW_INT   = 1,     /*!< OFLOW_INT : Overflow interrupt status bit was set.                        */
} CTIMER_STMINTEN_OVERFLOW_Enum;

/* ============================================  CTIMER STMINTEN COMPAREH [7..7]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTEN_COMPAREH                                                  */
  CTIMER_STMINTEN_COMPAREH_COMPARED    = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTEN_COMPAREH_Enum;

/* ============================================  CTIMER STMINTEN COMPAREG [6..6]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTEN_COMPAREG                                                  */
  CTIMER_STMINTEN_COMPAREG_COMPARED    = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTEN_COMPAREG_Enum;

/* ============================================  CTIMER STMINTEN COMPAREF [5..5]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTEN_COMPAREF                                                  */
  CTIMER_STMINTEN_COMPAREF_COMPARED    = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTEN_COMPAREF_Enum;

/* ============================================  CTIMER STMINTEN COMPAREE [4..4]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTEN_COMPAREE                                                  */
  CTIMER_STMINTEN_COMPAREE_COMPARED    = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTEN_COMPAREE_Enum;

/* ============================================  CTIMER STMINTEN COMPARED [3..3]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTEN_COMPARED                                                  */
  CTIMER_STMINTEN_COMPARED_COMPARED    = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTEN_COMPARED_Enum;

/* ============================================  CTIMER STMINTEN COMPAREC [2..2]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTEN_COMPAREC                                                  */
  CTIMER_STMINTEN_COMPAREC_COMPARED    = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTEN_COMPAREC_Enum;

/* ============================================  CTIMER STMINTEN COMPAREB [1..1]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTEN_COMPAREB                                                  */
  CTIMER_STMINTEN_COMPAREB_COMPARED    = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTEN_COMPAREB_Enum;

/* ============================================  CTIMER STMINTEN COMPAREA [0..0]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTEN_COMPAREA                                                  */
  CTIMER_STMINTEN_COMPAREA_COMPARED    = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTEN_COMPAREA_Enum;

/* ======================================================  STMINTSTAT  ======================================================= */
/* ==========================================  CTIMER STMINTSTAT CAPTURED [12..12]  ========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_CAPTURED                                                */
  CTIMER_STMINTSTAT_CAPTURED_CAPD_INT  = 1,     /*!< CAPD_INT : Capture D interrupt status bit was set.                        */
} CTIMER_STMINTSTAT_CAPTURED_Enum;

/* ==========================================  CTIMER STMINTSTAT CAPTUREC [11..11]  ========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_CAPTUREC                                                */
  CTIMER_STMINTSTAT_CAPTUREC_CAPC_INT  = 1,     /*!< CAPC_INT : CAPTURE C interrupt status bit was set.                        */
} CTIMER_STMINTSTAT_CAPTUREC_Enum;

/* ==========================================  CTIMER STMINTSTAT CAPTUREB [10..10]  ========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_CAPTUREB                                                */
  CTIMER_STMINTSTAT_CAPTUREB_CAPB_INT  = 1,     /*!< CAPB_INT : CAPTURE B interrupt status bit was set.                        */
} CTIMER_STMINTSTAT_CAPTUREB_Enum;

/* ===========================================  CTIMER STMINTSTAT CAPTUREA [9..9]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_CAPTUREA                                                */
  CTIMER_STMINTSTAT_CAPTUREA_CAPA_INT  = 1,     /*!< CAPA_INT : CAPTURE A interrupt status bit was set.                        */
} CTIMER_STMINTSTAT_CAPTUREA_Enum;

/* ===========================================  CTIMER STMINTSTAT OVERFLOW [8..8]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_OVERFLOW                                                */
  CTIMER_STMINTSTAT_OVERFLOW_OFLOW_INT = 1,     /*!< OFLOW_INT : Overflow interrupt status bit was set.                        */
} CTIMER_STMINTSTAT_OVERFLOW_Enum;

/* ===========================================  CTIMER STMINTSTAT COMPAREH [7..7]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_COMPAREH                                                */
  CTIMER_STMINTSTAT_COMPAREH_COMPARED  = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSTAT_COMPAREH_Enum;

/* ===========================================  CTIMER STMINTSTAT COMPAREG [6..6]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_COMPAREG                                                */
  CTIMER_STMINTSTAT_COMPAREG_COMPARED  = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSTAT_COMPAREG_Enum;

/* ===========================================  CTIMER STMINTSTAT COMPAREF [5..5]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_COMPAREF                                                */
  CTIMER_STMINTSTAT_COMPAREF_COMPARED  = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSTAT_COMPAREF_Enum;

/* ===========================================  CTIMER STMINTSTAT COMPAREE [4..4]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_COMPAREE                                                */
  CTIMER_STMINTSTAT_COMPAREE_COMPARED  = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSTAT_COMPAREE_Enum;

/* ===========================================  CTIMER STMINTSTAT COMPARED [3..3]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_COMPARED                                                */
  CTIMER_STMINTSTAT_COMPARED_COMPARED  = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSTAT_COMPARED_Enum;

/* ===========================================  CTIMER STMINTSTAT COMPAREC [2..2]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_COMPAREC                                                */
  CTIMER_STMINTSTAT_COMPAREC_COMPARED  = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSTAT_COMPAREC_Enum;

/* ===========================================  CTIMER STMINTSTAT COMPAREB [1..1]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_COMPAREB                                                */
  CTIMER_STMINTSTAT_COMPAREB_COMPARED  = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSTAT_COMPAREB_Enum;

/* ===========================================  CTIMER STMINTSTAT COMPAREA [0..0]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSTAT_COMPAREA                                                */
  CTIMER_STMINTSTAT_COMPAREA_COMPARED  = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSTAT_COMPAREA_Enum;

/* =======================================================  STMINTCLR  ======================================================= */
/* ==========================================  CTIMER STMINTCLR CAPTURED [12..12]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTCLR_CAPTURED                                                 */
  CTIMER_STMINTCLR_CAPTURED_CAPD_INT   = 1,     /*!< CAPD_INT : Capture D interrupt status bit was set.                        */
} CTIMER_STMINTCLR_CAPTURED_Enum;

/* ==========================================  CTIMER STMINTCLR CAPTUREC [11..11]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTCLR_CAPTUREC                                                 */
  CTIMER_STMINTCLR_CAPTUREC_CAPC_INT   = 1,     /*!< CAPC_INT : CAPTURE C interrupt status bit was set.                        */
} CTIMER_STMINTCLR_CAPTUREC_Enum;

/* ==========================================  CTIMER STMINTCLR CAPTUREB [10..10]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTCLR_CAPTUREB                                                 */
  CTIMER_STMINTCLR_CAPTUREB_CAPB_INT   = 1,     /*!< CAPB_INT : CAPTURE B interrupt status bit was set.                        */
} CTIMER_STMINTCLR_CAPTUREB_Enum;

/* ===========================================  CTIMER STMINTCLR CAPTUREA [9..9]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTCLR_CAPTUREA                                                 */
  CTIMER_STMINTCLR_CAPTUREA_CAPA_INT   = 1,     /*!< CAPA_INT : CAPTURE A interrupt status bit was set.                        */
} CTIMER_STMINTCLR_CAPTUREA_Enum;

/* ===========================================  CTIMER STMINTCLR OVERFLOW [8..8]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTCLR_OVERFLOW                                                 */
  CTIMER_STMINTCLR_OVERFLOW_OFLOW_INT  = 1,     /*!< OFLOW_INT : Overflow interrupt status bit was set.                        */
} CTIMER_STMINTCLR_OVERFLOW_Enum;

/* ===========================================  CTIMER STMINTCLR COMPAREH [7..7]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTCLR_COMPAREH                                                 */
  CTIMER_STMINTCLR_COMPAREH_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTCLR_COMPAREH_Enum;

/* ===========================================  CTIMER STMINTCLR COMPAREG [6..6]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTCLR_COMPAREG                                                 */
  CTIMER_STMINTCLR_COMPAREG_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTCLR_COMPAREG_Enum;

/* ===========================================  CTIMER STMINTCLR COMPAREF [5..5]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTCLR_COMPAREF                                                 */
  CTIMER_STMINTCLR_COMPAREF_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTCLR_COMPAREF_Enum;

/* ===========================================  CTIMER STMINTCLR COMPAREE [4..4]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTCLR_COMPAREE                                                 */
  CTIMER_STMINTCLR_COMPAREE_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTCLR_COMPAREE_Enum;

/* ===========================================  CTIMER STMINTCLR COMPARED [3..3]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTCLR_COMPARED                                                 */
  CTIMER_STMINTCLR_COMPARED_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTCLR_COMPARED_Enum;

/* ===========================================  CTIMER STMINTCLR COMPAREC [2..2]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTCLR_COMPAREC                                                 */
  CTIMER_STMINTCLR_COMPAREC_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTCLR_COMPAREC_Enum;

/* ===========================================  CTIMER STMINTCLR COMPAREB [1..1]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTCLR_COMPAREB                                                 */
  CTIMER_STMINTCLR_COMPAREB_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTCLR_COMPAREB_Enum;

/* ===========================================  CTIMER STMINTCLR COMPAREA [0..0]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTCLR_COMPAREA                                                 */
  CTIMER_STMINTCLR_COMPAREA_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTCLR_COMPAREA_Enum;

/* =======================================================  STMINTSET  ======================================================= */
/* ==========================================  CTIMER STMINTSET CAPTURED [12..12]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSET_CAPTURED                                                 */
  CTIMER_STMINTSET_CAPTURED_CAPD_INT   = 1,     /*!< CAPD_INT : Capture D interrupt status bit was set.                        */
} CTIMER_STMINTSET_CAPTURED_Enum;

/* ==========================================  CTIMER STMINTSET CAPTUREC [11..11]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSET_CAPTUREC                                                 */
  CTIMER_STMINTSET_CAPTUREC_CAPC_INT   = 1,     /*!< CAPC_INT : CAPTURE C interrupt status bit was set.                        */
} CTIMER_STMINTSET_CAPTUREC_Enum;

/* ==========================================  CTIMER STMINTSET CAPTUREB [10..10]  =========================================== */
typedef enum {                                  /*!< CTIMER_STMINTSET_CAPTUREB                                                 */
  CTIMER_STMINTSET_CAPTUREB_CAPB_INT   = 1,     /*!< CAPB_INT : CAPTURE B interrupt status bit was set.                        */
} CTIMER_STMINTSET_CAPTUREB_Enum;

/* ===========================================  CTIMER STMINTSET CAPTUREA [9..9]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTSET_CAPTUREA                                                 */
  CTIMER_STMINTSET_CAPTUREA_CAPA_INT   = 1,     /*!< CAPA_INT : CAPTURE A interrupt status bit was set.                        */
} CTIMER_STMINTSET_CAPTUREA_Enum;

/* ===========================================  CTIMER STMINTSET OVERFLOW [8..8]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTSET_OVERFLOW                                                 */
  CTIMER_STMINTSET_OVERFLOW_OFLOW_INT  = 1,     /*!< OFLOW_INT : Overflow interrupt status bit was set.                        */
} CTIMER_STMINTSET_OVERFLOW_Enum;

/* ===========================================  CTIMER STMINTSET COMPAREH [7..7]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTSET_COMPAREH                                                 */
  CTIMER_STMINTSET_COMPAREH_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSET_COMPAREH_Enum;

/* ===========================================  CTIMER STMINTSET COMPAREG [6..6]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTSET_COMPAREG                                                 */
  CTIMER_STMINTSET_COMPAREG_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSET_COMPAREG_Enum;

/* ===========================================  CTIMER STMINTSET COMPAREF [5..5]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTSET_COMPAREF                                                 */
  CTIMER_STMINTSET_COMPAREF_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSET_COMPAREF_Enum;

/* ===========================================  CTIMER STMINTSET COMPAREE [4..4]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTSET_COMPAREE                                                 */
  CTIMER_STMINTSET_COMPAREE_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSET_COMPAREE_Enum;

/* ===========================================  CTIMER STMINTSET COMPARED [3..3]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTSET_COMPARED                                                 */
  CTIMER_STMINTSET_COMPARED_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSET_COMPARED_Enum;

/* ===========================================  CTIMER STMINTSET COMPAREC [2..2]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTSET_COMPAREC                                                 */
  CTIMER_STMINTSET_COMPAREC_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSET_COMPAREC_Enum;

/* ===========================================  CTIMER STMINTSET COMPAREB [1..1]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTSET_COMPAREB                                                 */
  CTIMER_STMINTSET_COMPAREB_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSET_COMPAREB_Enum;

/* ===========================================  CTIMER STMINTSET COMPAREA [0..0]  ============================================ */
typedef enum {                                  /*!< CTIMER_STMINTSET_COMPAREA                                                 */
  CTIMER_STMINTSET_COMPAREA_COMPARED   = 1,     /*!< COMPARED : COUNTER greater than or equal to COMPARE register.             */
} CTIMER_STMINTSET_COMPAREA_Enum;



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  PADREGA  ======================================================== */
/* ===========================================  GPIO PADREGA PAD3FNCSEL [27..29]  ============================================ */
typedef enum {                                  /*!< GPIO_PADREGA_PAD3FNCSEL                                                   */
  GPIO_PADREGA_PAD3FNCSEL_UA0RTS       = 0,     /*!< UA0RTS : Configure as the UART0 RTS output                                */
  GPIO_PADREGA_PAD3FNCSEL_SLnCE        = 1,     /*!< SLnCE : Configure as the IOSLAVE SPI nCE signal                           */
  GPIO_PADREGA_PAD3FNCSEL_M1nCE4       = 2,     /*!< M1nCE4 : Configure as the SPI channel 4 nCE signal from IOMSTR1           */
  GPIO_PADREGA_PAD3FNCSEL_GPIO3        = 3,     /*!< GPIO3 : Configure as GPIO3                                                */
  GPIO_PADREGA_PAD3FNCSEL_MxnCELB      = 4,     /*!< MxnCELB : Configure as the IOSLAVE SPI nCE loopback signal from
                                                     IOMSTRx                                                                   */
  GPIO_PADREGA_PAD3FNCSEL_M2nCE0       = 5,     /*!< M2nCE0 : Configure as the SPI channel 0 nCE signal from IOMSTR2           */
  GPIO_PADREGA_PAD3FNCSEL_TRIG1        = 6,     /*!< TRIG1 : Configure as the ADC Trigger 1 signal                             */
  GPIO_PADREGA_PAD3FNCSEL_I2S_WCLK     = 7,     /*!< I2S_WCLK : Configure as the I2S Word Clock input                          */
} GPIO_PADREGA_PAD3FNCSEL_Enum;

/* ============================================  GPIO PADREGA PAD3STRNG [26..26]  ============================================ */
typedef enum {                                  /*!< GPIO_PADREGA_PAD3STRNG                                                    */
  GPIO_PADREGA_PAD3STRNG_LOW           = 0,     /*!< LOW : Low drive strength                                                  */
  GPIO_PADREGA_PAD3STRNG_HIGH          = 1,     /*!< HIGH : High drive strength                                                */
} GPIO_PADREGA_PAD3STRNG_Enum;

/* ============================================  GPIO PADREGA PAD3INPEN [25..25]  ============================================ */
typedef enum {                                  /*!< GPIO_PADREGA_PAD3INPEN                                                    */
  GPIO_PADREGA_PAD3INPEN_DIS           = 0,     /*!< DIS : Pad input disabled                                                  */
  GPIO_PADREGA_PAD3INPEN_EN            = 1,     /*!< EN : Pad input enabled                                                    */
} GPIO_PADREGA_PAD3INPEN_Enum;

/* ============================================  GPIO PADREGA PAD3PULL [24..24]  ============================================= */
typedef enum {                                  /*!< GPIO_PADREGA_PAD3PULL                                                     */
  GPIO_PADREGA_PAD3PULL_DIS            = 0,     /*!< DIS : Pullup disabled                                                     */
  GPIO_PADREGA_PAD3PULL_EN             = 1,     /*!< EN : Pullup enabled                                                       */
} GPIO_PADREGA_PAD3PULL_Enum;

/* ===========================================  GPIO PADREGA PAD2FNCSEL [19..21]  ============================================ */
typedef enum {                                  /*!< GPIO_PADREGA_PAD2FNCSEL                                                   */
  GPIO_PADREGA_PAD2FNCSEL_SLWIR3       = 0,     /*!< SLWIR3 : Configure as the IOSLAVE SPI 3-wire MOSI/MISO signal             */
  GPIO_PADREGA_PAD2FNCSEL_SLMOSI       = 1,     /*!< SLMOSI : Configure as the IOSLAVE SPI MOSI signal                         */
  GPIO_PADREGA_PAD2FNCSEL_UART0RX      = 2,     /*!< UART0RX : Configure as the UART0 RX input                                 */
  GPIO_PADREGA_PAD2FNCSEL_GPIO2        = 3,     /*!< GPIO2 : Configure as GPIO2                                                */
  GPIO_PADREGA_PAD2FNCSEL_MxMOSILB     = 4,     /*!< MxMOSILB : Configure as the IOSLAVE SPI MOSI loopback signal
                                                     from IOMSTRx                                                              */
  GPIO_PADREGA_PAD2FNCSEL_M2MOSI       = 5,     /*!< M2MOSI : Configure as the IOMSTR2 SPI MOSI output signal                  */
  GPIO_PADREGA_PAD2FNCSEL_MxWIR3LB     = 6,     /*!< MxWIR3LB : Configure as the IOSLAVE SPI 3-wire MOSI/MISO loopback
                                                     signal from IOMSTRx                                                       */
  GPIO_PADREGA_PAD2FNCSEL_M2WIR3       = 7,     /*!< M2WIR3 : Configure as the IOMSTR2 SPI 3-wire MOSI/MISO signal             */
} GPIO_PADREGA_PAD2FNCSEL_Enum;

/* ============================================  GPIO PADREGA PAD2STRNG [18..18]  ============================================ */
typedef enum {                                  /*!< GPIO_PADREGA_PAD2STRNG                                                    */
  GPIO_PADREGA_PAD2STRNG_LOW           = 0,     /*!< LOW : Low drive strength                                                  */
  GPIO_PADREGA_PAD2STRNG_HIGH          = 1,     /*!< HIGH : High drive strength                                                */
} GPIO_PADREGA_PAD2STRNG_Enum;

/* ============================================  GPIO PADREGA PAD2INPEN [17..17]  ============================================ */
typedef enum {                                  /*!< GPIO_PADREGA_PAD2INPEN                                                    */
  GPIO_PADREGA_PAD2INPEN_DIS           = 0,     /*!< DIS : Pad input disabled                                                  */
  GPIO_PADREGA_PAD2INPEN_EN            = 1,     /*!< EN : Pad input enabled                                                    */
} GPIO_PADREGA_PAD2INPEN_Enum;

/* ============================================  GPIO PADREGA PAD2PULL [16..16]  ============================================= */
typedef enum {                                  /*!< GPIO_PADREGA_PAD2PULL                                                     */
  GPIO_PADREGA_PAD2PULL_DIS            = 0,     /*!< DIS : Pullup disabled                                                     */
  GPIO_PADREGA_PAD2PULL_EN             = 1,     /*!< EN : Pullup enabled                                                       */
} GPIO_PADREGA_PAD2PULL_Enum;

/* ============================================  GPIO PADREGA PAD1RSEL [14..15]  ============================================= */
typedef enum {                                  /*!< GPIO_PADREGA_PAD1RSEL                                                     */
  GPIO_PADREGA_PAD1RSEL_PULL1_5K       = 0,     /*!< PULL1_5K : Pullup is ~1.5 KOhms                                           */
  GPIO_PADREGA_PAD1RSEL_PULL6K         = 1,     /*!< PULL6K : Pullup is ~6 KOhms                                               */
  GPIO_PADREGA_PAD1RSEL_PULL12K        = 2,     /*!< PULL12K : Pullup is ~12 KOhms                                             */
  GPIO_PADREGA_PAD1RSEL_PULL24K        = 3,     /*!< PULL24K : Pullup is ~24 KOhms                                             */
} GPIO_PADREGA_PAD1RSEL_Enum;

/* ===========================================  GPIO PADREGA PAD1FNCSEL [11..13]  ============================================ */
typedef enum {                                  /*!< GPIO_PADREGA_PAD1FNCSEL                                                   */
  GPIO_PADREGA_PAD1FNCSEL_SLSDA        = 0,     /*!< SLSDA : Configure as the IOSLAVE I2C SDA signal                           */
  GPIO_PADREGA_PAD1FNCSEL_SLMISO       = 1,     /*!< SLMISO : Configure as the IOSLAVE SPI MISO signal                         */
  GPIO_PADREGA_PAD1FNCSEL_UART0TX      = 2,     /*!< UART0TX : Configure as the UART0 TX output signal                         */
  GPIO_PADREGA_PAD1FNCSEL_GPIO1        = 3,     /*!< GPIO1 : Configure as GPIO1                                                */
  GPIO_PADREGA_PAD1FNCSEL_MxMISOLB     = 4,     /*!< MxMISOLB : Configure as the IOSLAVE SPI MISO loopback signal
                                                     from IOMSTRx                                                              */
  GPIO_PADREGA_PAD1FNCSEL_M2MISO       = 5,     /*!< M2MISO : Configure as the IOMSTR2 SPI MISO input signal                   */
  GPIO_PADREGA_PAD1FNCSEL_MxSDALB      = 6,     /*!< MxSDALB : Configure as the IOSLAVE I2C SDA loopback signal from
                                                     IOMSTRx                                                                   */
  GPIO_PADREGA_PAD1FNCSEL_M2SDA        = 7,     /*!< M2SDA : Configure as the IOMSTR2 I2C Serial data I/O signal               */
} GPIO_PADREGA_PAD1FNCSEL_Enum;

/* ============================================  GPIO PADREGA PAD1STRNG [10..10]  ============================================ */
typedef enum {                                  /*!< GPIO_PADREGA_PAD1STRNG                                                    */
  GPIO_PADREGA_PAD1STRNG_LOW           = 0,     /*!< LOW : Low drive strength                                                  */
  GPIO_PADREGA_PAD1STRNG_HIGH          = 1,     /*!< HIGH : High drive strength                                                */
} GPIO_PADREGA_PAD1STRNG_Enum;

/* =============================================  GPIO PADREGA PAD1INPEN [9..9]  ============================================= */
typedef enum {                                  /*!< GPIO_PADREGA_PAD1INPEN                                                    */
  GPIO_PADREGA_PAD1INPEN_DIS           = 0,     /*!< DIS : Pad input disabled                  