/* automatically generated by rust-bindgen 0.58.1 */

pub type __int64_t = ::std::os::raw::c_long;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __off_t = ::std::os::raw::c_long;
pub type mode_t = __mode_t;
pub type off_t = __off_t;
pub type va_list = __builtin_va_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct archive {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct archive_entry {
    _unused: [u8; 0],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __alpm_list_t {
    pub data: *mut ::std::os::raw::c_void,
    pub prev: *mut __alpm_list_t,
    pub next: *mut __alpm_list_t,
}
#[test]
fn bindgen_test_layout___alpm_list_t() {
    assert_eq!(
        ::std::mem::size_of::<__alpm_list_t>(),
        24usize,
        concat!("Size of: ", stringify!(__alpm_list_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__alpm_list_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__alpm_list_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__alpm_list_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__alpm_list_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__alpm_list_t>())).prev as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__alpm_list_t),
            "::",
            stringify!(prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__alpm_list_t>())).next as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__alpm_list_t),
            "::",
            stringify!(next)
        )
    );
}
pub type alpm_list_t = __alpm_list_t;
pub type alpm_list_fn_free =
    ::std::option::Option<unsafe extern "C" fn(item: *mut ::std::os::raw::c_void)>;
pub type alpm_list_fn_cmp = ::std::option::Option<
    unsafe extern "C" fn(
        arg1: *const ::std::os::raw::c_void,
        arg2: *const ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    pub fn alpm_list_free(list: *mut alpm_list_t);
}
extern "C" {
    pub fn alpm_list_free_inner(list: *mut alpm_list_t, fn_: alpm_list_fn_free);
}
extern "C" {
    pub fn alpm_list_add(
        list: *mut alpm_list_t,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_append(
        list: *mut *mut alpm_list_t,
        data: *mut ::std::os::raw::c_void,
    ) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_append_strdup(
        list: *mut *mut alpm_list_t,
        data: *const ::std::os::raw::c_char,
    ) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_add_sorted(
        list: *mut alpm_list_t,
        data: *mut ::std::os::raw::c_void,
        fn_: alpm_list_fn_cmp,
    ) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_join(first: *mut alpm_list_t, second: *mut alpm_list_t) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_mmerge(
        left: *mut alpm_list_t,
        right: *mut alpm_list_t,
        fn_: alpm_list_fn_cmp,
    ) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_msort(
        list: *mut alpm_list_t,
        n: usize,
        fn_: alpm_list_fn_cmp,
    ) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_remove_item(
        haystack: *mut alpm_list_t,
        item: *mut alpm_list_t,
    ) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_remove(
        haystack: *mut alpm_list_t,
        needle: *const ::std::os::raw::c_void,
        fn_: alpm_list_fn_cmp,
        data: *mut *mut ::std::os::raw::c_void,
    ) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_remove_str(
        haystack: *mut alpm_list_t,
        needle: *const ::std::os::raw::c_char,
        data: *mut *mut ::std::os::raw::c_char,
    ) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_remove_dupes(list: *const alpm_list_t) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_strdup(list: *const alpm_list_t) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_copy(list: *const alpm_list_t) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_copy_data(list: *const alpm_list_t, size: usize) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_reverse(list: *mut alpm_list_t) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_nth(list: *const alpm_list_t, n: usize) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_next(list: *const alpm_list_t) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_previous(list: *const alpm_list_t) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_last(list: *const alpm_list_t) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_count(list: *const alpm_list_t) -> usize;
}
extern "C" {
    pub fn alpm_list_find(
        haystack: *const alpm_list_t,
        needle: *const ::std::os::raw::c_void,
        fn_: alpm_list_fn_cmp,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn alpm_list_find_ptr(
        haystack: *const alpm_list_t,
        needle: *const ::std::os::raw::c_void,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    pub fn alpm_list_find_str(
        haystack: *const alpm_list_t,
        needle: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn alpm_list_diff_sorted(
        left: *const alpm_list_t,
        right: *const alpm_list_t,
        fn_: alpm_list_fn_cmp,
        onlyleft: *mut *mut alpm_list_t,
        onlyright: *mut *mut alpm_list_t,
    );
}
extern "C" {
    pub fn alpm_list_diff(
        lhs: *const alpm_list_t,
        rhs: *const alpm_list_t,
        fn_: alpm_list_fn_cmp,
    ) -> *mut alpm_list_t;
}
extern "C" {
    pub fn alpm_list_to_array(
        list: *const alpm_list_t,
        n: usize,
        size: usize,
    ) -> *mut ::std::os::raw::c_void;
}
#[doc = " The libalpm context handle."]
#[doc = ""]
#[doc = " This struct represents an instance of libalpm."]
#[doc = " @ingroup libalpm_handle"]
pub type alpm_handle_t = u8;
#[doc = " A database."]
#[doc = ""]
#[doc = " A database is a container that stores metadata about packages."]
#[doc = ""]
#[doc = " A database can be located on the local filesystem or on a remote server."]
#[doc = ""]
#[doc = " To use a database, it must first be registered via \\link alpm_register_syncdb \\endlink."]
#[doc = " If the database is already present in dbpath then it will be usable. Otherwise,"]
#[doc = " the database needs to be downloaded using \\link alpm_db_update \\endlink. Even if the"]
#[doc = " source of the database is the local filesystem."]
#[doc = ""]
#[doc = " After this, the database can be used to query packages and groups. Any packages or groups"]
#[doc = " from the database will continue to be owned by the database and do not need to be freed by"]
#[doc = " the user. They will be freed when the database is unregistered."]
#[doc = ""]
#[doc = " Databases are automatically unregistered when the \\link alpm_handle_t \\endlink is released."]
#[doc = " @ingroup libalpm_databases"]
pub type alpm_db_t = u8;
#[doc = " A package."]
#[doc = ""]
#[doc = " A package can be loaded from disk via \\link alpm_pkg_load \\endlink or retrieved from a database."]
#[doc = " Packages from databases are automatically freed when the database is unregistered. Packages loaded"]
#[doc = " from a file must be freed manually."]
#[doc = ""]
#[doc = " Packages can then be queried for metadata or added to a \\link alpm_trans_t transaction \\endlink"]
#[doc = " to be added or removed from the system."]
#[doc = " @ingroup libalpm_packages"]
pub type alpm_pkg_t = u8;
#[doc = " Transaction structure used internally by libalpm"]
#[doc = " @ingroup libalpm_trans"]
pub type alpm_trans_t = u8;
#[doc = " The time type used by libalpm. Represents a unix time stamp"]
#[doc = " @ingroup libalpm_misc"]
pub type alpm_time_t = i64;
#[doc = " File in a package"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_file_t {
    #[doc = " Name of the file"]
    pub name: *mut ::std::os::raw::c_char,
    #[doc = " Size of the file"]
    pub size: off_t,
    #[doc = " The file's permissions"]
    pub mode: mode_t,
}
#[test]
fn bindgen_test_layout__alpm_file_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_file_t>(),
        24usize,
        concat!("Size of: ", stringify!(_alpm_file_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_file_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_file_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_file_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_file_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_file_t>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_file_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_file_t>())).mode as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_file_t),
            "::",
            stringify!(mode)
        )
    );
}
#[doc = " File in a package"]
pub type alpm_file_t = _alpm_file_t;
#[doc = " Package filelist container"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_filelist_t {
    #[doc = " Amount of files in the array"]
    pub count: usize,
    #[doc = " An array of files"]
    pub files: *mut alpm_file_t,
}
#[test]
fn bindgen_test_layout__alpm_filelist_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_filelist_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_filelist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_filelist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_filelist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_filelist_t>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_filelist_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_filelist_t>())).files as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_filelist_t),
            "::",
            stringify!(files)
        )
    );
}
#[doc = " Package filelist container"]
pub type alpm_filelist_t = _alpm_filelist_t;
#[doc = " Local package or package file backup entry"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_backup_t {
    #[doc = " Name of the file (without .pacsave extension)"]
    pub name: *mut ::std::os::raw::c_char,
    #[doc = " Hash of the filename (used internally)"]
    pub hash: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__alpm_backup_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_backup_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_backup_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_backup_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_backup_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_backup_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_backup_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_backup_t>())).hash as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_backup_t),
            "::",
            stringify!(hash)
        )
    );
}
#[doc = " Local package or package file backup entry"]
pub type alpm_backup_t = _alpm_backup_t;
extern "C" {
    #[doc = " Determines whether a package filelist contains a given path."]
    #[doc = " The provided path should be relative to the install root with no leading"]
    #[doc = " slashes, e.g. \"etc/localtime\". When searching for directories, the path must"]
    #[doc = " have a trailing slash."]
    #[doc = " @param filelist a pointer to a package filelist"]
    #[doc = " @param path the path to search for in the package"]
    #[doc = " @return a pointer to the matching file or NULL if not found"]
    pub fn alpm_filelist_contains(
        filelist: *mut alpm_filelist_t,
        path: *const ::std::os::raw::c_char,
    ) -> *mut alpm_file_t;
}
#[doc = " Package group"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_group_t {
    #[doc = " group name"]
    pub name: *mut ::std::os::raw::c_char,
    #[doc = " list of alpm_pkg_t packages"]
    pub packages: *mut alpm_list_t,
}
#[test]
fn bindgen_test_layout__alpm_group_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_group_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_group_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_group_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_group_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_group_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_group_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_group_t>())).packages as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_group_t),
            "::",
            stringify!(packages)
        )
    );
}
#[doc = " Package group"]
pub type alpm_group_t = _alpm_group_t;
extern "C" {
    #[doc = " Find group members across a list of databases."]
    #[doc = " If a member exists in several databases, only the first database is used."]
    #[doc = " IgnorePkg is also handled."]
    #[doc = " @param dbs the list of alpm_db_t *"]
    #[doc = " @param name the name of the group"]
    #[doc = " @return the list of alpm_pkg_t * (caller is responsible for alpm_list_free)"]
    pub fn alpm_find_group_pkgs(
        dbs: *mut alpm_list_t,
        name: *const ::std::os::raw::c_char,
    ) -> *mut alpm_list_t;
}
#[repr(u32)]
#[doc = " libalpm's error type"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_errno_t {
    #[doc = " No error"]
    ALPM_ERR_OK = 0,
    #[doc = " Failed to allocate memory"]
    ALPM_ERR_MEMORY = 1,
    #[doc = " A system error occurred"]
    ALPM_ERR_SYSTEM = 2,
    #[doc = " Permmision denied"]
    ALPM_ERR_BADPERMS = 3,
    #[doc = " Should be a file"]
    ALPM_ERR_NOT_A_FILE = 4,
    #[doc = " Should be a directory"]
    ALPM_ERR_NOT_A_DIR = 5,
    #[doc = " Function was called with invalid arguments"]
    ALPM_ERR_WRONG_ARGS = 6,
    #[doc = " Insufficient disk space"]
    ALPM_ERR_DISK_SPACE = 7,
    #[doc = " Handle should be null"]
    ALPM_ERR_HANDLE_NULL = 8,
    #[doc = " Handle should not be null"]
    ALPM_ERR_HANDLE_NOT_NULL = 9,
    #[doc = " Failed to acquire lock"]
    ALPM_ERR_HANDLE_LOCK = 10,
    #[doc = " Failed to open database"]
    ALPM_ERR_DB_OPEN = 11,
    #[doc = " Failed to create database"]
    ALPM_ERR_DB_CREATE = 12,
    #[doc = " Database should not be null"]
    ALPM_ERR_DB_NULL = 13,
    #[doc = " Database should be null"]
    ALPM_ERR_DB_NOT_NULL = 14,
    #[doc = " The database could not be found"]
    ALPM_ERR_DB_NOT_FOUND = 15,
    #[doc = " Database is invalid"]
    ALPM_ERR_DB_INVALID = 16,
    #[doc = " Database has an invalid signature"]
    ALPM_ERR_DB_INVALID_SIG = 17,
    #[doc = " The localdb is in a newer/older format than libalpm expects"]
    ALPM_ERR_DB_VERSION = 18,
    #[doc = " Failed to write to the database"]
    ALPM_ERR_DB_WRITE = 19,
    #[doc = " Failed to remove entry from database"]
    ALPM_ERR_DB_REMOVE = 20,
    #[doc = " Server URL is in an invalid format"]
    ALPM_ERR_SERVER_BAD_URL = 21,
    #[doc = " The database has no configured servers"]
    ALPM_ERR_SERVER_NONE = 22,
    #[doc = " A transaction is already initialized"]
    ALPM_ERR_TRANS_NOT_NULL = 23,
    #[doc = " A transaction has not been initialized"]
    ALPM_ERR_TRANS_NULL = 24,
    #[doc = " Duplicate target in transaction"]
    ALPM_ERR_TRANS_DUP_TARGET = 25,
    #[doc = " Duplicate filename in transaction"]
    ALPM_ERR_TRANS_DUP_FILENAME = 26,
    #[doc = " A transaction has not been initialized"]
    ALPM_ERR_TRANS_NOT_INITIALIZED = 27,
    #[doc = " Transaction has not been prepared"]
    ALPM_ERR_TRANS_NOT_PREPARED = 28,
    #[doc = " Transaction was aborted"]
    ALPM_ERR_TRANS_ABORT = 29,
    #[doc = " Failed to interrupt transaction"]
    ALPM_ERR_TRANS_TYPE = 30,
    #[doc = " Tried to commit transaction without locking the database"]
    ALPM_ERR_TRANS_NOT_LOCKED = 31,
    #[doc = " A hook failed to run"]
    ALPM_ERR_TRANS_HOOK_FAILED = 32,
    #[doc = " Package not found"]
    ALPM_ERR_PKG_NOT_FOUND = 33,
    #[doc = " Package is in ignorepkg"]
    ALPM_ERR_PKG_IGNORED = 34,
    #[doc = " Package is invalid"]
    ALPM_ERR_PKG_INVALID = 35,
    #[doc = " Package has an invalid checksum"]
    ALPM_ERR_PKG_INVALID_CHECKSUM = 36,
    #[doc = " Package has an invalid signature"]
    ALPM_ERR_PKG_INVALID_SIG = 37,
    #[doc = " Package does not have a signature"]
    ALPM_ERR_PKG_MISSING_SIG = 38,
    #[doc = " Cannot open the package file"]
    ALPM_ERR_PKG_OPEN = 39,
    #[doc = " Failed to remove package files"]
    ALPM_ERR_PKG_CANT_REMOVE = 40,
    #[doc = " Package has an invalid name"]
    ALPM_ERR_PKG_INVALID_NAME = 41,
    #[doc = " Package has an invalid architecture"]
    ALPM_ERR_PKG_INVALID_ARCH = 42,
    #[doc = " Unused"]
    ALPM_ERR_PKG_REPO_NOT_FOUND = 43,
    #[doc = " Signatures are missing"]
    ALPM_ERR_SIG_MISSING = 44,
    #[doc = " Signatures are invalid"]
    ALPM_ERR_SIG_INVALID = 45,
    #[doc = " Dependencies could not be satisfied"]
    ALPM_ERR_UNSATISFIED_DEPS = 46,
    #[doc = " Conflicting dependencies"]
    ALPM_ERR_CONFLICTING_DEPS = 47,
    #[doc = " Files conflict"]
    ALPM_ERR_FILE_CONFLICTS = 48,
    #[doc = " Download failed"]
    ALPM_ERR_RETRIEVE = 49,
    #[doc = " Invalid Regex"]
    ALPM_ERR_INVALID_REGEX = 50,
    #[doc = " Error in libarchive"]
    ALPM_ERR_LIBARCHIVE = 51,
    #[doc = " Error in libcurl"]
    ALPM_ERR_LIBCURL = 52,
    #[doc = " Error in external download program"]
    ALPM_ERR_EXTERNAL_DOWNLOAD = 53,
    #[doc = " Error in gpgme"]
    ALPM_ERR_GPGME = 54,
    #[doc = " Missing compile-time features"]
    ALPM_ERR_MISSING_CAPABILITY_SIGNATURES = 55,
}
#[doc = " libalpm's error type"]
pub use self::_alpm_errno_t as alpm_errno_t;
extern "C" {
    #[doc = " Returns the current error code from the handle."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the current error code of the handle"]
    pub fn alpm_errno(handle: *mut alpm_handle_t) -> alpm_errno_t;
}
extern "C" {
    #[doc = " Returns the string corresponding to an error number."]
    #[doc = " @param err the error code to get the string for"]
    #[doc = " @return the string relating to the given error code"]
    pub fn alpm_strerror(err: alpm_errno_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Initializes the library."]
    #[doc = " Creates handle, connects to database and creates lockfile."]
    #[doc = " This must be called before any other functions are called."]
    #[doc = " @param root the root path for all filesystem operations"]
    #[doc = " @param dbpath the absolute path to the libalpm database"]
    #[doc = " @param err an optional variable to hold any error return codes"]
    #[doc = " @return a context handle on success, NULL on error, err will be set if provided"]
    pub fn alpm_initialize(
        root: *const ::std::os::raw::c_char,
        dbpath: *const ::std::os::raw::c_char,
        err: *mut alpm_errno_t,
    ) -> *mut alpm_handle_t;
}
extern "C" {
    #[doc = " Release the library."]
    #[doc = " Disconnects from the database, removes handle and lockfile"]
    #[doc = " This should be the last alpm call you make."]
    #[doc = " After this returns, handle should be considered invalid and cannot be reused"]
    #[doc = " in any way."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return 0 on success, -1 on error"]
    pub fn alpm_release(handle: *mut alpm_handle_t) -> ::std::os::raw::c_int;
}
pub mod _alpm_siglevel_t {
    #[doc = " PGP signature verification options"]
    pub type Type = ::std::os::raw::c_uint;
    #[doc = " Packages require a signature"]
    pub const ALPM_SIG_PACKAGE: Type = 1;
    #[doc = " Packages do not require a signature,"]
    #[doc = " but check packages that do have signatures"]
    pub const ALPM_SIG_PACKAGE_OPTIONAL: Type = 2;
    #[doc = " Packages do not require a signature,"]
    #[doc = " but check packages that do have signatures"]
    pub const ALPM_SIG_PACKAGE_MARGINAL_OK: Type = 4;
    #[doc = " Allow packages with signatures that are unknown trust"]
    pub const ALPM_SIG_PACKAGE_UNKNOWN_OK: Type = 8;
    #[doc = " Databases require a signature"]
    pub const ALPM_SIG_DATABASE: Type = 1024;
    #[doc = " Databases do not require a signature,"]
    #[doc = " but check databases that do have signatures"]
    pub const ALPM_SIG_DATABASE_OPTIONAL: Type = 2048;
    #[doc = " Allow databases with signatures that are marginal trust"]
    pub const ALPM_SIG_DATABASE_MARGINAL_OK: Type = 4096;
    #[doc = " Allow databases with signatures that are unknown trust"]
    pub const ALPM_SIG_DATABASE_UNKNOWN_OK: Type = 8192;
    #[doc = " The Default siglevel"]
    pub const ALPM_SIG_USE_DEFAULT: Type = 1073741824;
}
#[doc = " PGP signature verification options"]
pub use self::_alpm_siglevel_t::Type as alpm_siglevel_t;
#[repr(u32)]
#[doc = " PGP signature verification status return codes"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_sigstatus_t {
    #[doc = " Signature is valid"]
    ALPM_SIGSTATUS_VALID = 0,
    #[doc = " The key has expired"]
    ALPM_SIGSTATUS_KEY_EXPIRED = 1,
    #[doc = " The signature has expired"]
    ALPM_SIGSTATUS_SIG_EXPIRED = 2,
    #[doc = " The key is not in the keyring"]
    ALPM_SIGSTATUS_KEY_UNKNOWN = 3,
    #[doc = " The key has been disabled"]
    ALPM_SIGSTATUS_KEY_DISABLED = 4,
    #[doc = " The signature is invalid"]
    ALPM_SIGSTATUS_INVALID = 5,
}
#[doc = " PGP signature verification status return codes"]
pub use self::_alpm_sigstatus_t as alpm_sigstatus_t;
#[repr(u32)]
#[doc = " The trust level of a PGP key"]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_sigvalidity_t {
    #[doc = " The signature is fully trusted"]
    ALPM_SIGVALIDITY_FULL = 0,
    #[doc = " The signature is marginally trusted"]
    ALPM_SIGVALIDITY_MARGINAL = 1,
    #[doc = " The signature is never trusted"]
    ALPM_SIGVALIDITY_NEVER = 2,
    #[doc = " The signature has unknown trust"]
    ALPM_SIGVALIDITY_UNKNOWN = 3,
}
#[doc = " The trust level of a PGP key"]
pub use self::_alpm_sigvalidity_t as alpm_sigvalidity_t;
#[doc = " A PGP key"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_pgpkey_t {
    #[doc = " The actual key data"]
    pub data: *mut ::std::os::raw::c_void,
    #[doc = " The key's fingerprint"]
    pub fingerprint: *mut ::std::os::raw::c_char,
    #[doc = " UID of the key"]
    pub uid: *mut ::std::os::raw::c_char,
    #[doc = " Name of the key's owner"]
    pub name: *mut ::std::os::raw::c_char,
    #[doc = " Email of the key's owner"]
    pub email: *mut ::std::os::raw::c_char,
    #[doc = " When the key was created"]
    pub created: alpm_time_t,
    #[doc = " When the key expires"]
    pub expires: alpm_time_t,
    #[doc = " The length of the key"]
    pub length: ::std::os::raw::c_uint,
    #[doc = " has the key been revoked"]
    pub revoked: ::std::os::raw::c_uint,
    #[doc = " A character representing the  encryption algorithm used by the public key"]
    #[doc = ""]
    #[doc = " ? = unknown"]
    #[doc = " R = RSA"]
    #[doc = " D = DSA"]
    #[doc = " E = EDDSA"]
    pub pubkey_algo: ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__alpm_pgpkey_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_pgpkey_t>(),
        72usize,
        concat!("Size of: ", stringify!(_alpm_pgpkey_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_pgpkey_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_pgpkey_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_pgpkey_t>())).data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_pgpkey_t),
            "::",
            stringify!(data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_pgpkey_t>())).fingerprint as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_pgpkey_t),
            "::",
            stringify!(fingerprint)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_pgpkey_t>())).uid as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_pgpkey_t),
            "::",
            stringify!(uid)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_pgpkey_t>())).name as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_pgpkey_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_pgpkey_t>())).email as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_pgpkey_t),
            "::",
            stringify!(email)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_pgpkey_t>())).created as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_pgpkey_t),
            "::",
            stringify!(created)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_pgpkey_t>())).expires as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_pgpkey_t),
            "::",
            stringify!(expires)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_pgpkey_t>())).length as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_pgpkey_t),
            "::",
            stringify!(length)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_pgpkey_t>())).revoked as *const _ as usize },
        60usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_pgpkey_t),
            "::",
            stringify!(revoked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_pgpkey_t>())).pubkey_algo as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_pgpkey_t),
            "::",
            stringify!(pubkey_algo)
        )
    );
}
#[doc = " A PGP key"]
pub type alpm_pgpkey_t = _alpm_pgpkey_t;
#[doc = " Signature result. Contains the key, status, and validity of a given"]
#[doc = " signature."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_sigresult_t {
    #[doc = " The key of the signature"]
    pub key: alpm_pgpkey_t,
    #[doc = " The status of the signature"]
    pub status: alpm_sigstatus_t,
    #[doc = " The validity of the signature"]
    pub validity: alpm_sigvalidity_t,
}
#[test]
fn bindgen_test_layout__alpm_sigresult_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_sigresult_t>(),
        80usize,
        concat!("Size of: ", stringify!(_alpm_sigresult_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_sigresult_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_sigresult_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_sigresult_t>())).key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_sigresult_t),
            "::",
            stringify!(key)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_sigresult_t>())).status as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_sigresult_t),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_sigresult_t>())).validity as *const _ as usize },
        76usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_sigresult_t),
            "::",
            stringify!(validity)
        )
    );
}
#[doc = " Signature result. Contains the key, status, and validity of a given"]
#[doc = " signature."]
pub type alpm_sigresult_t = _alpm_sigresult_t;
#[doc = " Signature list. Contains the number of signatures found and a pointer to an"]
#[doc = " array of results. The array is of size count."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_siglist_t {
    #[doc = " The amount of results in the array"]
    pub count: usize,
    #[doc = " An array of sigresults"]
    pub results: *mut alpm_sigresult_t,
}
#[test]
fn bindgen_test_layout__alpm_siglist_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_siglist_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_siglist_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_siglist_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_siglist_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_siglist_t>())).count as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_siglist_t),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_siglist_t>())).results as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_siglist_t),
            "::",
            stringify!(results)
        )
    );
}
#[doc = " Signature list. Contains the number of signatures found and a pointer to an"]
#[doc = " array of results. The array is of size count."]
pub type alpm_siglist_t = _alpm_siglist_t;
extern "C" {
    #[doc = " Check the PGP signature for the given package file."]
    #[doc = " @param pkg the package to check"]
    #[doc = " @param siglist a pointer to storage for signature results"]
    #[doc = " @return a int value : 0 (valid), 1 (invalid), -1 (an error occurred)"]
    pub fn alpm_pkg_check_pgp_signature(
        pkg: *mut alpm_pkg_t,
        siglist: *mut alpm_siglist_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Check the PGP signature for the given database."]
    #[doc = " @param db the database to check"]
    #[doc = " @param siglist a pointer to storage for signature results"]
    #[doc = " @return a int value : 0 (valid), 1 (invalid), -1 (an error occurred)"]
    pub fn alpm_db_check_pgp_signature(
        db: *mut alpm_db_t,
        siglist: *mut alpm_siglist_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Clean up and free a signature result list."]
    #[doc = " Note that this does not free the siglist object itself in case that"]
    #[doc = " was allocated on the stack; this is the responsibility of the caller."]
    #[doc = " @param siglist a pointer to storage for signature results"]
    #[doc = " @return 0 on success, -1 on error"]
    pub fn alpm_siglist_cleanup(siglist: *mut alpm_siglist_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Decode a loaded signature in base64 form."]
    #[doc = " @param base64_data the signature to attempt to decode"]
    #[doc = " @param data the decoded data; must be freed by the caller"]
    #[doc = " @param data_len the length of the returned data"]
    #[doc = " @return 0 on success, -1 on failure to properly decode"]
    pub fn alpm_decode_signature(
        base64_data: *const ::std::os::raw::c_char,
        data: *mut *mut ::std::os::raw::c_uchar,
        data_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Extract the Issuer Key ID from a signature"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param identifier the identifier of the key."]
    #[doc = " This may be the name of the package or the path to the package."]
    #[doc = " @param sig PGP signature"]
    #[doc = " @param len length of signature"]
    #[doc = " @param keys a pointer to storage for key IDs"]
    #[doc = " @return 0 on success, -1 on error"]
    pub fn alpm_extract_keyid(
        handle: *mut alpm_handle_t,
        identifier: *const ::std::os::raw::c_char,
        sig: *const ::std::os::raw::c_uchar,
        len: usize,
        keys: *mut *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
#[repr(u32)]
#[doc = " Types of version constraints in dependency specs."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_depmod_t {
    #[doc = " No version constraint"]
    ALPM_DEP_MOD_ANY = 1,
    #[doc = " Test version equality (package=x.y.z)"]
    ALPM_DEP_MOD_EQ = 2,
    #[doc = " Test for at least a version (package>=x.y.z)"]
    ALPM_DEP_MOD_GE = 3,
    #[doc = " Test for at most a version (package<=x.y.z)"]
    ALPM_DEP_MOD_LE = 4,
    #[doc = " Test for greater than some version (package>x.y.z)"]
    ALPM_DEP_MOD_GT = 5,
    #[doc = " Test for less than some version (package<x.y.z)"]
    ALPM_DEP_MOD_LT = 6,
}
#[doc = " Types of version constraints in dependency specs."]
pub use self::_alpm_depmod_t as alpm_depmod_t;
#[repr(u32)]
#[doc = " File conflict type."]
#[doc = " Whether the conflict results from a file existing on the filesystem, or with"]
#[doc = " another target in the transaction."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_fileconflicttype_t {
    #[doc = " The conflict results with a another target in the transaction"]
    ALPM_FILECONFLICT_TARGET = 1,
    #[doc = " The conflict results from a file existing on the filesystem"]
    ALPM_FILECONFLICT_FILESYSTEM = 2,
}
#[doc = " File conflict type."]
#[doc = " Whether the conflict results from a file existing on the filesystem, or with"]
#[doc = " another target in the transaction."]
pub use self::_alpm_fileconflicttype_t as alpm_fileconflicttype_t;
#[doc = " The basic dependency type."]
#[doc = ""]
#[doc = " This type is used throughout libalpm, not just for dependencies"]
#[doc = " but also conflicts and providers."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_depend_t {
    #[doc = "  Name of the provider to satisfy this dependency"]
    pub name: *mut ::std::os::raw::c_char,
    #[doc = "  Version of the provider to match against (optional)"]
    pub version: *mut ::std::os::raw::c_char,
    #[doc = " A description of why this dependency is needed (optional)"]
    pub desc: *mut ::std::os::raw::c_char,
    #[doc = " A hash of name (used internally to speed up conflict checks)"]
    pub name_hash: ::std::os::raw::c_ulong,
    #[doc = " How the version should match against the provider"]
    pub mod_: alpm_depmod_t,
}
#[test]
fn bindgen_test_layout__alpm_depend_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_depend_t>(),
        40usize,
        concat!("Size of: ", stringify!(_alpm_depend_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_depend_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_depend_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_depend_t>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_depend_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_depend_t>())).version as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_depend_t),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_depend_t>())).desc as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_depend_t),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_depend_t>())).name_hash as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_depend_t),
            "::",
            stringify!(name_hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_depend_t>())).mod_ as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_depend_t),
            "::",
            stringify!(mod_)
        )
    );
}
#[doc = " The basic dependency type."]
#[doc = ""]
#[doc = " This type is used throughout libalpm, not just for dependencies"]
#[doc = " but also conflicts and providers."]
pub type alpm_depend_t = _alpm_depend_t;
#[doc = " Missing dependency."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_depmissing_t {
    #[doc = " Name of the package that has the dependency"]
    pub target: *mut ::std::os::raw::c_char,
    #[doc = " The dependency that was wanted"]
    pub depend: *mut alpm_depend_t,
    #[doc = " If the depmissing was caused by a conflict, the name of the package"]
    #[doc = " that would be installed, causing the satisfying package to be removed"]
    pub causingpkg: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__alpm_depmissing_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_depmissing_t>(),
        24usize,
        concat!("Size of: ", stringify!(_alpm_depmissing_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_depmissing_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_depmissing_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_depmissing_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_depmissing_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_depmissing_t>())).depend as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_depmissing_t),
            "::",
            stringify!(depend)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_depmissing_t>())).causingpkg as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_depmissing_t),
            "::",
            stringify!(causingpkg)
        )
    );
}
#[doc = " Missing dependency."]
pub type alpm_depmissing_t = _alpm_depmissing_t;
#[doc = " A conflict that has occurred between two packages."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_conflict_t {
    #[doc = " Hash of the first package name"]
    #[doc = " (used internally to speed up conflict checks)"]
    pub package1_hash: ::std::os::raw::c_ulong,
    #[doc = " Hash of the second package name"]
    #[doc = " (used internally to speed up conflict checks)"]
    pub package2_hash: ::std::os::raw::c_ulong,
    #[doc = " Name of the first package"]
    pub package1: *mut ::std::os::raw::c_char,
    #[doc = " Name of the second package"]
    pub package2: *mut ::std::os::raw::c_char,
    #[doc = " The conflict"]
    pub reason: *mut alpm_depend_t,
}
#[test]
fn bindgen_test_layout__alpm_conflict_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_conflict_t>(),
        40usize,
        concat!("Size of: ", stringify!(_alpm_conflict_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_conflict_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_conflict_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_conflict_t>())).package1_hash as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_conflict_t),
            "::",
            stringify!(package1_hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_conflict_t>())).package2_hash as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_conflict_t),
            "::",
            stringify!(package2_hash)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_conflict_t>())).package1 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_conflict_t),
            "::",
            stringify!(package1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_conflict_t>())).package2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_conflict_t),
            "::",
            stringify!(package2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_conflict_t>())).reason as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_conflict_t),
            "::",
            stringify!(reason)
        )
    );
}
#[doc = " A conflict that has occurred between two packages."]
pub type alpm_conflict_t = _alpm_conflict_t;
#[doc = " File conflict."]
#[doc = ""]
#[doc = " A conflict that has happened due to a two packages containing the same file,"]
#[doc = " or a package contains a file that is already on the filesystem and not owned"]
#[doc = " by that package."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_fileconflict_t {
    #[doc = " The name of the package that caused the conflict"]
    pub target: *mut ::std::os::raw::c_char,
    #[doc = " The type of conflict"]
    pub type_: alpm_fileconflicttype_t,
    #[doc = " The name of the file that the package conflicts with"]
    pub file: *mut ::std::os::raw::c_char,
    #[doc = " The name of the package that also owns the file if there is one"]
    pub ctarget: *mut ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__alpm_fileconflict_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_fileconflict_t>(),
        32usize,
        concat!("Size of: ", stringify!(_alpm_fileconflict_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_fileconflict_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_fileconflict_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_fileconflict_t>())).target as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_fileconflict_t),
            "::",
            stringify!(target)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_fileconflict_t>())).type_ as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_fileconflict_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_fileconflict_t>())).file as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_fileconflict_t),
            "::",
            stringify!(file)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_fileconflict_t>())).ctarget as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_fileconflict_t),
            "::",
            stringify!(ctarget)
        )
    );
}
#[doc = " File conflict."]
#[doc = ""]
#[doc = " A conflict that has happened due to a two packages containing the same file,"]
#[doc = " or a package contains a file that is already on the filesystem and not owned"]
#[doc = " by that package."]
pub type alpm_fileconflict_t = _alpm_fileconflict_t;
extern "C" {
    #[doc = " Checks dependencies and returns missing ones in a list."]
    #[doc = " Dependencies can include versions with depmod operators."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param pkglist the list of local packages"]
    #[doc = " @param remove an alpm_list_t* of packages to be removed"]
    #[doc = " @param upgrade an alpm_list_t* of packages to be upgraded (remove-then-upgrade)"]
    #[doc = " @param reversedeps handles the backward dependencies"]
    #[doc = " @return an alpm_list_t* of alpm_depmissing_t pointers."]
    pub fn alpm_checkdeps(
        handle: *mut alpm_handle_t,
        pkglist: *mut alpm_list_t,
        remove: *mut alpm_list_t,
        upgrade: *mut alpm_list_t,
        reversedeps: ::std::os::raw::c_int,
    ) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Find a package satisfying a specified dependency."]
    #[doc = " The dependency can include versions with depmod operators."]
    #[doc = " @param pkgs an alpm_list_t* of alpm_pkg_t where the satisfyer will be searched"]
    #[doc = " @param depstring package or provision name, versioned or not"]
    #[doc = " @return a alpm_pkg_t* satisfying depstring"]
    pub fn alpm_find_satisfier(
        pkgs: *mut alpm_list_t,
        depstring: *const ::std::os::raw::c_char,
    ) -> *mut alpm_pkg_t;
}
extern "C" {
    #[doc = " Find a package satisfying a specified dependency."]
    #[doc = " First look for a literal, going through each db one by one. Then look for"]
    #[doc = " providers. The first satisfyer that belongs to an installed package is"]
    #[doc = " returned. If no providers belong to an installed package then an"]
    #[doc = " alpm_question_select_provider_t is created to select the provider."]
    #[doc = " The dependency can include versions with depmod operators."]
    #[doc = ""]
    #[doc = " @param handle the context handle"]
    #[doc = " @param dbs an alpm_list_t* of alpm_db_t where the satisfyer will be searched"]
    #[doc = " @param depstring package or provision name, versioned or not"]
    #[doc = " @return a alpm_pkg_t* satisfying depstring"]
    pub fn alpm_find_dbs_satisfier(
        handle: *mut alpm_handle_t,
        dbs: *mut alpm_list_t,
        depstring: *const ::std::os::raw::c_char,
    ) -> *mut alpm_pkg_t;
}
extern "C" {
    #[doc = " Check the package conflicts in a database"]
    #[doc = ""]
    #[doc = " @param handle the context handle"]
    #[doc = " @param pkglist the list of packages to check"]
    #[doc = ""]
    #[doc = " @return an alpm_list_t of alpm_conflict_t"]
    pub fn alpm_checkconflicts(
        handle: *mut alpm_handle_t,
        pkglist: *mut alpm_list_t,
    ) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns a newly allocated string representing the dependency information."]
    #[doc = " @param dep a dependency info structure"]
    #[doc = " @return a formatted string, e.g. \"glibc>=2.12\""]
    pub fn alpm_dep_compute_string(dep: *const alpm_depend_t) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Return a newly allocated dependency information parsed from a string"]
    #[doc = "\\link alpm_dep_free should be used to free the dependency \\endlink"]
    #[doc = " @param depstring a formatted string, e.g. \"glibc=2.12\""]
    #[doc = " @return a dependency info structure"]
    pub fn alpm_dep_from_string(depstring: *const ::std::os::raw::c_char) -> *mut alpm_depend_t;
}
extern "C" {
    #[doc = " Free a dependency info structure"]
    #[doc = " @param dep struct to free"]
    pub fn alpm_dep_free(dep: *mut alpm_depend_t);
}
extern "C" {
    #[doc = " Free a fileconflict and its members."]
    #[doc = " @param conflict the fileconflict to free"]
    pub fn alpm_fileconflict_free(conflict: *mut alpm_fileconflict_t);
}
extern "C" {
    #[doc = " Free a depmissing and its members"]
    #[doc = " @param miss the depmissing to free"]
    pub fn alpm_depmissing_free(miss: *mut alpm_depmissing_t);
}
extern "C" {
    #[doc = " Free a conflict and its members."]
    #[doc = " @param conflict the conflict to free"]
    pub fn alpm_conflict_free(conflict: *mut alpm_conflict_t);
}
#[repr(u32)]
#[doc = " Type of events."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_event_type_t {
    #[doc = " Dependencies will be computed for a package."]
    ALPM_EVENT_CHECKDEPS_START = 1,
    #[doc = " Dependencies were computed for a package."]
    ALPM_EVENT_CHECKDEPS_DONE = 2,
    #[doc = " File conflicts will be computed for a package."]
    ALPM_EVENT_FILECONFLICTS_START = 3,
    #[doc = " File conflicts were computed for a package."]
    ALPM_EVENT_FILECONFLICTS_DONE = 4,
    #[doc = " Dependencies will be resolved for target package."]
    ALPM_EVENT_RESOLVEDEPS_START = 5,
    #[doc = " Dependencies were resolved for target package."]
    ALPM_EVENT_RESOLVEDEPS_DONE = 6,
    #[doc = " Inter-conflicts will be checked for target package."]
    ALPM_EVENT_INTERCONFLICTS_START = 7,
    #[doc = " Inter-conflicts were checked for target package."]
    ALPM_EVENT_INTERCONFLICTS_DONE = 8,
    #[doc = " Processing the package transaction is starting."]
    ALPM_EVENT_TRANSACTION_START = 9,
    #[doc = " Processing the package transaction is finished."]
    ALPM_EVENT_TRANSACTION_DONE = 10,
    #[doc = " Package will be installed/upgraded/downgraded/re-installed/removed; See"]
    #[doc = " alpm_event_package_operation_t for arguments."]
    ALPM_EVENT_PACKAGE_OPERATION_START = 11,
    #[doc = " Package was installed/upgraded/downgraded/re-installed/removed; See"]
    #[doc = " alpm_event_package_operation_t for arguments."]
    ALPM_EVENT_PACKAGE_OPERATION_DONE = 12,
    #[doc = " Target package's integrity will be checked."]
    ALPM_EVENT_INTEGRITY_START = 13,
    #[doc = " Target package's integrity was checked."]
    ALPM_EVENT_INTEGRITY_DONE = 14,
    #[doc = " Target package will be loaded."]
    ALPM_EVENT_LOAD_START = 15,
    #[doc = " Target package is finished loading."]
    ALPM_EVENT_LOAD_DONE = 16,
    #[doc = " Scriptlet has printed information; See alpm_event_scriptlet_info_t for"]
    #[doc = " arguments."]
    ALPM_EVENT_SCRIPTLET_INFO = 17,
    #[doc = " Database files will be downloaded from a repository."]
    ALPM_EVENT_DB_RETRIEVE_START = 18,
    #[doc = " Database files were downloaded from a repository."]
    ALPM_EVENT_DB_RETRIEVE_DONE = 19,
    #[doc = " Not all database files were successfully downloaded from a repository."]
    ALPM_EVENT_DB_RETRIEVE_FAILED = 20,
    #[doc = " Package files will be downloaded from a repository."]
    ALPM_EVENT_PKG_RETRIEVE_START = 21,
    #[doc = " Package files were downloaded from a repository."]
    ALPM_EVENT_PKG_RETRIEVE_DONE = 22,
    #[doc = " Not all package files were successfully downloaded from a repository."]
    ALPM_EVENT_PKG_RETRIEVE_FAILED = 23,
    #[doc = " Disk space usage will be computed for a package."]
    ALPM_EVENT_DISKSPACE_START = 24,
    #[doc = " Disk space usage was computed for a package."]
    ALPM_EVENT_DISKSPACE_DONE = 25,
    #[doc = " An optdepend for another package is being removed; See"]
    #[doc = " alpm_event_optdep_removal_t for arguments."]
    ALPM_EVENT_OPTDEP_REMOVAL = 26,
    #[doc = " A configured repository database is missing; See"]
    #[doc = " alpm_event_database_missing_t for arguments."]
    ALPM_EVENT_DATABASE_MISSING = 27,
    #[doc = " Checking keys used to create signatures are in keyring."]
    ALPM_EVENT_KEYRING_START = 28,
    #[doc = " Keyring checking is finished."]
    ALPM_EVENT_KEYRING_DONE = 29,
    #[doc = " Downloading missing keys into keyring."]
    ALPM_EVENT_KEY_DOWNLOAD_START = 30,
    #[doc = " Key downloading is finished."]
    ALPM_EVENT_KEY_DOWNLOAD_DONE = 31,
    #[doc = " A .pacnew file was created; See alpm_event_pacnew_created_t for arguments."]
    ALPM_EVENT_PACNEW_CREATED = 32,
    #[doc = " A .pacsave file was created; See alpm_event_pacsave_created_t for"]
    #[doc = " arguments."]
    ALPM_EVENT_PACSAVE_CREATED = 33,
    #[doc = " Processing hooks will be started."]
    ALPM_EVENT_HOOK_START = 34,
    #[doc = " Processing hooks is finished."]
    ALPM_EVENT_HOOK_DONE = 35,
    #[doc = " A hook is starting"]
    ALPM_EVENT_HOOK_RUN_START = 36,
    #[doc = " A hook has finished running."]
    ALPM_EVENT_HOOK_RUN_DONE = 37,
}
#[doc = " Type of events."]
pub use self::_alpm_event_type_t as alpm_event_type_t;
#[doc = " An event that may represent any event."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_any_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
}
#[test]
fn bindgen_test_layout__alpm_event_any_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_any_t>(),
        4usize,
        concat!("Size of: ", stringify!(_alpm_event_any_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_any_t>(),
        4usize,
        concat!("Alignment of ", stringify!(_alpm_event_any_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_any_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_any_t),
            "::",
            stringify!(type_)
        )
    );
}
#[doc = " An event that may represent any event."]
pub type alpm_event_any_t = _alpm_event_any_t;
#[repr(u32)]
#[doc = " An enum over the kind of package operations."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_package_operation_t {
    #[doc = " Package (to be) installed. (No oldpkg)"]
    ALPM_PACKAGE_INSTALL = 1,
    #[doc = " Package (to be) upgraded"]
    ALPM_PACKAGE_UPGRADE = 2,
    #[doc = " Package (to be) re-installed"]
    ALPM_PACKAGE_REINSTALL = 3,
    #[doc = " Package (to be) downgraded"]
    ALPM_PACKAGE_DOWNGRADE = 4,
    #[doc = " Package (to be) removed (No newpkg)"]
    ALPM_PACKAGE_REMOVE = 5,
}
#[doc = " An enum over the kind of package operations."]
pub use self::_alpm_package_operation_t as alpm_package_operation_t;
#[doc = " A package operation event occurred."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_package_operation_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
    #[doc = " Type of operation"]
    pub operation: alpm_package_operation_t,
    #[doc = " Old package"]
    pub oldpkg: *mut alpm_pkg_t,
    #[doc = " New package"]
    pub newpkg: *mut alpm_pkg_t,
}
#[test]
fn bindgen_test_layout__alpm_event_package_operation_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_package_operation_t>(),
        24usize,
        concat!("Size of: ", stringify!(_alpm_event_package_operation_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_package_operation_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_event_package_operation_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_package_operation_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_package_operation_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_package_operation_t>())).operation as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_package_operation_t),
            "::",
            stringify!(operation)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_package_operation_t>())).oldpkg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_package_operation_t),
            "::",
            stringify!(oldpkg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_package_operation_t>())).newpkg as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_package_operation_t),
            "::",
            stringify!(newpkg)
        )
    );
}
#[doc = " A package operation event occurred."]
pub type alpm_event_package_operation_t = _alpm_event_package_operation_t;
#[doc = " An optional dependency was removed."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_optdep_removal_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
    #[doc = " Package with the optdep"]
    pub pkg: *mut alpm_pkg_t,
    #[doc = " Optdep being removed"]
    pub optdep: *mut alpm_depend_t,
}
#[test]
fn bindgen_test_layout__alpm_event_optdep_removal_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_optdep_removal_t>(),
        24usize,
        concat!("Size of: ", stringify!(_alpm_event_optdep_removal_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_optdep_removal_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_event_optdep_removal_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_optdep_removal_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_optdep_removal_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_optdep_removal_t>())).pkg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_optdep_removal_t),
            "::",
            stringify!(pkg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_optdep_removal_t>())).optdep as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_optdep_removal_t),
            "::",
            stringify!(optdep)
        )
    );
}
#[doc = " An optional dependency was removed."]
pub type alpm_event_optdep_removal_t = _alpm_event_optdep_removal_t;
#[doc = " A scriptlet was ran."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_scriptlet_info_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
    #[doc = " Line of scriptlet output"]
    pub line: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__alpm_event_scriptlet_info_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_scriptlet_info_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_event_scriptlet_info_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_scriptlet_info_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_event_scriptlet_info_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_scriptlet_info_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_scriptlet_info_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_scriptlet_info_t>())).line as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_scriptlet_info_t),
            "::",
            stringify!(line)
        )
    );
}
#[doc = " A scriptlet was ran."]
pub type alpm_event_scriptlet_info_t = _alpm_event_scriptlet_info_t;
#[doc = " A database is missing."]
#[doc = ""]
#[doc = " The database is registered but has not been downloaded"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_database_missing_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
    #[doc = " Name of the database"]
    pub dbname: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__alpm_event_database_missing_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_database_missing_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_event_database_missing_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_database_missing_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_event_database_missing_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_database_missing_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_database_missing_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_database_missing_t>())).dbname as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_database_missing_t),
            "::",
            stringify!(dbname)
        )
    );
}
#[doc = " A database is missing."]
#[doc = ""]
#[doc = " The database is registered but has not been downloaded"]
pub type alpm_event_database_missing_t = _alpm_event_database_missing_t;
#[doc = " A package was downloaded."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_pkgdownload_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
    #[doc = " Name of the file"]
    pub file: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__alpm_event_pkgdownload_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_pkgdownload_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_event_pkgdownload_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_pkgdownload_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_event_pkgdownload_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_pkgdownload_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pkgdownload_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_pkgdownload_t>())).file as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pkgdownload_t),
            "::",
            stringify!(file)
        )
    );
}
#[doc = " A package was downloaded."]
pub type alpm_event_pkgdownload_t = _alpm_event_pkgdownload_t;
#[doc = " A pacnew file was created."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_pacnew_created_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
    #[doc = " Whether the creation was result of a NoUpgrade or not"]
    pub from_noupgrade: ::std::os::raw::c_int,
    #[doc = " Old package"]
    pub oldpkg: *mut alpm_pkg_t,
    #[doc = " New Package"]
    pub newpkg: *mut alpm_pkg_t,
    #[doc = " Filename of the file without the .pacnew suffix"]
    pub file: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__alpm_event_pacnew_created_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_pacnew_created_t>(),
        32usize,
        concat!("Size of: ", stringify!(_alpm_event_pacnew_created_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_pacnew_created_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_event_pacnew_created_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_pacnew_created_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pacnew_created_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_pacnew_created_t>())).from_noupgrade as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pacnew_created_t),
            "::",
            stringify!(from_noupgrade)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_pacnew_created_t>())).oldpkg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pacnew_created_t),
            "::",
            stringify!(oldpkg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_pacnew_created_t>())).newpkg as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pacnew_created_t),
            "::",
            stringify!(newpkg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_pacnew_created_t>())).file as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pacnew_created_t),
            "::",
            stringify!(file)
        )
    );
}
#[doc = " A pacnew file was created."]
pub type alpm_event_pacnew_created_t = _alpm_event_pacnew_created_t;
#[doc = " A pacsave file was created."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_pacsave_created_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
    #[doc = " Old package"]
    pub oldpkg: *mut alpm_pkg_t,
    #[doc = " Filename of the file without the .pacsave suffix"]
    pub file: *const ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__alpm_event_pacsave_created_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_pacsave_created_t>(),
        24usize,
        concat!("Size of: ", stringify!(_alpm_event_pacsave_created_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_pacsave_created_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_event_pacsave_created_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_pacsave_created_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pacsave_created_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_pacsave_created_t>())).oldpkg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pacsave_created_t),
            "::",
            stringify!(oldpkg)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_pacsave_created_t>())).file as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pacsave_created_t),
            "::",
            stringify!(file)
        )
    );
}
#[doc = " A pacsave file was created."]
pub type alpm_event_pacsave_created_t = _alpm_event_pacsave_created_t;
#[repr(u32)]
#[doc = " Kind of hook."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_hook_when_t {
    ALPM_HOOK_PRE_TRANSACTION = 1,
    ALPM_HOOK_POST_TRANSACTION = 2,
}
#[doc = " Kind of hook."]
pub use self::_alpm_hook_when_t as alpm_hook_when_t;
#[doc = " pre/post transaction hooks are to be ran."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_hook_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
    #[doc = " Type of hook"]
    pub when: alpm_hook_when_t,
}
#[test]
fn bindgen_test_layout__alpm_event_hook_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_hook_t>(),
        8usize,
        concat!("Size of: ", stringify!(_alpm_event_hook_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_hook_t>(),
        4usize,
        concat!("Alignment of ", stringify!(_alpm_event_hook_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_hook_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_hook_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_hook_t>())).when as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_hook_t),
            "::",
            stringify!(when)
        )
    );
}
#[doc = " pre/post transaction hooks are to be ran."]
pub type alpm_event_hook_t = _alpm_event_hook_t;
#[doc = " A pre/post transaction hook was ran."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_hook_run_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
    #[doc = " Name of hook"]
    pub name: *const ::std::os::raw::c_char,
    #[doc = " Description of hook to be outputted"]
    pub desc: *const ::std::os::raw::c_char,
    #[doc = " position of hook being run"]
    pub position: usize,
    #[doc = " total hooks being run"]
    pub total: usize,
}
#[test]
fn bindgen_test_layout__alpm_event_hook_run_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_hook_run_t>(),
        40usize,
        concat!("Size of: ", stringify!(_alpm_event_hook_run_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_hook_run_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_event_hook_run_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_hook_run_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_hook_run_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_hook_run_t>())).name as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_hook_run_t),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_hook_run_t>())).desc as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_hook_run_t),
            "::",
            stringify!(desc)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_hook_run_t>())).position as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_hook_run_t),
            "::",
            stringify!(position)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_hook_run_t>())).total as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_hook_run_t),
            "::",
            stringify!(total)
        )
    );
}
#[doc = " A pre/post transaction hook was ran."]
pub type alpm_event_hook_run_t = _alpm_event_hook_run_t;
#[doc = " Packages downloading about to start."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_event_pkg_retrieve_t {
    #[doc = " Type of event"]
    pub type_: alpm_event_type_t,
    #[doc = " Number of packages to download"]
    pub num: usize,
    #[doc = " Total size of packages to download"]
    pub total_size: off_t,
}
#[test]
fn bindgen_test_layout__alpm_event_pkg_retrieve_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_pkg_retrieve_t>(),
        24usize,
        concat!("Size of: ", stringify!(_alpm_event_pkg_retrieve_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_pkg_retrieve_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_event_pkg_retrieve_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_pkg_retrieve_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pkg_retrieve_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_pkg_retrieve_t>())).num as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pkg_retrieve_t),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_event_pkg_retrieve_t>())).total_size as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_pkg_retrieve_t),
            "::",
            stringify!(total_size)
        )
    );
}
#[doc = " Packages downloading about to start."]
pub type alpm_event_pkg_retrieve_t = _alpm_event_pkg_retrieve_t;
#[doc = " Events."]
#[doc = " This is a union passed to the callback that allows the frontend to know"]
#[doc = " which type of event was triggered (via type). It is then possible to"]
#[doc = " typecast the pointer to the right structure, or use the union field, in order"]
#[doc = " to access event-specific data."]
#[repr(C)]
#[derive(Copy, Clone)]
pub union _alpm_event_t {
    #[doc = " Type of event it's always safe to access this."]
    pub type_: alpm_event_type_t,
    #[doc = " The any event type. It's always safe to access this."]
    pub any: alpm_event_any_t,
    #[doc = " Package operation"]
    pub package_operation: alpm_event_package_operation_t,
    #[doc = " An optdept was remove"]
    pub optdep_removal: alpm_event_optdep_removal_t,
    #[doc = " A scriptlet was ran"]
    pub scriptlet_info: alpm_event_scriptlet_info_t,
    #[doc = " A database is missing"]
    pub database_missing: alpm_event_database_missing_t,
    #[doc = " A package was downloaded"]
    pub pkgdownload: alpm_event_pkgdownload_t,
    #[doc = " A pacnew file was created"]
    pub pacnew_created: alpm_event_pacnew_created_t,
    #[doc = " A pacsave file was created"]
    pub pacsave_created: alpm_event_pacsave_created_t,
    #[doc = " Pre/post transaction hooks are being ran"]
    pub hook: alpm_event_hook_t,
    #[doc = " A hook was ran"]
    pub hook_run: alpm_event_hook_run_t,
    #[doc = " Download packages"]
    pub pkg_retrieve: alpm_event_pkg_retrieve_t,
}
#[test]
fn bindgen_test_layout__alpm_event_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_event_t>(),
        40usize,
        concat!("Size of: ", stringify!(_alpm_event_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_event_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_event_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).any as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(any)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).package_operation as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(package_operation)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).optdep_removal as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(optdep_removal)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).scriptlet_info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(scriptlet_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).database_missing as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(database_missing)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).pkgdownload as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(pkgdownload)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).pacnew_created as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(pacnew_created)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).pacsave_created as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(pacsave_created)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).hook as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(hook)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).hook_run as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(hook_run)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_event_t>())).pkg_retrieve as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_event_t),
            "::",
            stringify!(pkg_retrieve)
        )
    );
}
#[doc = " Events."]
#[doc = " This is a union passed to the callback that allows the frontend to know"]
#[doc = " which type of event was triggered (via type). It is then possible to"]
#[doc = " typecast the pointer to the right structure, or use the union field, in order"]
#[doc = " to access event-specific data."]
pub type alpm_event_t = _alpm_event_t;
#[doc = " Event callback."]
#[doc = ""]
#[doc = " Called when an event occurs"]
#[doc = " @param ctx user-provided context"]
#[doc = " @param event the event that occurred"]
pub type alpm_cb_event = ::std::option::Option<
    unsafe extern "C" fn(ctx: *mut ::std::os::raw::c_void, arg1: *mut alpm_event_t),
>;
pub mod _alpm_question_type_t {
    #[doc = " Type of question."]
    #[doc = " Unlike the events or progress enumerations, this enum has bitmask values"]
    #[doc = " so a frontend can use a bitmask map to supply preselected answers to the"]
    #[doc = " different types of questions."]
    pub type Type = ::std::os::raw::c_uint;
    #[doc = " Should target in ignorepkg be installed anyway?"]
    pub const ALPM_QUESTION_INSTALL_IGNOREPKG: Type = 1;
    #[doc = " Should a package be replaced?"]
    pub const ALPM_QUESTION_REPLACE_PKG: Type = 2;
    #[doc = " Should a conflicting package be removed?"]
    pub const ALPM_QUESTION_CONFLICT_PKG: Type = 4;
    #[doc = " Should a corrupted package be deleted?"]
    pub const ALPM_QUESTION_CORRUPTED_PKG: Type = 8;
    #[doc = " Should unresolvable targets be removed from the transaction?"]
    pub const ALPM_QUESTION_REMOVE_PKGS: Type = 16;
    #[doc = " Provider selection"]
    pub const ALPM_QUESTION_SELECT_PROVIDER: Type = 32;
    #[doc = " Should a key be imported?"]
    pub const ALPM_QUESTION_IMPORT_KEY: Type = 64;
}
#[doc = " Type of question."]
#[doc = " Unlike the events or progress enumerations, this enum has bitmask values"]
#[doc = " so a frontend can use a bitmask map to supply preselected answers to the"]
#[doc = " different types of questions."]
pub use self::_alpm_question_type_t::Type as alpm_question_type_t;
#[doc = " A question that can represent any other question."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_question_any_t {
    #[doc = " Type of question"]
    pub type_: alpm_question_type_t,
    #[doc = " Answer"]
    pub answer: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__alpm_question_any_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_question_any_t>(),
        8usize,
        concat!("Size of: ", stringify!(_alpm_question_any_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_question_any_t>(),
        4usize,
        concat!("Alignment of ", stringify!(_alpm_question_any_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_any_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_any_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_any_t>())).answer as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_any_t),
            "::",
            stringify!(answer)
        )
    );
}
#[doc = " A question that can represent any other question."]
pub type alpm_question_any_t = _alpm_question_any_t;
#[doc = " Should target in ignorepkg be installed anyway?"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_question_install_ignorepkg_t {
    #[doc = " Type of question"]
    pub type_: alpm_question_type_t,
    #[doc = " Answer: whether or not to install pkg anyway"]
    pub install: ::std::os::raw::c_int,
    #[doc = " The ignored package that we are deciding whether to install"]
    pub pkg: *mut alpm_pkg_t,
}
#[test]
fn bindgen_test_layout__alpm_question_install_ignorepkg_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_question_install_ignorepkg_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_question_install_ignorepkg_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_question_install_ignorepkg_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_alpm_question_install_ignorepkg_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_install_ignorepkg_t>())).type_ as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_install_ignorepkg_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_install_ignorepkg_t>())).install as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_install_ignorepkg_t),
            "::",
            stringify!(install)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_install_ignorepkg_t>())).pkg as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_install_ignorepkg_t),
            "::",
            stringify!(pkg)
        )
    );
}
#[doc = " Should target in ignorepkg be installed anyway?"]
pub type alpm_question_install_ignorepkg_t = _alpm_question_install_ignorepkg_t;
#[doc = " Should a package be replaced?"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_question_replace_t {
    #[doc = " Type of question"]
    pub type_: alpm_question_type_t,
    #[doc = " Answer: whether or not to replace oldpkg with newpkg"]
    pub replace: ::std::os::raw::c_int,
    #[doc = " Package to be replaced"]
    pub oldpkg: *mut alpm_pkg_t,
    #[doc = " Package to replace with."]
    pub newpkg: *mut alpm_pkg_t,
    #[doc = " DB of newpkg"]
    pub newdb: *mut alpm_db_t,
}
#[test]
fn bindgen_test_layout__alpm_question_replace_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_question_replace_t>(),
        32usize,
        concat!("Size of: ", stringify!(_alpm_question_replace_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_question_replace_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_question_replace_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_replace_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_replace_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_replace_t>())).replace as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_replace_t),
            "::",
            stringify!(replace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_replace_t>())).oldpkg as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_replace_t),
            "::",
            stringify!(oldpkg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_replace_t>())).newpkg as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_replace_t),
            "::",
            stringify!(newpkg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_replace_t>())).newdb as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_replace_t),
            "::",
            stringify!(newdb)
        )
    );
}
#[doc = " Should a package be replaced?"]
pub type alpm_question_replace_t = _alpm_question_replace_t;
#[doc = " Should a conflicting package be removed?"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_question_conflict_t {
    #[doc = " Type of question"]
    pub type_: alpm_question_type_t,
    #[doc = " Answer: whether or not to remove conflict->package2"]
    pub remove: ::std::os::raw::c_int,
    #[doc = " Conflict info"]
    pub conflict: *mut alpm_conflict_t,
}
#[test]
fn bindgen_test_layout__alpm_question_conflict_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_question_conflict_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_question_conflict_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_question_conflict_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_question_conflict_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_conflict_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_conflict_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_conflict_t>())).remove as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_conflict_t),
            "::",
            stringify!(remove)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_conflict_t>())).conflict as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_conflict_t),
            "::",
            stringify!(conflict)
        )
    );
}
#[doc = " Should a conflicting package be removed?"]
pub type alpm_question_conflict_t = _alpm_question_conflict_t;
#[doc = " Should a corrupted package be deleted?"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_question_corrupted_t {
    #[doc = " Type of question"]
    pub type_: alpm_question_type_t,
    #[doc = " Answer: whether or not to remove filepath"]
    pub remove: ::std::os::raw::c_int,
    #[doc = " File to remove"]
    pub filepath: *const ::std::os::raw::c_char,
    #[doc = " Error code indicating the reason for package invalidity"]
    pub reason: alpm_errno_t,
}
#[test]
fn bindgen_test_layout__alpm_question_corrupted_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_question_corrupted_t>(),
        24usize,
        concat!("Size of: ", stringify!(_alpm_question_corrupted_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_question_corrupted_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_question_corrupted_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_corrupted_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_corrupted_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_corrupted_t>())).remove as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_corrupted_t),
            "::",
            stringify!(remove)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_corrupted_t>())).filepath as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_corrupted_t),
            "::",
            stringify!(filepath)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_corrupted_t>())).reason as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_corrupted_t),
            "::",
            stringify!(reason)
        )
    );
}
#[doc = " Should a corrupted package be deleted?"]
pub type alpm_question_corrupted_t = _alpm_question_corrupted_t;
#[doc = " Should unresolvable targets be removed from the transaction?"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_question_remove_pkgs_t {
    #[doc = " Type of question"]
    pub type_: alpm_question_type_t,
    #[doc = " Answer: whether or not to skip packages"]
    pub skip: ::std::os::raw::c_int,
    #[doc = " List of alpm_pkg_t* with unresolved dependencies"]
    pub packages: *mut alpm_list_t,
}
#[test]
fn bindgen_test_layout__alpm_question_remove_pkgs_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_question_remove_pkgs_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_question_remove_pkgs_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_question_remove_pkgs_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_question_remove_pkgs_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_remove_pkgs_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_remove_pkgs_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_remove_pkgs_t>())).skip as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_remove_pkgs_t),
            "::",
            stringify!(skip)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_remove_pkgs_t>())).packages as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_remove_pkgs_t),
            "::",
            stringify!(packages)
        )
    );
}
#[doc = " Should unresolvable targets be removed from the transaction?"]
pub type alpm_question_remove_pkgs_t = _alpm_question_remove_pkgs_t;
#[doc = " Provider selection"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_question_select_provider_t {
    #[doc = " Type of question"]
    pub type_: alpm_question_type_t,
    #[doc = " Answer: which provider to use (index from providers)"]
    pub use_index: ::std::os::raw::c_int,
    #[doc = " List of alpm_pkg_t* as possible providers"]
    pub providers: *mut alpm_list_t,
    #[doc = " What providers provide for"]
    pub depend: *mut alpm_depend_t,
}
#[test]
fn bindgen_test_layout__alpm_question_select_provider_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_question_select_provider_t>(),
        24usize,
        concat!("Size of: ", stringify!(_alpm_question_select_provider_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_question_select_provider_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_alpm_question_select_provider_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_select_provider_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_select_provider_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_select_provider_t>())).use_index as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_select_provider_t),
            "::",
            stringify!(use_index)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_select_provider_t>())).providers as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_select_provider_t),
            "::",
            stringify!(providers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_select_provider_t>())).depend as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_select_provider_t),
            "::",
            stringify!(depend)
        )
    );
}
#[doc = " Provider selection"]
pub type alpm_question_select_provider_t = _alpm_question_select_provider_t;
#[doc = " Should a key be imported?"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_question_import_key_t {
    #[doc = " Type of question"]
    pub type_: alpm_question_type_t,
    #[doc = " Answer: whether or not to import key"]
    pub import: ::std::os::raw::c_int,
    #[doc = " The key to import"]
    pub key: *mut alpm_pgpkey_t,
}
#[test]
fn bindgen_test_layout__alpm_question_import_key_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_question_import_key_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_question_import_key_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_question_import_key_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_question_import_key_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_import_key_t>())).type_ as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_import_key_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_import_key_t>())).import as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_import_key_t),
            "::",
            stringify!(import)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_import_key_t>())).key as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_import_key_t),
            "::",
            stringify!(key)
        )
    );
}
#[doc = " Should a key be imported?"]
pub type alpm_question_import_key_t = _alpm_question_import_key_t;
#[doc = " Questions."]
#[doc = " This is an union passed to the callback that allows the frontend to know"]
#[doc = " which type of question was triggered (via type). It is then possible to"]
#[doc = " typecast the pointer to the right structure, or use the union field, in order"]
#[doc = " to access question-specific data."]
#[repr(C)]
#[derive(Copy, Clone)]
pub union _alpm_question_t {
    #[doc = " The type of question. It's always safe to access this."]
    pub type_: alpm_question_type_t,
    #[doc = " A question that can represent any question."]
    #[doc = " It's always safe to access this."]
    pub any: alpm_question_any_t,
    #[doc = " Should target in ignorepkg be installed anyway?"]
    pub install_ignorepkg: alpm_question_install_ignorepkg_t,
    #[doc = " Should a package be replaced?"]
    pub replace: alpm_question_replace_t,
    #[doc = " Should a conflicting package be removed?"]
    pub conflict: alpm_question_conflict_t,
    #[doc = " Should a corrupted package be deleted?"]
    pub corrupted: alpm_question_corrupted_t,
    #[doc = " Should unresolvable targets be removed from the transaction?"]
    pub remove_pkgs: alpm_question_remove_pkgs_t,
    #[doc = " Provider selection"]
    pub select_provider: alpm_question_select_provider_t,
    #[doc = " Should a key be imported?"]
    pub import_key: alpm_question_import_key_t,
}
#[test]
fn bindgen_test_layout__alpm_question_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_question_t>(),
        32usize,
        concat!("Size of: ", stringify!(_alpm_question_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_question_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_question_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_t>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_t),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_t>())).any as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_t),
            "::",
            stringify!(any)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_t>())).install_ignorepkg as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_t),
            "::",
            stringify!(install_ignorepkg)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_t>())).replace as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_t),
            "::",
            stringify!(replace)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_t>())).conflict as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_t),
            "::",
            stringify!(conflict)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_t>())).corrupted as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_t),
            "::",
            stringify!(corrupted)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_t>())).remove_pkgs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_t),
            "::",
            stringify!(remove_pkgs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_question_t>())).select_provider as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_t),
            "::",
            stringify!(select_provider)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_alpm_question_t>())).import_key as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_question_t),
            "::",
            stringify!(import_key)
        )
    );
}
#[doc = " Questions."]
#[doc = " This is an union passed to the callback that allows the frontend to know"]
#[doc = " which type of question was triggered (via type). It is then possible to"]
#[doc = " typecast the pointer to the right structure, or use the union field, in order"]
#[doc = " to access question-specific data."]
pub type alpm_question_t = _alpm_question_t;
#[doc = " Question callback."]
#[doc = ""]
#[doc = " This callback allows user to give input and decide what to do during certain events"]
#[doc = " @param ctx user-provided context"]
#[doc = " @param question the question being asked."]
pub type alpm_cb_question = ::std::option::Option<
    unsafe extern "C" fn(ctx: *mut ::std::os::raw::c_void, arg1: *mut alpm_question_t),
>;
#[repr(u32)]
#[doc = " An enum over different kinds of progress alerts."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_progress_t {
    #[doc = " Package install"]
    ALPM_PROGRESS_ADD_START = 0,
    #[doc = " Package upgrade"]
    ALPM_PROGRESS_UPGRADE_START = 1,
    #[doc = " Package downgrade"]
    ALPM_PROGRESS_DOWNGRADE_START = 2,
    #[doc = " Package reinstall"]
    ALPM_PROGRESS_REINSTALL_START = 3,
    #[doc = " Package removal"]
    ALPM_PROGRESS_REMOVE_START = 4,
    #[doc = " Conflict checking"]
    ALPM_PROGRESS_CONFLICTS_START = 5,
    #[doc = " Diskspace checking"]
    ALPM_PROGRESS_DISKSPACE_START = 6,
    #[doc = " Package Integrity checking"]
    ALPM_PROGRESS_INTEGRITY_START = 7,
    #[doc = " Loading packages from disk"]
    ALPM_PROGRESS_LOAD_START = 8,
    #[doc = " Checking signatures of packages"]
    ALPM_PROGRESS_KEYRING_START = 9,
}
#[doc = " An enum over different kinds of progress alerts."]
pub use self::_alpm_progress_t as alpm_progress_t;
#[doc = " Progress callback"]
#[doc = ""]
#[doc = " Alert the front end about the progress of certain events."]
#[doc = " Allows the implementation of loading bars for events that"]
#[doc = " make take a while to complete."]
#[doc = " @param ctx user-provided context"]
#[doc = " @param progress the kind of event that is progressing"]
#[doc = " @param pkg for package operations, the name of the package being operated on"]
#[doc = " @param percent the percent completion of the action"]
#[doc = " @param howmany the total amount of items in the action"]
#[doc = " @param current the current amount of items completed"]
pub type alpm_cb_progress = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        progress: alpm_progress_t,
        pkg: *const ::std::os::raw::c_char,
        percent: ::std::os::raw::c_int,
        howmany: usize,
        current: usize,
    ),
>;
#[repr(u32)]
#[doc = " File download events."]
#[doc = " These events are reported by ALPM via download callback."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_download_event_type_t {
    #[doc = " A download was started"]
    ALPM_DOWNLOAD_INIT = 0,
    #[doc = " A download made progress"]
    ALPM_DOWNLOAD_PROGRESS = 1,
    #[doc = " Download will be retried"]
    ALPM_DOWNLOAD_RETRY = 2,
    #[doc = " A download completed"]
    ALPM_DOWNLOAD_COMPLETED = 3,
}
#[doc = " File download events."]
#[doc = " These events are reported by ALPM via download callback."]
pub use self::_alpm_download_event_type_t as alpm_download_event_type_t;
#[doc = " Context struct for when a download starts."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_download_event_init_t {
    #[doc = " whether this file is optional and thus the errors could be ignored"]
    pub optional: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__alpm_download_event_init_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_download_event_init_t>(),
        4usize,
        concat!("Size of: ", stringify!(_alpm_download_event_init_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_download_event_init_t>(),
        4usize,
        concat!("Alignment of ", stringify!(_alpm_download_event_init_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_download_event_init_t>())).optional as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_download_event_init_t),
            "::",
            stringify!(optional)
        )
    );
}
#[doc = " Context struct for when a download starts."]
pub type alpm_download_event_init_t = _alpm_download_event_init_t;
#[doc = " Context struct for when a download progresses."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_download_event_progress_t {
    #[doc = " Amount of data downloaded"]
    pub downloaded: off_t,
    #[doc = " Total amount need to be downloaded"]
    pub total: off_t,
}
#[test]
fn bindgen_test_layout__alpm_download_event_progress_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_download_event_progress_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_download_event_progress_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_download_event_progress_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_alpm_download_event_progress_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_download_event_progress_t>())).downloaded as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_download_event_progress_t),
            "::",
            stringify!(downloaded)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_download_event_progress_t>())).total as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_download_event_progress_t),
            "::",
            stringify!(total)
        )
    );
}
#[doc = " Context struct for when a download progresses."]
pub type alpm_download_event_progress_t = _alpm_download_event_progress_t;
#[doc = " Context struct for when a download retries."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_download_event_retry_t {
    #[doc = " If the download will resume or start over"]
    pub resume: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__alpm_download_event_retry_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_download_event_retry_t>(),
        4usize,
        concat!("Size of: ", stringify!(_alpm_download_event_retry_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_download_event_retry_t>(),
        4usize,
        concat!("Alignment of ", stringify!(_alpm_download_event_retry_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_download_event_retry_t>())).resume as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_download_event_retry_t),
            "::",
            stringify!(resume)
        )
    );
}
#[doc = " Context struct for when a download retries."]
pub type alpm_download_event_retry_t = _alpm_download_event_retry_t;
#[doc = " Context struct for when a download completes."]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _alpm_download_event_completed_t {
    #[doc = " Total bytes in file"]
    pub total: off_t,
    #[doc = " download result code:"]
    #[doc = "    0 - download completed successfully"]
    #[doc = "    1 - the file is up-to-date"]
    #[doc = "   -1 - error"]
    pub result: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__alpm_download_event_completed_t() {
    assert_eq!(
        ::std::mem::size_of::<_alpm_download_event_completed_t>(),
        16usize,
        concat!("Size of: ", stringify!(_alpm_download_event_completed_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_alpm_download_event_completed_t>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_alpm_download_event_completed_t)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_download_event_completed_t>())).total as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_download_event_completed_t),
            "::",
            stringify!(total)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_alpm_download_event_completed_t>())).result as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_alpm_download_event_completed_t),
            "::",
            stringify!(result)
        )
    );
}
#[doc = " Context struct for when a download completes."]
pub type alpm_download_event_completed_t = _alpm_download_event_completed_t;
#[doc = " Type of download progress callbacks."]
#[doc = " @param ctx user-provided context"]
#[doc = " @param filename the name of the file being downloaded"]
#[doc = " @param event the event type"]
#[doc = " @param data the event data of type alpm_download_event_*_t"]
pub type alpm_cb_download = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        filename: *const ::std::os::raw::c_char,
        event: alpm_download_event_type_t,
        data: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " A callback for downloading files"]
#[doc = " @param ctx user-provided context"]
#[doc = " @param url the URL of the file to be downloaded"]
#[doc = " @param localpath the directory to which the file should be downloaded"]
#[doc = " @param force whether to force an update, even if the file is the same"]
#[doc = " @return 0 on success, 1 if the file exists and is identical, -1 on"]
#[doc = " error."]
pub type alpm_cb_fetch = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        url: *const ::std::os::raw::c_char,
        localpath: *const ::std::os::raw::c_char,
        force: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int,
>;
extern "C" {
    #[doc = " Get the database of locally installed packages."]
    #[doc = " The returned pointer points to an internal structure"]
    #[doc = " of libalpm which should only be manipulated through"]
    #[doc = " libalpm functions."]
    #[doc = " @return a reference to the local database"]
    pub fn alpm_get_localdb(handle: *mut alpm_handle_t) -> *mut alpm_db_t;
}
extern "C" {
    #[doc = " Get the list of sync databases."]
    #[doc = " Returns a list of alpm_db_t structures, one for each registered"]
    #[doc = " sync database."]
    #[doc = ""]
    #[doc = " @param handle the context handle"]
    #[doc = " @return a reference to an internal list of alpm_db_t structures"]
    pub fn alpm_get_syncdbs(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Register a sync database of packages."]
    #[doc = " Databases can not be registered when there is an active transaction."]
    #[doc = ""]
    #[doc = " @param handle the context handle"]
    #[doc = " @param treename the name of the sync repository"]
    #[doc = " @param level what level of signature checking to perform on the"]
    #[doc = " database; note that this must be a '.sig' file type verification"]
    #[doc = " @return an alpm_db_t* on success (the value), NULL on error"]
    pub fn alpm_register_syncdb(
        handle: *mut alpm_handle_t,
        treename: *const ::std::os::raw::c_char,
        level: ::std::os::raw::c_int,
    ) -> *mut alpm_db_t;
}
extern "C" {
    #[doc = " Unregister all package databases."]
    #[doc = " Databases can not be unregistered while there is an active transaction."]
    #[doc = ""]
    #[doc = " @param handle the context handle"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_unregister_all_syncdbs(handle: *mut alpm_handle_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Unregister a package database."]
    #[doc = " Databases can not be unregistered when there is an active transaction."]
    #[doc = ""]
    #[doc = " @param db pointer to the package database to unregister"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_db_unregister(db: *mut alpm_db_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the name of a package database."]
    #[doc = " @param db pointer to the package database"]
    #[doc = " @return the name of the package database, NULL on error"]
    pub fn alpm_db_get_name(db: *const alpm_db_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the signature verification level for a database."]
    #[doc = " Will return the default verification level if this database is set up"]
    #[doc = " with ALPM_SIG_USE_DEFAULT."]
    #[doc = " @param db pointer to the package database"]
    #[doc = " @return the signature verification level"]
    pub fn alpm_db_get_siglevel(db: *mut alpm_db_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Check the validity of a database."]
    #[doc = " This is most useful for sync databases and verifying signature status."]
    #[doc = " If invalid, the handle error code will be set accordingly."]
    #[doc = " @param db pointer to the package database"]
    #[doc = " @return 0 if valid, -1 if invalid (pm_errno is set accordingly)"]
    pub fn alpm_db_get_valid(db: *mut alpm_db_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the list of servers assigned to this db."]
    #[doc = " @param db pointer to the database to get the servers from"]
    #[doc = " @return a char* list of servers"]
    pub fn alpm_db_get_servers(db: *const alpm_db_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Sets the list of servers for the database to use."]
    #[doc = " @param db the database to set the servers. The list will be duped and"]
    #[doc = " the original will still need to be freed by the caller."]
    #[doc = " @param servers a char* list of servers."]
    pub fn alpm_db_set_servers(
        db: *mut alpm_db_t,
        servers: *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Add a download server to a database."]
    #[doc = " @param db database pointer"]
    #[doc = " @param url url of the server"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_db_add_server(
        db: *mut alpm_db_t,
        url: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Remove a download server from a database."]
    #[doc = " @param db database pointer"]
    #[doc = " @param url url of the server"]
    #[doc = " @return 0 on success, 1 on server not present,"]
    #[doc = " -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_db_remove_server(
        db: *mut alpm_db_t,
        url: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Update package databases."]
    #[doc = ""]
    #[doc = " An update of the package databases in the list \\a dbs will be attempted."]
    #[doc = " Unless \\a force is true, the update will only be performed if the remote"]
    #[doc = " databases were modified since the last update."]
    #[doc = ""]
    #[doc = " This operation requires a database lock, and will return an applicable error"]
    #[doc = " if the lock could not be obtained."]
    #[doc = ""]
    #[doc = " Example:"]
    #[doc = " @code"]
    #[doc = " alpm_list_t *dbs = alpm_get_syncdbs(config->handle);"]
    #[doc = " ret = alpm_db_update(config->handle, dbs, force);"]
    #[doc = " if(ret < 0) {"]
    #[doc = "     pm_printf(ALPM_LOG_ERROR, _(\"failed to synchronize all databases (%s)\\n\"),"]
    #[doc = "         alpm_strerror(alpm_errno(config->handle)));"]
    #[doc = " }"]
    #[doc = " @endcode"]
    #[doc = ""]
    #[doc = " @note After a successful update, the \\link alpm_db_get_pkgcache()"]
    #[doc = " package cache \\endlink will be invalidated"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param dbs list of package databases to update"]
    #[doc = " @param force if true, then forces the update, otherwise update only in case"]
    #[doc = " the databases aren't up to date"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly),"]
    #[doc = " 1 if all databases are up to to date"]
    pub fn alpm_db_update(
        handle: *mut alpm_handle_t,
        dbs: *mut alpm_list_t,
        force: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get a package entry from a package database."]
    #[doc = " Looking up a package is O(1) and will be significantly faster than"]
    #[doc = " iterating over the pkgcahe."]
    #[doc = " @param db pointer to the package database to get the package from"]
    #[doc = " @param name of the package"]
    #[doc = " @return the package entry on success, NULL on error"]
    pub fn alpm_db_get_pkg(
        db: *mut alpm_db_t,
        name: *const ::std::os::raw::c_char,
    ) -> *mut alpm_pkg_t;
}
extern "C" {
    #[doc = " Get the package cache of a package database."]
    #[doc = " This is a list of all packages the db contains."]
    #[doc = " @param db pointer to the package database to get the package from"]
    #[doc = " @return the list of packages on success, NULL on error"]
    pub fn alpm_db_get_pkgcache(db: *mut alpm_db_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Get a group entry from a package database."]
    #[doc = " Looking up a group is O(1) and will be significantly faster than"]
    #[doc = " iterating over the groupcahe."]
    #[doc = " @param db pointer to the package database to get the group from"]
    #[doc = " @param name of the group"]
    #[doc = " @return the groups entry on success, NULL on error"]
    pub fn alpm_db_get_group(
        db: *mut alpm_db_t,
        name: *const ::std::os::raw::c_char,
    ) -> *mut alpm_group_t;
}
extern "C" {
    #[doc = " Get the group cache of a package database."]
    #[doc = " @param db pointer to the package database to get the group from"]
    #[doc = " @return the list of groups on success, NULL on error"]
    pub fn alpm_db_get_groupcache(db: *mut alpm_db_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Searches a database with regular expressions."]
    #[doc = " @param db pointer to the package database to search in"]
    #[doc = " @param needles a list of regular expressions to search for"]
    #[doc = " @param ret pointer to list for storing packages matching all"]
    #[doc = " regular expressions - must point to an empty (NULL) alpm_list_t *."]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_db_search(
        db: *mut alpm_db_t,
        needles: *const alpm_list_t,
        ret: *mut *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
pub mod _alpm_db_usage_t {
    #[doc = " The usage level of a database."]
    pub type Type = ::std::os::raw::c_uint;
    #[doc = " Enable refreshes for this database"]
    pub const ALPM_DB_USAGE_SYNC: Type = 1;
    #[doc = " Enable search for this database"]
    pub const ALPM_DB_USAGE_SEARCH: Type = 2;
    #[doc = " Enable installing packages from this database"]
    pub const ALPM_DB_USAGE_INSTALL: Type = 4;
    #[doc = " Enable sysupgrades with this database"]
    pub const ALPM_DB_USAGE_UPGRADE: Type = 8;
    #[doc = " Enable all usage levels"]
    pub const ALPM_DB_USAGE_ALL: Type = 15;
}
#[doc = " The usage level of a database."]
pub use self::_alpm_db_usage_t::Type as alpm_db_usage_t;
extern "C" {
    #[doc = " Sets the usage of a database."]
    #[doc = " @param db pointer to the package database to set the status for"]
    #[doc = " @param usage a bitmask of alpm_db_usage_t values"]
    #[doc = " @return 0 on success, or -1 on error"]
    pub fn alpm_db_set_usage(
        db: *mut alpm_db_t,
        usage: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets the usage of a database."]
    #[doc = " @param db pointer to the package database to get the status of"]
    #[doc = " @param usage pointer to an alpm_db_usage_t to store db's status"]
    #[doc = " @return 0 on success, or -1 on error"]
    pub fn alpm_db_get_usage(
        db: *mut alpm_db_t,
        usage: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub mod _alpm_loglevel_t {
    #[doc = " Logging Levels"]
    pub type Type = ::std::os::raw::c_uint;
    #[doc = " Error"]
    pub const ALPM_LOG_ERROR: Type = 1;
    #[doc = " Warning"]
    pub const ALPM_LOG_WARNING: Type = 2;
    #[doc = " Debug"]
    pub const ALPM_LOG_DEBUG: Type = 4;
    #[doc = " Function"]
    pub const ALPM_LOG_FUNCTION: Type = 8;
}
#[doc = " Logging Levels"]
pub use self::_alpm_loglevel_t::Type as alpm_loglevel_t;
#[doc = " The callback type for logging."]
#[doc = ""]
#[doc = " libalpm will call this function whenever something is to be logged."]
#[doc = " many libalpm will produce log output. Additionally any calls to \\link alpm_logaction"]
#[doc = " \\endlink will also call this callback."]
#[doc = " @param ctx user-provided context"]
#[doc = " @param level the currently set loglevel"]
#[doc = " @param fmt the printf like format string"]
#[doc = " @param args printf like arguments"]
pub type alpm_cb_log = ::std::option::Option<
    unsafe extern "C" fn(
        ctx: *mut ::std::os::raw::c_void,
        level: alpm_loglevel_t,
        fmt: *const ::std::os::raw::c_char,
        args: *mut __va_list_tag,
    ),
>;
extern "C" {
    #[doc = " A printf-like function for logging."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param prefix caller-specific prefix for the log"]
    #[doc = " @param fmt output format"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_logaction(
        handle: *mut alpm_handle_t,
        prefix: *const ::std::os::raw::c_char,
        fmt: *const ::std::os::raw::c_char,
        ...
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the callback used for logging."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set log callback"]
    pub fn alpm_option_get_logcb(handle: *mut alpm_handle_t) -> alpm_cb_log;
}
extern "C" {
    #[doc = " Returns the callback used for logging."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set log callback context"]
    pub fn alpm_option_get_logcb_ctx(handle: *mut alpm_handle_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Sets the callback used for logging."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param cb the cb to use"]
    #[doc = " @param ctx user-provided context to pass to cb"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_logcb(
        handle: *mut alpm_handle_t,
        cb: alpm_cb_log,
        ctx: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the callback used to report download progress."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set download callback"]
    pub fn alpm_option_get_dlcb(handle: *mut alpm_handle_t) -> alpm_cb_download;
}
extern "C" {
    #[doc = " Returns the callback used to report download progress."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set download callback context"]
    pub fn alpm_option_get_dlcb_ctx(handle: *mut alpm_handle_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Sets the callback used to report download progress."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param cb the cb to use"]
    #[doc = " @param ctx user-provided context to pass to cb"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_dlcb(
        handle: *mut alpm_handle_t,
        cb: alpm_cb_download,
        ctx: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the downloading callback."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set fetch callback"]
    pub fn alpm_option_get_fetchcb(handle: *mut alpm_handle_t) -> alpm_cb_fetch;
}
extern "C" {
    #[doc = " Returns the downloading callback."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set fetch callback context"]
    pub fn alpm_option_get_fetchcb_ctx(handle: *mut alpm_handle_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Sets the downloading callback."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param cb the cb to use"]
    #[doc = " @param ctx user-provided context to pass to cb"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_fetchcb(
        handle: *mut alpm_handle_t,
        cb: alpm_cb_fetch,
        ctx: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the callback used for events."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set event callback"]
    pub fn alpm_option_get_eventcb(handle: *mut alpm_handle_t) -> alpm_cb_event;
}
extern "C" {
    #[doc = " Returns the callback used for events."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set event callback context"]
    pub fn alpm_option_get_eventcb_ctx(handle: *mut alpm_handle_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Sets the callback used for events."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param cb the cb to use"]
    #[doc = " @param ctx user-provided context to pass to cb"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_eventcb(
        handle: *mut alpm_handle_t,
        cb: alpm_cb_event,
        ctx: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the callback used for questions."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set question callback"]
    pub fn alpm_option_get_questioncb(handle: *mut alpm_handle_t) -> alpm_cb_question;
}
extern "C" {
    #[doc = " Returns the callback used for questions."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set question callback context"]
    pub fn alpm_option_get_questioncb_ctx(
        handle: *mut alpm_handle_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Sets the callback used for questions."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param cb the cb to use"]
    #[doc = " @param ctx user-provided context to pass to cb"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_questioncb(
        handle: *mut alpm_handle_t,
        cb: alpm_cb_question,
        ctx: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = "Returns the callback used for operation progress."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set progress callback"]
    pub fn alpm_option_get_progresscb(handle: *mut alpm_handle_t) -> alpm_cb_progress;
}
extern "C" {
    #[doc = "Returns the callback used for operation progress."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the currently set progress callback context"]
    pub fn alpm_option_get_progresscb_ctx(
        handle: *mut alpm_handle_t,
    ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Sets the callback used for operation progress."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param cb the cb to use"]
    #[doc = " @param ctx user-provided context to pass to cb"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_progresscb(
        handle: *mut alpm_handle_t,
        cb: alpm_cb_progress,
        ctx: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the root path. Read-only."]
    #[doc = " @param handle the context handle"]
    pub fn alpm_option_get_root(handle: *mut alpm_handle_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the path to the database directory. Read-only."]
    #[doc = " @param handle the context handle"]
    pub fn alpm_option_get_dbpath(handle: *mut alpm_handle_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the name of the database lock file. Read-only."]
    #[doc = " This is the name that the lockfile would have. It does not"]
    #[doc = " matter if the lockfile actually exists on disk."]
    #[doc = " @param handle the context handle"]
    pub fn alpm_option_get_lockfile(handle: *mut alpm_handle_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Gets the currently configured cachedirs,"]
    #[doc = " @param handle the context handle"]
    #[doc = " @return a char* list of cache directories"]
    pub fn alpm_option_get_cachedirs(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Sets the cachedirs."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param cachedirs a char* list of cachdirs. The list will be duped and"]
    #[doc = " the original will still need to be freed by the caller."]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_cachedirs(
        handle: *mut alpm_handle_t,
        cachedirs: *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Append a cachedir to the configured cachedirs."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param cachedir the cachedir to add"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_add_cachedir(
        handle: *mut alpm_handle_t,
        cachedir: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Remove a cachedir from the configured cachedirs."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param cachedir the cachedir to remove"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_remove_cachedir(
        handle: *mut alpm_handle_t,
        cachedir: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets the currently configured hookdirs,"]
    #[doc = " @param handle the context handle"]
    #[doc = " @return a char* list of hook directories"]
    pub fn alpm_option_get_hookdirs(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Sets the hookdirs."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param hookdirs a char* list of hookdirs. The list will be duped and"]
    #[doc = " the original will still need to be freed by the caller."]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_hookdirs(
        handle: *mut alpm_handle_t,
        hookdirs: *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Append a hookdir to the configured hookdirs."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param hookdir the hookdir to add"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_add_hookdir(
        handle: *mut alpm_handle_t,
        hookdir: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Remove a hookdir from the configured hookdirs."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param hookdir the hookdir to remove"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_remove_hookdir(
        handle: *mut alpm_handle_t,
        hookdir: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets the currently configured overwritable files,"]
    #[doc = " @param handle the context handle"]
    #[doc = " @return a char* list of overwritable file globs"]
    pub fn alpm_option_get_overwrite_files(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Sets the overwritable files."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param globs a char* list of overwritable file globs. The list will be duped and"]
    #[doc = " the original will still need to be freed by the caller."]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_overwrite_files(
        handle: *mut alpm_handle_t,
        globs: *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Append an overwritable file to the configured overwritable files."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param glob the file glob to add"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_add_overwrite_file(
        handle: *mut alpm_handle_t,
        glob: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Remove a file glob from the configured overwritable files globs."]
    #[doc = " @note The overwritable file list contains a list of globs. The glob to"]
    #[doc = " remove must exactly match the entry to remove. There is no glob expansion."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param glob the file glob to remove"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_remove_overwrite_file(
        handle: *mut alpm_handle_t,
        glob: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets the filepath to the currently set logfile."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the path to the logfile"]
    pub fn alpm_option_get_logfile(handle: *mut alpm_handle_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Sets the logfile path."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param logfile path to the new location of the logfile"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_logfile(
        handle: *mut alpm_handle_t,
        logfile: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the path to libalpm's GnuPG home directory."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the path to libalpms's GnuPG home directory"]
    pub fn alpm_option_get_gpgdir(handle: *mut alpm_handle_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Sets the path to libalpm's GnuPG home directory."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param gpgdir the gpgdir to set"]
    pub fn alpm_option_set_gpgdir(
        handle: *mut alpm_handle_t,
        gpgdir: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns whether to use syslog (0 is FALSE, TRUE otherwise)."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_get_usesyslog(handle: *mut alpm_handle_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Sets whether to use syslog (0 is FALSE, TRUE otherwise)."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param usesyslog whether to use the syslog (0 is FALSE, TRUE otherwise)"]
    pub fn alpm_option_set_usesyslog(
        handle: *mut alpm_handle_t,
        usesyslog: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the list of no-upgrade files"]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the char* list of no-upgrade files"]
    pub fn alpm_option_get_noupgrades(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Add a file to the no-upgrade list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param path the path to add"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_add_noupgrade(
        handle: *mut alpm_handle_t,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Sets the list of no-upgrade files"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param noupgrade a char* list of file to not upgrade."]
    #[doc = " The list will be duped and the original will still need to be freed by the caller."]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_noupgrades(
        handle: *mut alpm_handle_t,
        noupgrade: *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Remove an entry from the no-upgrade list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param path the path to remove"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_remove_noupgrade(
        handle: *mut alpm_handle_t,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Test if a path matches any of the globs in the no-upgrade list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param path the path to test"]
    #[doc = " @return 0 is the path matches a glob, negative if there is no match and"]
    #[doc = " positive is the  match was inverted"]
    pub fn alpm_option_match_noupgrade(
        handle: *mut alpm_handle_t,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the list of no-extract files"]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the char* list of no-extract files"]
    pub fn alpm_option_get_noextracts(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Add a file to the no-extract list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param path the path to add"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_add_noextract(
        handle: *mut alpm_handle_t,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Sets the list of no-extract files"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param noextract a char* list of file to not extract."]
    #[doc = " The list will be duped and the original will still need to be freed by the caller."]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_noextracts(
        handle: *mut alpm_handle_t,
        noextract: *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Remove an entry from the no-extract list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param path the path to remove"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_remove_noextract(
        handle: *mut alpm_handle_t,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Test if a path matches any of the globs in the no-extract list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param path the path to test"]
    #[doc = " @return 0 is the path matches a glob, negative if there is no match and"]
    #[doc = " positive is the  match was inverted"]
    pub fn alpm_option_match_noextract(
        handle: *mut alpm_handle_t,
        path: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the list of ignored packages"]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the char* list of ignored packages"]
    pub fn alpm_option_get_ignorepkgs(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Add a file to the ignored package list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param pkg the package to add"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_add_ignorepkg(
        handle: *mut alpm_handle_t,
        pkg: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Sets the list of packages to ignore"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param ignorepkgs a char* list of packages to ignore"]
    #[doc = " The list will be duped and the original will still need to be freed by the caller."]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_ignorepkgs(
        handle: *mut alpm_handle_t,
        ignorepkgs: *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Remove an entry from the ignorepkg list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param pkg the package to remove"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_remove_ignorepkg(
        handle: *mut alpm_handle_t,
        pkg: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the list of ignored groups"]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the char* list of ignored groups"]
    pub fn alpm_option_get_ignoregroups(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Add a file to the ignored group list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param grp the group to add"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_add_ignoregroup(
        handle: *mut alpm_handle_t,
        grp: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Sets the list of groups to ignore"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param ignoregrps a char* list of groups to ignore"]
    #[doc = " The list will be duped and the original will still need to be freed by the caller."]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_ignoregroups(
        handle: *mut alpm_handle_t,
        ignoregrps: *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Remove an entry from the ignoregroup list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param grp the group to remove"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_remove_ignoregroup(
        handle: *mut alpm_handle_t,
        grp: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets the list of dependencies that are assumed to be met"]
    #[doc = " @param handle the context handle"]
    #[doc = " @return a list of alpm_depend_t*"]
    pub fn alpm_option_get_assumeinstalled(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Add a depend to the assumed installed list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param dep the dependency to add"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_add_assumeinstalled(
        handle: *mut alpm_handle_t,
        dep: *const alpm_depend_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Sets the list of dependencies that are assumed to be met"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param deps a list of *alpm_depend_t"]
    #[doc = " The list will be duped and the original will still need to be freed by the caller."]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_assumeinstalled(
        handle: *mut alpm_handle_t,
        deps: *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Remove an entry from the assume installed list"]
    #[doc = " @param handle the context handle"]
    #[doc = " @param dep the dep to remove"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_remove_assumeinstalled(
        handle: *mut alpm_handle_t,
        dep: *const alpm_depend_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the allowed package architecture."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the configured package architectures"]
    pub fn alpm_option_get_architectures(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Adds an allowed package architecture."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param arch the architecture to set"]
    pub fn alpm_option_add_architecture(
        handle: *mut alpm_handle_t,
        arch: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Sets the allowed package architecture."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param arches the architecture to set"]
    pub fn alpm_option_set_architectures(
        handle: *mut alpm_handle_t,
        arches: *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Removes an allowed package architecture."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param arch the architecture to remove"]
    pub fn alpm_option_remove_architecture(
        handle: *mut alpm_handle_t,
        arch: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get whether or not checking for free space before installing packages is enabled."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return 0 if disabled, 1 if enabled"]
    pub fn alpm_option_get_checkspace(handle: *mut alpm_handle_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Enable/disable checking free space before installing packages."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param checkspace 0 for disabled, 1 for enabled"]
    pub fn alpm_option_set_checkspace(
        handle: *mut alpm_handle_t,
        checkspace: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets the configured database extension."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the configured database extension"]
    pub fn alpm_option_get_dbext(handle: *mut alpm_handle_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Sets the database extension."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param dbext the database extension to use"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_dbext(
        handle: *mut alpm_handle_t,
        dbext: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the default siglevel."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return a \\link alpm_siglevel_t \\endlink bitfield of the siglevel"]
    pub fn alpm_option_get_default_siglevel(handle: *mut alpm_handle_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set the default siglevel."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param level a \\link alpm_siglevel_t \\endlink bitfield of the level to set"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_default_siglevel(
        handle: *mut alpm_handle_t,
        level: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the configured local file siglevel."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return a \\link alpm_siglevel_t \\endlink bitfield of the siglevel"]
    pub fn alpm_option_get_local_file_siglevel(handle: *mut alpm_handle_t)
        -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set the local file siglevel."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param level a \\link alpm_siglevel_t \\endlink bitfield of the level to set"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_local_file_siglevel(
        handle: *mut alpm_handle_t,
        level: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Get the configured remote file siglevel."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return a \\link alpm_siglevel_t \\endlink bitfield of the siglevel"]
    pub fn alpm_option_get_remote_file_siglevel(
        handle: *mut alpm_handle_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Set the remote file siglevel."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param level a \\link alpm_siglevel_t \\endlink bitfield of the level to set"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_remote_file_siglevel(
        handle: *mut alpm_handle_t,
        level: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Enables/disables the download timeout."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param disable_dl_timeout 0 for enabled, 1 for disabled"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_option_set_disable_dl_timeout(
        handle: *mut alpm_handle_t,
        disable_dl_timeout: ::std::os::raw::c_ushort,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets the number of parallel streams to download database and package files."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the number of parallel streams to download database and package files"]
    pub fn alpm_option_get_parallel_downloads(handle: *mut alpm_handle_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Sets number of parallel streams to download database and package files."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param num_streams number of parallel download streams"]
    #[doc = " @return 0 on success, -1 on error"]
    pub fn alpm_option_set_parallel_downloads(
        handle: *mut alpm_handle_t,
        num_streams: ::std::os::raw::c_uint,
    ) -> ::std::os::raw::c_int;
}
#[repr(u32)]
#[doc = " Package install reasons."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_pkgreason_t {
    #[doc = " Explicitly requested by the user."]
    ALPM_PKG_REASON_EXPLICIT = 0,
    #[doc = " Installed as a dependency for another package."]
    ALPM_PKG_REASON_DEPEND = 1,
}
#[doc = " Package install reasons."]
pub use self::_alpm_pkgreason_t as alpm_pkgreason_t;
#[repr(u32)]
#[doc = " Location a package object was loaded from."]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum _alpm_pkgfrom_t {
    #[doc = " Loaded from a file via \\link alpm_pkg_load \\endlink"]
    ALPM_PKG_FROM_FILE = 1,
    #[doc = " From the local database"]
    ALPM_PKG_FROM_LOCALDB = 2,
    #[doc = " From a sync database"]
    ALPM_PKG_FROM_SYNCDB = 3,
}
#[doc = " Location a package object was loaded from."]
pub use self::_alpm_pkgfrom_t as alpm_pkgfrom_t;
pub mod _alpm_pkgvalidation_t {
    #[doc = " Method used to validate a package."]
    pub type Type = ::std::os::raw::c_uint;
    #[doc = " The package's validation type is unknown"]
    pub const ALPM_PKG_VALIDATION_UNKNOWN: Type = 0;
    #[doc = " The package does not have any validation"]
    pub const ALPM_PKG_VALIDATION_NONE: Type = 1;
    #[doc = " The package is validated with md5"]
    pub const ALPM_PKG_VALIDATION_MD5SUM: Type = 2;
    #[doc = " The package is validated with sha256"]
    pub const ALPM_PKG_VALIDATION_SHA256SUM: Type = 4;
    #[doc = " The package is validated with a PGP signature"]
    pub const ALPM_PKG_VALIDATION_SIGNATURE: Type = 8;
}
#[doc = " Method used to validate a package."]
pub use self::_alpm_pkgvalidation_t::Type as alpm_pkgvalidation_t;
extern "C" {
    #[doc = " Create a package from a file."]
    #[doc = " If full is false, the archive is read only until all necessary"]
    #[doc = " metadata is found. If it is true, the entire archive is read, which"]
    #[doc = " serves as a verification of integrity and the filelist can be created."]
    #[doc = " The allocated structure should be freed using alpm_pkg_free()."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param filename location of the package tarball"]
    #[doc = " @param full whether to stop the load after metadata is read or continue"]
    #[doc = " through the full archive"]
    #[doc = " @param level what level of package signature checking to perform on the"]
    #[doc = " package; note that this must be a '.sig' file type verification"]
    #[doc = " @param pkg address of the package pointer"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_pkg_load(
        handle: *mut alpm_handle_t,
        filename: *const ::std::os::raw::c_char,
        full: ::std::os::raw::c_int,
        level: ::std::os::raw::c_int,
        pkg: *mut *mut alpm_pkg_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Fetch a list of remote packages."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param urls list of package URLs to download"]
    #[doc = " @param fetched list of filepaths to the fetched packages, each item"]
    #[doc = "    corresponds to one in `urls` list. This is an output parameter,"]
    #[doc = "    the caller should provide a pointer to an empty list"]
    #[doc = "    (*fetched === NULL) and the callee fills the list with data."]
    #[doc = " @return 0 on success or -1 on failure"]
    pub fn alpm_fetch_pkgurl(
        handle: *mut alpm_handle_t,
        urls: *const alpm_list_t,
        fetched: *mut *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Find a package in a list by name."]
    #[doc = " @param haystack a list of alpm_pkg_t"]
    #[doc = " @param needle the package name"]
    #[doc = " @return a pointer to the package if found or NULL"]
    pub fn alpm_pkg_find(
        haystack: *mut alpm_list_t,
        needle: *const ::std::os::raw::c_char,
    ) -> *mut alpm_pkg_t;
}
extern "C" {
    #[doc = " Free a package."]
    #[doc = " Only packages loaded with \\link alpm_pkg_load \\endlink can be freed."]
    #[doc = " Packages from databases will be freed by libalpm when they are unregistered."]
    #[doc = " @param pkg package pointer to free"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_pkg_free(pkg: *mut alpm_pkg_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Check the integrity (with md5) of a package from the sync cache."]
    #[doc = " @param pkg package pointer"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_pkg_checkmd5sum(pkg: *mut alpm_pkg_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Compare two version strings and determine which one is 'newer'."]
    #[doc = " Returns a value comparable to the way strcmp works. Returns 1"]
    #[doc = " if a is newer than b, 0 if a and b are the same version, or -1"]
    #[doc = " if b is newer than a."]
    #[doc = ""]
    #[doc = " Different epoch values for version strings will override any further"]
    #[doc = " comparison. If no epoch is provided, 0 is assumed."]
    #[doc = ""]
    #[doc = " Keep in mind that the pkgrel is only compared if it is available"]
    #[doc = " on both versions handed to this function. For example, comparing"]
    #[doc = " 1.5-1 and 1.5 will yield 0; comparing 1.5-1 and 1.5-2 will yield"]
    #[doc = " -1 as expected. This is mainly for supporting versioned dependencies"]
    #[doc = " that do not include the pkgrel."]
    pub fn alpm_pkg_vercmp(
        a: *const ::std::os::raw::c_char,
        b: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Computes the list of packages requiring a given package."]
    #[doc = " The return value of this function is a newly allocated"]
    #[doc = " list of package names (char*), it should be freed by the caller."]
    #[doc = " @param pkg a package"]
    #[doc = " @return the list of packages requiring pkg"]
    pub fn alpm_pkg_compute_requiredby(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Computes the list of packages optionally requiring a given package."]
    #[doc = " The return value of this function is a newly allocated"]
    #[doc = " list of package names (char*), it should be freed by the caller."]
    #[doc = " @param pkg a package"]
    #[doc = " @return the list of packages optionally requiring pkg"]
    pub fn alpm_pkg_compute_optionalfor(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Test if a package should be ignored."]
    #[doc = " Checks if the package is ignored via IgnorePkg, or if the package is"]
    #[doc = " in a group ignored via IgnoreGroup."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param pkg the package to test"]
    #[doc = " @return 1 if the package should be ignored, 0 otherwise"]
    pub fn alpm_pkg_should_ignore(
        handle: *mut alpm_handle_t,
        pkg: *mut alpm_pkg_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Gets the name of the file from which the package was loaded."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_filename(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the package base name."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_base(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the package name."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_name(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the package version as a string."]
    #[doc = " This includes all available epoch, version, and pkgrel components. Use"]
    #[doc = " alpm_pkg_vercmp() to compare version strings if necessary."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_version(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the origin of the package."]
    #[doc = " @return an alpm_pkgfrom_t constant, -1 on error"]
    pub fn alpm_pkg_get_origin(pkg: *mut alpm_pkg_t) -> alpm_pkgfrom_t;
}
extern "C" {
    #[doc = " Returns the package description."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_desc(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the package URL."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_url(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the build timestamp of the package."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return the timestamp of the build time"]
    pub fn alpm_pkg_get_builddate(pkg: *mut alpm_pkg_t) -> alpm_time_t;
}
extern "C" {
    #[doc = " Returns the install timestamp of the package."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return the timestamp of the install time"]
    pub fn alpm_pkg_get_installdate(pkg: *mut alpm_pkg_t) -> alpm_time_t;
}
extern "C" {
    #[doc = " Returns the packager's name."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_packager(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the package's MD5 checksum as a string."]
    #[doc = " The returned string is a sequence of 32 lowercase hexadecimal digits."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_md5sum(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the package's SHA256 checksum as a string."]
    #[doc = " The returned string is a sequence of 64 lowercase hexadecimal digits."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_sha256sum(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the architecture for which the package was built."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_arch(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Returns the size of the package. This is only available for sync database"]
    #[doc = " packages and package files, not those loaded from the local database."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return the size of the package in bytes."]
    pub fn alpm_pkg_get_size(pkg: *mut alpm_pkg_t) -> off_t;
}
extern "C" {
    #[doc = " Returns the installed size of the package."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return the total size of files installed by the package."]
    pub fn alpm_pkg_get_isize(pkg: *mut alpm_pkg_t) -> off_t;
}
extern "C" {
    #[doc = " Returns the package installation reason."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return an enum member giving the install reason."]
    pub fn alpm_pkg_get_reason(pkg: *mut alpm_pkg_t) -> alpm_pkgreason_t;
}
extern "C" {
    #[doc = " Returns the list of package licenses."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a pointer to an internal list of strings."]
    pub fn alpm_pkg_get_licenses(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns the list of package groups."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a pointer to an internal list of strings."]
    pub fn alpm_pkg_get_groups(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns the list of package dependencies as alpm_depend_t."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal list of alpm_depend_t structures."]
    pub fn alpm_pkg_get_depends(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns the list of package optional dependencies."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal list of alpm_depend_t structures."]
    pub fn alpm_pkg_get_optdepends(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns a list of package check dependencies"]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal list of alpm_depend_t structures."]
    pub fn alpm_pkg_get_checkdepends(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns a list of package make dependencies"]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal list of alpm_depend_t structures."]
    pub fn alpm_pkg_get_makedepends(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns the list of packages conflicting with pkg."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal list of alpm_depend_t structures."]
    pub fn alpm_pkg_get_conflicts(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns the list of packages provided by pkg."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal list of alpm_depend_t structures."]
    pub fn alpm_pkg_get_provides(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns the list of packages to be replaced by pkg."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal list of alpm_depend_t structures."]
    pub fn alpm_pkg_get_replaces(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns the list of files installed by pkg."]
    #[doc = " The filenames are relative to the install root,"]
    #[doc = " and do not include leading slashes."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a pointer to a filelist object containing a count and an array of"]
    #[doc = " package file objects"]
    pub fn alpm_pkg_get_files(pkg: *mut alpm_pkg_t) -> *mut alpm_filelist_t;
}
extern "C" {
    #[doc = " Returns the list of files backed up when installing pkg."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to a list of alpm_backup_t objects"]
    pub fn alpm_pkg_get_backup(pkg: *mut alpm_pkg_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns the database containing pkg."]
    #[doc = " Returns a pointer to the alpm_db_t structure the package is"]
    #[doc = " originating from, or NULL if the package was loaded from a file."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a pointer to the DB containing pkg, or NULL."]
    pub fn alpm_pkg_get_db(pkg: *mut alpm_pkg_t) -> *mut alpm_db_t;
}
extern "C" {
    #[doc = " Returns the base64 encoded package signature."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return a reference to an internal string"]
    pub fn alpm_pkg_get_base64_sig(pkg: *mut alpm_pkg_t) -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Extracts package signature either from embedded package signature"]
    #[doc = " or if it is absent then reads data from detached signature file."]
    #[doc = " @param pkg a pointer to package."]
    #[doc = " @param sig output parameter for signature data. Callee function allocates"]
    #[doc = " a buffer needed for the signature data. Caller is responsible for"]
    #[doc = " freeing this buffer."]
    #[doc = " @param sig_len output parameter for the signature data length."]
    #[doc = " @return 0 on success, negative number on error."]
    pub fn alpm_pkg_get_sig(
        pkg: *mut alpm_pkg_t,
        sig: *mut *mut ::std::os::raw::c_uchar,
        sig_len: *mut usize,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the method used to validate a package during install."]
    #[doc = " @param pkg a pointer to package"]
    #[doc = " @return an enum member giving the validation method"]
    pub fn alpm_pkg_get_validation(pkg: *mut alpm_pkg_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns whether the package has an install scriptlet."]
    #[doc = " @return 0 if FALSE, TRUE otherwise"]
    pub fn alpm_pkg_has_scriptlet(pkg: *mut alpm_pkg_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns the size of the files that will be downloaded to install a"]
    #[doc = " package."]
    #[doc = " @param newpkg the new package to upgrade to"]
    #[doc = " @return the size of the download"]
    pub fn alpm_pkg_download_size(newpkg: *mut alpm_pkg_t) -> off_t;
}
extern "C" {
    #[doc = " Set install reason for a package in the local database."]
    #[doc = " The provided package object must be from the local database or this method"]
    #[doc = " will fail. The write to the local database is performed immediately."]
    #[doc = " @param pkg the package to update"]
    #[doc = " @param reason the new install reason"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_pkg_set_reason(
        pkg: *mut alpm_pkg_t,
        reason: alpm_pkgreason_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Open a package changelog for reading."]
    #[doc = " Similar to fopen in functionality, except that the returned 'file"]
    #[doc = " stream' could really be from an archive as well as from the database."]
    #[doc = " @param pkg the package to read the changelog of (either file or db)"]
    #[doc = " @return a 'file stream' to the package changelog"]
    pub fn alpm_pkg_changelog_open(pkg: *mut alpm_pkg_t) -> *mut ::std::os::raw::c_void;
}
extern "C" {
    #[doc = " Read data from an open changelog 'file stream'."]
    #[doc = " Similar to fread in functionality, this function takes a buffer and"]
    #[doc = " amount of data to read. If an error occurs pm_errno will be set."]
    #[doc = " @param ptr a buffer to fill with raw changelog data"]
    #[doc = " @param size the size of the buffer"]
    #[doc = " @param pkg the package that the changelog is being read from"]
    #[doc = " @param fp a 'file stream' to the package changelog"]
    #[doc = " @return the number of characters read, or 0 if there is no more data or an"]
    #[doc = " error occurred."]
    pub fn alpm_pkg_changelog_read(
        ptr: *mut ::std::os::raw::c_void,
        size: usize,
        pkg: *const alpm_pkg_t,
        fp: *mut ::std::os::raw::c_void,
    ) -> usize;
}
extern "C" {
    #[doc = " Close a package changelog for reading."]
    #[doc = " @param pkg the package to close the changelog of (either file or db)"]
    #[doc = " @param fp the 'file stream' to the package changelog to close"]
    #[doc = " @return 0 on success, -1 on error"]
    pub fn alpm_pkg_changelog_close(
        pkg: *const alpm_pkg_t,
        fp: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Open a package mtree file for reading."]
    #[doc = " @param pkg the local package to read the mtree of"]
    #[doc = " @return an archive structure for the package mtree file"]
    pub fn alpm_pkg_mtree_open(pkg: *mut alpm_pkg_t) -> *mut archive;
}
extern "C" {
    #[doc = " Read next entry from a package mtree file."]
    #[doc = " @param pkg the package that the mtree file is being read from"]
    #[doc = " @param archive the archive structure reading from the mtree file"]
    #[doc = " @param entry an archive_entry to store the entry header information"]
    #[doc = " @return 0 on success, 1 if end of archive is reached, -1 otherwise."]
    pub fn alpm_pkg_mtree_next(
        pkg: *const alpm_pkg_t,
        archive: *mut archive,
        entry: *mut *mut archive_entry,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Close a package mtree file."]
    #[doc = " @param pkg the local package to close the mtree of"]
    #[doc = " @param archive the archive to close"]
    pub fn alpm_pkg_mtree_close(
        pkg: *const alpm_pkg_t,
        archive: *mut archive,
    ) -> ::std::os::raw::c_int;
}
pub mod _alpm_transflag_t {
    #[doc = " Transaction flags"]
    pub type Type = ::std::os::raw::c_uint;
    #[doc = " Ignore dependency checks."]
    pub const ALPM_TRANS_FLAG_NODEPS: Type = 1;
    #[doc = " Delete files even if they are tagged as backup."]
    pub const ALPM_TRANS_FLAG_NOSAVE: Type = 4;
    #[doc = " Ignore version numbers when checking dependencies."]
    pub const ALPM_TRANS_FLAG_NODEPVERSION: Type = 8;
    #[doc = " Remove also any packages depending on a package being removed."]
    pub const ALPM_TRANS_FLAG_CASCADE: Type = 16;
    #[doc = " Remove packages and their unneeded deps (not explicitly installed)."]
    pub const ALPM_TRANS_FLAG_RECURSE: Type = 32;
    #[doc = " Modify database but do not commit changes to the filesystem."]
    pub const ALPM_TRANS_FLAG_DBONLY: Type = 64;
    #[doc = " Use ALPM_PKG_REASON_DEPEND when installing packages."]
    pub const ALPM_TRANS_FLAG_ALLDEPS: Type = 256;
    #[doc = " Only download packages and do not actually install."]
    pub const ALPM_TRANS_FLAG_DOWNLOADONLY: Type = 512;
    #[doc = " Do not execute install scriptlets after installing."]
    pub const ALPM_TRANS_FLAG_NOSCRIPTLET: Type = 1024;
    #[doc = " Ignore dependency conflicts."]
    pub const ALPM_TRANS_FLAG_NOCONFLICTS: Type = 2048;
    #[doc = " Do not install a package if it is already installed and up to date."]
    pub const ALPM_TRANS_FLAG_NEEDED: Type = 8192;
    #[doc = " Use ALPM_PKG_REASON_EXPLICIT when installing packages."]
    pub const ALPM_TRANS_FLAG_ALLEXPLICIT: Type = 16384;
    #[doc = " Do not remove a package if it is needed by another one."]
    pub const ALPM_TRANS_FLAG_UNNEEDED: Type = 32768;
    #[doc = " Remove also explicitly installed unneeded deps (use with ALPM_TRANS_FLAG_RECURSE)."]
    pub const ALPM_TRANS_FLAG_RECURSEALL: Type = 65536;
    #[doc = " Do not lock the database during the operation."]
    pub const ALPM_TRANS_FLAG_NOLOCK: Type = 131072;
}
#[doc = " Transaction flags"]
pub use self::_alpm_transflag_t::Type as alpm_transflag_t;
extern "C" {
    #[doc = " Returns the bitfield of flags for the current transaction."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return the bitfield of transaction flags"]
    pub fn alpm_trans_get_flags(handle: *mut alpm_handle_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Returns a list of packages added by the transaction."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return a list of alpm_pkg_t structures"]
    pub fn alpm_trans_get_add(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Returns the list of packages removed by the transaction."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return a list of alpm_pkg_t structures"]
    pub fn alpm_trans_get_remove(handle: *mut alpm_handle_t) -> *mut alpm_list_t;
}
extern "C" {
    #[doc = " Initialize the transaction."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param flags flags of the transaction (like nodeps, etc; see alpm_transflag_t)"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_trans_init(
        handle: *mut alpm_handle_t,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Prepare a transaction."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param data the address of an alpm_list where a list"]
    #[doc = " of alpm_depmissing_t objects is dumped (conflicting packages)"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_trans_prepare(
        handle: *mut alpm_handle_t,
        data: *mut *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Commit a transaction."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param data the address of an alpm_list where detailed description"]
    #[doc = " of an error can be dumped (i.e. list of conflicting files)"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_trans_commit(
        handle: *mut alpm_handle_t,
        data: *mut *mut alpm_list_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Interrupt a transaction."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_trans_interrupt(handle: *mut alpm_handle_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Release a transaction."]
    #[doc = " @param handle the context handle"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_trans_release(handle: *mut alpm_handle_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Search for packages to upgrade and add them to the transaction."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param enable_downgrade allow downgrading of packages if the remote version is lower"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_sync_sysupgrade(
        handle: *mut alpm_handle_t,
        enable_downgrade: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Add a package to the transaction."]
    #[doc = " If the package was loaded by alpm_pkg_load(), it will be freed upon"]
    #[doc = " \\link alpm_trans_release \\endlink invocation."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param pkg the package to add"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_add_pkg(handle: *mut alpm_handle_t, pkg: *mut alpm_pkg_t) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Add a package removal to the transaction."]
    #[doc = " @param handle the context handle"]
    #[doc = " @param pkg the package to uninstall"]
    #[doc = " @return 0 on success, -1 on error (pm_errno is set accordingly)"]
    pub fn alpm_remove_pkg(
        handle: *mut alpm_handle_t,
        pkg: *mut alpm_pkg_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " Check for new version of pkg in syncdbs."]
    #[doc = ""]
    #[doc = " If the same package appears multiple dbs only the first will be checked"]
    #[doc = ""]
    #[doc = " This only checks the syncdb for a newer version. It does not access the network at all."]
    #[doc = " See \\link alpm_db_update \\endlink to update a database."]
    pub fn alpm_sync_get_new_version(
        pkg: *mut alpm_pkg_t,
        dbs_sync: *mut alpm_list_t,
    ) -> *mut alpm_pkg_t;
}
extern "C" {
    #[doc = " Get the md5 sum of file."]
    #[doc = " @param filename name of the file"]
    #[doc = " @return the checksum on success, NULL on error"]
    pub fn alpm_compute_md5sum(
        filename: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the sha256 sum of file."]
    #[doc = " @param filename name of the file"]
    #[doc = " @return the checksum on success, NULL on error"]
    pub fn alpm_compute_sha256sum(
        filename: *const ::std::os::raw::c_char,
    ) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Remove the database lock file"]
    #[doc = " @param handle the context handle"]
    #[doc = " @return 0 on success, -1 on error"]
    #[doc = ""]
    #[doc = " @note Safe to call from inside signal handlers."]
    pub fn alpm_unlock(handle: *mut alpm_handle_t) -> ::std::os::raw::c_int;
}
pub mod alpm_caps {
    #[doc = " Enum of possible compile time features"]
    pub type Type = ::std::os::raw::c_uint;
    #[doc = " localization"]
    pub const ALPM_CAPABILITY_NLS: Type = 1;
    #[doc = " Ability to download"]
    pub const ALPM_CAPABILITY_DOWNLOADER: Type = 2;
    #[doc = " Signature checking"]
    pub const ALPM_CAPABILITY_SIGNATURES: Type = 4;
}
extern "C" {
    #[doc = " Get the version of library."]
    #[doc = " @return the library version, e.g. \"6.0.4\""]
    pub fn alpm_version() -> *const ::std::os::raw::c_char;
}
extern "C" {
    #[doc = " Get the capabilities of the library."]
    #[doc = " @return a bitmask of the capabilities"]
    pub fn alpm_capabilities() -> ::std::os::raw::c_int;
}
pub type __builtin_va_list = [__va_list_tag; 1usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __va_list_tag {
    pub gp_offset: ::std::os::raw::c_uint,
    pub fp_offset: ::std::os::raw::c_uint,
    pub overflow_arg_area: *mut ::std::os::raw::c_void,
    pub reg_save_area: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout___va_list_tag() {
    assert_eq!(
        ::std::mem::size_of::<__va_list_tag>(),
        24usize,
        concat!("Size of: ", stringify!(__va_list_tag))
    );
    assert_eq!(
        ::std::mem::align_of::<__va_list_tag>(),
        8usize,
        concat!("Alignment of ", stringify!(__va_list_tag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).gp_offset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(gp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).fp_offset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(fp_offset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).overflow_arg_area as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(overflow_arg_area)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__va_list_tag>())).reg_save_area as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__va_list_tag),
            "::",
            stringify!(reg_save_area)
        )
    );
}
