# Alpakr CLI 🦙

A simple package lookup service that isn't to strict about its inputs. Paste a snippet of names and Alpakr will do it's best to provide info about the packages.

> Conjugation of 'All' and 'Packager' and pronounced the friendly fury alpaca.
>
>    \ ăl-păk′ə \ 
>

## Install

```shell
cargo install alpakr-cli
```

## Usage

Copy paste a fragment from a Cargo.toml, package.json or python requirments.txt file and pipe it to `alpakr`.

```shell
$ echo "
console = "0.15.0"
base64 = "0.13.0"
serde = { version = "1.0", features = ["derive"] }" | alpakr
```

Example output:

```
console -> A terminal and console abstraction for Rust
https://crates.io/crates/console

base64 -> encodes and decodes base64 as bytes or utf8
https://crates.io/crates/base64

serde -> A generic serialization/deserialization framework
https://crates.io/crates/serde
```

Note: for best result paste at least one full line, but more is better.

### Other ways to query

```shell
$ grep -A 3 "console" Cargo.toml | alpakr
```

```shell
$ alpakr <enter>
console = "0.15.0"
base64 = "0.13.0"
serde = { version = "1.0", features = ["derive"] }
<ctrl-d>
```

```shell
# If you are on Mac use `pbpaste`
$ pbpaste | alpakr
```

## Options

* `--verbose`: see encoded payload and full response 
* `--json`: output as JSON

## Supported package managers

- [x] npm (npmjs.com)
- [x] cargo (crates.io)
- [x] pip (pypi.org)
- [ ] gomod (pkg.go.dev)
- [x] gem (rubygems.org)
- [x] composer (packagist.org)

## Motivation

In short. I read a lot of code in many different languages. Part of that is looking into what third party packages are used. This can be by reading package.json files or skimming through the text when compiling a Rust program. I wanted to make it easier to learn about packages I don't know about.
