# Alpakr CLI

A simple package lookup service that isn't to strict about its inputs. Support repositories are: crates.io, pypipy.org, and npm.

> Conjugation of 'All' and 'Packager' and pronounced the friendly fury alpaca.
>
>    \ al-Ààpa-k…ô  \ 
>

## Install

```shell
cargo install alpakr-cli
```

## Usage

Copy paste a fragment from a Cargo.toml, package.json or python requirments.txt file and pipe it to `alpakr`.

```shell
$ alpakr # hit enter
console = "0.15.0"
base64 = "0.13.0"
serde = { version = "1.0", features = ["derive"] }
# then ctrl-d to end
```

or:  

```shell
$ grep -A 3 "console" Cargo.toml | alpakr
```

Example output:

```
console -> A terminal and console abstraction for Rust
https://crates.io/crates/console

base64 -> encodes and decodes base64 as bytes or utf8
https://crates.io/crates/base64

serde -> A generic serialization/deserialization framework
https://crates.io/crates/serde

serde_json -> A JSON serialization file format
https://crates.io/crates/serde_json
```


## Options

* `--verbose`: see encoded payload and full response 
* `--json`: output as JSON

