use structopt::clap::arg_enum;

arg_enum! {
    #[derive(Debug)]
    pub enum Shell {
        Bash,
        Zsh,
        Fish,
    }
}

pub static POSSIBLE_SHELL_VALUES: &[&str] = &["bash", "zsh", "fish"];

impl Shell {
    pub fn init_script(&self) -> &'static str {
        match self {
            Self::Bash => include_str!("init/almel.bash"),
            Self::Zsh => include_str!("init/almel.zsh"),
            Self::Fish => include_str!("init/almel.fish"),
        }
    }

    pub fn control_prefix(&self) -> &'static str {
        match self {
            Self::Bash => r"\[",
            Self::Zsh => r"%{",
            Self::Fish => r"",
        }
    }

    pub fn control_suffix(&self) -> &'static str {
        match self {
            Self::Bash => r"\]",
            Self::Zsh => r"%}",
            Self::Fish => r"",
        }
    }
}
