use libc::*;

pub use ALLEGRO_RENDER_FUNCTION::*;
pub use ALLEGRO_RENDER_STATE::*;
pub use ALLEGRO_WRITE_MASK_FLAGS::*;

#[derive(Copy, Clone)]
#[repr(u32)]
#[derive(Debug)]
pub enum ALLEGRO_RENDER_STATE
{
	ALLEGRO_ALPHA_TEST_RS = 0x0010,
	ALLEGRO_WRITE_MASK,
	ALLEGRO_DEPTH_TEST,
	ALLEGRO_DEPTH_FUNCTION,
	ALLEGRO_ALPHA_FUNCTION,
	ALLEGRO_ALPHA_TEST_VALUE,
}

#[derive(Copy, Clone)]
#[repr(u32)]
#[derive(Debug)]
pub enum ALLEGRO_RENDER_FUNCTION
{
	ALLEGRO_RENDER_NEVER,
	ALLEGRO_RENDER_ALWAYS,
	ALLEGRO_RENDER_LESS,
	ALLEGRO_RENDER_EQUAL,
	ALLEGRO_RENDER_LESS_EQUAL,
	ALLEGRO_RENDER_GREATER,
	ALLEGRO_RENDER_NOT_EQUAL,
	ALLEGRO_RENDER_GREATER_EQUAL,
}

#[derive(Copy, Clone)]
#[repr(u32)]
#[derive(Debug)]
pub enum ALLEGRO_WRITE_MASK_FLAGS
{
	ALLEGRO_MASK_RED = 1 << 0,
	ALLEGRO_MASK_GREEN = 1 << 1,
	ALLEGRO_MASK_BLUE = 1 << 2,
	ALLEGRO_MASK_ALPHA = 1 << 3,
	ALLEGRO_MASK_DEPTH = 1 << 4,
	ALLEGRO_MASK_RGB =
		ALLEGRO_MASK_RED as u32 | ALLEGRO_MASK_GREEN as u32 | ALLEGRO_MASK_BLUE as u32,
	ALLEGRO_MASK_RGBA = ALLEGRO_MASK_RGB as u32 | ALLEGRO_MASK_ALPHA as u32,
}

extern "C"
{
	pub fn al_set_render_state(state: ALLEGRO_RENDER_STATE, value: c_int);
}
