#! /usr/bin/env python3
import sys
import allantools
import numpy as np
import pylab as plt
from allantools import noise

# Generates N samples:
#   + white noise
#   +  pink noise
def gen_data (N):
    n = noise.white(num_points=N, b0=0.5, fs=1.0) 

def plot_semilogx (x, y, ax, label):
    ax.semilogx(x, 10*np.log10(y), "-+", label=label)

def power_law (x, y):
    (x_min_pow10, x_max_pow10) = (int(round(np.log10(x[0]))),int(round(np.log10(x[-1]))))
    print(x_min_pow10,x_max_pow10)
    nb_decade = (x_max_pow10 - x_min_pow10)
    print("nb decade", nb_decade)
    ydB = 10*np.log10(y)
    
    xn = x_min_pow10
    for i in range (0, nb_decade):
        xm = xn+1
        xn_index = max(np.where(x <= 10**xn)[0])
        xm_index = max(np.where(x <= 10**xm)[0])
        # faudrait interpoler le point en x=10**n parfaitement
        # pour calculer sur une decade parfaite
        # et surtout eviter des grosses erreurs lorsque tau=10**n est pas present
        yn = ydB[xn_index]
        ym = ydB[xm_index]
        print((ym - yn))

def mean (x):
    s = 0.0
    for i in range (0, len(x)):
        s += x[i]
    return s / len(x)

def power_law_nist (x, min_dist):
    exp = []
    for i in range (len(x) // min_dist):
        p = x[i*len(x) // min_dist:
              i*len(x) //min_dist +len(x)//min_dist]
        if len(p) == 0:
            break
        d = 0
        num = 0
        den = 0
        m = mean(p)
        for j in range (len(p)-1):
            num += (p[j] - m) * (p[j+1] - m)
            den += pow(p[j] -m, 2)
        r = num / den
        delta = r / (1+r)
        exp.append(int(round(-2*(delta + d))))
    return exp

def main (argv):
    #gen_data(128)
    #taus = np.logspace(0, 3, 50)
    #fig, ax = plt.subplots(1,1)
    data = allantools.noise.white(256)
    print(data)
    print("white", power_law_nist(data, 1))
    
    data = allantools.noise.pink(256)
    print(data)
    print("pink", power_law_nist(data, 3))

    data = np.diff(allantools.noise.white(1000))
    print("white", power_law_nist(data, 1))
    data = allantools.noise.pink(1000)
    print("pink", power_law_nist(data, 3))
    data = allantools.noise.brown(1000)
    print("brownian", power_law_nist(data, 3))
    data = allantools.noise.violet(1000)
    print("violet", power_law_nist(data, 3))

    return 0
    #(taus, ad, ade, adn) = allantools.mdev(data, taus=taus)
    #power_law(taus, ad)
    #plot_semilogx(taus, ad, ax, "MDEV W PM")
    
    (taus, ad, ade, adn) = allantools.adev(data, taus=taus)
    power_law(taus, ad)
    plot_semilogx(taus, ad, ax, "ADEV W PM")
    
    #(taus, ad, ade, adn) = allantools.oadev(data, taus=taus)
    #power_law(taus, ad)
    #plot_semilogx(taus, ad, ax, "oADEV W PM")
    
    #(taus, ad, ade, adn) = allantools.mdev(data, taus=taus, data_type='freq')
    #plot_semilogx(taus, ad, ax, "MDEV W FM")
    (taus, ad, ade, adn) = allantools.adev(data, taus=taus, data_type='freq')
    power_law(taus, ad)
    plot_semilogx(taus, ad, ax, "ADEV W FM")
    #(taus, ad, ade, adn) = allantools.oadev(data, taus=taus, data_type='freq')
    #plot_semilogx(taus, ad, ax, "oADEV W FM")
    
    ax.grid(True)
    ax.legend()
    plt.show()

if __name__ == "__main__":
    main(sys.argv[1:])
