use std::io::ErrorKind;

use jsonwebtoken::{decode, DecodingKey, Validation};
use serde::{Deserialize};

pub fn decode_token(
    token: String,
    secret_key: String
) -> Result<String, std::io::Error> { 
    let pub_key = decode::<Claims>(
        token.as_ref(),
        &DecodingKey::from_secret(secret_key.as_ref()),
        &Validation::default()
    ).map_err(|e| std::io::Error::new(ErrorKind::InvalidData, e.to_string()))?
     .claims
     .sub;

     Ok(pub_key)
}

#[derive(Deserialize)]
struct Claims { 
    sub: String,
    exp: usize
}
