use std::fs;
use serde::{Serialize, Deserialize};
use serde_json;

#[derive(Clone)]
pub struct Config {
    _host: String,
    _port: u16,
    _connection_string: String
}

impl Config { 
    pub fn new() -> Result<Self, std::io::Error> { 
        let config_file_name = "config.json";
        let config_json = fs::read_to_string(config_file_name)?;
        let config_dto: ConfigDto = serde_json::from_str(&config_json)?;
        Ok(Config {_host: config_dto.host, _port: config_dto.port, _connection_string: config_dto.connection_string})
    }

    pub fn host(&self) -> &str { &self._host }

    pub fn port(&self) -> u16 { self._port }

    pub fn connection_string(&self) -> &str { &self._connection_string }
}

#[derive(Serialize, Deserialize, Debug)]
struct ConfigDto {
    host: String,
    port: u16, 
    connection_string: String
}

