use std::fs;
use serde::{Serialize, Deserialize};
use serde_json;

pub struct Config {
    _host: String,
    _port: String
}

impl Config { 
    pub fn new() -> Result<Self, std::io::Error> { 
        let config_file_name = "config.json";
        let config_json = fs::read_to_string(config_file_name)?;
        let config_dto: ConfigDto = serde_json::from_str(&config_json)?;
        Ok(Config {_host: config_dto.host, _port: config_dto.port})
    }

    pub fn host(&self) -> &String { &self._host }

    pub fn port(&self) -> &String { &self._port }
}

#[derive(Serialize, Deserialize, Debug)]
struct ConfigDto {
    host: String,
    port: String
}

