use std::sync::{Arc};
use async_trait::async_trait;

use all4art_authservice_domain::{public_key::{PublicKey, self}, user::User, factories::{UserFactory, HashedPasswordFactory}, hashed_password::HashedPassword};

#[async_trait]
pub trait UserRepository {
    async fn retrieve_user(&self, public_key: &PublicKey) 
    -> Result<Arc<dyn User + Send + Sync>, std::io::Error>;
    async fn create_user(&self, user: Arc<dyn User + Send + Sync>) -> Result<(), std::io::Error>;
}

pub struct UserRepositoryImpl { 
    user_factory: Arc<dyn UserFactory + Send + Sync>,
    hashed_password_factory: Arc<dyn HashedPasswordFactory + Send + Sync>
}


#[async_trait]
impl UserRepository for UserRepositoryImpl { 
    async fn retrieve_user(&self, public_key: &PublicKey) -> Result<Arc<dyn User + Send + Sync>, std::io::Error> { 
        let public_key = PublicKey::new(String::from("public_key"));
        let hashed_password = self.hashed_password_factory.create()?;
        let user = self.user_factory.create(public_key, hashed_password)?;
        Ok(user)
    }

    async fn create_user(&self, user: Arc<dyn User + Send + Sync>) -> Result<(), std::io::Error> { 
        let result = ();
        Ok(result)
    }
}
