use std::sync::{Arc};

use all4art_authservice_domain::{public_key::{PublicKey}, user::User};

pub trait UserRepository {
    fn retrieve_user(&self, public_key: PublicKey) -> Result<Arc<dyn User>, std::io::Error>;
    fn create_user(&self, user: Arc<dyn User>) -> Result<(), std::io::Error>;
}
