use std::rc::Rc;

use all4art_authservice_domain::{public_key::{PublicKey}, user::User};

pub trait UserRepository {
    fn retrieve_user(public_key: PublicKey) -> Result<Rc<dyn User>, std::io::Error>;
    fn create_user(user: Rc<dyn User>) -> Result<(), std::io::Error>;
}
