use std::sync::Arc;

use all4art_authservice_domain::{factories::ClearTextPasswordFactory, clear_text_password::ClearTextPassword, hashed_password::HashedPassword};

struct ClearTextPasswordFactoryMock { 

}

impl ClearTextPasswordFactory for ClearTextPasswordFactoryMock { 
    fn create(&self, text: String) -> Result<Arc<dyn ClearTextPassword + Send + Sync>, std::io::Error> { 
        Ok(Arc::new(ClearTextPasswordMock{}))
    }
}

struct ClearTextPasswordMock { 

}

impl ClearTextPassword for ClearTextPasswordMock { 
    fn text(&self) -> Result<String, std::io::Error> { 
        Ok(String::from("some_password"))
    }    

    fn hashed_password(&self) 
    -> Result<Arc<dyn HashedPassword + Send + Sync>, std::io::Error> { 
        let hashed_password = Arc::new(HashedPasswordMock{});
        Ok(hashed_password)
    }
}

struct HashedPasswordMock { 

}

impl HashedPassword for HashedPasswordMock { 
    fn equals(&self, hashed_password: Arc<dyn HashedPassword>) -> Result<bool, std::io::Error> { 
        Ok(true)
    }
}
