use std::sync::Arc;

use all4art_authservice_domain::{clear_text_password::ClearTextPassword, factories::ClearTextPasswordFactory, public_key::{self, PublicKey}};
use serde::{Serialize, Deserialize};
use all4art_authservice_cqrs::queries::LoginQuery;

#[derive(Deserialize)]
pub struct LoginDto { 
    pub public_key: String,
    pub password: String,
}

impl LoginDto { 
    pub fn to_query(&self, clear_text_password_factory: Arc<dyn ClearTextPasswordFactory + Send + Sync>) 
    -> Result<LoginQuery, std::io::Error> { 
        let clear_text_password = clear_text_password_factory.create(self.password.clone())?;
        let public_key = PublicKey::new(self.public_key.clone());
        Ok(LoginQuery::new(public_key, clear_text_password))
    }
}
