use std::process::Command;

use serde::Serialize;
use all4art_authservice_cqrs::command_results::SubscribeCommandResult;

#[derive(Serialize)]
pub struct UserDto { 
    pub public_key: String
}

impl UserDto { 
    pub fn from_command_result(result: SubscribeCommandResult) -> Self { 
        UserDto{public_key: result.user().public_key().value().clone()}
    }
}
