use std::sync::Arc;

use all4art_authservice_domain::{factories::ClearTextPasswordFactory, clear_text_password, public_key::{self, PublicKey}};
use serde::Deserialize;
use all4art_authservice_cqrs::commands::SubscribeCommand;

#[derive(Deserialize)]
pub struct SubscribeDto { 
    pub public_key: String,
    pub password: String
}

impl SubscribeDto { 
    pub fn to_command(&self, clear_text_password_factory: Arc<dyn ClearTextPasswordFactory + Send + Sync>) 
    -> Result<SubscribeCommand, std::io::Error> { 
        let clear_text_password = clear_text_password_factory.create(self.password.clone())?;
        let public_key = PublicKey::new(self.public_key.clone());
        Ok(SubscribeCommand::new(public_key, clear_text_password))
    }
}
