use std::{sync::Arc};

use crate::{token::Token, hashed_password::HashedPassword, public_key::PublicKey, clear_text_password::ClearTextPassword};


pub trait User { 
    fn authenticate(&self, clear_text_password: Arc<dyn ClearTextPassword>) -> Result<Token, std::io::Error>;
    fn hashed_password(&self) -> Arc<dyn HashedPassword + Send + Sync>;
}

pub struct BaseUser { 
    _public_key: PublicKey,
    _hashed_password: Arc<dyn HashedPassword + Send + Sync>
}

impl User for BaseUser { 
    fn authenticate(&self, clear_text_password: Arc<dyn ClearTextPassword>) -> Result<Token, std::io::Error> { 
        Ok(Token::new(String::from("some_token")))
    }

    fn hashed_password(&self) -> Arc<dyn HashedPassword + Send + Sync> { 
        self._hashed_password.clone()
    }
}

impl BaseUser { 
    pub fn new(public_key: PublicKey, hashed_password: Arc<dyn HashedPassword + Send + Sync>) 
    -> Result<Self, std::io::Error> { 
        Ok(BaseUser{_public_key: public_key, _hashed_password: hashed_password})
    }
}

