use std::{sync::Arc};

use crate::{user::{User, BaseUser}, hashed_password::{HashedPassword, BaseHashedPassword}, clear_text_password::{ClearTextPassword, BaseClearTextPassword, self}, public_key::PublicKey};

pub trait UserFactory { 
    fn create(&self, public_key: PublicKey, hashed_password: Arc<dyn HashedPassword + Send + Sync>) 
    -> Result<Arc<dyn User + Send + Sync>, std::io::Error>;
}

pub trait HashedPasswordFactory { 
    fn create(&self) -> Result<Arc<dyn HashedPassword + Send + Sync>, std::io::Error>;
}

pub trait ClearTextPasswordFactory { 
    fn create(&self, text: String) -> Result<Arc<dyn ClearTextPassword + Send + Sync>, std::io::Error>;
}

pub struct UserFactoryImpl { 
     
}

impl UserFactory for UserFactoryImpl { 
    fn create(&self, public_key: PublicKey, hashed_password: Arc<dyn HashedPassword + Send + Sync>) 
    -> Result<Arc<dyn User + Send + Sync>, std::io::Error> { 
        let user = BaseUser::new(public_key, hashed_password)?;
        Ok(Arc::new(user))
    }
}

pub struct HashedPasswordFactoryImpl { 

}

impl HashedPasswordFactory for HashedPasswordFactoryImpl { 
    fn create(&self) -> Result<Arc<dyn HashedPassword + Send + Sync>, std::io::Error> { 
        let hashed_password = BaseHashedPassword::new()?;
        Ok(Arc::new(hashed_password))
    }
}

pub struct ClearTextPasswordFactoryImpl { 

}

impl ClearTextPasswordFactory for ClearTextPasswordFactoryImpl { 
    fn create(&self, text: String) -> Result<Arc<dyn ClearTextPassword + Send + Sync>, std::io::Error> { 
        let clear_text_password = BaseClearTextPassword::new(text)?;
        Ok(Arc::new(clear_text_password))
    } 
}
