use std::{sync::Arc};

use crate::hashed_password::{BaseHashedPassword, self};

use super::hashed_password::HashedPassword;

pub trait ClearTextPassword { 
    fn text(&self) -> Result<String, std::io::Error>;
    fn hashed_password(&self) -> Result<Arc<dyn HashedPassword>, std::io::Error>;
}

pub struct BaseClearTextPassword { 
    _text: String
}

impl ClearTextPassword for BaseClearTextPassword { 
    fn text(&self) -> Result<String, std::io::Error> { 
        Ok(String::from("something"))
    }

    fn hashed_password(&self) -> Result<Arc<dyn HashedPassword>, std::io::Error> { 
        let hashed_password = BaseHashedPassword::new()?;
        Ok(Arc::new(hashed_password))
    }
}

impl BaseClearTextPassword { 
    pub fn new(text: String) -> Result<Self, std::io::Error> { 
        Ok(BaseClearTextPassword{_text: text})
    }
}
