use std::{sync::Arc};

use crate::{token::Token, hashed_password::HashedPassword, public_key::PublicKey, clear_text_password::ClearTextPassword};


pub trait User { 
    fn authenticate(&self, clear_text_password: Arc<dyn ClearTextPassword>) -> Result<(), std::io::Error>;
    fn token(&self) -> Token;
    fn hashed_password(&self) -> Arc<dyn HashedPassword>;
}

pub struct BaseUser { 
    _public_key: PublicKey,
    _hashed_password: Arc<dyn HashedPassword>
}

impl User for BaseUser { 
    fn authenticate(&self, clear_text_password: Arc<dyn ClearTextPassword>) -> Result<(), std::io::Error> { 
        Ok(())
    }

    fn token(&self) -> Token {
        Token::new(String::from("some_token"))
    }

    fn hashed_password(&self) -> Arc<dyn HashedPassword> { 
        self._hashed_password.clone()
    }
}

impl BaseUser { 
    pub fn new(public_key: PublicKey, hashed_password: Arc<dyn HashedPassword>) -> Self { 
        BaseUser{_public_key: public_key, _hashed_password: hashed_password}  
    }
}

