use std::{sync::Arc};

pub trait HashedPassword { 
    fn equals(&self, hashed_password: Arc<dyn HashedPassword>) -> Result<bool, std::io::Error>;
}

pub struct BaseHashedPassword { 
    
}

impl HashedPassword for BaseHashedPassword { 
    fn equals(&self, hashed_password: Arc<dyn HashedPassword>) -> Result<bool, std::io::Error> { 
        Ok(true) 
    }
}

impl BaseHashedPassword { 
    pub fn new() -> Self { 
        BaseHashedPassword{}
    }
}
