use std::{sync::Arc};

use crate::{user::{User, BaseUser}, hashed_password::{HashedPassword, BaseHashedPassword}, clear_text_password::{ClearTextPassword, BaseClearTextPassword}, public_key::PublicKey};

pub trait UserFactory { 
    fn create(&self, public_key: PublicKey, hashed_password: Arc<dyn HashedPassword>) -> Arc<dyn User>;
}

pub trait HashedPasswordFactory { 
    fn create(&self) -> Arc<dyn HashedPassword>;
}

pub trait ClearTextPasswordFactory { 
    fn create(&self, text: String) -> Arc<dyn ClearTextPassword>;
}

pub struct UserFactoryImpl { 
 
}

impl UserFactory for UserFactoryImpl { 
    fn create(&self, public_key: PublicKey, hashed_password: Arc<dyn HashedPassword>) -> Arc<dyn User> { 
        Arc::new(BaseUser::new(public_key, hashed_password)) 
    }
}

pub struct HashedPasswordFactoryImpl { 

}

impl HashedPasswordFactory for HashedPasswordFactoryImpl { 
    fn create(&self) -> Arc<dyn HashedPassword>{ 
        Arc::new(BaseHashedPassword::new())
    }
}

pub struct ClearTextPasswordFactoryImpl { 

}

impl ClearTextPasswordFactory for ClearTextPasswordFactoryImpl { 
    fn create(&self, text: String) -> Arc<dyn ClearTextPassword> { 
        Arc::new(BaseClearTextPassword::new(text))
    } 
}
