use std::rc::Rc;

pub trait HashedPassword { 
    fn equals(&self, hashed_password: Rc<dyn HashedPassword>) -> Result<bool, std::io::Error>;
}

pub struct BaseHashedPassword { 
    
}

impl HashedPassword for BaseHashedPassword { 
    fn equals(&self, hashed_password: Rc<dyn HashedPassword>) -> Result<bool, std::io::Error> { 
        Ok(true) 
    }
}

impl BaseHashedPassword { 
    pub fn new() -> Self { 
        BaseHashedPassword{}
    }
}
