use std::{rc::Rc};

use crate::{user::{User, BaseUser}, hashed_password::{HashedPassword, BaseHashedPassword}, clear_text_password::{ClearTextPassword, BaseClearTextPassword}, public_key::PublicKey};

pub trait UserFactory { 
    fn create(&self, public_key: PublicKey, hashed_password: Rc<dyn HashedPassword>) -> Rc<dyn User>;
}

pub trait HashedPasswordFactory { 
    fn create(&self) -> Rc<dyn HashedPassword>;
}

pub trait ClearTextPasswordFactory { 
    fn create(&self, text: String) -> Rc<dyn ClearTextPassword>;
}

pub struct UserFactoryImpl { 
 
}

impl UserFactory for UserFactoryImpl { 
    fn create(&self, public_key: PublicKey, hashed_password: Rc<dyn HashedPassword>) -> Rc<dyn User> { 
        Rc::new(BaseUser::new(public_key, hashed_password)) 
    }
}

pub struct HashedPasswordFactoryImpl { 

}

impl HashedPasswordFactory for HashedPasswordFactoryImpl { 
    fn create(&self) -> Rc<dyn HashedPassword>{ 
        Rc::new(BaseHashedPassword::new())
    }
}

pub struct ClearTextPasswordFactoryImpl { 

}

impl ClearTextPasswordFactory for ClearTextPasswordFactoryImpl { 
    fn create(&self, text: String) -> Rc<dyn ClearTextPassword> { 
        Rc::new(BaseClearTextPassword::new(text))
    } 
}
