use std::rc::{Rc};

use crate::hashed_password::BaseHashedPassword;

use super::hashed_password::HashedPassword;

pub trait ClearTextPassword { 
    fn text(&self) -> Result<String, std::io::Error>;
    fn hashed_password(&self) -> Result<Rc<dyn HashedPassword>, std::io::Error>;
}

pub struct BaseClearTextPassword { 
    _text: String
}

impl ClearTextPassword for BaseClearTextPassword { 
    fn text(&self) -> Result<String, std::io::Error> { 
        Ok(String::from("something"))
    }

    fn hashed_password(&self) -> Result<Rc<dyn HashedPassword>, std::io::Error> { 
        Ok(Rc::new(BaseHashedPassword{}))
    }
}

impl BaseClearTextPassword { 
    pub fn new(text: String) -> Self { 
        BaseClearTextPassword{_text: text}
    }
}
