use std::sync::Arc;

use all4art_authservice_domain::{public_key::PublicKey, clear_text_password::{ClearTextPassword, self}};

pub struct LoginQuery { 
    _public_key: PublicKey,
    _clear_text_password: Arc<dyn ClearTextPassword + Send + Sync>
}

impl LoginQuery { 
    pub fn new(public_key: PublicKey, clear_text_password: Arc<dyn ClearTextPassword + Send + Sync>) -> Self { 
       LoginQuery{_public_key: public_key, _clear_text_password: clear_text_password}
    }

    pub fn public_key(&self) -> &PublicKey { 
        &self._public_key
    }

    pub fn clear_text_password(&self) -> Arc<dyn ClearTextPassword> { 
        self._clear_text_password.clone()
    }
}
