use std::{rc::Rc, sync::Arc};

use all4art_authservice_domain::{user::User, public_key::{PublicKey, self}, clear_text_password::{ClearTextPassword, self}};

pub struct SubscribeCommand { 
    _public_key: PublicKey,
    _clear_text_password: Arc<dyn ClearTextPassword>
}

impl SubscribeCommand {
    pub fn new(public_key: PublicKey, clear_text_password: Arc<dyn ClearTextPassword>) -> Self { 
        SubscribeCommand{_public_key: public_key, _clear_text_password: clear_text_password} 
    }

    pub fn public_key(&self) -> PublicKey { 
        PublicKey::new(self._public_key.value().clone())
    }

    pub fn clear_text_password(&self) -> Arc<dyn ClearTextPassword> { 
        self._clear_text_password.clone()
    }
}

