use std::{sync::Arc};

use all4art_authservice_domain::user::User;

pub struct SubscribeCommandResult { 
    _user: Arc<dyn User>
}

impl SubscribeCommandResult { 
    pub fn new(user: Arc<dyn User>) -> Self { 
        SubscribeCommandResult{_user: user} 
    }

    pub fn user(&self) -> Arc<dyn User> { 
        self._user.clone()
    }
}
