use std::process::Command;

use crate::{commands::SubscribeCommand, command_results::SubscribeCommandResult, queries::LoginQuery, handlers::{QueryHandler, SubscribeCommandHandler, LoginQueryHandler}, query_results::LoginQueryResult};

use super::handlers::CommandHandler;

pub trait CommandHandlerFactory { 
    fn create_subscribe_command_handler(&self, command: SubscribeCommand) 
    -> Box<dyn CommandHandler<SubscribeCommandResult>>;
}

pub trait QueryHandlerFactory { 
    fn create_login_query_handler(&self, query: LoginQuery) -> Box<dyn QueryHandler<LoginQueryResult>>;
}

pub struct CommandHandlerFactoryImpl { 
}

impl CommandHandlerFactory for CommandHandlerFactoryImpl { 
    fn create_subscribe_command_handler(&self, command: SubscribeCommand) 
    -> Box<dyn CommandHandler<SubscribeCommandResult>> {
        Box::new(SubscribeCommandHandler::new(command))
    }
}

impl CommandHandlerFactoryImpl {
    pub fn new() -> impl CommandHandlerFactory { 
        CommandHandlerFactoryImpl{}
    }
}

pub struct QueryHandlerFactoryImpl { 
}

impl QueryHandlerFactoryImpl { 
    pub fn new() -> impl QueryHandlerFactory { 
        QueryHandlerFactoryImpl{}        
    }
}

impl QueryHandlerFactory for QueryHandlerFactoryImpl { 
    fn create_login_query_handler(&self, query: LoginQuery) -> Box<dyn QueryHandler<LoginQueryResult>> { 
        Box::new(LoginQueryHandler::new(query))
    }
}
