use super::commands::SubscribeCommand;
use super::command_results::SubscribeCommandResult;
use super::queries::LoginQuery;
use super::query_results::LoginQueryResult;


pub trait QueryHandler<T> { 
    fn retrieve(&self) -> Result<T, std::io::Error>;
}

pub trait CommandHandler<T> { 
    fn execute(&self) -> Result<T, std::io::Error>;
}

pub struct SubscribeCommandHandler { 
    command: SubscribeCommand,
}

impl SubscribeCommandHandler { 
    pub fn new(command: SubscribeCommand) -> Self { 
       SubscribeCommandHandler {command: command} 
    }
}

impl CommandHandler<SubscribeCommandResult> for SubscribeCommandHandler { 
     fn execute(&self) -> Result<SubscribeCommandResult, std::io::Error> { 
        println!("executing");
        Ok(SubscribeCommandResult{})
    }
}

pub struct LoginQueryHandler {
    query: LoginQuery
}

impl LoginQueryHandler { 
    pub fn new(query: LoginQuery) -> Self { 
        LoginQueryHandler {query: query}
    }
}

impl QueryHandler<LoginQueryResult> for LoginQueryHandler { 
    fn retrieve(&self) -> Result<LoginQueryResult, std::io::Error> { 
        println!("retrieving");
        Ok(LoginQueryResult{})
    }
}


