# alass-ffi

![Crates.io](https://img.shields.io/crates/v/alass-util)
![Build](https://github.com/Wsiegenthaler/alass-ffi/workflows/Build/badge.svg)
![minimum rustc 1.40](https://img.shields.io/badge/rustc-1.40+-red.svg)
[![License](https://img.shields.io/badge/License-GPL--3.0-blue.svg)](https://opensource.org/licenses/GPL-3.0)

*FFI bindings for subtitle synchronization with `alass-core`*

`alass-core` is a fantastic library which performs fast and accurate subtitle synchronization. This wrapper library provides FFI bindings so such functionality can be used by other languages like C, Python, Java, or any language which can interface with native libraries.

## API

### Docs

See the generated [header file](https://github.com/wsiegenthaler/alass-ffi/tree/master/dist/alass.h) for API documentation. The `alass_sync` call is the API's main operation and a good place to start.

*Note that this header is checked into git for informational purposes and will not reflect any changes you may have made to your working copy. See the `target/` directory for the up-to-date version generated by your build.*

### Example

An example C application demonstrating usage of the API can be found in the [`ffi/examples/sync-demo/`](https://github.com/Wsiegenthaler/alass-ffi/tree/master/ffi/examples/sync-demo) folder. The example provides a basic CLI utility for syncing subtitles from the command line and can be built and run using the `sync-demo.sh` helper script.

## Releases

Pre-built binaries for several common architectures are available in the [releases](https://github.com/Wsiegenthaler/alass-ffi/releases) section. Additional architectures can be made available upon request.

## Building

You will need Rust 1.40+ and Cargo installed to build `alass-ffi`.

```shell
$ cargo build --release [--target ARCH]
```
Build artifacts can be found within the `target` directory.

## License

Everything in this repo is GPL-3.0 unless otherwise specified
