/*
 * Airbyte Configuration API
 *
 * Airbyte Configuration API [https://airbyte.io](https://airbyte.io).  This API is a collection of HTTP RPC-style methods. While it is not a REST API, those familiar with REST should find the conventions of this API recognizable.  Here are some conventions that this API follows: * All endpoints are http POST methods. * All endpoints accept data via `application/json` request bodies. The API does not accept any data via query params. * The naming convention for endpoints is: localhost:8000/{VERSION}/{METHOD_FAMILY}/{METHOD_NAME} e.g. `localhost:8000/v1/connections/create`. * For all `update` methods, the whole object must be passed in, even the fields that did not change.  Change Management: * The major version of the API endpoint can be determined / specified in the URL `localhost:8080/v1/connections/create` * Minor version bumps will be invisible to the end user. The user cannot specify minor versions in requests. * All backwards incompatible changes will happen in major version bumps. We will not make backwards incompatible changes in minor version bumps. Examples of non-breaking changes (includes but not limited to...):   * Adding fields to request or response bodies.   * Adding new HTTP endpoints. * All `web_backend` APIs are not considered public APIs and are not guaranteeing backwards compatibility.
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: contact@airbyte.io
 * Generated by: https://openapi-generator.tech
 */

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct WebBackendConnectionUpdate {
    /// Name that will be set to the connection
    #[serde(rename = "name", skip_serializing_if = "Option::is_none")]
    pub name: Option<String>,
    #[serde(rename = "connectionId")]
    pub connection_id: String,
    #[serde(
        rename = "namespaceDefinition",
        skip_serializing_if = "Option::is_none"
    )]
    pub namespace_definition: Option<crate::models::NamespaceDefinitionType>,
    /// Used when namespaceDefinition is 'customformat'. If blank then behaves like namespaceDefinition = 'destination'. If \"${SOURCE_NAMESPACE}\" then behaves like namespaceDefinition = 'source'.
    #[serde(rename = "namespaceFormat", skip_serializing_if = "Option::is_none")]
    pub namespace_format: Option<String>,
    /// Prefix that will be prepended to the name of each stream when it is written to the destination.
    #[serde(rename = "prefix", skip_serializing_if = "Option::is_none")]
    pub prefix: Option<String>,
    #[serde(rename = "operationIds", skip_serializing_if = "Option::is_none")]
    pub operation_ids: Option<Vec<String>>,
    #[serde(rename = "syncCatalog")]
    pub sync_catalog: Box<crate::models::AirbyteCatalog>,
    #[serde(rename = "schedule", skip_serializing_if = "Option::is_none")]
    pub schedule: Option<Box<crate::models::ConnectionSchedule>>,
    #[serde(rename = "status")]
    pub status: crate::models::ConnectionStatus,
    #[serde(
        rename = "resourceRequirements",
        skip_serializing_if = "Option::is_none"
    )]
    pub resource_requirements: Option<Box<crate::models::ResourceRequirements>>,
    #[serde(
        rename = "withRefreshedCatalog",
        skip_serializing_if = "Option::is_none"
    )]
    pub with_refreshed_catalog: Option<bool>,
    #[serde(rename = "operations", skip_serializing_if = "Option::is_none")]
    pub operations: Option<Vec<crate::models::WebBackendOperationCreateOrUpdate>>,
}

impl WebBackendConnectionUpdate {
    pub fn new(
        connection_id: String,
        sync_catalog: crate::models::AirbyteCatalog,
        status: crate::models::ConnectionStatus,
    ) -> WebBackendConnectionUpdate {
        WebBackendConnectionUpdate {
            name: None,
            connection_id,
            namespace_definition: None,
            namespace_format: None,
            prefix: None,
            operation_ids: None,
            sync_catalog: Box::new(sync_catalog),
            schedule: None,
            status,
            resource_requirements: None,
            with_refreshed_catalog: None,
            operations: None,
        }
    }
}
