/*
 * Airbyte Configuration API
 *
 * Airbyte Configuration API [https://airbyte.io](https://airbyte.io).  This API is a collection of HTTP RPC-style methods. While it is not a REST API, those familiar with REST should find the conventions of this API recognizable.  Here are some conventions that this API follows: * All endpoints are http POST methods. * All endpoints accept data via `application/json` request bodies. The API does not accept any data via query params. * The naming convention for endpoints is: localhost:8000/{VERSION}/{METHOD_FAMILY}/{METHOD_NAME} e.g. `localhost:8000/v1/connections/create`. * For all `update` methods, the whole object must be passed in, even the fields that did not change.  Change Management: * The major version of the API endpoint can be determined / specified in the URL `localhost:8080/v1/connections/create` * Minor version bumps will be invisible to the end user. The user cannot specify minor versions in requests. * All backwards incompatible changes will happen in major version bumps. We will not make backwards incompatible changes in minor version bumps. Examples of non-breaking changes (includes but not limited to...):   * Adding fields to request or response bodies.   * Adding new HTTP endpoints. * All `web_backend` APIs are not considered public APIs and are not guaranteeing backwards compatibility.
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: contact@airbyte.io
 * Generated by: https://openapi-generator.tech
 */

/// JobType : enum that describes the different types of jobs that the platform runs.

/// enum that describes the different types of jobs that the platform runs.
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum JobType {
    #[serde(rename = "get_spec")]
    GetSpec,
    #[serde(rename = "check_connection")]
    CheckConnection,
    #[serde(rename = "discover_schema")]
    DiscoverSchema,
    #[serde(rename = "sync")]
    Sync,
    #[serde(rename = "reset_connection")]
    ResetConnection,
    #[serde(rename = "connection_updater")]
    ConnectionUpdater,
    #[serde(rename = "replicate")]
    Replicate,
}

impl ToString for JobType {
    fn to_string(&self) -> String {
        match self {
            Self::GetSpec => String::from("get_spec"),
            Self::CheckConnection => String::from("check_connection"),
            Self::DiscoverSchema => String::from("discover_schema"),
            Self::Sync => String::from("sync"),
            Self::ResetConnection => String::from("reset_connection"),
            Self::ConnectionUpdater => String::from("connection_updater"),
            Self::Replicate => String::from("replicate"),
        }
    }
}

impl Default for JobType {
    fn default() -> JobType {
        Self::GetSpec
    }
}
