# \ConnectionApi

All URIs are relative to *http://localhost:8000/api*

Method | HTTP request | Description
------------- | ------------- | -------------
[**create_connection**](ConnectionApi.md#create_connection) | **POST** /v1/connections/create | Create a connection between a source and a destination
[**delete_connection**](ConnectionApi.md#delete_connection) | **POST** /v1/connections/delete | Delete a connection
[**get_connection**](ConnectionApi.md#get_connection) | **POST** /v1/connections/get | Get a connection
[**get_state**](ConnectionApi.md#get_state) | **POST** /v1/state/get | Fetch the current state for a connection.
[**list_all_connections_for_workspace**](ConnectionApi.md#list_all_connections_for_workspace) | **POST** /v1/connections/list_all | Returns all connections for a workspace, including deleted connections.
[**list_connections_for_workspace**](ConnectionApi.md#list_connections_for_workspace) | **POST** /v1/connections/list | Returns all connections for a workspace.
[**reset_connection**](ConnectionApi.md#reset_connection) | **POST** /v1/connections/reset | Reset the data for the connection. Deletes data generated by the connection in the destination. Resets any cursors back to initial state.
[**search_connections**](ConnectionApi.md#search_connections) | **POST** /v1/connections/search | Search connections
[**sync_connection**](ConnectionApi.md#sync_connection) | **POST** /v1/connections/sync | Trigger a manual sync of the connection
[**update_connection**](ConnectionApi.md#update_connection) | **POST** /v1/connections/update | Update a connection



## create_connection

> crate::models::ConnectionRead create_connection(connection_create)
Create a connection between a source and a destination

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**connection_create** | [**ConnectionCreate**](ConnectionCreate.md) |  | [required] |

### Return type

[**crate::models::ConnectionRead**](ConnectionRead.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## delete_connection

> delete_connection(connection_id_request_body)
Delete a connection

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**connection_id_request_body** | [**ConnectionIdRequestBody**](ConnectionIdRequestBody.md) |  | [required] |

### Return type

 (empty response body)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_connection

> crate::models::ConnectionRead get_connection(connection_id_request_body)
Get a connection

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**connection_id_request_body** | [**ConnectionIdRequestBody**](ConnectionIdRequestBody.md) |  | [required] |

### Return type

[**crate::models::ConnectionRead**](ConnectionRead.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## get_state

> crate::models::ConnectionState get_state(connection_id_request_body)
Fetch the current state for a connection.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**connection_id_request_body** | [**ConnectionIdRequestBody**](ConnectionIdRequestBody.md) |  | [required] |

### Return type

[**crate::models::ConnectionState**](ConnectionState.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## list_all_connections_for_workspace

> crate::models::ConnectionReadList list_all_connections_for_workspace(workspace_id_request_body)
Returns all connections for a workspace, including deleted connections.

List connections for workspace, including deleted connections.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**workspace_id_request_body** | [**WorkspaceIdRequestBody**](WorkspaceIdRequestBody.md) |  | [required] |

### Return type

[**crate::models::ConnectionReadList**](ConnectionReadList.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## list_connections_for_workspace

> crate::models::ConnectionReadList list_connections_for_workspace(workspace_id_request_body)
Returns all connections for a workspace.

List connections for workspace. Does not return deleted connections.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**workspace_id_request_body** | [**WorkspaceIdRequestBody**](WorkspaceIdRequestBody.md) |  | [required] |

### Return type

[**crate::models::ConnectionReadList**](ConnectionReadList.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## reset_connection

> crate::models::JobInfoRead reset_connection(connection_id_request_body)
Reset the data for the connection. Deletes data generated by the connection in the destination. Resets any cursors back to initial state.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**connection_id_request_body** | [**ConnectionIdRequestBody**](ConnectionIdRequestBody.md) |  | [required] |

### Return type

[**crate::models::JobInfoRead**](JobInfoRead.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## search_connections

> crate::models::ConnectionReadList search_connections(connection_search)
Search connections

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**connection_search** | [**ConnectionSearch**](ConnectionSearch.md) |  | [required] |

### Return type

[**crate::models::ConnectionReadList**](ConnectionReadList.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## sync_connection

> crate::models::JobInfoRead sync_connection(connection_id_request_body)
Trigger a manual sync of the connection

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**connection_id_request_body** | [**ConnectionIdRequestBody**](ConnectionIdRequestBody.md) |  | [required] |

### Return type

[**crate::models::JobInfoRead**](JobInfoRead.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## update_connection

> crate::models::ConnectionRead update_connection(connection_update)
Update a connection

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**connection_update** | [**ConnectionUpdate**](ConnectionUpdate.md) |  | [required] |

### Return type

[**crate::models::ConnectionRead**](ConnectionRead.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: application/json
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

