# Rust API client for airbyte_client

Airbyte Configuration API
[https://airbyte.io](https://airbyte.io).

This API is a collection of HTTP RPC-style methods. While it is not a REST API, those familiar with REST should find the conventions of this API recognizable.

Here are some conventions that this API follows:
* All endpoints are http POST methods.
* All endpoints accept data via `application/json` request bodies. The API does not accept any data via query params.
* The naming convention for endpoints is: localhost:8000/{VERSION}/{METHOD_FAMILY}/{METHOD_NAME} e.g. `localhost:8000/v1/connections/create`.
* For all `update` methods, the whole object must be passed in, even the fields that did not change.

Change Management:
* The major version of the API endpoint can be determined / specified in the URL `localhost:8080/v1/connections/create`
* Minor version bumps will be invisible to the end user. The user cannot specify minor versions in requests.
* All backwards incompatible changes will happen in major version bumps. We will not make backwards incompatible changes in minor version bumps. Examples of non-breaking changes (includes but not limited to...):
  * Adding fields to request or response bodies.
  * Adding new HTTP endpoints.
* All `web_backend` APIs are not considered public APIs and are not guaranteeing backwards compatibility.



## Overview

This API client was generated by the [OpenAPI Generator](https://openapi-generator.tech) project.  By using the [openapi-spec](https://openapis.org) from a remote server, you can easily generate an API client.

- API version: 1.0.0
- Package version: 0.0.2
- Build package: `org.openapitools.codegen.languages.RustClientCodegen`

## Installation

Put the package under your project folder in a directory named `airbyte_client` and add the following to `Cargo.toml` under `[dependencies]`:

```
airbyte_client = { path = "./airbyte_client" }
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8000/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConnectionApi* | [**create_connection**](docs/ConnectionApi.md#create_connection) | **POST** /v1/connections/create | Create a connection between a source and a destination
*ConnectionApi* | [**delete_connection**](docs/ConnectionApi.md#delete_connection) | **POST** /v1/connections/delete | Delete a connection
*ConnectionApi* | [**get_connection**](docs/ConnectionApi.md#get_connection) | **POST** /v1/connections/get | Get a connection
*ConnectionApi* | [**get_state**](docs/ConnectionApi.md#get_state) | **POST** /v1/state/get | Fetch the current state for a connection.
*ConnectionApi* | [**list_all_connections_for_workspace**](docs/ConnectionApi.md#list_all_connections_for_workspace) | **POST** /v1/connections/list_all | Returns all connections for a workspace, including deleted connections.
*ConnectionApi* | [**list_connections_for_workspace**](docs/ConnectionApi.md#list_connections_for_workspace) | **POST** /v1/connections/list | Returns all connections for a workspace.
*ConnectionApi* | [**reset_connection**](docs/ConnectionApi.md#reset_connection) | **POST** /v1/connections/reset | Reset the data for the connection. Deletes data generated by the connection in the destination. Resets any cursors back to initial state.
*ConnectionApi* | [**search_connections**](docs/ConnectionApi.md#search_connections) | **POST** /v1/connections/search | Search connections
*ConnectionApi* | [**sync_connection**](docs/ConnectionApi.md#sync_connection) | **POST** /v1/connections/sync | Trigger a manual sync of the connection
*ConnectionApi* | [**update_connection**](docs/ConnectionApi.md#update_connection) | **POST** /v1/connections/update | Update a connection
*DbMigrationApi* | [**execute_migrations**](docs/DbMigrationApi.md#execute_migrations) | **POST** /v1/db_migrations/migrate | Migrate the database to the latest version
*DbMigrationApi* | [**list_migrations**](docs/DbMigrationApi.md#list_migrations) | **POST** /v1/db_migrations/list | List all database migrations
*DeploymentApi* | [**export_archive**](docs/DeploymentApi.md#export_archive) | **POST** /v1/deployment/export | Export Airbyte Configuration and Data Archive
*DeploymentApi* | [**export_workspace**](docs/DeploymentApi.md#export_workspace) | **POST** /v1/deployment/export_workspace | Export Airbyte Workspace Configuration
*DeploymentApi* | [**import_archive**](docs/DeploymentApi.md#import_archive) | **POST** /v1/deployment/import | Import Airbyte Configuration and Data Archive
*DeploymentApi* | [**import_into_workspace**](docs/DeploymentApi.md#import_into_workspace) | **POST** /v1/deployment/import_into_workspace | Import Airbyte Configuration into Workspace (this operation might change ids of imported configurations). Note, in order to use this api endpoint, you might need to upload a temporary archive resource with 'deployment/upload_archive_resource' first 
*DeploymentApi* | [**upload_archive_resource**](docs/DeploymentApi.md#upload_archive_resource) | **POST** /v1/deployment/upload_archive_resource | Upload a GZIP archive tarball and stage it in the server's cache as a temporary resource
*DestinationApi* | [**check_connection_to_destination**](docs/DestinationApi.md#check_connection_to_destination) | **POST** /v1/destinations/check_connection | Check connection to the destination
*DestinationApi* | [**check_connection_to_destination_for_update**](docs/DestinationApi.md#check_connection_to_destination_for_update) | **POST** /v1/destinations/check_connection_for_update | Check connection for a proposed update to a destination
*DestinationApi* | [**clone_destination**](docs/DestinationApi.md#clone_destination) | **POST** /v1/destinations/clone | Clone destination
*DestinationApi* | [**create_destination**](docs/DestinationApi.md#create_destination) | **POST** /v1/destinations/create | Create a destination
*DestinationApi* | [**delete_destination**](docs/DestinationApi.md#delete_destination) | **POST** /v1/destinations/delete | Delete the destination
*DestinationApi* | [**get_destination**](docs/DestinationApi.md#get_destination) | **POST** /v1/destinations/get | Get configured destination
*DestinationApi* | [**list_destinations_for_workspace**](docs/DestinationApi.md#list_destinations_for_workspace) | **POST** /v1/destinations/list | List configured destinations for a workspace
*DestinationApi* | [**search_destinations**](docs/DestinationApi.md#search_destinations) | **POST** /v1/destinations/search | Search destinations
*DestinationApi* | [**update_destination**](docs/DestinationApi.md#update_destination) | **POST** /v1/destinations/update | Update a destination
*DestinationDefinitionApi* | [**create_custom_destination_definition**](docs/DestinationDefinitionApi.md#create_custom_destination_definition) | **POST** /v1/destination_definitions/create_custom | Creates a custom destinationDefinition for the given workspace
*DestinationDefinitionApi* | [**create_destination_definition**](docs/DestinationDefinitionApi.md#create_destination_definition) | **POST** /v1/destination_definitions/create | Creates a destinationsDefinition
*DestinationDefinitionApi* | [**delete_custom_destination_definition**](docs/DestinationDefinitionApi.md#delete_custom_destination_definition) | **POST** /v1/destination_definitions/delete_custom | Delete a custom destination definition for the given workspace
*DestinationDefinitionApi* | [**delete_destination_definition**](docs/DestinationDefinitionApi.md#delete_destination_definition) | **POST** /v1/destination_definitions/delete | Delete a destination definition
*DestinationDefinitionApi* | [**get_destination_definition**](docs/DestinationDefinitionApi.md#get_destination_definition) | **POST** /v1/destination_definitions/get | Get destinationDefinition
*DestinationDefinitionApi* | [**get_destination_definition_for_workspace**](docs/DestinationDefinitionApi.md#get_destination_definition_for_workspace) | **POST** /v1/destination_definitions/get_for_workspace | Get a destinationDefinition that is configured for the given workspace
*DestinationDefinitionApi* | [**grant_destination_definition_to_workspace**](docs/DestinationDefinitionApi.md#grant_destination_definition_to_workspace) | **POST** /v1/destination_definitions/grant_definition | grant a private, non-custom destinationDefinition to a given workspace
*DestinationDefinitionApi* | [**list_destination_definitions**](docs/DestinationDefinitionApi.md#list_destination_definitions) | **POST** /v1/destination_definitions/list | List all the destinationDefinitions the current Airbyte deployment is configured to use
*DestinationDefinitionApi* | [**list_destination_definitions_for_workspace**](docs/DestinationDefinitionApi.md#list_destination_definitions_for_workspace) | **POST** /v1/destination_definitions/list_for_workspace | List all the destinationDefinitions the given workspace is configured to use
*DestinationDefinitionApi* | [**list_latest_destination_definitions**](docs/DestinationDefinitionApi.md#list_latest_destination_definitions) | **POST** /v1/destination_definitions/list_latest | List the latest destinationDefinitions Airbyte supports
*DestinationDefinitionApi* | [**list_private_destination_definitions**](docs/DestinationDefinitionApi.md#list_private_destination_definitions) | **POST** /v1/destination_definitions/list_private | List all private, non-custom destinationDefinitions, and for each indicate whether the given workspace has a grant for using the definition. Used by admins to view and modify a given workspace's grants.
*DestinationDefinitionApi* | [**revoke_destination_definition_from_workspace**](docs/DestinationDefinitionApi.md#revoke_destination_definition_from_workspace) | **POST** /v1/destination_definitions/revoke_definition | revoke a grant to a private, non-custom destinationDefinition from a given workspace
*DestinationDefinitionApi* | [**update_custom_destination_definition**](docs/DestinationDefinitionApi.md#update_custom_destination_definition) | **POST** /v1/destination_definitions/update_custom | Update a custom destinationDefinition for the given workspace
*DestinationDefinitionApi* | [**update_destination_definition**](docs/DestinationDefinitionApi.md#update_destination_definition) | **POST** /v1/destination_definitions/update | Update destinationDefinition
*DestinationDefinitionSpecificationApi* | [**get_destination_definition_specification**](docs/DestinationDefinitionSpecificationApi.md#get_destination_definition_specification) | **POST** /v1/destination_definition_specifications/get | Get specification for a destinationDefinition
*HealthApi* | [**get_health_check**](docs/HealthApi.md#get_health_check) | **GET** /v1/health | Health Check
*JobsApi* | [**cancel_job**](docs/JobsApi.md#cancel_job) | **POST** /v1/jobs/cancel | Cancels a job
*JobsApi* | [**get_job_debug_info**](docs/JobsApi.md#get_job_debug_info) | **POST** /v1/jobs/get_debug_info | Gets all information needed to debug this job
*JobsApi* | [**get_job_info**](docs/JobsApi.md#get_job_info) | **POST** /v1/jobs/get | Get information about a job
*JobsApi* | [**list_jobs_for**](docs/JobsApi.md#list_jobs_for) | **POST** /v1/jobs/list | Returns recent jobs for a connection. Jobs are returned in descending order by createdAt.
*LogsApi* | [**get_logs**](docs/LogsApi.md#get_logs) | **POST** /v1/logs/get | Get logs
*NotificationsApi* | [**try_notification_config**](docs/NotificationsApi.md#try_notification_config) | **POST** /v1/notifications/try | Try sending a notifications
*OauthApi* | [**complete_destination_o_auth**](docs/OauthApi.md#complete_destination_o_auth) | **POST** /v1/destination_oauths/complete_oauth | Given a destination def ID generate an access/refresh token etc.
*OauthApi* | [**complete_source_o_auth**](docs/OauthApi.md#complete_source_o_auth) | **POST** /v1/source_oauths/complete_oauth | Given a source def ID generate an access/refresh token etc.
*OauthApi* | [**get_destination_o_auth_consent**](docs/OauthApi.md#get_destination_o_auth_consent) | **POST** /v1/destination_oauths/get_consent_url | Given a destination connector definition ID, return the URL to the consent screen where to redirect the user to.
*OauthApi* | [**get_source_o_auth_consent**](docs/OauthApi.md#get_source_o_auth_consent) | **POST** /v1/source_oauths/get_consent_url | Given a source connector definition ID, return the URL to the consent screen where to redirect the user to.
*OauthApi* | [**set_instancewide_destination_oauth_params**](docs/OauthApi.md#set_instancewide_destination_oauth_params) | **POST** /v1/destination_oauths/oauth_params/create | Sets instancewide variables to be used for the oauth flow when creating this destination. When set, these variables will be injected into a connector's configuration before any interaction with the connector image itself. This enables running oauth flows with consistent variables e.g: the company's Google Ads developer_token, client_id, and client_secret without the user having to know about these variables. 
*OauthApi* | [**set_instancewide_source_oauth_params**](docs/OauthApi.md#set_instancewide_source_oauth_params) | **POST** /v1/source_oauths/oauth_params/create | Sets instancewide variables to be used for the oauth flow when creating this source. When set, these variables will be injected into a connector's configuration before any interaction with the connector image itself. This enables running oauth flows with consistent variables e.g: the company's Google Ads developer_token, client_id, and client_secret without the user having to know about these variables. 
*OpenapiApi* | [**get_open_api_spec**](docs/OpenapiApi.md#get_open_api_spec) | **GET** /v1/openapi | Returns the openapi specification
*OperationApi* | [**check_operation**](docs/OperationApi.md#check_operation) | **POST** /v1/operations/check | Check if an operation to be created is valid
*OperationApi* | [**create_operation**](docs/OperationApi.md#create_operation) | **POST** /v1/operations/create | Create an operation to be applied as part of a connection pipeline
*OperationApi* | [**delete_operation**](docs/OperationApi.md#delete_operation) | **POST** /v1/operations/delete | Delete an operation
*OperationApi* | [**get_operation**](docs/OperationApi.md#get_operation) | **POST** /v1/operations/get | Returns an operation
*OperationApi* | [**list_operations_for_connection**](docs/OperationApi.md#list_operations_for_connection) | **POST** /v1/operations/list | Returns all operations for a connection.
*OperationApi* | [**update_operation**](docs/OperationApi.md#update_operation) | **POST** /v1/operations/update | Update an operation
*SchedulerApi* | [**execute_destination_check_connection**](docs/SchedulerApi.md#execute_destination_check_connection) | **POST** /v1/scheduler/destinations/check_connection | Run check connection for a given destination configuration
*SchedulerApi* | [**execute_source_check_connection**](docs/SchedulerApi.md#execute_source_check_connection) | **POST** /v1/scheduler/sources/check_connection | Run check connection for a given source configuration
*SchedulerApi* | [**execute_source_discover_schema**](docs/SchedulerApi.md#execute_source_discover_schema) | **POST** /v1/scheduler/sources/discover_schema | Run discover schema for a given source a source configuration
*SourceApi* | [**check_connection_to_source**](docs/SourceApi.md#check_connection_to_source) | **POST** /v1/sources/check_connection | Check connection to the source
*SourceApi* | [**check_connection_to_source_for_update**](docs/SourceApi.md#check_connection_to_source_for_update) | **POST** /v1/sources/check_connection_for_update | Check connection for a proposed update to a source
*SourceApi* | [**clone_source**](docs/SourceApi.md#clone_source) | **POST** /v1/sources/clone | Clone source
*SourceApi* | [**create_source**](docs/SourceApi.md#create_source) | **POST** /v1/sources/create | Create a source
*SourceApi* | [**delete_source**](docs/SourceApi.md#delete_source) | **POST** /v1/sources/delete | Delete a source
*SourceApi* | [**discover_schema_for_source**](docs/SourceApi.md#discover_schema_for_source) | **POST** /v1/sources/discover_schema | Discover the schema catalog of the source
*SourceApi* | [**get_source**](docs/SourceApi.md#get_source) | **POST** /v1/sources/get | Get source
*SourceApi* | [**list_sources_for_workspace**](docs/SourceApi.md#list_sources_for_workspace) | **POST** /v1/sources/list | List sources for workspace
*SourceApi* | [**search_sources**](docs/SourceApi.md#search_sources) | **POST** /v1/sources/search | Search sources
*SourceApi* | [**update_source**](docs/SourceApi.md#update_source) | **POST** /v1/sources/update | Update a source
*SourceDefinitionApi* | [**create_custom_source_definition**](docs/SourceDefinitionApi.md#create_custom_source_definition) | **POST** /v1/source_definitions/create_custom | Creates a custom sourceDefinition for the given workspace
*SourceDefinitionApi* | [**create_source_definition**](docs/SourceDefinitionApi.md#create_source_definition) | **POST** /v1/source_definitions/create | Creates a sourceDefinition
*SourceDefinitionApi* | [**delete_custom_source_definition**](docs/SourceDefinitionApi.md#delete_custom_source_definition) | **POST** /v1/source_definitions/delete_custom | Delete a custom source definition for the given workspace
*SourceDefinitionApi* | [**delete_source_definition**](docs/SourceDefinitionApi.md#delete_source_definition) | **POST** /v1/source_definitions/delete | Delete a source definition
*SourceDefinitionApi* | [**get_source_definition**](docs/SourceDefinitionApi.md#get_source_definition) | **POST** /v1/source_definitions/get | Get source
*SourceDefinitionApi* | [**get_source_definition_for_workspace**](docs/SourceDefinitionApi.md#get_source_definition_for_workspace) | **POST** /v1/source_definitions/get_for_workspace | Get a sourceDefinition that is configured for the given workspace
*SourceDefinitionApi* | [**grant_source_definition_to_workspace**](docs/SourceDefinitionApi.md#grant_source_definition_to_workspace) | **POST** /v1/source_definitions/grant_definition | grant a private, non-custom sourceDefinition to a given workspace
*SourceDefinitionApi* | [**list_latest_source_definitions**](docs/SourceDefinitionApi.md#list_latest_source_definitions) | **POST** /v1/source_definitions/list_latest | List the latest sourceDefinitions Airbyte supports
*SourceDefinitionApi* | [**list_private_source_definitions**](docs/SourceDefinitionApi.md#list_private_source_definitions) | **POST** /v1/source_definitions/list_private | List all private, non-custom sourceDefinitions, and for each indicate whether the given workspace has a grant for using the definition. Used by admins to view and modify a given workspace's grants.
*SourceDefinitionApi* | [**list_source_definitions**](docs/SourceDefinitionApi.md#list_source_definitions) | **POST** /v1/source_definitions/list | List all the sourceDefinitions the current Airbyte deployment is configured to use
*SourceDefinitionApi* | [**list_source_definitions_for_workspace**](docs/SourceDefinitionApi.md#list_source_definitions_for_workspace) | **POST** /v1/source_definitions/list_for_workspace | List all the sourceDefinitions the given workspace is configured to use
*SourceDefinitionApi* | [**revoke_source_definition_from_workspace**](docs/SourceDefinitionApi.md#revoke_source_definition_from_workspace) | **POST** /v1/source_definitions/revoke_definition | revoke a grant to a private, non-custom sourceDefinition from a given workspace
*SourceDefinitionApi* | [**update_custom_source_definition**](docs/SourceDefinitionApi.md#update_custom_source_definition) | **POST** /v1/source_definitions/update_custom | Update a custom sourceDefinition for the given workspace
*SourceDefinitionApi* | [**update_source_definition**](docs/SourceDefinitionApi.md#update_source_definition) | **POST** /v1/source_definitions/update | Update a sourceDefinition
*SourceDefinitionSpecificationApi* | [**get_source_definition_specification**](docs/SourceDefinitionSpecificationApi.md#get_source_definition_specification) | **POST** /v1/source_definition_specifications/get | Get specification for a SourceDefinition.
*WebBackendApi* | [**web_backend_create_connection**](docs/WebBackendApi.md#web_backend_create_connection) | **POST** /v1/web_backend/connections/create | Create a connection
*WebBackendApi* | [**web_backend_get_connection**](docs/WebBackendApi.md#web_backend_get_connection) | **POST** /v1/web_backend/connections/get | Get a connection
*WebBackendApi* | [**web_backend_get_workspace_state**](docs/WebBackendApi.md#web_backend_get_workspace_state) | **POST** /v1/web_backend/workspace/state | Returns the current state of a workspace
*WebBackendApi* | [**web_backend_list_all_connections_for_workspace**](docs/WebBackendApi.md#web_backend_list_all_connections_for_workspace) | **POST** /v1/web_backend/connections/list_all | Returns all connections for a workspace.
*WebBackendApi* | [**web_backend_list_connections_for_workspace**](docs/WebBackendApi.md#web_backend_list_connections_for_workspace) | **POST** /v1/web_backend/connections/list | Returns all non-deleted connections for a workspace.
*WebBackendApi* | [**web_backend_search_connections**](docs/WebBackendApi.md#web_backend_search_connections) | **POST** /v1/web_backend/connections/search | Search connections
*WebBackendApi* | [**web_backend_update_connection**](docs/WebBackendApi.md#web_backend_update_connection) | **POST** /v1/web_backend/connections/update | Update a connection
*WorkspaceApi* | [**create_workspace**](docs/WorkspaceApi.md#create_workspace) | **POST** /v1/workspaces/create | Creates a workspace
*WorkspaceApi* | [**delete_workspace**](docs/WorkspaceApi.md#delete_workspace) | **POST** /v1/workspaces/delete | Deletes a workspace
*WorkspaceApi* | [**get_workspace**](docs/WorkspaceApi.md#get_workspace) | **POST** /v1/workspaces/get | Find workspace by ID
*WorkspaceApi* | [**get_workspace_by_slug**](docs/WorkspaceApi.md#get_workspace_by_slug) | **POST** /v1/workspaces/get_by_slug | Find workspace by slug
*WorkspaceApi* | [**list_workspaces**](docs/WorkspaceApi.md#list_workspaces) | **POST** /v1/workspaces/list | List all workspaces registered in the current Airbyte deployment
*WorkspaceApi* | [**update_workspace**](docs/WorkspaceApi.md#update_workspace) | **POST** /v1/workspaces/update | Update workspace state
*WorkspaceApi* | [**update_workspace_feedback**](docs/WorkspaceApi.md#update_workspace_feedback) | **POST** /v1/workspaces/tag_feedback_status_as_done | Update workspace feedback state
*WorkspaceApi* | [**update_workspace_name**](docs/WorkspaceApi.md#update_workspace_name) | **POST** /v1/workspaces/update_name | Update workspace name


## Documentation For Models

 - [ActorDefinitionResourceRequirements](docs/ActorDefinitionResourceRequirements.md)
 - [AdvancedAuth](docs/AdvancedAuth.md)
 - [AirbyteCatalog](docs/AirbyteCatalog.md)
 - [AirbyteStream](docs/AirbyteStream.md)
 - [AirbyteStreamAndConfiguration](docs/AirbyteStreamAndConfiguration.md)
 - [AirbyteStreamConfiguration](docs/AirbyteStreamConfiguration.md)
 - [AttemptFailureOrigin](docs/AttemptFailureOrigin.md)
 - [AttemptFailureReason](docs/AttemptFailureReason.md)
 - [AttemptFailureSummary](docs/AttemptFailureSummary.md)
 - [AttemptFailureType](docs/AttemptFailureType.md)
 - [AttemptInfoRead](docs/AttemptInfoRead.md)
 - [AttemptRead](docs/AttemptRead.md)
 - [AttemptStats](docs/AttemptStats.md)
 - [AttemptStatus](docs/AttemptStatus.md)
 - [AttemptStreamStats](docs/AttemptStreamStats.md)
 - [AuthSpecification](docs/AuthSpecification.md)
 - [CheckConnectionRead](docs/CheckConnectionRead.md)
 - [CheckOperationRead](docs/CheckOperationRead.md)
 - [CompleteDestinationOAuthRequest](docs/CompleteDestinationOAuthRequest.md)
 - [CompleteSourceOauthRequest](docs/CompleteSourceOauthRequest.md)
 - [ConnectionCreate](docs/ConnectionCreate.md)
 - [ConnectionIdRequestBody](docs/ConnectionIdRequestBody.md)
 - [ConnectionRead](docs/ConnectionRead.md)
 - [ConnectionReadList](docs/ConnectionReadList.md)
 - [ConnectionSchedule](docs/ConnectionSchedule.md)
 - [ConnectionSearch](docs/ConnectionSearch.md)
 - [ConnectionState](docs/ConnectionState.md)
 - [ConnectionStatus](docs/ConnectionStatus.md)
 - [ConnectionUpdate](docs/ConnectionUpdate.md)
 - [CustomDestinationDefinitionCreate](docs/CustomDestinationDefinitionCreate.md)
 - [CustomDestinationDefinitionUpdate](docs/CustomDestinationDefinitionUpdate.md)
 - [CustomSourceDefinitionCreate](docs/CustomSourceDefinitionCreate.md)
 - [CustomSourceDefinitionUpdate](docs/CustomSourceDefinitionUpdate.md)
 - [DataType](docs/DataType.md)
 - [DbMigrationExecutionRead](docs/DbMigrationExecutionRead.md)
 - [DbMigrationRead](docs/DbMigrationRead.md)
 - [DbMigrationReadList](docs/DbMigrationReadList.md)
 - [DbMigrationRequestBody](docs/DbMigrationRequestBody.md)
 - [DbMigrationState](docs/DbMigrationState.md)
 - [DestinationCoreConfig](docs/DestinationCoreConfig.md)
 - [DestinationCreate](docs/DestinationCreate.md)
 - [DestinationDefinitionCreate](docs/DestinationDefinitionCreate.md)
 - [DestinationDefinitionIdRequestBody](docs/DestinationDefinitionIdRequestBody.md)
 - [DestinationDefinitionIdWithWorkspaceId](docs/DestinationDefinitionIdWithWorkspaceId.md)
 - [DestinationDefinitionRead](docs/DestinationDefinitionRead.md)
 - [DestinationDefinitionReadList](docs/DestinationDefinitionReadList.md)
 - [DestinationDefinitionSpecificationRead](docs/DestinationDefinitionSpecificationRead.md)
 - [DestinationDefinitionUpdate](docs/DestinationDefinitionUpdate.md)
 - [DestinationIdRequestBody](docs/DestinationIdRequestBody.md)
 - [DestinationOauthConsentRequest](docs/DestinationOauthConsentRequest.md)
 - [DestinationRead](docs/DestinationRead.md)
 - [DestinationReadList](docs/DestinationReadList.md)
 - [DestinationSearch](docs/DestinationSearch.md)
 - [DestinationSyncMode](docs/DestinationSyncMode.md)
 - [DestinationUpdate](docs/DestinationUpdate.md)
 - [HealthCheckRead](docs/HealthCheckRead.md)
 - [ImportRead](docs/ImportRead.md)
 - [ImportRequestBody](docs/ImportRequestBody.md)
 - [InvalidInputExceptionInfo](docs/InvalidInputExceptionInfo.md)
 - [InvalidInputProperty](docs/InvalidInputProperty.md)
 - [JobConfigType](docs/JobConfigType.md)
 - [JobDebugInfoRead](docs/JobDebugInfoRead.md)
 - [JobDebugRead](docs/JobDebugRead.md)
 - [JobIdRequestBody](docs/JobIdRequestBody.md)
 - [JobInfoRead](docs/JobInfoRead.md)
 - [JobListRequestBody](docs/JobListRequestBody.md)
 - [JobRead](docs/JobRead.md)
 - [JobReadList](docs/JobReadList.md)
 - [JobStatus](docs/JobStatus.md)
 - [JobType](docs/JobType.md)
 - [JobTypeResourceLimit](docs/JobTypeResourceLimit.md)
 - [JobWithAttemptsRead](docs/JobWithAttemptsRead.md)
 - [KnownExceptionInfo](docs/KnownExceptionInfo.md)
 - [LogRead](docs/LogRead.md)
 - [LogType](docs/LogType.md)
 - [LogsRequestBody](docs/LogsRequestBody.md)
 - [NamespaceDefinitionType](docs/NamespaceDefinitionType.md)
 - [NotFoundKnownExceptionInfo](docs/NotFoundKnownExceptionInfo.md)
 - [Notification](docs/Notification.md)
 - [NotificationRead](docs/NotificationRead.md)
 - [NotificationType](docs/NotificationType.md)
 - [OAuth2Specification](docs/OAuth2Specification.md)
 - [OAuthConfigSpecification](docs/OAuthConfigSpecification.md)
 - [OAuthConsentRead](docs/OAuthConsentRead.md)
 - [OperationCreate](docs/OperationCreate.md)
 - [OperationIdRequestBody](docs/OperationIdRequestBody.md)
 - [OperationRead](docs/OperationRead.md)
 - [OperationReadList](docs/OperationReadList.md)
 - [OperationUpdate](docs/OperationUpdate.md)
 - [OperatorConfiguration](docs/OperatorConfiguration.md)
 - [OperatorDbt](docs/OperatorDbt.md)
 - [OperatorNormalization](docs/OperatorNormalization.md)
 - [OperatorType](docs/OperatorType.md)
 - [Pagination](docs/Pagination.md)
 - [PrivateDestinationDefinitionRead](docs/PrivateDestinationDefinitionRead.md)
 - [PrivateDestinationDefinitionReadList](docs/PrivateDestinationDefinitionReadList.md)
 - [PrivateSourceDefinitionRead](docs/PrivateSourceDefinitionRead.md)
 - [PrivateSourceDefinitionReadList](docs/PrivateSourceDefinitionReadList.md)
 - [ReleaseStage](docs/ReleaseStage.md)
 - [ResourceRequirements](docs/ResourceRequirements.md)
 - [SetInstancewideDestinationOauthParamsRequestBody](docs/SetInstancewideDestinationOauthParamsRequestBody.md)
 - [SetInstancewideSourceOauthParamsRequestBody](docs/SetInstancewideSourceOauthParamsRequestBody.md)
 - [SlackNotificationConfiguration](docs/SlackNotificationConfiguration.md)
 - [SlugRequestBody](docs/SlugRequestBody.md)
 - [SourceCoreConfig](docs/SourceCoreConfig.md)
 - [SourceCreate](docs/SourceCreate.md)
 - [SourceDefinitionCreate](docs/SourceDefinitionCreate.md)
 - [SourceDefinitionIdRequestBody](docs/SourceDefinitionIdRequestBody.md)
 - [SourceDefinitionIdWithWorkspaceId](docs/SourceDefinitionIdWithWorkspaceId.md)
 - [SourceDefinitionRead](docs/SourceDefinitionRead.md)
 - [SourceDefinitionReadList](docs/SourceDefinitionReadList.md)
 - [SourceDefinitionSpecificationRead](docs/SourceDefinitionSpecificationRead.md)
 - [SourceDefinitionUpdate](docs/SourceDefinitionUpdate.md)
 - [SourceDiscoverSchemaRead](docs/SourceDiscoverSchemaRead.md)
 - [SourceDiscoverSchemaRequestBody](docs/SourceDiscoverSchemaRequestBody.md)
 - [SourceIdRequestBody](docs/SourceIdRequestBody.md)
 - [SourceOauthConsentRequest](docs/SourceOauthConsentRequest.md)
 - [SourceRead](docs/SourceRead.md)
 - [SourceReadList](docs/SourceReadList.md)
 - [SourceSearch](docs/SourceSearch.md)
 - [SourceUpdate](docs/SourceUpdate.md)
 - [SyncMode](docs/SyncMode.md)
 - [SynchronousJobRead](docs/SynchronousJobRead.md)
 - [UploadRead](docs/UploadRead.md)
 - [WebBackendConnectionCreate](docs/WebBackendConnectionCreate.md)
 - [WebBackendConnectionRead](docs/WebBackendConnectionRead.md)
 - [WebBackendConnectionReadList](docs/WebBackendConnectionReadList.md)
 - [WebBackendConnectionRequestBody](docs/WebBackendConnectionRequestBody.md)
 - [WebBackendConnectionSearch](docs/WebBackendConnectionSearch.md)
 - [WebBackendConnectionUpdate](docs/WebBackendConnectionUpdate.md)
 - [WebBackendOperationCreateOrUpdate](docs/WebBackendOperationCreateOrUpdate.md)
 - [WebBackendWorkspaceState](docs/WebBackendWorkspaceState.md)
 - [WebBackendWorkspaceStateResult](docs/WebBackendWorkspaceStateResult.md)
 - [WorkspaceCreate](docs/WorkspaceCreate.md)
 - [WorkspaceGiveFeedback](docs/WorkspaceGiveFeedback.md)
 - [WorkspaceIdRequestBody](docs/WorkspaceIdRequestBody.md)
 - [WorkspaceRead](docs/WorkspaceRead.md)
 - [WorkspaceReadList](docs/WorkspaceReadList.md)
 - [WorkspaceUpdate](docs/WorkspaceUpdate.md)
 - [WorkspaceUpdateName](docs/WorkspaceUpdateName.md)


To get access to the crate's generated documentation, use:

```
cargo doc --open
```
