/*
 * Airbyte Configuration API
 *
 * Airbyte Configuration API [https://airbyte.io](https://airbyte.io).  This API is a collection of HTTP RPC-style methods. While it is not a REST API, those familiar with REST should find the conventions of this API recognizable.  Here are some conventions that this API follows: * All endpoints are http POST methods. * All endpoints accept data via `application/json` request bodies. The API does not accept any data via query params. * The naming convention for endpoints is: localhost:8000/{VERSION}/{METHOD_FAMILY}/{METHOD_NAME} e.g. `localhost:8000/v1/connections/create`. * For all `update` methods, the whole object must be passed in, even the fields that did not change.  Change Management: * The major version of the API endpoint can be determined / specified in the URL `localhost:8080/v1/connections/create` * Minor version bumps will be invisible to the end user. The user cannot specify minor versions in requests. * All backwards incompatible changes will happen in major version bumps. We will not make backwards incompatible changes in minor version bumps. Examples of non-breaking changes (includes but not limited to...):   * Adding fields to request or response bodies.   * Adding new HTTP endpoints.
 *
 * The version of the OpenAPI document: 1.0.0
 * Contact: contact@airbyte.io
 * Generated by: https://openapi-generator.tech
 */

/// AirbyteStream : the immutable schema defined by the source

#[derive(Clone, Debug, PartialEq, Default, Serialize, Deserialize)]
pub struct AirbyteStream {
    /// Stream's name.
    #[serde(rename = "name")]
    pub name: String,
    #[serde(rename = "jsonSchema", skip_serializing_if = "Option::is_none")]
    pub json_schema: Option<serde_json::Value>,
    #[serde(rename = "supportedSyncModes", skip_serializing_if = "Option::is_none")]
    pub supported_sync_modes: Option<Vec<crate::models::SyncMode>>,
    /// If the source defines the cursor field, then any other cursor field inputs will be ignored. If it does not, either the user_provided one is used, or the default one is used as a backup.
    #[serde(
        rename = "sourceDefinedCursor",
        skip_serializing_if = "Option::is_none"
    )]
    pub source_defined_cursor: Option<bool>,
    /// Path to the field that will be used to determine if a record is new or modified since the last sync. If not provided by the source, the end user will have to specify the comparable themselves.
    #[serde(rename = "defaultCursorField", skip_serializing_if = "Option::is_none")]
    pub default_cursor_field: Option<Vec<String>>,
    /// If the source defines the primary key, paths to the fields that will be used as a primary key. If not provided by the source, the end user will have to specify the primary key themselves.
    #[serde(
        rename = "sourceDefinedPrimaryKey",
        skip_serializing_if = "Option::is_none"
    )]
    pub source_defined_primary_key: Option<Vec<Vec<String>>>,
    /// Optional Source-defined namespace. Airbyte streams from the same sources should have the same namespace. Currently only used by JDBC destinations to determine what schema to write to.
    #[serde(rename = "namespace", skip_serializing_if = "Option::is_none")]
    pub namespace: Option<String>,
}

impl AirbyteStream {
    /// the immutable schema defined by the source
    pub fn new(name: String) -> AirbyteStream {
        AirbyteStream {
            name,
            json_schema: None,
            supported_sync_modes: None,
            source_defined_cursor: None,
            default_cursor_field: None,
            source_defined_primary_key: None,
            namespace: None,
        }
    }
}
